# Using Structs to Structure Related Data

A *struct*, or *structure*, is a custom data type that lets you package
together and name multiple related values that make up a meaningful group. If
you’re familiar with an object-oriented language, a *struct* is like an
object’s data attributes. In this chapter, we’ll compare and contrast tuples
with structs to build on what you already know and demonstrate when structs are
a better way to group data. We’ll demonstrate how to define and instantiate
structs. We’ll discuss how to define associated functions, especially the kind
of associated functions called *methods*, to specify behavior associated with a
struct type. Structs and enums (discussed in Chapter 6) are the building blocks
for creating new types in your program’s domain to take full advantage of
Rust’s compile time type checking.
