Static and const variables can refer to other const variables. But a const
variable cannot refer to a static variable.

Erroneous code example:

```compile_fail,E0013
static X: i32 = 42;
const Y: i32 = X;
```

In this example, `Y` cannot refer to `X`. To fix this, the value can be
extracted as a const and then used:

```
const A: i32 = 42;
static X: i32 = A;
const Y: i32 = A;
```
