# Contributing to Win32

Contributions are very much appreciated. With thousands of Win32 APIs, there's a
lot of ground to cover :)

Please ensure you've signed the Contributors License Agreement here:
<https://cla.developers.google.com/about>.

Don't hesitate to ask questions -- I'm just honored that you're thinking of
contributing!

Some tips:

## Classic Win32 APIs

- When wrapping a Win32 API, use the Unicode ('W') wide variants of these APIs,
  rather than the ANSI ('A') variants. For example:
  [CredWriteW](https://docs.microsoft.com/en-us/windows/win32/api/wincred/nf-wincred-credwritew),
  rather than
  [CredWriteA](https://docs.microsoft.com/en-us/windows/win32/api/wincred/nf-wincred-credwritea).

- To create a new API, *don't* edit the main library files themselves; these get
  overwritten. Instead, edit `tool\inputs\functions.json` and run
  `tool\generate.cmd` to update the library files. This might seem a pain, but
  it gives protection against any changes to dart:ffi, since the typedef syntax
  can be easily recreated as necessary.

- Structs can be auto-generated by adding them to `tool\inputs\structs.dart`,
  which generates `lib\src\structs.g.dart`. If for some reason, you need to
  manually generate a struct, you can add it to `lib\src\structs.dart`. There
  should be almost no scenarios where this is necessary. If you come across one,
  please file an issue so we can address it.

- Constants belong in `constants.dart`; please add documentation. In rare cases
  (where the constant is truly self-documenting), you may add to
  `constants_nodoc.dart`, although the goal is to gradually document more
  constants.

- There are plenty of good existing patterns to build off in these locations;
  try to mirror an existing function if you can for consistency!

- Ideally pull requests for new API submissions include a sample (`example\`
  directory) and some tests (`tests\` directory).

## COM APIs

- Edit `inputs\interfaces.dart` with the COM interface to be generated.

Now run `generate.cmd` from the `tools\` directory, which should create the
relevant class in the `\lib\src\com` directory.

## Windows Runtime APIs

- This area is a work in progress and the interface generation should be viewed
  as experimental.
