; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

define <vscale x 1 x double> @vfwsub_vv_nxv1f64(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) {
; CHECK-LABEL: vfwsub_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfwsub.vv v10, v8, v9
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
  %vc = fpext <vscale x 1 x float> %va to <vscale x 1 x double>
  %vd = fpext <vscale x 1 x float> %vb to <vscale x 1 x double>
  %ve = fsub <vscale x 1 x double> %vc, %vd
  ret <vscale x 1 x double> %ve
}

define <vscale x 1 x double> @vfwsub_vf_nxv1f64(<vscale x 1 x float> %va, float %b) {
; CHECK-LABEL: vfwsub_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfwsub.vf v9, v8, fa0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %vc = fpext <vscale x 1 x float> %va to <vscale x 1 x double>
  %vd = fpext <vscale x 1 x float> %splat to <vscale x 1 x double>
  %ve = fsub <vscale x 1 x double> %vc, %vd
  ret <vscale x 1 x double> %ve
}

define <vscale x 1 x double> @vfwsub_wv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x float> %vb) {
; CHECK-LABEL: vfwsub_wv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfwsub.wv v10, v8, v9
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
  %vc = fpext <vscale x 1 x float> %vb to <vscale x 1 x double>
  %vd = fsub <vscale x 1 x double> %va, %vc
  ret <vscale x 1 x double> %vd
}

define <vscale x 1 x double> @vfwsub_wf_nxv1f64(<vscale x 1 x double> %va, float %b) {
; CHECK-LABEL: vfwsub_wf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfwsub.wf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %vc = fpext <vscale x 1 x float> %splat to <vscale x 1 x double>
  %vd = fsub <vscale x 1 x double> %va, %vc
  ret <vscale x 1 x double> %vd
}

define <vscale x 2 x double> @vfwsub_vv_nxv2f64(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) {
; CHECK-LABEL: vfwsub_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfwsub.vv v10, v8, v9
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %vc = fpext <vscale x 2 x float> %va to <vscale x 2 x double>
  %vd = fpext <vscale x 2 x float> %vb to <vscale x 2 x double>
  %ve = fsub <vscale x 2 x double> %vc, %vd
  ret <vscale x 2 x double> %ve
}

define <vscale x 2 x double> @vfwsub_vf_nxv2f64(<vscale x 2 x float> %va, float %b) {
; CHECK-LABEL: vfwsub_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfwsub.vf v10, v8, fa0
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %vc = fpext <vscale x 2 x float> %va to <vscale x 2 x double>
  %vd = fpext <vscale x 2 x float> %splat to <vscale x 2 x double>
  %ve = fsub <vscale x 2 x double> %vc, %vd
  ret <vscale x 2 x double> %ve
}

define <vscale x 2 x double> @vfwsub_wv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x float> %vb) {
; CHECK-LABEL: vfwsub_wv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfwsub.wv v12, v8, v10
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
  %vc = fpext <vscale x 2 x float> %vb to <vscale x 2 x double>
  %vd = fsub <vscale x 2 x double> %va, %vc
  ret <vscale x 2 x double> %vd
}

define <vscale x 2 x double> @vfwsub_wf_nxv2f64(<vscale x 2 x double> %va, float %b) {
; CHECK-LABEL: vfwsub_wf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfwsub.wf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %vc = fpext <vscale x 2 x float> %splat to <vscale x 2 x double>
  %vd = fsub <vscale x 2 x double> %va, %vc
  ret <vscale x 2 x double> %vd
}

define <vscale x 4 x double> @vfwsub_vv_nxv4f64(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) {
; CHECK-LABEL: vfwsub_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfwsub.vv v12, v8, v10
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %vc = fpext <vscale x 4 x float> %va to <vscale x 4 x double>
  %vd = fpext <vscale x 4 x float> %vb to <vscale x 4 x double>
  %ve = fsub <vscale x 4 x double> %vc, %vd
  ret <vscale x 4 x double> %ve
}

define <vscale x 4 x double> @vfwsub_vf_nxv4f64(<vscale x 4 x float> %va, float %b) {
; CHECK-LABEL: vfwsub_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfwsub.vf v12, v8, fa0
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %vc = fpext <vscale x 4 x float> %va to <vscale x 4 x double>
  %vd = fpext <vscale x 4 x float> %splat to <vscale x 4 x double>
  %ve = fsub <vscale x 4 x double> %vc, %vd
  ret <vscale x 4 x double> %ve
}

define <vscale x 4 x double> @vfwsub_wv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x float> %vb) {
; CHECK-LABEL: vfwsub_wv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfwsub.wv v16, v8, v12
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
  %vc = fpext <vscale x 4 x float> %vb to <vscale x 4 x double>
  %vd = fsub <vscale x 4 x double> %va, %vc
  ret <vscale x 4 x double> %vd
}

define <vscale x 4 x double> @vfwsub_wf_nxv4f64(<vscale x 4 x double> %va, float %b) {
; CHECK-LABEL: vfwsub_wf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfwsub.wf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %vc = fpext <vscale x 4 x float> %splat to <vscale x 4 x double>
  %vd = fsub <vscale x 4 x double> %va, %vc
  ret <vscale x 4 x double> %vd
}

define <vscale x 8 x double> @vfwsub_vv_nxv8f64(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: vfwsub_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfwsub.vv v16, v8, v12
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %vc = fpext <vscale x 8 x float> %va to <vscale x 8 x double>
  %vd = fpext <vscale x 8 x float> %vb to <vscale x 8 x double>
  %ve = fsub <vscale x 8 x double> %vc, %vd
  ret <vscale x 8 x double> %ve
}

define <vscale x 8 x double> @vfwsub_vf_nxv8f64(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: vfwsub_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfwsub.vf v16, v8, fa0
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fpext <vscale x 8 x float> %va to <vscale x 8 x double>
  %vd = fpext <vscale x 8 x float> %splat to <vscale x 8 x double>
  %ve = fsub <vscale x 8 x double> %vc, %vd
  ret <vscale x 8 x double> %ve
}

define <vscale x 8 x double> @vfwsub_wv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: vfwsub_wv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfwsub.wv v24, v8, v16
; CHECK-NEXT:    vmv8r.v v8, v24
; CHECK-NEXT:    ret
  %vc = fpext <vscale x 8 x float> %vb to <vscale x 8 x double>
  %vd = fsub <vscale x 8 x double> %va, %vc
  ret <vscale x 8 x double> %vd
}

define <vscale x 8 x double> @vfwsub_wf_nxv8f64(<vscale x 8 x double> %va, float %b) {
; CHECK-LABEL: vfwsub_wf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfwsub.wf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fpext <vscale x 8 x float> %splat to <vscale x 8 x double>
  %vd = fsub <vscale x 8 x double> %va, %vc
  ret <vscale x 8 x double> %vd
}
