.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XSetErrorHandler __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetErrorHandler, XGetErrorText, XDisplayName, XSetIOErrorHandler, XSetIOErrorExitHandler, XGetErrorDatabaseText \- default error handlers
.SH SYNTAX
.HP
int (*XSetErrorHandler\^(\^int (\^*\^\fIhandler\fP\^)\^(Display *, XErrorEvent
*)\^)\^)\^(\^);
.HP
int XGetErrorText\^(\^Display *\fIdisplay\fP\^, int \fIcode\fP\^, char
*\fIbuffer_return\fP\^, int \fIlength\fP\^);
.HP
char *XDisplayName\^(\^_Xconst char *\fIstring\fP\^);
.HP
int (*XSetIOErrorHandler\^(\^int (\^*\^\fIhandler\fP\^)(Display
*)\^)\^)\^(\^);
.HP
void (*XSetIOErrorExitHandler\^(Display
*\fIdisplay\fP\^, void (\^*\^\fIhandler\fP\^)(Display *, void
*)\^, void *\fIuser_data\fP)\^)\^(\^);
.HP
int XGetErrorDatabaseText\^(\^Display *\fIdisplay\fP\^, _Xconst char *\fIname\fP, _Xconst char
*\fImessage\fP\^, _Xconst char *\fIdefault_string\fP\^, char *\fIbuffer_return\fP\^,
int \fIlength\fP\^);
.SH ARGUMENTS
.IP \fIbuffer_return\fP 1i
Returns the error description.
.IP \fIcode\fP 1i
Specifies the error code for which you want to obtain a description.
.IP \fIdefault_string\fP 1i
Specifies the default error message if none is found in the database.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIhandler\fP 1i
Specifies the program's supplied error handler.
.IP \fIlength\fP 1i
Specifies the size of the buffer.
.IP \fImessage\fP 1i
Specifies the type of the error message.
.IP \fIname\fP 1i
Specifies the name of the application.
.IP \fIstring\fP 1i
Specifies the character string.
.SH DESCRIPTION
Xlib generally calls the program's
supplied error handler whenever an error is received.
It is not called on
.B BadName
errors from
.BR OpenFont ,
.BR LookupColor ,
or
.B AllocNamedColor
protocol requests or on
.B BadFont
errors from a
.B QueryFont
protocol request.
These errors generally are reflected back to the program through the
procedural interface.
Because this condition is not assumed to be fatal,
it is acceptable for your error handler to return;
the returned value is ignored.
However, the error handler should not
call any functions (directly or indirectly) on the display
that will generate protocol requests or that will look for input events.
The previous error handler is returned.
.LP
The
.B XGetErrorText
function copies a null-terminated string describing the specified error code
into the specified buffer.
The returned text is in the encoding of the current locale.
It is recommended that you use this function to obtain an error description
because extensions to Xlib may define their own error codes
and error strings.
.LP
The
.B XDisplayName
function returns the name of the display that
.B XOpenDisplay
would attempt to use.
If a NULL string is specified,
.B XDisplayName
looks in the environment for the display and returns the display name that
.B XOpenDisplay
would attempt to use.
This makes it easier to report to the user precisely which display the
program attempted to open when the initial connection attempt failed.
.LP
The
.B XSetIOErrorHandler
sets the fatal I/O error handler.
Xlib calls the program's supplied error handler if any sort of system call
error occurs (for example, the connection to the server was lost).
This is assumed to be a fatal condition,
and the called routine should normally not return.
If the I/O error handler does return,
the client process exits by default, this behavior may be altered with the
.BR XSetIOErrorExitHandler
function.
.LP
Note that the previous error handler is returned.
.LP
The
.B XGetErrorDatabaseText
function returns a null-terminated message
(or the default message) from the error message
database.
Xlib uses this function internally to look up its error messages.
The text in the default_string argument is assumed
to be in the encoding of the current locale,
and the text stored in the buffer_return argument
is in the encoding of the current locale.
.LP
The name argument should generally be the name of your application.
The message argument should indicate which type of error message you want.
If the name and message are not in the Host Portable Character Encoding,
the result is implementation-dependent.
Xlib uses three predefined \*(lqapplication names\*(rq to report errors.
In these names,
uppercase and lowercase matter.
.IP XProtoError 1i
The protocol error number is used as a string for the message argument.
.IP XlibMessage 1i
These are the message strings that are used internally by the library.
.IP XRequest 1i
For a core protocol request,
the major request protocol number is used for the message argument.
For an extension request,
the extension name (as given by
.BR InitExtension )
followed by a period (\.) and the minor request protocol number
is used for the message argument.
If no string is found in the error database,
the default_string is returned to the buffer argument.
.SH "SEE ALSO"
XOpenDisplay(__libmansuffix__),
XSynchronize(__libmansuffix__)
.br
\fI\*(xL\fP
