#ifndef BABELTRACE_GRAPH_COMPONENT_SINK_INTERNAL_H
#define BABELTRACE_GRAPH_COMPONENT_SINK_INTERNAL_H

/*
 * Copyright 2017-2018 Philippe Proulx <pproulx@efficios.com>
 * Copyright 2015 Jérémie Galarneau <jeremie.galarneau@efficios.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include <stdbool.h>

#include "common/macros.h"
#include "compat/compiler.h"
#include <babeltrace2/graph/component.h>

#include "component-class.h"
#include "component.h"

struct bt_component_sink {
	struct bt_component parent;
	bool graph_is_configured_method_called;
};

BT_HIDDEN
struct bt_component *bt_component_sink_create(
		const struct bt_component_class *class);

BT_HIDDEN
void bt_component_sink_destroy(struct bt_component *component);

#endif /* BABELTRACE_GRAPH_COMPONENT_SINK_INTERNAL_H */
