; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512fp16 -mattr=+avx512vl -O3 | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512fp16 -mattr=+avx512vl -O3 | FileCheck %s --check-prefixes=X64

declare half @llvm.experimental.constrained.sitofp.f16.i1(i1, metadata, metadata)
declare half @llvm.experimental.constrained.sitofp.f16.i8(i8, metadata, metadata)
declare half @llvm.experimental.constrained.sitofp.f16.i16(i16, metadata, metadata)
declare half @llvm.experimental.constrained.sitofp.f16.i32(i32, metadata, metadata)
declare half @llvm.experimental.constrained.sitofp.f16.i64(i64, metadata, metadata)
declare half @llvm.experimental.constrained.uitofp.f16.i1(i1, metadata, metadata)
declare half @llvm.experimental.constrained.uitofp.f16.i8(i8, metadata, metadata)
declare half @llvm.experimental.constrained.uitofp.f16.i16(i16, metadata, metadata)
declare half @llvm.experimental.constrained.uitofp.f16.i32(i32, metadata, metadata)
declare half @llvm.experimental.constrained.uitofp.f16.i64(i64, metadata, metadata)

define half @sitofp_i1tof16(i1 %x) #0 {
; X86-LABEL: sitofp_i1tof16:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    andb $1, %al
; X86-NEXT:    negb %al
; X86-NEXT:    movsbl %al, %eax
; X86-NEXT:    vcvtsi2sh %eax, %xmm0, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: sitofp_i1tof16:
; X64:       # %bb.0:
; X64-NEXT:    andb $1, %dil
; X64-NEXT:    negb %dil
; X64-NEXT:    movsbl %dil, %eax
; X64-NEXT:    vcvtsi2sh %eax, %xmm0, %xmm0
; X64-NEXT:    retq
  %result = call half @llvm.experimental.constrained.sitofp.f16.i1(i1 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret half %result
}

define half @sitofp_i8tof16(i8 %x) #0 {
; X86-LABEL: sitofp_i8tof16:
; X86:       # %bb.0:
; X86-NEXT:    movsbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vcvtsi2sh %eax, %xmm0, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: sitofp_i8tof16:
; X64:       # %bb.0:
; X64-NEXT:    movsbl %dil, %eax
; X64-NEXT:    vcvtsi2sh %eax, %xmm0, %xmm0
; X64-NEXT:    retq
  %result = call half @llvm.experimental.constrained.sitofp.f16.i8(i8 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret half %result
}

define half @sitofp_i16tof16(i16 %x) #0 {
; X86-LABEL: sitofp_i16tof16:
; X86:       # %bb.0:
; X86-NEXT:    movswl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vcvtsi2sh %eax, %xmm0, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: sitofp_i16tof16:
; X64:       # %bb.0:
; X64-NEXT:    movswl %di, %eax
; X64-NEXT:    vcvtsi2sh %eax, %xmm0, %xmm0
; X64-NEXT:    retq
  %result = call half @llvm.experimental.constrained.sitofp.f16.i16(i16 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret half %result
}

define half @sitofp_i32tof16(i32 %x) #0 {
; X86-LABEL: sitofp_i32tof16:
; X86:       # %bb.0:
; X86-NEXT:    vcvtsi2shl {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: sitofp_i32tof16:
; X64:       # %bb.0:
; X64-NEXT:    vcvtsi2sh %edi, %xmm0, %xmm0
; X64-NEXT:    retq
  %result = call half @llvm.experimental.constrained.sitofp.f16.i32(i32 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret half %result
}

define half @sitofp_i64tof16(i64 %x) #0 {
; X86-LABEL: sitofp_i64tof16:
; X86:       # %bb.0:
; X86-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    vcvtqq2ph %xmm0, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: sitofp_i64tof16:
; X64:       # %bb.0:
; X64-NEXT:    vcvtsi2sh %rdi, %xmm0, %xmm0
; X64-NEXT:    retq
  %result = call half @llvm.experimental.constrained.sitofp.f16.i64(i64 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret half %result
}

define half @uitofp_i1tof16(i1 %x) #0 {
; X86-LABEL: uitofp_i1tof16:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    andb $1, %al
; X86-NEXT:    movzbl %al, %eax
; X86-NEXT:    vcvtsi2sh %eax, %xmm0, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: uitofp_i1tof16:
; X64:       # %bb.0:
; X64-NEXT:    andl $1, %edi
; X64-NEXT:    vcvtsi2sh %edi, %xmm0, %xmm0
; X64-NEXT:    retq
  %result = call half @llvm.experimental.constrained.uitofp.f16.i1(i1 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret half %result
}

define half @uitofp_i8tof16(i8 %x) #0 {
; X86-LABEL: uitofp_i8tof16:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vcvtsi2sh %eax, %xmm0, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: uitofp_i8tof16:
; X64:       # %bb.0:
; X64-NEXT:    movzbl %dil, %eax
; X64-NEXT:    vcvtsi2sh %eax, %xmm0, %xmm0
; X64-NEXT:    retq
  %result = call half @llvm.experimental.constrained.uitofp.f16.i8(i8 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret half %result
}

define half @uitofp_i16tof16(i16 %x) #0 {
; X86-LABEL: uitofp_i16tof16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vcvtsi2sh %eax, %xmm0, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: uitofp_i16tof16:
; X64:       # %bb.0:
; X64-NEXT:    movzwl %di, %eax
; X64-NEXT:    vcvtsi2sh %eax, %xmm0, %xmm0
; X64-NEXT:    retq
  %result = call half @llvm.experimental.constrained.uitofp.f16.i16(i16 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret half %result
}

define half @uitofp_i32tof16(i32 %x) #0 {
; X86-LABEL: uitofp_i32tof16:
; X86:       # %bb.0:
; X86-NEXT:    vcvtusi2shl {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: uitofp_i32tof16:
; X64:       # %bb.0:
; X64-NEXT:    vcvtusi2sh %edi, %xmm0, %xmm0
; X64-NEXT:    retq
  %result = call half @llvm.experimental.constrained.uitofp.f16.i32(i32 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret half %result
}

define half @uitofp_i64tof16(i64 %x) #0 {
; X86-LABEL: uitofp_i64tof16:
; X86:       # %bb.0:
; X86-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    vcvtuqq2ph %xmm0, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: uitofp_i64tof16:
; X64:       # %bb.0:
; X64-NEXT:    vcvtusi2sh %rdi, %xmm0, %xmm0
; X64-NEXT:    retq
  %result = call half @llvm.experimental.constrained.uitofp.f16.i64(i64 %x,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret half %result
}

attributes #0 = { strictfp }
