'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetDeviceInfoChanges __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetDeviceInfoChanges \- Query the changes that have occurred in the button 
actions or indicator names and indicator maps associated with an input extension 
device
.SH SYNOPSIS
.HP
.B Status XkbGetDeviceInfoChanges
.BI "(\^Display *" "dpy" "\^,"
.BI "XkbDeviceInfoPtr " "device_info" "\^,"
.BI "XkbDeviceChangesPtr " "changes" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to X server
.TP
.I \- device_info
structure to update with results
.TP
.I \- changes
contains notes of changes that have occurred
.SH DESCRIPTION
.LP
The 
.I changes->changed 
field indicates which attributes of the device specified in 
.I changes->device 
have changed. The parameters describing the changes are contained in the other 
fields of 
.I changes. XkbGetDeviceInfoChanges 
uses that information to call 
.I XkbGetDeviceInfo 
to obtain the current status of those attributes that have changed. It then 
updates the local description of the device in 
.I device_info 
with the new information.
.SH "SEE ALSO"
.BR XkbGetDeviceInfo (__libmansuffix__)
