// Copyright (c) 2008-2022 LG Electronics, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

#include "web_app_wayland_agl.h"

#include "application_description.h"

WebAppWaylandAGL::WebAppWaylandAGL(const std::string& win_type,
                                   std::shared_ptr<ApplicationDescription> desc)
    : WebAppWayland(win_type,
                    desc->WidthOverride(),
                    desc->HeightOverride(),
                    kUndefinedDisplayId,
                    "",
                    desc->SurfaceType(),
                    desc->PanelType()) {}
