/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.common;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import java.nio.ByteBuffer;

public interface BinaryMessenger {
    @UiThread
    default public TaskQueue makeBackgroundTaskQueue() {
        return this.makeBackgroundTaskQueue(new TaskQueueOptions());
    }

    @UiThread
    default public TaskQueue makeBackgroundTaskQueue(TaskQueueOptions options) {
        throw new UnsupportedOperationException("makeBackgroundTaskQueue not implemented.");
    }

    @UiThread
    public void send(@NonNull String var1, @Nullable ByteBuffer var2);

    @UiThread
    public void send(@NonNull String var1, @Nullable ByteBuffer var2, @Nullable BinaryReply var3);

    @UiThread
    public void setMessageHandler(@NonNull String var1, @Nullable BinaryMessageHandler var2);

    @UiThread
    default public void setMessageHandler(@NonNull String channel, @Nullable BinaryMessageHandler handler, @Nullable TaskQueue taskQueue) {
        if (taskQueue != null) {
            throw new UnsupportedOperationException("setMessageHandler called with nonnull taskQueue is not supported.");
        }
        this.setMessageHandler(channel, handler);
    }

    default public void enableBufferingIncomingMessages() {
        throw new UnsupportedOperationException("enableBufferingIncomingMessages not implemented.");
    }

    default public void disableBufferingIncomingMessages() {
        throw new UnsupportedOperationException("disableBufferingIncomingMessages not implemented.");
    }

    public static interface BinaryReply {
        public void reply(@Nullable ByteBuffer var1);
    }

    public static interface BinaryMessageHandler {
        @UiThread
        public void onMessage(@Nullable ByteBuffer var1, @NonNull BinaryReply var2);
    }

    public static class TaskQueueOptions {
        private boolean isSerial = true;

        public boolean getIsSerial() {
            return this.isSerial;
        }

        public TaskQueueOptions setIsSerial(boolean isSerial) {
            this.isSerial = isSerial;
            return this;
        }
    }

    public static interface TaskQueue {
    }
}

