// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gst.Rtp {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	[StructLayout(LayoutKind.Sequential)]
	public partial struct RTPPayloadInfo : IEquatable<RTPPayloadInfo> {

		public byte PayloadType;
		public string Media;
		public string EncodingName;
		public uint ClockRate;
		public string EncodingParameters;
		public uint Bitrate;
		[MarshalAs (UnmanagedType.ByValArray, SizeConst=4)]
		private IntPtr[] _gstGstReserved;

		public static Gst.Rtp.RTPPayloadInfo Zero = new Gst.Rtp.RTPPayloadInfo ();

		public static Gst.Rtp.RTPPayloadInfo New(IntPtr raw) {
			if (raw == IntPtr.Zero)
				return Gst.Rtp.RTPPayloadInfo.Zero;
			return (Gst.Rtp.RTPPayloadInfo) Marshal.PtrToStructure (raw, typeof (Gst.Rtp.RTPPayloadInfo));
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_rtp_payload_info_for_name(IntPtr media, IntPtr encoding_name);

		public static Gst.Rtp.RTPPayloadInfo ForName(string media, string encoding_name) {
			IntPtr native_media = GLib.Marshaller.StringToPtrGStrdup (media);
			IntPtr native_encoding_name = GLib.Marshaller.StringToPtrGStrdup (encoding_name);
			IntPtr raw_ret = gst_rtp_payload_info_for_name(native_media, native_encoding_name);
			Gst.Rtp.RTPPayloadInfo ret = Gst.Rtp.RTPPayloadInfo.New (raw_ret);
			GLib.Marshaller.Free (native_media);
			GLib.Marshaller.Free (native_encoding_name);
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_rtp_payload_info_for_pt(byte payload_type);

		public static Gst.Rtp.RTPPayloadInfo ForPt(byte payload_type) {
			IntPtr raw_ret = gst_rtp_payload_info_for_pt(payload_type);
			Gst.Rtp.RTPPayloadInfo ret = Gst.Rtp.RTPPayloadInfo.New (raw_ret);
			return ret;
		}

		public bool Equals (RTPPayloadInfo other)
		{
			return true && PayloadType.Equals (other.PayloadType) && Media.Equals (other.Media) && EncodingName.Equals (other.EncodingName) && ClockRate.Equals (other.ClockRate) && EncodingParameters.Equals (other.EncodingParameters) && Bitrate.Equals (other.Bitrate);
		}

		public override bool Equals (object other)
		{
			return other is RTPPayloadInfo && Equals ((RTPPayloadInfo) other);
		}

		public override int GetHashCode ()
		{
			return this.GetType ().FullName.GetHashCode () ^ PayloadType.GetHashCode () ^ Media.GetHashCode () ^ EncodingName.GetHashCode () ^ ClockRate.GetHashCode () ^ EncodingParameters.GetHashCode () ^ Bitrate.GetHashCode ();
		}

		private static GLib.GType GType {
			get { return GLib.GType.Pointer; }
		}
#endregion
	}
}
