/* SPDX-License-Identifier: GPL-2.0 */
/*
 * VXD DEC SYSDEV and UI Interface header
 *
 * Copyright (c) Imagination Technologies Ltd.
 * Copyright (c) 2021 Texas Instruments Incorporated - http://www.ti.com/
 *
 * Authors:
 *	Amit Makani <amit.makani@ti.com>
 */

#ifndef __IMG_PIXFMTS_H__
#define __IMG_PIXFMTS_H__
/*
 * @brief Old pixel format definition
 *
 * @note These definitions are different in HW documentation(current to HW doc):
 * @li PL8 is defined as PL111
 * @li PL12 is sometime used wrongly for monochrome formats instead of PL_Y
 */
enum img_pixfmt {
	IMG_PIXFMT_CLUT1              =   0,
	IMG_PIXFMT_CLUT2              =   1,
	IMG_PIXFMT_CLUT4              =   2,
	IMG_PIXFMT_I4A4               =   3,
	IMG_PIXFMT_I8A8               =   4,
	IMG_PIXFMT_A8I8               =   51,
	IMG_PIXFMT_RGB8               =   5,
	IMG_PIXFMT_RGB332             =   6,
	IMG_PIXFMT_RGB555             =   7,
	IMG_PIXFMT_ARGB4444           =   8,
	IMG_PIXFMT_ABGR4444           =   57,
	IMG_PIXFMT_RGBA4444           =   58,
	IMG_PIXFMT_BGRA4444           =   59,
	IMG_PIXFMT_ARGB1555           =   9,
	IMG_PIXFMT_ABGR1555           =   60,
	IMG_PIXFMT_RGBA5551           =   61,
	IMG_PIXFMT_BGRA5551           =   62,
	IMG_PIXFMT_RGB565             =   10,
	IMG_PIXFMT_BGR565             =   63,
	IMG_PIXFMT_RGB888             =   11,
	IMG_PIXFMT_RSGSBS888          =   68,
	IMG_PIXFMT_ARGB8888           =   12,
	IMG_PIXFMT_ABGR8888           =   41,
	IMG_PIXFMT_BGRA8888           =   42,
	IMG_PIXFMT_RGBA8888           =   56,
	IMG_PIXFMT_ARGB8332           =   43,
	IMG_PIXFMT_ARGB8161616        =   64,
	IMG_PIXFMT_ARGB2101010        =   67,
	IMG_PIXFMT_UYVY8888           =   13,
	IMG_PIXFMT_VYUY8888           =   14,
	IMG_PIXFMT_YVYU8888           =   15,
	IMG_PIXFMT_YUYV8888           =   16,
	IMG_PIXFMT_UYVY10101010       =   17,
	IMG_PIXFMT_VYAUYA8888         =   18,
	IMG_PIXFMT_YUV101010          =   19,
	IMG_PIXFMT_AYUV4444           =   20,
	IMG_PIXFMT_YUV888             =   21,
	IMG_PIXFMT_AYUV8888           =   22,
	IMG_PIXFMT_AYUV2101010        =   23,
	IMG_PIXFMT_411PL111YUV8       =   120,
	IMG_PIXFMT_411PL12YUV8        =   121,
	IMG_PIXFMT_411PL12YVU8        =   24,
	IMG_PIXFMT_420PL12YUV8        =   25,
	IMG_PIXFMT_420PL12YVU8        =   26,
	IMG_PIXFMT_422PL12YUV8        =   27,
	IMG_PIXFMT_422PL12YVU8        =   28,
	IMG_PIXFMT_420PL8YUV8         =   47,
	IMG_PIXFMT_422PL8YUV8         =   48,
	IMG_PIXFMT_420PL12YUV8_A8     = 31,
	IMG_PIXFMT_422PL12YUV8_A8     = 32,
	IMG_PIXFMT_PL12Y8             =   33,
	IMG_PIXFMT_PL12YV8            =   35,
	IMG_PIXFMT_PL12IMC2           =   36,
	IMG_PIXFMT_A4                 =   37,
	IMG_PIXFMT_A8                 =   38,
	IMG_PIXFMT_YUV8               =   39,
	IMG_PIXFMT_CVBS10             =   40,
	IMG_PIXFMT_PL12YV12           =   44,
#if ((!defined(METAG) && !defined(MTXG)) || defined(__linux__))
	IMG_PIXFMT_F16                = 52,
	IMG_PIXFMT_F32                = 53,
	IMG_PIXFMT_F16F16F16F16       = 65,
#endif
	IMG_PIXFMT_L16                = 54,
	IMG_PIXFMT_L32                = 55,
	IMG_PIXFMT_Y1                 = 66,
	IMG_PIXFMT_444PL111YUV8       = 69,
	IMG_PIXFMT_444PL12YUV8        = 137,
	IMG_PIXFMT_444PL12YVU8        = 138,
	IMG_PIXFMT_PL12Y10            =   34,
	IMG_PIXFMT_PL12Y10_LSB        =  96,
	IMG_PIXFMT_PL12Y10_MSB        =  97,
	IMG_PIXFMT_420PL8YUV10        =   49,
	IMG_PIXFMT_420PL111YUV10_LSB  = 71,
	IMG_PIXFMT_420PL111YUV10_MSB  = 72,
	IMG_PIXFMT_420PL12YUV10       = 29,
	IMG_PIXFMT_420PL12YUV10_LSB   = 74,
	IMG_PIXFMT_420PL12YUV10_MSB   = 75,
	IMG_PIXFMT_420PL12YVU10       = 45,
	IMG_PIXFMT_420PL12YVU10_LSB   = 77,
	IMG_PIXFMT_420PL12YVU10_MSB   = 78,
	IMG_PIXFMT_422PL8YUV10        =   50,
	IMG_PIXFMT_422PL111YUV10_LSB  = 122,
	IMG_PIXFMT_422PL111YUV10_MSB  = 123,
	IMG_PIXFMT_422PL12YUV10       = 30,
	IMG_PIXFMT_422PL12YUV10_LSB   = 80,
	IMG_PIXFMT_422PL12YUV10_MSB   = 81,
	IMG_PIXFMT_422PL12YVU10       = 46,
	IMG_PIXFMT_422PL12YVU10_LSB   = 83,
	IMG_PIXFMT_422PL12YVU10_MSB   = 84,
	IMG_PIXFMT_444PL111YUV10      = 85,
	IMG_PIXFMT_444PL111YUV10_LSB  = 86,
	IMG_PIXFMT_444PL111YUV10_MSB  = 87,
	IMG_PIXFMT_444PL12YUV10       = 139,
	IMG_PIXFMT_444PL12YUV10_LSB   = 141,
	IMG_PIXFMT_444PL12YUV10_MSB   = 142,
	IMG_PIXFMT_444PL12YVU10       = 140,
	IMG_PIXFMT_444PL12YVU10_LSB   = 143,
	IMG_PIXFMT_444PL12YVU10_MSB   = 144,
	IMG_PIXFMT_420PL12Y8UV10      = 88,
	IMG_PIXFMT_420PL12Y8UV10_LSB  = 98,
	IMG_PIXFMT_420PL12Y8UV10_MSB  = 99,
	IMG_PIXFMT_420PL12Y8VU10      = 89,
	IMG_PIXFMT_420PL12Y8VU10_LSB  = 100,
	IMG_PIXFMT_420PL12Y8VU10_MSB  = 101,
	IMG_PIXFMT_420PL111Y8UV10     = 70,
	IMG_PIXFMT_420PL111Y8UV10_LSB = 127,
	IMG_PIXFMT_420PL111Y8UV10_MSB = 125,
	IMG_PIXFMT_422PL12Y8UV10      = 90,
	IMG_PIXFMT_422PL12Y8UV10_LSB  = 102,
	IMG_PIXFMT_422PL12Y8UV10_MSB  = 103,
	IMG_PIXFMT_422PL12Y8VU10      = 91,
	IMG_PIXFMT_422PL12Y8VU10_LSB  = 104,
	IMG_PIXFMT_422PL12Y8VU10_MSB  = 105,
	IMG_PIXFMT_444PL12Y8UV10      = 151,
	IMG_PIXFMT_444PL12Y8UV10_LSB  = 153,
	IMG_PIXFMT_444PL12Y8UV10_MSB  = 154,
	IMG_PIXFMT_444PL12Y8VU10      = 152,
	IMG_PIXFMT_444PL12Y8VU10_LSB  = 155,
	IMG_PIXFMT_444PL12Y8VU10_MSB  = 156,
	IMG_PIXFMT_420PL12Y10UV8      = 92,
	IMG_PIXFMT_420PL12Y10UV8_LSB  = 106,
	IMG_PIXFMT_420PL12Y10UV8_MSB  = 107,

	IMG_PIXFMT_420PL12Y10VU8      = 93,
	IMG_PIXFMT_420PL12Y10VU8_LSB  = 108,
	IMG_PIXFMT_420PL12Y10VU8_MSB  = 109,

	IMG_PIXFMT_420PL111Y10UV8     = 129,
	IMG_PIXFMT_420PL111Y10UV8_LSB = 133,
	IMG_PIXFMT_420PL111Y10UV8_MSB = 131,
	IMG_PIXFMT_422PL12Y10UV8      = 94,
	IMG_PIXFMT_422PL12Y10UV8_LSB  = 110,
	IMG_PIXFMT_422PL12Y10UV8_MSB  = 111,
	IMG_PIXFMT_422PL12Y10VU8      = 95,
	IMG_PIXFMT_422PL12Y10VU8_LSB  = 112,
	IMG_PIXFMT_422PL12Y10VU8_MSB  = 113,

	IMG_PIXFMT_444PL111Y10UV8     = 114,
	IMG_PIXFMT_444PL111Y10UV8_LSB = 115,
	IMG_PIXFMT_444PL111Y10UV8_MSB = 116,
	IMG_PIXFMT_444PL111Y8UV10     = 117,
	IMG_PIXFMT_444PL111Y8UV10_LSB = 118,
	IMG_PIXFMT_444PL111Y8UV10_MSB = 119,
	IMG_PIXFMT_444PL12Y10UV8      = 145,
	IMG_PIXFMT_444PL12Y10UV8_LSB  = 147,
	IMG_PIXFMT_444PL12Y10UV8_MSB  = 148,
	IMG_PIXFMT_444PL12Y10VU8      = 146,
	IMG_PIXFMT_444PL12Y10VU8_LSB  = 149,
	IMG_PIXFMT_444PL12Y10VU8_MSB  = 150,
	IMG_PIXFMT_422PL111Y8UV10     = 124,
	IMG_PIXFMT_422PL111Y8UV10_MSB = 126,
	IMG_PIXFMT_422PL111Y8UV10_LSB = 128,

	IMG_PIXFMT_422PL111Y10UV8     = 130,
	IMG_PIXFMT_422PL111Y10UV8_LSB = 134,
	IMG_PIXFMT_422PL111Y10UV8_MSB = 132,
	IMG_PIXFMT_420PL8YUV12        = 160,
	IMG_PIXFMT_422PL8YUV12        = 161,
	IMG_PIXFMT_444PL8YUV12        = 162,
	IMG_PIXFMT_420PL8YUV14        = 163,
	IMG_PIXFMT_422PL8YUV14        = 164,
	IMG_PIXFMT_444PL8YUV14        = 165,
	IMG_PIXFMT_420PL8YUV16        = 166,
	IMG_PIXFMT_422PL8YUV16        = 167,
	IMG_PIXFMT_444PL8YUV16        = 168,
	IMG_PIXFMT_UNDEFINED          = 255,

	IMG_PIXFMT_ARBPLANAR8         = 65536,
	IMG_PIXFMT_ARBPLANAR8_LAST    = IMG_PIXFMT_ARBPLANAR8 + 0xffff,
	IMG_PIXFMT_FORCE32BITS        = 0x7FFFFFFFU
};

#endif
