/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.JSONMethodCodec;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalizationChannel {
    private static final String TAG = "LocalizationChannel";
    @NonNull
    public final MethodChannel channel;
    @Nullable
    private LocalizationMessageHandler localizationMessageHandler;
    @NonNull
    @VisibleForTesting
    public final MethodChannel.MethodCallHandler handler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            String method;
            if (LocalizationChannel.this.localizationMessageHandler == null) {
                return;
            }
            switch (method = call.method) {
                case "Localization.getStringResource": {
                    JSONObject arguments = (JSONObject)call.arguments();
                    try {
                        String key = arguments.getString("key");
                        String localeString = null;
                        if (arguments.has("locale")) {
                            localeString = arguments.getString("locale");
                        }
                        result.success(LocalizationChannel.this.localizationMessageHandler.getStringResource(key, localeString));
                    }
                    catch (JSONException exception) {
                        result.error("error", exception.getMessage(), null);
                    }
                    break;
                }
                default: {
                    result.notImplemented();
                }
            }
        }
    };

    public LocalizationChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/localization", JSONMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.handler);
    }

    public void setLocalizationMessageHandler(@Nullable LocalizationMessageHandler localizationMessageHandler) {
        this.localizationMessageHandler = localizationMessageHandler;
    }

    public void sendLocales(@NonNull List<Locale> locales) {
        Log.v(TAG, "Sending Locales to Flutter.");
        ArrayList<String> data = new ArrayList<String>();
        for (Locale locale : locales) {
            Log.v(TAG, "Locale (Language: " + locale.getLanguage() + ", Country: " + locale.getCountry() + ", Variant: " + locale.getVariant() + ")");
            data.add(locale.getLanguage());
            data.add(locale.getCountry());
            data.add(Build.VERSION.SDK_INT >= 21 ? locale.getScript() : "");
            data.add(locale.getVariant());
        }
        this.channel.invokeMethod("setLocale", data);
    }

    public static interface LocalizationMessageHandler {
        @NonNull
        public String getStringResource(@NonNull String var1, @NonNull String var2);
    }
}

