// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +sme2 -S -DTEST_SME2 -O1 -Werror -Wall -emit-llvm -o - %s | FileCheck %s
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +sve2p1 -S -O1 -Werror -Wall -emit-llvm -o - -x c++ %s | FileCheck %s -check-prefix=CPP-CHECK
// RUN: %clang_cc1 -DSVE_OVERLOADED_FORMS -triple aarch64-none-linux-gnu -target-feature +sve2p1 -S -O1 -Werror -Wall -emit-llvm -o - %s | FileCheck %s
// RUN: %clang_cc1 -DSVE_OVERLOADED_FORMS -triple aarch64-none-linux-gnu -target-feature +sve2p1 -S -O1 -Werror -Wall -emit-llvm -o - -x c++ %s | FileCheck %s -check-prefix=CPP-CHECK
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +sve2p1 -S -disable-O0-optnone -Werror -Wall -o /dev/null %s
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +sme2 -S -DTEST_SME2 -disable-O0-optnone -Werror -Wall -o /dev/null %s

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

#ifdef SVE_OVERLOADED_FORMS
#define SVE_ACLE_FUNC(A1, A2_UNUSED) A1
#else
#define SVE_ACLE_FUNC(A1, A2) A1##A2
#endif

#ifdef TEST_SME2
#define ATTR __arm_streaming
#else
#define ATTR
#endif

// WHILEGE

// CHECK-LABEL: @test_svwhilege_c8_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilege_c8_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilege_c8_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c8,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilege_c8_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilege_c8_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilege_c8_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c8,_s64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilege_c16_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilege_c16_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilege_c16_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c16,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilege_c16_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilege_c16_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilege_c16_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c16,_s64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilege_c32_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilege_c32_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilege_c32_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c32,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilege_c32_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilege_c32_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilege_c32_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c32,_s64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilege_c64_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilege_c64_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilege_c64_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c64,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilege_c64_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilege_c64_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilege.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilege_c64_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c64,_s64)(op1, op2, 4);
}

// WHILEGT


// CHECK-LABEL: @test_svwhilegt_c8_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilegt_c8_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilegt_c8_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c8,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilegt_c8_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilegt_c8_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilegt_c8_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c8,_s64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilegt_c16_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilegt_c16_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilegt_c16_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c16,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilegt_c16_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilegt_c16_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilegt_c16_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c16,_s64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilegt_c32_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilegt_c32_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilegt_c32_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c32,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilegt_c32_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilegt_c32_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilegt_c32_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c32,_s64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilegt_c64_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilegt_c64_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilegt_c64_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c64,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilegt_c64_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilegt_c64_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilegt.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilegt_c64_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c64,_s64)(op1, op2, 4);
}


// WHILEHI

// CHECK-LABEL: @test_svwhilehi_c8_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilehi_c8_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehi_c8_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c8,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilehi_c8_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilehi_c8_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehi_c8_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c8,_u64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilehi_c16_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilehi_c16_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehi_c16_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c16,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilehi_c16_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilehi_c16_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehi_c16_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c16,_u64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilehi_c32_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilehi_c32_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehi_c32_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c32,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilehi_c32_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilehi_c32_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehi_c32_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c32,_u64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilehi_c64_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilehi_c64_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehi_c64_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c64,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilehi_c64_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilehi_c64_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehi.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehi_c64_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilegt_c64,_u64)(op1, op2, 4);
}


// WHILEHS

// CHECK-LABEL: @test_svwhilehs_c8_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilehs_c8_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehs_c8_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c8,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilehs_c8_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilehs_c8_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehs_c8_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c8,_u64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilehs_c16_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilehs_c16_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehs_c16_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c16,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilehs_c16_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilehs_c16_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehs_c16_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c16,_u64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilehs_c32_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilehs_c32_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehs_c32_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c32,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilehs_c32_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilehs_c32_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehs_c32_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c32,_u64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilehs_c64_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilehs_c64_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehs_c64_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c64,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilehs_c64_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilehs_c64_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilehs.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilehs_c64_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilege_c64,_u64)(op1, op2, 4);
}


// WHILELE

// CHECK-LABEL: @test_svwhilele_c8_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilele_c8_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilele_c8_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c8,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilele_c8_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilele_c8_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilele_c8_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c8,_s64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilele_c16_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilele_c16_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilele_c16_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c16,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilele_c16_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilele_c16_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilele_c16_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c16,_s64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilele_c32_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilele_c32_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilele_c32_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c32,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilele_c32_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilele_c32_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilele_c32_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c32,_s64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilele_c64_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilele_c64_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilele_c64_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c64,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilele_c64_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilele_c64_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilele.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilele_c64_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c64,_s64)(op1, op2, 4);
}


// WHILELO

// CHECK-LABEL: @test_svwhilelo_c8_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilelo_c8_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelo_c8_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c8,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilelo_c8_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilelo_c8_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelo_c8_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c8,_u64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilelo_c16_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilelo_c16_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelo_c16_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c16,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilelo_c16_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilelo_c16_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelo_c16_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c16,_u64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilelo_c32_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilelo_c32_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelo_c32_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c32,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilelo_c32_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilelo_c32_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelo_c32_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c32,_u64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilelo_c64_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilelo_c64_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelo_c64_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c64,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilelo_c64_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilelo_c64_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelo.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelo_c64_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c64,_u64)(op1, op2, 4);
}


// WHILELS

// CHECK-LABEL: @test_svwhilels_c8_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilels_c8_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilels_c8_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c8,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilels_c8_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilels_c8_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilels_c8_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c8,_u64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilels_c16_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilels_c16_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilels_c16_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c16,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilels_c16_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilels_c16_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilels_c16_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c16,_u64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilels_c32_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilels_c32_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilels_c32_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c32,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilels_c32_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilels_c32_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilels_c32_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c32,_u64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilels_c64_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilels_c64_vl2mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilels_c64_vl2(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c64,_u64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilels_c64_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilels_c64_vl4mm(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilels.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilels_c64_vl4(uint64_t op1, uint64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilele_c64,_u64)(op1, op2, 4);
}


// WHILELT

// CHECK-LABEL: @test_svwhilelt_c8_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilelt_c8_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelt_c8_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c8,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilelt_c8_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svwhilelt_c8_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c8(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelt_c8_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c8,_s64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilelt_c16_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilelt_c16_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelt_c16_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c16,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilelt_c16_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilelt_c16_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c16(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelt_c16_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c16,_s64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilelt_c32_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilelt_c32_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelt_c32_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c32,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilelt_c32_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilelt_c32_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c32(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelt_c32_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c32,_s64)(op1, op2, 4);
}

// CHECK-LABEL: @test_svwhilelt_c64_vl2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilelt_c64_vl2ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 2)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelt_c64_vl2(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c64,_s64)(op1, op2, 2);
}

// CHECK-LABEL: @test_svwhilelt_c64_vl4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z22test_svwhilelt_c64_vl4ll(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call target("aarch64.svcount") @llvm.aarch64.sve.whilelt.c64(i64 [[OP1:%.*]], i64 [[OP2:%.*]], i32 4)
// CPP-CHECK-NEXT:    ret target("aarch64.svcount") [[TMP0]]
//
svcount_t test_svwhilelt_c64_vl4(int64_t op1, int64_t op2) ATTR
{
  return SVE_ACLE_FUNC(svwhilelt_c64,_s64)(op1, op2, 4);
}
