---
date: 25 февраля 2006
section: 8
title: RPM
---

НАЗВАНИЕ
========

rpm - Менеджер пакетов RPM

ОБЗОР
=====

ЗАПРОС И ПРОВЕРКА ПАКЕТОВ:
--------------------------

**rpm** {**-q\|\--query**} \[**опции-выбора**\] \[**опции-запроса**\]

**rpm** {**-V\|\--verify**} \[**опции-выбора**\] \[**опции-проверки**\]

**rpm** **\--import** *PUBKEY \...*

**rpm** {**-K\|\--checksig**} \[**\--nosignature**\] \[**\--nodigest**\]
*PACKAGE\_FILE \...*

УСТАНОВКА, ОБНОВЛЕНИЕ И УДАЛЕНИЕ ПАКЕТОВ:
-----------------------------------------

**rpm** {**-i\|\--install**} \[**опции-установки**\] *PACKAGE\_FILE
\...*

**rpm** {**-U\|\--upgrade**} \[**опции-установки**\] *PACKAGE\_FILE
\...*

**rpm** {**-F\|\--freshen**} \[**опции-установки**\] *PACKAGE\_FILE
\...*

**rpm** {**-e\|\--erase**} \[**\--allmatches**\] \[**\--nodeps**\]
\[**\--noscripts**\] \[**\--notriggers**\] \[**\--test**\]
*PACKAGE\_NAME \...*

РАЗНОЕ:
-------

**rpm** {**\--initdb\|\--rebuilddb**}

**rpm** {**\--addsign\|\--resign**} *PACKAGE\_FILE \...*

**rpm** {**\--querytags\|\--showrc**}

**rpm** {**\--setperms\|\--setugids**} *PACKAGE\_NAME \...*

опции-выбора
------------

\[*PACKAGE\_NAME*\] \[**-a,\--all**\] \[**-f,\--file ***FILE*\]
\[**-g,\--group ***GROUP*\] {**-p,\--package ***PACKAGE\_FILE*\]
\[**\--hdrid ***SHA1*\] \[**\--pkgid ***MD5*\] \[**\--tid ***TID*\]
\[**\--querybynumber ***HDRNUM*\] \[**\--triggeredby ***PACKAGE\_NAME*\]
\[**\--whatprovides ***CAPABILITY*\] \[**\--whatrequires
***CAPABILITY*\]

опции-запроса
-------------

\[**\--changelog**\] \[**-c,\--configfiles**\] \[**-d,\--docfiles**\]
\[**\--dump**\] \[**\--filesbypkg**\] \[**-i,\--info**\] \[**\--last**\]
\[**-l,\--list**\] \[**\--provides**\] \[**\--qf,\--queryformat
***QUERYFMT*\] \[**-R,\--requires**\] \[**\--scripts**\]
\[**-s,\--state**\] \[**\--triggers,\--triggerscripts**\]

опции-проверки
--------------

\[**\--nodeps**\] \[**\--nofiles**\] \[**\--noscripts**\]
\[**\--nodigest**\] \[**\--nosignature**\] \[**\--nolinkto**\]
\[**\--nomd5**\] \[**\--nosize**\] \[**\--nouser**\] \[**\--nogroup**\]
\[**\--nomtime**\] \[**\--nomode**\] \[**\--nordev**\]

опции-установки
---------------

\[**\--aid**\] \[**\--allfiles**\] \[**\--badreloc**\]
\[**\--excludepath ***OLDPATH*\] \[**\--excludedocs**\] \[**\--force**\]
\[**-h,\--hash**\] \[**\--ignoresize**\] \[**\--ignorearch**\]
\[**\--ignoreos**\] \[**\--includedocs**\] \[**\--justdb**\]
\[**\--nodeps**\] \[**\--nodigest**\] \[**\--nosignature**\]
\[**\--nosuggest**\] \[**\--noorder**\] \[**\--noscripts**\]
\[**\--notriggers**\] \[**\--oldpackage**\] \[**\--percent**\]
\[**\--prefix ***NEWPATH*\] \[**\--relocate ***OLDPATH***=***NEWPATH*\]
\[**\--replacefiles**\] \[**\--replacepkgs**\] \[**\--test**\]

ОПИСАНИЕ
========

**rpm** - это мощный **Менеджер Пакетов**, который может быть
использован для сборки, установки, запроса, проверки, обновления и
удаления отдельных программных пакетов. **Пакет** содержит архив с
файлами и метаданные, используемые для установки и удаления файлов
архива. Метаданные включают сценарии, атрибуты файлов и информацию с
описанием пакета. **Пакеты** бывают двух типов: двоичные пакеты,
используемые для объединения устанавливаемых программ, и пакеты с
исходными кодами, включающие исходные коды и описание способа
формирования двоичного пакета.

Необходимо указать один из следующих основных режимов работы:
**Запрос**, **Проверка**, **Проверка подписи**,
**Установка/Обновление/Освежение**, **Удаление**, **Инициализация Базы
данных**, **Перестройка Базы данных**, **Повторная подпись**,
**Добавление подписи**, **Задание Владельцев/Групп**, **Отображение
тегов запроса** и **Отображение конфигурации**.

ОБЩИЕ ОПЦИИ
-----------

Эти опции могут быть использованы во всех режимах.

**-?, \--help**

:   Вывести более детальную, чем обычно, справку об использовании.

**\--version**

:   Вывести одну строку, содержащую номер версии **rpm**.

**\--quiet**

:   Выводить как можно меньше сообщений - как правило, отображаются
    только сообщения об ошибках.

**-v**

:   Выводить подробную информацию - как правило, отображаются сообщения
    о выполнении всех шагов.

**-vv**

:   Выводить много отладочной информации.

**\--rcfile ***FILELIST*

:   Каждый из файлов разделенного двоеточиями списка файлов *FILELIST*
    последовательно прочитывается *rpm* на предмет конфигурационной
    информации. В этом списке обязан существовать только первый файл;
    все знаки тильда будут заменены значением **\$HOME**. По умолчанию
    список файлов *FILELIST* выглядит как
    */usr/lib/rpm/rpmrc*:*/usr/lib/rpm/\<vendor\>/rpmrc*:*/etc/rpmrc*:*\~/.rpmrc*.

**\--pipe ***CMD*

:   Перенаправляет вывод **rpm** на вход команды *CMD*.

**\--dbpath ***DIRECTORY*

:   Использовать базу данных RPM в каталоге *DIRECTORY* вместо пути по
    умолчанию */var/lib/rpm*

**\--root ***DIRECTORY*

:   Использовать для всех операций файловую систему с корнем в
    *DIRECTORY*. Обратите внимание, что это значит, что база данных
    внутри *DIRECTORY* будет использоваться для проверки зависимостей, и
    все сценарии **%post** и **%prep** будут исполняться после chroot(2)
    в *DIRECTORY*.

ОПЦИИ УСТАНОВКИ И ОБНОВЛЕНИЯ
----------------------------

Общая форма команды установки rpm приведена ниже

**rpm** {**-i\|\--install**} \[**опции-установки**\] *PACKAGE\_FILE
\...*

Так выполняется установка нового пакета.

Общая форма команды обновления rpm приведена ниже

**rpm** {**-U\|\--upgrade**} \[**опции-установки**\] *PACKAGE\_FILE
\...*

Так выполняется установка или обновление уже установленного пакета до
новой версии. Эта операция аналогична установке, при этом все другие
версии удаляются после установки нового пакета.

**rpm** {**-F\|\--freshen**} \[**опции-установки**\] *PACKAGE\_FILE
\...*

Так выполняется обновление пакетов, но только если предыдущая версия уже
установлена. Параметр *PACKAGE\_FILE* может быть указан как адрес
**ftp** или **http** URL, в таком случае пакет будет скачан перед
установкой. См. **ОПЦИИ FTP/HTTP** для получения информации о работе
**rpm** с поддержкой **ftp** или **http**.

**\--aid**

:   Добавляет при необходимости предложенные пакеты в набор транзакции.

**\--allfiles**

:   Устанавливает или обновляет все файлы с флагом missingok в пакете,
    независимо от их существования.

**\--badreloc**

:   Используется вместе с **\--relocate**, разрешает перемещение всех
    путей файлов, не только тех, для которых старые пути *OLDPATH*
    включены в заметки по перемещению (relocation hint) в бинарном
    пакете.

**\--excludepath ***OLDPATH*

:   Не устанавливать файлы названия, которых начинаются с *OLDPATH*.

**\--excludedocs**

:   Не устанавливать файлы помеченные как документация (включающие man
    страницы и документы texinfo).

**\--force**

:   Эквивалентно использованию **\--replacepkgs**, **\--replacefiles** и
    **\--oldpackage**.

**-h, \--hash**

:   Выводит 50 отметок при распаковке архива. Используется с
    **-v\|\--verbose** для удобства отображения.

**\--ignoresize**

:   Не проверять подключенные файловые системы на наличие необходимого
    места на диске перед установкой данного пакета.

**\--ignorearch**

:   Разрешить установку или обновление, даже если архитектуры бинарного
    пакета и узла не совпадают.

**\--ignoreos**

:   Разрешить установку или обновление, даже если операционные системы
    бинарного пакета и узла не совпадают.

**\--includedocs**

:   Устанавливать файлы с документацией. Это поведение задано по
    умолчанию.

**\--justdb**

:   Обновить только информацию в базе, но не файловые системы.

**\--nodigest**

:   Не проверять при чтении дайджест пакета или заголовка.

**\--nosignature**

:   Не проверять при чтении подпись пакета или заголовка.

**\--nodeps**

:   Не выполнять проверку зависимостей перед установкой или обновлением
    пакета.

**\--nosuggest**

:   Не предлагать пакет(ы) для разрешения отсутствующих зависимостей.

**\--noorder**

:   Не выполнять переупорядочивание пакетов для установки. Список
    пакетов обычно переупорядочивается для удовлетворения зависимостей.

**\--noscripts**

:   

**\--nopre**

:   

**\--nopost**

:   

**\--nopreun**

:   

**\--nopostun**

:   Не выполнять скриптлеты с указанным именем. Опция **\--noscripts**
    эквивалентна

**\--nopre** **\--nopost** **\--nopreun** **\--nopostun**

и выключает исполнение соответствующих **%pre**, **%post**, **%preun** и
**%postun** скриптлетов.

**\--notriggers**

:   

**\--notriggerin**

:   

**\--notriggerun**

:   

**\--notriggerpostun**

:   

Не выполнять ни какие триггерные скриптлеты с указанным именем. Опция
**\--notriggers** эквивалентна

**\--notriggerin** **\--notriggerun** **\--notriggerpostun**

и выключает исполнение соответствующих **%triggerin**, **%triggerun** и
**%triggerpostun** скриптлетов.

**\--oldpackage**

:   Разрешает обновить или заменить новый пакет более старой версией.

**\--percent**

:   Вывести информацию в процентах по мере распаковки файлов из архива
    пакета. Она предназначена для упрощения вызова **rpm** из других
    утилит.

**\--prefix ***NEWPATH*

:   Для перемещаемых бинарных пакетов, преобразовать все пути файлов,
    которые начинаются с инсталляционного префикса в заметках по
    перемещению (relocation hint) на *NEWPATH*.

**\--relocate ***OLDPATH***=***NEWPATH*

:   Для перемещаемых бинарных пакетов, преобразовать все пути файлов,
    которые начинаются с *OLDPATH* в заметках по перемещению (relocation
    hint) на *NEWPATH*. Данная опция может быть использована несколько
    раз, если требуется переместить несколько путей *OLDPATH* в пакете.

**\--replacefiles**

:   Установить пакеты, даже если они заменяют файлы от других
    установленных пакетов.

**\--replacepkgs**

:   Установить пакеты, даже если они уже установлены в системе.

**\--test**

:   Не устанавливать пакеты, просто выполнить проверку и сообщить о
    потенциальных конфликтах.

ОПЦИИ УДАЛЕНИЯ
--------------

Общая форма команды удаления rpm приведена ниже

**rpm** {**-e\|\--erase**} \[**\--allmatches**\] \[**\--nodeps**\]
\[**\--noscripts**\] \[**\--notriggers**\] \[**\--test**\]
*PACKAGE\_NAME \...*

Следующие опции могут быть также использованы:

**\--allmatches**

:   Удалить все версии пакета совпадающие с *PACKAGE\_NAME*. Обычно при
    наличии нескольких пакетов совпадающих с *PACKAGE\_NAME* возникает
    ошибка.

**\--nodeps**

:   Не проверять зависимости перед удалением пакетов.

**\--noscripts**

:   

**\--nopreun**

:   

**\--nopostun**

:   Не выполнять скриптлеты с указанными именами. Наличие параметра
    **\--noscripts** при удалении пакетов эквивалентно

**\--nopreun** **\--nopostun**

и выключает исполнение соответствующих скриптлетов **%preun** и
**%postun**.

**\--notriggers**

:   

**\--notriggerun**

:   

**\--notriggerpostun**

:   Не выполнять ни какие триггерные скриптлеты с указанным именем.
    Опция **\--notriggers** эквивалентна

**\--notriggerun** **\--notriggerpostun**

и выключает исполнение соответствующих **%triggerun** и
**%triggerpostun** скриптлетов.

**\--test**

:   Не удалять пакеты, просто выполнить проверку. Удобно использовать
    этот параметр при отладке совместно с опцией **-vv**.

ОПЦИИ ЗАПРОСА
-------------

Общая форма команды запроса rpm приведена ниже

**rpm** {**-q\|\--query**} \[**select-options**\] \[**query-options**\]

Существует возможность задать формат вывода информации о пакете. Для
этого необходимо использовать параметр

**\--qf\|\--queryformat** *QUERYFMT*

вслед за которым указывается строка формата *QUERYFMT*. Форматирование
запроса - это измененная версия стандартного механизма **printf(3)**.
Форматирование формируется из статических строк (которые могут включать
стандартные для языка C escape-последовательности для перевода строки,
табуляции и других спец. символов) и меток форматирования **printf(3)**.
Т.к. **rpm** заранее знает тип выводимой информации, указатель формата
может быть опущен и заменен на имя выводимого тега заголовка,
заключенного в фигурные скобки **{}**. Имена тегов не чувствительны к
регистру и префикс **RPMTAG\_** в имени тега можно опускать.

Альтернативные форматы вывода могут быть заданы при помощи задания типа
вывода **:***typetag* после имени тега. В данный момент поддерживаются
следующие типы:

**:armor**

:   Упаковать публичный ключ в ASCII вид.

**:base64**

:   Закодировать двоичные данные в формат base64.

**:date**

:   Использовать формат strftime(3) \"%c\".

**:day**

:   Использовать формат strftime(3) \"%a %b %d %Y\".

**:depflags**

:   Форматировать флаги зависимостей.

**:fflags**

:   Форматировать флаги файлов.

**:hex**

:   В шестнадцатеричном виде.

**:octal**

:   В восьмеричном виде.

**:perms**

:   Форматировать права доступа файлов.

**:shescape**

:   Экранировать одиночные кавычки для применения в сценариях.

**:triggertype**

:   Вывести суффикс триггера.

Например, для вывода только имени пакета при запросе, вы можете
использовать строку формата **%{NAME}**. Для вывода имени пакетов и
информации о дистрибутиве в две колонки вы можете использовать
**%-30{NAME}%{DISTRIBUTION}**. Команда **rpm** отобразит спиков всех
тегов, с которыми она может работать при ее вызове с параметром
**\--querytags**.

Существуют два набора параметров для выполнения запросов: для выбора
пакетов и для указания информации.

ОПЦИИ ВЫБОРА ПАКЕТОВ:
---------------------

*PACKAGE\_NAME*

:   Выполняет запрос к установленному пакету с именем *PACKAGE\_NAME*.

**-a, \--all**

:   Выполняет запрос ко всем установленным пакетам.

**-f, \--file ***FILE*

:   Выполняет запрос к пакету, владельцу файла *FILE*.

**-g, \--group ***GROUP*

:   Выполняет запрос к пакету с группой *GROUP*.

**\--hdrid ***SHA1*

:   Выполняет запрос к пакету, содержащему указанный идентификатор
    заголовка, т.е. *SHA1* дайджест неизменной части заголовка.

**-p, \--package ***PACKAGE\_FILE*

:   Выполняет запрос к (неустановленному) пакету в файле
    *PACKAGE\_FILE*. Параметр *PACKAGE\_FILE* может быть указан в виде
    адреса **ftp** или **http** URL, в результате чего заголовок пакета
    будет скачан и опрошен. Обратитесь к **ОПЦИЯМ FTP/HTTP** за
    информацией о поддержке в **rpm** работы с **ftp** и **http**. Если
    аргумент(ы) *PACKAGE\_FILE* не является бинарным пакетом, то он
    будет интерпретирован как ASCII манифест пакета. В нем разрешено
    применение комментариев начинающихся с \'\#\', каждая из строк файла
    манифеста пакета может включать разделенные запятыми glob выражения,
    включая адреса URL с внешними glob выражениями, они будут развернуты
    в пути, которые будут подставлены вместо манифеста пакета как
    дополнительный аргумент *PACKAGE\_FILE* в запросе.

**\--pkgid ***MD5*

:   Выполняет запрос к пакету, который содержит указанный идентификатор
    пакета, т.е. *MD5* дайджест объединенного содержимого заголовка и
    тела пакета.

**\--querybynumber ***HDRNUM*

:   Выполняет запрос напрямую *HDRNUM*\'ой записи в базе данных;
    используется только для отладки.

**\--specfile ***SPECFILE*

:   Обработать и выполнить запрос к *SPECFILE* файлу, как если бы это
    был пакет. Хотя не вся информация доступна (например, список
    файлов), этот тип запросов позволяет использовать rpm для извлечения
    информации из spec файлов без написания специализированного
    анализатора таких файлов.

**\--tid ***TID*

:   Выполняет запрос к пакету(ам), который содержит указанный
    идентификатор транзакции *TID*. В данный момент используется
    временная метка unix в качестве идентификатора. Все пакеты
    установленные или удаленные в составе одной транзакции будут иметь
    один и тот же идентификатор.

**\--triggeredby ***PACKAGE\_NAME*

:   Выполняет запрос к пакетам, которые вызывают срабатывание триггера
    пакета(ов) *PACKAGE\_NAME*.

**\--whatprovides ***CAPABILITY*

:   Выполняет запрос ко всем пакетам, которые предоставляют
    функциональность *CAPABILITY*.

**\--whatrequires ***CAPABILITY*

:   Выполняет запрос ко всем пакетам, которые требуют *CAPABILITY* для
    корректной работы.

ОПЦИИ ЗАПРОСА ПАКЕТОВ:
----------------------

**\--changelog**

:   Вывести информацию об изменениях в пакете.

**-c, \--configfiles**

:   Вывести только конфигурационные файлы (подразумевает **-l**).

**-d, \--docfiles**

:   Вывести только файлы документации (подразумевает **-l**).

**\--dump**

:   Распечатать информацию о файле в виде:

>     path size mtime md5sum mode owner group isconfig isdoc rdev symlink
>     	

Эта опция должна быть использована совместно с одной из **-l**, **-c**,
**-d**.

**\--filesbypkg**

:   Вывести все файлы во всех выбранных пакетах.

**-i, \--info**

:   Вывести информацию о пакете, включая имя, версию и описание. Будет
    использована **\--queryformat** если указана.

**\--last**

:   Упорядочивает вывод пакетов по времени установки так, чтобы
    последние пакеты были выведены в начале.

**-l, \--list**

:   Вывести список файлов в пакете.

**\--provides**

:   Вывести функциональность (capabilities) предоставляемую пакетом.

**-R, \--requires**

:   Вывести пакеты, от которых зависит этот пакет.

**\--scripts**

:   Вывести скриптлет(ы) пакета, которые используются как часть процесса
    установки или удаления пакетов.

**-s, \--state**

:   Вывести состояние (*state*) файлов в пакете (подразумевается
    **-l**). Состояние каждого файла в пакете является одним из
    *нормальное (normal)*, *не установлен (not installed)* или *заменен
    (replaced)*.

**\--triggers, \--triggerscripts**

:   Показать сценарии триггеров (если существуют), входящие в состав
    пакета.

ОПЦИИ ПРОВЕРКИ
--------------

Общая форма команды проверки rpm приведена ниже

**rpm** {**-V\|\--verify**} \[**опции-выбора**\] \[**опции-проверки**\]

Операция проверки пакета сравнивает информацию о файлах установленных из
пакета с информацией о них из метаданных пакета, хранимых в базе данных
rpm. Среди прочего при проверке сравниваются размер, MD5 сумма, права
доступа тип, владельца и группу каждого файла. Любые расхождения будут
отображены. Файлы, которые не были установлены вместе с пакетом,
например, файлы документации, исключенные при помощи опции
\"**\--excludedocs**\", будут проигнорированы без предупреждения.

Опции выбора пакетов являются аналогичными запросу пакетов (включая
файлы манифеста пакета в качестве аргумента). Опции, уникальные для
режима проверки, приведены ниже:

**\--nodeps**

:   Не выполнять проверку зависимостей пакетов.

**\--nodigest**

:   Не проверять при чтении дайджест пакета или заголовка.

**\--nofiles**

:   Не проверять атрибуты файлов пакетов.

**\--noscripts**

:   Не выполнять скриптлет **%verifyscript** (если существует).

**\--nosignature**

:   Не проверять при чтении подпись пакета или заголовка при чтении.

**\--nolinkto**

:   

**\--nomd5**

:   

**\--nosize**

:   

**\--nouser**

:   

**\--nogroup**

:   

**\--nomtime**

:   

**\--nomode**

:   

**\--nordev**

:   Не проверять соответствующие атрибуты файлов.

Формат вывода представляет собой строку из 9 символов и маркера из
заголовка пакета, за которыми следует имя файла. Возможные маркеры
атрибутов приведены ниже:

    c %config конфигурационный файл.
    d %doc файл документации.
    g %ghost файл (т.е. содержимое файла не включено в состав пакета).
    l %license файл с лицензией.
    r %readme файл readme.

Каждый из 9 символов отражает результат проверки атрибута(ов) файлов с
значением того же атрибута, записанного в базе данных. Символ \"**.**\"
(точка) означает, что проверка прошла, а символ \"**?**\"
(вопросительный знак) означает, что проверка не может быть выполнена
(например, права доступа к файлу не позволяют провести чтение). В
противном случае будут отображены символы (для привлечения внимания
выделены жирным), показывающие сбой проверки соответствующего
**\--verify** теста:

    S размер (Size) файла отличается
    M режим (Mode) доступа отличается (включая права доступа и тип файла)
    5 отличается контрольная MD5 сумма
    D отличается старший/младший номер файла устройства (Device)
    L отличается путь ссылки при readLink(2) 
    U отличается владелец (User)
    G отличается групповое владение (Group)
    T отличается время изменения (mTime)

ПРОВЕРКА ЦИФРОВОЙ ПОДПИСИ И ДАЙДЖЕСТА
-------------------------------------

Общая форма команд rpm по работе с цифровой подписью приведена ниже

**rpm** **\--import** *PUBKEY \...*

**rpm** {**\--checksig**} \[**\--nosignature**\] \[**\--nodigest**\]
*PACKAGE\_FILE \...*

Опция **\--checksig** проверяет все дайджесты и подписи, содержащиеся в
*PACKAGE\_FILE* для проверки целостности и происхождения пакета.
Обратите внимание, что подписи теперь проверяются при каждом чтении
пакета и опция **\--checksig** полезна для проверки всех дайджестов и
подписей, ассоциированных с пакетом.

Цифровые подписи не могут быть проверены без публичных ключей. Публичный
ключ в ASCII формате может быть добавлен в базу данных **rpm** при
использовании команды **\--import**. Импортированный публичный ключ
заносится в заголовок и управление ключами проводится аналогично
управлению пакетами. Например, все импортированные ключи можно
просмотреть при помощи:

**rpm -qa gpg-pubkey\***

Подробная информация о конкретном публичном ключе после импорта может
быть отображена при запросе. Информация о ключе Red Hat GPG/DSA:

**rpm -qi gpg-pubkey-db42a60e**

Наконец, публичный ключ может быть удален после его импорта также как
пакет. Удаление ключа Red Hat GPG/DSA:

**rpm -e gpg-pubkey-db42a60e**

ПОДПИСЬ ПАКЕТА
--------------

**rpm** **\--addsign\|\--resign** *PACKAGE\_FILE \...*

Обе опции **\--addsign** и **\--resign** создают и вставляют новую
подпись для каждого указанного файла *PACKAGE\_FILE*, заменяя
существующие подписи. Эти две опции существуют по историческим причинам,
и разницы в поведении между ними сейчас нет.

ИСПОЛЬЗОВАНИЕ GPG ДЛЯ ПОДПИСИ ПАКЕТОВ
-------------------------------------

Для того, чтобы подписывать пакеты при помощи GPG, **rpm** должен быть
настроен на запуск GPG и иметь возможность находить хранилище ключей с
требуемыми ключами. По умолчанию **rpm** использует те же соглашения,
что и GPG для обнаружения хранилища ключей, а именно переменную среды
**\$GNUPGHOME**. Если ваше хранилище ключей располагается не там, где
его ожидает найти GPG, вам потребуется определить в макросе
**%\_gpg\_path** расположение хранилища ключей GPG.

Для совместимости со старыми версиями GPG, PGP и rpm следует настраивать
только подпись пакетов V3 OpenPGP. Могут быть использованы алгоритмы
проверки DSA и RSA, хотя предпочитается DSA.

Если вам требуется подписывать собственные пакеты, вам также потребуется
создать собственную пару из публичного и приватного ключа (см.
руководство по GPG). Вам также потребуется настроить **rpm** макрос

**%\_gpg\_name**

:   Имя пользователя, ключом которого будут подписываться ваши пакеты.

Например, для использования GPG для подписи пакетов от имени *\"John Doe
\<jdoe\@foo.com\>\"* из хранилища ключей расположенного в
*/etc/rpm/.gpg*, используя программу */usr/bin/gpg*, вам потребуется
включить строки

    %_gpg_path /etc/rpm/.gpg
    %_gpg_name John Doe <jdoe@foo.com>
    %_gpgbin /usr/bin/gpg

в файл настройки макросов. Для общесистемной настройки используется
*/etc/rpm/macros* и *\~/.rpmmacros* для конкретного пользователя.

ОПЦИИ ПЕРЕСТРОЙКИ БАЗЫ ДАННЫХ
-----------------------------

Общая форма команды перестройки базы данных rpm приведена ниже

**rpm** {**\--initdb\|\--rebuilddb**} \[**-v**\] \[**\--dbpath
***DIRECTORY*\] \[**\--root ***DIRECTORY*\]

Используйте **\--initdb** для создания новой базы данных и
**\--rebuilddb** для перестройки индексов базы данных на основании
заголовков установленных пакетов.

SHOWRC
------

Команда

**rpm** **\--showrc**

показывает значения, которые **rpm** будет использовать для всех опций,
установленные в конфигурационных файлах *rpmrc* и *macros*.

ОПЦИИ FTP/HTTP
--------------

**rpm** может выступать в качестве клиента FTP и/или HTTP, таким образом
пакеты могут быть опрошены или установлены из Интернет. Пакеты для
операций установки, обновления или запроса могут быть указаны в виде
адреса **ftp** или **http** URL:

ftp://USER:PASSWORD\@HOST:PORT/path/to/package.rpm

Если параметр **:PASSWORD** будет опущен, пароль будет запрошен (один
раз для пары пользователь/узел). Если опущены оба параметра (user и
password), будет выполнено анонимное подключение **ftp**. Во всех
случаях используется пассивный (PASV) режим передачи файлов **ftp**.

**rpm** допускает следующие опции для адресов ftp URL:

**\--ftpproxy ***HOST*

:   Узел *HOST* будет использован как прокси-сервер для всех операций
    передачи данных ftp, что позволяет работать с ftp через межсетевые
    экраны, на которых запущена служба прокси. Эта опция может быть
    также указана при настройке макроса **%\_ftpproxy**.

**\--ftpport ***PORT*

:   Номер TCP порта *PORT* будет использован для ftp подключения к ftp
    прокси-серверу вместо порта по умолчанию. Эта опция может быть также
    указана при настройке макроса **%\_ftpport**.

**rpm** допускает следующие опции для адресов **http** URL:

**\--httpproxy ***HOST*

:   Узел *HOST* будет использован как прокси-сервер для всех операций
    передачи данных **http**. Эта опция может быть также указана при
    настройке макроса **%\_httpproxy**.

**\--httpport ***PORT*

:   Номер TCP порта *PORT* будет использован для **http** подключения к
    http прокси-серверу вместо порта по умолчанию. Эта опция может быть
    также указана при настройке макроса **%\_httpport**.

ВОПРОСЫ СОВМЕСТИМОСТИ
=====================

Выполнение rpmbuild
-------------------

Режимы сборки rpm теперь вынесены в программу */usr/bin/rpmbuild*. Не
смотря на это, совместимость, обеспечиваемая при помощи popt
псевдонимов, указанных ниже, является адекватной, но не совершенной.
Поэтому совместимость режимов сборки через псевдонимы popt удалена из
rpm. Установите пакет **rpmbuild** и просмотрите документацию в
**rpmbuild**(8) по всем режимам сборки **rpm**, ранее приведенную здесь
в **rpm**(8).

Добавьте следующие строки в */etc/popt*, если вы желаете вызывать
**rpmbuild** из командной строки **rpm**:

    rpm     exec --bp               rpmb -bp
    rpm     exec --bc               rpmb -bc
    rpm     exec --bi               rpmb -bi
    rpm     exec --bl               rpmb -bl
    rpm     exec --ba               rpmb -ba
    rpm     exec --bb               rpmb -bb
    rpm     exec --bs               rpmb -bs 
    rpm     exec --tp               rpmb -tp 
    rpm     exec --tc               rpmb -tc 
    rpm     exec --ti               rpmb -ti 
    rpm     exec --tl               rpmb -tl 
    rpm     exec --ta               rpmb -ta
    rpm     exec --tb               rpmb -tb
    rpm     exec --ts               rpmb -ts 
    rpm     exec --rebuild          rpmb --rebuild
    rpm     exec --recompile        rpmb --recompile
    rpm     exec --clean            rpmb --clean
    rpm     exec --rmsource         rpmb --rmsource
    rpm     exec --rmspec           rpmb --rmspec
    rpm     exec --target           rpmb --target
    rpm     exec --short-circuit    rpmb --short-circuit

ФАЙЛЫ
=====

Конфигурация rpmrc
------------------

    /usr/lib/rpm/rpmrc
    /usr/lib/rpm/<vendor>/rpmrc
    /etc/rpmrc
    ~/.rpmrc

Конфигурация макросов
---------------------

    /usr/lib/rpm/macros
    /usr/lib/rpm/<vendor>/macros
    /etc/rpm/macros
    ~/.rpmmacros

База данных
-----------

    /var/lib/rpm/Basenames
    /var/lib/rpm/Conflictname
    /var/lib/rpm/Dirnames
    /var/lib/rpm/Filemd5s
    /var/lib/rpm/Group
    /var/lib/rpm/Installtid
    /var/lib/rpm/Name
    /var/lib/rpm/Packages
    /var/lib/rpm/Providename
    /var/lib/rpm/Provideversion
    /var/lib/rpm/Pubkeys
    /var/lib/rpm/Removed
    /var/lib/rpm/Requirename
    /var/lib/rpm/Requireversion
    /var/lib/rpm/Sha1header
    /var/lib/rpm/Sigmd5
    /var/lib/rpm/Triggername

Временные файлы
---------------

*/var/tmp/rpm\**

СМОТРИ ТАКЖЕ
============

    popt(3),
    rpm2cpio(8),
    rpmbuild(8),

**http://www.rpm.org/ \<URL:http://www.rpm.org/\>**

АВТОРЫ
======

    Marc Ewing <marc@redhat.com>
    Jeff Johnson <jbj@redhat.com>
    Erik Troan <ewt@redhat.com>

ПЕРЕВОД
=======

    Андрей Мартынов <andrewm@inventa.ru>
