// Copyright (c) 2019, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

/// From: https://ko.wikipedia.org/wiki/%ED%95%9C%EA%B8%80
/// text converted to Unicode NFD format.
/// Text is available under the [Creative Commons Attribution-ShareAlike License](https://en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License).
var hangul = """
한글
위키백과, 우리 모두의 백과사전.
둘러보기로 가기검색하러 가기
	이 문서에는 옛 한글이 포함되어 있습니다.
관련 글꼴이 설치되지 않은 경우, 일부 문자가 깨진 글자로 표시될 수 있습니다. 옛 한글 도움말을 참고하여 볼 수 있습니다.
 다른 뜻에 대해서는 한글 (동음이의) 문서를 참조하십시오.
 서적에 대해서는 훈민정음 문서를, 언어에 대해서는 한국어 문서를 참조하십시오.
한글 · 조선글


한글의 구조
한글의 구조
원래 이름	훈민정음(訓民正音)
유형	음소문자
표기 언어	한국어, 제주어, 찌아찌아어
사용 시기	1443년 ~ 현재
창제자	세종
ISO 15924	Hang
한국어의 표기법
문자
한글
한자
한글 점자
한글전용
국한문혼용
이두
향찰
구결
로마자 표기법
국어의 로마자 표기법
매큔-라이샤워 표기법
예일 로마자 표기법
ISO/TR 11941
김복문 로마자 표기법
양병선 로마자 표기법
21세기 로마자 표기법
음소문자의 역사
원시 시나이 문자 (기원전 18 ~ 15세기)

우가리트 문자 (기원전 15세기)
원시 가나안 문자 (기원전 14세기)
페니키아 문자 (기원전 11세기)
고대 히브리 문자 (기원전 10세기)
사마리아 문자 (기원전 6세기)
아람 문자 (기원전 8세기)
브라흐미 문자와 인도 문자 (기원전 6세기)
티베트 문자 (7세기)
크메르 문자/자와 문자 (9세기)
히브리 문자 (기원전 3세기)
시리아 문자 (기원전 2세기)
나바테아 문자 (기원전 2세기)
아랍 문자 (4세기)
타나 문자 (18세기)
소그드 문자 (기원전 4세기)
돌궐 문자 (5세기)
로바쉬 문자 (12세기)
위구르 문자 (8세기)
몽골 문자 (13세기)
만주 문자 (16세기)
팔라비 문자 (기원전 3세기)
아베스타 문자 (4세기)
그리스 문자 (기원전 9세기)
에트루리아 문자 (기원전 8세기)
로마자 (기원전 7세기)
룬 문자 (2세기)
고트 문자 (3세기)
콥트 문자 (300년)
아르메니아 문자 (405년)
조지아 문자 (5세기)
글라골 문자 (862년)
키릴 문자 (10세기)
아부르 문자 (1372년)
고대 히스파니아 문자 (기원전 7세기)
남아랍 문자 금석문 (기원전 9세기)
그으즈 문자 (기원전 5 ~ 6세기)
메로이트 문자 (기원전 3세기)
오검 문자 (4세기)
한글 1443년
캐나다 문자 1840년
주음부호 1913년
전체 분류
v • d • e • h
한글은 발음기관과 하늘, 땅, 사람을 본따 고안된 음소문자로, 닿소리 14자에 홀소리 10자 총 24자로 구성되어 있다. "나랏말이 중국과 달라" 문제를 느낀 조선 세종이 한국어를 표기하기 위하여 1443년 창제, 1446년 반포하였다. 낱자가 음가만 표기하기 때문에 갈래로는 음소문자에 속하나, 네모 칸에 초성, 중성, 종성을 이루는 자모음을 한데 모아 쓰는 방식 때문에 음절문자의 특성도 일부 지닌다. 원래 글자 수는 닿소리 17자에 홀소리 11자 총 28자였으나 이후 4자가 소실, 24자만 쓰이게 되었다. 대한민국과 조선민주주의인민공화국과 옌볜 조선족 자치주에서는 공용 문자로, 인도네시아 부톤 섬에서는 찌아찌아어의 보조 문자로 채택되었다. 북한에서는 조선글(朝鮮-)이라 한다.

세계에서 유일하게 만든 사람,만든 이유,만든 날짜를 아는 글자이다.


목차
1	명칭
2	역사
2.1	창제
2.2	창제 논란
2.3	조선
2.4	근대 이후
2.5	현대 이후
3	창제원리
4	구조
4.1	낱자
4.2	모아쓰기
4.3	표기 가능한 글자 수와 소리나는 음절 개수
5	한글의 유래
6	한글에 관한 여러 이설
6.1	파스파 문자 기원설
6.2	기타 한글과 유사하다고 주장하는 문자
6.2.1	가림토와 신대 문자
6.2.2	구자라트 문자
6.3	다른 언어에서의 한글 사용
7	오해와 사실
8	한글 자모일람
8.1	방언 한글 자모
8.2	고문 한글 자모
8.3	복합원음와 보음
9	관련 항목
10	각주
11	참고 문헌
12	읽을거리
13	외부 링크
명칭
창제 때는 백성(民)을 가르치는(訓) 바른(正) 소리(音), 훈민정음(訓民正音)이라 하였고, 줄여서 정음(正音)이라고도 했다.

'한글'이라는 이름은 주시경이 ‘큰’, ‘바른’, ‘하나’를 뜻하는 고유어 ‘한’을 차용하여 지었다. 하지만 주시경의 의도한 뜻이 무엇이었는지는 명확히 밝혀진 바가 없다.

한글 창제 당시에는 백성을 가르치는 바른소리라는 뜻으로 훈민정음이라 하였고, 줄여서 정음(正音)이라고도 하였다. 조선시대에는 지식층으로부터 경시되며, 본래의 이름으로 쓰지 않고 막연히 언문(諺文)[1], 언서(諺書)[2], 반절(反切)[3] 로 불리거나, 혹은 암클(여성들이 배우는 글), 아햇글(어린이들이 배우는 글)이라고 불렀다고 알려져 있다. (단, 암클, 아햇글이라는 표현은 그 출처가 불분명하다.) 1894년 갑오개혁 이후 국서(國書), 국문(國文)이라고 불렀고 혹은 조선글로 부르기도 하였는데 이것은 한국의 글이라는 보통 이름일 뿐이며, 고유명사로 한글이라는 이름이 널리 쓰이기 전에는 가갸, 정음 등으로 불렀다.

처음 한글이라는 이름이 사용된 것에대한 명확한 기록은 없다. 다만 1913년 3월 23일 주시경이 ‘배달말글몯음(조선어문회, 朝鮮言文會)[4]’를 ‘한글모’로 바꾼 바 있고[5], 같은 해 9월 최남선의 출판사 ‘신문관(新文館)’에서 창간한 어린이 잡지 《아이들 보이》의 끝에 가로글씨로 '한글풀이’라 한 것이 있고[6], 1914년 4월에 ‘조선어강습원(朝鮮語講習院)’이 ‘한글배곧’으로 이름을 바꾼 것 등으로 볼 때 1913년 무렵 주시경이 처음으로 사용한 것으로 보이며, 1927년에는 조선어학회 회원들이 《한글》이라는 잡지를 매달 발간하였다. 한글이라는 명칭이 일반화된 것은 1928년 11월 11일 조선어연구회에서 가갸날을 한글날로 고쳐 부른 때부터라고 한다.

현재 한글의 명칭을 대한민국에서는 한글로, 조선민주주의인민공화국에서는 조선어자모로 부르는데[7], 2001년 2월 중국 옌지에서 열린 ‘제5차 코리안 컴퓨터 처리 국제 학술 대회(ICCKL 2001)’에서는 남과 북, 해외 동포 학자들이 국제 표준화 기구(ISO)에 등록하기 위한 명칭으로 ‘정음(Jeong'eum)’을 쓰기로 합의하였다.

다른 나라에서는 한글(Hangul/Hangeul)이라는 이름을 많이 쓰지만, 중국에서는 조선 자모(중국어: 朝鮮字母, 병음: Cháoxiǎn zìmǔ 차오셴 쯔무[*])와 같은 이름을 쓴다. 일본에서는 한글은 물론 한국어를 ‘한구루(한글)(ハングル)’로 부르기도 하는데, 이는 NHK 방송에서 한국어 강좌를 설립시에 대한민국의 ‘한국어’와 조선민주주의인민공화국의 ‘조선어’ 사이에서 중립적인 위치를 지키기 위해 한국어 강좌 명칭으로 '한글강좌'를 사용하여 많은 일본인들이 이를 보고 한글의 뜻을 한국어로 오해한 것이다.

한글이라는 이름은 본디 문자의 이름이지만, 관용적으로는 한국어를 한글로 적은 것이라는 의미로 책이나 소프트웨어, 게임 등의 한국어 번역 작업을 한글화라 하고 번역본을 한글판이라 부르기도 한다. 그리고 한글 이름, 한글 지명처럼 고유어라는 의미로 쓰이기도 한다. 하지만 표준국어대사전에서는 두 의미 모두 등재되지 않았으며, 한국어화, 한국어판이 맞는 표현이다.

역사

《훈민정음 언해》의 서두
창제
한국은 삼국시대부터 이두(吏讀)와 구결(口訣)을 써 왔는데, 구결은 본래 한문에 구두(句讀)를 떼는 데 쓰기 위한 일종의 보조적 편법에 지나지 않았고, 이두는 비록 한국어를 표시함에 틀림이 없었지만 한국어를 자유자재로 적을 수 없었으며, 그 표기법의 일원성(一元性)이 없어서 설사 이두로써 족하다 해도 한자교육이 선행되어야 했다. 이러한 문자생활의 불편은 한자를 쓰지 않고도, 배우기 쉽고 쓰기 쉬운 새로운 글자의 출현이 절실히 요구되었다.

이러한 사조가 세종때에 특히 두드러져 드디어 1443년 음력 12월에 문자혁명의 결실을 보게 되었다. 훈민정음 창제의 취지에 관하여는 세종이 손수 저술한 《훈민정음》 예의편(例義篇) 첫머리에 잘 나타나 있는데, 첫째 한국어는 중국말과 다르므로 한자를 가지고는 잘 표기할 수 없으며, 둘째 우리의 고유한 글자가 없어서 문자생활의 불편이 매우 심하고, 셋째 이런 뜻에서 새로 글자를 만들었으니 일상생활에 편하게 쓰라는 것이다.

‘훈민정음’은 “백성을 가르치는 바른소리”라는 뜻으로[8], 세종의 어제 서문과 정인지 서(序)에서 분명히 밝히고 있는바, 당시까지 한문 의존에 따른 어려움을 근본적으로 극복하기 위해 한국어의 고유문자로서 창제되었다.

한편, 훈민정음 창제 후 5년 뒤에 《동국정운(東國正韻)》이 간행되는데, 당시 조선에서 통용되던 한자음을 중국어 원음으로 교정하기 위한 책으로서 이것의 발음 표기에 훈민정음이 사용되고 있다. 따라서, 세종의 훈민정음 창제가 한자 및 한문의 폐지를 목적한 것은 아니라고 보이며, 훈민정음의 활용 범위가 상당히 넓었음을 짐작할 수 있다. 훈민정음에 대하여 반대하는 신하들이 있었는데 대표적으로 최만리는 상소를 올려 반대하였다. 그러나 세종은 "경이 운서를 아는가? 사성칠음에 자모가 몇이나 있는가? 만일 짐이 운서를 바로잡지 아니하면 누가 이를 바로잡을 것인가?" 라고 말하였다.

처음 만들었을 때는 낱자 28글자와 성조를 나타내는 기호(방점)가 따로 있었으나, 지금은 ㅿ, ㆁ, ㆆ, ㆍ 네 글자와 성조 기호(방점)가 사라져서 24글자가 되었다. (제주도를 비롯한 몇 곳에서는 아직도 ㆍ의 발음이 남아 있다.)

그 뒤로 몇 백 년에 걸쳐, 식자층은 주로 한글보다는 한문 위주의 문자 생활을 했지만 한자를 배울 수 없었던 백성과 여자들은 서로 주고 받는 편지나 계약서 등에 한글을 썼고, 궁궐에서 여자끼리 주고 받는 문서에 한글을 쓰기도 하였다.

창제 논란
오늘날 한글이라 불리는 글이 창제되었다는 사실이 세상에 알려진 것은 세종대왕 25년인 1443년이다. 창제 당시에 한글은 '훈민정음'이라 불렸으며 1446년 음력 9월 초에는 《훈민정음》(통칭 '해례본')이 책으로 엮어졌다. 이 사실은 정인지(鄭麟趾)가 쓴 〈서(序)〉로 확인된다.[9]

지금까지 논란이 되고 있는 부분은 세종대왕이 홀로 글을 창제했는지, 집현전 학자들의 도움을 받았는지, 아니면 세종대왕의 명을 받아 집현전 학자들이 글을 창제했는지가 문제이다. 세종실록(世宗實錄)은 훈민정음을 세종대왕이 친히 만들었다고 기록하고 있으며[10], 누구의 도움을 받았다는 기록은 없다.[11]

다시 말하면 시월 상친제언문이십팔자(是月 上親制諺文二十八字, 세종 25년, 12월 30일)에서 ‘상친제(上親制)’란 세종이 직접 한글을 만들었다는 뜻인데 '세종실록' 안에는 다른 업적에 관해서는 "친제"라는 말이 없었지만, 훈민정음(한글)에 관해서는 이렇게 확실하게 적어 놓았다는 것이다. 또한, 집현전 학자였던 정인지가 집필한 훈민정음 해례본의 서문 중에도 세종대왕이 직접 한글을 창제했다는 내용이 있다.[12]

그러나 성현(成俔, 1439년~1504년)의 《용재총화(慵齋叢話)》 제7권에서 세종이 언문청을 세워 신숙주, 성삼문 등에게 글을 짓도록 명을 내렸다는 주장이 나왔다. 주시경은 《대한국어문법》(1906년)에서 세종이 집현전 학자들의 도움을 받아 한글을 창제했다고 썼다. 그리하여 한글 창제에 집현전 학자들이 관여했다는 설이 우세하게 되었으나, 이기문을 비롯한 학자들은 기록에 나타난 당시 정황을 볼 때 세종이 한글을 홀로 창제한 것이 아니라고 볼 이유가 없다고 주장하고 있다. 한글 창제 후 세종은 표음주의 표기가 일반적인 당대의 표기법과는 달리 형태주의 표기를 주로 활용하고 동국정운 같은 책을 편찬한 예에서 보듯이 국어와 중국어의 전반에 걸쳐 음운학 및 언어학에 깊은 조예와 지식을 보여 주었다. 집현전 학자들은 한글 창제 후 정음청에서 한글을 사용한 편찬 사업에만 관여했다는 것이다.[13]

조선
처음에 ‘훈민정음’으로 반포된 한글은 조선시대에는 '언문'이라고 불렸다. 이것은 《세종실록》에서 '상친제언문이십팔자(上親製諺文二十八字)'라고 한 것에 연유하는데 한자를 제외한 문자는 ‘언문’이라고 불렀기 때문이다. 여성들이 많이 한글을 썼기 때문에 ‘암클’ 등으로 낮추어 불리기도 하였으나, 궁중과 일부양반층, 백성들 사이에서도 사용되었다.

1445년(세종 27) 4월에 훈민정음을 처음으로 사용하여 악장(樂章)인 《용비어천가》를 편찬하고, 1447년(세종 29) 5월에 간행하였다. 목판본 10권 5책 모두 125장에 달하는 서사시로서, 한글로 엮어진 책으로는 한국 최초의 것이 된다. 세종은 “어리석은 남녀노소 모두가 쉽게 깨달을 수 있도록” 《(세종실록》, 세종 26년) 《삼강행실도》를 훈민정음으로 번역하도록 했으며, 훈민정음이 반포된 뒤에는 일부 관리를 뽑을 때 훈민정음을 시험하도록 했다. 이후로 민간과 조정의 일부 문서에서 훈민정음을 써 왔다.

이러한 한글 보급 정책에 따라 한글은 빠르게 퍼져 반 세기 만인 1500년대 지방의 노비 수준의 신분인 도공에게까지 쓰이게 되었다.[14]

연산군은 1504년(연산군 10년) 훈민정음을 쓰거나 가르치는 것을 금했지만, 조정안에서 훈민정음을 쓰는 것을 금하지는 않았으며, 훈민정음을 아는 사람을 일부러 궁궐에 등용하기도 했다고 전한다.

율곡 이이가 《대학》에 구결을 달고 언해한 《대학율곡언해》는 1749년에 간행되었다.[15]

조선 중기 이후로 가사 문학, 한글 소설 등 한글로 창작된 문학이 유행하였고, 서간에서도 한글/정음이 종종 사용되었다.

근대 이후
1894년(조선 고종 31년) 갑오개혁에서 마침내 한글을 ‘국문’(國文 나랏글)이라고 하여, 1894년 11월 21일 칙령 제1호 공문식(公文式) 제14조[16] 및 1895년 5월 8일 칙령 제86호 공문식 제9조[17] 에서 법령을 모두 국문을 바탕으로 삼고 한문 번역을 붙이거나 국한문을 섞어 쓰도록 하였다. 1905년 지석영이 상소한 6개 항목의 〈신정국문(新訂國文)〉이 광무황제의 재가를 얻어 한글 맞춤법으로서 공포되었으나, 그 내용의 결점이 지적되면서 1906년 5월에 이능화(李能和)가 〈국문일정의견(國文一定意見)〉을 제출하는 등 논란이 되자, 당시 학부대신 이재곤(李載崑)의 건의로 1907년 7월 8일 대한제국 학부에 통일된 문자 체계를 확립하기 위한 국어 연구 기관으로 '국문연구소(國文硏究所)'가 설치되었는데, 국문연구소의 연구 성과는 1909년 12월 28일 학부에 제출한 보고서로서 〈국문연구의정안(國文硏究議定案)〉 및 어윤적, 이종일(李鍾一), 이억(李億), 윤돈구(尹敦求), 송기용(宋綺用), 유필근(柳苾根), 지석영, 이민응(李敏應)의 8위원 연구안으로 완결되었다.


한글과 한문이 혼용되어 쓰인 매일신보 1944년 기사
한편, 민간에서는 1906년 주시경이 《대한국어문법(大韓國語文法)》을 저술하여 1908년에 《국어문전음학(國語文典音學)》으로 출판하였으며, 1908년 최광옥(崔光玉)의 《대한문전(大韓文典)》, 1909년 유길준(兪吉濬)의 《대한문전(大韓文典)》, 김희상(金熙祥)의 《초등국어어전(初等國語語典)》, 1910년 주시경의 《국어문법(國語文法)》등이 출간되고, 이후에도 1911년 김희상의 《조선어전(朝鮮語典)》, 1913년 남궁억(南宮檍)의 〈조선문법(朝鮮文法)〉, 이규영(李奎榮)의 〈말듬〉, 1925년 이상춘(李常春)의 《조선어문법(朝鮮語文法)》 등으로 이어지면서, 1937년 최현배의 《우리말본》으로 집대성된다.

이와 함께, 조선어학회와 같은 모임에서 꾸준히 애쓴 덕에 조금씩 한국어의 표준 문자로 힘을 얻게 되어 누구나 쓸 수 있게끔, 널리 퍼지게 되었다. '한글'이라는 이름은 주시경이 지은 것이며 조선어학회가 이 이름을 널리 알리기 시작한 것도 이 즈음이다. 일제강점기를 거쳐 광복을 맞이한 다음에는 남북한 모두 공문서와 법전에 한글을 쓰게 되었고, 끝내 조선어를 받아적는 글자로 자리잡게 되었다.

현대 이후
한국에서는 한글전용법이 시행되어 한자의 사용이 줄어들면서 1990년대 그 사용이 절정을 이루었다.[18] 이후 정부차원에서의 영어우대정책으로 인해 한글의 사용이 점차 줄고 있다는 지적이 있다.[19]

2009년에는 문자가 없어 의사 소통에 곤란을 겪었던 인도네시아의 소수 민족인 찌아찌아족이 자신들의 언어 찌아찌아어의 표기 문자로 시범적으로 한글을 채택, 도입하였다. 그러나 주 정부의 반대와 소수만 배우는 문제 등으로 인해서 이 방법은 사용되지 않고 있다. 그리고 2012년에 솔로몬 제도에 있는 일부 주가 모어 표기문자로 한글을 도입하였다.[20]

창제원리
『훈민정음 해례본(訓民正音 解例本)』을 바탕으로 한글과 음양오행의 관계를 기록하였다.

가. 모음은 음양의 원리를 기본으로 만들어졌다.

기본 모음'ㆍ, ㅡ, ㅣ'를 보면 'ㆍ'(아래아)는 양(陽)인 하늘(天)을 본 떠 만들고, 'ㅡ'는 음(陰)인 땅(地)을 본 떠 만들었으며 'ㅣ'는 음과 양의 중간자인 인간(人)의 형상을 본 떠 만들었다. 천지인(天地人)은 단군사상에서 유래한 것으로 우주를 구성하는 주요한 요소인 하늘(·)과 땅(ㅡ), 사람(ㅣ)을 나타낸다.[21]
『훈민정음 해례본』에 따르면 'ㅏ,ㅑ, ㅗ, ㅛ'는 'ㆍ'(아래아) 계열의 글자이다.
'ㆍ'(아래아)의 속성은 양이다. 양의 특성은 위로의 상승, 바깥으로의 확장이다. 따라서 점을 위, 바깥 쪽에다 찍은 것.

'ㅓ, ㅕ, ㅜ, ㅠ'는 그 반대로 'ㅡ' 계열의 글자이기 때문에 음의 속성을 따라, 하강, 수축의 뜻으로 점을 안쪽, 아래로 찍은 것.
나. 자음은 오행을 바탕으로 만들어졌다.

『훈민정음 해례본』에선 각 방위와 발음기관을 연결시키고, 해당 발음기관에서 나는 소리 또한 방위와 연관시키고 있다. 방위는 또 계절과 연결이 되므로, 결국 소리는 계절과 연결된다.
(소리=방위=계절, 소리=계절) 계절은 봄, 여름, 늦여름, 가을, 겨울 순이므로, 소리 역시 어금닛소리(ㄱ, 봄), 혓소리(ㄴ, 여름), 입술소리(ㅁ, 늦여름), 잇소리(ㅅ, 가을), 목소리(ㅇ,겨울) 순으로 배열한다.

『훈민정음 해례본』에서 기본 자음을 ㄱ,ㄴ,ㅁ,ㅅ,ㅇ,ㄹ 순으로 배열한 것은 오행 원리와 연관이 있다.
자음과 오행의 관계 정리표
속성	계절	방위	음성	음계
목(木, 나무)	춘(春, 봄)	동(東, 동녘)	어금닛소리(ㄱ,ㅋ,ㄲ)	각(角)
화(火, 불)	하(夏, 여름)	남, (南, 남녘)	혓소리(ㄴ,ㄷ,ㅌ,ㄸ)	치(徵)
토(土, 흙)	계하 (季夏, 늦여름)	중앙(中, 無定)	입술소리(ㅁ,ㅂ,ㅍ,ㅃ,)	궁(宮)
금(金, 쇠)	추(秋, 가을)	서(西, 서녘)	잇소리(ㅅ,ㅆ,ㅈ,ㅊ,ㅉ)	상(商)
수(水, 물)	동(冬, 겨울)	북(北, 북녘)	목소리(ㅇ, ㅎ)	우(羽)
구조
한글은 낱소리 문자에 속하며, 낱자하나는 낱소리하나를 나타낸다. 낱소리는 닿소리(자음)와 홀소리(모음)로 이루어진다.

한 소리마디는 첫소리(초성), 가운뎃소리(중성), 끝소리(종성)의 낱소리 세 벌로 이루어지는데, 첫소리와 끝소리에는 닿소리를 쓰고 가운뎃소리에는 홀소리를 쓴다. 한글은 낱자를 하나씩 풀어쓰지 않고 하나의 글자 마디로 모아쓰는 특징을 가지고 있다.

낱자
<nowiki />이 부분의 본문은 한글 낱자입니다.
처음 한글 낱자는 닿소리 17자와 홀소리 11자로 총 28가지였다. 오늘날 한글 낱자에 쓰이지 않는 없어진 글자를 소실자(消失字)라 하는데, 닿소리 ㅿ(반시옷), ㆁ(옛이응), ㆆ(여린히읗)과 홀소리 ㆍ(아래아)의 네 글자이다. 이로써 현대 한글은 모두 24자로서 닿소리 14자와 홀소리 10자로 되었다. 낱자의 이름과 순서는 다음과 같다.

훈민정음 창제 당시에는 낱자 자체의 칭호법(稱號法)은 표시되어 있지 않았고, 중종 때 최세진의 《훈몽자회》에 이르러 각 낱자의 명칭이 붙게 되었다. 하지만 기역, 디귿, 시옷은 이두식 한자어 명칭을 그대로 사용하여 일제시대의 언문 철자법을 거쳐 지금까지 그대로 사용하게 되었다.[22]

각 자모에 대한 소릿값을 살펴보면, 첫소리 아·설·순·치·후(牙舌脣齒喉)와 반설·반치(反舌半齒)의 7음으로 구별하였고, 모음은 따로 구별하지 않았다. 이러한 7음과 각 자모의 독특한 배열 순서는 중국 운서(韻書)를 그대로 모방한 것이라고 여겨진다. 그리고 실제로 쓸 적에는 각 낱자를 독립시켜 소리 나는 차례대로 적지 않고, 반드시 닿소리와 홀소리를 어울려 쓰기로 하였으니, 곧 <· ㅡ ㅗ ㅜ ㅛ ㅠ >는 자음 아래에 쓰고, <ㅏ ㅓ ㅑ ㅕ>는 자음 오른쪽에 붙여 쓰기로 하였다. 즉 음절문자(音節文字)로 하되, 그 모양이 네모꼴이 되도록 하였으니, 이는 한자의 꼴에 영향을 받았기 때문이라 여겨진다.

닿소리
ㄱ	ㄴ	ㄷ	ㄹ	ㅁ	ㅂ	ㅅ	ㅇ	ㅈ	ㅊ	ㅋ	ㅌ	ㅍ	ㅎ
기윽/기역	니은	디읃/디귿	리을	미음	비읍	시읏/시옷	이응	지읒	치읓	키읔	티읕	피읖	히읗
홀소리
ㅏ	ㅑ	ㅓ	ㅕ	ㅗ	ㅛ	ㅜ	ㅠ	ㅡ	ㅣ
아	야	어	여	오	요	우	유	으	이
이 스물네 가지를 바탕으로 하는데 모두 홑소리(단음)이고, 홑소리로 나타낼 수 없는 겹소리(복음)는 두세 홑소리를 어울러서 적되, 그 이름과 순서는 다음과 같다.

겹닿소리
ㄲ	ㄸ	ㅃ	ㅆ	ㅉ
된기윽/쌍기역	된디읃/쌍디귿	된비읍/쌍비읍	된시읏/쌍시옷	된지읒/쌍지읒
겹홀소리
ㅐ	ㅒ	ㅔ	ㅖ	ㅘ	ㅙ	ㅚ	ㅝ	ㅞ	ㅟ	ㅢ
애	얘	에	예	와	왜	외	워	웨	위	의
소실자 닿소리
ㅿ	ㆁ	ㆆ
반시옷	옛이응	여린히읗
유성 치경 마찰음	연구개 비음	성문 파열음
반시옷은 알파벳의 z에 해당하는 음가를 가진 것으로 추정되며 여린히읗은 1을 강하게 발음 시 혀로 목구멍을 막으며 발음된다.

현대 한글에서는 끝소리가 없으면 받침을 쓰지 않고 끝소리가 있을 때에만 홑받침 또는 겹받침을 쓰는데, 홑받침에는 모든 닿소리가 쓰이며, 겹받침에는 홑홀소리 아래에만 놓이는 겹닿소리 ㄲ(쌍기역)과 ㅆ(쌍시옷)과 따로 이름이 없지만 모든 홀소리 아래에 놓일 수 있는 겹받침으로만 쓰이는 겹닿소리가 있다. 모든 받침의 소릿값은 끝소리 규칙에 따라 8갈래로 모인다.[23]

겹받침
ㄲ	ㅆ	ㄳ	ㄵ	ㄶ	ㄺ	ㄻ	ㄼ	ㄽ	ㄾ	ㄿ	ㅀ	ㅄ
받침의 소릿값
ㄱ	ㄴ	ㄷ	ㄹ	ㅁ	ㅂ	ㅇ
사전에 올릴 때에는 첫소리 > 가운뎃소리 > 끝소리의 순으로 정렬하되, 그 정렬 순서는 다음과 같다.

정렬 순서
첫소리	ㄱ ㄲ ㄴ ㄷ ㄸ ㄹ ㅁ ㅂ ㅃ ㅅ ㅆ ㅇ ㅈ ㅉ ㅊ ㅋ ㅌ ㅍ ㅎ
가운뎃소리	ㅏ ㅐ ㅑ ㅒ ㅓ ㅔ ㅕ ㅖ ㅗ ㅘ ㅙ ㅚ ㅛ ㅜ ㅝ ㅞ ㅟ ㅠ ㅡ ㅢ ㅣ
끝소리	( ) ㄱ ㄲ ㄳ ㄴ ㄵ ㄶ ㄷ ㄹ ㄺ ㄻ ㄼ ㄽ ㄾ ㄿ ㅀ ㅁ ㅂ ㅄ ㅅ ㅆ ㅇ ㅈ ㅊ ㅋ ㅌ ㅍ ㅎ
모아쓰기
한글의 모든 낱자는 한데 모아쓰도록 하고 있으며, 닿소리를 가장 먼저 쓰고 그 오른쪽이나 아래에 홀소리를 적으며, 모든 받침은 닿소리와 홀소리 밑에 놓인다. 따라서, 글자 마디로 모아쓸 때는 다음과 같은 틀에 맞추어 쓴다.

중성이 ㅏ, ㅐ, ㅑ, ㅒ, ㅓ, ㅔ, ㅕ, ㅖ, ㅣ일 때는 중성을 초성의 오른쪽에 붙여 쓴다.
초성	중성
초성	중성
종성
중성이 ㅗ, ㅛ, ㅜ, ㅠ, ㅡ일 때는 중성을 아래쪽에 붙여 쓴다. 종성이 있으면 그 아래 붙여 쓴다.
초성
중성
초성
중성
종성
중성이 ㅘ, ㅙ, ㅚ, ㅝ, ㅞ, ㅟ, ㅢ와 같이 아래쪽에 붙이는 모음과 오른쪽에 붙이는 모음의 복합일 때는 다음과 같이 아래쪽에 먼저, 그 다음 오른쪽에 붙여 쓴다. 종성은 마찬가지로 아래쪽에 붙여 쓴다.
초성	중성
중성
초성	중성
중성
종성
표기 가능한 글자 수와 소리나는 음절 개수
현대 한글은 낱자를 엮어 11,172(첫소리 19 × 가운뎃소리 21 × (끝소리 27 + 끝소리 없음 1))글자 마디를 쓸 수 있다. 11,172자 중 399자는 무받침 글자이며 10,773자는 받침 글자이다. 사용 빈도는 KS X 1001 완성형 한글 코드에 선별된 2,350글자가 상위 99.9%로 알려져 있다.[출처 필요]

어문 규정에 의하여, 현대 한국어 표준어에서 실제 사용하는 음절은 이보다 적다. 한국어의 소리는 첫소리+가운뎃소리(+끝소리)로 이루어지는데, 표준어에서 첫소리에는 19가지 닿소리가 모두 쓰이되 첫소리에 놓인 ㅇ은 소리 나지 않는다. 끝소리는 7종성법에 따라 7갈래로 모이며 끝소리가 없는 것까지 더하여 모두 8갈래이므로 현대 한국어의 발음은 첫소리 19 × 가운뎃소리 21 × 끝소리 8 = 3,192가지 소리가 된다.

그런데, 표준 발음법을 따르면 구개음 ㅈ, ㅉ, ㅊ 뒤의 이중 모음 ㅑ, ㅒ, ㅕ, ㅖ, ㅛ, ㅠ는 단모음 ㅏ, ㅐ, ㅓ, ㅔ, ㅗ, ㅜ로 소리나므로 첫소리 3 × 가운뎃소리 6 × 끝소리 8 = 144소리가 빠지고, 아울러 소리나는 첫소리 (ㅇ이 아닌 첫소리 뒤에 오는)를 얹은 가운뎃소리 [ㅢ]는 ㄴ을 제외하면(ㄴ의 경우는 구개음화에 따른 다른 음소로 인정하고 있다.) [ㅣ]로 소리나므로(한글 맞춤법 제9항 및 표준 발음법 제5항 단서 3) 첫소리 17 × 가운뎃소리 1 × 끝소리 8 = 136 소리가 다시 빠진다. 따라서, 현재 한국어 표준어에서 실제 사용하는 소리마디는 3192 − 144 − 136 = 2,912가지가 된다.

옛 한글의 경우, 2009년 10월 1일 발표된 유니코드 5.2에 포함되어 있는 옛 한글 자모의 총 개수는 초성 124개, 중성 95개, 종성 137개와 채움 문자 2개(초성, 중성)이다. 방점 2개는 현재 유니코드에 등록돼 있다. 방점을 제외하고, 총 조합 가능한 글자 마디 개수를 구한다면 다음과 같다.

조합 가능한 한글 코드(125×96×138): 1,656,000개
완성된 한글(124×95×138): 1,625,640개
조합 가능한 비표준 한글: 총 16,989개
채움 문자로만 구성된 한글: 1개
초성, 종성만 있는 비표준 한글(124×137): 16,988개
∴ 표준 한글 총 개수(조합 가능한 한글 코드 − 비표준 한글): 1,639,011개
한글의 유래
《세종실록》에 최만리가 훈민정음이 “고전(古篆)을 본땄다(倣)”라고 말한 기록이 있는데,[24][25] 이 말이 모호하기 때문에 여러 가지 해석이 있다. ‘고전’의 해석에는 한자의 전자체(篆字體)라는 설과 당시에 ‘몽고전자’(蒙古篆字)로도 불렸던 파스파 문자를 말하는 것이라는 설이 있다. 《환단고기》를 인정하는 사람은 이것이 가림토를 일컫는 말이라고 주장한다. 또한 ‘본땄다’(倣)에 대해서도 그 생김새만이 닮았을 뿐이라는 풀이와 만드는 데에 참고를 했다, 또는 모두 본땄다 등의 여러 가지 해석이 있다.

1940년 《훈민정음》(해례본)이 발견되기 이전에는 훈민정음의 창제 원리를 설명한 문헌이 존재하지 않아 그 유래에 대한 여러 이론이 제기되었다. 그 이전에 제기되었던 주요 학설은 다음과 같다.

발음 기관 상형설: 발음 기관을 상형했다는 설. 신경준(申景濬), 홍양호(洪良浩), 최현배
전자 기원설: 한문 비석 등에 쓰이는 전자체에서 유래되었다는 설. 황윤석(黃胤錫), 이능화
몽골 문자 기원설: 몽골문자(파스파)에서 유래했다는 설. 이익(李翼), 유희(柳僖), 게리 레드야드(Gari Ledyard)
범자(梵字) 기원설: 불경과 함께 고대 인도 문자가 전해져, 그것에서 유래했다는 설. 성현, 이수광(李晬光)
고대 문자 전래설: 훈민정음 이전 민간에서 전해지던 고대문자로부터 유래했다는 설.
창문 상형설: 한옥의 창살 모양에서 유래했다는 설. 에카르트(P. A. Eckardt)
서장(西藏)글자·오행(五行)이론.[26]
《훈민정음》(해례본)에는 자음과 모음 각각에 대한 창제 원리가 상세히 설명되어 기본 자음 5자는 발음 기관의 모양을 추상화하고, 기본 모음 3자는 천지인 3재를 상징하여 창제되었고 다른 글자들이 획을 덧붙이는 방식으로 만들어졌다고 분명히 밝힘으로써, 여러 이설들을 잠재우고 정설이 되었다.

한글에 관한 여러 이설
파스파 문자 기원설

(위) ’파스파 문자 ꡂ [k], ꡊ [t], ꡎ [p], ꡛ [s], ꡙ [l]와 그에 대응하는 것으로 여겨지는 한글 문자 ㄱ [k], ㄷ [t], ㅂ [p], ㅈ [ts], ㄹ [l].
(아래) 중국어를 표현하기 위한 파스파 문자 ꡯ w, ꡤ v, ꡰ f의 파생과 그의 변형 문자 ꡜ [h]
(왼쪽) 밑에 기호를 덧붙인 ꡧ [w][27] 와 유사한 중국어 표기용 한글 ㅱ w/m, ㅸ v, ㆄ f. 이 한글들은 기본자 ㅁ과 ㅇ에서 유래했다.
1966년 컬럼비아 대학의 게리 레드야드 교수는 그의 논문에서 훈민정음에서 언급한 고전(古篆)을 몽고전자(蒙古篆字)로 해석하며 한글이 파스파 문자에서 그 기하학적 모양을 차용했다고 주장했다.[28] 레드야드는 그 근거로 당시 조선의 궁에는 파스파 문자가 쓰이고 있었고, 집현전 학자 일부는 파스파 문자를 잘 알고 있었다는 점을 들며, 한글의 기본 자음은 ㄱ, ㄷ, ㅂ, ㅈ, ㄹ라고 제시했다.

레드야드에 따르면 이 다섯개의 글자는 그 모양이 단순화되어 파열음을 위한 가획을 할 수 있는 여지(ㅋ, ㅌ, ㅍ, ㅊ)를 만들어 냈다고 한다. 그는 전통적인 설명과는 다르게 비파열음 ㄴ, ㅁ, ㅅ은 기본자 ㄷ, ㅂ, ㅈ의 윗부분이 지워진 형태라 주장했다. 그는 ㅁ이 ㅂ의 윗부분을 지워서 파생되기는 쉽지만, ㅁ에서 ㅂ의 모양을 이끌어 내는 것은 불분명하다고 주장했다. 즉 다른 파열음과 같은 방법으로 파생되었다면 ㅂ의 모양은 ㅁ위에 한 획이 더해진 형태(ㄱ-ㅋ, ㄷ-ㅌ, ㅈ-ㅊ의 관계처럼)여야 한다는 것이다.

ㆁ자의 유래에 대한 설명도 기존과 다르다. 많은 중국 단어는 ng으로 시작하는데 세종대왕 집권 시기 즈음의 중국에서는 앞에 나오는 ng는 [ŋ]으로 발음하거나 발음하지 않았으며, 이런 단어가 한국어로 차용되었을 경우에도 이는 묵음이었다. 또한 논리적으로 추론 가능한 ng음의 모양은 ㄱ에서 가로 획을 제한 모양인데, 이는 모음 ㅣ과 구분하기 힘들었을 것이다. 따라서 세종대왕은 가로 획을 제한 ㄱ에 묵음이라는 뜻의 ㅇ을 더해 ㆁ을 만들었을 것이라 주장한다. 이는 단어 중간 혹은 끝에서의 [ŋ]의 발음과 단어 처음 부분에서의 묵음을 상징적으로 나타낼 수 있는 것이었다.

중국어를 표기하기 위한 다른 글자는 ㅱ이었는데 훈민정음은 이를 微(미)의 초성이라 설명했다. 이는 중국 방언에 따라 m 혹은 w로 발음되는데 한글에서는 ㅁ([m])과 ㅇ의 조합(이에 대응되는 파스파 문자에서는 [w]로 발음한다)으로 만들어졌다. 파스파 문자에서 글자 밑에 환형의 모양을 그리는 것은 모음 뒤의 w를 의미했다. 레드야드는 ㅱ자의 'ㅇ'모양이 이 과정을 통해 만들어 졌다고 주장했다.

마지막 증거로 레드야드는 ㄷ의 좌측 상단에 작게 삐져나온 형상(입술 모양으로)은 파스파 문자의 d와 유사하다는 점을 들었다. 이러한 입술 모양은 티베트 문자의 d인 ད에서도 찾아볼 수 있다.

만약 레드야드의 이러한 기원설이 사실이라면 한글은 파스파 문자→티베트 문자→브라미 문자→아람 문자를 거쳐 결국 중동 페니키아 문자의 일족에 속하게 된다. 하지만 파스파문자는 세계의 다른 고대문자들처럼 상형문자일 뿐만 아니라 각 글자가 한가지의 음을 나타내지 않고, 그 문자를 사용하던 언어권에 따라 각기 다른 음을 가졌을 것이기 때문에 한글과 같이 소리를 표기하는 문자와의 상관관계는 레드야드 혼자만이 인정하고 있다.

이에 대해 2009년 국어학자 정광(鄭光)은 훈민정음이 36개 중국어 초성을 기본으로 하는 등 파스파 문자로부터 일부 영향을 받았지만 글자를 만든 원리가 서로 다르며, 자음과 모음을 분리하여 독창적으로 만든 문자라고 반론하였다.[29]

기타 한글과 유사하다고 주장하는 문자
생김새가 한글과 유사한 문자가 있어서 한글 이전의 고대문자에 영향을 받았다는 주장이 있는데, 우연히 닮은 경우이거나 신뢰할 수 없는 출처를 근거로 하고 있다고 설명된다.

가림토와 신대 문자
송호수는 1984년 《광장(廣場)》 1월호 기고문에서 〈천부경〉과 《환단고기》〈태백일사〉를 참조하여 한글이 단군 시대부터 있었고, 단군조선의 가림다문(加臨多文)에서 한글과 일본의 아히루 문자가 기원했다고 주장하였다.[30] 이에 대하여 국어학자 이근수는 《광장(廣場)》 2월호의 기고문을 통하여 과학적 논증이 없는 이상 추론일 뿐이며, 참조한 고서의 대부분이 야사임을 지적하였다.[31] 또한 가림토 문자는 《환단고기》의 저자로 의심되고 있는 이유립이 한글의 모(母)문자로 창작한 가공의 문자일 가능성이 높아[32] 이러한 주장은 역사학계 및 언어학계에서 인정받지 못하고 있다.

일본의 신대 문자 중에서도 모습이 한글과 비슷한 것이 있어 이를 가림토와 연관이 있다고 주장하기도 하나, 신대 문자가 새겨져 있는 비석마다 문자의 모습이 달라 일관성이 없고 언어학자들이 추정하는 고대 일본어의 음운 구조와도 맞지 않으며,[33] 신대 문자가 기록되었다고 하는 유물 거의 전부가 18~19세기의 것이고 에도 시대 전의 것을 찾을 수 없는바, 신대 문자라는 것은 고대 일본에 문자가 있었다고 주장하기 위한 에도 시대의 위작이며, 특히 그 중에 한글과 유사한 것들은 오히려 한글을 모방한 것임이 밝혀졌다.[34]

구자라트 문자
1983년 9월 KBS가 방영한 8부작 다큐멘터리 《신왕오천축국전》은[35] 구자라트 문자를 소개하면서 '자음은 ㄱ, ㄴ, ㄷ, ㄹ, ㅁ, ㅅ, ㅇ 등이고, 모음은 ㅏ, ㅑ, ㅓ, ㅕ, ㅗ, ㅛ, ㅜ, ㅠ, ㅡ, ㅣ의 열 자가 꼭 같았으며, 받침까지도 비슷하게 쓰고 있었다'고 주장하였다.

또한, 개천학회 회장 송호수[36]는 1984년 이를 인용하면서 '자음에서는 상당수가 같고, 모음은 10자가 꼭 같다는 것이다'라고 썼다. 그는 구자라트 문자가 가림토에서 비롯되었다고 주장했다.[37][38]

그러나 구자라트 문자는 문자 구성상 자모로 완전히 분리되는 한글과는 달리 모든 자음이 딸림 모음을 수반하는 아부기다이며, 데바나가리 문자에서 수직선을 제거한 데바나가리 파생문자로서 다른 인도계 여러 문자와 친족 관계가 명확하게 밝혀져 있기 때문에 이는 구자라트 문자의 특정 글자체와 한글 사이의 표면적 유사성에 대한 착오일 뿐이다.[39]

다른 언어에서의 한글 사용
한글은 2009년에 처음으로 인도네시아의 소수 민족인 찌아찌아족의 언어인 찌아찌아어를 표기하는데 사용되었다.

이밖에도 한국에서는 한글을 표기 문자로 보급하기 위하여 노력하고 있으며 2012년 솔로몬제도의 토착어를 한글로 표기하여 교육하는 활동이 시작됐다. 2012년 10월부터 시행된 것은 2개 언어이며 결과에 따라 솔로몬제도 전역으로 확대할 예정이다.[40]

간혹, 영어 발음을 정확하게 표기하기 위해 옛 한글 등을 부활시킨 표기법을 연구하는 경우도 있으나, 이 역시 개인 연구자에 의한 것이다. 그리고 한국인이 아닌 사람이 만든 인공어618-Vuro나 인공 문자 井卜文(Jingbu Script) 등에서 일부 한글 또는 한글을 모티브로 한 문자를 개인 수준에서 사용한 예를 볼 수 있다.

오해와 사실
<nowiki />이 부분의 본문은 한글에 대한 오해입니다.
유네스코의 세계기록유산에 등재된 것은 한글이 아니라, 책《훈민정음》(해례본)이다.
유네스코 세계기록유산은 기록물이 담고 있는 내용이 아니라 기록물 자체만을 등록 대상으로 한다.
실제의 한글은 모든 언어의 발음을 표기할 수 있는 것이 아니다. 또한, 현재의 한글은 창제 당시의 훈민정음보다 표현할 수 있는 발음 수가 적다.
'모든 소리를 표현할 수 있다는 것'은 원래 언어학적 명제가 아니고, 창제 당시에 '모든 소리는 기본 5음의 조화로 이루어진다'는 사상을 배경으로 한 철학적 표현이다.
한글 낱자는 모두 소릿값이 확정되어 있고 실제 한글 쓰임에서는 모아쓰기의 규칙도 정해져 있으므로, 한글로 표현되는 소리의 숫자는 본래 유한하며, 한글은 기본적으로 한국어에 맞추어져 있다.
현재 한글은 한국어 발음에만 사용하고 있으나, 원래의 훈민정음에서는 모아쓰기가 좀 더 다양하며, 아울러 《동국정운》에 따르면 실제의 한국어 발음뿐만 아니라, 이론적인 한자음도 훈민정음으로써 표현하고 있다.
한글은 언어의 이름이 아니라 글자의 이름이다.
창제 당시의 이름인 '훈민정음'과 그 약칭인 '정음'도 본래 글자의 이름이었다.
찌아찌아족의 찌아찌아어의 표기에는 사용되나 공식은 아니다.
한글 자모일람
방언 한글 자모
㄰ㄱㄲㄳㄴㄵㄶㄷㄸㄹㄺㄻㄼㄽㄾㄿ

ㅀㅁㅂㅃㅄㅅㅆㅇㅈㅉㅊㅋㅌㅍㅎㅏ

ㅐㅑㅒㅓㅔㅕㅖㅗㅘㅙㅚㅛㅜㅝㅞㅟ

ㅠㅡㅢㅣㅤㅥㅦㅧㅨㅩㅪㅫㅬㅭㅮㅯ

ㅰㅱㅲㅳㅴㅵㅶㅷㅸㅹㅺㅻㅼㅽㅾㅿ

ㆀㆁㆂㆃㆄㆅㆆㆇㆈㆉㆊㆋㆌㆍㆎ㆏

고문 한글 자모
ᄀᄁᄂᄃᄄᄅᄆᄇᄈᄉᄊᄋᄌᄍᄎᄏ

ᄐᄑᄒᄓᄔᄕᄖᄗᄘᄙᄚᄛᄜᄝᄞᄟ

ᄠᄡᄢᄣᄤᄥᄦᄧᄨᄩᄪᄫᄬᄭᄮᄯ

ᄰᄱᄲᄳᄴᄵᄶᄷᄸᄹᄺᄻᄼᄽᄾᄿ

ᅐᅑᅒᅓᅔᅕᅖᅗᅘᅙᅚᅛᅜᅝᅞᅟ

복합원음와 보음
ᅠᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯ

ᅰᅱᅲᅳᅴᅵᅶᅷᅸᅹᅺᅻᅼᅽᅾᅿ

ᆀᆁᆂᆃᆄᆅᆆᆇᆈᆉᆊᆋᆌᆍᆎᆏ

ᆐᆑᆒᆓᆔᆕᆖᆗᆘᆙᆚᆛᆜᆝᆞᆟ

ᆠᆡᆢᆨᆩᆪᆫᆬᆭᆮᆯ

ᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿ

ᇀᇁᇂᇃᇄᇅᇆᇇᇈᇉᇊᇋᇌᇍᇎᇏ

ᇐᇑᇒᇓᇔᇕᇖᇗᇘᇙᇚᇛᇜᇝᇞᇟ

ᇠᇡᇢᇣᇤᇥᇦᇧᇨᇩᇪᇫᇬᇭᇮᇯ

ᇰᇱᇲᇳᇴᇵᇶᇷᇸᇹᇺᇻᇼᇽᇾᇿ

관련 항목
국어
세종대왕
주시경
한글의 우수성에 관한 논란
문자
한글 맞춤법
한글 낱자
한글 낱자 목록
한국어
한국어 로마자 표기법
한글전용과 국한문혼용
조선어 신철자법
옛 한글
훈민정음
한글날
한글 위키백과
한글의 모든 글자
한글을 표기하는 언어 목록
한국어
카리어
꽈라아에어[41]
찌아찌아어
각주
 이것은 훈민정음 창제 당시부터 보인다. 예컨대, 《세종실록》은 훈민정음 창제를 上親制諺文二十八字…是謂訓民正音(주상께서 친히 언문 28자를 만들어 … 이것을 훈민정음이라 이른다)이라고 기록하는데, 이것은 한글의 이름이거나 또는 굳이 한글만 지칭한 것은 아니고 한자 이외의 문자를 통칭하는 표현이다. 예컨대 《순조실록(純祖實錄)》 9년 12월 2일 기사에 역관 현의순(玄義洵)이 대마도의 사정을 보고한 글 가운데 敎之以諺文名之曰假名(언문을 가르치는데, 그 이름을 일러 가나라고 한다)과 같은 문장이 있어, 일본 문자에 대해서도 언문이라는 표현이 사용됨을 볼 수 있다.) 또한 《세종실록》 28년 11월 8일자에 언문청이라는 한글을 보급하는 구실을 하는 기관 이름이 나온다.
 한문을 지칭하는 ‘진서(眞書)’와 대비되는 표현이다.
 諺文字母俗所謂反切二十七字(세간에서 이른바 반절 27자라고 하는 언문 자모). 최세진(崔世珍), 〈범례(凡例)〉, 《훈몽자회(訓蒙字會)》. 1527. 반절은 본래 2개의 한자로 다른 한자음을 표기하는 방법을 말하며, 이렇게 소리의 표기에 사용된 글자를 반절자(反切字)라고 한다. 당시 훈민정음이 이와 비슷한 용법으로 한자음 표기에도 사용되었기 때문에 반절이라고 불렸던 것으로 보인다.
 1908년 설립한 ‘국어연구학회(國語硏究學會)’가 1911년 9월에 명칭을 바꾼 것으로, 공식적으로 한글과 한문 표기를 나란히 사용했다.
 ‘本會의 名稱을 한글모라 改稱하고 이 몯음을 세움몯음으로…’, 〈한글모세움몯음적발〉, 《한글모 죽보기》. 이규영. 1917.
 한글풀이의 수록이 확인되는 것은 1914년 3월의 제7호부터 1914년 7월의 제11호까지
 〈맞춤법〉, 《조선말규범집》. 북한(조선민주주의인민공화국) 내각직속 국어사정위원회. 1987.
 “훈민정음은 백성(百姓) 가르치시는 정(正)한 소리라”(현대어 표기로 옮김), 〈세종어제훈민정음〉, 《월인석보》. 1459년.
 癸亥冬我殿下創制正音二十八字略揭例義以示之名曰訓民正音 (계해년 겨울, 우리 전하께서 정음 28자를 창제하시어, 간략하게 예를 들어 보이시고 이름을 훈민정음이라 하셨다). 정인지,〈서(序)〉, 《훈민정음》. 1446년.
 “上親制諺文二十八字…是謂訓民正音”, 《세종실록》 25년 12월.
 정인지는 훈민정음을 지은 세종이 집현전 학자들에게 ‘해설서’의 편찬을 명했다고 적고 있다. 遂命詳加解釋以喩諸人…謹作諸解及例以敍其梗槪 (마침내, 해석을 상세히 더하여 사람들을 깨우치라고 명하시어… 여러 풀이와 예를 지어 그 개요를 펴내니), 정인지, 〈서〉, 《훈민정음》. 1446년.
 "錢下槍制', 《훈민정음 해례본》
 〈훈민정음 친제론〉, 이기문, 《한국문화》제13집. 서울대학교 규장각 한국학연구원, 1992년.
 '라랴러려' 분청사기..."16세기 지방 하층민도 한글 사용".YTN.2011-09-08.
 [1]
 第十四條 法律勅令總以國文爲本漢文附譯或用國漢文
 第九條 法律命令은 다 國文으로써 本을 삼꼬 漢譯을 附하며 或國漢文을 混用홈
 세계는 지금 '언어전쟁' 중
 “한글 홀대하는 사회”. 2012년 11월 30일에 원본 문서에서 보존된 문서. 2010년 2월 2일에 확인함.
 솔로몬제도 일부 주(州)서 표기문자로 한글 채택
 최현철 기자 (2010년 10월 20일). “‘천지인’ 개발자 특허권 기부 … 표준 제정 임박”. 중앙일보. 2012년 11월 15일에 확인함.
 [북녘말] 기윽 디읃 시읏 / 김태훈 : 칼럼 : 사설.칼럼 : 뉴스 : 한겨레
 然ㄱㆁㄷㄴㅂㅁㅅㄹ八字可足用也如ㅂ·ㅣㅅ곶爲梨花여ㅿ의갗爲狐皮而ㅅ字可以通用故只用ㅅ字 ,훈민정음 해례 종성해
 其字倣古篆分爲初中終聲合之然後乃成字 : (그 글자는 옛 전자(篆字)를 모방하고, 초·중·종성으로 나뉘어 그것을 합한 연후에 글자를 이룬다.) 《세종실록》 25년 12월 30일.
 象形而字倣古篆因聲而音叶七調 (물건의 형상을 본떠서 글자는 고전을 모방하고, 소리(聲)로 인(因)하여 음(音)은 칠조(七調)에 맞아). 《세종실록》28년 9월 29일. 이 기사는 《훈민정음》의 정인지 〈서(序)〉를 옮겨 놓은 것이다.
 글로벌세계대백과, 〈양반관료의 문화〉, 한글 창제.
 이 문자들은 확실히 증명되진 않았다. 어떤 필사본에는 ꡜ h에서 파생된 저 세 글자 모두 아래쪽이 환형으로 되어있기도 하다.
 "The Korean Language Reform of 1446", Gari Ledyard. (1966)
 ［Why］ 세종대왕 한글 창제가 '표절' 누명 쓰고 있다고?, 《조선닷컴》, 2009.10.10.
 "한글은 檀君시대부터 있었다" 송호수 교수 주장에 學界관심, 《경향신문》, 1984.1.12.
 한글 世宗전 創製 "터무니없다" 李覲洙교수, 宋鎬洙교수 主張 반박, 《경향신문》, 1984.2.6.
 문명, 《만들어진 한국사》, 파란, 2010
 "日 神代文字는 한글의 僞作이다", 《경향신문》, 1985.7.17.
 MBC 다큐멘터리 “미스터리 한글, 해례6211의 비밀”, 2007. 10. 7. 방송
 《新往五天竺國傳(신왕오천축국전)》. 문순태, KBS 특별취재반. 한국방송사업단, 1983. 참조
 당시 보도에는 S베일러대 교수로 소개되었다.
 〈한글은 세종 이전에도 있었다〉, 송호수,《廣場(광장)》1984년 1월호. 세계평화교수협의회.
 일본 神代文字 논란[깨진 링크(과거 내용 찾기)], 충북대학 국어국문학과 국어학강의실
 〈한글과 비슷한(?) 구자라트 문자〉, 김광해, 《새국어소식》1999년 10월호. 한국어문진흥회
 [2]
 섬나라 솔로몬제도 2개주도 한글 쓴다
참고 문헌
〈한글〉, 《한국민족문화대백과》. 한국학중앙연구원.
읽을거리
Portal icon	한국 포털
Portal icon	문화 포털
한글날에 생각해보는 훈민정음 미스터리. 김현미.《신동아》 2006년 10월호.
히브리문자 기원설을 계기로 본 훈민정음. 이기혁. 《신동아》 1997년 5월호.
어느 기하학자의 한글 창제. 《동아일보》, 2007-10-19. (영어의 v, f, θ, ð, l 등의 발음을 한글로 표기하기 - 고등과학원 최재경 교수의 제안)
'한글 연구가' 최성철씨 "이젠 한글표기법 독립운동할 때". 《동아일보》, 2006-10-09.
한글과 코드: 한글과 컴퓨터 코드에 관하여
외부 링크
	위키미디어 공용에 관련된 미디어 자료와 분류가 있습니다.
한글 (분류)
	위키낱말사전에
관련된 항목이 있습니다.
한글
디지털한글박물관
한글학회
한글재단
국립국어원
한글 듣기 테스트
"한글 자음 쓰기 영상" - 유튜브
"한글 모음 쓰기 영상" - 유튜브
Heckert GNU white.svgCc.logo.circle.svg 이 문서에는 다음커뮤니케이션(현 카카오)에서 GFDL 또는 CC-SA 라이선스로 배포한 글로벌 세계대백과사전의 "양반관료의 문화" 항목을 기초로 작성된 글이 포함되어 있습니다.
""";

/// Sample ASCII text: Genesis from the King James Bible (1604).
const genesis = """
Genesis

1.
In the beginning God created the heaven and the earth.
And the earth was without form, and void; and darkness was upon the face of the deep. And the Spirit of God moved upon the face of the waters.
And God said, Let there be light: and there was light.
And God saw the light, that it was good: and God divided the light from the darkness.
And God called the light Day, and the darkness he called Night. And the evening and the morning were the first day.
And God said, Let there be a firmament in the midst of the waters, and let it divide the waters from the waters.
And God made the firmament, and divided the waters which were under the firmament from the waters which were above the firmament: and it was so.
And God called the firmament Heaven. And the evening and the morning were the second day.
And God said, Let the waters under the heaven be gathered together unto one place, and let the dry land appear: and it was so.
And God called the dry land Earth; and the gathering together of the waters called he Seas: and God saw that it was good.
And God said, Let the earth bring forth grass, the herb yielding seed, and the fruit tree yielding fruit after his kind, whose seed is in itself, upon the earth: and it was so.
And the earth brought forth grass, and herb yielding seed after his kind, and the tree yielding fruit, whose seed was in itself, after his kind: and God saw that it was good.
And the evening and the morning were the third day.
And God said, Let there be lights in the firmament of the heaven to divide the day from the night; and let them be for signs, and for seasons, and for days, and years:
And let them be for lights in the firmament of the heaven to give light upon the earth: and it was so.
And God made two great lights; the greater light to rule the day, and the lesser light to rule the night: he made the stars also.
And God set them in the firmament of the heaven to give light upon the earth,
And to rule over the day and over the night, and to divide the light from the darkness: and God saw that it was good.
And the evening and the morning were the fourth day.
And God said, Let the waters bring forth abundantly the moving creature that hath life, and fowl that may fly above the earth in the open firmament of heaven.
And God created great whales, and every living creature that moveth, which the waters brought forth abundantly, after their kind, and every winged fowl after his kind: and God saw that it was good.
And God blessed them, saying, Be fruitful, and multiply, and fill the waters in the seas, and let fowl multiply in the earth.
And the evening and the morning were the fifth day.
And God said, Let the earth bring forth the living creature after his kind, cattle, and creeping thing, and beast of the earth after his kind: and it was so.
And God made the beast of the earth after his kind, and cattle after their kind, and every thing that creepeth upon the earth after his kind: and God saw that it was good.
And God said, Let us make man in our image, after our likeness: and let them have dominion over the fish of the sea, and over the fowl of the air, and over the cattle, and over all the earth, and over every creeping thing that creepeth upon the earth.
So God created man in his own image, in the image of God created he him; male and female created he them.
And God blessed them, and God said unto them, Be fruitful, and multiply, and replenish the earth, and subdue it: and have dominion over the fish of the sea, and over the fowl of the air, and over every living thing that moveth upon the earth.
And God said, Behold, I have given you every herb bearing seed, which is upon the face of all the earth, and every tree, in the which is the fruit of a tree yielding seed; to you it shall be for meat.
And to every beast of the earth, and to every fowl of the air, and to every thing that creepeth upon the earth, wherein there is life, I have given every green herb for meat: and it was so.
And God saw every thing that he had made, and, behold, it was very good. And the evening and the morning were the sixth day.

2.
Thus the heavens and the earth were finished, and all the host of them.
And on the seventh day God ended his work which he had made; and he rested on the seventh day from all his work which he had made.
And God blessed the seventh day, and sanctified it: because that in it he had rested from all his work which God created and made.
These are the generations of the heavens and of the earth when they were created, in the day that the LORD God made the earth and the heavens,
And every plant of the field before it was in the earth, and every herb of the field before it grew: for the LORD God had not caused it to rain upon the earth, and there was not a man to till the ground.
But there went up a mist from the earth, and watered the whole face of the ground.
And the LORD God formed man of the dust of the ground, and breathed into his nostrils the breath of life; and man became a living soul.
And the LORD God planted a garden eastward in Eden; and there he put the man whom he had formed.
And out of the ground made the LORD God to grow every tree that is pleasant to the sight, and good for food; the tree of life also in the midst of the garden, and the tree of knowledge of good and evil.
And a river went out of Eden to water the garden; and from thence it was parted, and became into four heads.
The name of the first is Pison: that is it which compasseth the whole land of Havilah, where there is gold;
And the gold of that land is good: there is bdellium and the onyx stone.
And the name of the second river is Gihon: the same is it that compasseth the whole land of Ethiopia.
And the name of the third river is Hiddekel: that is it which goeth toward the east of Assyria. And the fourth river is Euphrates.
And the LORD God took the man, and put him into the garden of Eden to dress it and to keep it.
And the LORD God commanded the man, saying, Of every tree of the garden thou mayest freely eat:
But of the tree of the knowledge of good and evil, thou shalt not eat of it: for in the day that thou eatest thereof thou shalt surely die.
And the LORD God said, It is not good that the man should be alone; I will make him an help meet for him.
And out of the ground the LORD God formed every beast of the field, and every fowl of the air; and brought them unto Adam to see what he would call them: and whatsoever Adam called every living creature, that was the name thereof.
And Adam gave names to all cattle, and to the fowl of the air, and to every beast of the field; but for Adam there was not found an help meet for him.
And the LORD God caused a deep sleep to fall upon Adam and he slept: and he took one of his ribs, and closed up the flesh instead thereof;
And the rib, which the LORD God had taken from man, made he a woman, and brought her unto the man.
And Adam said, This is now bone of my bones, and flesh of my flesh: she shall be called Woman, because she was taken out of Man.
Therefore shall a man leave his father and his mother, and shall cleave unto his wife: and they shall be one flesh.
And they were both naked, the man and his wife, and were not ashamed.

3.
Now the serpent was more subtil than any beast of the field which the LORD God had made. And he said unto the woman, Yea, hath God said, Ye shall not eat of every tree of the garden?
And the woman said unto the serpent, We may eat of the fruit of the trees of the garden:
But of the fruit of the tree which is in the midst of the garden, God hath said, Ye shall not eat of it, neither shall ye touch it, lest ye die.
And the serpent said unto the woman, Ye shall not surely die:
For God doth know that in the day ye eat thereof, then your eyes shall be opened, and ye shall be as gods, knowing good and evil.
And when the woman saw that the tree was good for food, and that it was pleasant to the eyes, and a tree to be desired to make one wise, she took of the fruit thereof, and did eat, and gave also unto her husband with her; and he did eat.
And the eyes of them both were opened, and they knew that they were naked; and they sewed fig leaves together, and made themselves aprons.
And they heard the voice of the LORD God walking in the garden in the cool of the day: and Adam and his wife hid themselves from the presence of the LORD God amongst the trees of the garden.
And the LORD God called unto Adam, and said unto him, Where art thou?
And he said, I heard thy voice in the garden, and I was afraid, because I was naked; and I hid myself.
And he said, Who told thee that thou wast naked? Hast thou eaten of the tree, whereof I commanded thee that thou shouldest not eat?
And the man said, The woman whom thou gavest to be with me, she gave me of the tree, and I did eat.
And the LORD God said unto the woman, What is this that thou hast done? And the woman said, The serpent beguiled me, and I did eat.
And the LORD God said unto the serpent, Because thou hast done this, thou art cursed above all cattle, and above every beast of the field; upon thy belly shalt thou go, and dust shalt thou eat all the days of thy life:
And I will put enmity between thee and the woman, and between thy seed and her seed; it shall bruise thy head, and thou shalt bruise his heel.
Unto the woman he said, I will greatly multiply thy sorrow and thy conception; in sorrow thou shalt bring forth children; and thy desire shall be to thy husband, and he shall rule over thee.
And unto Adam he said, Because thou hast hearkened unto the voice of thy wife, and hast eaten of the tree, of which I commanded thee, saying, Thou shalt not eat of it: cursed is the ground for thy sake; in sorrow shalt thou eat of it all the days of thy life;
Thorns also and thistles shall it bring forth to thee; and thou shalt eat the herb of the field;
In the sweat of thy face shalt thou eat bread, till thou return unto the ground; for out of it wast thou taken: for dust thou art, and unto dust shalt thou return.
And Adam called his wife's name Eve; because she was the mother of all living.
Unto Adam also and to his wife did the LORD God make coats of skins, and clothed them.
And the LORD God said, Behold, the man is become as one of us, to know good and evil: and now, lest he put forth his hand, and take also of the tree of life, and eat, and live for ever:
Therefore the LORD God sent him forth from the garden of Eden, to till the ground from whence he was taken.
So he drove out the man; and he placed at the east of the garden of Eden Cherubims, and a flaming sword which turned every way, to keep the way of the tree of life.

4.
And Adam knew Eve his wife; and she conceived, and bare Cain, and said, I have gotten a man from the LORD.
And she again bare his brother Abel. And Abel was a keeper of sheep, but Cain was a tiller of the ground.
And in process of time it came to pass, that Cain brought of the fruit of the ground an offering unto the LORD.
And Abel, he also brought of the firstlings of his flock and of the fat thereof. And the LORD had respect unto Abel and to his offering:
But unto Cain and to his offering he had not respect. And Cain was very wroth, and his countenance fell.
And the LORD said unto Cain, Why art thou wroth? and why is thy countenance fallen?
If thou doest well, shalt thou not be accepted? and if thou doest not well, sin lieth at the door. And unto thee shall be his desire, and thou shalt rule over him.
And Cain talked with Abel his brother: and it came to pass, when they were in the field, that Cain rose up against Abel his brother, and slew him.
And the LORD said unto Cain, Where is Abel thy brother? And he said, I know not: Am I my brother's keeper?
And he said, What hast thou done? the voice of thy brother's blood crieth unto me from the ground.
And now art thou cursed from the earth, which hath opened her mouth to receive thy brother's blood from thy hand;
When thou tillest the ground, it shall not henceforth yield unto thee her strength; a fugitive and a vagabond shalt thou be in the earth.
And Cain said unto the LORD, My punishment is greater than I can bear.
Behold, thou hast driven me out this day from the face of the earth; and from thy face shall I be hid; and I shall be a fugitive and a vagabond in the earth; and it shall come to pass, that every one that findeth me shall slay me.
And the LORD said unto him, Therefore whosoever slayeth Cain, vengeance shall be taken on him sevenfold. And the LORD set a mark upon Cain, lest any finding him should kill him.
And Cain went out from the presence of the LORD, and dwelt in the land of Nod, on the east of Eden.
And Cain knew his wife; and she conceived, and bare Enoch: and he builded a city, and called the name of the city, after the name of his son, Enoch.
And unto Enoch was born Irad: and Irad begat Mehujael: and Mehujael begat Methusael: and Methusael begat Lamech.
And Lamech took unto him two wives: the name of the one was Adah, and the name of the other Zillah.
And Adah bare Jabal: he was the father of such as dwell in tents, and of such as have cattle.
And his brother's name was Jubal: he was the father of all such as handle the harp and organ.
And Zillah, she also bare Tubal-cain, an instructer of every artificer in brass and iron: and the sister of Tubal-cain was Naamah.
And Lamech said unto his wives, Adah and Zillah, Hear my voice; ye wives of Lamech, hearken unto my speech: for I have slain a man to my wounding, and a young man to my hurt.
If Cain shall be avenged sevenfold, truly Lamech seventy and sevenfold.
And Adam knew his wife again; and she bare a son, and called his name Seth: For God, said she, hath appointed me another seed instead of Abel, whom Cain slew.
And to Seth, to him also there was born a son; and he called his name Enos: then began men to call upon the name of the LORD.

5.
This is the book of the generations of Adam. In the day that God created man, in the likeness of God made he him;
Male and female created he them; and blessed them, and called their name Adam, in the day when they were created.
And Adam lived an hundred and thirty years, and begat a son in his own likeness, after his image; and called his name Seth:
And the days of Adam after he had begotten Seth were eight hundred years: and he begat sons and daughters:
And all the days that Adam lived were nine hundred and thirty years: and he died.
And Seth lived an hundred and five years, and begat Enos:
And Seth lived after he begat Enos eight hundred and seven years, and begat sons and daughters:
And all the days of Seth were nine hundred and twelve years: and he died.
And Enos lived ninety years, and begat Cainan:
And Enos lived after he begat Cainan eight hundred and fifteen years, and begat sons and daughters:
And all the days of Enos were nine hundred and five years: and he died.
And Cainan lived seventy years, and begat Mahalaleel:
And Cainan lived after he begat Mahalaleel eight hundred and forty years, and begat sons and daughters:
And all the days of Cainan were nine hundred and ten years: and he died.
And Mahalaleel lived sixty and five years, and begat Jared:
And Mahalaleel lived after he begat Jared eight hundred and thirty years, and begat sons and daughters:
And all the days of Mahalaleel were eight hundred ninety and five years: and he died.
And Jared lived an hundred sixty and two years, and he begat Enoch:
And Jared lived after he begat Enoch eight hundred years, and begat sons and daughters:
And all the days of Jared were nine hundred sixty and two years: and he died.
And Enoch lived sixty and five years, and begat Methuselah:
And Enoch walked with God after he begat Methuselah three hundred years, and begat sons and daughters:
And all the days of Enoch were three hundred sixty and five years:
And Enoch walked with God: and he was not; for God took him.
And Methuselah lived an hundred eighty and seven years, and begat Lamech:
And Methuselah lived after he begat Lamech seven hundred eighty and two years, and begat sons and daughters:
And all the days of Methuselah were nine hundred sixty and nine years: and he died.
And Lamech lived an hundred eighty and two years, and begat a son:
And he called his name Noah, saying, This same shall comfort us concerning our work and toil of our hands, because of the ground which the LORD hath cursed.
And Lamech lived after he begat Noah five hundred ninety and five years, and begat sons and daughters:
And all the days of Lamech were seven hundred seventy and seven years: and he died.
And Noah was five hundred years old: and Noah begat Shem, Ham, and Japheth.

6.
And it came to pass, when men began to multiply on the face of the earth, and daughters were born unto them,
That the sons of God saw the daughters of men that they were fair; and they took them wives of all which they chose.
And the LORD said, My spirit shall not always strive with man, for that he also is flesh: yet his days shall be an hundred and twenty years.
There were giants in the earth in those days; and also after that, when the sons of God came in unto the daughters of men, and they bare children to them, the same became mighty men which were of old, men of renown.
And GOD saw that the wickedness of man was great in the earth, and that every imagination of the thoughts of his heart was only evil continually.
And it repented the LORD that he had made man on the earth, and it grieved him at his heart.
And the LORD said, I will destroy man whom I have created from the face of the earth; both man, and beast, and the creeping thing, and the fowls of the air; for it repenteth me that I have made them.
But Noah found grace in the eyes of the LORD.
These are the generations of Noah: Noah was a just man and perfect in his generations, and Noah walked with God.
And Noah begat three sons, Shem, Ham, and Japheth.
The earth also was corrupt before God, and the earth was filled with violence.
And God looked upon the earth, and, behold, it was corrupt; for all flesh had corrupted his way upon the earth.
And God said unto Noah, The end of all flesh is come before me; for the earth is filled with violence through them; and, behold, I will destroy them with the earth.
Make thee an ark of gopher wood; rooms shalt thou make in the ark, and shalt pitch it within and without with pitch.
And this is the fashion which thou shalt make it of: The length of the ark shall be three hundred cubits, the breadth of it fifty cubits, and the height of it thirty cubits.
A window shalt thou make to the ark, and in a cubit shalt thou finish it above; and the door of the ark shalt thou set in the side thereof; with lower, second, and third stories shalt thou make it.
And, behold, I, even I, do bring a flood of waters upon the earth, to destroy all flesh, wherein is the breath of life, from under heaven; and every thing that is in the earth shall die.
But with thee will I establish my covenant; and thou shalt come into the ark, thou, and thy sons, and thy wife, and thy sons' wives with thee.
And of every living thing of all flesh, two of every sort shalt thou bring into the ark, to keep them alive with thee; they shall be male and female.
Of fowls after their kind, and of cattle after their kind, of every creeping thing of the earth after his kind, two of every sort shall come unto thee, to keep them alive.
And take thou unto thee of all food that is eaten, and thou shalt gather it to thee; and it shall be for food for thee, and for them.
Thus did Noah; according to all that God commanded him, so did he.

7.
And the LORD said unto Noah, Come thou and all thy house into the ark; for thee have I seen righteous before me in this generation.
Of every clean beast thou shalt take to thee by sevens, the male and his female: and of beasts that are not clean by two, the male and his female.
Of fowls also of the air by sevens, the male and the female; to keep seed alive upon the face of all the earth.
For yet seven days, and I will cause it to rain upon the earth forty days and forty nights; and every living substance that I have made will I destroy from off the face of the earth.
And Noah did according unto all that the LORD commanded him.
And Noah was six hundred years old when the flood of waters was upon the earth.
And Noah went in, and his sons, and his wife, and his sons' wives with him, into the ark, because of the waters of the flood.
Of clean beasts, and of beasts that are not clean, and of fowls, and of every thing that creepeth upon the earth,
There went in two and two unto Noah into the ark, the male and the female, as God had commanded Noah.
And it came to pass after seven days, that the waters of the flood were upon the earth.
In the six hundredth year of Noah's life, in the second month, the seventeenth day of the month, the same day were all the fountains of the great deep broken up, and the windows of heaven were opened.
And the rain was upon the earth forty days and forty nights.
In the selfsame day entered Noah, and Shem, and Ham, and Japheth, the sons of Noah, and Noah's wife, and the three wives of his sons with them, into the ark;
They, and every beast after his kind, and all the cattle after their kind, and every creeping thing that creepeth upon the earth after his kind, and every fowl after his kind, every bird of every sort.
And they went in unto Noah into the ark, two and two of all flesh, wherein is the breath of life.
And they that went in, went in male and female of all flesh, as God had commanded him: and the LORD shut him in.
And the flood was forty days upon the earth; and the waters increased, and bare up the ark, and it was lift up above the earth.
And the waters prevailed, and were increased greatly upon the earth; and the ark went upon the face of the waters.
And the waters prevailed exceedingly upon the earth; and all the high hills, that were under the whole heaven, were covered.
Fifteen cubits upward did the waters prevail; and the mountains were covered.
And all flesh died that moved upon the earth, both of fowl, and of cattle, and of beast, and of every creeping thing that creepeth upon the earth, and every man:
All in whose nostrils was the breath of life, of all that was in the dry land, died.
And every living substance was destroyed which was upon the face of the ground, both man, and cattle, and the creeping things, and the fowl of the heaven; and they were destroyed from the earth: and Noah only remained alive, and they that were with him in the ark.
And the waters prevailed upon the earth an hundred and fifty days.

8.
And God remembered Noah, and every living thing, and all the cattle that was with him in the ark: and God made a wind to pass over the earth, and the waters asswaged;
The fountains also of the deep and the windows of heaven were stopped, and the rain from heaven was restrained;
And the waters returned from off the earth continually: and after the end of the hundred and fifty days the waters were abated.
And the ark rested in the seventh month, on the seventeenth day of the month, upon the mountains of Ararat.
And the waters decreased continually until the tenth month: in the tenth month, on the first day of the month, were the tops of the mountains seen.
And it came to pass at the end of forty days, that Noah opened the window of the ark which he had made:
And he sent forth a raven, which went forth to and fro, until the waters were dried up from off the earth.
Also he sent forth a dove from him, to see if the waters were abated from off the face of the ground;
But the dove found no rest for the sole of her foot, and she returned unto him into the ark, for the waters were on the face of the whole earth: then he put forth his hand, and took her, and pulled her in unto him into the ark.
And he stayed yet other seven days; and again he sent forth the dove out of the ark;
And the dove came in to him in the evening; and, lo, in her mouth was an olive leaf pluckt off: so Noah knew that the waters were abated from off the earth.
And he stayed yet other seven days; and sent forth the dove; which returned not again unto him any more.
And it came to pass in the six hundredth and first year, in the first month, the first day of the month, the waters were dried up from off the earth: and Noah removed the covering of the ark, and looked, and, behold, the face of the ground was dry.
And in the second month, on the seven and twentieth day of the month, was the earth dried.
And God spake unto Noah, saying,
Go forth of the ark, thou, and thy wife, and thy sons, and thy sons' wives with thee.
Bring forth with thee every living thing that is with thee, of all flesh, both of fowl, and of cattle, and of every creeping thing that creepeth upon the earth; that they may breed abundantly in the earth, and be fruitful, and multiply upon the earth.
And Noah went forth, and his sons, and his wife, and his sons' wives with him:
Every beast, every creeping thing, and every fowl, and whatsoever creepeth upon the earth, after their kinds, went forth out of the ark.
And Noah builded an altar unto the LORD; and took of every clean beast, and of every clean fowl, and offered burnt offerings on the altar.
And the LORD smelled a sweet savour; and the LORD said in his heart, I will not again curse the ground any more for man's sake; for the imagination of man's heart is evil from his youth; neither will I again smite any more every thing living, as I have done.
While the earth remaineth, seedtime and harvest, and cold and heat, and summer and winter, and day and night shall not cease.

9.
And God blessed Noah and his sons, and said unto them, Be fruitful, and multiply, and replenish the earth.
And the fear of you and the dread of you shall be upon every beast of the earth, and upon every fowl of the air, upon all that moveth upon the earth, and upon all the fishes of the sea; into your hand are they delivered.
Every moving thing that liveth shall be meat for you; even as the green herb have I given you all things.
But flesh with the life thereof, which is the blood thereof, shall ye not eat.
And surely your blood of your lives will I require; at the hand of every beast will I require it, and at the hand of man; at the hand of every man's brother will I require the life of man.
Whoso sheddeth man's blood, by man shall his blood be shed: for in the image of God made he man.
And you, be ye fruitful, and multiply; bring forth abundantly in the earth, and multiply therein.
And God spake unto Noah, and to his sons with him, saying,
And I, behold, I establish my covenant with you, and with your seed after you;
And with every living creature that is with you, of the fowl, of the cattle, and of every beast of the earth with you; from all that go out of the ark, to every beast of the earth.
And I will establish my covenant with you; neither shall all flesh be cut off any more by the waters of a flood; neither shall there any more be a flood to destroy the earth.
And God said, This is the token of the covenant which I make between me and you and every living creature that is with you, for perpetual generations:
I do set my bow in the cloud, and it shall be for a token of a covenant between me and the earth.
And it shall come to pass, when I bring a cloud over the earth, that the bow shall be seen in the cloud:
And I will remember my covenant, which is between me and you and every living creature of all flesh; and the waters shall no more become a flood to destroy all flesh.
And the bow shall be in the cloud; and I will look upon it, that I may remember the everlasting covenant between God and every living creature of all flesh that is upon the earth.
And God said unto Noah, This is the token of the covenant, which I have established between me and all flesh that is upon the earth.
And the sons of Noah, that went forth of the ark, were Shem, and Ham, and Japheth: and Ham is the father of Canaan.
These are the three sons of Noah: and of them was the whole earth overspread.
And Noah began to be an husbandman, and he planted a vineyard:
And he drank of the wine, and was drunken; and he was uncovered within his tent.
And Ham, the father of Canaan, saw the nakedness of his father, and told his two brethren without.
And Shem and Japheth took a garment, and laid it upon both their shoulders, and went backward, and covered the nakedness of their father; and their faces were backward, and they saw not their father's nakedness.
And Noah awoke from his wine, and knew what his younger son had done unto him.
And he said, Cursed be Canaan; a servant of servants shall he be unto his brethren.
And he said, Blessed be the LORD God of Shem; and Canaan shall be his servant.
God shall enlarge Japheth, and he shall dwell in the tents of Shem; and Canaan shall be his servant.
And Noah lived after the flood three hundred and fifty years.
And all the days of Noah were nine hundred and fifty years: and he died.

10.
Now these are the generations of the sons of Noah, Shem, Ham, and Japheth: and unto them were sons born after the flood.
The sons of Japheth; Gomer, and Magog, and Madai, and Javan, and Tubal, and Meshech, and Tiras.
And the sons of Gomer; Ashkenaz, and Riphath, and Togarmah.
And the sons of Javan; Elishah, and Tarshish, Kittim, and Dodanim.
By these were the isles of the Gentiles divided in their lands; every one after his tongue, after their families, in their nations.
And the sons of Ham; Cush, and Mizraim, and Phut, and Canaan.
And the sons of Cush; Seba, and Havilah, and Sabtah, and Raamah, and Sabtecha: and the sons of Raamah; Sheba, and Dedan.
And Cush begat Nimrod: he began to be a mighty one in the earth.
He was a mighty hunter before the LORD: wherefore it is said, Even as Nimrod the mighty hunter before the LORD.
And the beginning of his kingdom was Babel, and Erech, and Accad, and Calneh, in the land of Shinar.
Out of that land went forth Asshur, and builded Nineveh, and the city Rehoboth, and Calah,
And Resen between Nineveh and Calah: the same is a great city.
And Mizraim begat Ludim, and Anamim, and Lehabim, and Naphtuhim,
And Pathrusim, and Casluhim, (out of whom came Philistim,) and Caphtorim.
And Canaan begat Sidon his firstborn, and Heth,
And the Jebusite, and the Amorite, and the Girgasite,
And the Hivite, and the Arkite, and the Sinite,
And the Arvadite, and the Zemarite, and the Hamathite: and afterward were the families of the Canaanites spread abroad.
And the border of the Canaanites was from Sidon, as thou comest to Gerar, unto Gaza; as thou goest, unto Sodom, and Gomorrah, and Admah, and Zeboim, even unto Lasha.
These are the sons of Ham, after their families, after their tongues, in their countries, and in their nations.
Unto Shem also, the father of all the children of Eber, the brother of Japheth the elder, even to him were children born.
The children of Shem; Elam, and Asshur, and Arphaxad, and Lud, and Aram.
And the children of Aram; Uz, and Hul, and Gether, and Mash.
And Arphaxad begat Salah; and Salah begat Eber.
And unto Eber were born two sons: the name of one was Peleg; for in his days was the earth divided; and his brother's name was Joktan.
And Joktan begat Almodad, and Sheleph, and Hazar-maveth, and Jerah,
And Hadoram, and Uzal, and Diklah,
And Obal, and Abimael, and Sheba,
And Ophir, and Havilah, and Jobab: all these were the sons of Joktan.
And their dwelling was from Mesha, as thou goest unto Sephar a mount of the east.
These are the sons of Shem, after their families, after their tongues, in their lands, after their nations.
These are the families of the sons of Noah, after their generations, in their nations: and by these were the nations divided in the earth after the flood.

11.
And the whole earth was of one language, and of one speech.
And it came to pass, as they journeyed from the east, that they found a plain in the land of Shinar; and they dwelt there.
And they said one to another, Go to, let us make brick, and burn them throughly. And they had brick for stone, and slime had they for morter.
And they said, Go to, let us build us a city and a tower, whose top may reach unto heaven; and let us make us a name, lest we be scattered abroad upon the face of the whole earth.
And the LORD came down to see the city and the tower, which the children of men builded.
And the LORD said, Behold, the people is one, and they have all one language; and this they begin to do: and now nothing will be restrained from them, which they have imagined to do.
Go to, let us go down, and there confound their language, that they may not understand one another's speech.
So the LORD scattered them abroad from thence upon the face of all the earth: and they left off to build the city.
Therefore is the name of it called Babel; because the LORD did there confound the language of all the earth: and from thence did the LORD scatter them abroad upon the face of all the earth.
These are the generations of Shem: Shem was an hundred years old, and begat Arphaxad two years after the flood:
And Shem lived after he begat Arphaxad five hundred years, and begat sons and daughters.
And Arphaxad lived five and thirty years, and begat Salah:
And Arphaxad lived after he begat Salah four hundred and three years, and begat sons and daughters.
And Salah lived thirty years, and begat Eber:
And Salah lived after he begat Eber four hundred and three years, and begat sons and daughters.
And Eber lived four and thirty years, and begat Peleg:
And Eber lived after he begat Peleg four hundred and thirty years, and begat sons and daughters.
And Peleg lived thirty years, and begat Reu:
And Peleg lived after he begat Reu two hundred and nine years, and begat sons and daughters.
And Reu lived two and thirty years, and begat Serug:
And Reu lived after he begat Serug two hundred and seven years, and begat sons and daughters.
And Serug lived thirty years, and begat Nahor:
And Serug lived after he begat Nahor two hundred years, and begat sons and daughters.
And Nahor lived nine and twenty years, and begat Terah:
And Nahor lived after he begat Terah an hundred and nineteen years, and begat sons and daughters.
And Terah lived seventy years, and begat Abram, Nahor, and Haran.
Now these are the generations of Terah: Terah begat Abram, Nahor, and Haran; and Haran begat Lot.
And Haran died before his father Terah in the land of his nativity, in Ur of the Chaldees.
And Abram and Nahor took them wives: the name of Abram's wife was Sarai; and the name of Nahor's wife, Milcah, the daughter of Haran, the father of Milcah, and the father of Iscah.
But Sarai was barren; she had no child.
And Terah took Abram his son, and Lot the son of Haran his son's son, and Sarai his daughter in law, his son Abram's wife; and they went forth with them from Ur of the Chaldees, to go into the land of Canaan; and they came unto Haran, and dwelt there.
And the days of Terah were two hundred and five years: and Terah died in Haran.

12.
Now the LORD had said unto Abram, Get thee out of thy country, and from thy kindred, and from thy father's house, unto a land that I will shew thee:
And I will make of thee a great nation, and I will bless thee, and make thy name great; and thou shalt be a blessing:
And I will bless them that bless thee, and curse him that curseth thee: and in thee shall all families of the earth be blessed.
So Abram departed, as the LORD had spoken unto him; and Lot went with him: and Abram was seventy and five years old when he departed out of Haran.
And Abram took Sarai his wife, and Lot his brother's son, and all their substance that they had gathered, and the souls that they had gotten in Haran; and they went forth to go into the land of Canaan; and into the land of Canaan they came.
And Abram passed through the land unto the place of Sichem, unto the plain of Moreh. And the Canaanite was then in the land.
And the LORD appeared unto Abram, and said, Unto thy seed will I give this land: and there builded he an altar unto the LORD, who appeared unto him.
And he removed from thence unto a mountain on the east of Bethel, and pitched his tent, having Bethel on the west, and Hai on the east: and there he builded an altar unto the LORD, and called upon the name of the LORD.
And Abram journeyed, going on still toward the south.
And there was a famine in the land: and Abram went down into Egypt to sojourn there; for the famine was grievous in the land.
And it came to pass, when he was come near to enter into Egypt, that he said unto Sarai his wife, Behold now, I know that thou art a fair woman to look upon:
Therefore it shall come to pass, when the Egyptians shall see thee, that they shall say, This is his wife: and they will kill me, but they will save thee alive.
Say, I pray thee, thou art my sister: that it may be well with me for thy sake; and my soul shall live because of thee.
And it came to pass, that, when Abram was come into Egypt, the Egyptians beheld the woman that she was very fair.
The princes also of Pharaoh saw her, and commended her before Pharaoh: and the woman was taken into Pharaoh's house.
And he entreated Abram well for her sake: and he had sheep, and oxen, and he asses, and menservants, and maidservants, and she asses, and camels.
And the LORD plagued Pharaoh and his house with great plagues because of Sarai Abram's wife.
And Pharaoh called Abram, and said, What is this that thou hast done unto me? why didst thou not tell me that she was thy wife?
Why saidst thou, She is my sister? so I might have taken her to me to wife: now therefore behold thy wife, take her, and go thy way.
And Pharaoh commanded his men concerning him: and they sent him away, and his wife, and all that he had.

13.
And Abram went up out of Egypt, he, and his wife, and all that he had, and Lot with him, into the south.
And Abram was very rich in cattle, in silver, and in gold.
And he went on his journeys from the south even to Bethel, unto the place where his tent had been at the beginning, between Bethel and Hai;
Unto the place of the altar, which he had made there at the first: and there Abram called on the name of the LORD.
And Lot also, which went with Abram, had flocks, and herds, and tents.
And the land was not able to bear them, that they might dwell together: for their substance was great, so that they could not dwell together.
And there was a strife between the herdmen of Abram's cattle and the herdmen of Lot's cattle: and the Canaanite and the Perizzite dwelled then in the land.
And Abram said unto Lot, Let there be no strife, I pray thee, between me and thee, and between my herdmen and thy herdmen; for we be brethren.
Is not the whole land before thee? separate thyself, I pray thee, from me: if thou wilt take the left hand, then I will go to the right; or if thou depart to the right hand, then I will go to the left.
And Lot lifted up his eyes, and beheld all the plain of Jordan, that it was well watered every where, before the LORD destroyed Sodom and Gomorrah, even as the garden of the LORD, like the land of Egypt, as thou comest unto Zoar.
Then Lot chose him all the plain of Jordan; and Lot journeyed east: and they separated themselves the one from the other.
Abram dwelled in the land of Canaan, and Lot dwelled in the cities of the plain, and pitched his tent toward Sodom.
But the men of Sodom were wicked and sinners before the LORD exceedingly.
And the LORD said unto Abram, after that Lot was separated from him, Lift up now thine eyes, and look from the place where thou art northward, and southward, and eastward, and westward:
For all the land which thou seest, to thee will I give it, and to thy seed for ever.
And I will make thy seed as the dust of the earth: so that if a man can number the dust of the earth, then shall thy seed also be numbered.
Arise, walk through the land in the length of it and in the breadth of it; for I will give it unto thee.
Then Abram removed his tent, and came and dwelt in the plain of Mamre, which is in Hebron, and built there an altar unto the LORD.

14.
And it came to pass in the days of Amraphel king of Shinar, Arioch king of Ellasar, Chedorlaomer king of Elam, and Tidal king of nations;
That these made war with Bera king of Sodom, and with Birsha king of Gomorrah, Shinab king of Admah, and Shemeber king of Zeboiim, and the king of Bela, which is Zoar.
All these were joined together in the vale of Siddim, which is the salt sea.
Twelve years they served Chedorlaomer, and in the thirteenth year they rebelled.
And in the fourteenth year came Chedorlaomer, and the kings that were with him, and smote the Rephaims in Ashteroth Karnaim, and the Zuzims in Ham, and the Emims in Shaveh Kiriathaim,
And the Horites in their mount Seir, unto El-paran, which is by the wilderness.
And they returned, and came to En-mishpat, which is Kadesh, and smote all the country of the Amalekites, and also the Amorites that dwelt in Hazezon-tamar.
And there went out the king of Sodom, and the king of Gomorrah, and the king of Admah, and the king of Zeboiim, and the king of Bela (the same is Zoar;) and they joined battle with them in the vale of Siddim;
With Chedorlaomer the king of Elam, and with Tidal king of nations, and Amraphel king of Shinar, and Arioch king of Ellasar; four kings with five.
And the vale of Siddim was full of slimepits; and the kings of Sodom and Gomorrah fled, and fell there; and they that remained fled to the mountain.
And they took all the goods of Sodom and Gomorrah, and all their victuals, and went their way.
And they took Lot, Abram's brother's son, who dwelt in Sodom, and his goods, and departed.
And there came one that had escaped, and told Abram the Hebrew; for he dwelt in the plain of Mamre the Amorite, brother of Eschol, and brother of Aner: and these were confederate with Abram.
And when Abram heard that his brother was taken captive, he armed his trained servants, born in his own house, three hundred and eighteen, and pursued them unto Dan.
And he divided himself against them, he and his servants, by night, and smote them, and pursued them unto Hobah, which is on the left hand of Damascus.
And he brought back all the goods, and also brought again his brother Lot, and his goods, and the women also, and the people.
And the king of Sodom went out to meet him after his return from the slaughter of Chedorlaomer, and of the kings that were with him, at the valley of Shaveh, which is the king's dale.
And Melchizedek king of Salem brought forth bread and wine: and he was the priest of the most high God.
And he blessed him, and said, Blessed be Abram of the most high God, possessor of heaven and earth:
And blessed be the most high God, which hath delivered thine enemies into thy hand. And he gave him tithes of all.
And the king of Sodom said unto Abram, Give me the persons, and take the goods to thyself.
And Abram said to the king of Sodom, I have lift up mine hand unto the LORD, the most high God, the possessor of heaven and earth,
That I will not take from a thread even to a shoelatchet, and that I will not take any thing that is thine, lest thou shouldest say, I have made Abram rich:
Save only that which the young men have eaten, and the portion of the men which went with me, Aner, Eshcol, and Mamre; let them take their portion.

15.
After these things the word of the LORD came unto Abram in a vision, saying, Fear not, Abram: I am thy shield, and thy exceeding great reward.
And Abram said, Lord GOD, what wilt thou give me, seeing I go childless, and the steward of my house is this Eliezer of Damascus?
And Abram said, Behold, to me thou hast given no seed: and, lo, one born in my house is mine heir.
And, behold, the word of the LORD came unto him, saying, This shall not be thine heir; but he that shall come forth out of thine own bowels shall be thine heir.
And he brought him forth abroad, and said, Look now toward heaven, and tell the stars, if thou be able to number them: and he said unto him, So shall thy seed be.
And he believed in the LORD; and he counted it to him for righteousness.
And he said unto him, I am the LORD that brought thee out of Ur of the Chaldees, to give thee this land to inherit it.
And he said, Lord GOD, whereby shall I know that I shall inherit it?
And he said unto him, Take me an heifer of three years old, and a she goat of three years old, and a ram of three years old, and a turtledove, and a young pigeon.
And he took unto him all these, and divided them in the midst, and laid each piece one against another: but the birds divided he not.
And when the fowls came down upon the carcases, Abram drove them away.
And when the sun was going down, a deep sleep fell upon Abram; and, lo, an horror of great darkness fell upon him.
And he said unto Abram, Know of a surety that thy seed shall be a stranger in a land that is not theirs, and shall serve them; and they shall afflict them four hundred years;
And also that nation, whom they shall serve, will I judge: and afterward shall they come out with great substance.
And thou shalt go to thy fathers in peace; thou shalt be buried in a good old age.
But in the fourth generation they shall come hither again: for the iniquity of the Amorites is not yet full.
And it came to pass, that, when the sun went down, and it was dark, behold a smoking furnace, and a burning lamp that passed between those pieces.
In the same day the LORD made a covenant with Abram, saying, Unto thy seed have I given this land, from the river of Egypt unto the great river, the river Euphrates:
The Kenites, and the Kenizzites, and the Kadmonites,
And the Hittites, and the Perizzites, and the Rephaims,
And the Amorites, and the Canaanites, and the Girgashites, and the Jebusites.

16.
Now Sarai Abram's wife bare him no children: and she had an handmaid, an Egyptian, whose name was Hagar.
And Sarai said unto Abram, Behold now, the LORD hath restrained me from bearing: I pray thee, go in unto my maid; it may be that I may obtain children by her. And Abram hearkened to the voice of Sarai.
And Sarai Abram's wife took Hagar her maid the Egyptian, after Abram had dwelt ten years in the land of Canaan, and gave her to her husband Abram to be his wife.
And he went in unto Hagar, and she conceived: and when she saw that she had conceived, her mistress was despised in her eyes.
And Sarai said unto Abram, My wrong be upon thee: I have given my maid into thy bosom; and when she saw that she had conceived, I was despised in her eyes: the LORD judge between me and thee.
But Abram said unto Sarai, Behold, thy maid is in thy hand; do to her as it pleaseth thee. And when Sarai dealt hardly with her, she fled from her face.
And the angel of the LORD found her by a fountain of water in the wilderness, by the fountain in the way to Shur.
And he said, Hagar, Sarai's maid, whence camest thou? and whither wilt thou go? And she said, I flee from the face of my mistress Sarai.
And the angel of the LORD said unto her, Return to thy mistress, and submit thyself under her hands.
And the angel of the LORD said unto her, I will multiply thy seed exceedingly, that it shall not be numbered for multitude.
And the angel of the LORD said unto her, Behold, thou art with child, and shalt bear a son, and shalt call his name Ishmael; because the LORD hath heard thy affliction.
And he will be a wild man; his hand will be against every man, and every man's hand against him; and he shall dwell in the presence of all his brethren.
And she called the name of the LORD that spake unto her, Thou God seest me: for she said, Have I also here looked after him that seeth me?
Wherefore the well was called Beer-lahai-roi; behold, it is between Kadesh and Bered.
And Hagar bare Abram a son: and Abram called his son's name, which Hagar bare, Ishmael.
And Abram was fourscore and six years old, when Hagar bare Ishmael to Abram.

17.
And when Abram was ninety years old and nine, the LORD appeared to Abram, and said unto him, I am the Almighty God; walk before me, and be thou perfect.
And I will make my covenant between me and thee, and will multiply thee exceedingly.
And Abram fell on his face: and God talked with him, saying,
As for me, behold, my covenant is with thee, and thou shalt be a father of many nations.
Neither shall thy name any more be called Abram, but thy name shall be Abraham; for a father of many nations have I made thee.
And I will make thee exceeding fruitful, and I will make nations of thee, and kings shall come out of thee.
And I will establish my covenant between me and thee and thy seed after thee in their generations for an everlasting covenant, to be a God unto thee, and to thy seed after thee.
And I will give unto thee, and to thy seed after thee, the land wherein thou art a stranger, all the land of Canaan, for an everlasting possession; and I will be their God.
And God said unto Abraham, Thou shalt keep my covenant therefore, thou, and thy seed after thee in their generations.
This is my covenant, which ye shall keep, between me and you and thy seed after thee; Every man child among you shall be circumcised.
And ye shall circumcise the flesh of your foreskin; and it shall be a token of the covenant betwixt me and you.
And he that is eight days old shall be circumcised among you, every man child in your generations, he that is born in the house, or bought with money of any stranger, which is not of thy seed.
He that is born in thy house, and he that is bought with thy money, must needs be circumcised: and my covenant shall be in your flesh for an everlasting covenant.
And the uncircumcised man child whose flesh of his foreskin is not circumcised, that soul shall be cut off from his people; he hath broken my covenant.
And God said unto Abraham, As for Sarai thy wife, thou shalt not call her name Sarai, but Sarah shall her name be.
And I will bless her, and give thee a son also of her: yea, I will bless her, and she shall be a mother of nations; kings of people shall be of her.
Then Abraham fell upon his face, and laughed, and said in his heart, Shall a child be born unto him that is an hundred years old? and shall Sarah, that is ninety years old, bear?
And Abraham said unto God, O that Ishmael might live before thee!
And God said, Sarah thy wife shall bear thee a son indeed; and thou shalt call his name Isaac: and I will establish my covenant with him for an everlasting covenant, and with his seed after him.
And as for Ishmael, I have heard thee: Behold, I have blessed him, and will make him fruitful, and will multiply him exceedingly; twelve princes shall he beget, and I will make him a great nation.
But my covenant will I establish with Isaac, which Sarah shall bear unto thee at this set time in the next year.
And he left off talking with him, and God went up from Abraham.
And Abraham took Ishmael his son, and all that were born in his house, and all that were bought with his money, every male among the men of Abraham's house; and circumcised the flesh of their foreskin in the selfsame day, as God had said unto him.
And Abraham was ninety years old and nine, when he was circumcised in the flesh of his foreskin.
And Ishmael his son was thirteen years old, when he was circumcised in the flesh of his foreskin.
In the selfsame day was Abraham circumcised, and Ishmael his son.
And all the men of his house, born in the house, and bought with money of the stranger, were circumcised with him.

18.
And the LORD appeared unto him in the plains of Mamre: and he sat in the tent door in the heat of the day;
And he lift up his eyes and looked, and, lo, three men stood by him: and when he saw them, he ran to meet them from the tent door, and bowed himself toward the ground,
And said, My Lord, if now I have found favour in thy sight, pass not away, I pray thee, from thy servant:
Let a little water, I pray you, be fetched, and wash your feet, and rest yourselves under the tree:
And I will fetch a morsel of bread, and comfort ye your hearts; after that ye shall pass on: for therefore are ye come to your servant. And they said, So do, as thou hast said.
And Abraham hastened into the tent unto Sarah, and said, Make ready quickly three measures of fine meal, knead it, and make cakes upon the hearth.
And Abraham ran unto the herd, and fetcht a calf tender and good, and gave it unto a young man; and he hasted to dress it.
And he took butter, and milk, and the calf which he had dressed, and set it before them; and he stood by them under the tree, and they did eat.
And they said unto him, Where is Sarah thy wife? And he said, Behold, in the tent.
And he said, I will certainly return unto thee according to the time of life; and, lo, Sarah thy wife shall have a son. And Sarah heard it in the tent door, which was behind him.
Now Abraham and Sarah were old and well stricken in age; and it ceased to be with Sarah after the manner of women.
Therefore Sarah laughed within herself, saying, After I am waxed old shall I have pleasure, my lord being old also?
And the LORD said unto Abraham, Wherefore did Sarah laugh, saying, Shall I of a surety bear a child, which am old?
Is any thing too hard for the LORD? At the time appointed I will return unto thee, according to the time of life, and Sarah shall have a son.
Then Sarah denied, saying, I laughed not; for she was afraid. And he said, Nay; but thou didst laugh.
And the men rose up from thence, and looked toward Sodom: and Abraham went with them to bring them on the way.
And the LORD said, Shall I hide from Abraham that thing which I do;
Seeing that Abraham shall surely become a great and mighty nation, and all the nations of the earth shall be blessed in him?
For I know him, that he will command his children and his household after him, and they shall keep the way of the LORD, to do justice and judgment; that the LORD may bring upon Abraham that which he hath spoken of him.
And the LORD said, Because the cry of Sodom and Gomorrah is great, and because their sin is very grievous;
I will go down now, and see whether they have done altogether according to the cry of it, which is come unto me; and if not, I will know.
And the men turned their faces from thence, and went toward Sodom: but Abraham stood yet before the LORD.
And Abraham drew near, and said, Wilt thou also destroy the righteous with the wicked?
Peradventure there be fifty righteous within the city: wilt thou also destroy and not spare the place for the fifty righteous that are therein?
That be far from thee to do after this manner, to slay the righteous with the wicked: and that the righteous should be as the wicked, that be far from thee: Shall not the Judge of all the earth do right?
And the LORD said, If I find in Sodom fifty righteous within the city, then I will spare all the place for their sakes.
And Abraham answered and said, Behold now, I have taken upon me to speak unto the Lord, which am but dust and ashes:
Peradventure there shall lack five of the fifty righteous: wilt thou destroy all the city for lack of five? And he said, If I find there forty and five, I will not destroy it.
And he spake unto him yet again, and said, Peradventure there shall be forty found there. And he said, I will not do it for forty's sake.
And he said unto him, Oh let not the Lord be angry, and I will speak: Peradventure there shall thirty be found there. And he said, I will not do it, if I find thirty there.
And he said, Behold now, I have taken upon me to speak unto the Lord: Peradventure there shall be twenty found there. And he said, I will not destroy it for twenty's sake.
And he said, Oh let not the Lord be angry, and I will speak yet but this once: Peradventure ten shall be found there. And he said, I will not destroy it for ten's sake.
And the LORD went his way, as soon as he had left communing with Abraham: and Abraham returned unto his place.

19.
And there came two angels to Sodom at even; and Lot sat in the gate of Sodom: and Lot seeing them rose up to meet them; and he bowed himself with his face toward the ground;
And he said, Behold now, my lords, turn in, I pray you, into your servant's house, and tarry all night, and wash your feet, and ye shall rise up early, and go on your ways. And they said, Nay; but we will abide in the street all night.
And he pressed upon them greatly; and they turned in unto him, and entered into his house; and he made them a feast, and did bake unleavened bread, and they did eat.
But before they lay down, the men of the city, even the men of Sodom, compassed the house round, both old and young, all the people from every quarter:
And they called unto Lot, and said unto him, Where are the men which came in to thee this night? bring them out unto us, that we may know them.
And Lot went out at the door unto them, and shut the door after him,
And said, I pray you, brethren, do not so wickedly.
Behold now, I have two daughters which have not known man; let me, I pray you, bring them out unto you, and do ye to them as is good in your eyes: only unto these men do nothing; for therefore came they under the shadow of my roof.
And they said, Stand back. And they said again, This one fellow came in to sojourn, and he will needs be a judge: now will we deal worse with thee, than with them. And they pressed sore upon the man, even Lot, and came near to break the door.
But the men put forth their hand, and pulled Lot into the house to them, and shut to the door.
And they smote the men that were at the door of the house with blindness, both small and great: so that they wearied themselves to find the door.
And the men said unto Lot, Hast thou here any besides? son in law, and thy sons, and thy daughters, and whatsoever thou hast in the city, bring them out of this place:
For we will destroy this place, because the cry of them is waxen great before the face of the LORD; and the LORD hath sent us to destroy it.
And Lot went out, and spake unto his sons in law, which married his daughters, and said, Up, get you out of this place; for the LORD will destroy this city. But he seemed as one that mocked unto his sons in law.
And when the morning arose, then the angels hastened Lot, saying, Arise, take thy wife, and thy two daughters, which are here; lest thou be consumed in the iniquity of the city.
And while he lingered, the men laid hold upon his hand, and upon the hand of his wife, and upon the hand of his two daughters; the LORD being merciful unto him: and they brought him forth, and set him without the city.
And it came to pass, when they had brought them forth abroad, that he said, Escape for thy life; look not behind thee, neither stay thou in all the plain; escape to the mountain, lest thou be consumed.
And Lot said unto them, Oh, not so, my Lord:
Behold now, thy servant hath found grace in thy sight, and thou hast magnified thy mercy, which thou hast shewed unto me in saving my life; and I cannot escape to the mountain, lest some evil take me, and I die:
Behold now, this city is near to flee unto, and it is a little one: Oh, let me escape thither, (is it not a little one?) and my soul shall live.
And he said unto him, See, I have accepted thee concerning this thing also, that I will not overthrow this city, for the which thou hast spoken.
Haste thee, escape thither; for I cannot do any thing till thou be come thither. Therefore the name of the city was called Zoar.
The sun was risen upon the earth when Lot entered into Zoar.
Then the LORD rained upon Sodom and upon Gomorrah brimstone and fire from the LORD out of heaven;
And he overthrew those cities, and all the plain, and all the inhabitants of the cities, and that which grew upon the ground.
But his wife looked back from behind him, and she became a pillar of salt.
And Abraham gat up early in the morning to the place where he stood before the LORD:
And he looked toward Sodom and Gomorrah, and toward all the land of the plain, and beheld, and, lo, the smoke of the country went up as the smoke of a furnace.
And it came to pass, when God destroyed the cities of the plain, that God remembered Abraham, and sent Lot out of the midst of the overthrow, when he overthrew the cities in the which Lot dwelt.
And Lot went up out of Zoar, and dwelt in the mountain, and his two daughters with him; for he feared to dwell in Zoar: and he dwelt in a cave, he and his two daughters.
And the firstborn said unto the younger, Our father is old, and there is not a man in the earth to come in unto us after the manner of all the earth:
Come, let us make our father drink wine, and we will lie with him, that we may preserve seed of our father.
And they made their father drink wine that night: and the firstborn went in, and lay with her father; and he perceived not when she lay down, nor when she arose.
And it came to pass on the morrow, that the firstborn said unto the younger, Behold, I lay yesternight with my father: let us make him drink wine this night also; and go thou in, and lie with him, that we may preserve seed of our Father.
And they made their father drink wine that night also: and the younger arose, and lay with him; and he perceived not when she lay down, nor when she arose.
Thus were both the daughters of Lot with child by their father.
And the firstborn bare a son, and called his name Moab: the same is the father of the Moabites unto this day.
And the younger, she also bare a son, and called his name Benammi: the same is the father of the children of Ammon unto this day.

20.
And Abraham journeyed from thence toward the south country, and dwelled between Kadesh and Shur, and sojourned in Gerar.
And Abraham said of Sarah his wife, She is my sister: and Abimelech king of Gerar sent, and took Sarah.
But God came to Abimelech in a dream by night, and said to him, Behold, thou art but a dead man, for the woman which thou hast taken; for she is a man's wife.
But Abimelech had not come near her: and he said, Lord, wilt thou slay also a righteous nation?
Said he not unto me, She is my sister? and she, even she herself said, He is my brother: in the integrity of my heart and innocency of my hands have I done this.
And God said unto him in a dream, Yea, I know that thou didst this in the integrity of thy heart; for I also withheld thee from sinning against me: therefore suffered I thee not to touch her.
Now therefore restore the man his wife; for he is a prophet, and he shall pray for thee, and thou shalt live: and if thou restore her not, know thou that thou shalt surely die, thou, and all that are thine.
Therefore Abimelech rose early in the morning, and called all his servants, and told all these things in their ears: and the men were sore afraid.
Then Abimelech called Abraham, and said unto him, What hast thou done unto us? and what have I offended thee, that thou hast brought on me and on my kingdom a great sin? thou hast done deeds unto me that ought not to be done.
And Abimelech said unto Abraham, What sawest thou, that thou hast done this thing?
And Abraham said, Because I thought, Surely the fear of God is not in this place; and they will slay me for my wife's sake.
And yet indeed she is my sister; she is the daughter of my father, but not the daughter of my mother; and she became my wife.
And it came to pass, when God caused me to wander from my father's house, that I said unto her, This is thy kindness which thou shalt shew unto me; at every place whither we shall come, say of me, He is my brother.
And Abimelech took sheep, and oxen, and menservants, and womenservants, and gave them unto Abraham, and restored him Sarah his wife.
And Abimelech said, Behold, my land is before thee: dwell where it pleaseth thee.
And unto Sarah he said, Behold, I have given thy brother a thousand pieces of silver: behold, he is to thee a covering of the eyes, unto all that are with thee, and with all other: thus she was reproved.
So Abraham prayed unto God: and God healed Abimelech, and his wife, and his maidservants; and they bare children.
For the LORD had fast closed up all the wombs of the house of Abimelech, because of Sarah Abraham's wife.

21.
And the LORD visited Sarah as he had said, and the LORD did unto Sarah as he had spoken.
For Sarah conceived, and bare Abraham a son in his old age, at the set time of which God had spoken to him.
And Abraham called the name of his son that was born unto him, whom Sarah bare to him, Isaac.
And Abraham circumcised his son Isaac being eight days old, as God had commanded him.
And Abraham was an hundred years old, when his son Isaac was born unto him.
And Sarah said, God hath made me to laugh, so that all that hear will laugh with me.
And she said, Who would have said unto Abraham, that Sarah should have given children suck? for I have born him a son in his old age.
And the child grew, and was weaned: and Abraham made a great feast the same day that Isaac was weaned.
And Sarah saw the son of Hagar the Egyptian, which she had born unto Abraham, mocking.
Wherefore she said unto Abraham, Cast out this bondwoman and her son: for the son of this bondwoman shall not be heir with my son, even with Isaac.
And the thing was very grievous in Abraham's sight because of his son.
And God said unto Abraham, Let it not be grievous in thy sight because of the lad, and because of thy bondwoman; in all that Sarah hath said unto thee, hearken unto her voice; for in Isaac shall thy seed be called.
And also of the son of the bondwoman will I make a nation, because he is thy seed.
And Abraham rose up early in the morning, and took bread, and a bottle of water, and gave it unto Hagar, putting it on her shoulder, and the child, and sent her away: and she departed, and wandered in the wilderness of Beer-sheba.
And the water was spent in the bottle, and she cast the child under one of the shrubs.
And she went, and sat her down over against him a good way off, as it were a bowshot: for she said, Let me not see the death of the child. And she sat over against him, and lift up her voice, and wept.
And God heard the voice of the lad; and the angel of God called Hagar out of heaven, and said unto her, What aileth thee, Hagar? fear not; for God hath heard the voice of the lad where he is.
Arise, lift up the lad, and hold him in thine hand; for I will make him a great nation.
And God opened her eyes, and she saw a well of water; and she went, and filled the bottle with water, and gave the lad drink.
And God was with the lad; and he grew, and dwelt in the wilderness, and became an archer.
And he dwelt in the wilderness of Paran: and his mother took him a wife out of the land of Egypt.
And it came to pass at that time, that Abimelech and Phichol the chief captain of his host spake unto Abraham, saying, God is with thee in all that thou doest:
Now therefore swear unto me here by God that thou wilt not deal falsely with me, nor with my son, nor with my son's son: but according to the kindness that I have done unto thee, thou shalt do unto me, and to the land wherein thou hast sojourned.
And Abraham said, I will swear.
And Abraham reproved Abimelech because of a well of water, which Abimelech's servants had violently taken away.
And Abimelech said, I wot not who hath done this thing: neither didst thou tell me, neither yet heard I of it, but to day.
And Abraham took sheep and oxen, and gave them unto Abimelech; and both of them made a covenant.
And Abraham set seven ewe lambs of the flock by themselves.
And Abimelech said unto Abraham, What mean these seven ewe lambs which thou hast set by themselves?
And he said, For these seven ewe lambs shalt thou take of my hand, that they may be a witness unto me, that I have digged this well.
Wherefore he called that place Beer-sheba; because there they sware both of them.
Thus they made a covenant at Beer-sheba: then Abimelech rose up, and Phichol the chief captain of his host, and they returned into the land of the Philistines.
And Abraham planted a grove in Beer-sheba, and called there on the name of the LORD, the everlasting God.
And Abraham sojourned in the Philistines' land many days.

22.
And it came to pass after these things, that God did tempt Abraham, and said unto him, Abraham: and he said, Behold, here I am.
And he said, Take now thy son, thine only son Isaac, whom thou lovest, and get thee into the land of Moriah; and offer him there for a burnt offering upon one of the mountains which I will tell thee of.
And Abraham rose up early in the morning, and saddled his ass, and took two of his young men with him, and Isaac his son, and clave the wood for the burnt offering, and rose up, and went unto the place of which God had told him.
Then on the third day Abraham lifted up his eyes, and saw the place afar off.
And Abraham said unto his young men, Abide ye here with the ass; and I and the lad will go yonder and worship, and come again to you,
And Abraham took the wood of the burnt offering, and laid it upon Isaac his son; and he took the fire in his hand, and a knife; and they went both of them together.
And Isaac spake unto Abraham his father, and said, My father: and he said, Here am I, my son. And he said, Behold the fire and the wood: but where is the lamb for a burnt offering?
And Abraham said, My son, God will provide himself a lamb for a burnt offering: so they went both of them together.
And they came to the place which God had told him of; and Abraham built an altar there, and laid the wood in order, and bound Isaac his son, and laid him on the altar upon the wood.
And Abraham stretched forth his hand, and took the knife to slay his son.
And the angel of the LORD called unto him out of heaven, and said, Abraham, Abraham: and he said, Here am I.
And he said, Lay not thine hand upon the lad, neither do thou any thing unto him: for now I know that thou fearest God, seeing thou hast not withheld thy son, thine only son from me.
And Abraham lifted up his eyes, and looked, and behold behind him a ram caught in a thicket by his horns: and Abraham went and took the ram, and offered him up for a burnt offering in the stead of his son.
And Abraham called the name of that place Jehovah-jireh: as it is said to this day, In the mount of the LORD it shall be seen.
And the angel of the LORD called unto Abraham out of heaven the second time,
And said, By myself have I sworn, saith the LORD, for because thou hast done this thing, and hast not withheld thy son, thine only son:
That in blessing I will bless thee, and in multiplying I will multiply thy seed as the stars of the heaven, and as the sand which is upon the sea shore; and thy seed shall possess the gate of his enemies;
And in thy seed shall all the nations of the earth be blessed; because thou hast obeyed my voice.
So Abraham returned unto his young men, and they rose up and went together to Beer-sheba; and Abraham dwelt at Beer-sheba.
And it came to pass after these things, that it was told Abraham, saying, Behold, Milcah, she hath also born children unto thy brother Nahor;
Huz his firstborn, and Buz his brother, and Kemuel the father of Aram,
And Chesed, and Hazo, and Pildash, and Jidlaph, and Bethuel.
And Bethuel begat Rebekah: these eight Milcah did bear to Nahor, Abraham's brother.
And his concubine, whose name was Reumah, she bare also Tebah, and Gaham, and Thahash, and Maachah.

23.
And Sarah was an hundred and seven and twenty years old: these were the years of the life of Sarah.
And Sarah died in Kirjath-arba; the same is Hebron in the land of Canaan: and Abraham came to mourn for Sarah, and to weep for her.
And Abraham stood up from before his dead, and spake unto the sons of Heth, saying,
I am a stranger and a sojourner with you: give me a possession of a buryingplace with you, that I may bury my dead out of my sight.
And the children of Heth answered Abraham, saying unto him,
Hear us, my lord: thou art a mighty prince among us: in the choice of our sepulchres bury thy dead; none of us shall withhold from thee his sepulchre, but that thou mayest bury thy dead.
And Abraham stood up, and bowed himself to the people of the land, even to the children of Heth.
And he communed with them, saying, If it be your mind that I should bury my dead out of my sight; hear me, and intreat for me to Ephron the son of Zohar,
That he may give me the cave of Machpelah, which he hath, which is in the end of his field; for as much money as it is worth he shall give it me for a possession of a buryingplace amongst you.
And Ephron dwelt among the children of Heth: and Ephron the Hittite answered Abraham in the audience of the children of Heth, even of all that went in at the gate of his city, saying,
Nay, my lord, hear me: the field give I thee, and the cave that is therein, I give it thee; in the presence of the sons of my people give I it thee: bury thy dead.
And Abraham bowed down himself before the people of the land.
And he spake unto Ephron in the audience of the people of the land, saying, But if thou wilt give it, I pray thee, hear me: I will give thee money for the field; take it of me, and I will bury my dead there.
And Ephron answered Abraham, saying unto him,
My lord, hearken unto me: the land is worth four hundred shekels of silver; what is that betwixt me and thee? bury therefore thy dead.
And Abraham hearkened unto Ephron; and Abraham weighed to Ephron the silver, which he had named in the audience of the sons of Heth, four hundred shekels of silver, current money with the merchant.
And the field of Ephron, which was in Machpelah, which was before Mamre, the field, and the cave which was therein, and all the trees that were in the field, that were in all the borders round about, were made sure
Unto Abraham for a possession in the presence of the children of Heth, before all that went in at the gate of his city.
And after this, Abraham buried Sarah his wife in the cave of the field of Machpelah before Mamre: the same is Hebron in the land of Canaan.
And the field, and the cave that is therein, were made sure unto Abraham for a possession of a buryingplace by the sons of Heth.

24.
And Abraham was old, and well stricken in age: and the LORD had blessed Abraham in all things.
And Abraham said unto his eldest servant of his house, that ruled over all that he had, Put, I pray thee, thy hand under my thigh:
And I will make thee swear by the LORD, the God of heaven, and the God of the earth, that thou shalt not take a wife unto my son of the daughters of the Canaanites, among whom I dwell:
But thou shalt go unto my country, and to my kindred, and take a wife unto my son Isaac.
And the servant said unto him, Peradventure the woman will not be willing to follow me unto this land: must I needs bring thy son again unto the land from whence thou camest?
And Abraham said unto him, Beware thou that thou bring not my son thither again.
The LORD God of heaven, which took me from my father's house, and from the land of my kindred, and which spake unto me, and that sware unto me, saying, Unto thy seed will I give this land; he shall send his angel before thee, and thou shalt take a wife unto my son from thence.
And if the woman will not be willing to follow thee, then thou shalt be clear from this my oath: only bring not my son thither again.
And the servant put his hand under the thigh of Abraham his master, and sware to him concerning that matter.
And the servant took ten camels of the camels of his master, and departed; for all the goods of his master were in his hand: and he arose, and went to Mesopotamia, unto the city of Nahor.
And he made his camels to kneel down without the city by a well of water at the time of the evening, even the time that women go out to draw water.
And he said, O LORD God of my master Abraham, I pray thee, send me good speed this day, and shew kindness unto my master Abraham.
Behold, I stand here by the well of water; and the daughters of the men of the city come out to draw water:
And let it come to pass, that the damsel to whom I shall say, Let down thy pitcher, I pray thee, that I may drink; and she shall say, Drink, and I will give thy camels drink also: let the same be she that thou hast appointed for thy servant Isaac; and thereby shall I know that thou hast shewed kindness unto my master.
And it came to pass, before he had done speaking, that, behold, Rebekah came out, who was born to Bethuel, son of Milcah, the wife of Nahor, Abraham's brother, with her pitcher upon her shoulder.
And the damsel was very fair to look upon, a virgin, neither had any man known her: and she went down to the well, and filled her pitcher, and came up.
And the servant ran to meet her, and said, Let me, I pray thee, drink a little water of thy pitcher.
And she said, Drink, my lord: and she hasted, and let down her pitcher upon her hand, and gave him drink.
And when she had done giving him drink, she said, I will draw water for thy camels also, until they have done drinking.
And she hasted, and emptied her pitcher into the trough, and ran again unto the well to draw water, and drew for all his camels.
And the man wondering at her held his peace, to wit whether the LORD had made his journey prosperous or not.
And it came to pass, as the camels had done drinking, that the man took a golden earring of half a shekel weight, and two bracelets for her hands of ten shekels weight of gold;
And said, Whose daughter art thou? tell me, I pray thee: is there room in thy father's house for us to lodge in?
And she said unto him, I am the daughter of Bethuel the son of Milcah, which she bare unto Nahor.
She said moreover unto him, We have both straw and provender enough, and room to lodge in.
And the man bowed down his head, and worshipped the LORD.
And he said, Blessed be the LORD God of my master Abraham, who hath not left destitute my master of his mercy and his truth: I being in the way, the LORD led me to the house of my master's brethren.
And the damsel ran, and told them of her mother's house these things.
And Rebekah had a brother, and his name was Laban: and Laban ran out unto the man, unto the well.
And it came to pass, when he saw the earring and bracelets upon his sister's hands, and when he heard the words of Rebekah his sister, saying, Thus spake the man unto me; that he came unto the man; and, behold, he stood by the camels at the well.
And he said, Come in, thou blessed of the LORD; wherefore standest thou without? for I have prepared the house, and room for the camels.
And the man came into the house: and he ungirded his camels, and gave straw and provender for the camels, and water to wash his feet, and the men's feet that were with him.
And there was set meat before him to eat: but he said, I will not eat, until I have told mine errand. And he said, Speak on.
And he said, I am Abraham's servant.
And the LORD hath blessed my master greatly; and he is become great: and he hath given him flocks, and herds, and silver, and gold, and menservants, and maidservants, and camels, and asses.
And Sarah my master's wife bare a son to my master when she was old: and unto him hath he given all that he hath.
And my master made me swear, saying, Thou shalt not take a wife to my son of the daughters of the Canaanites, in whose land I dwell:
But thou shalt go unto my father's house, and to my kindred, and take a wife unto my son.
And I said unto my master, Peradventure the woman will not follow me.
And he said unto me, The LORD, before whom I walk, will send his angel with thee, and prosper thy way; and thou shalt take a wife for my son of my kindred, and of my father's house:
Then shalt thou be clear from this my oath, when thou comest to my kindred; and if they give not thee one, thou shalt be clear from my oath.
And I came this day unto the well, and said, O LORD God of my master Abraham, if now thou do prosper my way which I go;
Behold, I stand by the well of water; and it shall come to pass, that when the virgin cometh forth to draw water, and I say to her, Give me, I pray thee, a little water of thy pitcher to drink;
And she say to me, Both drink thou, and I will also draw for thy camels: let the same be the woman whom the LORD hath appointed out for my master's son.
And before I had done speaking in mine heart, behold, Rebekah came forth with her pitcher on her shoulder; and she went down unto the well, and drew water: and I said unto her, Let me drink, I pray thee.
And she made haste, and let down her pitcher from her shoulder, and said, Drink, and I will give thy camels drink also: so I drank, and she made the camels drink also.
And I asked her, and said, Whose daughter art thou? And she said, The daughter of Bethuel, Nahor's son, whom Milcah bare unto him: and I put the earring upon her face, and the bracelets upon her hands.
And I bowed down my head, and worshipped the LORD, and blessed the LORD God of my master Abraham, which had led me in the right way to take my master's brother's daughter unto his son.
And now if ye will deal kindly and truly with my master, tell me: and if not, tell me; that I may turn to the right hand, or to the left.
Then Laban and Bethuel answered and said, The thing proceedeth from the LORD: we cannot speak unto thee bad or good.
Behold, Rebekah is before thee, take her, and go, and let her be thy master's son's wife, as the LORD hath spoken.
And it came to pass, that, when Abraham's servant heard their words, he worshipped the LORD, bowing himself to the earth.
And the servant brought forth jewels of silver, and jewels of gold, and raiment, and gave them to Rebekah: he gave also to her brother and to her mother precious things.
And they did eat and drink, he and the men that were with him, and tarried all night; and they rose up in the morning, and he said, Send me away unto my master.
And her brother and her mother said, Let the damsel abide with us a few days, at the least ten; after that she shall go.
And he said unto them, Hinder me not, seeing the LORD hath prospered my way; send me away that I may go to my master.
And they said, We will call the damsel, and inquire at her mouth.
And they called Rebekah, and said unto her, Wilt thou go with this man? And she said, I will go.
And they sent away Rebekah their sister, and her nurse, and Abraham's servant, and his men.
And they blessed Rebekah, and said unto her, Thou art our sister, be thou the mother of thousands of millions, and let thy seed possess the gate of those which hate them.
And Rebekah arose, and her damsels, and they rode upon the camels, and followed the man: and the servant took Rebekah, and went his way.
And Isaac came from the way of the well Lahai-roi; for he dwelt in the south country.
And Isaac went out to meditate in the field at the eventide: and he lifted up his eyes, and saw, and, behold, the camels were coming.
And Rebekah lifted up her eyes, and when she saw Isaac, she lighted off the camel.
For she had said unto the servant, What man is this that walketh in the field to meet us? And the servant had said, It is my master: therefore she took a vail, and covered herself.
And the servant told Isaac all things that he had done.
And Isaac brought her into his mother Sarah's tent, and took Rebekah, and she became his wife; and he loved her: and Isaac was comforted after his mother's death.

25.
Then again Abraham took a wife, and her name was Keturah.
And she bare him Zimran, and Jokshan, and Medan, and Midian, and Ishbak, and Shuah.
And Jokshan begat Sheba, and Dedan. And the sons of Dedan were Asshurim, and Letushim, and Leummim.
And the sons of Midian; Ephah, and Epher, and Hanoch, and Abida, and Eldaah. All these were the children of Keturah.
And Abraham gave all that he had unto Isaac.
But unto the sons of the concubines, which Abraham had, Abraham gave gifts, and sent them away from Isaac his son, while he yet lived, eastward, unto the east country.
And these are the days of the years of Abraham's life which he lived, an hundred threescore and fifteen years.
Then Abraham gave up the ghost, and died in a good old age, an old man, and full of years; and was gathered to his people.
And his sons Isaac and Ishmael buried him in the cave of Machpelah, in the field of Ephron the son of Zohar the Hittite, which is before Mamre;
The field which Abraham purchased of the sons of Heth: there was Abraham buried, and Sarah his wife.
And it came to pass after the death of Abraham, that God blessed his son Isaac; and Isaac dwelt by the well Lahai-roi.
Now these are the generations of Ishmael, Abraham's son, whom Hagar the Egyptian, Sarah's handmaid, bare unto Abraham:
And these are the names of the sons of Ishmael, by their names, according to their generations: the firstborn of Ishmael, Nebajoth; and Kedar, and Adbeel, and Mibsam,
And Mishma, and Dumah, and Massa,
Hadar, and Tema, Jetur, Naphish, and Kedemah:
These are the sons of Ishmael, and these are their names, by their towns, and by their castles; twelve princes according to their nations.
And these are the years of the life of Ishmael, an hundred and thirty and seven years: and he gave up the ghost and died; and was gathered unto his people.
And they dwelt from Havilah unto Shur, that is before Egypt, as thou goest toward Assyria: and he died in the presence of all his brethren.
And these are the generations of Isaac, Abraham's son: Abraham begat Isaac:
And Isaac was forty years old when he took Rebekah to wife, the daughter of Bethuel the Syrian of Padan-aram, the sister to Laban the Syrian.
And Isaac intreated the LORD for his wife, because she was barren: and the LORD was intreated of him, and Rebekah his wife conceived.
And the children struggled together within her; and she said, If it be so, why am I thus? And she went to inquire of the LORD.
And the LORD said unto her, Two nations are in thy womb, and two manner of people shall be separated from thy bowels; and the one people shall be stronger than the other people; and the elder shall serve the younger.
And when her days to be delivered were fulfilled, behold, there were twins in her womb.
And the first came out red, all over like an hairy garment; and they called his name Esau.
And after that came his brother out, and his hand took hold on Esau's heel; and his name was called Jacob: and Isaac was threescore years old when she bare them.
And the boys grew: and Esau was a cunning hunter, a man of the field; and Jacob was a plain man, dwelling in tents.
And Isaac loved Esau, because he did eat of his venison: but Rebekah loved Jacob.
And Jacob sod pottage: and Esau came from the field, and he was faint:
And Esau said to Jacob, Feed me, I pray thee, with that same red pottage; for I am faint: therefore was his name called Edom.
And Jacob said, Sell me this day thy birthright.
And Esau said, Behold, I am at the point to die: and what profit shall this birthright do to me?
And Jacob said, Swear to me this day; and he sware unto him: and he sold his birthright unto Jacob.
Then Jacob gave Esau bread and pottage of lentiles; and he did eat and drink, and rose up, and went his way: thus Esau despised his birthright.

26.
And there was a famine in the land, beside the first famine that was in the days of Abraham. And Isaac went unto Abimelech king of the Philistines unto Gerar.
And the LORD appeared unto him, and said, Go not down into Egypt; dwell in the land which I shall tell thee of:
Sojourn in this land, and I will be with thee, and will bless thee; for unto thee, and unto thy seed, I will give all these countries, and I will perform the oath which I sware unto Abraham thy father;
And I will make thy seed to multiply as the stars of heaven, and will give unto thy seed all these countries; and in thy seed shall all the nations of the earth be blessed;
Because that Abraham obeyed my voice, and kept my charge, my commandments, my statutes, and my laws.
And Isaac dwelt in Gerar:
And the men of the place asked him of his wife; and he said, She is my sister: for he feared to say, She is my wife; lest, said he, the men of the place should kill me for Rebekah; because she was fair to look upon.
And it came to pass, when he had been there a long time, that Abimelech king of the Philistines looked out at a window, and saw, and, behold, Isaac was sporting with Rebekah his wife.
And Abimelech called Isaac, and said, Behold, of a surety she is thy wife: and how saidst thou, She is my sister? And Isaac said unto him, Because I said, Lest I die for her.
And Abimelech said, What is this thou hast done unto us? one of the people might lightly have lien with thy wife, and thou shouldest have brought guiltiness upon us.
And Abimelech charged all his people, saying, He that toucheth this man or his wife shall surely be put to death.
Then Isaac sowed in that land, and received in the same year an hundredfold: and the LORD blessed him.
And the man waxed great, and went forward, and grew until he became very great:
For he had possession of flocks, and possessions of herds, and great store of servants: and the Philistines envied him.
For all the wells which his father's servants had digged in the days of Abraham his father, the Philistines had stopped them, and filled them with earth.
And Abimelech said unto Isaac, Go from us; for thou art much mightier than we.
And Isaac departed thence, and pitched his tent in the valley of Gerar, and dwelt there.
And Isaac digged again the wells of water, which they had digged in the days of Abraham his father; for the philistines had stopped them after the death of Abraham: and he called their names after the names by which his father had called them.
And Isaac's servants digged in the valley, and found there a well of springing water.
And the herdmen of Gerar did strive with Isaac's herdmen, saying, The water is ours: and he called the name of the well Esek; because they strove with him.
And they digged another well, and strove for that also:and he called the name of it Sitnah.
And he removed from thence, and digged another well; and for that they strove not: and he called the name of it Rehoboth; and he said, For now the LORD hath made room for us, and we shall be fruitful in the land.
And he went up from thence to Beer-sheba.
And the LORD appeared unto him the same night, and said, I am the God of Abraham thy father: fear not, for I am with thee, and will bless thee, and multiply thy seed for my servant Abraham's sake.
And he builded an altar there, and called upon the name of the LORD and pitched his tent there: and there Isaac's servants digged a well.
Then Abimelech went to him from Gerar, and Ahuzzath one of his friends, and Phichol the chief captain of his army.
And Isaac said unto them, Wherefore come ye to me, seeing ye hate me, and have sent me away from you?
And they said, We saw certainly that the LORD was with thee: and we said, Let there be now an oath betwixt us, even betwixt us and thee, and let us make a covenant with thee;
That thou wilt do us no hurt, as we have not touched thee, and as we have done unto thee nothing but good, and have sent thee away in peace: thou art now the blessed of the LORD.
And he made them a feast, and they did eat and drink.
And they rose up betimes in the morning, and sware one to another: and Isaac sent them away, and they departed from him in peace.
And it came to pass the same day, that Isaac's servants came, and told him concerning the well which they had digged, and said unto him, We have found water.
And he called it Shebah: therefore the name of the city is Beer-sheba unto this day.
And Esau was forty years old when he took to wife Judith the daughter of Beeri the Hittite, and Bashemath the daughter of Elon the Hittite:
Which were a grief of mind unto Isaac and to Rebekah.

27.
And it came to pass, that when Isaac was old, and his eyes were dim, so that he could not see, he called Esau his eldest son, and said unto him, My son: and he said unto him, Behold, here am I.
And he said, Behold now, I am old, I know not the day of my death:
Now therefore take, I pray thee, thy weapons, thy quiver and thy bow, and go out to the field, and take me some venison;
And make me savoury meat, such as I love, and bring it to me, that I may eat; that my soul may bless thee before I die.
And Rebekah heard when Isaac spake to Esau his son. And Esau went to the field to hunt for venison, and to bring it.
And Rebekah spake unto Jacob her son, saying, Behold, I heard thy father speak unto Esau thy brother, saying,
Bring me venison, and make me savoury meat, that I may eat, and bless thee before the LORD before my death.
Now therefore, my son, obey my voice according to that which I command thee.
Go now to the flock, and fetch me from thence two good kids of the goats; and I will make them savoury meat for thy father, such as he loveth:
And thou shalt bring it to thy father, that he may eat, and that he may bless thee before his death.
And Jacob said to Rebekah his mother, Behold, Esau my brother is a hairy man, and I am a smooth man:
My father peradventure will feel me, and I shall seem to him as a deceiver; and I shall bring a curse upon me, and not a blessing.
And his mother said unto him, Upon me be thy curse, my son: only obey my voice, and go fetch me them.
And he went, and fetched, and brought them to his mother: and his mother made savoury meat, such as his father loved.
And Rebekah took goodly raiment of her eldest son Esau, which were with her in the house, and put them upon Jacob her younger son:
And she put the skins of the kids of the goats upon his hands, and upon the smooth of his neck:
And she gave the savoury meat and the bread, which she had prepared, into the hand of her son Jacob.
And he came unto his father, and said, My father: and he said, Here am I; who art thou, my son?
And Jacob said unto his father, I am Esau thy firstborn; I have done according as thou badest me: arise, I pray thee, sit and eat of my venison, that thy soul may bless me.
And Isaac said unto his son, How is it that thou hast found it so quickly, my son? And he said, Because the LORD thy God brought it to me.
And Isaac said unto Jacob, Come near, I pray thee, that I may feel thee, my son, whether thou be my very son Esau or not.
And Jacob went near unto Isaac his father; and he felt him, and said, The voice is Jacob's voice, but the hands are the hands of Esau.
And he discerned him not, because his hands were hairy, as his brother Esau's hands: so he blessed him.
And he said, Art thou my very son Esau? And he said, I am.
And he said, Bring it near to me, and I will eat of my son's venison, that my soul may bless thee. And he brought it near to him, and he did eat: and he brought him wine, and he drank.
And his father Isaac said unto him, Come near now, and kiss me, my son.
And he came near, and kissed him: and he smelled the smell of his raiment, and blessed him, and said, See, the smell of my son is as the smell of a field which the LORD hath blessed:
Therefore God give thee of the dew of heaven, and the fatness of the earth, and plenty of corn and wine:
Let people serve thee, and nations bow down to thee: be lord over thy brethren, and let thy mother's sons bow down to thee: cursed be every one that curseth thee, and blessed be he that blesseth thee.
And it came to pass, as soon as Isaac had made an end of blessing Jacob, and Jacob was yet scarce gone out from the presence of Isaac his father, that Esau his brother came in from his hunting.
And he also had made savoury meat, and brought it unto his father, and said unto his father, Let my father arise, and eat of his son's venison, that thy soul may bless me.
And Isaac his father said unto him, Who art thou? And he said, I am thy son, thy firstborn Esau.
And Isaac trembled very exceedingly, and said, Who? where is he that hath taken venison, and brought it me, and I have eaten of all before thou camest, and have blessed him? yea, and he shall be blessed.
And when Esau heard the words of his father, he cried with a great and exceeding bitter cry, and said unto his father, Bless me, even me also, O my father.
And he said, Thy brother came with subtilty, and hath taken away thy blessing.
And he said, Is not he rightly named Jacob? for he hath supplanted me these two times: he took away my birthright; and, behold, now he hath taken away my blessing. And he said, Hast thou not reserved a blessing for me?
And Isaac answered and said unto Esau, Behold, I have made him thy lord, and all his brethren have I given to him for servants; and with corn and wine have I sustained him: and what shall I do now unto thee, my son?
And Esau said unto his father, Hast thou but one blessing, my father? bless me, even me also, O my father. And Esau lifted up his voice, and wept.
And Isaac his father answered and said unto him, Behold, thy dwelling shall be the fatness of the earth, and of the dew of heaven from above;
And by thy sword shalt thou live, and shalt serve thy brother; and it shall come to pass when thou shalt have the dominion, that thou shalt break his yoke from off thy neck.
And Esau hated Jacob because of the blessing wherewith his father blessed him: and Esau said in his heart, The days of mourning for my father are at hand; then will I slay my brother Jacob.
And these words of Esau her elder son were told to Rebekah: and she sent and called Jacob her younger son, and said unto him, Behold, thy brother Esau, as touching thee, doth comfort himself, purposing to kill thee.
Now therefore, my son, obey my voice; and arise, flee thou to Laban my brother to Haran;
And tarry with him a few days, until thy brother's fury turn away;
Until thy brother's anger turn away from thee, and he forget that which thou hast done to him: then I will send, and fetch thee from thence: why should I be deprived also of you both in one day?
And Rebekah said to Isaac, I am weary of my life because of the daughters of Heth: if Jacob take a wife of the daughters of Heth, such as these which are of the daughters of the land, what good shall my life do me?

28.
And Isaac called Jacob, and blessed him, and charged him, and said unto him, Thou shalt not take a wife of the daughters of Canaan.
Arise, go to Padan-aram, to the house of Bethuel thy mother's father; and take thee a wife from thence of the daughters of Laban thy mother's brother.
And God Almighty bless thee, and make thee fruitful, and multiply thee, that thou mayest be a multitude of people;
And give thee the blessing of Abraham, to thee, and to thy seed with thee; that thou mayest inherit the land wherein thou art a stranger, which God gave unto Abraham.
And Isaac sent away Jacob: and he went to Padan-aram unto Laban, son of Bethuel the Syrian, the brother of Rebekah, Jacob's and Esau's mother.
When Esau saw that Isaac had blessed Jacob, and sent him away to Padan-aram, to take him a wife from thence; and that as he blessed him he gave him a charge, saying, Thou shalt not take a wife of the daughters of Canaan;
And that Jacob obeyed his father and his mother, and was gone to Padan-aram;
And Esau seeing that the daughters of Canaan pleased not Isaac his father;
Then went Esau unto Ishmael, and took unto the wives which he had Mahalath the daughter of Ishmael Abraham's son, the sister of Nebajoth, to be his wife.
And Jacob went out from Beer-sheba, and went toward Haran.
And he lighted upon a certain place, and tarried there all night, because the sun was set; and he took of the stones of that place, and put them for his pillows, and lay down in that place to sleep.
And he dreamed, and behold a ladder set up on the earth, and the top of it reached to heaven: and behold the angels of God ascending and descending on it.
And, behold, the LORD stood above it, and said, I am the LORD God of Abraham thy father, and the God of Isaac: the land whereon thou liest, to thee will I give it, and to thy seed;
And thy seed shall be as the dust of the earth, and thou shalt spread abroad to the west, and to the east, and to the north, and to the south: and in thee and in thy seed shall all the families of the earth be blessed.
And, behold, I am with thee, and will keep thee in all places whither thou goest, and will bring thee again into this land; for I will not leave thee, until I have done that which I have spoken to thee of.
And Jacob awaked out of his sleep, and he said, Surely the LORD is in this place; and I knew it not.
And he was afraid, and said, How dreadful is this place! this is none other but the house of God, and this is the gate of heaven.
And Jacob rose up early in the morning, and took the stone that he had put for his pillows, and set it up for a pillar, and poured oil upon the top of it.
And he called the name of that place Bethel: but the name of that city was called Luz at the first.
And Jacob vowed a vow, saying, If God will be with me, and will keep me in this way that I go, and will give me bread to eat, and raiment to put on,
So that I come again to my father's house in peace; then shall the LORD be my God:
And this stone, which I have set for a pillar, shall be God's house: and of all that thou shalt give me I will surely give the tenth unto thee.

29.
Then Jacob went on his journey, and came into the land of the people of the east.
And he looked, and behold a well in the field, and, lo, there were three flocks of sheep lying by it; for out of that well they watered the flocks: and a great stone was upon the well's mouth.
And thither were all the flocks gathered: and they rolled the stone from the well's mouth, and watered the sheep, and put the stone again upon the well's mouth in his place.
And Jacob said unto them, My brethren, whence be ye? And they said, Of Haran are we.
And he said unto them, Know ye Laban the son of Nahor? And they said, We know him.
And he said unto them, Is he well? And they said, He is well: and, behold, Rachel his daughter cometh with the sheep.
And he said, Lo, it is yet high day, neither is it time that the cattle should be gathered together: water ye the sheep, and go and feed them.
And they said, We cannot, until all the flocks be gathered together, and till they roll the stone from the well's mouth; then we water the sheep.
And while he yet spake with them, Rachel came with her father's sheep: for she kept them.
And it came to pass, when Jacob saw Rachel the daughter of Laban his mother's brother, and the sheep of Laban his mother's brother, that Jacob went near, and rolled the stone from the well's mouth, and watered the flock of Laban his mother's brother.
And Jacob kissed Rachel, and lifted up his voice, and wept.
And Jacob told Rachel that he was her father's brother, and that he was Rebekah's son: and she ran and told her father.
And it came to pass, when Laban heard the tidings of Jacob his sister's son, that he ran to meet him, and embraced him, and kissed him, and brought him to his house. And he told Laban all these things.
And Laban said to him, Surely thou art my bone and my flesh. And he abode with him the space of a month.
And Laban said unto Jacob, Because thou art my brother, shouldest thou therefore serve me for nought? tell me, what shall thy wages be?
And Laban had two daughters: the name of the elder was Leah, and the name of the younger was Rachel.
Leah was tender eyed; but Rachel was beautiful and well favoured.
And Jacob loved Rachel; and said, I will serve thee seven years for Rachel thy younger daughter.
And Laban said, It is better that I give her to thee, than that I should give her to another man: abide with me.
And Jacob served seven years for Rachel; and they seemed unto him but a few days, for the love he had to her.
And Jacob said unto Laban, Give me my wife, for my days are fulfilled, that I may go in unto her.
And Laban gathered together all the men of the place, and made a feast.
And it came to pass in the evening, that he took Leah his daughter, and brought her to him; and he went in unto her.
And Laban gave unto his daughter Leah Zilpah his maid for an handmaid.
And it came to pass, that in the morning, behold, it was Leah: and he said to Laban, What is this thou hast done unto me? did not I serve with thee for Rachel? wherefore then hast thou beguiled me?
And Laban said, It must not be so done in our country, to give the younger before the firstborn.
Fulfil her week, and we will give thee this also for the service which thou shalt serve with me yet seven other years.
And Jacob did so, and fulfilled her week: and he gave him Rachel his daughter to wife also.
And Laban gave to Rachel his daughter Bilhah his handmaid to be her maid.
And he went in also unto Rachel, and he loved also Rachel more than Leah, and served with him yet seven other years.
And when the LORD saw that Leah was hated, he opened her womb: but Rachel was barren.
And Leah conceived, and bare a son, and she called his name Reuben: for she said, Surely the LORD hath looked upon my affliction; now therefore my husband will love me.
And she conceived again, and bare a son; and said, Because the LORD hath heard that I was hated, he hath therefore given me this son also: and she called his name Simeon.
And she conceived again, and bare a son; and said, Now this time will my husband be joined unto me, because I have born him three sons: therefore was his name called Levi.
And she conceived again, and bare a son: and she said, Now will I praise the LORD: therefore she called his name Judah; and left bearing.

30.
And when Rachel saw that she bare Jacob no children, Rachel envied her sister; and said unto Jacob, Give me children, or else I die.
And Jacob's anger was kindled against Rachel: and he said, Am I in God's stead, who hath withheld from thee the fruit of the womb?
And she said, Behold my maid Bilhah, go in unto her; and she shall bear upon my knees that I may also have children by her.
And she gave him Bilhah her handmaid to wife: and Jacob went in unto her.
And Bilhah conceived, and bare Jacob a son.
And Rachel said, God hath judged me, and hath also heard my voice, and hath given me a son: therefore called she his name Dan.
And Bilhah Rachel's maid conceived again, and bare Jacob a second son.
And Rachel said, With great wrestlings have I wrestled with my sister, and I have prevailed: and she called his name Naphtali.
When Leah saw that she had left bearing, she took Zilpah her maid, and gave her Jacob to wife.
And Zilpah Leah's maid bare Jacob a son.
And Leah said, A troop cometh: and she called his name Gad.
And Zilpah Leah's maid bare Jacob a second son.
And Leah said, Happy am I, for the daughters will call me blessed: and she called his name Asher.
And Reuben went in the days of wheat harvest, and found mandrakes in the field, and brought them unto his mother Leah. Then Rachel said to Leah, Give me, I pray thee, of thy son's mandrakes.
And she said unto her, Is it a small matter that thou hast taken my husband? and wouldest thou take away my son's mandrakes also? And Rachel said, Therefore he shall lie with thee to night for thy son's mandrakes.
And Jacob came out of the field in the evening, and Leah went out to meet him, and said, Thou must come in unto me; for surely I have hired thee with my son's mandrakes. And he lay with her that night.
And God hearkened unto Leah, and she conceived, and bare Jacob the fifth son.
And Leah said, God hath given me my hire, because I have given my maiden to my husband: and she called his name Issachar.
And Leah conceived again, and bare Jacob the sixth son.
And Leah said, God hath endued me with a good dowry; now will my husband dwell with me, because I have born him six sons: and she called his name Zebulun.
And afterwards she bare a daughter, and called her name Dinah.
And God remembered Rachel, and God hearkened to her, and opened her womb.
And she conceived, and bare a son; and said, God hath taken away my reproach:
And she called his name Joseph; and said, The LORD shall add to me another son.
And it came to pass, when Rachel had born Joseph, that Jacob said unto Laban, Send me away, that I may go unto mine own place, and to my country.
Give me my wives and my children, for whom I have served thee, and let me go: for thou knowest my service which I have done thee.
And Laban said unto him, I pray thee, if I have found favour in thine eyes, tarry: for I have learned by experience that the LORD hath blessed me for thy sake.
And he said, Appoint me thy wages, and I will give it.
And he said unto him, Thou knowest how I have served thee, and how thy cattle was with me.
For it was little which thou hadst before I came, and it is now increased unto a multitude; and the LORD hath blessed thee since my coming: and now when shall I provide for mine own house also?
And he said, What shall I give thee? And Jacob said, Thou shalt not give me any thing: if thou wilt do this thing for me, I will again feed and keep thy flock:
I will pass through all thy flock to day, removing from thence all the speckled and spotted cattle, and all the brown cattle among the sheep, and the spotted and speckled among the goats: and of such shall be my hire.
So shall my righteousness answer for me in time to come, when it shall come for my hire before thy face: every one that is not speckled and spotted among the goats, and brown among the sheep, that shall be counted stolen with me.
And Laban said, Behold, I would it might be according to thy word.
And he removed that day the he goats that were ringstraked and spotted, and all the she goats that were speckled and spotted, and every one that had some white in it, and all the brown among the sheep, and gave them into the hand of his sons.
And he set three days' journey betwixt himself and Jacob: and Jacob fed the rest of Laban's flocks.
And Jacob took him rods of green poplar, and of the hazel and chesnut tree; and pilled white strakes in them, and made the white appear which was in the rods.
And he set the rods which he had pilled before the flocks in the gutters in the watering troughs when the flocks came to drink, that they should conceive when they came to drink.
And the flocks conceived before the rods, and brought forth cattle ringstraked, speckled, and spotted.
And Jacob did separate the lambs, and set the faces of the flocks toward the ringstraked, and all the brown in the flock of Laban; and he put his own flocks by themselves, and put them not unto Laban's cattle.
And it came to pass, whensoever the stronger cattle did conceive, that Jacob laid the rods before the eyes of the cattle in the gutters, that they might conceive among the rods.
But when the cattle were feeble, he put them not in: so the feebler were Laban's, and the stronger Jacob's.
And the man increased exceedingly, and had much cattle, and maidservants, and menservants, and camels, and asses.

31.
And he heard the words of Laban's sons, saying, Jacob hath taken away all that was our father's; and of that which was our father's hath he gotten all this glory.
And Jacob beheld the countenance of Laban, and, behold, it was not toward him as before.
And the LORD said unto Jacob, Return unto the land of thy fathers, and to thy kindred; and I will be with thee.
And Jacob sent and called Rachel and Leah to the field unto his flock,
And said unto them, I see your father's countenance, that it is not toward me as before; but the God of my father hath been with me.
And ye know that with all my power I have served your father.
And your father hath deceived me, and changed my wages ten times; but God suffered him not to hurt me.
If he said thus, The speckled shall be thy wages; then all the cattle bare speckled: and if he said thus, The ringstraked shall be thy hire; then bare all the cattle ringstraked.
Thus God hath taken away the cattle of your father, and given them to me.
And it came to pass at the time that the cattle conceived, that I lifted up mine eyes, and saw in a dream, and, behold, the rams which leaped upon the cattle were ringstraked, speckled, and grisled.
And the angel of God spake unto me in a dream, saying, Jacob: And I said, Here am I.
And he said, Lift up now thine eyes, and see, all the rams which leap upon the cattle are ringstraked, speckled, and grisled: for I have seen all that Laban doeth unto thee.
I am the God of Bethel, where thou anointedst the pillar, and where thou vowedst a vow unto me: now arise, get thee out from this land, and return unto the land of thy kindred.
And Rachel and Leah answered and said unto him, Is there yet any portion or inheritance for us in our father's house?
Are we not counted of him strangers? for he hath sold us, and hath quite devoured also our money.
For all the riches which God hath taken from our father, that is ours, and our children's: now then, whatsoever God hath said unto thee, do.
Then Jacob rose up, and set his sons and his wives upon camels;
And he carried away all his cattle, and all his goods which he had gotten, the cattle of his getting, which he had gotten in Padan-aram, for to go to Isaac his father in the land of Canaan.
And Laban went to shear his sheep: and Rachel had stolen the images that were her father's.
And Jacob stole away unawares to Laban the Syrian, in that he told him not that he fled.
So he fled with all that he had; and he rose up, and passed over the river, and set his face toward the mount Gilead.
And it was told Laban on the third day that Jacob was fled.
And he took his brethren with him, and pursued after him seven days' journey; and they overtook him in the mount Gilead.
And God came to Laban the Syrian in a dream by night, and said unto him, Take heed that thou speak not to Jacob either good or bad.
Then Laban overtook Jacob. Now Jacob had pitched his tent in the mount: and Laban with his brethren pitched in the mount of Gilead.
And Laban said to Jacob, What hast thou done, that thou hast stolen away unawares to me, and carried away my daughters, as captives taken with the sword?
Wherefore didst thou flee away secretly, and steal away from me; and didst not tell me, that I might have sent thee away with mirth, and with songs, with tabret, and with harp?
And hast not suffered me to kiss my sons and my daughters? thou hast now done foolishly in so doing.
It is in the power of my hand to do you hurt: but the God of your father spake unto me yesternight, saying, Take thou heed that thou speak not to Jacob either good or bad.
And now, though thou wouldest needs be gone, because thou sore longedst after thy father's house, yet wherefore hast thou stolen my gods?
And Jacob answered and said to Laban, Because I was afraid: for I said, Peradventure thou wouldest take by force thy daughters from me.
With whomsoever thou findest thy gods, let him not live: before our brethren discern thou what is thine with me, and take it to thee. For Jacob knew not that Rachel had stolen them.
And Laban went into Jacob's tent, and into Leah's tent, and into the two maidservants' tents; but he found them not. Then went he out of Leah's tent, and entered into Rachel's tent.
Now Rachel had taken the images, and put them in the camel's furniture, and sat upon them. And Laban searched all the tent, but found them not.
And she said to her father, Let it not displease my lord that I cannot rise up before thee; for the custom of women is upon me. And he searched, but found not the images.
And Jacob was wroth, and chode with Laban: and Jacob answered and said to Laban, What is my trespass? what is my sin, that thou hast so hotly pursued after me?
Whereas thou hast searched all my stuff, what hast thou found of all thy household stuff? set it here before my brethren and thy brethren, that they may judge betwixt us both.
This twenty years have I been with thee; thy ewes and thy she goats have not cast their young, and the rams of thy flock have I not eaten.
That which was torn of beasts I brought not unto thee; I bare the loss of it; of my hand didst thou require it, whether stolen by day, or stolen by night.
Thus I was; in the day the drought consumed me, and the frost by night; and my sleep departed from mine eyes.
Thus have I been twenty years in thy house; I served thee fourteen years for thy two daughters, and six years for thy cattle: and thou hast changed my wages ten times.
Except the God of my father, the God of Abraham, and the fear of Isaac, had been with me, surely thou hadst sent me away now empty. God hath seen mine affliction and the labour of my hands, and rebuked thee yesternight.
And Laban answered and said unto Jacob, These daughters are my daughters, and these children are my children, and these cattle are my cattle, and all that thou seest is mine: and what can I do this day unto these my daughters, or unto their children which they have born?
Now therefore come thou, let us make a covenant, I and thou; and let it be for a witness between me and thee.
And Jacob took a stone, and set it up for a pillar.
And Jacob said unto his brethren, Gather stones; and they took stones, and made an heap: and they did eat there upon the heap.
And Laban called it Jegar-sahadutha: but Jacob called it Galeed.
And Laban said, This heap is a witness between me and thee this day. Therefore was the name of it called Galeed;
And Mizpah; for he said, The LORD watch between me and thee, when we are absent one from another.
If thou shalt afflict my daughters, or if thou shalt take other wives beside my daughters, no man is with us; see, God is witness betwixt me and thee.
And Laban said to Jacob, Behold this heap, and behold this pillar, which I have cast betwixt me and thee;
This heap be witness, and this pillar be witness, that I will not pass over this heap to thee, and that thou shalt not pass over this heap and this pillar unto me, for harm.
The God of Abraham, and the God of Nahor, the God of their father, judge betwixt us. And Jacob sware by the fear of his father Isaac.
Then Jacob offered sacrifice upon the mount, and called his brethren to eat bread: and they did eat bread, and tarried all night in the mount.
And early in the morning Laban rose up, and kissed his sons and his daughters, and blessed them: and Laban departed, and returned unto his place.

32.
And Jacob went on his way, and the angels of God met him.
And when Jacob saw them, he said, This is God's host: and he called the name of that place Mahanaim.
And Jacob sent messengers before him to Esau his brother unto the land of Seir, the country of Edom.
And he commanded them, saying, Thus shall ye speak unto my lord Esau; Thy servant Jacob saith thus, I have sojourned with Laban, and stayed there until now:
And I have oxen, and asses, flocks, and menservants, and womenservants: and I have sent to tell my lord, that I may find grace in thy sight.
And the messengers returned to Jacob, saying, We came to thy brother Esau, and also he cometh to meet thee, and four hundred men with him.
Then Jacob was greatly afraid and distressed: and he divided the people that was with him, and the flocks, and herds, and the camels, into two bands;
And said, If Esau come to the one company, and smite it, then the other company which is left shall escape.
And Jacob said, O God of my father Abraham, and God of my father Isaac, the LORD which saidst unto me, Return unto thy country, and to thy kindred, and I will deal well with thee:
I am not worthy of the least of all the mercies, and of all the truth, which thou hast shewed unto thy servant; for with my staff I passed over this Jordan; and now I am become two bands.
Deliver me, I pray thee, from the hand of my brother, from the hand of Esau: for I fear him, lest he will come and smite me, and the mother with the children.
And thou saidst, I will surely do thee good, and make thy seed as the sand of the sea, which cannot be numbered for multitude.
And he lodged there that same night; and took of that which came to his hand a present for Esau his brother;
Two hundred she goats, and twenty he goats, two hundred ewes, and twenty rams,
Thirty milch camels with their colts, forty kine, and ten bulls, twenty she asses, and ten foals.
And he delivered them into the hand of his servants, every drove by themselves; and said unto his servants, Pass over before me, and put a space betwixt drove and drove.
And he commanded the foremost, saying, When Esau my brother meeteth thee, and asketh thee, saying, Whose art thou? and whither goest thou? and whose are these before thee?
Then thou shalt say, They be thy servant Jacob's; it is a present sent unto my lord Esau: and, behold, also he is behind us.
And so commanded he the second, and the third, and all that followed the droves, saying, On this manner shall ye speak unto Esau, when ye find him.
And say ye moreover, Behold, thy servant Jacob is behind us. For he said, I will appease him with the present that goeth before me, and afterward I will see his face; peradventure he will accept of me.
So went the present over before him: and himself lodged that night in the company.
And he rose up that night, and took his two wives, and his two womenservants, and his eleven sons, and passed over the ford Jabbok.
And he took them, and sent them over the brook, and sent over that he had.
And Jacob was left alone; and there wrestled a man with him until the breaking of the day.
And when he saw that he prevailed not against him, he touched the hollow of his thigh; and the hollow of Jacob's thigh was out of joint, as he wrestled with him.
And he said, Let me go, for the day breaketh. And he said, I will not let thee go, except thou bless me.
And he said unto him, What is thy name? And he said, Jacob.
And he said, Thy name shall be called no more Jacob, but Israel: for as a prince hast thou power with God and with men, and hast prevailed.
And Jacob asked him, and said, Tell me, I pray thee, thy name. And he said, Wherefore is it that thou dost ask after my name? And he blessed him there.
And Jacob called the name of the place Peniel: for I have seen God face to face, and my life is preserved.
And as he passed over Penuel the sun rose upon him, and he halted upon his thigh.
Therefore the children of Israel eat not of the sinew which shrank, which is upon the hollow of the thigh, unto this day: because he touched the hollow of Jacob's thigh in the sinew that shrank.

33.
And Jacob lifted up his eyes, and looked, and, behold, Esau came, and with him four hundred men. And he divided the children unto Leah, and unto Rachel, and unto the two handmaids.
And he put the handmaids and their children foremost, and Leah and her children after, and Rachel and Joseph hindermost.
And he passed over before them, and bowed himself to the ground seven times, until he came near to his brother.
And Esau ran to meet him, and embraced him, and fell on his neck, and kissed him: and they wept.
And he lifted up his eyes, and saw the women and the children; and said, Who are those with thee? And he said, The children which God hath graciously given thy servant.
Then the handmaidens came near, they and their children, and they bowed themselves.
And Leah also with her children came near, and bowed themselves: and after came Joseph near and Rachel, and they bowed themselves.
And he said, What meanest thou by all this drove which I met? And he said, These are to find grace in the sight of my lord.
And Esau said, I have enough, my brother; keep that thou hast unto thyself.
And Jacob said, Nay, I pray thee, if now I have found grace in thy sight, then receive my present at my hand: for therefore I have seen thy face, as though I had seen the face of God, and thou wast pleased with me.
Take, I pray thee, my blessing that is brought to thee; because God hath dealt graciously with me, and because I have enough. And he urged him, and he took it.
And he said, Let us take our journey, and let us go, and I will go before thee.
And he said unto him, My lord knoweth that the children are tender, and the flocks and herds with young are with me: and if men should overdrive them one day, all the flock will die.
Let my lord, I pray thee, pass over before his servant: and I will lead on softly, according as the cattle that goeth before me and the children be able to endure, until I come unto my lord unto Seir.
And Esau said, Let me now leave with thee some of the folk that are with me. And he said, What needeth it? let me find grace in the sight of my lord.
So Esau returned that day on his way unto Seir.
And Jacob journeyed to Succoth, and built him an house, and made booths for his cattle: therefore the name of the place is called Succoth.
And Jacob came to Shalem, a city of Shechem, which is in the land of Canaan, when he came from Padan-aram; and pitched his tent before the city.
And he bought a parcel of a field, where he had spread his tent, at the hand of the children of Hamor, Shechem's father, for an hundred pieces of money.
And he erected there an altar, and called it El-elohe-Israel.

34.
And Dinah the daughter of Leah, which she bare unto Jacob, went out to see the daughters of the land.
And when Shechem the son of Hamor the Hivite, prince of the country, saw her, he took her, and lay with her, and defiled her.
And his soul clave unto Dinah the daughter of Jacob, and he loved the damsel, and spake kindly unto the damsel.
And Shechem spake unto his father Hamor, saying, Get me this damsel to wife.
And Jacob heard that he had defiled Dinah his daughter: now his sons were with his cattle in the field: and Jacob held his peace until they were come.
And Hamor the father of Shechem went out unto Jacob to commune with him.
And the sons of Jacob came out of the field when they heard it: and the men were grieved, and they were very wroth, because he had wrought folly in Israel in lying with Jacob's daughter; which thing ought not to be done.
And Hamor communed with them, saying, The soul of my son Shechem longeth for your daughter: I pray you give her him to wife.
And make ye marriages with us, and give your daughters unto us, and take our daughters unto you.
And ye shall dwell with us: and the land shall be before you; dwell and trade ye therein, and get you possessions therein.
And Shechem said unto her father and unto her brethren, Let me find grace in your eyes, and what ye shall say unto me I will give.
Ask me never so much dowry and gift, and I will give according as ye shall say unto me: but give me the damsel to wife.
And the sons of Jacob answered Shechem and Hamor his father deceitfully, and said, because he had defiled Dinah their sister:
And they said unto them, We cannot do this thing, to give our sister to one that is uncircumcised; for that were a reproach unto us:
But in this will we consent unto you: If ye will be as we be, that every male of you be circumcised;
Then will we give our daughters unto you, and we will take your daughters to us, and we will dwell with you, and we will become one people.
But if ye will not hearken unto us, to be circumcised; then will we take our daughter, and we will be gone.
And their words pleased Hamor, and Shechem Hamor's son.
And the young man deferred not to do the thing, because he had delight in Jacob's daughter: and he was more honourable than all the house of his father.
And Hamor and Shechem his son came unto the gate of their city, and communed with the men of their city, saying,
These men are peaceable with us; therefore let them dwell in the land, and trade therein; for the land, behold, it is large enough for them; let us take their daughters to us for wives, and let us give them our daughters.
Only herein will the men consent unto us for to dwell with us, to be one people, if every male among us be circumcised, as they are circumcised.
Shall not their cattle and their substance and every beast of theirs be ours? only let us consent unto them, and they will dwell with us.
And unto Hamor and unto Shechem his son hearkened all that went out of the gate of his city; and every male was circumcised, all that went out of the gate of his city.
And it came to pass on the third day, when they were sore, that two of the sons of Jacob, Simeon and Levi, Dinah's brethren, took each man his sword, and came upon the city boldly, and slew all the males.
And they slew Hamor and Shechem his son with the edge of the sword, and took Dinah out of Shechem's house, and went out.
The sons of Jacob came upon the slain, and spoiled the city, because they had defiled their sister.
They took their sheep, and their oxen, and their asses, and that which was in the city, and that which was in the field,
And all their wealth, and all their little ones, and their wives took they captive, and spoiled even all that was in the house.
And Jacob said to Simeon and Levi, Ye have troubled me to make me to stink among the inhabitants of the land, among the Canaanites and the Perizzites: and I being few in number, they shall gather themselves together against me, and slay me; and I shall be destroyed, I and my house.
And they said, Should he deal with our sister as with an harlot?

35.
And God said unto Jacob, Arise, go up to Bethel, and dwell there: and make there an altar unto God, that appeared unto thee when thou fleddest from the face of Esau thy brother.
Then Jacob said unto his household, and to all that were with him, Put away the strange gods that are among you, and be clean, and change your garments:
And let us arise, and go up to Bethel; and I will make there an altar unto God, who answered me in the day of my distress, and was with me in the way which I went.
And they gave unto Jacob all the strange gods which were in their hand, and all their earrings which were in their ears; and Jacob hid them under the oak which was by Shechem.
And they journeyed: and the terror of God was upon the cities that were round about them, and they did not pursue after the sons of Jacob.
So Jacob came to Luz, which is in the land of Canaan, that is, Bethel, he and all the people that were with him.
And he built there an altar, and called the place El-beth-el: because there God appeared unto him, when he fled from the face of his brother.
But Deborah Rebekah's nurse died, and she was buried beneath Bethel under an oak: and the name of it was called Allon-bachuth.
And God appeared unto Jacob again, when he came out of Padan-aram, and blessed him.
And God said unto him, Thy name is Jacob: thy name shall not be called any more Jacob, but Israel shall be thy name: and he called his name Israel.
And God said unto him, I am God Almighty: be fruitful and multiply; a nation and a company of nations shall be of thee, and kings shall come out of thy loins;
And the land which I gave Abraham and Isaac, to thee I will give it, and to thy seed after thee will I give the land.
And God went up from him in the place where he talked with him.
And Jacob set up a pillar in the place where he talked with him, even a pillar of stone: and he poured a drink offering thereon, and he poured oil thereon.
And Jacob called the name of the place where God spake with him, Bethel.
And they journeyed from Bethel; and there was but a little way to come to Ephrath: and Rachel travailed, and she had hard labour.
And it came to pass, when she was in hard labour, that the midwife said unto her, Fear not; thou shalt have this son also.
And it came to pass, as her soul was in departing, (for she died) that she called his name Ben-oni: but his father called him Benjamin.
And Rachel died, and was buried in the way to Ephrath, which is Bethlehem.
And Jacob set a pillar upon her grave: that is the pillar of Rachel's grave unto this day.
And Israel journeyed, and spread his tent beyond the tower of Edar.
And it came to pass, when Israel dwelt in that land, that Reuben went and lay with Bilhah his father's concubine: and Israel heard it. Now the sons of Jacob were twelve:
The sons of Leah; Reuben, Jacob's firstborn, and Simeon, and Levi, and Judah, and Issachar, and Zebulun:
The sons of Rachel; Joseph, and Benjamin:
And the sons of Bilhah, Rachel's handmaid; Dan, and Naphtali:
And the sons of Zilpah, Leah's handmaid; Gad, and Asher: these are the sons of Jacob, which were born to him in Padan-aram.
And Jacob came unto Isaac his father unto Mamre, unto the city of Arbah, which is Hebron, where Abraham and Isaac sojourned.
And the days of Isaac were an hundred and fourscore years.
And Isaac gave up the ghost, and died, and was gathered unto his people, being old and full of days: and his sons Esau and Jacob buried him.

36.
Now these are the generations of Esau, who is Edom.
Esau took his wives of the daughters of Canaan; Adah the daughter of Elon the Hittite, and Aholibamah the daughter of Anah the daughter of Zibeon the Hivite;
And Bashemath Ishmael's daughter, sister of Nebajoth.
And Adah bare to Esau Eliphaz; and Bashemath bare Reuel;
And Aholibamah bare Jeush, and Jaalam, and Korah: these are the sons of Esau, which were born unto him in the land of Canaan.
And Esau took his wives, and his sons, and his daughters, and all the persons of his house, and his cattle, and all his beasts, and all his substance, which he had got in the land of Canaan; and went into the country from the face of his brother Jacob.
For their riches were more than that they might dwell together; and the land wherein they were strangers could not bear them because of their cattle.
Thus dwelt Esau in mount Seir: Esau is Edom.
And these are the generations of Esau the father of the Edomites in mount Seir:
These are the names of Esau's sons; Eliphaz the son of Adah the wife of Esau, Reuel the son of Bashemath the wife of Esau.
And the sons of Eliphaz were Teman, Omar, Zepho, and Gatam, and Kenaz.
And Timna was concubine to Eliphaz Esau's son; and she bare to Eliphaz Amalek: these were the sons of Adah Esau's wife.
And these are the sons of Reuel; Nahath, and Zerah, Shammah, and Mizzah: these were the sons of Bashemath Esau's wife.
And these were the sons of Aholibamah, the daughter of Anah the daughter of Zibeon, Esau's wife: and she bare to Esau Jeush, and Jaalam, and Korah.
These were dukes of the sons of Esau: the sons of Eliphaz the firstborn son of Esau; duke Teman, duke Omar, duke Zepho, duke Kenaz,
Duke Korah, duke Gatam, and duke Amalek: these are the dukes that came of Eliphaz in the land of Edom; these were the sons of Adah.
And these are the sons of Reuel Esau's son; duke Nahath, duke Zerah, duke Shammah, duke Mizzah: these are the dukes that came of Reuel in the land of Edom; these are the sons of Bashemath Esau's wife.
And these are the sons of Aholibamah Esau's wife; duke Jeush, duke Jaalam, duke Korah: these were the dukes that came of Aholibamah the daughter of Anah, Esau's wife.
These are the sons of Esau, who is Edom, and these are their dukes.
These are the sons of Seir the Horite, who inhabited the land; Lotan, and Shobal, and Zibeon, and Anah,
And Dishon, and Ezer, and Dishan: these are the dukes of the Horites, the children of Seir in the land of Edom.
And the children of Lotan were Hori and Hemam; and Lotan's sister was Timna.
And the children of Shobal were these; Alvan, and Manahath, and Ebal, Shepho, and Onam.
And these are the children of Zibeon; both Ajah, and Anah: this was that Anah that found the mules in the wilderness, as he fed the asses of Zibeon his father.
And the children of Anah were these; Dishon, and Aholibamah the daughter of Anah.
And these are the children of Dishon; Hemdan, and Eshban, and Ithran, and Cheran.
The children of Ezer are these; Bilhan, and Zaavan, and Akan.
The children of Dishan are these: Uz, and Aran.
These are the dukes that came of the Horites; duke Lotan, duke Shobal, duke Zibeon, duke Anah,
Duke Dishon, duke Ezer, duke Dishan: these are the dukes that came of Hori, among their dukes in the land of Seir.
And these are the kings that reigned in the land of Edom, before there reigned any king over the children of Israel.
And Bela the son of Beor reigned in Edom: and the name of his city was Dinhabah.
And Bela died, and Jobab the son of Zerah of Bozrah reigned in his stead.
And Jobab died, and Husham of the land of Temani reigned in his stead.
And Husham died, and Hadad the son of Bedad, who smote Midian in the field of Moab, reigned in his stead: and the name of his city was Avith.
And Hadad died, and Samlah of Masrekah reigned in his stead.
And Samlah died, and Saul of Rehoboth by the river reigned in his stead.
And Saul died, and Baal-hanan the son of Achbor reigned in his stead.
And Baal-hanan the son of Achbor died, and Hadar reigned in his stead: and the name of his city was Pau; and his wife's name was Mehetabel, the daughter of Matred, the daughter of Mezahab.
And these are the names of the dukes that came of Esau, according to their families, after their places, by their names; duke Timnah, duke Alvah, duke Jetheth,
Duke Aholibamah, duke Elah, duke Pinon,
Duke Kenaz, duke Teman, duke Mibzar,
Duke Magdiel, duke Iram: these be the dukes of Edom, according to their habitations in the land of their possession: he is Esau the father of the Edomites.

37.
And Jacob dwelt in the land wherein his father was a stranger, in the land of Canaan.
These are the generations of Jacob. Joseph, being seventeen years old, was feeding the flock with his brethren; and the lad was with the sons of Bilhah, and with the sons of Zilpah, his father's wives: and Joseph brought unto his father their evil report.
Now Israel loved Joseph more than all his children, because he was the son of his old age: and he made him a coat of many colours.
And when his brethren saw that their father loved him more than all his brethren, they hated him, and could not speak peaceably unto him.
And Joseph dreamed a dream, and he told it his brethren: and they hated him yet the more.
And he said unto them, Hear, I pray you, this dream which I have dreamed:
For, behold, we were binding sheaves in the field, and, lo, my sheaf arose, and also stood upright; and, behold, your sheaves stood round about, and made obeisance to my sheaf.
And his brethren said to him, Shalt thou indeed reign over us? or shalt thou indeed have dominion over us? And they hated him yet the more for his dreams, and for his words.
And he dreamed yet another dream, and told it his brethren, and said, Behold, I have dreamed a dream more; and, behold, the sun and the moon and the eleven stars made obeisance to me.
And he told it to his father, and to his brethren: and his father rebuked him, and said unto him, What is this dream that thou hast dreamed? Shall I and thy mother and thy brethren indeed come to bow down ourselves to thee to the earth?
And his brethren envied him; but his father observed the saying.
And his brethren went to feed their father's flock in Shechem.
And Israel said unto Joseph, Do not thy brethren feed the flock in Shechem? come, and I will send thee unto them. And he said to him, Here am I.
And he said to him, Go, I pray thee, see whether it be well with thy brethren, and well with the flocks; and bring me word again. So he sent him out of the vale of Hebron, and he came to Shechem.
And a certain man found him, and, behold, he was wandering in the field: and the man asked him, saying, What seekest thou?
And he said, I seek my brethren: tell me, I pray thee, where they feed their flocks.
And the man said, They are departed hence; for I heard them say, Let us go to Dothan. And Joseph went after his brethren, and found them in Dothan.
And when they saw him afar off, even before he came near unto them, they conspired against him to slay him.
And they said one to another, Behold, this dreamer cometh.
Come now therefore, and let us slay him, and cast him into some pit, and we will say, Some evil beast hath devoured him: and we shall see what will become of his dreams.
And Reuben heard it, and he delivered him out of their hands; and said, Let us not kill him.
And Reuben said unto them, Shed no blood, but cast him into this pit that is in the wilderness, and lay no hand upon him; that he might rid him out of their hands, to deliver him to his father again.
And it came to pass, when Joseph was come unto his brethren, that they stript Joseph out of his coat, his coat of many colours that was on him;
And they took him, and cast him into a pit: and the pit was empty, there was no water in it.
And they sat down to eat bread: and they lifted up their eyes and looked, and, behold, a company of Ishmeelites came from Gilead with their camels bearing spicery and balm and myrrh, going to carry it down to Egypt.
And Judah said unto his brethren, What profit is it if we slay our brother, and conceal his blood?
Come, and let us sell him to the Ishmeelites, and let not our hand be upon him; for he is our brother and our flesh. And his brethren were content.
Then there passed by Midianites merchantmen; and they drew and lifted up Joseph out of the pit, and sold Joseph to the Ishmeelites for twenty pieces of silver: and they brought Joseph into Egypt.
And Reuben returned unto the pit; and, behold, Joseph was not in the pit; and he rent his clothes.
And he returned unto his brethren, and said, The child is not; and I, whither shall I go?
And they took Joseph's coat, and killed a kid of the goats, and dipped the coat in the blood;
And they sent the coat of many colours, and they brought it to their father; and said, This have we found: know now whether it be thy son's coat or no.
And he knew it, and said, It is my son's coat; an evil beast hath devoured him; Joseph is without doubt rent in pieces.
And Jacob rent his clothes, and put sackcloth upon his loins, and mourned for his son many days.
And all his sons and all his daughters rose up to comfort him; but he refused to be comforted; and he said, For I will go down into the grave unto my son mourning. Thus his father wept for him.
And the Midianites sold him into Egypt unto Potiphar, an officer of Pharaoh's, and captain of the guard.

38.
And it came to pass at that time, that Judah went down from his brethren, and turned in to a certain Adullamite, whose name was Hirah.
And Judah saw there a daughter of a certain Canaanite, whose name was Shuah; and he took her, and went in unto her.
And she conceived, and bare a son; and he called his name Er.
And she conceived again, and bare a son; and she called his name Onan.
And she yet again conceived, and bare a son; and called his name Shelah: and he was at Chezib, when she bare him.
And Judah took a wife for Er his firstborn, whose name was Tamar.
And Er, Judah's firstborn, was wicked in the sight of the LORD; and the LORD slew him.
And Judah said unto Onan, Go in unto thy brother's wife, and marry her, and raise up seed to thy brother.
And Onan knew that the seed should not be his; and it came to pass, when he went in unto his brother's wife, that he spilled it on the ground, lest that he should give seed to his brother.
And the thing which he did displeased the LORD: wherefore he slew him also.
Then said Judah to Tamar his daughter in law, Remain a widow at thy father's house, till Shelah my son be grown: for he said, Lest peradventure he die also, as his brethren did. And Tamar went and dwelt in her father's house.
And in process of time the daughter of Shuah Judah's wife died; and Judah was comforted, and went up unto his sheepshearers to Timnath, he and his friend Hirah the Adullamite.
And it was told Tamar, saying, Behold thy father in law goeth up to Timnath to shear his sheep.
And she put her widow's garments off from her, and covered her with a vail, and wrapped herself, and sat in an open place, which is by the way to Timnath; for she saw that Shelah was grown, and she was not given unto him to wife.
When Judah saw her, he thought her to be an harlot; because she had covered her face.
And he turned unto her by the way, and said, Go to, I pray thee, let me come in unto thee; (for he knew not that she was his daughter in law.) And she said, What wilt thou give me, that thou mayest come in unto me?
And he said, I will send thee a kid from the flock. And she said, Wilt thou give me a pledge, till thou send it?
And he said, What pledge shall I give thee? And she said, Thy signet, and thy bracelets, and thy staff that is in thine hand. And he gave it her, and came in unto her, and she conceived by him.
And she arose, and went away, and laid by her vail from her, and put on the garments of her widowhood.
And Judah sent the kid by the hand of his friend the Adullamite, to receive his pledge from the woman's hand: but he found her not.
Then he asked the men of that place, saying, Where is the harlot, that was openly by the way side? And they said, There was no harlot in this place.
And he returned to Judah, and said, I cannot find her; and also the men of the place said, that there was no harlot in this place.
And Judah said, Let her take it to her, lest we be shamed: behold, I sent this kid, and thou hast not found her.
And it came to pass about three months after, that it was told Judah, saying, Tamar thy daughter in law hath played the harlot; and also, behold, she is with child by whoredom. And Judah said, Bring her forth, and let her be burnt.
When she was brought forth, she sent to her father in law, saying, By the man, whose these are, am I with child: and she said, Discern, I pray thee, whose are these, the signet, and bracelets, and staff.
And Judah acknowledged them, and said, She hath been more righteous than I; because that I gave her not to Shelah my son. And he knew her again no more.
And it came to pass in the time of her travail, that, behold, twins were in her womb.
And it came to pass, when she travailed, that the one put out his hand: and the midwife took and bound upon his hand a scarlet thread, saying, This came out first,
And it came to pass, as he drew back his hand, that, behold, his brother came out: and she said, How hast thou broken forth? this breach be upon thee: therefore his name was called Pharez.
And afterward came out his brother, that had the scarlet thread upon his hand: and his name was called Zarah.

39.
And Joseph was brought down to Egypt; and Potiphar, an officer of Pharaoh, captain of the guard, an Egyptian, bought him of the hands of the Ishmeelites, which had brought him down thither.
And the LORD was with Joseph, and he was a prosperous man; and he was in the house of his master the Egyptian.
And his master saw that the LORD was with him, and that the LORD made all that he did to prosper in his hand.
And Joseph found grace in his sight, and he served him: and he made him overseer over his house, and all that he had he put into his hand.
And it came to pass from the time that he had made him overseer in his house, and over all that he had, that the LORD blessed the Egyptian's house for Joseph's sake; and the blessing of the LORD was upon all that he had in the house, and in the field.
And he left all that he had in Joseph's hand; and he knew not ought he had, save the bread which he did eat. And Joseph was a goodly person, and well favoured.
And it came to pass after these things, that his master's wife cast her eyes upon Joseph; and she said, Lie with me.
But he refused, and said unto his master's wife, Behold, my master wotteth not what is with me in the house, and he hath committed all that he hath to my hand;
There is none greater in this house than I; neither hath he kept back any thing from me but thee, because thou art his wife: how then can I do this great wickedness, and sin against God?
And it came to pass, as she spake to Joseph day by day, that he hearkened not unto her, to lie by her, or to be with her.
And it came to pass about this time, that Joseph went into the house to do his business; and there was none of the men of the house there within.
And she caught him by his garment, saying, Lie with me: and he left his garment in her hand, and fled, and got him out.
And it came to pass, when she saw that he had left his garment in her hand, and was fled forth,
That she called unto the men of her house, and spake unto them, saying, See, he hath brought in an Hebrew unto us to mock us; he came in unto me to lie with me, and I cried with a loud voice:
And it came to pass, when he heard that I lifted up my voice and cried, that he left his garment with me, and fled, and got him out.
And she laid up his garment by her, until his lord came home.
And she spake unto him according to these words, saying, The Hebrew servant, which thou hast brought unto us, came in unto me to mock me:
And it came to pass, as I lifted up my voice and cried, that he left his garment with me, and fled out.
And it came to pass, when his master heard the words of his wife, which she spake unto him, saying, After this manner did thy servant to me; that his wrath was kindled.
And Joseph's master took him, and put him into the prison, a place where the king's prisoners were bound: and he was there in the prison.
But the LORD was with Joseph, and shewed him mercy, and gave him favour in the sight of the keeper of the prison.
And the keeper of the prison committed to Joseph's hand all the prisoners that were in the prison; and whatsoever they did there, he was the doer of it.
The keeper of the prison looked not to any thing that was under his hand; because the LORD was with him, and that which he did, the LORD made it to prosper.

40.
And it came to pass after these things, that the butler of the king of Egypt and his baker had offended their lord the king of Egypt.
And Pharaoh was wroth against two of his officers, against the chief of the butlers, and against the chief of the bakers.
And he put them in ward in the house of the captain of the guard, into the prison, the place where Joseph was bound.
And the captain of the guard charged Joseph with them, and he served them: and they continued a season in ward.
And they dreamed a dream both of them, each man his dream in one night, each man according to the interpretation of his dream, the butler and the baker of the king of Egypt, which were bound in the prison.
And Joseph came in unto them in the morning, and looked upon them, and, behold, they were sad.
And he asked Pharaoh's officers that were with him in the ward of his lord's house, saying, Wherefore look ye so sadly to day?
And they said unto him, We have dreamed a dream, and there is no interpreter of it. And Joseph said unto them, Do not interpretations belong to God? tell me them, I pray you.
And the chief butler told his dream to Joseph, and said to him, In my dream, behold, a vine was before me;
And in the vine were three branches: and it was as though it budded, and her blossoms shot forth; and the clusters thereof brought forth ripe grapes:
And Pharaoh's cup was in my hand: and I took the grapes, and pressed them into Pharaoh's cup, and I gave the cup into Pharaoh's hand.
And Joseph said unto him, This is the interpretation of it: The three branches are three days:
Yet within three days shall Pharaoh lift up thine head, and restore thee unto thy place: and thou shalt deliver Pharaoh's cup into his hand, after the former manner when thou wast his butler.
But think on me when it shall be well with thee, and shew kindness, I pray thee, unto me, and make mention of me unto Pharaoh, and bring me out of this house:
For indeed I was stolen away out of the land of the Hebrews: and here also have I done nothing that they should put me into the dungeon.
When the chief baker saw that the interpretation was good, he said unto Joseph, I also was in my dream, and, behold, I had three white baskets on my head:
And in the uppermost basket there was of all manner of bakemeats for Pharaoh; and the birds did eat them out of the basket upon my head.
And Joseph answered and said, This is the interpretation thereof: The three baskets are three days:
Yet within three days shall Pharaoh lift up thy head from off thee, and shall hang thee on a tree; and the birds shall eat thy flesh from off thee.
And it came to pass the third day, which was Pharaoh's birthday, that he made a feast unto all his servants: and he lifted up the head of the chief butler and of the chief baker among his servants.
And he restored the chief butler unto his butlership again; and he gave the cup into Pharaoh's hand:
But he hanged the chief baker: as Joseph had interpreted to them.
Yet did not the chief butler remember Joseph, but forgat him.

41.
And it came to pass at the end of two full years, that Pharaoh dreamed: and, behold, he stood by the river.
And, behold, there came up out of the river seven well favoured kine and fatfleshed; and they fed in a meadow.
And, behold, seven other kine came up after them out of the river, ill favoured and leanfleshed; and stood by the other kine upon the brink of the river.
And the ill favoured and leanfleshed kine did eat up the seven well favoured and fat kine. So Pharaoh awoke.
And he slept and dreamed the second time: and, behold, seven ears of corn came up upon one stalk, rank and good.
And, behold, seven thin ears and blasted with the east wind sprung up after them.
And the seven thin ears devoured the seven rank and full ears. And Pharaoh awoke, and, behold, it was a dream.
And it came to pass in the morning that his spirit was troubled; and he sent and called for all the magicians of Egypt, and all the wise men thereof: and Pharaoh told them his dream; but there was none that could interpret them unto Pharaoh.
Then spake the chief butler unto Pharaoh, saying, I do remember my faults this day:
Pharaoh was wroth with his servants, and put me in ward in the captain of the guard's house, both me and the chief baker:
And we dreamed a dream in one night, I and he; we dreamed each man according to the interpretation of his dream.
And there was there with us a young man, an Hebrew, servant to the captain of the guard; and we told him, and he interpreted to us our dreams; to each man according to his dream he did interpret.
And it came to pass, as he interpreted to us, so it was; me he restored unto mine office, and him he hanged.
Then Pharaoh sent and called Joseph, and they brought him hastily out of the dungeon: and he shaved himself, and changed his raiment, and came in unto Pharaoh.
And Pharaoh said unto Joseph, I have dreamed a dream, and there is none that can interpret it: and I have heard say of thee, that thou canst understand a dream to interpret it.
And Joseph answered Pharaoh, saying, It is not in me: God shall give Pharaoh an answer of peace.
And Pharaoh said unto Joseph, In my dream, behold, I stood upon the bank of the river:
And, behold, there came up out of the river seven kine, fatfleshed and well favoured; and they fed in a meadow:
And, behold, seven other kine came up after them, poor and very ill favoured and leanfleshed, such as I never saw in all the land of Egypt for badness:
And the lean and the ill favoured kine did eat up the first seven fat kine:
And when they had eaten them up, it could not be known that they had eaten them; but they were still ill favoured, as at the beginning. So I awoke.
And I saw in my dream, and, behold, seven ears came up in one stalk, full and good:
And, behold, seven ears, withered, thin, and blasted with the east wind, sprung up after them:
And the thin ears devoured the seven good ears: and I told this unto the magicians; but there was none that could declare it to me.
And Joseph said unto Pharaoh, The dream of Pharaoh is one: God hath shewed Pharaoh what he is about to do.
The seven good kine are seven years; and the seven good ears are seven years: the dream is one.
And the seven thin and ill favoured kine that came up after them are seven years; and the seven empty ears blasted with the east wind shall be seven years of famine.
This is the thing which I have spoken unto Pharaoh: What God is about to do he sheweth unto Pharaoh.
Behold, there come seven years of great plenty throughout all the land of Egypt:
And there shall arise after them seven years of famine; and all the plenty shall be forgotten in the land of Egypt; and the famine shall consume the land;
And the plenty shall not be known in the land by reason of that famine following; for it shall be very grievous.
And for that the dream was doubled unto Pharaoh twice; it is because the thing is established by God, and God will shortly bring it to pass.
Now therefore let Pharaoh look out a man discreet and wise, and set him over the land of Egypt.
Let Pharaoh do this, and let him appoint officers over the land, and take up the fifth part of the land of Egypt in the seven plenteous years.
And let them gather all the food of those good years that come, and lay up corn under the hand of Pharaoh, and let them keep food in the cities.
And that food shall be for store to the land against the seven years of famine, which shall be in the land of Egypt; that the land perish not through the famine.
And the thing was good in the eyes of Pharaoh, and in the eyes of all his servants.
And Pharaoh said unto his servants, Can we find such a one as this is, a man in whom the Spirit of God is?
And Pharaoh said unto Joseph, Forasmuch as God hath shewed thee all this, there is none so discreet and wise as thou art:
Thou shalt be over my house, and according unto thy word shall all my people be ruled: only in the throne will I be greater than thou.
And Pharaoh said unto Joseph, See, I have set thee over all the land of Egypt.
And Pharaoh took off his ring from his hand, and put it upon Joseph's hand, and arrayed him in vestures of fine linen, and put a gold chain about his neck;
And he made him to ride in the second chariot which he had; and they cried before him, Bow the knee: and he made him ruler over all the land of Egypt.
And Pharaoh said unto Joseph, I am Pharaoh, and without thee shall no man lift up his hand or foot in all the land of Egypt.
And Pharaoh called Joseph's name Zaphnath-paaneah; and he gave him to wife Asenath the daughter of Poti-pherah priest of On. And Joseph went out over all the land of Egypt.
And Joseph was thirty years old when he stood before Pharaoh king of Egypt. And Joseph went out from the presence of Pharaoh, and went throughout all the land of Egypt.
And in the seven plenteous years the earth brought forth by handfuls.
And he gathered up all the food of the seven years, which were in the land of Egypt, and laid up the food in the cities: the food of the field, which was round about every city, laid he up in the same.
And Joseph gathered corn as the sand of the sea, very much, until he left numbering; for it was without number.
And unto Joseph were born two sons before the years of famine came, which Asenath the daughter of Poti-pherah priest of On bare unto him.
And Joseph called the name of the firstborn Manasseh: For God, said he, hath made me forget all my toil, and all my father's house.
And the name of the second called he Ephraim: For God hath caused me to be fruitful in the land of my affliction.
And the seven years of plenteousness, that was in the land of Egypt, were ended.
And the seven years of dearth began to come, according as Joseph had said: and the dearth was in all lands; but in all the land of Egypt there was bread.
And when all the land of Egypt was famished, the people cried to Pharaoh for bread: and Pharaoh said unto all the Egyptians, Go unto Joseph; what he saith to you, do.
And the famine was over all the face of the earth: and Joseph opened all the storehouses, and sold unto the Egyptians; and the famine waxed sore in the land of Egypt.
And all countries came into Egypt to Joseph for to buy corn; because that the famine was so sore in all lands.

42.
Now when Jacob saw that there was corn in Egypt, Jacob said unto his sons, Why do ye look one upon another?
And he said, Behold, I have heard that there is corn in Egypt: get you down thither, and buy for us from thence; that we may live, and not die.
And Joseph's ten brethren went down to buy corn in Egypt.
But Benjamin, Joseph's brother, Jacob sent not with his brethren; for he said, Lest peradventure mischief befall him.
And the sons of Israel came to buy corn among those that came: for the famine was in the land of Canaan.
And Joseph was the governor over the land, and he it was that sold to all the people of the land: and Joseph's brethren came, and bowed down themselves before him with their faces to the earth.
And Joseph saw his brethren, and he knew them, but made himself strange unto them, and spake roughly unto them; and he said unto them, Whence come ye? And they said, From the land of Canaan to buy food.
And Joseph knew his brethren, but they knew not him.
And Joseph remembered the dreams which he dreamed of them, and said unto them, Ye are spies; to see the nakedness of the land ye are come.
And they said unto him, Nay, my lord, but to buy food are thy servants come.
We are all one man's sons; we are true men, thy servants are no spies.
And he said unto them, Nay, but to see the nakedness of the land ye are come.
And they said, Thy servants are twelve brethren, the sons of one man in the land of Canaan; and, behold, the youngest is this day with our father, and one is not.
And Joseph said unto them, That is it that I spake unto you, saying, Ye are spies:
Hereby ye shall be proved: By the life of Pharaoh ye shall not go forth hence, except your youngest brother come hither.
Send one of you, and let him fetch your brother, and ye shall be kept in prison, that your words may be proved, whether there be any truth in you: or else by the life of Pharaoh surely ye are spies.
And he put them all together into ward three days.
And Joseph said unto them the third day, This do, and live; for I fear God:
If ye be true men, let one of your brethren be bound in the house of your prison: go ye, carry corn for the famine of your houses:
But bring your youngest brother unto me; so shall your words be verified, and ye shall not die. And they did so.
And they said one to another, We are verily guilty concerning our brother, in that we saw the anguish of his soul, when he besought us, and we would not hear; therefore is this distress come upon us.
And Reuben answered them, saying, Spake I not unto you, saying, Do not sin against the child; and ye would not hear? therefore, behold, also his blood is required.
And they knew not that Joseph understood them; for he spake unto them by an interpreter.
And he turned himself about from them, and wept; and returned to them again, and communed with them, and took from them Simeon, and bound him before their eyes.
Then Joseph commanded to fill their sacks with corn, and to restore every man's money into his sack, and to give them provision for the way: and thus did he unto them.
And they laded their asses with the corn, and departed thence.
And as one of them opened his sack to give his ass provender in the inn, he espied his money; for, behold, it was in his sack's mouth.
And he said unto his brethren, My money is restored; and, lo, it is even in my sack: and their heart failed them, and they were afraid, saying one to another, What is this that God hath done unto us?
And they came unto Jacob their father unto the land of Canaan, and told him all that befell unto them; saying,
The man, who is the lord of the land, spake roughly to us, and took us for spies of the country.
And we said unto him, We are true men; we are no spies:
We be twelve brethren, sons of our father; one is not, and the youngest is this day with our father in the land of Canaan.
And the man, the lord of the country, said unto us, Hereby shall I know that ye are true men; leave one of your brethren here with me, and take food for the famine of your households, and be gone:
And bring your youngest brother unto me: then shall I know that ye are no spies, but that ye are true men: so will I deliver you your brother, and ye shall traffick in the land.
And it came to pass as they emptied their sacks, that, behold, every man's bundle of money was in his sack: and when both they and their father saw the bundles of money, they were afraid.
And Jacob their father said unto them, Me have ye bereaved of my children: Joseph is not, and Simeon is not, and ye will take Benjamin away: all these things are against me.
And Reuben spake unto his father, saying, Slay my two sons, if I bring him not to thee: deliver him into my hand, and I will bring him to thee again.
And he said, My son shall not go down with you; for his brother is dead, and he is left alone: if mischief befall him by the way in the which ye go, then shall ye bring down my gray hairs with sorrow to the grave.

43.
And the famine was sore in the land.
And it came to pass, when they had eaten up the corn which they had brought out of Egypt, their father said unto them, Go again, buy us a little food.
And Judah spake unto him, saying, The man did solemnly protest unto us, saying, Ye shall not see my face, except your brother be with you.
If thou wilt send our brother with us, we will go down and buy thee food:
But if thou wilt not send him, we will not go down: for the man said unto us, Ye shall not see my face, except your brother be with you.
And Israel said, Wherefore dealt ye so ill with me, as to tell the man whether ye had yet a brother?
And they said, The man asked us straitly of our state, and of our kindred, saying, Is your father yet alive? have ye another brother? and we told him according to the tenor of these words: could we certainly know that he would say, Bring your brother down?
And Judah said unto Israel his father, Send the lad with me, and we will arise and go; that we may live, and not die, both we, and thou, and also our little ones.
I will be surety for him; of my hand shalt thou require him: if I bring him not unto thee, and set him before thee, then let me bear the blame for ever:
For except we had lingered, surely now we had returned this second time.
And their father Israel said unto them, If it must be so now, do this; take of the best fruits in the land in your vessels, and carry down the man a present, a little balm, and a little honey, spices, and myrrh, nuts, and almonds:
And take double money in your hand; and the money that was brought again in the mouth of your sacks, carry it again in your hand; peradventure it was an oversight:
Take also your brother, and arise, go again unto the man:
And God Almighty give you mercy before the man, that he may send away your other brother, and Benjamin. If I be bereaved of my children, I am bereaved.
And the men took that present, and they took double money in their hand, and Benjamin; and rose up, and went down to Egypt, and stood before Joseph.
And when Joseph saw Benjamin with them, he said to the ruler of his house, Bring these men home, and slay, and make ready; for these men shall dine with me at noon.
And the man did as Joseph bade; and the man brought the men into Joseph's house.
And the men were afraid, because they were brought into Joseph's house; and they said, Because of the money that was returned in our sacks at the first time are we brought in; that he may seek occasion against us, and fall upon us, and take us for bondmen, and our asses.
And they came near to the steward of Joseph's house, and they communed with him at the door of the house,
And said, O sir, we came indeed down at the first time to buy food:
And it came to pass, when we came to the inn, that we opened our sacks, and, behold, every man's money was in the mouth of his sack, our money in full weight: and we have brought it again in our hand.
And other money have we brought down in our hands to buy food: we cannot tell who put our money in our sacks.
And he said, Peace be to you, fear not: your God, and the God of your father, hath given you treasure in your sacks: I had your money. And he brought Simeon out unto them.
And the man brought the men into Joseph's house, and gave them water, and they washed their feet; and he gave their asses provender.
And they made ready the present against Joseph came at noon: for they heard that they should eat bread there.
And when Joseph came home, they brought him the present which was in their hand into the house, and bowed themselves to him to the earth.
And he asked them of their welfare, and said, Is your father well, the old man of whom ye spake? Is he yet alive?
And they answered, Thy servant our father is in good health, he is yet alive. And they bowed down their heads, and made obeisance.
And he lifted up his eyes, and saw his brother Benjamin, his mother's son, and said, Is this your younger brother, of whom ye spake unto me? And he said, God be gracious unto thee, my son.
And Joseph made haste; for his bowels did yearn upon his brother: and he sought where to weep; and he entered into his chamber, and wept there.
And he washed his face, and went out, and refrained himself, and said, Set on bread.
And they set on for him by himself, and for them by themselves, and for the Egyptians, which did eat with him, by themselves: because the Egyptians might not eat bread with the Hebrews; for that is an abomination unto the Egyptians.
And they sat before him, the firstborn according to his birthright, and the youngest according to his youth: and the men marvelled one at another.
And he took and sent messes unto them from before him: but Benjamin's mess was five times so much as any of theirs. And they drank, and were merry with him.

44.
And he commanded the steward of his house, saying, Fill the men's sacks with food, as much as they can carry, and put every man's money in his sack's mouth.
And put my cup, the silver cup, in the sack's mouth of the youngest, and his corn money. And he did according to the word that Joseph had spoken.
As soon as the morning was light, the men were sent away, they and their asses.
And when they were gone out of the city, and not yet far off, Joseph said unto his steward, Up, follow after the men; and when thou dost overtake them, say unto them, Wherefore have ye rewarded evil for good?
Is not this it in which my lord drinketh, and whereby indeed he divineth? ye have done evil in so doing.
And he overtook them, and he spake unto them these same words.
And they said unto him, Wherefore saith my lord these words? God forbid that thy servants should do according to this thing:
Behold, the money, which we found in our sacks' mouths, we brought again unto thee out of the land of Canaan: how then should we steal out of thy lord's house silver or gold?
With whomsoever of thy servants it be found, both let him die, and we also will be my lord's bondmen.
And he said, Now also let it be according unto your words; he with whom it is found shall be my servant; and ye shall be blameless.
Then they speedily took down every man his sack to the ground, and opened every man his sack.
And he searched, and began at the eldest, and left at the youngest: and the cup was found in Benjamin's sack.
Then they rent their clothes, and laded every man his ass, and returned to the city.
And Judah and his brethren came to Joseph's house; for he was yet there: and they fell before him on the ground.
And Joseph said unto them, What deed is this that ye have done? wot ye not that such a man as I can certainly divine?
And Judah said, What shall we say unto my lord? what shall we speak? or how shall we clear ourselves? God hath found out the iniquity of thy servants: behold, we are my lord's servants, both we, and he also with whom the cup is found.
And he said, God forbid that I should do so: but the man in whose hand the cup is found, he shall be my servant; and as for you, get you up in peace unto your father.
Then Judah came near unto him, and said, Oh my lord, let thy servant, I pray thee, speak a word in my lord's ears, and let not thine anger burn against thy servant: for thou art even as Pharaoh.
My lord asked his servants, saying, Have ye a father, or a brother?
And we said unto my lord, We have a father, an old man, and a child of his old age, a little one; and his brother is dead, and he alone is left of his mother, and his father loveth him.
And thou saidst unto thy servants, Bring him down unto me, that I may set mine eyes upon him.
And we said unto my lord, The lad cannot leave his father: for if he should leave his father, his father would die.
And thou saidst unto thy servants, Except your youngest brother come down with you, ye shall see my face no more.
And it came to pass when we came up unto thy servant my father, we told him the words of my lord.
And our father said, Go again, and buy us a little food.
And we said, We cannot go down: if our youngest brother be with us, then will we go down: for we may not see the man's face, except our youngest brother be with us.
And thy servant my father said unto us, Ye know that my wife bare me two sons:
And the one went out from me, and I said, Surely he is torn in pieces; and I saw him not since:
And if ye take this also from me, and mischief befall him, ye shall bring down my gray hairs with sorrow to the grave.
Now therefore when I come to thy servant my father, and the lad be not with us; seeing that his life is bound up in the lad's life;
It shall come to pass, when he seeth that the lad is not with us, that he will die: and thy servants shall bring down the gray hairs of thy servant our father with sorrow to the grave.
For thy servant became surety for the lad unto my father, saying, If I bring him not unto thee, then I shall bear the blame to my father for ever.
Now therefore, I pray thee, let thy servant abide instead of the lad a bondman to my lord; and let the lad go up with his brethren.
For how shall I go up to my father, and the lad be not with me? lest peradventure I see the evil that shall come on my father.

45.
Then Joseph could not refrain himself before all them that stood by him; and he cried, Cause every man to go out from me. And there stood no man with him, while Joseph made himself known unto his brethren.
And he wept aloud: and the Egyptians and the house of Pharaoh heard.
And Joseph said unto his brethren, I am Joseph; doth my father yet live? And his brethren could not answer him; for they were troubled at his presence.
And Joseph said unto his brethren, Come near to me, I pray you. And they came near. And he said, I am Joseph your brother, whom ye sold into Egypt.
Now therefore be not grieved, nor angry with yourselves, that ye sold me hither: for God did send me before you to preserve life.
For these two years hath the famine been in the land: and yet there are five years, in the which there shall neither be earing nor harvest.
And God sent me before you to preserve you a posterity in the earth, and to save your lives by a great deliverance.
So now it was not you that sent me hither, but God: and he hath made me a father to Pharaoh, and lord of all his house, and a ruler throughout all the land of Egypt.
Haste ye, and go up to my father, and say unto him, Thus saith thy son Joseph, God hath made me lord of all Egypt: come down unto me, tarry not:
And thou shalt dwell in the land of Goshen, and thou shalt be near unto me, thou, and thy children, and thy children's children, and thy flocks, and thy herds, and all that thou hast:
And there will I nourish thee; for yet there are five years of famine; lest thou, and thy household, and all that thou hast, come to poverty.
And, behold, your eyes see, and the eyes of my brother Benjamin, that it is my mouth that speaketh unto you.
And ye shall tell my father of all my glory in Egypt, and of all that ye have seen; and ye shall haste and bring down my father hither.
And he fell upon his brother Benjamin's neck, and wept; and Benjamin wept upon his neck.
Moreover he kissed all his brethren, and wept upon them: and after that his brethren talked with him.
And the fame thereof was heard in Pharaoh's house, saying, Joseph's brethren are come: and it pleased Pharaoh well, and his servants.
And Pharaoh said unto Joseph, Say unto thy brethren, This do ye; lade your beasts, and go, get you unto the land of Canaan;
And take your father and your households, and come unto me: and I will give you the good of the land of Egypt, and ye shall eat the fat of the land.
Now thou art commanded, this do ye; take you wagons out of the land of Egypt for your little ones, and for your wives, and bring your father, and come.
Also regard not your stuff; for the good of all the land of Egypt is yours.
And the children of Israel did so: and Joseph gave them wagons, according to the commandment of Pharaoh, and gave them provision for the way.
To all of them he gave each man changes of raiment; but to Benjamin he gave three hundred pieces of silver, and five changes of raiment.
And to his father he sent after this manner; ten asses laden with the good things of Egypt, and ten she asses laden with corn and bread and meat for his father by the way.
So he sent his brethren away, and they departed: and he said unto them, See that ye fall not out by the way.
And they went up out of Egypt, and came into the land of Canaan unto Jacob their father,
And told him, saying, Joseph is yet alive, and he is governor over all the land of Egypt. And Jacob's heart fainted, for he believed them not.
And they told him all the words of Joseph, which he had said unto them: and when he saw the wagons which Joseph had sent to carry him, the spirit of Jacob their father revived:
And Israel said, It is enough; Joseph my son is yet alive: I will go and see him before I die.

46.
And Israel took his journey with all that he had, and came to Beer-sheba, and offered sacrifices unto the God of his father Isaac.
And God spake unto Israel in the visions of the night, and said, Jacob, Jacob. And he said, Here am I.
And he said, I am God, the God of thy father: fear not to go down into Egypt; for I will there make of thee a great nation:
I will go down with thee into Egypt; and I will also surely bring thee up again: and Joseph shall put his hand upon thine eyes.
And Jacob rose up from Beer-sheba: and the sons of Israel carried Jacob their father, and their little ones, and their wives, in the wagons which Pharaoh had sent to carry him.
And they took their cattle, and their goods, which they had gotten in the land of Canaan, and came into Egypt, Jacob, and all his seed with him:
His sons, and his sons' sons with him, his daughters, and his sons' daughters, and all his seed brought he with him into Egypt.
And these are the names of the children of Israel, which came into Egypt, Jacob and his sons: Reuben, Jacob's firstborn.
And the sons of Reuben; Hanoch, and Phallu, and Hezron, and Carmi.
And the sons of Simeon; Jemuel, and Jamin, and Ohad, and Jachin, and Zohar, and Shaul the son of a Canaanitish woman.
And the sons of Levi; Gershon, Kohath, and Merari.
And the sons of Judah; Er, and Onan, and Shelah, and Pharez, and Zerah: but Er and Onan died in the land of Canaan. And the sons of Pharez were Hezron and Hamul.
And the sons of Issachar; Tola, and Phuvah, and Job, and Shimron.
And the sons of Zebulun; Sered, and Elon, and Jahleel.
These be the sons of Leah, which she bare unto Jacob in Padan-aram, with his daughter Dinah: all the souls of his sons and his daughters were thirty and three.
And the sons of Gad; Ziphion, and Haggi, Shuni, and Ezbon, Eri, and Arodi, and Areli.
And the sons of Asher; Jimnah, and Ishuah, and Isui, and Beriah, and Serah their sister: and the sons of Beriah; Heber, and Malchiel.
These are the sons of Zilpah, whom Laban gave to Leah his daughter, and these she bare unto Jacob, even sixteen souls.
The sons of Rachel Jacob's wife; Joseph, and Benjamin.
And unto Joseph in the land of Egypt were born Manasseh and Ephraim, which Asenath the daughter of Poti-pherah priest of On bare unto him.
And the sons of Benjamin were Belah, and Becher, and Ashbel, Gera, and Naaman, Ehi, and Rosh, Muppim, and Huppim, and Ard.
These are the sons of Rachel, which were born to Jacob: all the souls were fourteen.
And the sons of Dan; Hushim.
And the sons of Naphtali; Jahzeel, and Guni, and Jezer, and Shillem.
These are the sons of Bilhah, which Laban gave unto Rachel his daughter, and she bare these unto Jacob: all the souls were seven.
All the souls that came with Jacob into Egypt, which came out of his loins, besides Jacob's sons' wives, all the souls were threescore and six;
And the sons of Joseph, which were born him in Egypt, were two souls: all the souls of the house of Jacob, which came into Egypt, were threescore and ten.
And he sent Judah before him unto Joseph, to direct his face unto Goshen; and they came into the land of Goshen.
And Joseph made ready his chariot, and went up to meet Israel his father, to Goshen, and presented himself unto him; and he fell on his neck, and wept on his neck a good while.
And Israel said unto Joseph, Now let me die, since I have seen thy face, because thou art yet alive.
And Joseph said unto his brethren, and unto his father's house, I will go up, and shew Pharaoh, and say unto him, My brethren, and my father's house, which were in the land of Canaan, are come unto me;
And the men are shepherds, for their trade hath been to feed cattle; and they have brought their flocks, and their herds, and all that they have.
And it shall come to pass, when Pharaoh shall call you, and shall say, What is your occupation?
That ye shall say, Thy servants' trade hath been about cattle from our youth even until now, both we, and also our fathers: that ye may dwell in the land of Goshen; for every shepherd is an abomination unto the Egyptians.

47.
Then Joseph came and told Pharaoh, and said, My father and my brethren, and their flocks, and their herds, and all that they have, are come out of the land of Canaan; and, behold, they are in the land of Goshen.
And he took some of his brethren, even five men, and presented them unto Pharaoh.
And Pharaoh said unto his brethren, What is your occupation? And they said unto Pharaoh, Thy servants are shepherds, both we, and also our fathers.
They said moreover unto Pharaoh, For to sojourn in the land are we come; for thy servants have no pasture for their flocks; for the famine is sore in the land of Canaan: now therefore, we pray thee, let thy servants dwell in the land of Goshen.
And Pharaoh spake unto Joseph, saying, Thy father and thy brethren are come unto thee:
The land of Egypt is before thee; in the best of the land make thy father and brethren to dwell; in the land of Goshen let them dwell: and if thou knowest any men of activity among them, then make them rulers over my cattle.
And Joseph brought in Jacob his father, and set him before Pharaoh: and Jacob blessed Pharaoh.
And Pharaoh said unto Jacob, How old art thou?
And Jacob said unto Pharaoh, The days of the years of my pilgrimage are an hundred and thirty years: few and evil have the days of the years of my life been, and have not attained unto the days of the years of the life of my fathers in the days of their pilgrimage.
And Jacob blessed Pharaoh, and went out from before Pharaoh.
And Joseph placed his father and his brethren, and gave them a possession in the land of Egypt, in the best of the land, in the land of Rameses, as Pharaoh had commanded.
And Joseph nourished his father, and his brethren, and all his father's household, with bread, according to their families.
And there was no bread in all the land; for the famine was very sore, so that the land of Egypt and all the land of Canaan fainted by reason of the famine.
And Joseph gathered up all the money that was found in the land of Egypt, and in the land of Canaan, for the corn which they bought: and Joseph brought the money into Pharaoh's house.
And when money failed in the land of Egypt, and in the land of Canaan, all the Egyptians came unto Joseph, and said, Give us bread: for why should we die in thy presence? for the money faileth.
And Joseph said, Give your cattle; and I will give you for your cattle, if money fail.
And they brought their cattle unto Joseph: and Joseph gave them bread in exchange for horses, and for the flocks, and for the cattle of the herds, and for the asses: and he fed them with bread for all their cattle for that year.
When that year was ended, they came unto him the second year, and said unto him, We will not hide it from my lord, how that our money is spent; my lord also hath our herds of cattle; there is not ought left in the sight of my lord, but our bodies, and our lands:
Wherefore shall we die before thine eyes, both we and our land? buy us and our land for bread, and we and our land will be servants unto Pharaoh: and give us seed, that we may live, and not die, that the land be not desolate.
And Joseph bought all the land of Egypt for Pharaoh; for the Egyptians sold every man his field, because the famine prevailed over them: so the land became Pharaoh's.
And as for the people, he removed them to cities from one end of the borders of Egypt even to the other end thereof.
Only the land of the priests bought he not; for the priests had a portion assigned them of Pharaoh, and did eat their portion which Pharaoh gave them: wherefore they sold not their lands.
Then Joseph said unto the people, Behold, I have bought you this day and your land for Pharaoh: lo, here is seed for you, and ye shall sow the land.
And it shall come to pass in the increase, that ye shall give the fifth part unto Pharaoh, and four parts shall be your own, for seed of the field, and for your food, and for them of your households, and for food for your little ones.
And they said, Thou hast saved our lives: let us find grace in the sight of my lord, and we will be Pharaoh's servants.
And Joseph made it a law over the land of Egypt unto this day, that Pharaoh should have the fifth part; except the land of the priests only, which became not Pharaoh's.
And Israel dwelt in the land of Egypt, in the country of Goshen; and they had possessions therein, and grew, and multiplied exceedingly.
And Jacob lived in the land of Egypt seventeen years: so the whole age of Jacob was an hundred forty and seven years.
And the time drew nigh that Israel must die: and he called his son Joseph, and said unto him, If now I have found grace in thy sight, put, I pray thee, thy hand under my thigh, and deal kindly and truly with me; bury me not, I pray thee, in Egypt:
But I will lie with my fathers, and thou shalt carry me out of Egypt, and bury me in their buryingplace. And he said, I will do as thou hast said.
And he said, Swear unto me. And he sware unto him. And Israel bowed himself upon the bed's head.

48.
And it came to pass after these things, that one told Joseph, Behold, thy father is sick: and he took with him his two sons, Manasseh and Ephraim.
And one told Jacob, and said, Behold, thy son Joseph cometh unto thee: and Israel strengthened himself, and sat upon the bed.
And Jacob said unto Joseph, God Almighty appeared unto me at Luz in the land of Canaan, and blessed me,
And said unto me, Behold, I will make thee fruitful, and multiply thee, and I will make of thee a multitude of people; and will give this land to thy seed after thee for an everlasting possession.
And now thy two sons, Ephraim and Manasseh, which were born unto thee in the land of Egypt before I came unto thee into Egypt, are mine; as Reuben and Simeon, they shall be mine.
And thy issue, which thou begettest after them, shall be thine, and shall be called after the name of their brethren in their inheritance.
And as for me, when I came from Padan, Rachel died by me in the land of Canaan in the way, when yet there was but a little way to come unto Ephrath: and I buried her there in the way of Ephrath; the same is Bethlehem.
And Israel beheld Joseph's sons, and said, Who are these?
And Joseph said unto his father, They are my sons, whom God hath given me in this place. And he said, Bring them, I pray thee, unto me, and I will bless them.
Now the eyes of Israel were dim for age, so that he could not see. And he brought them near unto him; and he kissed them, and embraced them.
And Israel said unto Joseph, I had not thought to see thy face: and, lo, God hath shewed me also thy seed.
And Joseph brought them out from between his knees, and he bowed himself with his face to the earth.
And Joseph took them both, Ephraim in his right hand toward Israel's left hand, and Manasseh in his left hand toward Israel's right hand, and brought them near unto him.
And Israel stretched out his right hand, and laid it upon Ephraim's head, who was the younger, and his left hand upon Manasseh's head, guiding his hands wittingly; for Manasseh was the firstborn.
And he blessed Joseph, and said, God, before whom my fathers Abraham and Isaac did walk, the God which fed me all my life long unto this day,
The Angel which redeemed me from all evil, bless the lads; and let my name be named on them, and the name of my fathers Abraham and Isaac; and let them grow into a multitude in the midst of the earth.
And when Joseph saw that his father laid his right hand upon the head of Ephraim, it displeased him: and he held up his father's hand, to remove it from Ephraim's head unto Manasseh's head.
And Joseph said unto his father, Not so, my father: for this is the firstborn; put thy right hand upon his head.
And his father refused, and said, I know it, my son, I know it: he also shall become a people, and he also shall be great: but truly his younger brother shall be greater than he, and his seed shall become a multitude of nations.
And he blessed them that day, saying, In thee shall Israel bless, saying, God make thee as Ephraim and as Manasseh: and he set Ephraim before Manasseh.
And Israel said unto Joseph, Behold, I die: but God shall be with you, and bring you again unto the land of your fathers.
Moreover I have given to thee one portion above thy brethren, which I took out of the hand of the Amorite with my sword and with my bow.

49.
And Jacob called unto his sons, and said, Gather yourselves together, that I may tell you that which shall befall you in the last days.
Gather yourselves together, and hear, ye sons of Jacob; and hearken unto Israel your father.
Reuben, thou art my firstborn, my might, and the beginning of my strength, the excellency of dignity, and the excellency of power:
Unstable as water, thou shalt not excel; because thou wentest up to thy father's bed; then defiledst thou it: he went up to my couch.
Simeon and Levi are brethren; instruments of cruelty are in their habitations.
O my soul, come not thou into their secret; unto their assembly, mine honour, be not thou united: for in their anger they slew a man, and in their selfwill they digged down a wall.
Cursed be their anger, for it was fierce; and their wrath, for it was cruel: I will divide them in Jacob, and scatter them in Israel.
Judah, thou art he whom thy brethren shall praise: thy hand shall be in the neck of thine enemies; thy father's children shall bow down before thee.
Judah is a lion's whelp: from the prey, my son, thou art gone up: he stooped down, he couched as a lion, and as an old lion; who shall rouse him up?
The sceptre shall not depart from Judah, nor a lawgiver from between his feet, until Shiloh come; and unto him shall the gathering of the people be.
Binding his foal unto the vine, and his ass's colt unto the choice vine; he washed his garments in wine, and his clothes in the blood of grapes:
His eyes shall be red with wine, and his teeth white with milk.
Zebulun shall dwell at the haven of the sea; and he shall be for an haven of ships; and his border shall be unto Zidon.
Issachar is a strong ass couching down between two burdens:
And he saw that rest was good, and the land that it was pleasant; and bowed his shoulder to bear, and became a servant unto tribute.
Dan shall judge his people, as one of the tribes of Israel.
Dan shall be a serpent by the way, an adder in the path, that biteth the horse heels, so that his rider shall fall backward.
I have waited for thy salvation, O LORD.
Gad, a troop shall overcome him: but he shall overcome at the last.
Out of Asher his bread shall be fat, and he shall yield royal dainties.
Naphtali is a hind let loose: he giveth goodly words.
Joseph is a fruitful bough, even a fruitful bough by a well; whose branches run over the wall:
The archers have sorely grieved him, and shot at him, and hated him:
But his bow abode in strength, and the arms of his hands were made strong by the hands of the mighty God of Jacob; (from thence is the shepherd, the stone of Israel:)
Even by the God of thy father, who shall help thee; and by the Almighty, who shall bless thee with blessings of heaven above, blessings of the deep that lieth under, blessings of the breasts, and of the womb:
The blessings of thy father have prevailed above the blessings of my progenitors unto the utmost bound of the everlasting hills: they shall be on the head of Joseph, and on the crown of the head of him that was separate from his brethren.
Benjamin shall ravin as a wolf: in the morning he shall devour the prey, and at night he shall divide the spoil.
All these are the twelve tribes of Israel: and this is it that their father spake unto them, and blessed them; every one according to his blessing he blessed them.
And he charged them, and said unto them, I am to be gathered unto my people: bury me with my fathers in the cave that is in the field of Ephron the Hittite,
In the cave that is in the field of Machpelah, which is before Mamre, in the land of Canaan, which Abraham bought with the field of Ephron the Hittite for a possession of a buryingplace.
There they buried Abraham and Sarah his wife; there they buried Isaac and Rebekah his wife; and there I buried Leah.
The purchase of the field and of the cave that is therein was from the children of Heth.
And when Jacob had made an end of commanding his sons, he gathered up his feet into the bed, and yielded up the ghost, and was gathered unto his people.

50.
And Joseph fell upon his father's face, and wept upon him, and kissed him.
And Joseph commanded his servants the physicians to embalm his father: and the physicians embalmed Israel.
And forty days were fulfilled for him; for so are fulfilled the days of those which are embalmed: and the Egyptians mourned for him threescore and ten days.
And when the days of his mourning were past, Joseph spake unto the house of Pharaoh, saying, If now I have found grace in your eyes, speak, I pray you, in the ears of Pharaoh, saying,
My father made me swear, saying, Lo, I die: in my grave which I have digged for me in the land of Canaan, there shalt thou bury me. Now therefore let me go up, I pray thee, and bury my father, and I will come again.
And Pharaoh said, Go up, and bury thy father, according as he made thee swear.
And Joseph went up to bury his father: and with him went up all the servants of Pharaoh, the elders of his house, and all the elders of the land of Egypt,
And all the house of Joseph, and his brethren, and his father's house: only their little ones, and their flocks, and their herds, they left in the land of Goshen.
And there went up with him both chariots and horsemen: and it was a very great company.
And they came to the threshingfloor of Atad, which is beyond Jordan, and there they mourned with a great and very sore lamentation: and he made a mourning for his father seven days.
And when the inhabitants of the land, the Canaanites, saw the mourning in the floor of Atad, they said, This is a grievous mourning to the Egyptians: wherefore the name of it was called Abel-mizraim, which is beyond Jordan.
And his sons did unto him according as he commanded them:
For his sons carried him into the land of Canaan, and buried him in the cave of the field of Machpelah, which Abraham bought with the field for a possession of a buryingplace of Ephron the Hittite, before Mamre.
And Joseph returned into Egypt, he, and his brethren, and all that went up with him to bury his father, after he had buried his father.
And when Joseph's brethren saw that their father was dead, they said, Joseph will peradventure hate us, and will certainly requite us all the evil which we did unto him.
And they sent a messenger unto Joseph, saying, Thy father did command before he died, saying,
So shall ye say unto Joseph, Forgive, I pray thee now, the trespass of thy brethren, and their sin; for they did unto thee evil: and now, we pray thee, forgive the trespass of the servants of the God of thy father. And Joseph wept when they spake unto him.
And his brethren also went and fell down before his face; and they said, Behold, we be thy servants.
And Joseph said unto them, Fear not: for am I in the place of God?
But as for you, ye thought evil against me; but God meant it unto good, to bring to pass, as it is this day, to save much people alive.
Now therefore fear ye not: I will nourish you, and your little ones. And he comforted them, and spake kindly unto them.
And Joseph dwelt in Egypt, he, and his father's house: and Joseph lived an hundred and ten years.
And Joseph saw Ephraim's children of the third generation: the children also of Machir the son Manasseh were brought up upon Joseph's knees.
And Joseph said unto his brethren, I die: and God will surely visit you, and bring you out of this land unto the land which he sware to Abraham, to Isaac, and to Jacob.
And Joseph took an oath of the children of Israel, saying, God will surely visit you, and ye shall carry up my bones from hence.
So Joseph died, being an hundred and ten years old: and they embalmed him, and he was put in a coffin in Egypt.
""";

/// From: https://en.wiktionary.org/wiki/Appendix:English_words_with_diacritics
/// which no longer exists.
/// Text is available under the [Creative Commons Attribution-ShareAlike License](https://en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License).
const diacretics = """
à bas, à la, à la carte, à la mode, à gogo, à propos, abacá, abaká,
abbé, açaí, adiós, agèd, agrément, aikidō, Åland, ampère, Ancien
Régime, André, ångström, animé (the oleo-resin), animēshon (usually
anime), áo dài, aperçu, apéritif, appliqué, après-ski, arête, art
décoratif, attaché, auto-da-fé bánh mì, barège, beau idéal, béchamel,
belle époque, béguin, bentō, bête noire, bêtise, Beyoncé, Bézier curves,
biały, Bichon Frisé, bíró, blasé, blessèd, bobèche, bodegón, boîte,
Bokmål, bombé, Bön, bon appétit, Boötes, boutonnière, brassière,
bric-à-brac, Brontë, bún café, cafetería, cafetière, caffè, caïque
[-jee], calèche, canapé, cañón (usually canyon), cap-à-pie,
Champs-Élysées, château, chargé d'affaires, cause célèbre, chacun à son
goût, chaînés, chèvre, Chloë, cinéma, cinéma vérité, Citroën, cliché,
cliché-verre, clientèle, comme ci comme ça, cloisonné, compère, consommé,
communiqué, confrère, confronté, continuüm (rare), coöperate [-ion, -ive],
coöpt, coördinate [-ed, -ing, -ion, -or, -ors], cortège, coup d'état, coup
de grâce, coupé, coulée, crèche, crème [-brûlée, -caramel, -de cacao, -de
la crème, -de menthe, -fraîche], Créole, crêpe [-paper, -Suzette], crétin
[-ism], Creüsa, croûton, crudités, csárdás, Curaçao, cursèd (rare)
Daimyō, daïs, dấu hỏi, débâcle, débris, début, décal [-comania],
déclassé, décolletage, décolleté, décor, découpage, dégagé,
dégustation, déjà vu, démarche, démodé, dénouement, dépôt, dérailleur,
derrière, déshabillé, détente, diamanté, diddé, discothèque, divorcé,
divorcée, dōjō, dōmoic acid, Doña, doppelgänger, Dvořák éclair, éclat,
Éire, El Niño, élan, élite, Élysée, émigré, entrée, entrepôt,
entrecôte, épaulette, épée, étouffée, étude, exposé façade, fête,
faïence, fiancé, fiancée, filmjölk, fin de siècle, flambé, flèche, föhn,
folie à deux, fouetté, frappé, Fräulein, frère, fricassée, Führer
garçon, garçonnière, gâteau, Geiger–Müller counter, gemütlichkeit, genrō,
genkō yōshi, Gewürztraminer, ginkyō (usually ginkgo), glacé, glögg,
Götterdämmerung, Gruyère, gyōza habitué, háček, hajdúk, halászlé,
hāngi, hapū, Hawaiʻi, hors d'œuvre, hôtel, humuhumunukunukuāpuaʻa ingénue,
inrō jäger, jalapeño, jardinière, jūdō, jūjutsu kākā, kākāpō,
kåldolmar, kamaʻāina, karōshi, kāwanatanga, kendō, kererū, kōan, kōhanga
reo, kōji, kōkako, kōrero, króna (Icelandic with accent, Swedish without),
kroužek, kūmara, kümmel, kyūdō lamé, lānai, ländler, langue d'oïl,
Laocoön, La Niña, légionnaire, littérateur, lūʻau, lycée macédoine,
macramé, mahātmā, maître d'hôtel, malagueña, Malmö, mañana, manège,
manœuvre, manqué, Māori, maté, matériel, matinée, mélange, mêlée,
ménage à trois, ménagerie, mésalliance, métier, Métis, México,
minaudière, mise en scène, Monégasque, moiré, Montaño, Montréal naïf,
naïve, naïveté, né, née, négligée, Neufchâtel, Nez Percé, Nō (usually
Noh), Noël, noöne (rare), número uno (Spanish with accent, Italian without)
objet trouvé, Öland, olé, ombré, omertà, oöcyte, oölogy (rare), opéra
bouffe, opéra comique, opïum (rare), öre, øre, outré pączki, pāhoehoe,
papier-mâché, páramo, passé, pâté, pāua, phở, pièce de résistance,
pied-à-terre, plissé, piña colada, piñata, piñón, piraña (usually
piranha), piqué, più, plié, précis, pōhutukawa, pölsa, preëminent [-ly]
(rare), preëmpt [-ion, -ive] (rare), prélude, première, première danseuse,
prêt-à-porter, protégé, protégée, purée Québec, Québécois,
quinceañera ragoût, ragù, raison d'être, rāmen, rātā, recherché,
réclame, reconnoître, reëlect [-ed, -ing] (rare), reënter [-ed, -ing]
(rare), reëstablish [-ed, -ing] (rare), régime, rędzina (usually rendzina),
résumé, residuüm (rare), retroussé, rincón, risqué, rôle, rivière, roman
à clef, România, röntgen, rosé, roué sauté, sayōnara, séance, señor,
señora, señorita, senryū, Shintō, shōgun, shōyu, Sinn Féin, Škoda,
smörgåsbord, smörgåstårta, soigné, soirée, soufflé, soupçon, sūdoku,
sumō, surströmming table d'hôte, takahē, télécommunication, tennō,
tête-à-tête, Thaïs, tōfu, Tōkyō, tōtara, touché, toupée, tourtière
über, Übermensch, ʻukulele vicuña, Việt Nam, vis-à-vis, voilà whekī
Zaïre, Zoë, zoölogy, Zürich, zōri, złoty
""";
