/* valabasicblock.c generated by valac, the Vala compiler
 * generated from valabasicblock.vala, do not modify */

/* valabasicblock.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _ValaParamSpecBasicBlock ValaParamSpecBasicBlock;

struct _ValaBasicBlockPrivate {
	ValaList* nodes;
	ValaList* predecessors;
	ValaList* successors;
	ValaBasicBlock* _parent;
	ValaList* children;
	ValaSet* df;
	ValaSet* phi_functions;
	gboolean _postorder_visited;
	gint _postorder_number;
};

struct _ValaParamSpecBasicBlock {
	GParamSpec parent_instance;
};

static gint ValaBasicBlock_private_offset;
static gpointer vala_basic_block_parent_class = NULL;

static void vala_basic_block_set_parent (ValaBasicBlock* self,
                                  ValaBasicBlock* value);
static void vala_basic_block_finalize (ValaBasicBlock * obj);
static GType vala_basic_block_get_type_once (void);

static inline gpointer
vala_basic_block_get_instance_private (ValaBasicBlock* self)
{
	return G_STRUCT_MEMBER_P (self, ValaBasicBlock_private_offset);
}

ValaBasicBlock*
vala_basic_block_get_parent (ValaBasicBlock* self)
{
	ValaBasicBlock* result;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent;
	result = _tmp0_;
	return result;
}

static void
vala_basic_block_set_parent (ValaBasicBlock* self,
                             ValaBasicBlock* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_parent = value;
}

gboolean
vala_basic_block_get_postorder_visited (ValaBasicBlock* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_postorder_visited;
	return result;
}

void
vala_basic_block_set_postorder_visited (ValaBasicBlock* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_postorder_visited = value;
}

gint
vala_basic_block_get_postorder_number (ValaBasicBlock* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_postorder_number;
	return result;
}

void
vala_basic_block_set_postorder_number (ValaBasicBlock* self,
                                       gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_postorder_number = value;
}

ValaBasicBlock*
vala_basic_block_construct (GType object_type)
{
	ValaBasicBlock* self = NULL;
	self = (ValaBasicBlock*) g_type_create_instance (object_type);
	return self;
}

ValaBasicBlock*
vala_basic_block_new (void)
{
	return vala_basic_block_construct (VALA_TYPE_BASIC_BLOCK);
}

ValaBasicBlock*
vala_basic_block_construct_entry (GType object_type)
{
	ValaBasicBlock* self = NULL;
	self = (ValaBasicBlock*) g_type_create_instance (object_type);
	return self;
}

ValaBasicBlock*
vala_basic_block_new_entry (void)
{
	return vala_basic_block_construct_entry (VALA_TYPE_BASIC_BLOCK);
}

ValaBasicBlock*
vala_basic_block_construct_exit (GType object_type)
{
	ValaBasicBlock* self = NULL;
	self = (ValaBasicBlock*) g_type_create_instance (object_type);
	return self;
}

ValaBasicBlock*
vala_basic_block_new_exit (void)
{
	return vala_basic_block_construct_exit (VALA_TYPE_BASIC_BLOCK);
}

void
vala_basic_block_add_node (ValaBasicBlock* self,
                           ValaCodeNode* node)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->priv->nodes;
	vala_collection_add ((ValaCollection*) _tmp0_, node);
}

ValaList*
vala_basic_block_get_nodes (ValaBasicBlock* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->nodes;
	result = _tmp0_;
	return result;
}

void
vala_basic_block_connect (ValaBasicBlock* self,
                          ValaBasicBlock* target)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	_tmp0_ = self->priv->successors;
	if (!vala_collection_contains ((ValaCollection*) _tmp0_, target)) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->successors;
		vala_collection_add ((ValaCollection*) _tmp1_, target);
	}
	_tmp2_ = target->priv->predecessors;
	if (!vala_collection_contains ((ValaCollection*) _tmp2_, self)) {
		ValaList* _tmp3_;
		_tmp3_ = target->priv->predecessors;
		vala_collection_add ((ValaCollection*) _tmp3_, self);
	}
}

ValaList*
vala_basic_block_get_predecessors (ValaBasicBlock* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->predecessors;
	result = _tmp0_;
	return result;
}

ValaList*
vala_basic_block_get_successors (ValaBasicBlock* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->successors;
	result = _tmp0_;
	return result;
}

void
vala_basic_block_add_child (ValaBasicBlock* self,
                            ValaBasicBlock* block)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	_tmp0_ = self->priv->children;
	vala_collection_add ((ValaCollection*) _tmp0_, block);
	vala_basic_block_set_parent (block, self);
}

ValaList*
vala_basic_block_get_children (ValaBasicBlock* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->children;
	result = _tmp0_;
	return result;
}

void
vala_basic_block_add_dominator_frontier (ValaBasicBlock* self,
                                         ValaBasicBlock* block)
{
	ValaSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	_tmp0_ = self->priv->df;
	vala_collection_add ((ValaCollection*) _tmp0_, block);
}

ValaSet*
vala_basic_block_get_dominator_frontier (ValaBasicBlock* self)
{
	ValaSet* _tmp0_;
	ValaSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->df;
	result = _tmp0_;
	return result;
}

void
vala_basic_block_add_phi_function (ValaBasicBlock* self,
                                   ValaPhiFunction* phi)
{
	ValaSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (phi != NULL);
	_tmp0_ = self->priv->phi_functions;
	vala_collection_add ((ValaCollection*) _tmp0_, phi);
}

ValaSet*
vala_basic_block_get_phi_functions (ValaBasicBlock* self)
{
	ValaSet* _tmp0_;
	ValaSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->phi_functions;
	result = _tmp0_;
	return result;
}

static void
vala_value_basic_block_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_basic_block_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_basic_block_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_basic_block_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_basic_block_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_basic_block_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_basic_block_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaBasicBlock * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_basic_block_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_basic_block_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	ValaBasicBlock ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_basic_block_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_param_spec_basic_block (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ValaParamSpecBasicBlock* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_BASIC_BLOCK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_value_get_basic_block (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_BASIC_BLOCK), NULL);
	return value->data[0].v_pointer;
}

void
vala_value_set_basic_block (GValue* value,
                            gpointer v_object)
{
	ValaBasicBlock * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_BASIC_BLOCK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_BASIC_BLOCK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_basic_block_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_basic_block_unref (old);
	}
}

void
vala_value_take_basic_block (GValue* value,
                             gpointer v_object)
{
	ValaBasicBlock * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_BASIC_BLOCK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_BASIC_BLOCK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_basic_block_unref (old);
	}
}

static void
vala_basic_block_class_init (ValaBasicBlockClass * klass,
                             gpointer klass_data)
{
	vala_basic_block_parent_class = g_type_class_peek_parent (klass);
	((ValaBasicBlockClass *) klass)->finalize = vala_basic_block_finalize;
	g_type_class_adjust_private_offset (klass, &ValaBasicBlock_private_offset);
}

static void
vala_basic_block_instance_init (ValaBasicBlock * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	GHashFunc _tmp8_;
	GEqualFunc _tmp9_;
	ValaHashSet* _tmp10_;
	GHashFunc _tmp11_;
	GEqualFunc _tmp12_;
	ValaHashSet* _tmp13_;
	self->priv = vala_basic_block_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->nodes = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, NULL, NULL, _tmp2_);
	self->priv->predecessors = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, NULL, NULL, _tmp4_);
	self->priv->successors = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, NULL, NULL, _tmp6_);
	self->priv->children = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_hash;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_hash_set_new (VALA_TYPE_BASIC_BLOCK, NULL, NULL, _tmp8_, _tmp9_);
	self->priv->df = (ValaSet*) _tmp10_;
	_tmp11_ = g_direct_hash;
	_tmp12_ = g_direct_equal;
	_tmp13_ = vala_hash_set_new (VALA_TYPE_PHI_FUNCTION, (GBoxedCopyFunc) vala_phi_function_ref, (GDestroyNotify) vala_phi_function_unref, _tmp11_, _tmp12_);
	self->priv->phi_functions = (ValaSet*) _tmp13_;
	self->ref_count = 1;
}

static void
vala_basic_block_finalize (ValaBasicBlock * obj)
{
	ValaBasicBlock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_BASIC_BLOCK, ValaBasicBlock);
	g_signal_handlers_destroy (self);
	_vala_iterable_unref0 (self->priv->nodes);
	_vala_iterable_unref0 (self->priv->predecessors);
	_vala_iterable_unref0 (self->priv->successors);
	_vala_iterable_unref0 (self->priv->children);
	_vala_iterable_unref0 (self->priv->df);
	_vala_iterable_unref0 (self->priv->phi_functions);
}

/**
 * Represents a basic block, i.e. a straight-line piece of code without any
 * jumps or jump targets.
 */
static GType
vala_basic_block_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_basic_block_init, vala_value_basic_block_free_value, vala_value_basic_block_copy_value, vala_value_basic_block_peek_pointer, "p", vala_value_basic_block_collect_value, "p", vala_value_basic_block_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaBasicBlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_basic_block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBasicBlock), 0, (GInstanceInitFunc) vala_basic_block_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_basic_block_type_id;
	vala_basic_block_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaBasicBlock", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaBasicBlock_private_offset = g_type_add_instance_private (vala_basic_block_type_id, sizeof (ValaBasicBlockPrivate));
	return vala_basic_block_type_id;
}

GType
vala_basic_block_get_type (void)
{
	static volatile gsize vala_basic_block_type_id__once = 0;
	if (g_once_init_enter (&vala_basic_block_type_id__once)) {
		GType vala_basic_block_type_id;
		vala_basic_block_type_id = vala_basic_block_get_type_once ();
		g_once_init_leave (&vala_basic_block_type_id__once, vala_basic_block_type_id);
	}
	return vala_basic_block_type_id__once;
}

gpointer
vala_basic_block_ref (gpointer instance)
{
	ValaBasicBlock * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_basic_block_unref (gpointer instance)
{
	ValaBasicBlock * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_BASIC_BLOCK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

