/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.StandardMethodCodec;
import java.util.HashMap;

public class MouseCursorChannel {
    private static final String TAG = "MouseCursorChannel";
    @NonNull
    public final MethodChannel channel;
    @Nullable
    private MouseCursorMethodHandler mouseCursorMethodHandler;
    @NonNull
    private final MethodChannel.MethodCallHandler parsingMethodCallHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            if (MouseCursorChannel.this.mouseCursorMethodHandler == null) {
                return;
            }
            String method = call.method;
            Log.v(MouseCursorChannel.TAG, "Received '" + method + "' message.");
            try {
                switch (method) {
                    case "activateSystemCursor": {
                        HashMap data = (HashMap)call.arguments;
                        String kind = (String)data.get("kind");
                        try {
                            MouseCursorChannel.this.mouseCursorMethodHandler.activateSystemCursor(kind);
                        }
                        catch (Exception e) {
                            result.error("error", "Error when setting cursors: " + e.getMessage(), null);
                            break;
                        }
                        result.success(true);
                        break;
                    }
                }
            }
            catch (Exception e) {
                result.error("error", "Unhandled error: " + e.getMessage(), null);
            }
        }
    };

    public MouseCursorChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/mousecursor", StandardMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.parsingMethodCallHandler);
    }

    public void setMethodHandler(@Nullable MouseCursorMethodHandler mouseCursorMethodHandler) {
        this.mouseCursorMethodHandler = mouseCursorMethodHandler;
    }

    @VisibleForTesting
    public void synthesizeMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
        this.parsingMethodCallHandler.onMethodCall(call, result);
    }

    public static interface MouseCursorMethodHandler {
        public void activateSystemCursor(@NonNull String var1);
    }
}

