/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import io.flutter.plugin.platform.AccessibilityEventsDelegate;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.SingleViewPresentation;
import io.flutter.view.TextureRegistry;

@TargetApi(value=20)
class VirtualDisplayController {
    private static String TAG = "VirtualDisplayController";
    @VisibleForTesting
    SingleViewPresentation presentation;
    private final Context context;
    private final AccessibilityEventsDelegate accessibilityEventsDelegate;
    private final int densityDpi;
    private final TextureRegistry.SurfaceTextureEntry textureEntry;
    private final View.OnFocusChangeListener focusChangeListener;
    private final Surface surface;
    private VirtualDisplay virtualDisplay;
    private int bufferWidth;
    private int bufferHeight;

    public static VirtualDisplayController create(Context context, AccessibilityEventsDelegate accessibilityEventsDelegate, PlatformView view, TextureRegistry.SurfaceTextureEntry textureEntry, int width, int height, int viewId, Object createParams, View.OnFocusChangeListener focusChangeListener) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        if (width == 0 || height == 0) {
            return null;
        }
        textureEntry.surfaceTexture().setDefaultBufferSize(width, height);
        Surface surface = new Surface(textureEntry.surfaceTexture());
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        int densityDpi = context.getResources().getDisplayMetrics().densityDpi;
        VirtualDisplay virtualDisplay = displayManager.createVirtualDisplay("flutter-vd", width, height, densityDpi, surface, 0);
        if (virtualDisplay == null) {
            return null;
        }
        VirtualDisplayController controller = new VirtualDisplayController(context, accessibilityEventsDelegate, virtualDisplay, view, surface, textureEntry, focusChangeListener, viewId, createParams);
        controller.bufferWidth = width;
        controller.bufferHeight = height;
        return controller;
    }

    private VirtualDisplayController(Context context, AccessibilityEventsDelegate accessibilityEventsDelegate, VirtualDisplay virtualDisplay, PlatformView view, Surface surface, TextureRegistry.SurfaceTextureEntry textureEntry, View.OnFocusChangeListener focusChangeListener, int viewId, Object createParams) {
        this.context = context;
        this.accessibilityEventsDelegate = accessibilityEventsDelegate;
        this.textureEntry = textureEntry;
        this.focusChangeListener = focusChangeListener;
        this.surface = surface;
        this.virtualDisplay = virtualDisplay;
        this.densityDpi = context.getResources().getDisplayMetrics().densityDpi;
        this.presentation = new SingleViewPresentation(context, this.virtualDisplay.getDisplay(), view, accessibilityEventsDelegate, viewId, focusChangeListener);
        this.presentation.show();
    }

    public int getBufferWidth() {
        return this.bufferWidth;
    }

    public int getBufferHeight() {
        return this.bufferHeight;
    }

    public void resize(int width, int height, final Runnable onNewSizeFrameAvailable) {
        boolean isFocused = this.getView().isFocused();
        SingleViewPresentation.PresentationState presentationState = this.presentation.detachState();
        this.virtualDisplay.setSurface(null);
        this.virtualDisplay.release();
        this.bufferWidth = width;
        this.bufferHeight = height;
        this.textureEntry.surfaceTexture().setDefaultBufferSize(width, height);
        DisplayManager displayManager = (DisplayManager)this.context.getSystemService("display");
        this.virtualDisplay = displayManager.createVirtualDisplay("flutter-vd", width, height, this.densityDpi, this.surface, 0);
        final View embeddedView = this.getView();
        embeddedView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                OneTimeOnDrawListener.schedule(embeddedView, new Runnable(){

                    @Override
                    public void run() {
                        embeddedView.postDelayed(onNewSizeFrameAvailable, 128L);
                    }
                });
                embeddedView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            }

            public void onViewDetachedFromWindow(View v) {
            }
        });
        SingleViewPresentation newPresentation = new SingleViewPresentation(this.context, this.virtualDisplay.getDisplay(), this.accessibilityEventsDelegate, presentationState, this.focusChangeListener, isFocused);
        newPresentation.show();
        this.presentation.cancel();
        this.presentation = newPresentation;
    }

    public void dispose() {
        this.presentation.cancel();
        this.presentation.detachState();
        this.virtualDisplay.release();
        this.textureEntry.release();
    }

    void onFlutterViewAttached(@NonNull View flutterView) {
        if (this.presentation == null || this.presentation.getView() == null) {
            return;
        }
        this.presentation.getView().onFlutterViewAttached(flutterView);
    }

    void onFlutterViewDetached() {
        if (this.presentation == null || this.presentation.getView() == null) {
            return;
        }
        this.presentation.getView().onFlutterViewDetached();
    }

    void onInputConnectionLocked() {
        if (this.presentation == null || this.presentation.getView() == null) {
            return;
        }
        this.presentation.getView().onInputConnectionLocked();
    }

    void onInputConnectionUnlocked() {
        if (this.presentation == null || this.presentation.getView() == null) {
            return;
        }
        this.presentation.getView().onInputConnectionUnlocked();
    }

    public View getView() {
        if (this.presentation == null) {
            return null;
        }
        PlatformView platformView = this.presentation.getView();
        return platformView.getView();
    }

    public void dispatchTouchEvent(MotionEvent event) {
        if (this.presentation == null) {
            return;
        }
        this.presentation.dispatchTouchEvent(event);
    }

    static class OneTimeOnDrawListener
    implements ViewTreeObserver.OnDrawListener {
        final View mView;
        Runnable mOnDrawRunnable;

        static void schedule(View view, Runnable runnable) {
            OneTimeOnDrawListener listener = new OneTimeOnDrawListener(view, runnable);
            view.getViewTreeObserver().addOnDrawListener((ViewTreeObserver.OnDrawListener)listener);
        }

        OneTimeOnDrawListener(View view, Runnable onDrawRunnable) {
            this.mView = view;
            this.mOnDrawRunnable = onDrawRunnable;
        }

        public void onDraw() {
            if (this.mOnDrawRunnable == null) {
                return;
            }
            this.mOnDrawRunnable.run();
            this.mOnDrawRunnable = null;
            this.mView.post(new Runnable(){

                @Override
                public void run() {
                    mView.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this);
                }
            });
        }
    }
}

