/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class KeyData {
    private static final String TAG = "KeyData";
    public static final String CHANNEL = "flutter/keydata";
    private static final int FIELD_COUNT = 5;
    private static final int BYTES_PER_FIELD = 8;
    long timestamp;
    Type type;
    long physicalKey;
    long logicalKey;
    boolean synthesized;
    @Nullable
    String character;

    public KeyData() {
    }

    public KeyData(@NonNull ByteBuffer buffer) {
        long charSize = buffer.getLong();
        this.timestamp = buffer.getLong();
        this.type = Type.fromLong(buffer.getLong());
        this.physicalKey = buffer.getLong();
        this.logicalKey = buffer.getLong();
        boolean bl = this.synthesized = buffer.getLong() != 0L;
        if ((long)buffer.remaining() != charSize) {
            throw new AssertionError((Object)String.format("Unexpected char length: charSize is %d while buffer has position %d, capacity %d, limit %d", charSize, buffer.position(), buffer.capacity(), buffer.limit()));
        }
        this.character = null;
        if (charSize != 0L) {
            byte[] strBytes = new byte[(int)charSize];
            buffer.get(strBytes, 0, (int)charSize);
            try {
                this.character = new String(strBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)"UTF-8 unsupported");
            }
        }
    }

    ByteBuffer toBytes() {
        byte[] charBytes;
        try {
            charBytes = this.character == null ? null : this.character.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
        int charSize = charBytes == null ? 0 : charBytes.length;
        ByteBuffer packet = ByteBuffer.allocateDirect(48 + charSize);
        packet.order(ByteOrder.LITTLE_ENDIAN);
        packet.putLong(charSize);
        packet.putLong(this.timestamp);
        packet.putLong(this.type.getValue());
        packet.putLong(this.physicalKey);
        packet.putLong(this.logicalKey);
        packet.putLong(this.synthesized ? 1L : 0L);
        if (charBytes != null) {
            packet.put(charBytes);
        }
        return packet;
    }

    public static enum Type {
        kDown(0L),
        kUp(1L),
        kRepeat(2L);

        private long value;

        private Type(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        static Type fromLong(long value) {
            switch ((int)value) {
                case 0: {
                    return kDown;
                }
                case 1: {
                    return kUp;
                }
                case 2: {
                    return kRepeat;
                }
            }
            throw new AssertionError((Object)"Unexpected Type value");
        }
    }
}

