/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import androidx.annotation.NonNull;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.JSONMessageCodec;
import java.util.HashMap;
import java.util.Map;

public class SettingsChannel {
    private static final String TAG = "SettingsChannel";
    public static final String CHANNEL_NAME = "flutter/settings";
    private static final String TEXT_SCALE_FACTOR = "textScaleFactor";
    private static final String NATIVE_SPELL_CHECK_SERVICE_DEFINED = "nativeSpellCheckServiceDefined";
    private static final String BRIEFLY_SHOW_PASSWORD = "brieflyShowPassword";
    private static final String ALWAYS_USE_24_HOUR_FORMAT = "alwaysUse24HourFormat";
    private static final String PLATFORM_BRIGHTNESS = "platformBrightness";
    @NonNull
    public final BasicMessageChannel<Object> channel;

    public SettingsChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new BasicMessageChannel<Object>(dartExecutor, CHANNEL_NAME, JSONMessageCodec.INSTANCE);
    }

    @NonNull
    public MessageBuilder startMessage() {
        return new MessageBuilder(this.channel);
    }

    public static enum PlatformBrightness {
        light("light"),
        dark("dark");

        @NonNull
        public String name;

        private PlatformBrightness(String name) {
            this.name = name;
        }
    }

    public static class MessageBuilder {
        @NonNull
        private final BasicMessageChannel<Object> channel;
        @NonNull
        private Map<String, Object> message = new HashMap<String, Object>();

        MessageBuilder(@NonNull BasicMessageChannel<Object> channel) {
            this.channel = channel;
        }

        @NonNull
        public MessageBuilder setTextScaleFactor(float textScaleFactor) {
            this.message.put(SettingsChannel.TEXT_SCALE_FACTOR, Float.valueOf(textScaleFactor));
            return this;
        }

        @NonNull
        public MessageBuilder setNativeSpellCheckServiceDefined(boolean nativeSpellCheckServiceDefined) {
            this.message.put(SettingsChannel.NATIVE_SPELL_CHECK_SERVICE_DEFINED, nativeSpellCheckServiceDefined);
            return this;
        }

        @NonNull
        public MessageBuilder setBrieflyShowPassword(@NonNull boolean brieflyShowPassword) {
            this.message.put(SettingsChannel.BRIEFLY_SHOW_PASSWORD, brieflyShowPassword);
            return this;
        }

        @NonNull
        public MessageBuilder setUse24HourFormat(boolean use24HourFormat) {
            this.message.put(SettingsChannel.ALWAYS_USE_24_HOUR_FORMAT, use24HourFormat);
            return this;
        }

        @NonNull
        public MessageBuilder setPlatformBrightness(@NonNull PlatformBrightness brightness) {
            this.message.put(SettingsChannel.PLATFORM_BRIGHTNESS, brightness.name);
            return this;
        }

        public void send() {
            Log.v(SettingsChannel.TAG, "Sending message: \ntextScaleFactor: " + this.message.get(SettingsChannel.TEXT_SCALE_FACTOR) + "\nalwaysUse24HourFormat: " + this.message.get(SettingsChannel.ALWAYS_USE_24_HOUR_FORMAT) + "\nplatformBrightness: " + this.message.get(SettingsChannel.PLATFORM_BRIGHTNESS));
            this.channel.send(this.message);
        }
    }
}

