/* ----------------------------------------------------------------- */
/*           The Japanese TTS System "Open JTalk"                    */
/*           developed by HTS Working Group                          */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2015  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef NJD_SET_ACCENT_TYPE_RULE_H
#define NJD_SET_ACCENT_TYPE_RULE_H

#ifdef __cplusplus
#define NJD_SET_ACCENT_TYPE_RULE_H_START extern "C" {
#define NJD_SET_ACCENT_TYPE_RULE_H_END   }
#else
#define NJD_SET_ACCENT_TYPE_RULE_H_START
#define NJD_SET_ACCENT_TYPE_RULE_H_END
#endif                          /* __CPLUSPLUS */

NJD_SET_ACCENT_TYPE_RULE_H_START;

#define NJD_SET_ACCENT_TYPE_KAZU "\xe6\x95\xb0"
#define NJD_SET_ACCENT_TYPE_ICHI "\xe4\xb8\x80"
#define NJD_SET_ACCENT_TYPE_NI "\xe4\xba\x8c"
#define NJD_SET_ACCENT_TYPE_SAN "\xe4\xb8\x89"
#define NJD_SET_ACCENT_TYPE_YON "\xe5\x9b\x9b"
#define NJD_SET_ACCENT_TYPE_GO "\xe4\xba\x94"
#define NJD_SET_ACCENT_TYPE_ROKU "\xe5\x85\xad"
#define NJD_SET_ACCENT_TYPE_NANA "\xe4\xb8\x83"
#define NJD_SET_ACCENT_TYPE_HACHI "\xe5\x85\xab"
#define NJD_SET_ACCENT_TYPE_KYUU "\xe4\xb9\x9d"
#define NJD_SET_ACCENT_TYPE_JYUU "\xe5\x8d\x81"
#define NJD_SET_ACCENT_TYPE_HYAKU "\xe7\x99\xbe"
#define NJD_SET_ACCENT_TYPE_SEN "\xe5\x8d\x83"
#define NJD_SET_ACCENT_TYPE_MAN "\xe4\xb8\x87"
#define NJD_SET_ACCENT_TYPE_OKU "\xe5\x84\x84"
#define NJD_SET_ACCENT_TYPE_CHOU "\xe5\x85\x86"
#define NJD_SET_ACCENT_TYPE_SUU "\xe6\x95\xb0"
#define NJD_SET_ACCENT_TYPE_NAN "\xe4\xbd\x95"
#define NJD_SET_ACCENT_TYPE_IKU "\xe5\xb9\xbe"

NJD_SET_ACCENT_TYPE_RULE_H_END;

#endif                          /* !NJD_SET_ACCENT_TYPE_RULE_H */
