.TH GROLJ4 @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH NAME
grolj4 \- groff driver for HP LaserJet 4 family
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1994-2018 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.SY grolj4
.OP \-l
.OP \-c num-copies
.RB [ \-d
.RI [ n ]]
.OP \-F font-directory
.OP \-p paper-size
.OP \-w line-width
.RI [ file
\&.\|.\|.\&]
.YS
.
.SY grolj4
.B \-\-help
.YS
.
.SY grolj4
.B \-v
.SY grolj4
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
.B grolj4
is a driver for
.B groff
that produces output in PCL5 format suitable for an HP LaserJet 4
printer.
.
.
.LP
There is an additional drawing command available:
.
.TP
.BI \eD'R\  dh\ dv '
Draw a rule (solid black rectangle), with one corner at the current
position, and the diagonally opposite corner at the current position
.RI +( dh , dv ).
.
Afterwards the current position will be at the opposite corner.
.
This generates a PCL fill rectangle command, and so will work on
printers that do not support HPGL/2 unlike the other
.B \eD
commands.
.
.
.\" ====================================================================
.SH OPTIONS
.\" ====================================================================
.
Whitespace is permitted between a command-line option and its argument.
.
.
.TP
.BI \-c " num-copies"
Print
.I num-copies
copies of each page.
.
.
.TP
.B \-l
Print the document with a landscape orientation.
.
.
.TP
.B \-d\c
.RI " [" n ]
Use duplex mode
.IR n :
1\ is long-side binding; 2\ is short-side binding;
default is\ 1.
.
.
.TP
.BI \-p " paper-size"
Set the paper size to
.IR paper-size ,
which must be one of
letter, legal, executive, a4, com10, monarch, c5, b5, dl.
.
.
.TP
.B \-v
.TQ
.B \-\-version
Print the version number.
.
.
.TP
.BI \-w " line-width"
Set the default line thickness to
.I line-width
thousandths of an em.
.
If this option isn't specified, the line thickness defaults to
0.04\~em.
.
.
.TP
.BI \-F " font-directory"
Prepend directory
.IR font-directory /dev name
to the search path for font and device description files;
.I name
is the name of the device, usually
.BR lj4 .
.
.
.LP
The following four commands are available additionally in the
font description files:
.
.
.TP
.BI pclweight \ N
The integer value
.I N
must be in the range \-7 to +7; default is\~0.
.
.
.TP
.BI pclstyle \ N
The integer value
.I N
must be in the range 0 to 32767; default is\~0.
.
.
.TP
.BI pclproportional \ N
A boolean flag which can be either 0 or\~1; default is\~0.
.
.
.TP
.BI pcltypeface \ N
The integer value
.I N
must be in the range 0 to 65535; default is\~0.
.
.
.\" ====================================================================
.SH ENVIRONMENT
.\" ====================================================================
.
.TP
.I GROFF_FONT_PATH
A list of directories in which to search for the
.IR dev name
directory in addition to the default ones.
.
See
.BR @g@troff (@MAN1EXT@)
and
.BR \%groff_font (@MAN5EXT@)
for more details.
.
.
.\" ====================================================================
.SH FILES
.\" ====================================================================
.
.TP
.I @FONTDIR@/devlj4/DESC
Device description file.
.
.TP
.IR @FONTDIR@/devlj4/ F
Font description file for font
.IR F .
.
.TP
.I @MACRODIR@/lj4.tmac
Macros for use with
.BR grolj4 .
.
.
.SH BUGS
Small dots.
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.
.BR lj4_font (@MAN5EXT@),
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR groff_out (@MAN5EXT@),
.BR groff_font (@MAN5EXT@),
.BR groff_char (@MAN7EXT@)
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
