\page page_man_pipewire_conf_5 pipewire.conf

The PipeWire server configuration file

# SYNOPSIS

*$XDG_CONFIG_HOME/pipewire/pipewire.conf*

*$(PIPEWIRE_CONFIG_DIR)/pipewire.conf*

*$(PIPEWIRE_CONFDATADIR)/pipewire.conf*

*$(PIPEWIRE_CONFDATADIR)/pipewire.conf.d/*

*$(PIPEWIRE_CONFIG_DIR)/pipewire.conf.d/*

*$XDG_CONFIG_HOME/pipewire/pipewire.conf.d/*

# DESCRIPTION

PipeWire is a service that facilitates sharing of multimedia content
between devices and applications.

On startup, the daemon reads a main configuration file to configure
itself. It executes a series of commands listed in the config file.

The config files are loaded in the order listed in the
[SYNOPSIS](#synopsis). The environment variables `PIPEWIRE_CONFIG_DIR`,
`PIPEWIRE_CONFIG_PREFIX` and `PIPEWIRE_CONFIG_NAME` can be used to
specify an alternative config directory, subdirectory and file
respectively.

Next to the configuration file can be a directory with the same name as
the file with a `.d/` suffix. All directories in the
[SYNOPSIS](#synopsis) directory search paths are traversed in the listed
order and the contents of the `*.conf` files inside them are appended to
the main configuration file as overrides. Object sections are merged and
array sections are appended.

# CONFIGURATION FILE FORMAT

The configuration file format is grouped into sections. A section is
either a dictionary, {}, or an array, \[\]. Dictionary and array entries
are separated by whitespace and may be simple value assignment, an array
or a dictionary. For example:
```
    name = value # simple assignment

    name = { key1 = value1 key2 = value2 } # a dictionary with two entries

    name = [ value1 value2 ] # an array with two entries

    name = [ { k = v1 } { k = v2 } ] # an array of dictionaries
```

The configuration files can be expressed in full JSON syntax but for
ease of use, a relaxed format may be used where:

- `:` to delimit keys and values can be substuted by `=` or a space.
- <tt>\"</tt> around keys and string can be omitted as long as no special
  characters are used in the strings.
- `,` to separate objects can be replaced with a whitespace character.
- `#` can be used to start a comment until the line end

# CONFIGURATION FILE SECTIONS

\par context.properties
Dictionary. These properties configure the PipeWire instance.

\par context.spa-libs
Dictionary. Maps plugin features with globs to a spa library.

\par context.modules
Array of dictionaries. Each entry in the array is a dictionary with the
*name* of the module to load, including optional *args* and *flags*.
Most modules support being loaded multiple times.

\par context.objects
Array of dictionaries. Each entry in the array is a dictionary
containing the *factory* to create an object from and optional extra
arguments specific to that factory.

\par context.exec
\parblock
Array of dictionaries. Each entry in the array is dictionary containing
the *path* of a program to execute on startup and optional *args*.

This array used to contain an entry to start the session manager but
this mode of operation has since been demoted to development aid. Avoid
starting a session manager in this way in production environment.
\endparblock

# AUTHORS

The PipeWire Developers <$(PACKAGE_BUGREPORT)>;
PipeWire is available from <$(PACKAGE_URL)>

# SEE ALSO

\ref page_man_pipewire_1 "pipewire(1)",
\ref page_man_pw-mon_1 "pw-mon(1)",
\ref page_man_libpipewire-modules_7 "libpipewire-modules(7)"
