This file contains an overview of examples.

- `derive` folder contains a list of examples which uses different `#[derive(Tabled)]` attributes.
- `show` folder contains a program which uses different styles and prints the resulting table.
- `terminal_size` folder contains a program which spreads the table to the max terminal width and max terminal height.
  You can use which dimension to use via args `--width`, `--height` by default 2 are used.

Bellow there's a list of results of running some examples.

## table

```
| name    | based_on | is_active | is_cool |
|---------|----------|-----------|---------|
| Manjaro | Arch     | true      | true    |
| Arch    |          | true      | true    |
| Debian  |          | true      | true    |
```

## border_text

```
 Numbers ─┬────┬────┬────┐
│ 0  │ 1  │ 2  │ 3  │ 4  │
 More numbers ─┼────┼────┤
│ 5  │ 6  │ 7  │ 8  │ 9  │
│ 10 │ 11 │ 12 │ 13 │ 14 │
 end. ────┴────┴────┴────┘
```

## builder_index

```
┌───────────┬─────────┬──────┬────────┐
│           │ Manjaro │ Arch │ Debian │
├───────────┼─────────┼──────┼────────┤
│ based_on  │ Arch    │ None │ None   │
├───────────┼─────────┼──────┼────────┤
│ is_active │ true    │ true │ true   │
├───────────┼─────────┼──────┼────────┤
│ is_cool   │ true    │ true │ true   │
└───────────┴─────────┴──────┴────────┘
```

## builder

```
| https://en.wikipedia.org/wiki/Ocean |
|---------------+---------------------|
| The terms "the ocean" or "the sea"  |
| used without specification refer to |
|  the interconnected body of salt wa |
| ter covering the majority of the Ea |
| rth's surface                       |
| =================================== |
| #             | Ocean               |
| 0             | Atlantic            |
| 1             | Pacific             |
| 2             | Indian              |
| 3             | Southern            |
| 4             | Arctic              |
```

## chess

<picture>
  <source media="(prefers-color-scheme: dark)" srcset="https://github.com/zhiburt/tabled/assets/20165848/f474bc84-5ed4-4f49-b6e9-fc204c3ecd5d">
  <img alt="Preview" src="https://github.com/zhiburt/tabled/assets/20165848/68960bba-c5ba-4e0a-85b4-ba4f36bc0ed0">
</picture>

## col_row_macros

```
+-------------------------------------------+---------------------------------------------+
| .---------------------------------------. | ┌────────────────────┬─────┬──────────────┐ |
| | name             | age | is_validated | | │ name               │ age │ is_validated │ |
| | Jon Doe          | 255 | false        | | ├────────────────────┼─────┼──────────────┤ |
| | Mark Nelson      | 13  | true         | | │ Jack Black         │ 51  │ false        │ |
| | Terminal Monitor | 0   | false        | | ├────────────────────┼─────┼──────────────┤ |
| | Adam Blend       | 17  | true         | | │ Michelle Goldstein │ 44  │ true         │ |
| '---------------------------------------' | └────────────────────┴─────┴──────────────┘ |
+-------------------------------------------+---------------------------------------------+
+-------------------------------------------+
| .---------------------------------------. |
| | name             | age | is_validated | |
| | Jon Doe          | 255 | false        | |
| | Mark Nelson      | 13  | true         | |
| | Terminal Monitor | 0   | false        | |
| | Adam Blend       | 17  | true         | |
| '---------------------------------------' |
+-------------------------------------------+
| .---------------------------------------. |
| | name             | age | is_validated | |
| | Jon Doe          | 255 | false        | |
| | Mark Nelson      | 13  | true         | |
| | Terminal Monitor | 0   | false        | |
| | Adam Blend       | 17  | true         | |
| '---------------------------------------' |
+-------------------------------------------+
| .---------------------------------------. |
| | name             | age | is_validated | |
| | Jon Doe          | 255 | false        | |
| | Mark Nelson      | 13  | true         | |
| | Terminal Monitor | 0   | false        | |
| | Adam Blend       | 17  | true         | |
| '---------------------------------------' |
+-------------------------------------------+
+-------------------------------------------------------------------------------+
|  +-------+-----+--------------+  ┌────────────────────┬─────┬──────────────┐  |
|  | name  | age | is_validated |  │ name               │ age │ is_validated │  |
|  +-------+-----+--------------+  ├────────────────────┼─────┼──────────────┤  |
|  | Sam   | 31  | true         |  │ Jack Black         │ 51  │ false        │  |
|  +-------+-----+--------------+  ├────────────────────┼─────┼──────────────┤  |
|  | Sarah | 26  | true         |  │ Michelle Goldstein │ 44  │ true         │  |
|  +-------+-----+--------------+  └────────────────────┴─────┴──────────────┘  |
+-------------------------------------------------------------------------------+
|                   .---------------------------------------.                   |
|                   | name             | age | is_validated |                   |
|                   | Jon Doe          | 255 | false        |                   |
|                   | Mark Nelson      | 13  | true         |                   |
|                   | Terminal Monitor | 0   | false        |                   |
|                   | Adam Blend       | 17  | true         |                   |
|                   '---------------------------------------'                   |
+-------------------------------------------------------------------------------+
```

## color

<picture>
  <source media="(prefers-color-scheme: dark)" srcset="https://raw.githubusercontent.com/zhiburt/tabled/assets/assets/example-color-1-dark.png">
  <img alt="Preview" src="https://raw.githubusercontent.com/zhiburt/tabled/assets/assets/example-color-1-light.png">
</picture>

## colored_borders

<picture>
  <source media="(prefers-color-scheme: dark)" srcset="https://raw.githubusercontent.com/zhiburt/tabled/assets/assets/example-colored_borders-1-dark.png">
  <img alt="Preview" src="https://raw.githubusercontent.com/zhiburt/tabled/assets/assets/example-colored_borders-1-light.png">
</picture>

## colored_padding

<picture>
  <source media="(prefers-color-scheme: dark)" srcset="https://raw.githubusercontent.com/zhiburt/tabled/assets/assets/example-padding_color-1-dark.png">
  <img alt="Preview" src="https://raw.githubusercontent.com/zhiburt/tabled/assets/assets/example-padding_color-1-light.png">
</picture>

## colorization

<picture>
  <source media="(prefers-color-scheme: dark)" srcset="https://github.com/zhiburt/tabled/assets/20165848/95ef3c5b-a86d-425c-b95a-b689b61734c5">
  <img alt="Preview" src="https://github.com/zhiburt/tabled/assets/20165848/b6b8af0a-7c1f-4656-b880-c8ecd130c5be">
</picture>

## column_names


<picture>
  <source media="(prefers-color-scheme: dark)" srcset="https://github.com/zhiburt/tabled/assets/20165848/82d8e285-3c1b-4dd2-a1f4-45fd49f0dabe">
  <img alt="Preview" src="https://github.com/zhiburt/tabled/assets/20165848/13054c74-0fae-4df1-87e8-60d498d734e4">
</picture>

## concat

```
 temperature_c  wind_ms  latitude  longitude 
 16             3000     111.111   333.333   
 -20            300      5.111     7282.1    
 40             100      0         0         
                         0         0        
```

## custom_style

```
┌────────────────────┬─────────────────────────────────┐
│ name               │ first_release  developer        │
├────────────────────┼─────────────────────────────────┤
│ Sublime Text 3     │ 2008           Sublime HQ       │
│ Visual Studio Code │ 2015           Microsoft        │
│ Notepad++          │ 2003           Don Ho           │
│ GNU Emacs          │ 1984           Richard Stallman │
│ Neovim             │ 2015           Vim community    │
└────────────────────┴─────────────────────────────────┘
```

## disable

```
###########                     
# name    # based_on | is_cool |
###########----------|---------|
# Debian  #          | true    |
###########                     
# Arch    #          | true    |
###########                     
# Manjaro # Arch     | true    |
###########                     
```

## expanded_display

```
-[ RECORD 0 ]------
name      | Manjaro
based_on  | Arch
is_active | true
is_cool   | true
-[ RECORD 1 ]------
name      | Arch
based_on  | 
is_active | true
is_cool   | true
-[ RECORD 2 ]------
name      | Debian
based_on  | 
is_active | true
is_cool   | true
```

## extract

```
┌───────────────┬───────────────────────────┬──────────────────┬────────────────────┐
│    artist     │           name            │     released     │ level_of_greatness │
├───────────────┼───────────────────────────┼──────────────────┼────────────────────┤
│ Pink Floyd    │ The Dark Side of the Moon │ 01 March 1973    │ Unparalleled       │
├───────────────┼───────────────────────────┼──────────────────┼────────────────────┤
│ Fleetwood Mac │ Rumours                   │ 04 February 1977 │ Outstanding        │
├───────────────┼───────────────────────────┼──────────────────┼────────────────────┤
│ Led Zeppelin  │ Led Zeppelin IV           │ 08 November 1971 │ Supreme            │
└───────────────┴───────────────────────────┴──────────────────┴────────────────────┘

┼───────────────────────────┼──────────────────┼──────────────┤
│ The Dark Side of the Moon │ 01 March 1973    │ Unparalleled │
┼───────────────────────────┼──────────────────┼──────────────┤
│ Rumours                   │ 04 February 1977 │ Outstanding  │
┼───────────────────────────┼──────────────────┼──────────────┤

┌───────────────────────────┬──────────────────┬───────────────┐
│ The Dark Side of the Moon │ 01 March 1973    │ Unparalleled  │
├───────────────────────────┼──────────────────┼───────────────┤
│ Rumours                   │ 04 February 1977 │ +Outstanding+ │
└───────────────────────────┴──────────────────┴───────────────┘
```

## format

```
 0                                           | 1                              | 2                       
---------------------------------------------+--------------------------------+-------------------------
 8ae4e8957caeaa467acbce963701e227af00a1c7... | bypass open-source transmitter | index neural panel      
 48c76de71bd685486d97dc8f4f05aa6fcc0c3f86... | program online alarm           | copy bluetooth card     
 6ffc2a2796229fc7bf59471ad907f58b897005d0... | CSV                            | reboot mobile capacitor 
```

## formatting_settings

```
╭───────────────────╮
│       &str        │
├───────────────────┤
│                   │
│ [                 │
│     "foo",        │
│     {             │
│         "bar": 1, │
│         "baz": [  │
│             2,    │
│             3     │
│         ]         │
│     }             │
│ ]                 │
╰───────────────────╯

╭───────────────────╮
│       &str        │
├───────────────────┤
│                   │
│         [         │
│        "foo",     │
│           {       │
│         "bar": 1, │
│         "baz": [  │
│              2,   │
│               3   │
│             ]     │
│           }       │
│         ]         │
╰───────────────────╯

╭───────────────────╮
│       &str        │
├───────────────────┤
│     [             │
│     "foo",        │
│     {             │
│     "bar": 1,     │
│     "baz": [      │
│     2,            │
│     3             │
│     ]             │
│     }             │
│     ]             │
│                   │
╰───────────────────╯
```

## highlight

```
*************
* 0 │ 1 │ 2 *
*****───*****
│ A * B * C │
├───*───*───┤
│ D * E * F │
├───*───*───┤
│ G * H * I │
└───*****───┘
```

## margin

```
vvvvvvvvvvvvvvvvvv
vvvvvvvvvvvvvvvvvv
<<<<=== === ===>>>
<<<< 0   1   2 >>>
<<<<=== === ===>>>
<<<< A   B   C >>>
<<<< D   E   F >>>
<<<< G   H   I >>>
<<<<=== === ===>>>
^^^^^^^^^^^^^^^^^^
```

## nested_table

```
+-----------------------------------------------+
|            +---------------------+            |
|            |       Animal        |            |
|            +---------------------+            |
|            | +-----------------+ |            |
|            | | +age: Int       | |            |
|            | | +gender: String | |            |
|            | +-----------------+ |            |
|            | +-----------------+ |            |
|            | | +isMammal()     | |            |
|            | | +mate()         | |            |
|            | +-----------------+ |            |
|            +---------------------+            |
|                       ▲                       |
|                       |                       |
|                       |                       |
|     +-----------------------------------+     |
|     |               Duck                |     |
|     +-----------------------------------+     |
|     | +-------------------------------+ |     |
|     | | +beakColor: String = "yellow" | |     |
|     | +-------------------------------+ |     |
|     | +-------------------------------+ |     |
|     | | +swim()                       | |     |
|     | | +quack()                      | |     |
|     | +-------------------------------+ |     |
|     +-----------------------------------+     |
+-----------------------------------------------+
```

## nested_table_2

```
┌───────┬─────────────────────────────────────────────────┬──────────────────────────────────────────────┐
│ name  │ main_os                                         │ switch_os                                    │
├───────┼─────────────────────────────────────────────────┼──────────────────────────────────────────────┤
│ Azure │ ╔═════════╦═════════════╦═══════════╦═════════╗ │ ╔═════════╦══════════╦═══════════╦═════════╗ │
│       │ ║ name    ║ based_on    ║ is_active ║ is_cool ║ │ ║ name    ║ based_on ║ is_active ║ is_cool ║ │
│       │ ╠═════════╬═════════════╬═══════════╬═════════╣ │ ╠═════════╬══════════╬═══════════╬═════════╣ │
│       │ ║ Windows ║ Independent ║ true      ║ true    ║ │ ║ Manjaro ║ Arch     ║ true      ║ true    ║ │
│       │ ╚═════════╩═════════════╩═══════════╩═════════╝ │ ╚═════════╩══════════╩═══════════╩═════════╝ │
├───────┼─────────────────────────────────────────────────┼──────────────────────────────────────────────┤
│ AWS   │ ╔════════╦═════════════╦═══════════╦═════════╗  │ ╔══════╦═════════════╦═══════════╦═════════╗ │
│       │ ║ name   ║ based_on    ║ is_active ║ is_cool ║  │ ║ name ║ based_on    ║ is_active ║ is_cool ║ │
│       │ ╠════════╬═════════════╬═══════════╬═════════╣  │ ╠══════╬═════════════╬═══════════╬═════════╣ │
│       │ ║ Debian ║ Independent ║ true      ║ true    ║  │ ║ Arch ║ Independent ║ true      ║ true    ║ │
│       │ ╚════════╩═════════════╩═══════════╩═════════╝  │ ╚══════╩═════════════╩═══════════╩═════════╝ │
├───────┼─────────────────────────────────────────────────┼──────────────────────────────────────────────┤
│ GCP   │ ╔════════╦═════════════╦═══════════╦═════════╗  │ ╔══════╦═════════════╦═══════════╦═════════╗ │
│       │ ║ name   ║ based_on    ║ is_active ║ is_cool ║  │ ║ name ║ based_on    ║ is_active ║ is_cool ║ │
│       │ ╠════════╬═════════════╬═══════════╬═════════╣  │ ╠══════╬═════════════╬═══════════╬═════════╣ │
│       │ ║ Debian ║ Independent ║ true      ║ true    ║  │ ║ Arch ║ Independent ║ true      ║ true    ║ │
│       │ ╚════════╩═════════════╩═══════════╩═════════╝  │ ╚══════╩═════════════╩═══════════╩═════════╝ │
└───────┴─────────────────────────────────────────────────┴──────────────────────────────────────────────┘
```

## nested_table_3

```
*************************************************
*                   Thank You                   *
*************************************************
| +------------+------------------------------+ |
| |               Contributors                | |
| +------------+------------------------------+ |
| |   author   |           profile            | |
| +------------+------------------------------+ |
| |   kozmod   |   https:/github.com/kozmod   | |
| +------------+------------------------------+ |
| | IsaacCloos | https:/github.com/IsaacCloos | |
| +------------+------------------------------+ |
|  +-----------+-----------------------------+  |
|  |                 Issuers                 |  |
|  +-----------+-----------------------------+  |
|  |  author   |           profile           |  |
|  +-----------+-----------------------------+  |
|  | aharpervc | https:/github.com/aharpervc |  |
|  +-----------+-----------------------------+  |
+-----------------------------------------------+
```

## panel

```
┌───┬────────────────────────────────────────────────────────────────────┬───┐
│ S │                          Tabled Releases                           │ S │
│ o │                                                                    │ o │
│ m │                                                                    │ m │
│ e │                                                                    │ e │
│   ├─────────┬────────────────┬───────────┬─────────────────────────────┤   │
│ t │ version │ published_date │ is_active │        major_feature        │ t │
│ e │         │                │           │                             │ e │
│ x ├─────────┼────────────────┼───────────┼─────────────────────────────┤ x │
│ t │  0.2.1  │   2021-06-23   │   true    │ #[header(inline)] attribute │ t │
│   │         │                │           │                             │   │
│ g ├─────────┼────────────────┼───────────┼─────────────────────────────┤ g │
│ o │  0.2.0  │   2021-06-19   │   false   │         API changes         │ o │
│ e │         │                │           │                             │ e │
│ s ├─────────┼────────────────┼───────────┼─────────────────────────────┤ s │
│   │  0.1.4  │   2021-06-07   │   false   │   display_with attribute    │   │
│ h │         │                │           │                             │ h │
│ e ├─────────┴────────────────┴───────────┴─────────────────────────────┤ e │
│ r │                               N - 3                                │ r │
│ e │                                                                    │ e │
└───┴────────────────────────────────────────────────────────────────────┴───┘
```

## print_matrix

```
┌────┬────┬────┬────┬────┬────┬────┬────┬────┬─────┐
│ 0  │ 1  │ 2  │ 3  │ 4  │ 5  │ 6  │ 7  │ 8  │  9  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 1  │ 2  │ 3  │ 4  │ 5  │ 6  │ 7  │ 8  │ 9  │ 10  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 2  │ 4  │ 6  │ 8  │ 10 │ 12 │ 14 │ 16 │ 18 │ 20  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 3  │ 6  │ 9  │ 12 │ 15 │ 18 │ 21 │ 24 │ 27 │ 30  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 4  │ 8  │ 12 │ 16 │ 20 │ 24 │ 28 │ 32 │ 36 │ 40  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 5  │ 10 │ 15 │ 20 │ 25 │ 30 │ 35 │ 40 │ 45 │ 50  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 6  │ 12 │ 18 │ 24 │ 30 │ 36 │ 42 │ 48 │ 54 │ 60  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 7  │ 14 │ 21 │ 28 │ 35 │ 42 │ 49 │ 56 │ 63 │ 70  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 8  │ 16 │ 24 │ 32 │ 40 │ 48 │ 56 │ 64 │ 72 │ 80  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 9  │ 18 │ 27 │ 36 │ 45 │ 54 │ 63 │ 72 │ 81 │ 90  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 10 │ 20 │ 30 │ 40 │ 50 │ 60 │ 70 │ 80 │ 90 │ 100 │
└────┴────┴────┴────┴────┴────┴────┴────┴────┴─────┘
```

## rotate

```
+--------------+------------------------+---------------------------+--------------------------+
| link         | https://getfedora.org/ | https://www.opensuse.org/ | https://endeavouros.com/ |
+--------------+------------------------+---------------------------+--------------------------+
| destribution | Fedora                 | OpenSUSE                  | Endeavouros              |
+--------------+------------------------+---------------------------+--------------------------+
| id           | 0                      | 2                         | 3                        |
+--------------+------------------------+---------------------------+--------------------------+
```

## shadow

```
┌──┬┐ ╔══╦╗ ╓──┬╖ ╒═╤╕
│  ││ ║  ║║ ║  │║ │ ││
├──┼┤ ╠══╬╣ ╟──┼╢ ╞═╪╡
└──┴┘ ╚══╩╝ ╙──┴╜ ╘═╧╛
┌──────────────────┐  
│  ╔═══╗ Some text │▒▒
│  ╚═╦═╝ In the box│▒▒
╞═╤══╩══╤══════════╡▒▒
│ ├──┬──┤          │▒▒
│ └──┴──┘          │▒▒
└──────────────────┘▒▒
 ▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒
 ▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒▒
```

## span

```
┌───────────────────────────────────────────────────────────────────────────────┐
│ span all 5 columns                                                            │
├───────────────────────────────────────────────────────────────┬───────────────┤
│ span 4 columns                                                │ just 1 column │
├───────────────────────────────┬───────────────┬───────────────┼───────────────┤
│ span 2 columns                │ just 1 column │               │               │
├───────────────┬───────────────┴───────────────┤ just 1 column │               │
│ just 1 column │ span 2 columns                │ span          │ just 1 column │
│               │ span                          │ 3             │ span          │
├───────────────┤ 2                             │ columns       │ 4             │
│ just 1 column │ columns                       │               │ columns       │
├───────────────┼───────────────┬───────────────┼───────────────┤               │
│ just 1 column │ just 1 column │ just 1 column │ just 1 column │               │
└───────────────┴───────────────┴───────────────┴───────────────┴───────────────┘
```

## table_width

```
| 0                | 1         |
|------------------|-----------|
| Hello World!!!   | 3.3.22.2  |
| Guten Morgen     | 1.1.1.1   |
| Добры вечар      | 127.0.0.1 |
| Bonjour le monde |           |
| Ciao mondo       |           |

| 0          | 1   |
|------------|-----|
| Hello W... | ... |
| Guten M... | ... |
| Добры в... | ... |
| Bonjour... |     |
| Ciao mondo |     |

| 0     | 1   |
|-------|-----|
| Hello | ... |
|  W... |     |
| Guten | ... |
|  M... |     |
| Добры | ... |
|  в... |     |
| Bonjo |     |
| ur... |     |
| Ciao  |     |
| mondo |     |

| 0             | 1          |
|---------------|------------|
| Hello         | ...        |
|  W...         |            |
| Guten         | ...        |
|  M...         |            |
| Добры         | ...        |
|  в...         |            |
| Bonjo         |            |
| ur...         |            |
| Ciao          |            |
| mondo         |            |
```

## table_width_2

```
.----------------------------------------.
| usize | &str                           |
| 0     | # Changelog                    |
| 1     | All notable changes to this    |
|       | projectwill be documented in   |
|       | thisfile.                      |
| 2     | The format is based on [Keep a |
|       | Changelog](https://keepachange |
|       | log.com/en/1.0.0/),            |
| 3     | and this project adheres to    |
|       | [SemanticVersioning](https://s |
|       | emver.org/spec/v2.0.0.html).   |
| 4     | ## Unreleased                  |
'-------+--------------------------------'
```

## alphabet

```
+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
| a | b | c | d | e | f | g | h | i | j | k | l | m | n | o | p | q | r | s | t | u | v | w | x | y | z |
+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
```

## compact_table

```
| Debian |     | true |
|-------|-----|-----|
| Arch  |     | true |
| Manjaro | Arch | true |
```

## compact_table_2

```
 Debian  | 1.1.1.1   | true 
---------+-----------+------
 Arch    | 127.1.1.1 | true 
 Manjaro | Arch      | true 
```

## extended_display

```
-[ RECORD 0 ]------
name      | Manjaro
based_on  | Arch
is_active | true
is_cool   | true
-[ RECORD 1 ]------
name      | Arch
based_on  | 
is_active | true
is_cool   | true
-[ RECORD 2 ]------
name      | Debian
based_on  | 
is_active | true
is_cool   | true
```

## height

```
Table

| &str        | i32 |
|-------------|-----|
| Multi       | 123 |
| line        |     |
| string      |     |
| Single line | 234 |

Table increase height to 10

| &str        | i32 |
|             |     |
|             |     |
|-------------|-----|
| Multi       | 123 |
| line        |     |
| string      |     |
|             |     |
| Single line | 234 |
|             |     |

Table decrease height to 4

| &str        | i32 |
|-------------|-----|
| Multi       | 123 |
| Single line | 234 |
Table decrease height to 0

|--|--|
```

## iter_table 

```
.----------------------------------------------------------------------------------------.
| 0  | ok | //! The example can be run by this command                                   |
| 1  | ok | //! `cargo run --example iter_table`                                         |
| 2  | ok |                                                                              |
| 3  | ok | use std::io::BufRead;                                                        |
| 4  | ok |                                                                              |
| 5  | ok | use tabled::{settings::Style, tables::IterTable};               |
| 6  | ok |                                                                              |
| 7  | ok | fn main() {                                                                  |
| 8  | ok |     let path = file!();                                                      |
| 9  | ok |     let file = std::fs::File::open(path).unwrap();                           |
| 10 | ok |     let reader = std::io::BufReader::new(file);                              |
| 11 | ok |     let iterator = reader.lines().enumerate().map(|(i, line)| match line {   |
| 12 | ok |         Ok(line) => [i.to_string(), String::from("ok"), line],               |
| 13 | ok |         Err(err) => [i.to_string(), String::from("error"), err.to_string()], |
| 14 | ok |     });                                                                      |
| 15 | ok |                                                                              |
| 16 | ok |     let table = IterTable::new(iterator).with(Style::ascii_rounded());       |
| 17 | ok |                                                                              |
| 18 | ok |     table.build(std::io::stdout()).unwrap();                                 |
| 19 | ok |     println!()                                                               |
| 20 | ok | }                                                                            |
'----------------------------------------------------------------------------------------'
```

## margin

```
vvvvvvvvvvvvvvvvvv
vvvvvvvvvvvvvvvvvv
<<<<=== === ===>>>
<<<< 0   1   2 >>>
<<<<=== === ===>>>
<<<< A   B   C >>>
<<<< D   E   F >>>
<<<< G   H   I >>>
<<<<=== === ===>>>
^^^^^^^^^^^^^^^^^^
```

## matrix

```
┌────┬────┬────┬────┬────┬────┬────┬────┬────┬─────┐
│ 0  │ 1  │ 2  │ 3  │ 4  │ 5  │ 6  │ 7  │ 8  │ 9   │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 1  │ 2  │ 3  │ 4  │ 5  │ 6  │ 7  │ 8  │ 9  │ 10  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 2  │ 4  │ 6  │ 8  │ 10 │ 12 │ 14 │ 16 │ 18 │ 20  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 3  │ 6  │ 9  │ 12 │ 15 │ 18 │ 21 │ 24 │ 27 │ 30  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 4  │ 8  │ 12 │ 16 │ 20 │ 24 │ 28 │ 32 │ 36 │ 40  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 5  │ 10 │ 15 │ 20 │ 25 │ 30 │ 35 │ 40 │ 45 │ 50  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 6  │ 12 │ 18 │ 24 │ 30 │ 36 │ 42 │ 48 │ 54 │ 60  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 7  │ 14 │ 21 │ 28 │ 35 │ 42 │ 49 │ 56 │ 63 │ 70  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 8  │ 16 │ 24 │ 32 │ 40 │ 48 │ 56 │ 64 │ 72 │ 80  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 9  │ 18 │ 27 │ 36 │ 45 │ 54 │ 63 │ 72 │ 81 │ 90  │
├────┼────┼────┼────┼────┼────┼────┼────┼────┼─────┤
│ 10 │ 20 │ 30 │ 40 │ 50 │ 60 │ 70 │ 80 │ 90 │ 100 │
└────┴────┴────┴────┴────┴────┴────┴────┴────┴─────┘
```

## merge_duplicates

```
┌────────────┬─────────┬────────┐
│ db         │ table   │ total  │
├────────────┼─────────┼────────┤
│ database_1 │ table_1 │ 10712  │
│            ├─────────┼────────┤
│            │ table_2 │ 57     │
│            ├─────────┤        │
│            │ table_3 │        │
├────────────┼─────────┼────────┤
│ database_2 │ table_1 │ 72     │
│            ├─────────┼────────┤
│            │ table_2 │ 75     │
├────────────┼─────────┼────────┤
│ database_3 │ table_1 │ 20     │
│            ├─────────┼────────┤
│            │ table_2 │ 21339  │
│            ├─────────┼────────┤
│            │ table_3 │ 141723 │
└────────────┴─────────┴────────┘
```

## merge_duplicates_2

```
╭───────────┬───────────────────────────────────────────────────────────────────────────╮
│           │ 0        1        2        3        4        5           6        7       │
├───────────┼───────────────────────────────────────────────────────────────────────────┤
│ db        │ database_1                 database_2        database_3                   │
│ origin_db │ database_1                                   database_3                   │
│ table     │ table_1  table_2  table_3  table_1  table_2  table_1     table_2  table_3 │
│ total     │ 10712    57                72       75       20          21339    141723  │
╰───────────┴───────────────────────────────────────────────────────────────────────────╯
```

## settings_list

```
+----------------------+-----------------+--------------------+
|        name          | first_release   |    developer       |
+----------------------+-----------------+--------------------+
| Sublime Text 3       | 2008            | Sublime HQ         |
+----------------------+-----------------+--------------------+
| Visual Studio Code   | 2015            | Microsoft          |
+----------------------+-----------------+--------------------+
| Notepad++            | 2003            | Don Ho             |
+----------------------+-----------------+--------------------+
| GNU Emacs            | 1984            | Richard Stallman   |
+----------------------+-----------------+--------------------+
| Neovim               | 2015            | Vim community      |
+----------------------+-----------------+--------------------+
```

## split

```
┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐                       
│ a │ b │ c │ d │ e │ f │ g │ h │ i │ j │ k │ l │ m │ n │ o │ p │ q │ r │ s │ t │ u │ v │ w │ x │ y │ z │                       
└───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┘                       
┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐ ┌───┬───┐ ┌───┬───┐ ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐ 
│ a │ b │ c │ d │ e │ f │ g │ h │ i │ j │ k │ l │ │ a │ b │ │ a │ b │ │ a │ y │ b │ z │ c │ d │ e │ f │ g │ h │ i │ j │ k │ l │ 
├───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┤ ├───┼───┤ ├───┼───┤ ├───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┤ 
│ m │ n │ o │ p │ q │ r │ s │ t │ u │ v │ w │ x │ │ c │ d │ │ m │ n │ │ m │   │ n │   │ o │ p │ q │ r │ s │ t │ u │ v │ w │ x │ 
├───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┤ ├───┼───┤ ├───┼───┤ └───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┘ 
│ y │ z │   │   │   │   │   │   │   │   │   │   │ │ e │ f │ │ y │ z │ ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐ 
└───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┘ ├───┼───┤ ├───┼───┤ │ a │ b │ c │ d │ e │ f │ g │ h │ i │ j │ k │ l │ y │ z │ 
                                                  │ g │ h │ │ c │ d │ ├───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┤ 
                                                  ├───┼───┤ ├───┼───┤ │ m │ n │ o │ p │ q │ r │ s │ t │ u │ v │ w │ x │   │   │ 
                                                  │ i │ j │ │ o │ p │ └───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┘ 
                                                  ├───┼───┤ ├───┼───┤                                                           
                                                  │ k │ l │ │ e │ f │                                                           
                                                  ├───┼───┤ ├───┼───┤                                                           
                                                  │ m │ n │ │ q │ r │                                                           
                                                  ├───┼───┤ ├───┼───┤                                                           
                                                  │ o │ p │ │ g │ h │                                                           
                                                  ├───┼───┤ ├───┼───┤                                                           
                                                  │ q │ r │ │ s │ t │                                                           
                                                  ├───┼───┤ ├───┼───┤                                                           
                                                  │ s │ t │ │ i │ j │                                                           
                                                  ├───┼───┤ ├───┼───┤                                                           
                                                  │ u │ v │ │ u │ v │                                                           
                                                  ├───┼───┤ ├───┼───┤                                                           
                                                  │ w │ x │ │ k │ l │                                                           
                                                  ├───┼───┤ ├───┼───┤                                                           
                                                  │ y │ z │ │ w │ x │                                                           
                                                  └───┴───┘ └───┴───┘                     
```