/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* virtuals;
};

static gint ValaInterface_private_offset;
static gpointer vala_interface_parent_class = NULL;

static void vala_interface_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_interface_real_add_property (ValaSymbol* base,
                                       ValaProperty* prop);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_interface_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                            ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_interface_finalize (ValaCodeNode * obj);
static GType vala_interface_get_type_once (void);

static inline gpointer
vala_interface_get_instance_private (ValaInterface* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInterface_private_offset);
}

/**
 * Creates a new interface.
 *
 * @param name              type name
 * @param source_reference  reference to source code
 * @return                  newly created interface
 */
ValaInterface*
vala_interface_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	ValaInterface* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaInterface*
vala_interface_new (const gchar* name,
                    ValaSourceReference* source_reference,
                    ValaComment* comment)
{
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}

/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_add_prerequisite (ValaInterface* self,
                                 ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_interface_get_prerequisites (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void
vala_interface_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaInterface * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp18_ = FALSE;
	ValaDataType* _tmp19_;
	ValaDataType* _tmp20_;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaParameter* _tmp8_;
		ValaParameter* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaParameter* _tmp12_;
		ValaParameter* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		_tmp4_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_parameter_new ("this", _tmp5_, _tmp7_);
		_tmp9_ = _tmp8_;
		vala_method_set_this_parameter (m, _tmp9_);
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_method_get_this_parameter (m);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_get_this_parameter (m);
		_tmp17_ = _tmp16_;
		vala_scope_add (_tmp11_, _tmp15_, (ValaSymbol*) _tmp17_);
	}
	_tmp19_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp20_ = _tmp19_;
	if (!VALA_IS_VOID_TYPE (_tmp20_)) {
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp21_ = vala_method_get_postconditions (m);
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp18_ = _tmp23_ > 0;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaDataType* _tmp26_;
		ValaDataType* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaSourceReference* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		ValaLocalVariable* _tmp33_;
		_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_data_type_copy (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_local_variable_new (_tmp27_, "result", NULL, _tmp29_);
		_tmp31_ = _tmp30_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp31_);
		_vala_code_node_unref0 (_tmp31_);
		_vala_code_node_unref0 (_tmp27_);
		_tmp32_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp33_ = _tmp32_;
		vala_local_variable_set_is_result (_tmp33_, TRUE);
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void
vala_interface_real_add_property (ValaSymbol* base,
                                  ValaProperty* prop)
{
	ValaInterface * self;
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	ValaMemberBinding _tmp4_;
	ValaMemberBinding _tmp5_;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_property_get_field (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "interface properties should be `abstract' or have `get' accessor and/o" \
"r `set' mutator");
		vala_code_node_set_error ((ValaCodeNode*) prop, TRUE);
		return;
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp4_ = vala_property_get_binding (prop);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		ValaScope* _tmp12_;
		ValaScope* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		ValaParameter* _tmp18_;
		ValaParameter* _tmp19_;
		_tmp6_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_parameter_new ("this", _tmp7_, _tmp9_);
		_tmp11_ = _tmp10_;
		vala_property_set_this_parameter (prop, _tmp11_);
		_vala_code_node_unref0 (_tmp11_);
		_vala_code_node_unref0 (_tmp7_);
		_tmp12_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_property_get_this_parameter (prop);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_symbol_get_name ((ValaSymbol*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_property_get_this_parameter (prop);
		_tmp19_ = _tmp18_;
		vala_scope_add (_tmp13_, _tmp17_, (ValaSymbol*) _tmp19_);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static ValaList*
vala_interface_real_get_virtuals (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

ValaList*
vala_interface_get_virtuals (ValaInterface* self)
{
	ValaInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_INTERFACE_GET_CLASS (self);
	if (_klass_->get_virtuals) {
		return _klass_->get_virtuals (self);
	}
	return NULL;
}

static void
vala_interface_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_interface (visitor, self);
}

static void
vala_interface_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			_type_index = _type_index + 1;
			_tmp4_ = _type_index;
			_tmp5_ = _type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _type_list;
			_tmp7_ = vala_list_get (_tmp6_, _type_index);
			type = (ValaDataType*) _tmp7_;
			_tmp8_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (type);
		}
	}
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
}

static gboolean
vala_interface_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaInterface * self;
	gboolean result;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                   ValaTypeSymbol* t)
{
	ValaInterface * self;
	gboolean result;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp0_;
		gint _prerequisite_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prerequisite_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_prerequisite_list = _tmp0_;
		_tmp1_ = _prerequisite_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prerequisite_size = _tmp3_;
		_prerequisite_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_prerequisite_index = _prerequisite_index + 1;
			_tmp4_ = _prerequisite_index;
			_tmp5_ = _prerequisite_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _prerequisite_list;
			_tmp7_ = vala_list_get (_tmp6_, _prerequisite_index);
			prerequisite = (ValaDataType*) _tmp7_;
			_tmp9_ = prerequisite;
			_tmp10_ = vala_data_type_get_type_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaDataType* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				_tmp12_ = prerequisite;
				_tmp13_ = vala_data_type_get_type_symbol (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = vala_typesymbol_is_subtype_of (_tmp14_, t);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
	}
	result = FALSE;
	return result;
}

static void
vala_interface_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->prerequisites;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->prerequisites;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->prerequisites;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_interface_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaInterface * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaClass* prereq_class = NULL;
	gboolean _tmp124_;
	gboolean _tmp125_;
	ValaMap* positions = NULL;
	GHashFunc _tmp255_;
	GEqualFunc _tmp256_;
	GEqualFunc _tmp257_;
	ValaHashMap* _tmp258_;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	ValaSemanticAnalyzer* _tmp323_;
	ValaSemanticAnalyzer* _tmp324_;
	ValaSourceFile* _tmp325_;
	ValaSemanticAnalyzer* _tmp326_;
	ValaSemanticAnalyzer* _tmp327_;
	ValaSymbol* _tmp328_;
	gboolean _tmp329_;
	gboolean _tmp330_;
	gboolean result;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	if (!VALA_CODE_NODE_CLASS (vala_interface_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), context)) {
		result = FALSE;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp24_;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _prerequisite_reference_index = 0;
		_tmp24_ = vala_interface_get_prerequisites (self);
		_prerequisite_reference_list = _tmp24_;
		_tmp25_ = _prerequisite_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_prerequisite_reference_size = _tmp27_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp30_;
			gpointer _tmp31_;
			ValaDataType* _tmp32_;
			_prerequisite_reference_index = _prerequisite_reference_index + 1;
			_tmp28_ = _prerequisite_reference_index;
			_tmp29_ = _prerequisite_reference_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _prerequisite_reference_list;
			_tmp31_ = vala_list_get (_tmp30_, _prerequisite_reference_index);
			prerequisite_reference = (ValaDataType*) _tmp31_;
			_tmp32_ = prerequisite_reference;
			if (!vala_data_type_is_accessible (_tmp32_, (ValaSymbol*) self)) {
				ValaSourceReference* _tmp33_;
				ValaSourceReference* _tmp34_;
				ValaDataType* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp34_ = _tmp33_;
				_tmp35_ = prerequisite_reference;
				_tmp36_ = vala_code_node_to_string ((ValaCodeNode*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp39_ = _tmp38_;
				vala_report_error (_tmp34_, "prerequisite `%s' is less accessible than interface `%s'", _tmp37_, _tmp39_);
				_g_free0 (_tmp39_);
				_g_free0 (_tmp37_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp40_;
		gint _prereq_size = 0;
		ValaList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _prereq_index = 0;
		_tmp40_ = vala_interface_get_prerequisites (self);
		_prereq_list = _tmp40_;
		_tmp41_ = _prereq_list;
		_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_prereq_size = _tmp43_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp44_;
			gint _tmp45_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp46_;
			gpointer _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			_prereq_index = _prereq_index + 1;
			_tmp44_ = _prereq_index;
			_tmp45_ = _prereq_size;
			if (!(_tmp44_ < _tmp45_)) {
				break;
			}
			_tmp46_ = _prereq_list;
			_tmp47_ = vala_list_get (_tmp46_, _prereq_index);
			prereq = (ValaDataType*) _tmp47_;
			_tmp48_ = prereq;
			if (!VALA_IS_OBJECT_TYPE (_tmp48_)) {
				ValaSourceReference* _tmp49_;
				ValaSourceReference* _tmp50_;
				ValaDataType* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp50_ = _tmp49_;
				_tmp51_ = prereq;
				_tmp52_ = vala_code_node_to_string ((ValaCodeNode*) _tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp50_, "Prerequisite `%s' of interface `%s' is not a class or interface", _tmp53_, _tmp55_);
				_g_free0 (_tmp55_);
				_g_free0 (_tmp53_);
				result = FALSE;
				_vala_code_node_unref0 (prereq);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp56_ = prereq;
			_tmp57_ = vala_data_type_get_type_symbol (_tmp56_);
			_tmp58_ = _tmp57_;
			if (VALA_IS_CLASS (_tmp58_)) {
				ValaClass* _tmp59_;
				ValaDataType* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaTypeSymbol* _tmp74_;
				ValaClass* _tmp75_;
				_tmp59_ = prereq_class;
				if (_tmp59_ != NULL) {
					ValaSourceReference* _tmp60_;
					ValaSourceReference* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					ValaDataType* _tmp64_;
					ValaTypeSymbol* _tmp65_;
					ValaTypeSymbol* _tmp66_;
					gchar* _tmp67_;
					gchar* _tmp68_;
					ValaClass* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp61_ = _tmp60_;
					_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp63_ = _tmp62_;
					_tmp64_ = prereq;
					_tmp65_ = vala_data_type_get_type_symbol (_tmp64_);
					_tmp66_ = _tmp65_;
					_tmp67_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = prereq_class;
					_tmp70_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp69_);
					_tmp71_ = _tmp70_;
					vala_report_error (_tmp61_, "%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp63_, _tmp68_, _tmp71_);
					_g_free0 (_tmp71_);
					_g_free0 (_tmp68_);
					_g_free0 (_tmp63_);
					result = FALSE;
					_vala_code_node_unref0 (prereq);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp72_ = prereq;
				_tmp73_ = vala_data_type_get_type_symbol (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp75_;
			}
			_vala_code_node_unref0 (prereq);
		}
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp76_;
		gint _type_size = 0;
		ValaList* _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		gint _type_index = 0;
		_tmp76_ = self->priv->prerequisites;
		_type_list = _tmp76_;
		_tmp77_ = _type_list;
		_tmp78_ = vala_collection_get_size ((ValaCollection*) _tmp77_);
		_tmp79_ = _tmp78_;
		_type_size = _tmp79_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp80_;
			gint _tmp81_;
			ValaDataType* type = NULL;
			ValaList* _tmp82_;
			gpointer _tmp83_;
			ValaDataType* _tmp84_;
			ValaSemanticAnalyzer* _tmp85_;
			ValaSemanticAnalyzer* _tmp86_;
			ValaDataType* _tmp87_;
			_type_index = _type_index + 1;
			_tmp80_ = _type_index;
			_tmp81_ = _type_size;
			if (!(_tmp80_ < _tmp81_)) {
				break;
			}
			_tmp82_ = _type_list;
			_tmp83_ = vala_list_get (_tmp82_, _type_index);
			type = (ValaDataType*) _tmp83_;
			_tmp84_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp84_, context);
			_tmp85_ = vala_code_context_get_analyzer (context);
			_tmp86_ = _tmp85_;
			_tmp87_ = type;
			vala_semantic_analyzer_check_type (_tmp86_, _tmp87_);
			_vala_code_node_unref0 (type);
		}
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp88_;
		gint _p_size = 0;
		ValaList* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gint _p_index = 0;
		_tmp88_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp88_;
		_tmp89_ = _p_list;
		_tmp90_ = vala_collection_get_size ((ValaCollection*) _tmp89_);
		_tmp91_ = _tmp90_;
		_p_size = _tmp91_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp92_;
			gint _tmp93_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp94_;
			gpointer _tmp95_;
			ValaTypeParameter* _tmp96_;
			_p_index = _p_index + 1;
			_tmp92_ = _p_index;
			_tmp93_ = _p_size;
			if (!(_tmp92_ < _tmp93_)) {
				break;
			}
			_tmp94_ = _p_list;
			_tmp95_ = vala_list_get (_tmp94_, _p_index);
			p = (ValaTypeParameter*) _tmp95_;
			_tmp96_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp96_, context);
			_vala_code_node_unref0 (p);
		}
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp97_;
		gint _en_size = 0;
		ValaList* _tmp98_;
		gint _tmp99_;
		gint _tmp100_;
		gint _en_index = 0;
		_tmp97_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp97_;
		_tmp98_ = _en_list;
		_tmp99_ = vala_collection_get_size ((ValaCollection*) _tmp98_);
		_tmp100_ = _tmp99_;
		_en_size = _tmp100_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp101_;
			gint _tmp102_;
			ValaEnum* en = NULL;
			ValaList* _tmp103_;
			gpointer _tmp104_;
			ValaEnum* _tmp105_;
			_en_index = _en_index + 1;
			_tmp101_ = _en_index;
			_tmp102_ = _en_size;
			if (!(_tmp101_ < _tmp102_)) {
				break;
			}
			_tmp103_ = _en_list;
			_tmp104_ = vala_list_get (_tmp103_, _en_index);
			en = (ValaEnum*) _tmp104_;
			_tmp105_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp105_, context);
			_vala_code_node_unref0 (en);
		}
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp106_;
		gint _f_size = 0;
		ValaList* _tmp107_;
		gint _tmp108_;
		gint _tmp109_;
		gint _f_index = 0;
		_tmp106_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp106_;
		_tmp107_ = _f_list;
		_tmp108_ = vala_collection_get_size ((ValaCollection*) _tmp107_);
		_tmp109_ = _tmp108_;
		_f_size = _tmp109_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp110_;
			gint _tmp111_;
			ValaField* f = NULL;
			ValaList* _tmp112_;
			gpointer _tmp113_;
			ValaField* _tmp114_;
			_f_index = _f_index + 1;
			_tmp110_ = _f_index;
			_tmp111_ = _f_size;
			if (!(_tmp110_ < _tmp111_)) {
				break;
			}
			_tmp112_ = _f_list;
			_tmp113_ = vala_list_get (_tmp112_, _f_index);
			f = (ValaField*) _tmp113_;
			_tmp114_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp114_, context);
			_vala_code_node_unref0 (f);
		}
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp115_;
		gint _c_size = 0;
		ValaList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _c_index = 0;
		_tmp115_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp115_;
		_tmp116_ = _c_list;
		_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		_c_size = _tmp118_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp119_;
			gint _tmp120_;
			ValaConstant* c = NULL;
			ValaList* _tmp121_;
			gpointer _tmp122_;
			ValaConstant* _tmp123_;
			_c_index = _c_index + 1;
			_tmp119_ = _c_index;
			_tmp120_ = _c_size;
			if (!(_tmp119_ < _tmp120_)) {
				break;
			}
			_tmp121_ = _c_list;
			_tmp122_ = vala_list_get (_tmp121_, _c_index);
			c = (ValaConstant*) _tmp122_;
			_tmp123_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp123_, context);
			_vala_code_node_unref0 (c);
		}
	}
	_tmp124_ = vala_code_context_get_abi_stability (context);
	_tmp125_ = _tmp124_;
	if (_tmp125_) {
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp126_;
			gint _s_size = 0;
			ValaList* _tmp127_;
			gint _tmp128_;
			gint _tmp129_;
			gint _s_index = 0;
			_tmp126_ = vala_object_type_symbol_get_members ((ValaObjectTypeSymbol*) self);
			_s_list = _tmp126_;
			_tmp127_ = _s_list;
			_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
			_tmp129_ = _tmp128_;
			_s_size = _tmp129_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp130_;
				gint _tmp131_;
				ValaSymbol* s = NULL;
				ValaList* _tmp132_;
				gpointer _tmp133_;
				ValaSymbol* _tmp134_;
				_s_index = _s_index + 1;
				_tmp130_ = _s_index;
				_tmp131_ = _s_size;
				if (!(_tmp130_ < _tmp131_)) {
					break;
				}
				_tmp132_ = _s_list;
				_tmp133_ = vala_list_get (_tmp132_, _s_index);
				s = (ValaSymbol*) _tmp133_;
				_tmp134_ = s;
				if (VALA_IS_METHOD (_tmp134_)) {
					ValaMethod* m = NULL;
					ValaSymbol* _tmp135_;
					ValaMethod* _tmp136_;
					ValaMethod* _tmp137_;
					gboolean _tmp138_ = FALSE;
					ValaMethod* _tmp139_;
					gboolean _tmp140_;
					gboolean _tmp141_;
					_tmp135_ = s;
					_tmp136_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp135_, VALA_TYPE_METHOD, ValaMethod));
					m = _tmp136_;
					_tmp137_ = m;
					vala_code_node_check ((ValaCodeNode*) _tmp137_, context);
					_tmp139_ = m;
					_tmp140_ = vala_method_get_is_virtual (_tmp139_);
					_tmp141_ = _tmp140_;
					if (_tmp141_) {
						_tmp138_ = TRUE;
					} else {
						ValaMethod* _tmp142_;
						gboolean _tmp143_;
						gboolean _tmp144_;
						_tmp142_ = m;
						_tmp143_ = vala_method_get_is_abstract (_tmp142_);
						_tmp144_ = _tmp143_;
						_tmp138_ = _tmp144_;
					}
					if (_tmp138_) {
						ValaList* _tmp145_;
						ValaMethod* _tmp146_;
						_tmp145_ = self->priv->virtuals;
						_tmp146_ = m;
						vala_collection_add ((ValaCollection*) _tmp145_, (ValaSymbol*) _tmp146_);
					}
					_vala_code_node_unref0 (m);
				} else {
					ValaSymbol* _tmp147_;
					_tmp147_ = s;
					if (VALA_IS_SIGNAL (_tmp147_)) {
						ValaSignal* sig = NULL;
						ValaSymbol* _tmp148_;
						ValaSignal* _tmp149_;
						ValaSignal* _tmp150_;
						ValaSignal* _tmp151_;
						gboolean _tmp152_;
						gboolean _tmp153_;
						_tmp148_ = s;
						_tmp149_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp148_, VALA_TYPE_SIGNAL, ValaSignal));
						sig = _tmp149_;
						_tmp150_ = sig;
						vala_code_node_check ((ValaCodeNode*) _tmp150_, context);
						_tmp151_ = sig;
						_tmp152_ = vala_signal_get_is_virtual (_tmp151_);
						_tmp153_ = _tmp152_;
						if (_tmp153_) {
							ValaList* _tmp154_;
							ValaSignal* _tmp155_;
							_tmp154_ = self->priv->virtuals;
							_tmp155_ = sig;
							vala_collection_add ((ValaCollection*) _tmp154_, (ValaSymbol*) _tmp155_);
						}
						_vala_code_node_unref0 (sig);
					} else {
						ValaSymbol* _tmp156_;
						_tmp156_ = s;
						if (VALA_IS_PROPERTY (_tmp156_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp157_;
							ValaProperty* _tmp158_;
							ValaProperty* _tmp159_;
							gboolean _tmp160_ = FALSE;
							ValaProperty* _tmp161_;
							gboolean _tmp162_;
							gboolean _tmp163_;
							_tmp157_ = s;
							_tmp158_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp157_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp158_;
							_tmp159_ = prop;
							vala_code_node_check ((ValaCodeNode*) _tmp159_, context);
							_tmp161_ = prop;
							_tmp162_ = vala_property_get_is_virtual (_tmp161_);
							_tmp163_ = _tmp162_;
							if (_tmp163_) {
								_tmp160_ = TRUE;
							} else {
								ValaProperty* _tmp164_;
								gboolean _tmp165_;
								gboolean _tmp166_;
								_tmp164_ = prop;
								_tmp165_ = vala_property_get_is_abstract (_tmp164_);
								_tmp166_ = _tmp165_;
								_tmp160_ = _tmp166_;
							}
							if (_tmp160_) {
								ValaList* _tmp167_;
								ValaProperty* _tmp168_;
								_tmp167_ = self->priv->virtuals;
								_tmp168_ = prop;
								vala_collection_add ((ValaCollection*) _tmp167_, (ValaSymbol*) _tmp168_);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (s);
			}
		}
	} else {
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp169_;
			gint _m_size = 0;
			ValaList* _tmp170_;
			gint _tmp171_;
			gint _tmp172_;
			gint _m_index = 0;
			_tmp169_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
			_m_list = _tmp169_;
			_tmp170_ = _m_list;
			_tmp171_ = vala_collection_get_size ((ValaCollection*) _tmp170_);
			_tmp172_ = _tmp171_;
			_m_size = _tmp172_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp173_;
				gint _tmp174_;
				ValaMethod* m = NULL;
				ValaList* _tmp175_;
				gpointer _tmp176_;
				ValaMethod* _tmp177_;
				gboolean _tmp178_ = FALSE;
				ValaMethod* _tmp179_;
				gboolean _tmp180_;
				gboolean _tmp181_;
				_m_index = _m_index + 1;
				_tmp173_ = _m_index;
				_tmp174_ = _m_size;
				if (!(_tmp173_ < _tmp174_)) {
					break;
				}
				_tmp175_ = _m_list;
				_tmp176_ = vala_list_get (_tmp175_, _m_index);
				m = (ValaMethod*) _tmp176_;
				_tmp177_ = m;
				vala_code_node_check ((ValaCodeNode*) _tmp177_, context);
				_tmp179_ = m;
				_tmp180_ = vala_method_get_is_virtual (_tmp179_);
				_tmp181_ = _tmp180_;
				if (_tmp181_) {
					_tmp178_ = TRUE;
				} else {
					ValaMethod* _tmp182_;
					gboolean _tmp183_;
					gboolean _tmp184_;
					_tmp182_ = m;
					_tmp183_ = vala_method_get_is_abstract (_tmp182_);
					_tmp184_ = _tmp183_;
					_tmp178_ = _tmp184_;
				}
				if (_tmp178_) {
					ValaList* _tmp185_;
					ValaMethod* _tmp186_;
					_tmp185_ = self->priv->virtuals;
					_tmp186_ = m;
					vala_collection_add ((ValaCollection*) _tmp185_, (ValaSymbol*) _tmp186_);
				}
				_vala_code_node_unref0 (m);
			}
		}
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp187_;
			gint _sig_size = 0;
			ValaList* _tmp188_;
			gint _tmp189_;
			gint _tmp190_;
			gint _sig_index = 0;
			_tmp187_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
			_sig_list = _tmp187_;
			_tmp188_ = _sig_list;
			_tmp189_ = vala_collection_get_size ((ValaCollection*) _tmp188_);
			_tmp190_ = _tmp189_;
			_sig_size = _tmp190_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp191_;
				gint _tmp192_;
				ValaSignal* sig = NULL;
				ValaList* _tmp193_;
				gpointer _tmp194_;
				ValaSignal* _tmp195_;
				ValaSignal* _tmp196_;
				gboolean _tmp197_;
				gboolean _tmp198_;
				_sig_index = _sig_index + 1;
				_tmp191_ = _sig_index;
				_tmp192_ = _sig_size;
				if (!(_tmp191_ < _tmp192_)) {
					break;
				}
				_tmp193_ = _sig_list;
				_tmp194_ = vala_list_get (_tmp193_, _sig_index);
				sig = (ValaSignal*) _tmp194_;
				_tmp195_ = sig;
				vala_code_node_check ((ValaCodeNode*) _tmp195_, context);
				_tmp196_ = sig;
				_tmp197_ = vala_signal_get_is_virtual (_tmp196_);
				_tmp198_ = _tmp197_;
				if (_tmp198_) {
					ValaList* _tmp199_;
					ValaSignal* _tmp200_;
					_tmp199_ = self->priv->virtuals;
					_tmp200_ = sig;
					vala_collection_add ((ValaCollection*) _tmp199_, (ValaSymbol*) _tmp200_);
				}
				_vala_code_node_unref0 (sig);
			}
		}
		{
			ValaList* _prop_list = NULL;
			ValaList* _tmp201_;
			gint _prop_size = 0;
			ValaList* _tmp202_;
			gint _tmp203_;
			gint _tmp204_;
			gint _prop_index = 0;
			_tmp201_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
			_prop_list = _tmp201_;
			_tmp202_ = _prop_list;
			_tmp203_ = vala_collection_get_size ((ValaCollection*) _tmp202_);
			_tmp204_ = _tmp203_;
			_prop_size = _tmp204_;
			_prop_index = -1;
			while (TRUE) {
				gint _tmp205_;
				gint _tmp206_;
				ValaProperty* prop = NULL;
				ValaList* _tmp207_;
				gpointer _tmp208_;
				ValaProperty* _tmp209_;
				gboolean _tmp210_ = FALSE;
				ValaProperty* _tmp211_;
				gboolean _tmp212_;
				gboolean _tmp213_;
				_prop_index = _prop_index + 1;
				_tmp205_ = _prop_index;
				_tmp206_ = _prop_size;
				if (!(_tmp205_ < _tmp206_)) {
					break;
				}
				_tmp207_ = _prop_list;
				_tmp208_ = vala_list_get (_tmp207_, _prop_index);
				prop = (ValaProperty*) _tmp208_;
				_tmp209_ = prop;
				vala_code_node_check ((ValaCodeNode*) _tmp209_, context);
				_tmp211_ = prop;
				_tmp212_ = vala_property_get_is_virtual (_tmp211_);
				_tmp213_ = _tmp212_;
				if (_tmp213_) {
					_tmp210_ = TRUE;
				} else {
					ValaProperty* _tmp214_;
					gboolean _tmp215_;
					gboolean _tmp216_;
					_tmp214_ = prop;
					_tmp215_ = vala_property_get_is_abstract (_tmp214_);
					_tmp216_ = _tmp215_;
					_tmp210_ = _tmp216_;
				}
				if (_tmp210_) {
					ValaList* _tmp217_;
					ValaProperty* _tmp218_;
					_tmp217_ = self->priv->virtuals;
					_tmp218_ = prop;
					vala_collection_add ((ValaCollection*) _tmp217_, (ValaSymbol*) _tmp218_);
				}
				_vala_code_node_unref0 (prop);
			}
		}
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp219_;
		gint _cl_size = 0;
		ValaList* _tmp220_;
		gint _tmp221_;
		gint _tmp222_;
		gint _cl_index = 0;
		_tmp219_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp219_;
		_tmp220_ = _cl_list;
		_tmp221_ = vala_collection_get_size ((ValaCollection*) _tmp220_);
		_tmp222_ = _tmp221_;
		_cl_size = _tmp222_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp223_;
			gint _tmp224_;
			ValaClass* cl = NULL;
			ValaList* _tmp225_;
			gpointer _tmp226_;
			ValaClass* _tmp227_;
			_cl_index = _cl_index + 1;
			_tmp223_ = _cl_index;
			_tmp224_ = _cl_size;
			if (!(_tmp223_ < _tmp224_)) {
				break;
			}
			_tmp225_ = _cl_list;
			_tmp226_ = vala_list_get (_tmp225_, _cl_index);
			cl = (ValaClass*) _tmp226_;
			_tmp227_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp227_, context);
			_vala_code_node_unref0 (cl);
		}
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp228_;
		gint _iface_size = 0;
		ValaList* _tmp229_;
		gint _tmp230_;
		gint _tmp231_;
		gint _iface_index = 0;
		_tmp228_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_iface_list = _tmp228_;
		_tmp229_ = _iface_list;
		_tmp230_ = vala_collection_get_size ((ValaCollection*) _tmp229_);
		_tmp231_ = _tmp230_;
		_iface_size = _tmp231_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp232_;
			gint _tmp233_;
			ValaInterface* iface = NULL;
			ValaList* _tmp234_;
			gpointer _tmp235_;
			ValaInterface* _tmp236_;
			_iface_index = _iface_index + 1;
			_tmp232_ = _iface_index;
			_tmp233_ = _iface_size;
			if (!(_tmp232_ < _tmp233_)) {
				break;
			}
			_tmp234_ = _iface_list;
			_tmp235_ = vala_list_get (_tmp234_, _iface_index);
			iface = (ValaInterface*) _tmp235_;
			_tmp236_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp236_, context);
			_vala_code_node_unref0 (iface);
		}
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp237_;
		gint _st_size = 0;
		ValaList* _tmp238_;
		gint _tmp239_;
		gint _tmp240_;
		gint _st_index = 0;
		_tmp237_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp237_;
		_tmp238_ = _st_list;
		_tmp239_ = vala_collection_get_size ((ValaCollection*) _tmp238_);
		_tmp240_ = _tmp239_;
		_st_size = _tmp240_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp241_;
			gint _tmp242_;
			ValaStruct* st = NULL;
			ValaList* _tmp243_;
			gpointer _tmp244_;
			ValaStruct* _tmp245_;
			_st_index = _st_index + 1;
			_tmp241_ = _st_index;
			_tmp242_ = _st_size;
			if (!(_tmp241_ < _tmp242_)) {
				break;
			}
			_tmp243_ = _st_list;
			_tmp244_ = vala_list_get (_tmp243_, _st_index);
			st = (ValaStruct*) _tmp244_;
			_tmp245_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp245_, context);
			_vala_code_node_unref0 (st);
		}
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp246_;
		gint _d_size = 0;
		ValaList* _tmp247_;
		gint _tmp248_;
		gint _tmp249_;
		gint _d_index = 0;
		_tmp246_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp246_;
		_tmp247_ = _d_list;
		_tmp248_ = vala_collection_get_size ((ValaCollection*) _tmp247_);
		_tmp249_ = _tmp248_;
		_d_size = _tmp249_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp250_;
			gint _tmp251_;
			ValaDelegate* d = NULL;
			ValaList* _tmp252_;
			gpointer _tmp253_;
			ValaDelegate* _tmp254_;
			_d_index = _d_index + 1;
			_tmp250_ = _d_index;
			_tmp251_ = _d_size;
			if (!(_tmp250_ < _tmp251_)) {
				break;
			}
			_tmp252_ = _d_list;
			_tmp253_ = vala_list_get (_tmp252_, _d_index);
			d = (ValaDelegate*) _tmp253_;
			_tmp254_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp254_, context);
			_vala_code_node_unref0 (d);
		}
	}
	_tmp255_ = g_direct_hash;
	_tmp256_ = g_direct_equal;
	_tmp257_ = g_direct_equal;
	_tmp258_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp255_, _tmp256_, _tmp257_);
	positions = (ValaMap*) _tmp258_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp259_;
		gint _sym_size = 0;
		ValaList* _tmp260_;
		gint _tmp261_;
		gint _tmp262_;
		gint _sym_index = 0;
		_tmp259_ = self->priv->virtuals;
		_sym_list = _tmp259_;
		_tmp260_ = _sym_list;
		_tmp261_ = vala_collection_get_size ((ValaCollection*) _tmp260_);
		_tmp262_ = _tmp261_;
		_sym_size = _tmp262_;
		_sym_index = -1;
		while (TRUE) {
			gint _tmp263_;
			gint _tmp264_;
			ValaSymbol* sym = NULL;
			ValaList* _tmp265_;
			gpointer _tmp266_;
			gint ordering = 0;
			ValaSymbol* _tmp267_;
			gboolean ordered = FALSE;
			gboolean _tmp274_ = FALSE;
			gboolean _tmp275_ = FALSE;
			gboolean _tmp282_ = FALSE;
			gboolean _tmp283_ = FALSE;
			gboolean _tmp284_ = FALSE;
			gboolean _tmp291_ = FALSE;
			gboolean _tmp292_ = FALSE;
			_sym_index = _sym_index + 1;
			_tmp263_ = _sym_index;
			_tmp264_ = _sym_size;
			if (!(_tmp263_ < _tmp264_)) {
				break;
			}
			_tmp265_ = _sym_list;
			_tmp266_ = vala_list_get (_tmp265_, _sym_index);
			sym = (ValaSymbol*) _tmp266_;
			_tmp267_ = sym;
			ordering = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp267_, "CCode", "ordering", -1);
			if (ordering < -1) {
				ValaSymbol* _tmp268_;
				ValaSourceReference* _tmp269_;
				ValaSourceReference* _tmp270_;
				ValaSymbol* _tmp271_;
				gchar* _tmp272_;
				gchar* _tmp273_;
				_tmp268_ = sym;
				_tmp269_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp268_);
				_tmp270_ = _tmp269_;
				_tmp271_ = sym;
				_tmp272_ = vala_symbol_get_full_name (_tmp271_);
				_tmp273_ = _tmp272_;
				vala_report_error (_tmp270_, "%s: Invalid ordering", _tmp273_);
				_g_free0 (_tmp273_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			ordered = ordering != -1;
			if (ordered) {
				_tmp275_ = unordered_seen;
			} else {
				_tmp275_ = FALSE;
			}
			if (_tmp275_) {
				_tmp274_ = !ordered_seen;
			} else {
				_tmp274_ = FALSE;
			}
			if (_tmp274_) {
				ValaSymbol* _tmp276_;
				ValaSourceReference* _tmp277_;
				ValaSourceReference* _tmp278_;
				ValaSymbol* _tmp279_;
				gchar* _tmp280_;
				gchar* _tmp281_;
				_tmp276_ = sym;
				_tmp277_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp276_);
				_tmp278_ = _tmp277_;
				_tmp279_ = sym;
				_tmp280_ = vala_symbol_get_full_name (_tmp279_);
				_tmp281_ = _tmp280_;
				vala_report_error (_tmp278_, "%s: Cannot mix ordered and unordered virtuals", _tmp281_);
				_g_free0 (_tmp281_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (ordered_seen) {
				_tmp282_ = TRUE;
			} else {
				_tmp282_ = ordered;
			}
			ordered_seen = _tmp282_;
			if (!ordered) {
				_tmp284_ = !unordered_seen;
			} else {
				_tmp284_ = FALSE;
			}
			if (_tmp284_) {
				_tmp283_ = ordered_seen;
			} else {
				_tmp283_ = FALSE;
			}
			if (_tmp283_) {
				ValaSymbol* _tmp285_;
				ValaSourceReference* _tmp286_;
				ValaSourceReference* _tmp287_;
				ValaSymbol* _tmp288_;
				gchar* _tmp289_;
				gchar* _tmp290_;
				_tmp285_ = sym;
				_tmp286_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp285_);
				_tmp287_ = _tmp286_;
				_tmp288_ = sym;
				_tmp289_ = vala_symbol_get_full_name (_tmp288_);
				_tmp290_ = _tmp289_;
				vala_report_error (_tmp287_, "%s: Cannot mix ordered and unordered virtuals", _tmp290_);
				_g_free0 (_tmp290_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (unordered_seen) {
				_tmp291_ = TRUE;
			} else {
				_tmp291_ = !ordered;
			}
			unordered_seen = _tmp291_;
			if (!ordered_seen) {
				_tmp292_ = TRUE;
			} else {
				_tmp292_ = !unordered_seen;
			}
			if (_tmp292_) {
				if (ordered) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp293_;
					gpointer _tmp294_;
					ValaSymbol* _tmp295_;
					ValaMap* _tmp305_;
					ValaSymbol* _tmp306_;
					_tmp293_ = positions;
					_tmp294_ = vala_map_get (_tmp293_, (gpointer) ((gintptr) ordering));
					prev = (ValaSymbol*) _tmp294_;
					_tmp295_ = prev;
					if (_tmp295_ != NULL) {
						ValaSymbol* _tmp296_;
						ValaSourceReference* _tmp297_;
						ValaSourceReference* _tmp298_;
						ValaSymbol* _tmp299_;
						gchar* _tmp300_;
						gchar* _tmp301_;
						ValaSymbol* _tmp302_;
						const gchar* _tmp303_;
						const gchar* _tmp304_;
						_tmp296_ = sym;
						_tmp297_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp296_);
						_tmp298_ = _tmp297_;
						_tmp299_ = sym;
						_tmp300_ = vala_symbol_get_full_name (_tmp299_);
						_tmp301_ = _tmp300_;
						_tmp302_ = prev;
						_tmp303_ = vala_symbol_get_name (_tmp302_);
						_tmp304_ = _tmp303_;
						vala_report_error (_tmp298_, "%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp301_, _tmp304_);
						_g_free0 (_tmp301_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp305_ = positions;
					_tmp306_ = sym;
					vala_map_set (_tmp305_, (gpointer) ((gintptr) ordering), _tmp306_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
	}
	if (ordered_seen) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp307_ = FALSE;
				_tmp307_ = TRUE;
				while (TRUE) {
					ValaList* _tmp309_;
					gint _tmp310_;
					gint _tmp311_;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp312_;
					gpointer _tmp313_;
					ValaSymbol* _tmp314_;
					gboolean _tmp319_;
					gboolean _tmp320_;
					if (!_tmp307_) {
						gint _tmp308_;
						_tmp308_ = i;
						i = _tmp308_ + 1;
					}
					_tmp307_ = FALSE;
					_tmp309_ = self->priv->virtuals;
					_tmp310_ = vala_collection_get_size ((ValaCollection*) _tmp309_);
					_tmp311_ = _tmp310_;
					if (!(i < _tmp311_)) {
						break;
					}
					_tmp312_ = positions;
					_tmp313_ = vala_map_get (_tmp312_, (gpointer) ((gintptr) i));
					sym = (ValaSymbol*) _tmp313_;
					_tmp314_ = sym;
					if (_tmp314_ == NULL) {
						ValaSourceReference* _tmp315_;
						ValaSourceReference* _tmp316_;
						gchar* _tmp317_;
						gchar* _tmp318_;
						_tmp315_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp316_ = _tmp315_;
						_tmp317_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp318_ = _tmp317_;
						vala_report_error (_tmp316_, "%s: Gap in ordering in position %d", _tmp318_, i);
						_g_free0 (_tmp318_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp319_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp320_ = _tmp319_;
					if (!_tmp320_) {
						ValaList* _tmp321_;
						ValaSymbol* _tmp322_;
						_tmp321_ = self->priv->virtuals;
						_tmp322_ = sym;
						vala_list_set (_tmp321_, i, _tmp322_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp323_ = vala_code_context_get_analyzer (context);
	_tmp324_ = _tmp323_;
	_tmp325_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp324_, _tmp325_);
	_tmp326_ = vala_code_context_get_analyzer (context);
	_tmp327_ = _tmp326_;
	_tmp328_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp327_, _tmp328_);
	_tmp329_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp330_ = _tmp329_;
	result = !_tmp330_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_interface_class_init (ValaInterfaceClass * klass,
                           gpointer klass_data)
{
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_interface_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInterface_private_offset);
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_interface_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_interface_real_add_property;
	((ValaInterfaceClass *) klass)->get_virtuals = (ValaList* (*) (ValaInterface*)) vala_interface_real_get_virtuals;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_interface_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_interface_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_interface_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_interface_real_check;
}

static void
vala_interface_instance_init (ValaInterface * self,
                              gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_interface_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->virtuals = (ValaList*) _tmp3_;
}

static void
vala_interface_finalize (ValaCodeNode * obj)
{
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->virtuals);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}

/**
 * Represents an interface declaration in the source code.
 */
static GType
vala_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
	GType vala_interface_type_id;
	vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
	ValaInterface_private_offset = g_type_add_instance_private (vala_interface_type_id, sizeof (ValaInterfacePrivate));
	return vala_interface_type_id;
}

GType
vala_interface_get_type (void)
{
	static volatile gsize vala_interface_type_id__once = 0;
	if (g_once_init_enter (&vala_interface_type_id__once)) {
		GType vala_interface_type_id;
		vala_interface_type_id = vala_interface_get_type_once ();
		g_once_init_leave (&vala_interface_type_id__once, vala_interface_type_id);
	}
	return vala_interface_type_id__once;
}

