The compiler found multiple library files with the requested crate name.

```compile_fail
// aux-build:crateresolve-1.rs
// aux-build:crateresolve-2.rs
// aux-build:crateresolve-3.rs

extern crate crateresolve;
//~^ ERROR multiple candidates for `rlib` dependency `crateresolve` found

fn main() {}
```

This error can occur in several different cases -- for example, when using
`extern crate` or passing `--extern` options without crate paths. It can also be
caused by caching issues with the build directory, in which case `cargo clean`
may help.

In the above example, there are three different library files, all of which
define the same crate name. Without providing a full path, there is no way for
the compiler to know which crate it should use.
