Generated Dart libraries for accessing
[Google APIs](https://developers.google.com/api-client-library).

To use these APIs from Flutter, see the
[Flutter Google APIs documentation](https://flutter.dev/docs/development/data-and-backend/google-apis).

For example of using these APIs from a Dart console example see the example in
this package. For an example of usage in a server application,
[see this example](https://github.com/dart-lang/samples/tree/master/server/google_apis).

## Available Google APIs

The following is a list of APIs that are currently available inside this
package.

#### Abusive Experience Report API - `abusiveexperiencereport.v1`

Views Abusive Experience Report data, and gets a list of sites that have a significant number of abusive experiences.

- [Documentation](https://developers.google.com/abusive-experience-report/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/abusiveexperiencereport.v1/abusiveexperiencereport.v1-library.html)

#### Accelerated Mobile Pages (AMP) URL API - `acceleratedmobilepageurl.v1`

Retrieves the list of AMP URLs (and equivalent AMP Cache URLs) for a given list of public URL(s). 

- [Documentation](https://developers.google.com/amp/cache/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/acceleratedmobilepageurl.v1/acceleratedmobilepageurl.v1-library.html)

#### Access Approval API - `accessapproval.v1`

An API for controlling access to data by Google personnel.

- [Documentation](https://cloud.google.com/access-approval/docs)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/accessapproval.v1/accessapproval.v1-library.html)

#### Access Context Manager API - `accesscontextmanager.v1`

An API for setting attribute based access control to requests to GCP services.

- [Documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/accesscontextmanager.v1/accesscontextmanager.v1-library.html)

#### ![Logo](https://www.google.com/images/icons/product/doubleclick-16.gif) Ad Exchange Buyer API - `adexchangebuyer.v1_3`

Accesses your bidding-account information, submits creatives for validation, finds available direct deals, and retrieves performance reports.

- [Documentation](https://developers.google.com/ad-exchange/buyer-rest)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/adexchangebuyer.v1_3/adexchangebuyer.v1_3-library.html)

#### ![Logo](https://www.google.com/images/icons/product/doubleclick-16.gif) Ad Exchange Buyer API - `adexchangebuyer.v1_4`

Accesses your bidding-account information, submits creatives for validation, finds available direct deals, and retrieves performance reports.

- [Documentation](https://developers.google.com/ad-exchange/buyer-rest)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/adexchangebuyer.v1_4/adexchangebuyer.v1_4-library.html)

#### Ad Experience Report API - `adexperiencereport.v1`

Views Ad Experience Report data, and gets a list of sites that have a significant number of annoying ads.

- [Documentation](https://developers.google.com/ad-experience-report/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/adexperiencereport.v1/adexperiencereport.v1-library.html)

#### Admin SDK API - `admin.datatransfer_v1`

Admin SDK lets administrators of enterprise domains to view and manage resources like user, groups etc. It also provides audit and usage reports of domain.

- [Documentation](http://developers.google.com/admin-sdk/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/admin.datatransfer_v1/admin.datatransfer_v1-library.html)

#### Admin SDK API - `admin.directory_v1`

Admin SDK lets administrators of enterprise domains to view and manage resources like user, groups etc. It also provides audit and usage reports of domain.

- [Documentation](http://developers.google.com/admin-sdk/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/admin.directory_v1/admin.directory_v1-library.html)

#### Admin SDK API - `admin.reports_v1`

Admin SDK lets administrators of enterprise domains to view and manage resources like user, groups etc. It also provides audit and usage reports of domain.

- [Documentation](http://developers.google.com/admin-sdk/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/admin.reports_v1/admin.reports_v1-library.html)

#### AdMob API - `admob.v1`

The AdMob API allows publishers to programmatically get information about their AdMob account. 

- [Documentation](https://developers.google.com/admob/api/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/admob.v1/admob.v1-library.html)

#### ![Logo](https://www.google.com/images/icons/product/adsense-16.png) AdSense Management API - `adsense.v1_4`

Accesses AdSense publishers' inventory and generates performance reports.

- [Documentation](https://developers.google.com/adsense/management/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/adsense.v1_4/adsense.v1_4-library.html)

#### AdSense Management API - `adsense.v2`

The AdSense Management API allows publishers to access their inventory and run earnings and performance reports.

- [Documentation](http://code.google.com/apis/adsense/management/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/adsense.v2/adsense.v2-library.html)

#### ![Logo](https://www.google.com/images/icons/product/adsense-16.png) AdSense Host API - `adsensehost.v4_1`

Generates performance reports, generates ad codes, and provides publisher management capabilities for AdSense Hosts.

- [Documentation](https://developers.google.com/adsense/host/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/adsensehost.v4_1/adsensehost.v4_1-library.html)

#### ![Logo](https://www.google.com/images/icons/product/analytics-16.png) Google Analytics API - `analytics.v3`

Views and manages your Google Analytics data.

- [Documentation](https://developers.google.com/analytics/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/analytics.v3/analytics.v3-library.html)

#### Analytics Reporting API - `analyticsreporting.v4`

Accesses Analytics report data.

- [Documentation](https://developers.google.com/analytics/devguides/reporting/core/v4/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/analyticsreporting.v4/analyticsreporting.v4-library.html)

#### Android Device Provisioning Partner API - `androiddeviceprovisioning.v1`

Automates Android zero-touch enrollment for device resellers, customers, and EMMs.

- [Documentation](https://developers.google.com/zero-touch/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/androiddeviceprovisioning.v1/androiddeviceprovisioning.v1-library.html)

#### Google Play EMM API - `androidenterprise.v1`

Manages the deployment of apps to Android Enterprise devices.

- [Documentation](https://developers.google.com/android/work/play/emm-api)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/androidenterprise.v1/androidenterprise.v1-library.html)

#### Android Management API - `androidmanagement.v1`

The Android Management API provides remote enterprise management of Android devices and apps.

- [Documentation](https://developers.google.com/android/management)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/androidmanagement.v1/androidmanagement.v1-library.html)

#### Google Play Android Developer API - `androidpublisher.v3`

Lets Android application developers access their Google Play accounts.

- [Documentation](https://developers.google.com/android-publisher)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/androidpublisher.v3/androidpublisher.v3-library.html)

#### API Gateway API - `apigateway.v1`

- [Documentation](https://cloud.google.com/api-gateway/docs)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/apigateway.v1/apigateway.v1-library.html)

#### Apigee API - `apigee.v1`

Use the Apigee API to programmatically develop and manage APIs with a set of RESTful operations. Develop and secure API proxies, deploy and undeploy API proxy revisions, monitor APIs, configure environments, manage users, and more. Note: This product is available as a free trial for a time period of 60 days.

- [Documentation](https://cloud.google.com/apigee-api-management/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/apigee.v1/apigee.v1-library.html)

#### API Keys API - `apikeys.v2`

Manages the API keys associated with developer projects.

- [Documentation](https://cloud.google.com/api-keys/docs)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/apikeys.v2/apikeys.v2-library.html)

#### App Engine Admin API - `appengine.v1`

Provisions and manages developers' App Engine applications.

- [Documentation](https://cloud.google.com/appengine/docs/admin-api/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/appengine.v1/appengine.v1-library.html)

#### Artifact Registry API - `artifactregistry.v1`

Store and manage build artifacts in a scalable and integrated service built on Google infrastructure.

- [Documentation](https://cloud.google.com/artifacts/docs/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/artifactregistry.v1/artifactregistry.v1-library.html)

#### Assured Workloads API - `assuredworkloads.v1`

- [Documentation](https://cloud.google.com)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/assuredworkloads.v1/assuredworkloads.v1-library.html)

#### Bare Metal Solution API - `baremetalsolution.v1`

Bare Metal Solution provides hardware to run specialized workloads with low latency on Google Cloud.

- [Documentation](https://cloud.google.com/bare-metal)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/baremetalsolution.v1/baremetalsolution.v1-library.html)

#### ![Logo](https://www.google.com/images/icons/product/search-16.gif) BigQuery API - `bigquery.v2`

A data platform for customers to create, manage, share and query data.

- [Documentation](https://cloud.google.com/bigquery/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/bigquery.v2/bigquery.v2-library.html)

#### BigQuery Data Transfer API - `bigquerydatatransfer.v1`

Schedule queries or transfer external data from SaaS applications to Google BigQuery on a regular basis.

- [Documentation](https://cloud.google.com/bigquery-transfer/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/bigquerydatatransfer.v1/bigquerydatatransfer.v1-library.html)

#### BigQuery Reservation API - `bigqueryreservation.v1`

A service to modify your BigQuery flat-rate reservations.

- [Documentation](https://cloud.google.com/bigquery/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/bigqueryreservation.v1/bigqueryreservation.v1-library.html)

#### Cloud Bigtable Admin API - `bigtableadmin.v2`

Administer your Cloud Bigtable tables and instances.

- [Documentation](https://cloud.google.com/bigtable/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/bigtableadmin.v2/bigtableadmin.v2-library.html)

#### Cloud Billing Budget API - `billingbudgets.v1`

The Cloud Billing Budget API stores Cloud Billing budgets, which define a budget plan and the rules to execute as spend is tracked against that plan.

- [Documentation](https://cloud.google.com/billing/docs/how-to/budget-api-overview)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/billingbudgets.v1/billingbudgets.v1-library.html)

#### Binary Authorization API - `binaryauthorization.v1`

The management interface for Binary Authorization, a system providing policy control for images deployed to Kubernetes Engine clusters. 

- [Documentation](https://cloud.google.com/binary-authorization/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/binaryauthorization.v1/binaryauthorization.v1-library.html)

#### Blogger API v3 - `blogger.v3`

The Blogger API provides access to posts, comments and pages of a Blogger blog.

- [Documentation](https://developers.google.com/blogger/docs/3.0/getting_started)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/blogger.v3/blogger.v3-library.html)

#### Books API - `books.v1`

The Google Books API allows clients to access the Google Books repository.

- [Documentation](https://code.google.com/apis/books/docs/v1/getting_started.html)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/books.v1/books.v1-library.html)

#### Calendar API - `calendar.v3`

Manipulates events and other calendar data.

- [Documentation](https://developers.google.com/google-apps/calendar/firstapp)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/calendar.v3/calendar.v3-library.html)

#### Google Chat API - `chat.v1`

Enables bots to fetch information and perform actions in Google Chat. Authentication using a service account is a prerequisite for using the Google Chat REST API.

- [Documentation](https://developers.google.com/hangouts/chat)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/chat.v1/chat.v1-library.html)

#### Chrome Management API - `chromemanagement.v1`

The Chrome Management API is a suite of services that allows Chrome administrators to view, manage and gain insights on their Chrome OS and Chrome Browser devices.

- [Documentation](http://developers.google.com/chrome/management/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/chromemanagement.v1/chromemanagement.v1-library.html)

#### Chrome Policy API - `chromepolicy.v1`

The Chrome Policy API is a suite of services that allows Chrome administrators to control the policies applied to their managed Chrome OS devices and Chrome browsers.

- [Documentation](http://developers.google.com/chrome/policy)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/chromepolicy.v1/chromepolicy.v1-library.html)

#### Chrome UX Report API - `chromeuxreport.v1`

The Chrome UX Report API lets you view real user experience data for millions of websites. 

- [Documentation](https://developers.google.com/web/tools/chrome-user-experience-report/api/reference)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/chromeuxreport.v1/chromeuxreport.v1-library.html)

#### Google Civic Information API - `civicinfo.v2`

Provides polling places, early vote locations, contest data, election officials, and government representatives for U.S. residential addresses.

- [Documentation](https://developers.google.com/civic-information/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/civicinfo.v2/civicinfo.v2-library.html)

#### Google Classroom API - `classroom.v1`

Manages classes, rosters, and invitations in Google Classroom.

- [Documentation](https://developers.google.com/classroom/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/classroom.v1/classroom.v1-library.html)

#### Cloud Asset API - `cloudasset.v1`

The cloud asset API manages the history and inventory of cloud resources.

- [Documentation](https://cloud.google.com/asset-inventory/docs/quickstart)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudasset.v1/cloudasset.v1-library.html)

#### Cloud Billing API - `cloudbilling.v1`

Allows developers to manage billing for their Google Cloud Platform projects programmatically.

- [Documentation](https://cloud.google.com/billing/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudbilling.v1/cloudbilling.v1-library.html)

#### Cloud Build API - `cloudbuild.v1`

Creates and manages builds on Google Cloud Platform.

- [Documentation](https://cloud.google.com/cloud-build/docs/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudbuild.v1/cloudbuild.v1-library.html)

#### Cloud Channel API - `cloudchannel.v1`

- [Documentation](https://cloud.google.com/channel)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudchannel.v1/cloudchannel.v1-library.html)

#### Cloud Debugger API - `clouddebugger.v2`

Examines the call stack and variables of a running application without stopping or slowing it down. 

- [Documentation](https://cloud.google.com/debugger)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/clouddebugger.v2/clouddebugger.v2-library.html)

#### Cloud Functions API - `cloudfunctions.v1`

Manages lightweight user-provided functions executed in response to events.

- [Documentation](https://cloud.google.com/functions)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudfunctions.v1/cloudfunctions.v1-library.html)

#### Cloud Identity API - `cloudidentity.v1`

API for provisioning and managing identity resources.

- [Documentation](https://cloud.google.com/identity/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudidentity.v1/cloudidentity.v1-library.html)

#### Cloud IoT API - `cloudiot.v1`

Registers and manages IoT (Internet of Things) devices that connect to the Google Cloud Platform. 

- [Documentation](https://cloud.google.com/iot)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudiot.v1/cloudiot.v1-library.html)

#### Cloud Key Management Service (KMS) API - `cloudkms.v1`

Manages keys and performs cryptographic operations in a central cloud service, for direct use by other cloud resources and applications. 

- [Documentation](https://cloud.google.com/kms/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudkms.v1/cloudkms.v1-library.html)

#### Stackdriver Profiler API - `cloudprofiler.v2`

Manages continuous profiling information.

- [Documentation](https://cloud.google.com/profiler/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudprofiler.v2/cloudprofiler.v2-library.html)

#### Cloud Resource Manager API - `cloudresourcemanager.v1`

Creates, reads, and updates metadata for Google Cloud Platform resource containers.

- [Documentation](https://cloud.google.com/resource-manager)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudresourcemanager.v1/cloudresourcemanager.v1-library.html)

#### Cloud Resource Manager API - `cloudresourcemanager.v2`

Creates, reads, and updates metadata for Google Cloud Platform resource containers.

- [Documentation](https://cloud.google.com/resource-manager)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudresourcemanager.v2/cloudresourcemanager.v2-library.html)

#### Cloud Resource Manager API - `cloudresourcemanager.v3`

Creates, reads, and updates metadata for Google Cloud Platform resource containers.

- [Documentation](https://cloud.google.com/resource-manager)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudresourcemanager.v3/cloudresourcemanager.v3-library.html)

#### Cloud Scheduler API - `cloudscheduler.v1`

Creates and manages jobs run on a regular recurring schedule.

- [Documentation](https://cloud.google.com/scheduler/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudscheduler.v1/cloudscheduler.v1-library.html)

#### Cloud Search API - `cloudsearch.v1`

Cloud Search provides cloud-based search capabilities over G Suite data. The Cloud Search API allows indexing of non-G Suite data into Cloud Search.

- [Documentation](https://developers.google.com/cloud-search/docs/guides/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudsearch.v1/cloudsearch.v1-library.html)

#### Cloud Shell API - `cloudshell.v1`

Allows users to start, configure, and connect to interactive shell sessions running in the cloud. 

- [Documentation](https://cloud.google.com/shell/docs/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudshell.v1/cloudshell.v1-library.html)

#### Cloud Tasks API - `cloudtasks.v2`

Manages the execution of large numbers of distributed requests.

- [Documentation](https://cloud.google.com/tasks/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudtasks.v2/cloudtasks.v2-library.html)

#### Cloud Trace API - `cloudtrace.v2`

Sends application trace data to Cloud Trace for viewing. Trace data is collected for all App Engine applications by default. Trace data from other applications can be provided using this API. This library is used to interact with the Cloud Trace API directly. If you are looking to instrument your application for Cloud Trace, we recommend using OpenCensus. 

- [Documentation](https://cloud.google.com/trace)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/cloudtrace.v2/cloudtrace.v2-library.html)

#### Cloud Composer API - `composer.v1`

Manages Apache Airflow environments on Google Cloud Platform.

- [Documentation](https://cloud.google.com/composer/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/composer.v1/composer.v1-library.html)

#### ![Logo](https://www.google.com/images/icons/product/compute_engine-16.png) Compute Engine API - `compute.v1`

Creates and runs virtual machines on Google Cloud Platform.

- [Documentation](https://developers.google.com/compute/docs/reference/latest/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/compute.v1/compute.v1-library.html)

#### Kubernetes Engine API - `container.v1`

Builds and manages container-based applications, powered by the open source Kubernetes technology.

- [Documentation](https://cloud.google.com/container-engine/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/container.v1/container.v1-library.html)

#### Content API for Shopping - `content.v2_1`

Manage your product listings and accounts for Google Shopping

- [Documentation](https://developers.google.com/shopping-content/v2/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/content.v2_1/content.v2_1-library.html)

#### Custom Search API - `customsearch.v1`

Searches over a website or collection of websites

- [Documentation](https://developers.google.com/custom-search/v1/introduction)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/customsearch.v1/customsearch.v1-library.html)

#### Cloud Data Fusion API - `datafusion.v1`

Cloud Data Fusion is a fully-managed, cloud native, enterprise data integration service for quickly building and managing data pipelines. It provides a graphical interface to increase time efficiency and reduce complexity, and allows business users, developers, and data scientists to easily and reliably build scalable data integration solutions to cleanse, prepare, blend, transfer and transform data without having to wrestle with infrastructure.

- [Documentation](https://cloud.google.com/data-fusion/docs)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/datafusion.v1/datafusion.v1-library.html)

#### Database Migration API - `datamigration.v1`

Manage Cloud Database Migration Service resources on Google Cloud Platform.

- [Documentation](https://cloud.google.com/database-migration/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/datamigration.v1/datamigration.v1-library.html)

#### Cloud Dataproc API - `dataproc.v1`

Manages Hadoop-based clusters and jobs on Google Cloud Platform.

- [Documentation](https://cloud.google.com/dataproc/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/dataproc.v1/dataproc.v1-library.html)

#### Cloud Datastore API - `datastore.v1`

Accesses the schemaless NoSQL database to provide fully managed, robust, scalable storage for your application. 

- [Documentation](https://cloud.google.com/datastore/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/datastore.v1/datastore.v1-library.html)

#### Cloud Deployment Manager V2 API - `deploymentmanager.v2`

The Google Cloud Deployment Manager v2 API provides services for configuring, deploying, and viewing Google Cloud services and APIs via templates which specify deployments of Cloud resources.

- [Documentation](https://cloud.google.com/deployment-manager)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/deploymentmanager.v2/deploymentmanager.v2-library.html)

#### Campaign Manager 360 API - `dfareporting.v3_4`

Build applications to efficiently manage large or complex trafficking, reporting, and attribution workflows for Campaign Manager 360.

- [Documentation](https://developers.google.com/doubleclick-advertisers/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/dfareporting.v3_4/dfareporting.v3_4-library.html)

#### Dialogflow API - `dialogflow.v2`

Builds conversational interfaces (for example, chatbots, and voice-powered apps and devices).

- [Documentation](https://cloud.google.com/dialogflow/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/dialogflow.v2/dialogflow.v2-library.html)

#### Dialogflow API - `dialogflow.v3`

Builds conversational interfaces (for example, chatbots, and voice-powered apps and devices).

- [Documentation](https://cloud.google.com/dialogflow/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/dialogflow.v3/dialogflow.v3-library.html)

#### Digital Asset Links API - `digitalassetlinks.v1`

Discovers relationships between online assets such as websites or mobile apps.

- [Documentation](https://developers.google.com/digital-asset-links/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/digitalassetlinks.v1/digitalassetlinks.v1-library.html)

#### API Discovery Service - `discovery.v1`

Provides information about other Google APIs, such as what APIs are available, the resource, and method details for each API.

- [Documentation](https://developers.google.com/discovery/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/discovery.v1/discovery.v1-library.html)

#### Display & Video 360 API - `displayvideo.v1`

Display & Video 360 API allows users to manage and create campaigns and reports.

- [Documentation](https://developers.google.com/display-video/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/displayvideo.v1/displayvideo.v1-library.html)

#### Cloud Data Loss Prevention (DLP) API - `dlp.v2`

Provides methods for detection, risk analysis, and de-identification of privacy-sensitive fragments in text, images, and Google Cloud Platform storage repositories.

- [Documentation](https://cloud.google.com/dlp/docs/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/dlp.v2/dlp.v2-library.html)

#### Cloud DNS API - `dns.v1`

- [Documentation](https://cloud.google.com/dns/docs)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/dns.v1/dns.v1-library.html)

#### Google Docs API - `docs.v1`

Reads and writes Google Docs documents.

- [Documentation](https://developers.google.com/docs/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/docs.v1/docs.v1-library.html)

#### Cloud Document AI API - `documentai.v1`

Service to parse structured information from unstructured or semi-structured documents using state-of-the-art Google AI such as natural language, computer vision, translation, and AutoML.

- [Documentation](https://cloud.google.com/document-ai/docs/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/documentai.v1/documentai.v1-library.html)

#### Domains RDAP API - `domainsrdap.v1`

Read-only public API that lets users search for information about domain names.

- [Documentation](https://developers.google.com/domains/rdap/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/domainsrdap.v1/domainsrdap.v1-library.html)

#### DoubleClick Bid Manager API - `doubleclickbidmanager.v1_1`

DoubleClick Bid Manager API allows users to manage and create campaigns and reports.

- [Documentation](https://developers.google.com/bid-manager/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/doubleclickbidmanager.v1_1/doubleclickbidmanager.v1_1-library.html)

#### Search Ads 360 API - `doubleclicksearch.v2`

The Search Ads 360 API allows developers to automate uploading conversions and downloading reports from Search Ads 360.

- [Documentation](https://developers.google.com/search-ads)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/doubleclicksearch.v2/doubleclicksearch.v2-library.html)

#### ![Logo](https://ssl.gstatic.com/docs/doclist/images/drive_icon_16.png) Drive API - `drive.v2`

Manages files in Drive including uploading, downloading, searching, detecting changes, and updating sharing permissions.

- [Documentation](https://developers.google.com/drive/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/drive.v2/drive.v2-library.html)

#### ![Logo](https://ssl.gstatic.com/docs/doclist/images/drive_icon_16.png) Drive API - `drive.v3`

Manages files in Drive including uploading, downloading, searching, detecting changes, and updating sharing permissions.

- [Documentation](https://developers.google.com/drive/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/drive.v3/drive.v3-library.html)

#### Drive Activity API - `driveactivity.v2`

Provides a historical view of activity in Google Drive.

- [Documentation](https://developers.google.com/drive/activity/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/driveactivity.v2/driveactivity.v2-library.html)

#### Essential Contacts API - `essentialcontacts.v1`

- [Documentation](https://cloud.google.com/essentialcontacts/docs/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/essentialcontacts.v1/essentialcontacts.v1-library.html)

#### Eventarc API - `eventarc.v1`

- [Documentation](https://cloud.google.com/eventarc)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/eventarc.v1/eventarc.v1-library.html)

#### Firebase Cloud Messaging API - `fcm.v1`

FCM send API that provides a cross-platform messaging solution to reliably deliver messages at no cost.

- [Documentation](https://firebase.google.com/docs/cloud-messaging)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/fcm.v1/fcm.v1-library.html)

#### Cloud Filestore API - `file.v1`

The Cloud Filestore API is used for creating and managing cloud file servers.

- [Documentation](https://cloud.google.com/filestore/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/file.v1/file.v1-library.html)

#### Firebase Dynamic Links API - `firebasedynamiclinks.v1`

Programmatically creates and manages Firebase Dynamic Links.

- [Documentation](https://firebase.google.com/docs/dynamic-links/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/firebasedynamiclinks.v1/firebasedynamiclinks.v1-library.html)

#### Firebase Hosting API - `firebasehosting.v1`

The Firebase Hosting REST API enables programmatic and customizable management and deployments to your Firebase-hosted sites. Use this REST API to create and manage channels and sites as well as to deploy new or updated hosting configurations and content files.

- [Documentation](https://firebase.google.com/docs/hosting/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/firebasehosting.v1/firebasehosting.v1-library.html)

#### Firebase ML API - `firebaseml.v1`

Access custom machine learning models hosted via Firebase ML.

- [Documentation](https://firebase.google.com)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/firebaseml.v1/firebaseml.v1-library.html)

#### Firebase Rules API - `firebaserules.v1`

Creates and manages rules that determine when a Firebase Rules-enabled service should permit a request. 

- [Documentation](https://firebase.google.com/docs/storage/security)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/firebaserules.v1/firebaserules.v1-library.html)

#### Cloud Firestore API - `firestore.v1`

Accesses the NoSQL document database built for automatic scaling, high performance, and ease of application development. 

- [Documentation](https://cloud.google.com/firestore)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/firestore.v1/firestore.v1-library.html)

#### Fitness API - `fitness.v1`

The Fitness API for managing users' fitness tracking data.

- [Documentation](https://developers.google.com/fit/rest/v1/get-started)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/fitness.v1/fitness.v1-library.html)

#### Google Play Game Services - `games.v1`

The Google Play games service allows developers to enhance games with social leaderboards, achievements, game state, sign-in with Google, and more.

- [Documentation](https://developers.google.com/games/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/games.v1/games.v1-library.html)

#### Google Play Game Services Publishing API - `gamesConfiguration.v1configuration`

The Google Play Game Services Publishing API allows developers to configure their games in Game Services.

- [Documentation](https://developers.google.com/games/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/gamesConfiguration.v1configuration/gamesConfiguration.v1configuration-library.html)

#### Google Play Game Management - `gamesManagement.v1management`

The Google Play Game Management API allows developers to manage resources from the Google Play Game service.

- [Documentation](https://developers.google.com/games/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/gamesManagement.v1management/gamesManagement.v1management-library.html)

#### Game Services API - `gameservices.v1`

Deploy and manage infrastructure for global multiplayer gaming experiences.

- [Documentation](https://cloud.google.com/solutions/gaming/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/gameservices.v1/gameservices.v1-library.html)

#### GKE Hub - `gkehub.v1`

- [Documentation](https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/gkehub.v1/gkehub.v1-library.html)

#### Gmail API - `gmail.v1`

The Gmail API lets you view and manage Gmail mailbox data like threads, messages, and labels.

- [Documentation](https://developers.google.com/gmail/api/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/gmail.v1/gmail.v1-library.html)

#### Gmail Postmaster Tools API - `gmailpostmastertools.v1`

The Postmaster Tools API is a RESTful API that provides programmatic access to email traffic metrics (like spam reports, delivery errors etc) otherwise available through the Gmail Postmaster Tools UI currently.

- [Documentation](https://developers.google.com/gmail/postmaster)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/gmailpostmastertools.v1/gmailpostmastertools.v1-library.html)

#### Groups Migration API - `groupsmigration.v1`

The Groups Migration API allows domain administrators to archive emails into Google groups.

- [Documentation](https://developers.google.com/google-apps/groups-migration/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/groupsmigration.v1/groupsmigration.v1-library.html)

#### ![Logo](https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png) Groups Settings API - `groupssettings.v1`

Manages permission levels and related settings of a group.

- [Documentation](https://developers.google.com/google-apps/groups-settings/get_started)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/groupssettings.v1/groupssettings.v1-library.html)

#### Cloud Healthcare API - `healthcare.v1`

Manage, store, and access healthcare data in Google Cloud Platform.

- [Documentation](https://cloud.google.com/healthcare)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/healthcare.v1/healthcare.v1-library.html)

#### HomeGraph API - `homegraph.v1`

- [Documentation](https://developers.google.com/actions/smarthome/create-app#request-sync)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/homegraph.v1/homegraph.v1-library.html)

#### Identity and Access Management (IAM) API - `iam.v1`

Manages identity and access control for Google Cloud Platform resources, including the creation of service accounts, which you can use to authenticate to Google and make API calls. 

- [Documentation](https://cloud.google.com/iam/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/iam.v1/iam.v1-library.html)

#### IAM Service Account Credentials API - `iamcredentials.v1`

Creates short-lived credentials for impersonating IAM service accounts. To enable this API, you must enable the IAM API (iam.googleapis.com). 

- [Documentation](https://cloud.google.com/iam/docs/creating-short-lived-service-account-credentials)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/iamcredentials.v1/iamcredentials.v1-library.html)

#### Cloud Identity-Aware Proxy API - `iap.v1`

Controls access to cloud applications running on Google Cloud Platform.

- [Documentation](https://cloud.google.com/iap)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/iap.v1/iap.v1-library.html)

#### ![Logo](https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png) Google Identity Toolkit API - `identitytoolkit.v3`

Help the third party sites to implement federated login.

- [Documentation](https://developers.google.com/identity-toolkit/v3/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/identitytoolkit.v3/identitytoolkit.v3-library.html)

#### Indexing API - `indexing.v3`

Notifies Google when your web pages change.

- [Documentation](https://developers.google.com/search/apis/indexing-api/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/indexing.v3/indexing.v3-library.html)

#### Cloud Talent Solution API - `jobs.v3`

Cloud Talent Solution provides the capability to create, read, update, and delete job postings, as well as search jobs based on keywords and filters. 

- [Documentation](https://cloud.google.com/talent-solution/job-search/docs/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/jobs.v3/jobs.v3-library.html)

#### Cloud Talent Solution API - `jobs.v4`

Cloud Talent Solution provides the capability to create, read, update, and delete job postings, as well as search jobs based on keywords and filters. 

- [Documentation](https://cloud.google.com/talent-solution/job-search/docs/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/jobs.v4/jobs.v4-library.html)

#### Knowledge Graph Search API - `kgsearch.v1`

Searches the Google Knowledge Graph for entities.

- [Documentation](https://developers.google.com/knowledge-graph/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/kgsearch.v1/kgsearch.v1-library.html)

#### Cloud Natural Language API - `language.v1`

Provides natural language understanding technologies, such as sentiment analysis, entity recognition, entity sentiment analysis, and other text annotations, to developers.

- [Documentation](https://cloud.google.com/natural-language/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/language.v1/language.v1-library.html)

#### Library Agent API - `libraryagent.v1`

A simple Google Example Library API.

- [Documentation](https://cloud.google.com/docs/quota)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/libraryagent.v1/libraryagent.v1-library.html)

#### Enterprise License Manager API - `licensing.v1`

The Google Enterprise License Manager API's allows you to license apps for all the users of a domain managed by you.

- [Documentation](https://developers.google.com/admin-sdk/licensing/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/licensing.v1/licensing.v1-library.html)

#### Local Services API - `localservices.v1`

- [Documentation](https://ads.google.com/local-services-ads/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/localservices.v1/localservices.v1-library.html)

#### Cloud Logging API - `logging.v2`

Writes log entries and manages your Cloud Logging configuration. The table entries below are presented in alphabetical order, not in order of common use. For explanations of the concepts found in the table entries, read the documentation at https://cloud.google.com/logging/docs.

- [Documentation](https://cloud.google.com/logging/docs/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/logging.v2/logging.v2-library.html)

#### Managed Service for Microsoft Active Directory API - `managedidentities.v1`

The Managed Service for Microsoft Active Directory API is used for managing a highly available, hardened service running Microsoft Active Directory (AD).

- [Documentation](https://cloud.google.com/managed-microsoft-ad/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/managedidentities.v1/managedidentities.v1-library.html)

#### Manufacturer Center API - `manufacturers.v1`

Public API for managing Manufacturer Center related data.

- [Documentation](https://developers.google.com/manufacturers/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/manufacturers.v1/manufacturers.v1-library.html)

#### Cloud Memorystore for Memcached API - `memcache.v1`

Google Cloud Memorystore for Memcached API is used for creating and managing Memcached instances in GCP.

- [Documentation](https://cloud.google.com/memorystore/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/memcache.v1/memcache.v1-library.html)

#### AI Platform Training & Prediction API - `ml.v1`

An API to enable creating and using machine learning models.

- [Documentation](https://cloud.google.com/ml/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/ml.v1/ml.v1-library.html)

#### Cloud Monitoring API - `monitoring.v3`

Manages your Cloud Monitoring data and configurations. Most projects must be associated with a Workspace, with a few exceptions as noted on the individual method pages. The table entries below are presented in alphabetical order, not in order of common use. For explanations of the concepts found in the table entries, read the Cloud Monitoring documentation.

- [Documentation](https://cloud.google.com/monitoring/api/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/monitoring.v3/monitoring.v3-library.html)

#### My Business Account Management API - `mybusinessaccountmanagement.v1`

The My Business Account Management API provides an interface for managing access to a location on Google.

- [Documentation](https://developers.google.com/my-business/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/mybusinessaccountmanagement.v1/mybusinessaccountmanagement.v1-library.html)

#### My Business Lodging API - `mybusinesslodging.v1`

The My Business Lodging API enables managing lodging business information on Google.

- [Documentation](https://developers.google.com/my-business/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/mybusinesslodging.v1/mybusinesslodging.v1-library.html)

#### My Business Place Actions API - `mybusinessplaceactions.v1`

The My Business Place Actions API provides an interface for managing place action links of a location on Google.

- [Documentation](https://developers.google.com/my-business/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/mybusinessplaceactions.v1/mybusinessplaceactions.v1-library.html)

#### Network Management API - `networkmanagement.v1`

The Network Management API provides a collection of network performance monitoring and diagnostic capabilities.

- [Documentation](https://cloud.google.com/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/networkmanagement.v1/networkmanagement.v1-library.html)

#### Notebooks API - `notebooks.v1`

AI Platform Notebooks API is used to manage notebook resources in Google Cloud.

- [Documentation](https://cloud.google.com/ai-platform/notebooks/docs/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/notebooks.v1/notebooks.v1-library.html)

#### ![Logo](https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png) Google OAuth2 API - `oauth2.v2`

Obtains end-user authorization grants for use with other Google APIs.

- [Documentation](https://developers.google.com/identity/protocols/oauth2/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/oauth2.v2/oauth2.v2-library.html)

#### On-Demand Scanning API - `ondemandscanning.v1`

A service to scan container images for vulnerabilities.

- [Documentation](https://cloud.google.com/container-analysis/docs/on-demand-scanning/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/ondemandscanning.v1/ondemandscanning.v1-library.html)

#### Organization Policy API - `orgpolicy.v2`

The Org Policy API allows users to configure governance ruleson their GCP resources across the Cloud Resource Hierarchy.

- [Documentation](https://cloud.google.com/orgpolicy/docs/reference/rest/index.html)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/orgpolicy.v2/orgpolicy.v2-library.html)

#### OS Config API - `osconfig.v1`

OS management tools that can be used for patch management, patch compliance, and configuration management on VM instances.

- [Documentation](https://cloud.google.com/compute/docs/osconfig/rest)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/osconfig.v1/osconfig.v1-library.html)

#### Cloud OS Login API - `oslogin.v1`

You can use OS Login to manage access to your VM instances using IAM roles.

- [Documentation](https://cloud.google.com/compute/docs/oslogin/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/oslogin.v1/oslogin.v1-library.html)

#### PageSpeed Insights API - `pagespeedonline.v5`

The PageSpeed Insights API lets you analyze the performance of your website with a simple API. It offers tailored suggestions for how you can optimize your site, and lets you easily integrate PageSpeed Insights analysis into your development tools and workflow. 

- [Documentation](https://developers.google.com/speed/docs/insights/v5/about)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/pagespeedonline.v5/pagespeedonline.v5-library.html)

#### People API - `people.v1`

Provides access to information about profiles and contacts.

- [Documentation](https://developers.google.com/people/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/people.v1/people.v1-library.html)

#### Playable Locations API - `playablelocations.v3`

- [Documentation](https://developers.google.com/maps/contact-sales/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/playablelocations.v3/playablelocations.v3-library.html)

#### Google Play Custom App Publishing API - `playcustomapp.v1`

API to create and publish custom Android apps

- [Documentation](https://developers.google.com/android/work/play/custom-app-api/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/playcustomapp.v1/playcustomapp.v1-library.html)

#### Policy Simulator API - `policysimulator.v1`

 Policy Simulator is a collection of endpoints for creating, running, and viewing a Replay. A `Replay` is a type of simulation that lets you see how your members' access to resources might change if you changed your IAM policy. During a `Replay`, Policy Simulator re-evaluates, or replays, past access attempts under both the current policy and your proposed policy, and compares those results to determine how your members' access might change under the proposed policy.

- [Documentation](https://cloud.google.com/iam/docs/simulating-access)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/policysimulator.v1/policysimulator.v1-library.html)

#### Policy Troubleshooter API - `policytroubleshooter.v1`

- [Documentation](https://cloud.google.com/iam/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/policytroubleshooter.v1/policytroubleshooter.v1-library.html)

#### Poly API - `poly.v1`

The Poly API provides read access to assets hosted on poly.google.com to all, and upload access to poly.google.com for whitelisted accounts. 

- [Documentation](https://developers.google.com/poly/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/poly.v1/poly.v1-library.html)

#### Cloud Pub/Sub API - `pubsub.v1`

Provides reliable, many-to-many, asynchronous messaging between applications. 

- [Documentation](https://cloud.google.com/pubsub/docs)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/pubsub.v1/pubsub.v1-library.html)

#### Pub/Sub Lite API - `pubsublite.v1`

- [Documentation](https://cloud.google.com/pubsub/lite/docs)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/pubsublite.v1/pubsublite.v1-library.html)

#### Real-time Bidding API - `realtimebidding.v1`

Allows external bidders to manage their RTB integration with Google. This includes managing bidder endpoints, QPS quotas, configuring what ad inventory to receive via pretargeting, submitting creatives for verification, and accessing creative metadata such as approval status.

- [Documentation](https://developers.google.com/authorized-buyers/apis/realtimebidding/reference/rest/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/realtimebidding.v1/realtimebidding.v1-library.html)

#### reCAPTCHA Enterprise API - `recaptchaenterprise.v1`

- [Documentation](https://cloud.google.com/recaptcha-enterprise/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/recaptchaenterprise.v1/recaptchaenterprise.v1-library.html)

#### Recommender API - `recommender.v1`

- [Documentation](https://cloud.google.com/recommender/docs/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/recommender.v1/recommender.v1-library.html)

#### Google Cloud Memorystore for Redis API - `redis.v1`

Creates and manages Redis instances on the Google Cloud Platform.

- [Documentation](https://cloud.google.com/memorystore/docs/redis/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/redis.v1/redis.v1-library.html)

#### Google Workspace Reseller API - `reseller.v1`

Perform common functions that are available on the Channel Services console at scale, like placing orders and viewing customer information

- [Documentation](https://developers.google.com/google-apps/reseller/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/reseller.v1/reseller.v1-library.html)

#### Retail API - `retail.v2`

Cloud Retail service enables customers to build end-to-end personalized recommendation systems without requiring a high level of expertise in machine learning, recommendation system, or Google Cloud.

- [Documentation](https://cloud.google.com/recommendations)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/retail.v2/retail.v2-library.html)

#### Cloud Run Admin API - `run.v1`

Deploy and manage user provided container images that scale automatically based on HTTP traffic.

- [Documentation](https://cloud.google.com/run/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/run.v1/run.v1-library.html)

#### Cloud Runtime Configuration API - `runtimeconfig.v1`

The Runtime Configurator allows you to dynamically configure and expose variables through Google Cloud Platform. In addition, you can also set Watchers and Waiters that will watch for changes to your data and return based on certain conditions.

- [Documentation](https://cloud.google.com/deployment-manager/runtime-configurator/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/runtimeconfig.v1/runtimeconfig.v1-library.html)

#### Safe Browsing API - `safebrowsing.v4`

Enables client applications to check web resources (most commonly URLs) against Google-generated lists of unsafe web resources. The Safe Browsing APIs are for non-commercial use only. If you need to use APIs to detect malicious URLs for commercial purposes – meaning “for sale or revenue-generating purposes” – please refer to the Web Risk API.

- [Documentation](https://developers.google.com/safe-browsing/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/safebrowsing.v4/safebrowsing.v4-library.html)

#### Apps Script API - `script.v1`

Manages and executes Google Apps Script projects. 

- [Documentation](https://developers.google.com/apps-script/api/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/script.v1/script.v1-library.html)

#### Google Search Console API - `searchconsole.v1`

The Search Console API provides access to both Search Console data (verified users only) and to public information on an URL basis (anyone)

- [Documentation](https://developers.google.com/webmaster-tools/search-console-api/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/searchconsole.v1/searchconsole.v1-library.html)

#### Secret Manager API - `secretmanager.v1`

Stores sensitive data such as API keys, passwords, and certificates. Provides convenience while improving security. 

- [Documentation](https://cloud.google.com/secret-manager/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/secretmanager.v1/secretmanager.v1-library.html)

#### Security Command Center API - `securitycenter.v1`

Security Command Center API provides access to temporal views of assets and findings within an organization.

- [Documentation](https://cloud.google.com/security-command-center)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/securitycenter.v1/securitycenter.v1-library.html)

#### Service Consumer Management API - `serviceconsumermanagement.v1`

Manages the service consumers of a Service Infrastructure service.

- [Documentation](https://cloud.google.com/service-consumer-management/docs/overview)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/serviceconsumermanagement.v1/serviceconsumermanagement.v1-library.html)

#### Service Control API - `servicecontrol.v1`

Provides admission control and telemetry reporting for services integrated with Service Infrastructure. 

- [Documentation](https://cloud.google.com/service-control/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/servicecontrol.v1/servicecontrol.v1-library.html)

#### Service Control API - `servicecontrol.v2`

Provides admission control and telemetry reporting for services integrated with Service Infrastructure. 

- [Documentation](https://cloud.google.com/service-control/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/servicecontrol.v2/servicecontrol.v2-library.html)

#### Service Directory API - `servicedirectory.v1`

Service Directory is a platform for discovering, publishing, and connecting services. 

- [Documentation](https://cloud.google.com/service-directory)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/servicedirectory.v1/servicedirectory.v1-library.html)

#### Service Management API - `servicemanagement.v1`

Google Service Management allows service producers to publish their services on Google Cloud Platform so that they can be discovered and used by service consumers.

- [Documentation](https://cloud.google.com/service-management/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/servicemanagement.v1/servicemanagement.v1-library.html)

#### Service Networking API - `servicenetworking.v1`

Provides automatic management of network configurations necessary for certain services.

- [Documentation](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/servicenetworking.v1/servicenetworking.v1-library.html)

#### Service Usage API - `serviceusage.v1`

Enables services that service consumers want to use on Google Cloud Platform, lists the available or enabled services, or disables services that service consumers no longer use.

- [Documentation](https://cloud.google.com/service-usage/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/serviceusage.v1/serviceusage.v1-library.html)

#### Google Sheets API - `sheets.v4`

Reads and writes Google Sheets.

- [Documentation](https://developers.google.com/sheets/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/sheets.v4/sheets.v4-library.html)

#### ![Logo](https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png) Google Site Verification API - `siteVerification.v1`

Verifies ownership of websites or domains with Google.

- [Documentation](https://developers.google.com/site-verification/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/siteVerification.v1/siteVerification.v1-library.html)

#### Google Slides API - `slides.v1`

Reads and writes Google Slides presentations.

- [Documentation](https://developers.google.com/slides/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/slides.v1/slides.v1-library.html)

#### Smart Device Management API - `smartdevicemanagement.v1`

Allow select enterprise partners to access, control, and manage Google and Nest devices programmatically.

- [Documentation](https://developers.google.com/nest/device-access)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/smartdevicemanagement.v1/smartdevicemanagement.v1-library.html)

#### Cloud Source Repositories API - `sourcerepo.v1`

Accesses source code repositories hosted by Google.

- [Documentation](https://cloud.google.com/source-repositories/docs/apis)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/sourcerepo.v1/sourcerepo.v1-library.html)

#### Cloud Spanner API - `spanner.v1`

Cloud Spanner is a managed, mission-critical, globally consistent and scalable relational database service.

- [Documentation](https://cloud.google.com/spanner/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/spanner.v1/spanner.v1-library.html)

#### Cloud Speech-to-Text API - `speech.v1`

Converts audio to text by applying powerful neural network models.

- [Documentation](https://cloud.google.com/speech-to-text/docs/quickstart-protocol)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/speech.v1/speech.v1-library.html)

#### ![Logo](https://www.google.com/images/icons/product/cloud_storage-16.png) Cloud Storage JSON API - `storage.v1`

Stores and retrieves potentially large, immutable data objects.

- [Documentation](https://developers.google.com/storage/docs/json_api/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/storage.v1/storage.v1-library.html)

#### Storage Transfer API - `storagetransfer.v1`

Transfers data from external data sources to a Google Cloud Storage bucket or between Google Cloud Storage buckets.

- [Documentation](https://cloud.google.com/storage-transfer/docs)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/storagetransfer.v1/storagetransfer.v1-library.html)

#### Street View Publish API - `streetviewpublish.v1`

Publishes 360 photos to Google Maps, along with position, orientation, and connectivity metadata. Apps can offer an interface for positioning, connecting, and uploading user-generated Street View images. 

- [Documentation](https://developers.google.com/streetview/publish/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/streetviewpublish.v1/streetviewpublish.v1-library.html)

#### Security Token Service API - `sts.v1`

The Security Token Service exchanges Google or third-party credentials for a short-lived access token to Google Cloud resources.

- [Documentation](http://cloud.google.com/iam/docs/workload-identity-federation)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/sts.v1/sts.v1-library.html)

#### Tag Manager API - `tagmanager.v1`

This API allows clients to access and modify container and tag configuration.

- [Documentation](https://developers.google.com/tag-manager)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/tagmanager.v1/tagmanager.v1-library.html)

#### Tag Manager API - `tagmanager.v2`

This API allows clients to access and modify container and tag configuration.

- [Documentation](https://developers.google.com/tag-manager)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/tagmanager.v2/tagmanager.v2-library.html)

#### Tasks API - `tasks.v1`

The Google Tasks API lets you manage your tasks and task lists.

- [Documentation]()
- [API details](https://pub.dev/documentation/googleapis/3.0.0/tasks.v1/tasks.v1-library.html)

#### Cloud Testing API - `testing.v1`

Allows developers to run automated tests for their mobile applications on Google infrastructure.

- [Documentation](https://developers.google.com/cloud-test-lab/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/testing.v1/testing.v1-library.html)

#### Cloud Text-to-Speech API - `texttospeech.v1`

Synthesizes natural-sounding speech by applying powerful neural network models.

- [Documentation](https://cloud.google.com/text-to-speech/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/texttospeech.v1/texttospeech.v1-library.html)

#### Cloud TPU API - `tpu.v1`

TPU API provides customers with access to Google TPU technology.

- [Documentation](https://cloud.google.com/tpu/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/tpu.v1/tpu.v1-library.html)

#### Traffic Director API - `trafficdirector.v2`

- [Documentation](https://cloud.google.com/traffic-director)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/trafficdirector.v2/trafficdirector.v2-library.html)

#### Cloud Translation API - `translate.v3`

Integrates text translation into your website or application.

- [Documentation](https://cloud.google.com/translate/docs/quickstarts)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/translate.v3/translate.v3-library.html)

#### G Suite Vault API - `vault.v1`

Retention and eDiscovery for Google Workspace. To work with Vault resources, the account must have the [required Vault privileges] (https://support.google.com/vault/answer/2799699) and access to the matter. To access a matter, the account must have created the matter, have the matter shared with them, or have the **View All Matters** privilege. For example, to download an export, an account needs the **Manage Exports** privilege and the matter shared with them. 

- [Documentation](https://developers.google.com/vault)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/vault.v1/vault.v1-library.html)

#### Semantic Tile API - `vectortile.v1`

Serves vector tiles containing geospatial data. 

- [Documentation](https://developers.google.com/maps/contact-sales/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/vectortile.v1/vectortile.v1-library.html)

#### Chrome Verified Access API - `verifiedaccess.v1`

API for Verified Access chrome extension to provide credential verification for chrome devices connecting to an enterprise network

- [Documentation](https://developers.google.com/chrome/verified-access)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/verifiedaccess.v1/verifiedaccess.v1-library.html)

#### Cloud Video Intelligence API - `videointelligence.v1`

Detects objects, explicit content, and scene changes in videos. It also specifies the region for annotation and transcribes speech to text. Supports both asynchronous API and streaming API.

- [Documentation](https://cloud.google.com/video-intelligence/docs/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/videointelligence.v1/videointelligence.v1-library.html)

#### Cloud Vision API - `vision.v1`

Integrates Google Vision features, including image labeling, face, logo, and landmark detection, optical character recognition (OCR), and detection of explicit content, into applications.

- [Documentation](https://cloud.google.com/vision/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/vision.v1/vision.v1-library.html)

#### Web Fonts Developer API - `webfonts.v1`

The Google Web Fonts Developer API lets you retrieve information about web fonts served by Google.

- [Documentation](https://developers.google.com/fonts/docs/developer_api)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/webfonts.v1/webfonts.v1-library.html)

#### ![Logo](https://www.google.com/images/icons/product/webmaster_tools-16.png) Search Console API - `webmasters.v3`

View Google Search Console data for your verified sites.

- [Documentation](https://developers.google.com/webmaster-tools/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/webmasters.v3/webmasters.v3-library.html)

#### Web Risk API - `webrisk.v1`

- [Documentation](https://cloud.google.com/web-risk/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/webrisk.v1/webrisk.v1-library.html)

#### Web Security Scanner API - `websecurityscanner.v1`

Scans your Compute and App Engine apps for common web vulnerabilities.

- [Documentation](https://cloud.google.com/security-command-center/docs/concepts-web-security-scanner-overview/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/websecurityscanner.v1/websecurityscanner.v1-library.html)

#### Workflow Executions API - `workflowexecutions.v1`

Execute workflows created with Workflows API.

- [Documentation](https://cloud.google.com/workflows)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/workflowexecutions.v1/workflowexecutions.v1-library.html)

#### Workflows API - `workflows.v1`

Manage workflow definitions. To execute workflows and manage executions, see the Workflows Executions API.

- [Documentation](https://cloud.google.com/workflows)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/workflows.v1/workflows.v1-library.html)

#### YouTube Data API v3 - `youtube.v3`

The YouTube Data API v3 is an API that provides access to YouTube data, such as videos, playlists, and channels.

- [Documentation](https://developers.google.com/youtube/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/youtube.v3/youtube.v3-library.html)

#### YouTube Analytics API - `youtubeAnalytics.v2`

Retrieves your YouTube Analytics data.

- [Documentation](https://developers.google.com/youtube/analytics)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/youtubeAnalytics.v2/youtubeAnalytics.v2-library.html)

#### YouTube Reporting API - `youtubereporting.v1`

Schedules reporting jobs containing your YouTube Analytics data and downloads the resulting bulk data reports in the form of CSV files.

- [Documentation](https://developers.google.com/youtube/reporting/v1/reports/)
- [API details](https://pub.dev/documentation/googleapis/3.0.0/youtubereporting.v1/youtubereporting.v1-library.html)

