/* SPDX-License-Identifier: GPL-2.0 */
/*
 * OmniVision OV1063X Camera Driver
 *
 * Copyright (C) 2018 Texas Instruments Incorporated -  http://www.ti.com/
 */

struct ov1063x_reg {
	u16	reg;
	u8	val;
};

static const struct ov1063x_reg ov1063x_regs_default[] = {
	/* Register configuration for full resolution : 1280x720 */
		{0x103, 0x1},	 /** Software Reset */
		{0x301b, 0xff},  /** System Control Clock Reset #1 */
		{0x301c, 0xff},  /** System Control Clock Reset #2 */
		{0x301a, 0xff},  /** System Control Clock Reset #0 */
		{0x300c, 0x61},  /** Serial Camera Control Bus ID */
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x300c, 0x61},
		{0x3021, 0x3},  /** System Control Misc */
		{0x3011, 0x2},
		{0x6900, 0xc},
		{0x6901, 0x1},
		{0x3033, 0x8},  /** System clock/4 */
		{0x3503, 0x10}, /** AEC Delay enabled */
		{0x302d, 0x2f}, /** Power Down Control */
		{0x3025, 0x3},  /** Debug Control enabled */
		/*
		 * FPS is computed as:
		 * XVCLK	   = 9MHz
		 * preDivide   = {/1,/1.5,/2,/3,/4,/5,/6,/7}
		 * decided based on (0x3004[6:4].
		 * numerator   = (0x3003[5:0] * XVCLK)/preDivide)
		 * denominator = (2 * (1+0x3004[2:0]))
		 * FPS = numerator/denominator.
		 */
		/* {0x3003, 0x1B}, */ /* fps = 30fps. */
		/* {0x3004, 0x03}, */
		{0x3003, 0x20}, /* fps = 15fps. */
		{0x3004, 0x3},
		{0x3005, 0x20},
		{0x3006, 0x91},
		{0x3600, 0x74},
		{0x3601, 0x2b},
		{0x3612, 0x0},
		{0x3611, 0x67},
		{0x3633, 0xba},
		{0x3602, 0x2f},
		{0x3603, 0x0},
		{0x3630, 0xa8},
		{0x3631, 0x16},
		{0x3714, 0x10},
		{0x371d, 0x1},
		{0x4300, 0x3A}, /* UYVY mode */
		{0x3007, 0x1},
		/*
		 * RAW mode and Pixel CLK selct.
		 * 0x3024[0] = 1 :: System CLK (0x3003,0x3004)
		 * 0x3024[0] = 0 :: secondary CLK (0x3005,0x3006)
		 */
		{0x3024, 0x1},
		{0x3020, 0xb},
		{0x3702, 0xd},
		{0x3703, 0x20},
		{0x3704, 0x15},
		{0x3709, 0x28},
		{0x370d, 0x0},
		{0x3712, 0x0},
		{0x3713, 0x20},
		{0x3715, 0x4},
		{0x381d, 0x40},
		{0x381c, 0x0},
		{0x3824, 0x10},
		{0x3815, 0x8c},
		{0x3804, 0x5},
		{0x3805, 0x1f},
		{0x3800, 0x0},
		{0x3801, 0x0},
		{0x3806, 0x3},
		{0x3807, 0x1},
		{0x3802, 0x0},
		{0x3803, 0x2e},
		{0x3808, 0x5},
		{0x3809, 0x0},
		{0x380a, 0x2},
		{0x380b, 0xd0},
		{0x380c, 0x6},
		{0x380d, 0xf6}, /* 1280x720 */
		{0x380e, 0x2},
		{0x380f, 0xec}, /* 1280x720 */
		{0x3811, 0x8},
		{0x381f, 0xc},
		{0x3621, 0x63},
		{0x5005, 0x8},
		{0x56d5, 0x0},
		{0x56d6, 0x80},
		{0x56d7, 0x0},
		{0x56d8, 0x0},
		{0x56d9, 0x0},
		{0x56da, 0x80},
		{0x56db, 0x0},
		{0x56dc, 0x0},
		{0x56e8, 0x0},
		{0x56e9, 0x7f},
		{0x56ea, 0x0},
		{0x56eb, 0x7f},
		{0x5100, 0x0},
		{0x5101, 0x80},
		{0x5102, 0x0},
		{0x5103, 0x80},
		{0x5104, 0x0},
		{0x5105, 0x80},
		{0x5106, 0x0},
		{0x5107, 0x80},
		{0x5108, 0x0},
		{0x5109, 0x0},
		{0x510a, 0x0},
		{0x510b, 0x0},
		{0x510c, 0x0},
		{0x510d, 0x0},
		{0x510e, 0x0},
		{0x510f, 0x0},
		{0x5110, 0x0},
		{0x5111, 0x80},
		{0x5112, 0x0},
		{0x5113, 0x80},
		{0x5114, 0x0},
		{0x5115, 0x80},
		{0x5116, 0x0},
		{0x5117, 0x80},
		{0x5118, 0x0},
		{0x5119, 0x0},
		{0x511a, 0x0},
		{0x511b, 0x0},
		{0x511c, 0x0},
		{0x511d, 0x0},
		{0x511e, 0x0},
		{0x511f, 0x0},
		{0x56d0, 0x0},
		{0x5006, 0x24},
		{0x5608, 0x0},
		{0x52d7, 0x6},
		{0x528d, 0x8},
		{0x5293, 0x12},
		{0x52d3, 0x12},
		{0x5288, 0x6},
		{0x5289, 0x20},
		{0x52c8, 0x6},
		{0x52c9, 0x20},
		{0x52cd, 0x4},
		{0x5381, 0x0},
		{0x5382, 0xff},
		{0x5589, 0x76},
		{0x558a, 0x47},
		{0x558b, 0xef},
		{0x558c, 0xc9},
		{0x558d, 0x49},
		{0x558e, 0x30},
		{0x558f, 0x67},
		{0x5590, 0x3f},
		{0x5591, 0xf0},
		{0x5592, 0x10},
		{0x55a2, 0x6d},
		{0x55a3, 0x55},
		{0x55a4, 0xc3},
		{0x55a5, 0xb5},
		{0x55a6, 0x43},
		{0x55a7, 0x38},
		{0x55a8, 0x5f},
		{0x55a9, 0x4b},
		{0x55aa, 0xf0},
		{0x55ab, 0x10},
		{0x5581, 0x52},
		{0x5300, 0x1},
		{0x5301, 0x0},
		{0x5302, 0x0},
		{0x5303, 0xe},
		{0x5304, 0x0},
		{0x5305, 0xe},
		{0x5306, 0x0},
		{0x5307, 0x36},
		{0x5308, 0x0},
		{0x5309, 0xd9},
		{0x530a, 0x0},
		{0x530b, 0xf},
		{0x530c, 0x0},
		{0x530d, 0x2c},
		{0x530e, 0x0},
		{0x530f, 0x59},
		{0x5310, 0x0},
		{0x5311, 0x7b},
		{0x5312, 0x0},
		{0x5313, 0x22},
		{0x5314, 0x0},
		{0x5315, 0xd5},
		{0x5316, 0x0},
		{0x5317, 0x13},
		{0x5318, 0x0},
		{0x5319, 0x18},
		{0x531a, 0x0},
		{0x531b, 0x26},
		{0x531c, 0x0},
		{0x531d, 0xdc},
		{0x531e, 0x0},
		{0x531f, 0x2},
		{0x5320, 0x0},
		{0x5321, 0x24},
		{0x5322, 0x0},
		{0x5323, 0x56},
		{0x5324, 0x0},
		{0x5325, 0x85},
		{0x5326, 0x0},
		{0x5327, 0x20},
		{0x5609, 0x1},
		{0x560a, 0x40},
		{0x560b, 0x1},
		{0x560c, 0x40},
		{0x560d, 0x0},
		{0x560e, 0xfa},
		{0x560f, 0x0},
		{0x5610, 0xfa},
		{0x5611, 0x2},
		{0x5612, 0x80},
		{0x5613, 0x2},
		{0x5614, 0x80},
		{0x5615, 0x1},
		{0x5616, 0x2c},
		{0x5617, 0x1},
		{0x5618, 0x2c},
		{0x563b, 0x1},
		{0x563c, 0x1},
		{0x563d, 0x1},
		{0x563e, 0x1},
		{0x563f, 0x3},
		{0x5640, 0x3},
		{0x5641, 0x3},
		{0x5642, 0x5},
		{0x5643, 0x9},
		{0x5644, 0x5},
		{0x5645, 0x5},
		{0x5646, 0x5},
		{0x5647, 0x5},
		{0x5651, 0x0},
		{0x5652, 0x80},
		{0x521a, 0x1},
		{0x521b, 0x3},
		{0x521c, 0x6},
		{0x521d, 0xa},
		{0x521e, 0xe},
		{0x521f, 0x12},
		{0x5220, 0x16},
		{0x5223, 0x2},
		{0x5225, 0x4},
		{0x5227, 0x8},
		{0x5229, 0xc},
		{0x522b, 0x12},
		{0x522d, 0x18},
		{0x522f, 0x1e},
		{0x5241, 0x4},
		{0x5242, 0x1},
		{0x5243, 0x3},
		{0x5244, 0x6},
		{0x5245, 0xa},
		{0x5246, 0xe},
		{0x5247, 0x12},
		{0x5248, 0x16},
		{0x524a, 0x3},
		{0x524c, 0x4},
		{0x524e, 0x8},
		{0x5250, 0xc},
		{0x5252, 0x12},
		{0x5254, 0x18},
		{0x5256, 0x1e},
		{0x4605, 0x00}, /* 8-bit YUV mode. */
		{0x4606, 0x7},
		{0x4607, 0x71},
		{0x460a, 0x2},
		{0x460b, 0x70},
		{0x460c, 0x0},
		{0x4620, 0xe},
		{0x4700, 0x4},
		{0x4701, 0x01},
		/* {0x4702, 0x1}, */
		{0x4702, 0x00},  /* 01 */
		{0x4703, 0x00},
		{0x4704, 0x00}, /* 01 */
		/*
		 * Non-overlapping HSYNC-VSYNC.
		 * Therefore do not set the VSYNC delay registers.
		 */
		{0x4705, 0x00}, /* Vsync delay high byte */
		{0x4706, 0x00}, /* Vsync delay middle byte */
		{0x4707, 0x00}, /* Vsync delay low byte{0x4708, 0x1}, */
		/* {0x4709, 0x50}, */
		{0x4004, 0x8},
		{0x4005, 0x18},
		{0x4001, 0x4},
		{0x4050, 0x20},
		{0x4051, 0x22},
		{0x4057, 0x9c},
		{0x405a, 0x0},
		{0x4202, 0x2},
		{0x3023, 0x10},
		{0x100, 0x1},
		{0x100, 0x1},
		{0x6f0e, 0x0},
		{0x6f0f, 0x0},
		{0x460e, 0x8},
		{0x460f, 0x1},
		{0x4610, 0x0},
		{0x4611, 0x1},
		{0x4612, 0x0},
		{0x4613, 0x1},
		{0x4605, 0x00},
		{0x4608, 0x0},
		{0x4609, 0x8},
		{0x6804, 0x0},
		{0x6805, 0x6},
		{0x6806, 0x0},
		{0x5120, 0x0},
		{0x3510, 0x0},
		{0x3504, 0x0},
		{0x6800, 0x0},
		{0x6f0d, 0x0},
		{0x5000, 0xff},
		{0x5001, 0xbf},
		{0x5002, 0xfe},
		{0x503d, 0x0},
		/* {0x503e, 0x00}, */
		{0xc450, 0x1},
		{0xc452, 0x4},
		{0xc453, 0x0},
		{0xc454, 0x0},
		{0xc455, 0x0},
		{0xc456, 0x0},
		{0xc457, 0x0},
		{0xc458, 0x0},
		{0xc459, 0x0},
		{0xc45b, 0x0},
		{0xc45c, 0x0},
		{0xc45d, 0x0},
		{0xc45e, 0x0},
		{0xc45f, 0x0},
		{0xc460, 0x0},
		{0xc461, 0x1},
		{0xc462, 0x1},
		{0xc464, 0x88},
		{0xc465, 0x0},
		{0xc466, 0x8a},
		{0xc467, 0x0},
		{0xc468, 0x86},
		{0xc469, 0x0},
		{0xc46a, 0x40},
		{0xc46b, 0x50},
		{0xc46c, 0x30},
		{0xc46d, 0x28},
		{0xc46e, 0x60},
		{0xc46f, 0x40},
		{0xc47c, 0x1},
		{0xc47d, 0x38},
		{0xc47e, 0x0},
		{0xc47f, 0x0},
		{0xc480, 0x0},
		{0xc481, 0xff},
		{0xc482, 0x0},
		{0xc483, 0x40},
		{0xc484, 0x0},
		{0xc485, 0x18},
		{0xc486, 0x0},
		{0xc487, 0x18},
		{0xc488, 0x2e},
		{0xc489, 0x80},
		{0xc48a, 0x2e},
		{0xc48b, 0x80},
		{0xc48c, 0x0},
		{0xc48d, 0x4},
		{0xc48e, 0x0},
		{0xc48f, 0x4},
		{0xc490, 0x7},
		{0xc492, 0x20},
		{0xc493, 0x8},
		{0xc498, 0x2},
		{0xc499, 0x0},
		{0xc49a, 0x2},
		{0xc49b, 0x0},
		{0xc49c, 0x2},
		{0xc49d, 0x0},
		{0xc49e, 0x2},
		{0xc49f, 0x60},
		{0xc4a0, 0x4},
		{0xc4a1, 0x0},
		{0xc4a2, 0x6},
		{0xc4a3, 0x0},
		{0xc4a4, 0x0},
		{0xc4a5, 0x10},
		{0xc4a6, 0x0},
		{0xc4a7, 0x40},
		{0xc4a8, 0x0},
		{0xc4a9, 0x80},
		{0xc4aa, 0xd},
		{0xc4ab, 0x0},
		{0xc4ac, 0xf},
		{0xc4ad, 0xc0},
		{0xc4b4, 0x1},
		{0xc4b5, 0x1},
		{0xc4b6, 0x0},
		{0xc4b7, 0x1},
		{0xc4b8, 0x0},
		{0xc4b9, 0x1},
		{0xc4ba, 0x1},
		{0xc4bb, 0x0},
		{0xc4be, 0x2},
		{0xc4bf, 0x33},
		{0xc4c8, 0x3},
		{0xc4c9, 0xd0},
		{0xc4ca, 0xe},
		{0xc4cb, 0x0},
		{0xc4cc, 0xe},
		{0xc4cd, 0x51},
		{0xc4ce, 0xe},
		{0xc4cf, 0x51},
		{0xc4d0, 0x4},
		{0xc4d1, 0x80},
		{0xc4e0, 0x4},
		{0xc4e1, 0x2},
		{0xc4e2, 0x1},
		{0xc4e4, 0x10},
		{0xc4e5, 0x20},
		{0xc4e6, 0x30},
		{0xc4e7, 0x40},
		{0xc4e8, 0x50},
		{0xc4e9, 0x60},
		{0xc4ea, 0x70},
		{0xc4eb, 0x80},
		{0xc4ec, 0x90},
		{0xc4ed, 0xa0},
		{0xc4ee, 0xb0},
		{0xc4ef, 0xc0},
		{0xc4f0, 0xd0},
		{0xc4f1, 0xe0},
		{0xc4f2, 0xf0},
		{0xc4f3, 0x80},
		{0xc4f4, 0x0},
		{0xc4f5, 0x20},
		{0xc4f6, 0x2},
		{0xc4f7, 0x0},
		{0xc4f8, 0x4},
		{0xc4f9, 0xb},
		{0xc4fa, 0x0},
		{0xc4fb, 0x1},
		{0xc4fc, 0x1},
		{0xc4fd, 0x1},
		{0xc4fe, 0x4},
		{0xc4ff, 0x2},
		{0xc500, 0x68},
		{0xc501, 0x74},
		{0xc502, 0x70},
		{0xc503, 0x80},
		{0xc504, 0x5},
		{0xc505, 0x80},
		{0xc506, 0x3},
		{0xc507, 0x80},
		{0xc508, 0x1},
		{0xc509, 0xc0},
		{0xc50a, 0x1},
		{0xc50b, 0xa0},
		{0xc50c, 0x1},
		{0xc50d, 0x2c},
		{0xc50e, 0x1},
		{0xc50f, 0xa},
		{0xc510, 0x0},
		{0xc511, 0x0},
		{0xc512, 0xe5},
		{0xc513, 0x14},
		{0xc514, 0x4},
		{0xc515, 0x0},
		{0xc518, 0x3},
		{0xc519, 0x48},
		{0xc51a, 0x7},
		{0xc51b, 0x70},
		{0xc2e0, 0x0},
		{0xc2e1, 0x51},
		{0xc2e2, 0x0},
		{0xc2e3, 0xd6},
		{0xc2e4, 0x1},
		{0xc2e5, 0x5e},
		{0xc2e9, 0x1},
		{0xc2ea, 0x7a},
		{0xc2eb, 0x90},
		{0xc2ed, 0x1},
		{0xc2ee, 0x7a},
		{0xc2ef, 0x64},
		{0xc308, 0x0},
		{0xc309, 0x0},
		{0xc30a, 0x0},
		{0xc30c, 0x0},
		{0xc30d, 0x1},
		{0xc30e, 0x0},
		{0xc30f, 0x0},
		{0xc310, 0x1},
		{0xc311, 0x60},
		{0xc312, 0xff},
		{0xc313, 0x8},
		{0xc314, 0x1},
		{0xc315, 0x7f},
		{0xc316, 0xff},
		{0xc317, 0xb},
		{0xc318, 0x0},
		{0xc319, 0xc},
		{0xc31a, 0x0},
		{0xc31b, 0xe0},
		{0xc31c, 0x0},
		{0xc31d, 0x14},
		{0xc31e, 0x0},
		{0xc31f, 0xc5},
		{0xc320, 0xff},
		{0xc321, 0x4b},
		{0xc322, 0xff},
		{0xc323, 0xf0},
		{0xc324, 0xff},
		{0xc325, 0xe8},
		{0xc326, 0x0},
		{0xc327, 0x46},
		{0xc328, 0xff},
		{0xc329, 0xd2},
		{0xc32a, 0xff},
		{0xc32b, 0xe4},
		{0xc32c, 0xff},
		{0xc32d, 0xbb},
		{0xc32e, 0x0},
		{0xc32f, 0x61},
		{0xc330, 0xff},
		{0xc331, 0xf9},
		{0xc332, 0x0},
		{0xc333, 0xd9},
		{0xc334, 0x0},
		{0xc335, 0x2e},
		{0xc336, 0x0},
		{0xc337, 0xb1},
		{0xc338, 0xff},
		{0xc339, 0x64},
		{0xc33a, 0xff},
		{0xc33b, 0xeb},
		{0xc33c, 0xff},
		{0xc33d, 0xe8},
		{0xc33e, 0x0},
		{0xc33f, 0x48},
		{0xc340, 0xff},
		{0xc341, 0xd0},
		{0xc342, 0xff},
		{0xc343, 0xed},
		{0xc344, 0xff},
		{0xc345, 0xad},
		{0xc346, 0x0},
		{0xc347, 0x66},
		{0xc348, 0x1},
		{0xc349, 0x0},
		{0x6700, 0x4},
		{0x6701, 0x7b},
		{0x6702, 0xfd},
		{0x6703, 0xf9},
		{0x6704, 0x3d},
		{0x6705, 0x71},
		/*
		 * 0x6706[3:0] :: XVCLK
		 * 0x6706[3:0] :: 0 = 6MHz
		 * 0x6706[3:0] :: 1 = 9MHz
		 * 0x6706[3:0] :: 8 = 24MHz
		 * 0x6706[3:0] :: 9 = 27MHz
		 */
		{0x6706, 0x71},
		{0x6708, 0x5},
		{0x3822, 0x50},
		{0x6f06, 0x6f},
		{0x6f07, 0x0},
		{0x6f0a, 0x6f},
		{0x6f0b, 0x0},
		{0x6f00, 0x3},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x3042, 0xf0},
		{0x301b, 0xf0},
		{0x301c, 0xf0},
		{0x301a, 0xf0},
};

static const struct ov1063x_reg ov1063x_regs_change_mode[] = {
	{ 0x301b, 0xff }, { 0x301c, 0xff }, { 0x301a, 0xff }, { 0x5005, 0x08 },
	{ 0x3007, 0x01 }, { 0x381c, 0x00 }, { 0x381f, 0x0C }, { 0x4001, 0x04 },
	{ 0x4004, 0x08 }, { 0x4050, 0x20 }, { 0x4051, 0x22 }, { 0x6e47, 0x0C },
	{ 0x4610, 0x05 }, { 0x4613, 0x10 },
};

static const struct ov1063x_reg ov1063x_regs_bt656[] = {
	{ 0x4700, 0x02 }, { 0x4302, 0x03 }, { 0x4303, 0xf8 }, { 0x4304, 0x00 },
	{ 0x4305, 0x08 }, { 0x4306, 0x03 }, { 0x4307, 0xf8 }, { 0x4308, 0x00 },
	{ 0x4309, 0x08 },
};

static const struct ov1063x_reg ov1063x_regs_bt656_10bit[] = {
	{ 0x4700, 0x02 }, { 0x4302, 0x03 }, { 0x4303, 0xfe }, { 0x4304, 0x00 },
	{ 0x4305, 0x02 }, { 0x4306, 0x03 }, { 0x4307, 0xfe }, { 0x4308, 0x00 },
	{ 0x4309, 0x02 },
};

static const struct ov1063x_reg ov1063x_regs_vert_sub_sample[] = {
	{ 0x381f, 0x06 }, { 0x4001, 0x02 }, { 0x4004, 0x02 }, { 0x4050, 0x10 },
	{ 0x4051, 0x11 }, { 0x6e47, 0x06 }, { 0x4610, 0x03 }, { 0x4613, 0x0a },
};

static const struct ov1063x_reg ov1063x_regs_enable[] = {
	{ 0x3042, 0xf0 }, { 0x3042, 0xf0 }, { 0x3042, 0xf0 }, { 0x3042, 0xf0 },
	{ 0x3042, 0xf0 }, { 0x3042, 0xf0 }, { 0x3042, 0xf0 }, { 0x3042, 0xf0 },
	{ 0x3042, 0xf0 }, { 0x3042, 0xf0 }, { 0x3042, 0xf0 }, { 0x3042, 0xf0 },
	{ 0x3042, 0xf0 }, { 0x3042, 0xf0 }, { 0x3042, 0xf0 }, { 0x3042, 0xf0 },
	{ 0x3042, 0xf0 }, { 0x3042, 0xf0 }, { 0x3042, 0xf0 }, { 0x3042, 0xf0 },
	{ 0x3042, 0xf0 }, { 0x3042, 0xf0 }, { 0x3042, 0xf0 }, { 0x3042, 0xf0 },
	{ 0x3042, 0xf0 }, { 0x3042, 0xf0 }, { 0x301b, 0xf0 }, { 0x301c, 0xf0 },
	{ 0x301a, 0xf0 },
};

/*
 * Datasheet highlight the following sequence to enable and disable
 * Test Pattern mode i.e. colobar
 */
static const struct ov1063x_reg ov1063x_regs_colorbar_enable[] = {
	{0x5120, 0x01}, {0x56d0, 0x01}, {0x5300, 0x01}, {0x5301, 0x00},
	{0x5302, 0x00},	{0x5303, 0x00},	{0x5304, 0x00},	{0x5305, 0x00},
	{0x5306, 0x00},	{0x5307, 0x00},	{0x5308, 0x01},	{0x5309, 0x00},
	{0x530a, 0x00},	{0x530b, 0x00},	{0x530c, 0x00},	{0x530d, 0x00},
	{0x530e, 0x00},	{0x530f, 0x00},	{0x5310, 0x01},	{0x5311, 0x00},
	{0x5312, 0x00},	{0x5313, 0x00},	{0x5314, 0x01},	{0x5315, 0x00},
	{0x5316, 0x00},	{0x5317, 0x00},	{0x5318, 0x00},	{0x5319, 0x00},
	{0x531a, 0x00},	{0x531b, 0x00},	{0x531c, 0x01},	{0x531d, 0x00},
	{0x531e, 0x00},	{0x531f, 0x00},	{0x5320, 0x00},	{0x5321, 0x00},
	{0x5322, 0x00},	{0x5323, 0x00},	{0x5324, 0x01},	{0x5325, 0x00},
	{0x5326, 0x00},	{0x5327, 0x00},	{0xc2ea, 0x80},	{0xc2eb, 0x80},
	{0x5000, 0x79},	{0x503d, 0x80},
};

static const struct ov1063x_reg ov1063x_regs_colorbar_disable[] = {
	{0x503d, 0x00},	{0x5120, 0x00},	{0x56d0, 0x00},	{0x5300, 0x01},
	{0x5301, 0x00},	{0x5302, 0x00},	{0x5303, 0x0e},	{0x5304, 0x00},
	{0x5305, 0x0e},	{0x5306, 0x00},	{0x5307, 0x36},	{0x5308, 0x00},
	{0x5309, 0xd9},	{0x530a, 0x00},	{0x530b, 0x0f},	{0x530c, 0x00},
	{0x530d, 0x2c},	{0x530e, 0x00},	{0x530f, 0x59},	{0x5310, 0x00},
	{0x5311, 0x7b},	{0x5312, 0x00},	{0x5313, 0x22},	{0x5314, 0x00},
	{0x5315, 0xd5},	{0x5316, 0x00},	{0x5317, 0x13},	{0x5318, 0x00},
	{0x5319, 0x18},	{0x531a, 0x00},	{0x531b, 0x26},	{0x531c, 0x00},
	{0x531d, 0xdc},	{0x531e, 0x00},	{0x531f, 0x02},	{0x5320, 0x00},
	{0x5321, 0x24},	{0x5322, 0x00},	{0x5323, 0x56},	{0x5324, 0x00},
	{0x5325, 0x85},	{0x5326, 0x00},	{0x5327, 0x20},	{0xc2ea, 0x7a},
	{0xc2eb, 0x90},	{0x5000, 0xff},
};
