/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "systemd1_manager_interface.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.systemd1.Manager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Systemd1Manager
 * @title: Systemd1Manager
 * @short_description: Generated C code for the org.freedesktop.systemd1.Manager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-systemd1-Manager.top_of_page">org.freedesktop.systemd1.Manager</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.systemd1.Manager ---- */

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_unit_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_OUT_ARG_unit =
{
  {
    -1,
    (gchar *) "unit",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_unit_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_unit_OUT_ARG_unit.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_get_unit =
{
  {
    -1,
    (gchar *) "GetUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_unit_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_unit_OUT_ARG_pointers,
    NULL
  },
  "handle-get-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_by_pid_IN_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_unit_by_pid_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_unit_by_pid_IN_ARG_pid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_by_pid_OUT_ARG_unit =
{
  {
    -1,
    (gchar *) "unit",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_unit_by_pid_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_unit_by_pid_OUT_ARG_unit.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_get_unit_by_pid =
{
  {
    -1,
    (gchar *) "GetUnitByPID",
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_unit_by_pid_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_unit_by_pid_OUT_ARG_pointers,
    NULL
  },
  "handle-get-unit-by-pid",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_by_invocation_id_IN_ARG_invocation_id =
{
  {
    -1,
    (gchar *) "invocation_id",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_unit_by_invocation_id_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_unit_by_invocation_id_IN_ARG_invocation_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_by_invocation_id_OUT_ARG_unit =
{
  {
    -1,
    (gchar *) "unit",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_unit_by_invocation_id_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_unit_by_invocation_id_OUT_ARG_unit.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_get_unit_by_invocation_id =
{
  {
    -1,
    (gchar *) "GetUnitByInvocationID",
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_unit_by_invocation_id_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_unit_by_invocation_id_OUT_ARG_pointers,
    NULL
  },
  "handle-get-unit-by-invocation-id",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_by_control_group_IN_ARG_cgroup =
{
  {
    -1,
    (gchar *) "cgroup",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_unit_by_control_group_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_unit_by_control_group_IN_ARG_cgroup.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_by_control_group_OUT_ARG_unit =
{
  {
    -1,
    (gchar *) "unit",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_unit_by_control_group_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_unit_by_control_group_OUT_ARG_unit.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_get_unit_by_control_group =
{
  {
    -1,
    (gchar *) "GetUnitByControlGroup",
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_unit_by_control_group_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_unit_by_control_group_OUT_ARG_pointers,
    NULL
  },
  "handle-get-unit-by-control-group",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_load_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_load_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_load_unit_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_load_unit_OUT_ARG_unit =
{
  {
    -1,
    (gchar *) "unit",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_load_unit_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_load_unit_OUT_ARG_unit.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_load_unit =
{
  {
    -1,
    (gchar *) "LoadUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_load_unit_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_load_unit_OUT_ARG_pointers,
    NULL
  },
  "handle-load-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_start_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_start_unit_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_start_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_start_unit_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_start_unit_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_start_unit_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_start_unit_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_start_unit_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_start_unit =
{
  {
    -1,
    (gchar *) "StartUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_start_unit_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_start_unit_OUT_ARG_pointers,
    NULL
  },
  "handle-start-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_start_unit_replace_IN_ARG_old_unit =
{
  {
    -1,
    (gchar *) "old_unit",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_start_unit_replace_IN_ARG_new_unit =
{
  {
    -1,
    (gchar *) "new_unit",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_start_unit_replace_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_start_unit_replace_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_start_unit_replace_IN_ARG_old_unit.parent_struct,
  &_systemd1_manager_method_info_start_unit_replace_IN_ARG_new_unit.parent_struct,
  &_systemd1_manager_method_info_start_unit_replace_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_start_unit_replace_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_start_unit_replace_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_start_unit_replace_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_start_unit_replace =
{
  {
    -1,
    (gchar *) "StartUnitReplace",
    (GDBusArgInfo **) &_systemd1_manager_method_info_start_unit_replace_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_start_unit_replace_OUT_ARG_pointers,
    NULL
  },
  "handle-start-unit-replace",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_stop_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_stop_unit_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_stop_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_stop_unit_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_stop_unit_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_stop_unit_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_stop_unit_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_stop_unit_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_stop_unit =
{
  {
    -1,
    (gchar *) "StopUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_stop_unit_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_stop_unit_OUT_ARG_pointers,
    NULL
  },
  "handle-stop-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reload_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reload_unit_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_reload_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_reload_unit_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_reload_unit_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reload_unit_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_reload_unit_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_reload_unit_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_reload_unit =
{
  {
    -1,
    (gchar *) "ReloadUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_reload_unit_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_reload_unit_OUT_ARG_pointers,
    NULL
  },
  "handle-reload-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_restart_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_restart_unit_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_restart_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_restart_unit_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_restart_unit_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_restart_unit_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_restart_unit_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_restart_unit_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_restart_unit =
{
  {
    -1,
    (gchar *) "RestartUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_restart_unit_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_restart_unit_OUT_ARG_pointers,
    NULL
  },
  "handle-restart-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_try_restart_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_try_restart_unit_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_try_restart_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_try_restart_unit_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_try_restart_unit_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_try_restart_unit_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_try_restart_unit_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_try_restart_unit_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_try_restart_unit =
{
  {
    -1,
    (gchar *) "TryRestartUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_try_restart_unit_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_try_restart_unit_OUT_ARG_pointers,
    NULL
  },
  "handle-try-restart-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reload_or_restart_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reload_or_restart_unit_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_reload_or_restart_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_reload_or_restart_unit_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_reload_or_restart_unit_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reload_or_restart_unit_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_reload_or_restart_unit_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_reload_or_restart_unit_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_reload_or_restart_unit =
{
  {
    -1,
    (gchar *) "ReloadOrRestartUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_reload_or_restart_unit_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_reload_or_restart_unit_OUT_ARG_pointers,
    NULL
  },
  "handle-reload-or-restart-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reload_or_try_restart_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reload_or_try_restart_unit_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_reload_or_try_restart_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_reload_or_try_restart_unit_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_reload_or_try_restart_unit_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reload_or_try_restart_unit_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_reload_or_try_restart_unit_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_reload_or_try_restart_unit_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_reload_or_try_restart_unit =
{
  {
    -1,
    (gchar *) "ReloadOrTryRestartUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_reload_or_try_restart_unit_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_reload_or_try_restart_unit_OUT_ARG_pointers,
    NULL
  },
  "handle-reload-or-try-restart-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enqueue_unit_job_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enqueue_unit_job_IN_ARG_job_type =
{
  {
    -1,
    (gchar *) "job_type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enqueue_unit_job_IN_ARG_job_mode =
{
  {
    -1,
    (gchar *) "job_mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_enqueue_unit_job_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_enqueue_unit_job_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_enqueue_unit_job_IN_ARG_job_type.parent_struct,
  &_systemd1_manager_method_info_enqueue_unit_job_IN_ARG_job_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enqueue_unit_job_OUT_ARG_job_id =
{
  {
    -1,
    (gchar *) "job_id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enqueue_unit_job_OUT_ARG_job_path =
{
  {
    -1,
    (gchar *) "job_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enqueue_unit_job_OUT_ARG_unit_id =
{
  {
    -1,
    (gchar *) "unit_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enqueue_unit_job_OUT_ARG_unit_path =
{
  {
    -1,
    (gchar *) "unit_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enqueue_unit_job_OUT_ARG_job_type =
{
  {
    -1,
    (gchar *) "job_type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enqueue_unit_job_OUT_ARG_affected_jobs =
{
  {
    -1,
    (gchar *) "affected_jobs",
    (gchar *) "a(uosos)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_enqueue_unit_job_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_enqueue_unit_job_OUT_ARG_job_id.parent_struct,
  &_systemd1_manager_method_info_enqueue_unit_job_OUT_ARG_job_path.parent_struct,
  &_systemd1_manager_method_info_enqueue_unit_job_OUT_ARG_unit_id.parent_struct,
  &_systemd1_manager_method_info_enqueue_unit_job_OUT_ARG_unit_path.parent_struct,
  &_systemd1_manager_method_info_enqueue_unit_job_OUT_ARG_job_type.parent_struct,
  &_systemd1_manager_method_info_enqueue_unit_job_OUT_ARG_affected_jobs.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_enqueue_unit_job =
{
  {
    -1,
    (gchar *) "EnqueueUnitJob",
    (GDBusArgInfo **) &_systemd1_manager_method_info_enqueue_unit_job_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_enqueue_unit_job_OUT_ARG_pointers,
    NULL
  },
  "handle-enqueue-unit-job",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_kill_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_kill_unit_IN_ARG_whom =
{
  {
    -1,
    (gchar *) "whom",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_kill_unit_IN_ARG_signal =
{
  {
    -1,
    (gchar *) "signal",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_kill_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_kill_unit_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_kill_unit_IN_ARG_whom.parent_struct,
  &_systemd1_manager_method_info_kill_unit_IN_ARG_signal.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_kill_unit =
{
  {
    -1,
    (gchar *) "KillUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_kill_unit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-kill-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_clean_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_clean_unit_IN_ARG_mask =
{
  {
    -1,
    (gchar *) "mask",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_clean_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_clean_unit_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_clean_unit_IN_ARG_mask.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_clean_unit =
{
  {
    -1,
    (gchar *) "CleanUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_clean_unit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-clean-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_freeze_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_freeze_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_freeze_unit_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_freeze_unit =
{
  {
    -1,
    (gchar *) "FreezeUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_freeze_unit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-freeze-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_thaw_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_thaw_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_thaw_unit_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_thaw_unit =
{
  {
    -1,
    (gchar *) "ThawUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_thaw_unit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-thaw-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reset_failed_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_reset_failed_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_reset_failed_unit_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_reset_failed_unit =
{
  {
    -1,
    (gchar *) "ResetFailedUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_reset_failed_unit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-reset-failed-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_set_unit_properties_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_set_unit_properties_IN_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_set_unit_properties_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a(sv)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_set_unit_properties_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_set_unit_properties_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_set_unit_properties_IN_ARG_runtime.parent_struct,
  &_systemd1_manager_method_info_set_unit_properties_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_set_unit_properties =
{
  {
    -1,
    (gchar *) "SetUnitProperties",
    (GDBusArgInfo **) &_systemd1_manager_method_info_set_unit_properties_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-unit-properties",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_bind_mount_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_bind_mount_unit_IN_ARG_source =
{
  {
    -1,
    (gchar *) "source",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_bind_mount_unit_IN_ARG_destination =
{
  {
    -1,
    (gchar *) "destination",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_bind_mount_unit_IN_ARG_read_only =
{
  {
    -1,
    (gchar *) "read_only",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_bind_mount_unit_IN_ARG_mkdir =
{
  {
    -1,
    (gchar *) "mkdir",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_bind_mount_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_bind_mount_unit_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_bind_mount_unit_IN_ARG_source.parent_struct,
  &_systemd1_manager_method_info_bind_mount_unit_IN_ARG_destination.parent_struct,
  &_systemd1_manager_method_info_bind_mount_unit_IN_ARG_read_only.parent_struct,
  &_systemd1_manager_method_info_bind_mount_unit_IN_ARG_mkdir.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_bind_mount_unit =
{
  {
    -1,
    (gchar *) "BindMountUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_bind_mount_unit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-bind-mount-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_mount_image_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_mount_image_unit_IN_ARG_source =
{
  {
    -1,
    (gchar *) "source",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_mount_image_unit_IN_ARG_destination =
{
  {
    -1,
    (gchar *) "destination",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_mount_image_unit_IN_ARG_read_only =
{
  {
    -1,
    (gchar *) "read_only",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_mount_image_unit_IN_ARG_mkdir =
{
  {
    -1,
    (gchar *) "mkdir",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_mount_image_unit_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a(ss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_mount_image_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_mount_image_unit_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_mount_image_unit_IN_ARG_source.parent_struct,
  &_systemd1_manager_method_info_mount_image_unit_IN_ARG_destination.parent_struct,
  &_systemd1_manager_method_info_mount_image_unit_IN_ARG_read_only.parent_struct,
  &_systemd1_manager_method_info_mount_image_unit_IN_ARG_mkdir.parent_struct,
  &_systemd1_manager_method_info_mount_image_unit_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_mount_image_unit =
{
  {
    -1,
    (gchar *) "MountImageUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_mount_image_unit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-mount-image-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_ref_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_ref_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_ref_unit_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_ref_unit =
{
  {
    -1,
    (gchar *) "RefUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_ref_unit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-ref-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_unref_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_unref_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_unref_unit_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_unref_unit =
{
  {
    -1,
    (gchar *) "UnrefUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_unref_unit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-unref-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_start_transient_unit_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_start_transient_unit_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_start_transient_unit_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a(sv)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_start_transient_unit_IN_ARG_aux =
{
  {
    -1,
    (gchar *) "aux",
    (gchar *) "a(sa(sv))",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_start_transient_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_start_transient_unit_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_start_transient_unit_IN_ARG_mode.parent_struct,
  &_systemd1_manager_method_info_start_transient_unit_IN_ARG_properties.parent_struct,
  &_systemd1_manager_method_info_start_transient_unit_IN_ARG_aux.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_start_transient_unit_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_start_transient_unit_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_start_transient_unit_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_start_transient_unit =
{
  {
    -1,
    (gchar *) "StartTransientUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_start_transient_unit_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_start_transient_unit_OUT_ARG_pointers,
    NULL
  },
  "handle-start-transient-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_processes_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_unit_processes_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_unit_processes_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_processes_OUT_ARG_processes =
{
  {
    -1,
    (gchar *) "processes",
    (gchar *) "a(sus)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_unit_processes_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_unit_processes_OUT_ARG_processes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_get_unit_processes =
{
  {
    -1,
    (gchar *) "GetUnitProcesses",
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_unit_processes_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_unit_processes_OUT_ARG_pointers,
    NULL
  },
  "handle-get-unit-processes",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_attach_processes_to_unit_IN_ARG_unit_name =
{
  {
    -1,
    (gchar *) "unit_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_attach_processes_to_unit_IN_ARG_subcgroup =
{
  {
    -1,
    (gchar *) "subcgroup",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_attach_processes_to_unit_IN_ARG_pids =
{
  {
    -1,
    (gchar *) "pids",
    (gchar *) "au",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_attach_processes_to_unit_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_attach_processes_to_unit_IN_ARG_unit_name.parent_struct,
  &_systemd1_manager_method_info_attach_processes_to_unit_IN_ARG_subcgroup.parent_struct,
  &_systemd1_manager_method_info_attach_processes_to_unit_IN_ARG_pids.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_attach_processes_to_unit =
{
  {
    -1,
    (gchar *) "AttachProcessesToUnit",
    (GDBusArgInfo **) &_systemd1_manager_method_info_attach_processes_to_unit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-attach-processes-to-unit",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_abandon_scope_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_abandon_scope_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_abandon_scope_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_abandon_scope =
{
  {
    -1,
    (gchar *) "AbandonScope",
    (GDBusArgInfo **) &_systemd1_manager_method_info_abandon_scope_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-abandon-scope",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_job_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_job_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_job_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_job_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_job_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_job_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_get_job =
{
  {
    -1,
    (gchar *) "GetJob",
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_job_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_job_OUT_ARG_pointers,
    NULL
  },
  "handle-get-job",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_job_after_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_job_after_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_job_after_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_job_after_OUT_ARG_jobs =
{
  {
    -1,
    (gchar *) "jobs",
    (gchar *) "a(usssoo)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_job_after_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_job_after_OUT_ARG_jobs.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_get_job_after =
{
  {
    -1,
    (gchar *) "GetJobAfter",
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_job_after_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_job_after_OUT_ARG_pointers,
    NULL
  },
  "handle-get-job-after",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_job_before_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_job_before_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_job_before_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_job_before_OUT_ARG_jobs =
{
  {
    -1,
    (gchar *) "jobs",
    (gchar *) "a(usssoo)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_job_before_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_job_before_OUT_ARG_jobs.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_get_job_before =
{
  {
    -1,
    (gchar *) "GetJobBefore",
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_job_before_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_job_before_OUT_ARG_pointers,
    NULL
  },
  "handle-get-job-before",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_cancel_job_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_cancel_job_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_cancel_job_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_cancel_job =
{
  {
    -1,
    (gchar *) "CancelJob",
    (GDBusArgInfo **) &_systemd1_manager_method_info_cancel_job_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-cancel-job",
  FALSE
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_clear_jobs =
{
  {
    -1,
    (gchar *) "ClearJobs",
    NULL,
    NULL,
    NULL
  },
  "handle-clear-jobs",
  FALSE
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_reset_failed =
{
  {
    -1,
    (gchar *) "ResetFailed",
    NULL,
    NULL,
    NULL
  },
  "handle-reset-failed",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_set_show_status_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_set_show_status_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_set_show_status_IN_ARG_mode.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _systemd1_manager_method_set_show_status_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_method_set_show_status_annotation_info_pointers[] =
{
  &_systemd1_manager_method_set_show_status_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_set_show_status =
{
  {
    -1,
    (gchar *) "SetShowStatus",
    (GDBusArgInfo **) &_systemd1_manager_method_info_set_show_status_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_systemd1_manager_method_set_show_status_annotation_info_pointers
  },
  "handle-set-show-status",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_list_units_OUT_ARG_units =
{
  {
    -1,
    (gchar *) "units",
    (gchar *) "a(ssssssouso)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_list_units_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_list_units_OUT_ARG_units.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_list_units =
{
  {
    -1,
    (gchar *) "ListUnits",
    NULL,
    (GDBusArgInfo **) &_systemd1_manager_method_info_list_units_OUT_ARG_pointers,
    NULL
  },
  "handle-list-units",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_list_units_filtered_IN_ARG_states =
{
  {
    -1,
    (gchar *) "states",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_list_units_filtered_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_list_units_filtered_IN_ARG_states.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_list_units_filtered_OUT_ARG_units =
{
  {
    -1,
    (gchar *) "units",
    (gchar *) "a(ssssssouso)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_list_units_filtered_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_list_units_filtered_OUT_ARG_units.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_list_units_filtered =
{
  {
    -1,
    (gchar *) "ListUnitsFiltered",
    (GDBusArgInfo **) &_systemd1_manager_method_info_list_units_filtered_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_list_units_filtered_OUT_ARG_pointers,
    NULL
  },
  "handle-list-units-filtered",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_list_units_by_patterns_IN_ARG_states =
{
  {
    -1,
    (gchar *) "states",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_list_units_by_patterns_IN_ARG_patterns =
{
  {
    -1,
    (gchar *) "patterns",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_list_units_by_patterns_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_list_units_by_patterns_IN_ARG_states.parent_struct,
  &_systemd1_manager_method_info_list_units_by_patterns_IN_ARG_patterns.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_list_units_by_patterns_OUT_ARG_units =
{
  {
    -1,
    (gchar *) "units",
    (gchar *) "a(ssssssouso)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_list_units_by_patterns_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_list_units_by_patterns_OUT_ARG_units.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_list_units_by_patterns =
{
  {
    -1,
    (gchar *) "ListUnitsByPatterns",
    (GDBusArgInfo **) &_systemd1_manager_method_info_list_units_by_patterns_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_list_units_by_patterns_OUT_ARG_pointers,
    NULL
  },
  "handle-list-units-by-patterns",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_list_units_by_names_IN_ARG_names =
{
  {
    -1,
    (gchar *) "names",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_list_units_by_names_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_list_units_by_names_IN_ARG_names.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_list_units_by_names_OUT_ARG_units =
{
  {
    -1,
    (gchar *) "units",
    (gchar *) "a(ssssssouso)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_list_units_by_names_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_list_units_by_names_OUT_ARG_units.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_list_units_by_names =
{
  {
    -1,
    (gchar *) "ListUnitsByNames",
    (GDBusArgInfo **) &_systemd1_manager_method_info_list_units_by_names_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_list_units_by_names_OUT_ARG_pointers,
    NULL
  },
  "handle-list-units-by-names",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_list_jobs_OUT_ARG_jobs =
{
  {
    -1,
    (gchar *) "jobs",
    (gchar *) "a(usssoo)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_list_jobs_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_list_jobs_OUT_ARG_jobs.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_list_jobs =
{
  {
    -1,
    (gchar *) "ListJobs",
    NULL,
    (GDBusArgInfo **) &_systemd1_manager_method_info_list_jobs_OUT_ARG_pointers,
    NULL
  },
  "handle-list-jobs",
  FALSE
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_subscribe =
{
  {
    -1,
    (gchar *) "Subscribe",
    NULL,
    NULL,
    NULL
  },
  "handle-subscribe",
  FALSE
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_unsubscribe =
{
  {
    -1,
    (gchar *) "Unsubscribe",
    NULL,
    NULL,
    NULL
  },
  "handle-unsubscribe",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_dump_OUT_ARG_output =
{
  {
    -1,
    (gchar *) "output",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_dump_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_dump_OUT_ARG_output.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_dump =
{
  {
    -1,
    (gchar *) "Dump",
    NULL,
    (GDBusArgInfo **) &_systemd1_manager_method_info_dump_OUT_ARG_pointers,
    NULL
  },
  "handle-dump",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_dump_by_file_descriptor_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_dump_by_file_descriptor_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_dump_by_file_descriptor_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_dump_by_file_descriptor =
{
  {
    -1,
    (gchar *) "DumpByFileDescriptor",
    NULL,
    (GDBusArgInfo **) &_systemd1_manager_method_info_dump_by_file_descriptor_OUT_ARG_pointers,
    NULL
  },
  "handle-dump-by-file-descriptor",
  FALSE
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_reload =
{
  {
    -1,
    (gchar *) "Reload",
    NULL,
    NULL,
    NULL
  },
  "handle-reload",
  FALSE
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_reexecute =
{
  {
    -1,
    (gchar *) "Reexecute",
    NULL,
    NULL,
    NULL
  },
  "handle-reexecute",
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_method_exit_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_method_exit_annotation_info_pointers[] =
{
  &_systemd1_manager_method_exit_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_exit =
{
  {
    -1,
    (gchar *) "Exit",
    NULL,
    NULL,
    (GDBusAnnotationInfo **) &_systemd1_manager_method_exit_annotation_info_pointers
  },
  "handle-exit",
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_method_reboot_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_method_reboot_annotation_info_pointers[] =
{
  &_systemd1_manager_method_reboot_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_reboot =
{
  {
    -1,
    (gchar *) "Reboot",
    NULL,
    NULL,
    (GDBusAnnotationInfo **) &_systemd1_manager_method_reboot_annotation_info_pointers
  },
  "handle-reboot",
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_method_power_off_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_method_power_off_annotation_info_pointers[] =
{
  &_systemd1_manager_method_power_off_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_power_off =
{
  {
    -1,
    (gchar *) "PowerOff",
    NULL,
    NULL,
    (GDBusAnnotationInfo **) &_systemd1_manager_method_power_off_annotation_info_pointers
  },
  "handle-power-off",
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_method_halt_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_method_halt_annotation_info_pointers[] =
{
  &_systemd1_manager_method_halt_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_halt =
{
  {
    -1,
    (gchar *) "Halt",
    NULL,
    NULL,
    (GDBusAnnotationInfo **) &_systemd1_manager_method_halt_annotation_info_pointers
  },
  "handle-halt",
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_method_kexec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_method_kexec_annotation_info_pointers[] =
{
  &_systemd1_manager_method_kexec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_kexec =
{
  {
    -1,
    (gchar *) "KExec",
    NULL,
    NULL,
    (GDBusAnnotationInfo **) &_systemd1_manager_method_kexec_annotation_info_pointers
  },
  "handle-kexec",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_switch_root_IN_ARG_new_root =
{
  {
    -1,
    (gchar *) "new_root",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_switch_root_IN_ARG_init =
{
  {
    -1,
    (gchar *) "init",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_switch_root_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_switch_root_IN_ARG_new_root.parent_struct,
  &_systemd1_manager_method_info_switch_root_IN_ARG_init.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _systemd1_manager_method_switch_root_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_method_switch_root_annotation_info_pointers[] =
{
  &_systemd1_manager_method_switch_root_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_switch_root =
{
  {
    -1,
    (gchar *) "SwitchRoot",
    (GDBusArgInfo **) &_systemd1_manager_method_info_switch_root_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_systemd1_manager_method_switch_root_annotation_info_pointers
  },
  "handle-switch-root",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_set_environment_IN_ARG_assignments =
{
  {
    -1,
    (gchar *) "assignments",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_set_environment_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_set_environment_IN_ARG_assignments.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_set_environment =
{
  {
    -1,
    (gchar *) "SetEnvironment",
    (GDBusArgInfo **) &_systemd1_manager_method_info_set_environment_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-environment",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_unset_environment_IN_ARG_names =
{
  {
    -1,
    (gchar *) "names",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_unset_environment_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_unset_environment_IN_ARG_names.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_unset_environment =
{
  {
    -1,
    (gchar *) "UnsetEnvironment",
    (GDBusArgInfo **) &_systemd1_manager_method_info_unset_environment_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-unset-environment",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_unset_and_set_environment_IN_ARG_names =
{
  {
    -1,
    (gchar *) "names",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_unset_and_set_environment_IN_ARG_assignments =
{
  {
    -1,
    (gchar *) "assignments",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_unset_and_set_environment_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_unset_and_set_environment_IN_ARG_names.parent_struct,
  &_systemd1_manager_method_info_unset_and_set_environment_IN_ARG_assignments.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_unset_and_set_environment =
{
  {
    -1,
    (gchar *) "UnsetAndSetEnvironment",
    (GDBusArgInfo **) &_systemd1_manager_method_info_unset_and_set_environment_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-unset-and-set-environment",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enqueue_marked_jobs_OUT_ARG_jobs =
{
  {
    -1,
    (gchar *) "jobs",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_enqueue_marked_jobs_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_enqueue_marked_jobs_OUT_ARG_jobs.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_enqueue_marked_jobs =
{
  {
    -1,
    (gchar *) "EnqueueMarkedJobs",
    NULL,
    (GDBusArgInfo **) &_systemd1_manager_method_info_enqueue_marked_jobs_OUT_ARG_pointers,
    NULL
  },
  "handle-enqueue-marked-jobs",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_list_unit_files_OUT_ARG_unit_files =
{
  {
    -1,
    (gchar *) "unit_files",
    (gchar *) "a(ss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_list_unit_files_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_list_unit_files_OUT_ARG_unit_files.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_list_unit_files =
{
  {
    -1,
    (gchar *) "ListUnitFiles",
    NULL,
    (GDBusArgInfo **) &_systemd1_manager_method_info_list_unit_files_OUT_ARG_pointers,
    NULL
  },
  "handle-list-unit-files",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_list_unit_files_by_patterns_IN_ARG_states =
{
  {
    -1,
    (gchar *) "states",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_list_unit_files_by_patterns_IN_ARG_patterns =
{
  {
    -1,
    (gchar *) "patterns",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_list_unit_files_by_patterns_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_list_unit_files_by_patterns_IN_ARG_states.parent_struct,
  &_systemd1_manager_method_info_list_unit_files_by_patterns_IN_ARG_patterns.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_list_unit_files_by_patterns_OUT_ARG_unit_files =
{
  {
    -1,
    (gchar *) "unit_files",
    (gchar *) "a(ss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_list_unit_files_by_patterns_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_list_unit_files_by_patterns_OUT_ARG_unit_files.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_list_unit_files_by_patterns =
{
  {
    -1,
    (gchar *) "ListUnitFilesByPatterns",
    (GDBusArgInfo **) &_systemd1_manager_method_info_list_unit_files_by_patterns_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_list_unit_files_by_patterns_OUT_ARG_pointers,
    NULL
  },
  "handle-list-unit-files-by-patterns",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_file_state_IN_ARG_file =
{
  {
    -1,
    (gchar *) "file",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_unit_file_state_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_unit_file_state_IN_ARG_file.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_file_state_OUT_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_unit_file_state_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_unit_file_state_OUT_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_get_unit_file_state =
{
  {
    -1,
    (gchar *) "GetUnitFileState",
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_unit_file_state_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_unit_file_state_OUT_ARG_pointers,
    NULL
  },
  "handle-get-unit-file-state",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enable_unit_files_IN_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enable_unit_files_IN_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enable_unit_files_IN_ARG_force =
{
  {
    -1,
    (gchar *) "force",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_enable_unit_files_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_enable_unit_files_IN_ARG_files.parent_struct,
  &_systemd1_manager_method_info_enable_unit_files_IN_ARG_runtime.parent_struct,
  &_systemd1_manager_method_info_enable_unit_files_IN_ARG_force.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enable_unit_files_OUT_ARG_carries_install_info =
{
  {
    -1,
    (gchar *) "carries_install_info",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enable_unit_files_OUT_ARG_changes =
{
  {
    -1,
    (gchar *) "changes",
    (gchar *) "a(sss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_enable_unit_files_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_enable_unit_files_OUT_ARG_carries_install_info.parent_struct,
  &_systemd1_manager_method_info_enable_unit_files_OUT_ARG_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_enable_unit_files =
{
  {
    -1,
    (gchar *) "EnableUnitFiles",
    (GDBusArgInfo **) &_systemd1_manager_method_info_enable_unit_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_enable_unit_files_OUT_ARG_pointers,
    NULL
  },
  "handle-enable-unit-files",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_disable_unit_files_IN_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_disable_unit_files_IN_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_disable_unit_files_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_disable_unit_files_IN_ARG_files.parent_struct,
  &_systemd1_manager_method_info_disable_unit_files_IN_ARG_runtime.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_disable_unit_files_OUT_ARG_changes =
{
  {
    -1,
    (gchar *) "changes",
    (gchar *) "a(sss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_disable_unit_files_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_disable_unit_files_OUT_ARG_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_disable_unit_files =
{
  {
    -1,
    (gchar *) "DisableUnitFiles",
    (GDBusArgInfo **) &_systemd1_manager_method_info_disable_unit_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_disable_unit_files_OUT_ARG_pointers,
    NULL
  },
  "handle-disable-unit-files",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enable_unit_files_with_flags_IN_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enable_unit_files_with_flags_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_enable_unit_files_with_flags_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_enable_unit_files_with_flags_IN_ARG_files.parent_struct,
  &_systemd1_manager_method_info_enable_unit_files_with_flags_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enable_unit_files_with_flags_OUT_ARG_carries_install_info =
{
  {
    -1,
    (gchar *) "carries_install_info",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_enable_unit_files_with_flags_OUT_ARG_changes =
{
  {
    -1,
    (gchar *) "changes",
    (gchar *) "a(sss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_enable_unit_files_with_flags_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_enable_unit_files_with_flags_OUT_ARG_carries_install_info.parent_struct,
  &_systemd1_manager_method_info_enable_unit_files_with_flags_OUT_ARG_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_enable_unit_files_with_flags =
{
  {
    -1,
    (gchar *) "EnableUnitFilesWithFlags",
    (GDBusArgInfo **) &_systemd1_manager_method_info_enable_unit_files_with_flags_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_enable_unit_files_with_flags_OUT_ARG_pointers,
    NULL
  },
  "handle-enable-unit-files-with-flags",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_disable_unit_files_with_flags_IN_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_disable_unit_files_with_flags_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_disable_unit_files_with_flags_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_disable_unit_files_with_flags_IN_ARG_files.parent_struct,
  &_systemd1_manager_method_info_disable_unit_files_with_flags_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_disable_unit_files_with_flags_OUT_ARG_changes =
{
  {
    -1,
    (gchar *) "changes",
    (gchar *) "a(sss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_disable_unit_files_with_flags_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_disable_unit_files_with_flags_OUT_ARG_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_disable_unit_files_with_flags =
{
  {
    -1,
    (gchar *) "DisableUnitFilesWithFlags",
    (GDBusArgInfo **) &_systemd1_manager_method_info_disable_unit_files_with_flags_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_disable_unit_files_with_flags_OUT_ARG_pointers,
    NULL
  },
  "handle-disable-unit-files-with-flags",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reenable_unit_files_IN_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reenable_unit_files_IN_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reenable_unit_files_IN_ARG_force =
{
  {
    -1,
    (gchar *) "force",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_reenable_unit_files_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_reenable_unit_files_IN_ARG_files.parent_struct,
  &_systemd1_manager_method_info_reenable_unit_files_IN_ARG_runtime.parent_struct,
  &_systemd1_manager_method_info_reenable_unit_files_IN_ARG_force.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reenable_unit_files_OUT_ARG_carries_install_info =
{
  {
    -1,
    (gchar *) "carries_install_info",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_reenable_unit_files_OUT_ARG_changes =
{
  {
    -1,
    (gchar *) "changes",
    (gchar *) "a(sss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_reenable_unit_files_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_reenable_unit_files_OUT_ARG_carries_install_info.parent_struct,
  &_systemd1_manager_method_info_reenable_unit_files_OUT_ARG_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_reenable_unit_files =
{
  {
    -1,
    (gchar *) "ReenableUnitFiles",
    (GDBusArgInfo **) &_systemd1_manager_method_info_reenable_unit_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_reenable_unit_files_OUT_ARG_pointers,
    NULL
  },
  "handle-reenable-unit-files",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_link_unit_files_IN_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_link_unit_files_IN_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_link_unit_files_IN_ARG_force =
{
  {
    -1,
    (gchar *) "force",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_link_unit_files_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_link_unit_files_IN_ARG_files.parent_struct,
  &_systemd1_manager_method_info_link_unit_files_IN_ARG_runtime.parent_struct,
  &_systemd1_manager_method_info_link_unit_files_IN_ARG_force.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_link_unit_files_OUT_ARG_changes =
{
  {
    -1,
    (gchar *) "changes",
    (gchar *) "a(sss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_link_unit_files_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_link_unit_files_OUT_ARG_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_link_unit_files =
{
  {
    -1,
    (gchar *) "LinkUnitFiles",
    (GDBusArgInfo **) &_systemd1_manager_method_info_link_unit_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_link_unit_files_OUT_ARG_pointers,
    NULL
  },
  "handle-link-unit-files",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_unit_files_IN_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_unit_files_IN_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_unit_files_IN_ARG_force =
{
  {
    -1,
    (gchar *) "force",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_preset_unit_files_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_preset_unit_files_IN_ARG_files.parent_struct,
  &_systemd1_manager_method_info_preset_unit_files_IN_ARG_runtime.parent_struct,
  &_systemd1_manager_method_info_preset_unit_files_IN_ARG_force.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_unit_files_OUT_ARG_carries_install_info =
{
  {
    -1,
    (gchar *) "carries_install_info",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_unit_files_OUT_ARG_changes =
{
  {
    -1,
    (gchar *) "changes",
    (gchar *) "a(sss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_preset_unit_files_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_preset_unit_files_OUT_ARG_carries_install_info.parent_struct,
  &_systemd1_manager_method_info_preset_unit_files_OUT_ARG_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_preset_unit_files =
{
  {
    -1,
    (gchar *) "PresetUnitFiles",
    (GDBusArgInfo **) &_systemd1_manager_method_info_preset_unit_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_preset_unit_files_OUT_ARG_pointers,
    NULL
  },
  "handle-preset-unit-files",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_unit_files_with_mode_IN_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_unit_files_with_mode_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_unit_files_with_mode_IN_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_unit_files_with_mode_IN_ARG_force =
{
  {
    -1,
    (gchar *) "force",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_preset_unit_files_with_mode_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_preset_unit_files_with_mode_IN_ARG_files.parent_struct,
  &_systemd1_manager_method_info_preset_unit_files_with_mode_IN_ARG_mode.parent_struct,
  &_systemd1_manager_method_info_preset_unit_files_with_mode_IN_ARG_runtime.parent_struct,
  &_systemd1_manager_method_info_preset_unit_files_with_mode_IN_ARG_force.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_unit_files_with_mode_OUT_ARG_carries_install_info =
{
  {
    -1,
    (gchar *) "carries_install_info",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_unit_files_with_mode_OUT_ARG_changes =
{
  {
    -1,
    (gchar *) "changes",
    (gchar *) "a(sss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_preset_unit_files_with_mode_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_preset_unit_files_with_mode_OUT_ARG_carries_install_info.parent_struct,
  &_systemd1_manager_method_info_preset_unit_files_with_mode_OUT_ARG_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_preset_unit_files_with_mode =
{
  {
    -1,
    (gchar *) "PresetUnitFilesWithMode",
    (GDBusArgInfo **) &_systemd1_manager_method_info_preset_unit_files_with_mode_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_preset_unit_files_with_mode_OUT_ARG_pointers,
    NULL
  },
  "handle-preset-unit-files-with-mode",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_mask_unit_files_IN_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_mask_unit_files_IN_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_mask_unit_files_IN_ARG_force =
{
  {
    -1,
    (gchar *) "force",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_mask_unit_files_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_mask_unit_files_IN_ARG_files.parent_struct,
  &_systemd1_manager_method_info_mask_unit_files_IN_ARG_runtime.parent_struct,
  &_systemd1_manager_method_info_mask_unit_files_IN_ARG_force.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_mask_unit_files_OUT_ARG_changes =
{
  {
    -1,
    (gchar *) "changes",
    (gchar *) "a(sss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_mask_unit_files_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_mask_unit_files_OUT_ARG_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_mask_unit_files =
{
  {
    -1,
    (gchar *) "MaskUnitFiles",
    (GDBusArgInfo **) &_systemd1_manager_method_info_mask_unit_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_mask_unit_files_OUT_ARG_pointers,
    NULL
  },
  "handle-mask-unit-files",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_unmask_unit_files_IN_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_unmask_unit_files_IN_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_unmask_unit_files_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_unmask_unit_files_IN_ARG_files.parent_struct,
  &_systemd1_manager_method_info_unmask_unit_files_IN_ARG_runtime.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_unmask_unit_files_OUT_ARG_changes =
{
  {
    -1,
    (gchar *) "changes",
    (gchar *) "a(sss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_unmask_unit_files_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_unmask_unit_files_OUT_ARG_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_unmask_unit_files =
{
  {
    -1,
    (gchar *) "UnmaskUnitFiles",
    (GDBusArgInfo **) &_systemd1_manager_method_info_unmask_unit_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_unmask_unit_files_OUT_ARG_pointers,
    NULL
  },
  "handle-unmask-unit-files",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_revert_unit_files_IN_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_revert_unit_files_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_revert_unit_files_IN_ARG_files.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_revert_unit_files_OUT_ARG_changes =
{
  {
    -1,
    (gchar *) "changes",
    (gchar *) "a(sss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_revert_unit_files_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_revert_unit_files_OUT_ARG_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_revert_unit_files =
{
  {
    -1,
    (gchar *) "RevertUnitFiles",
    (GDBusArgInfo **) &_systemd1_manager_method_info_revert_unit_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_revert_unit_files_OUT_ARG_pointers,
    NULL
  },
  "handle-revert-unit-files",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_set_default_target_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_set_default_target_IN_ARG_force =
{
  {
    -1,
    (gchar *) "force",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_set_default_target_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_set_default_target_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_set_default_target_IN_ARG_force.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_set_default_target_OUT_ARG_changes =
{
  {
    -1,
    (gchar *) "changes",
    (gchar *) "a(sss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_set_default_target_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_set_default_target_OUT_ARG_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_set_default_target =
{
  {
    -1,
    (gchar *) "SetDefaultTarget",
    (GDBusArgInfo **) &_systemd1_manager_method_info_set_default_target_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_set_default_target_OUT_ARG_pointers,
    NULL
  },
  "handle-set-default-target",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_default_target_OUT_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_default_target_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_default_target_OUT_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_get_default_target =
{
  {
    -1,
    (gchar *) "GetDefaultTarget",
    NULL,
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_default_target_OUT_ARG_pointers,
    NULL
  },
  "handle-get-default-target",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_all_unit_files_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_all_unit_files_IN_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_all_unit_files_IN_ARG_force =
{
  {
    -1,
    (gchar *) "force",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_preset_all_unit_files_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_preset_all_unit_files_IN_ARG_mode.parent_struct,
  &_systemd1_manager_method_info_preset_all_unit_files_IN_ARG_runtime.parent_struct,
  &_systemd1_manager_method_info_preset_all_unit_files_IN_ARG_force.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_preset_all_unit_files_OUT_ARG_changes =
{
  {
    -1,
    (gchar *) "changes",
    (gchar *) "a(sss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_preset_all_unit_files_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_preset_all_unit_files_OUT_ARG_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_preset_all_unit_files =
{
  {
    -1,
    (gchar *) "PresetAllUnitFiles",
    (GDBusArgInfo **) &_systemd1_manager_method_info_preset_all_unit_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_preset_all_unit_files_OUT_ARG_pointers,
    NULL
  },
  "handle-preset-all-unit-files",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_add_dependency_unit_files_IN_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_add_dependency_unit_files_IN_ARG_target =
{
  {
    -1,
    (gchar *) "target",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_add_dependency_unit_files_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_add_dependency_unit_files_IN_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_add_dependency_unit_files_IN_ARG_force =
{
  {
    -1,
    (gchar *) "force",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_add_dependency_unit_files_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_add_dependency_unit_files_IN_ARG_files.parent_struct,
  &_systemd1_manager_method_info_add_dependency_unit_files_IN_ARG_target.parent_struct,
  &_systemd1_manager_method_info_add_dependency_unit_files_IN_ARG_type.parent_struct,
  &_systemd1_manager_method_info_add_dependency_unit_files_IN_ARG_runtime.parent_struct,
  &_systemd1_manager_method_info_add_dependency_unit_files_IN_ARG_force.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_add_dependency_unit_files_OUT_ARG_changes =
{
  {
    -1,
    (gchar *) "changes",
    (gchar *) "a(sss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_add_dependency_unit_files_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_add_dependency_unit_files_OUT_ARG_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_add_dependency_unit_files =
{
  {
    -1,
    (gchar *) "AddDependencyUnitFiles",
    (GDBusArgInfo **) &_systemd1_manager_method_info_add_dependency_unit_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_add_dependency_unit_files_OUT_ARG_pointers,
    NULL
  },
  "handle-add-dependency-unit-files",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_file_links_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_file_links_IN_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_unit_file_links_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_unit_file_links_IN_ARG_name.parent_struct,
  &_systemd1_manager_method_info_get_unit_file_links_IN_ARG_runtime.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_unit_file_links_OUT_ARG_links =
{
  {
    -1,
    (gchar *) "links",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_unit_file_links_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_unit_file_links_OUT_ARG_links.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_get_unit_file_links =
{
  {
    -1,
    (gchar *) "GetUnitFileLinks",
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_unit_file_links_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_unit_file_links_OUT_ARG_pointers,
    NULL
  },
  "handle-get-unit-file-links",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_set_exit_code_IN_ARG_number =
{
  {
    -1,
    (gchar *) "number",
    (gchar *) "y",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_set_exit_code_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_set_exit_code_IN_ARG_number.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_set_exit_code =
{
  {
    -1,
    (gchar *) "SetExitCode",
    (GDBusArgInfo **) &_systemd1_manager_method_info_set_exit_code_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-exit-code",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_lookup_dynamic_user_by_name_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_lookup_dynamic_user_by_name_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_lookup_dynamic_user_by_name_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_lookup_dynamic_user_by_name_OUT_ARG_uid =
{
  {
    -1,
    (gchar *) "uid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_lookup_dynamic_user_by_name_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_lookup_dynamic_user_by_name_OUT_ARG_uid.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_lookup_dynamic_user_by_name =
{
  {
    -1,
    (gchar *) "LookupDynamicUserByName",
    (GDBusArgInfo **) &_systemd1_manager_method_info_lookup_dynamic_user_by_name_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_lookup_dynamic_user_by_name_OUT_ARG_pointers,
    NULL
  },
  "handle-lookup-dynamic-user-by-name",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_lookup_dynamic_user_by_uid_IN_ARG_uid =
{
  {
    -1,
    (gchar *) "uid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_lookup_dynamic_user_by_uid_IN_ARG_pointers[] =
{
  &_systemd1_manager_method_info_lookup_dynamic_user_by_uid_IN_ARG_uid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_lookup_dynamic_user_by_uid_OUT_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_lookup_dynamic_user_by_uid_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_lookup_dynamic_user_by_uid_OUT_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_lookup_dynamic_user_by_uid =
{
  {
    -1,
    (gchar *) "LookupDynamicUserByUID",
    (GDBusArgInfo **) &_systemd1_manager_method_info_lookup_dynamic_user_by_uid_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_manager_method_info_lookup_dynamic_user_by_uid_OUT_ARG_pointers,
    NULL
  },
  "handle-lookup-dynamic-user-by-uid",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_method_info_get_dynamic_users_OUT_ARG_users =
{
  {
    -1,
    (gchar *) "users",
    (gchar *) "a(us)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_method_info_get_dynamic_users_OUT_ARG_pointers[] =
{
  &_systemd1_manager_method_info_get_dynamic_users_OUT_ARG_users.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_manager_method_info_get_dynamic_users =
{
  {
    -1,
    (gchar *) "GetDynamicUsers",
    NULL,
    (GDBusArgInfo **) &_systemd1_manager_method_info_get_dynamic_users_OUT_ARG_pointers,
    NULL
  },
  "handle-get-dynamic-users",
  FALSE
};

static const GDBusMethodInfo * const _systemd1_manager_method_info_pointers[] =
{
  &_systemd1_manager_method_info_get_unit.parent_struct,
  &_systemd1_manager_method_info_get_unit_by_pid.parent_struct,
  &_systemd1_manager_method_info_get_unit_by_invocation_id.parent_struct,
  &_systemd1_manager_method_info_get_unit_by_control_group.parent_struct,
  &_systemd1_manager_method_info_load_unit.parent_struct,
  &_systemd1_manager_method_info_start_unit.parent_struct,
  &_systemd1_manager_method_info_start_unit_replace.parent_struct,
  &_systemd1_manager_method_info_stop_unit.parent_struct,
  &_systemd1_manager_method_info_reload_unit.parent_struct,
  &_systemd1_manager_method_info_restart_unit.parent_struct,
  &_systemd1_manager_method_info_try_restart_unit.parent_struct,
  &_systemd1_manager_method_info_reload_or_restart_unit.parent_struct,
  &_systemd1_manager_method_info_reload_or_try_restart_unit.parent_struct,
  &_systemd1_manager_method_info_enqueue_unit_job.parent_struct,
  &_systemd1_manager_method_info_kill_unit.parent_struct,
  &_systemd1_manager_method_info_clean_unit.parent_struct,
  &_systemd1_manager_method_info_freeze_unit.parent_struct,
  &_systemd1_manager_method_info_thaw_unit.parent_struct,
  &_systemd1_manager_method_info_reset_failed_unit.parent_struct,
  &_systemd1_manager_method_info_set_unit_properties.parent_struct,
  &_systemd1_manager_method_info_bind_mount_unit.parent_struct,
  &_systemd1_manager_method_info_mount_image_unit.parent_struct,
  &_systemd1_manager_method_info_ref_unit.parent_struct,
  &_systemd1_manager_method_info_unref_unit.parent_struct,
  &_systemd1_manager_method_info_start_transient_unit.parent_struct,
  &_systemd1_manager_method_info_get_unit_processes.parent_struct,
  &_systemd1_manager_method_info_attach_processes_to_unit.parent_struct,
  &_systemd1_manager_method_info_abandon_scope.parent_struct,
  &_systemd1_manager_method_info_get_job.parent_struct,
  &_systemd1_manager_method_info_get_job_after.parent_struct,
  &_systemd1_manager_method_info_get_job_before.parent_struct,
  &_systemd1_manager_method_info_cancel_job.parent_struct,
  &_systemd1_manager_method_info_clear_jobs.parent_struct,
  &_systemd1_manager_method_info_reset_failed.parent_struct,
  &_systemd1_manager_method_info_set_show_status.parent_struct,
  &_systemd1_manager_method_info_list_units.parent_struct,
  &_systemd1_manager_method_info_list_units_filtered.parent_struct,
  &_systemd1_manager_method_info_list_units_by_patterns.parent_struct,
  &_systemd1_manager_method_info_list_units_by_names.parent_struct,
  &_systemd1_manager_method_info_list_jobs.parent_struct,
  &_systemd1_manager_method_info_subscribe.parent_struct,
  &_systemd1_manager_method_info_unsubscribe.parent_struct,
  &_systemd1_manager_method_info_dump.parent_struct,
  &_systemd1_manager_method_info_dump_by_file_descriptor.parent_struct,
  &_systemd1_manager_method_info_reload.parent_struct,
  &_systemd1_manager_method_info_reexecute.parent_struct,
  &_systemd1_manager_method_info_exit.parent_struct,
  &_systemd1_manager_method_info_reboot.parent_struct,
  &_systemd1_manager_method_info_power_off.parent_struct,
  &_systemd1_manager_method_info_halt.parent_struct,
  &_systemd1_manager_method_info_kexec.parent_struct,
  &_systemd1_manager_method_info_switch_root.parent_struct,
  &_systemd1_manager_method_info_set_environment.parent_struct,
  &_systemd1_manager_method_info_unset_environment.parent_struct,
  &_systemd1_manager_method_info_unset_and_set_environment.parent_struct,
  &_systemd1_manager_method_info_enqueue_marked_jobs.parent_struct,
  &_systemd1_manager_method_info_list_unit_files.parent_struct,
  &_systemd1_manager_method_info_list_unit_files_by_patterns.parent_struct,
  &_systemd1_manager_method_info_get_unit_file_state.parent_struct,
  &_systemd1_manager_method_info_enable_unit_files.parent_struct,
  &_systemd1_manager_method_info_disable_unit_files.parent_struct,
  &_systemd1_manager_method_info_enable_unit_files_with_flags.parent_struct,
  &_systemd1_manager_method_info_disable_unit_files_with_flags.parent_struct,
  &_systemd1_manager_method_info_reenable_unit_files.parent_struct,
  &_systemd1_manager_method_info_link_unit_files.parent_struct,
  &_systemd1_manager_method_info_preset_unit_files.parent_struct,
  &_systemd1_manager_method_info_preset_unit_files_with_mode.parent_struct,
  &_systemd1_manager_method_info_mask_unit_files.parent_struct,
  &_systemd1_manager_method_info_unmask_unit_files.parent_struct,
  &_systemd1_manager_method_info_revert_unit_files.parent_struct,
  &_systemd1_manager_method_info_set_default_target.parent_struct,
  &_systemd1_manager_method_info_get_default_target.parent_struct,
  &_systemd1_manager_method_info_preset_all_unit_files.parent_struct,
  &_systemd1_manager_method_info_add_dependency_unit_files.parent_struct,
  &_systemd1_manager_method_info_get_unit_file_links.parent_struct,
  &_systemd1_manager_method_info_set_exit_code.parent_struct,
  &_systemd1_manager_method_info_lookup_dynamic_user_by_name.parent_struct,
  &_systemd1_manager_method_info_lookup_dynamic_user_by_uid.parent_struct,
  &_systemd1_manager_method_info_get_dynamic_users.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_unit_new_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_unit_new_ARG_unit =
{
  {
    -1,
    (gchar *) "unit",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_signal_info_unit_new_ARG_pointers[] =
{
  &_systemd1_manager_signal_info_unit_new_ARG_id.parent_struct,
  &_systemd1_manager_signal_info_unit_new_ARG_unit.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _systemd1_manager_signal_info_unit_new =
{
  {
    -1,
    (gchar *) "UnitNew",
    (GDBusArgInfo **) &_systemd1_manager_signal_info_unit_new_ARG_pointers,
    NULL
  },
  "unit-new"
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_unit_removed_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_unit_removed_ARG_unit =
{
  {
    -1,
    (gchar *) "unit",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_signal_info_unit_removed_ARG_pointers[] =
{
  &_systemd1_manager_signal_info_unit_removed_ARG_id.parent_struct,
  &_systemd1_manager_signal_info_unit_removed_ARG_unit.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _systemd1_manager_signal_info_unit_removed =
{
  {
    -1,
    (gchar *) "UnitRemoved",
    (GDBusArgInfo **) &_systemd1_manager_signal_info_unit_removed_ARG_pointers,
    NULL
  },
  "unit-removed"
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_job_new_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_job_new_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_job_new_ARG_unit =
{
  {
    -1,
    (gchar *) "unit",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_signal_info_job_new_ARG_pointers[] =
{
  &_systemd1_manager_signal_info_job_new_ARG_id.parent_struct,
  &_systemd1_manager_signal_info_job_new_ARG_job.parent_struct,
  &_systemd1_manager_signal_info_job_new_ARG_unit.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _systemd1_manager_signal_info_job_new =
{
  {
    -1,
    (gchar *) "JobNew",
    (GDBusArgInfo **) &_systemd1_manager_signal_info_job_new_ARG_pointers,
    NULL
  },
  "job-new"
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_job_removed_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_job_removed_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_job_removed_ARG_unit =
{
  {
    -1,
    (gchar *) "unit",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_job_removed_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_signal_info_job_removed_ARG_pointers[] =
{
  &_systemd1_manager_signal_info_job_removed_ARG_id.parent_struct,
  &_systemd1_manager_signal_info_job_removed_ARG_job.parent_struct,
  &_systemd1_manager_signal_info_job_removed_ARG_unit.parent_struct,
  &_systemd1_manager_signal_info_job_removed_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _systemd1_manager_signal_info_job_removed =
{
  {
    -1,
    (gchar *) "JobRemoved",
    (GDBusArgInfo **) &_systemd1_manager_signal_info_job_removed_ARG_pointers,
    NULL
  },
  "job-removed"
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_startup_finished_ARG_firmware =
{
  {
    -1,
    (gchar *) "firmware",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_startup_finished_ARG_loader =
{
  {
    -1,
    (gchar *) "loader",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_startup_finished_ARG_kernel =
{
  {
    -1,
    (gchar *) "kernel",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_startup_finished_ARG_initrd =
{
  {
    -1,
    (gchar *) "initrd",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_startup_finished_ARG_userspace =
{
  {
    -1,
    (gchar *) "userspace",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_startup_finished_ARG_total =
{
  {
    -1,
    (gchar *) "total",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_signal_info_startup_finished_ARG_pointers[] =
{
  &_systemd1_manager_signal_info_startup_finished_ARG_firmware.parent_struct,
  &_systemd1_manager_signal_info_startup_finished_ARG_loader.parent_struct,
  &_systemd1_manager_signal_info_startup_finished_ARG_kernel.parent_struct,
  &_systemd1_manager_signal_info_startup_finished_ARG_initrd.parent_struct,
  &_systemd1_manager_signal_info_startup_finished_ARG_userspace.parent_struct,
  &_systemd1_manager_signal_info_startup_finished_ARG_total.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _systemd1_manager_signal_info_startup_finished =
{
  {
    -1,
    (gchar *) "StartupFinished",
    (GDBusArgInfo **) &_systemd1_manager_signal_info_startup_finished_ARG_pointers,
    NULL
  },
  "startup-finished"
};

static const _ExtendedGDBusSignalInfo _systemd1_manager_signal_info_unit_files_changed =
{
  {
    -1,
    (gchar *) "UnitFilesChanged",
    NULL,
    NULL
  },
  "unit-files-changed"
};

static const _ExtendedGDBusArgInfo _systemd1_manager_signal_info_reloading_ARG_active =
{
  {
    -1,
    (gchar *) "active",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_manager_signal_info_reloading_ARG_pointers[] =
{
  &_systemd1_manager_signal_info_reloading_ARG_active.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _systemd1_manager_signal_info_reloading =
{
  {
    -1,
    (gchar *) "Reloading",
    (GDBusArgInfo **) &_systemd1_manager_signal_info_reloading_ARG_pointers,
    NULL
  },
  "reloading"
};

static const GDBusSignalInfo * const _systemd1_manager_signal_info_pointers[] =
{
  &_systemd1_manager_signal_info_unit_new.parent_struct,
  &_systemd1_manager_signal_info_unit_removed.parent_struct,
  &_systemd1_manager_signal_info_job_new.parent_struct,
  &_systemd1_manager_signal_info_job_removed.parent_struct,
  &_systemd1_manager_signal_info_startup_finished.parent_struct,
  &_systemd1_manager_signal_info_unit_files_changed.parent_struct,
  &_systemd1_manager_signal_info_reloading.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _systemd1_manager_property_version_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_version_annotation_info_pointers[] =
{
  &_systemd1_manager_property_version_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_version =
{
  {
    -1,
    (gchar *) "Version",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_version_annotation_info_pointers
  },
  "version",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_features_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_features_annotation_info_pointers[] =
{
  &_systemd1_manager_property_features_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_features =
{
  {
    -1,
    (gchar *) "Features",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_features_annotation_info_pointers
  },
  "features",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_virtualization_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_virtualization_annotation_info_pointers[] =
{
  &_systemd1_manager_property_virtualization_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_virtualization =
{
  {
    -1,
    (gchar *) "Virtualization",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_virtualization_annotation_info_pointers
  },
  "virtualization",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_architecture_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_architecture_annotation_info_pointers[] =
{
  &_systemd1_manager_property_architecture_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_architecture =
{
  {
    -1,
    (gchar *) "Architecture",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_architecture_annotation_info_pointers
  },
  "architecture",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_tainted_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_tainted_annotation_info_pointers[] =
{
  &_systemd1_manager_property_tainted_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_tainted =
{
  {
    -1,
    (gchar *) "Tainted",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_tainted_annotation_info_pointers
  },
  "tainted",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_firmware_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_firmware_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_firmware_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_firmware_timestamp =
{
  {
    -1,
    (gchar *) "FirmwareTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_firmware_timestamp_annotation_info_pointers
  },
  "firmware-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_firmware_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_firmware_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_firmware_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_firmware_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "FirmwareTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_firmware_timestamp_monotonic_annotation_info_pointers
  },
  "firmware-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_loader_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_loader_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_loader_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_loader_timestamp =
{
  {
    -1,
    (gchar *) "LoaderTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_loader_timestamp_annotation_info_pointers
  },
  "loader-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_loader_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_loader_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_loader_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_loader_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "LoaderTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_loader_timestamp_monotonic_annotation_info_pointers
  },
  "loader-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_kernel_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_kernel_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_kernel_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_kernel_timestamp =
{
  {
    -1,
    (gchar *) "KernelTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_kernel_timestamp_annotation_info_pointers
  },
  "kernel-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_kernel_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_kernel_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_kernel_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_kernel_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "KernelTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_kernel_timestamp_monotonic_annotation_info_pointers
  },
  "kernel-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_init_rdtimestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_init_rdtimestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_init_rdtimestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_init_rdtimestamp =
{
  {
    -1,
    (gchar *) "InitRDTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_init_rdtimestamp_annotation_info_pointers
  },
  "init-rdtimestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_init_rdtimestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_init_rdtimestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_init_rdtimestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_init_rdtimestamp_monotonic =
{
  {
    -1,
    (gchar *) "InitRDTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_init_rdtimestamp_monotonic_annotation_info_pointers
  },
  "init-rdtimestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_userspace_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_userspace_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_userspace_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_userspace_timestamp =
{
  {
    -1,
    (gchar *) "UserspaceTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_userspace_timestamp_annotation_info_pointers
  },
  "userspace-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_userspace_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_userspace_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_userspace_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_userspace_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "UserspaceTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_userspace_timestamp_monotonic_annotation_info_pointers
  },
  "userspace-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_finish_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_finish_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_finish_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_finish_timestamp =
{
  {
    -1,
    (gchar *) "FinishTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_finish_timestamp_annotation_info_pointers
  },
  "finish-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_finish_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_finish_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_finish_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_finish_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "FinishTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_finish_timestamp_monotonic_annotation_info_pointers
  },
  "finish-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_security_start_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_security_start_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_security_start_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_security_start_timestamp =
{
  {
    -1,
    (gchar *) "SecurityStartTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_security_start_timestamp_annotation_info_pointers
  },
  "security-start-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_security_start_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_security_start_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_security_start_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_security_start_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "SecurityStartTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_security_start_timestamp_monotonic_annotation_info_pointers
  },
  "security-start-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_security_finish_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_security_finish_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_security_finish_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_security_finish_timestamp =
{
  {
    -1,
    (gchar *) "SecurityFinishTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_security_finish_timestamp_annotation_info_pointers
  },
  "security-finish-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_security_finish_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_security_finish_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_security_finish_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_security_finish_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "SecurityFinishTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_security_finish_timestamp_monotonic_annotation_info_pointers
  },
  "security-finish-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_generators_start_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_generators_start_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_generators_start_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_generators_start_timestamp =
{
  {
    -1,
    (gchar *) "GeneratorsStartTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_generators_start_timestamp_annotation_info_pointers
  },
  "generators-start-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_generators_start_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_generators_start_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_generators_start_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_generators_start_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "GeneratorsStartTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_generators_start_timestamp_monotonic_annotation_info_pointers
  },
  "generators-start-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_generators_finish_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_generators_finish_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_generators_finish_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_generators_finish_timestamp =
{
  {
    -1,
    (gchar *) "GeneratorsFinishTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_generators_finish_timestamp_annotation_info_pointers
  },
  "generators-finish-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_generators_finish_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_generators_finish_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_generators_finish_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_generators_finish_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "GeneratorsFinishTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_generators_finish_timestamp_monotonic_annotation_info_pointers
  },
  "generators-finish-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_units_load_start_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_units_load_start_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_units_load_start_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_units_load_start_timestamp =
{
  {
    -1,
    (gchar *) "UnitsLoadStartTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_units_load_start_timestamp_annotation_info_pointers
  },
  "units-load-start-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_units_load_start_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_units_load_start_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_units_load_start_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_units_load_start_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "UnitsLoadStartTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_units_load_start_timestamp_monotonic_annotation_info_pointers
  },
  "units-load-start-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_units_load_finish_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_units_load_finish_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_units_load_finish_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_units_load_finish_timestamp =
{
  {
    -1,
    (gchar *) "UnitsLoadFinishTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_units_load_finish_timestamp_annotation_info_pointers
  },
  "units-load-finish-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_units_load_finish_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_units_load_finish_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_units_load_finish_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_units_load_finish_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "UnitsLoadFinishTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_units_load_finish_timestamp_monotonic_annotation_info_pointers
  },
  "units-load-finish-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_init_rdsecurity_start_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_init_rdsecurity_start_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_init_rdsecurity_start_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_init_rdsecurity_start_timestamp =
{
  {
    -1,
    (gchar *) "InitRDSecurityStartTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_init_rdsecurity_start_timestamp_annotation_info_pointers
  },
  "init-rdsecurity-start-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_init_rdsecurity_start_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_init_rdsecurity_start_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_init_rdsecurity_start_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_init_rdsecurity_start_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "InitRDSecurityStartTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_init_rdsecurity_start_timestamp_monotonic_annotation_info_pointers
  },
  "init-rdsecurity-start-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_init_rdsecurity_finish_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_init_rdsecurity_finish_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_init_rdsecurity_finish_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_init_rdsecurity_finish_timestamp =
{
  {
    -1,
    (gchar *) "InitRDSecurityFinishTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_init_rdsecurity_finish_timestamp_annotation_info_pointers
  },
  "init-rdsecurity-finish-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_init_rdsecurity_finish_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_init_rdsecurity_finish_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_init_rdsecurity_finish_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_init_rdsecurity_finish_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "InitRDSecurityFinishTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_init_rdsecurity_finish_timestamp_monotonic_annotation_info_pointers
  },
  "init-rdsecurity-finish-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_init_rdgenerators_start_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_init_rdgenerators_start_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_init_rdgenerators_start_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_init_rdgenerators_start_timestamp =
{
  {
    -1,
    (gchar *) "InitRDGeneratorsStartTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_init_rdgenerators_start_timestamp_annotation_info_pointers
  },
  "init-rdgenerators-start-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_init_rdgenerators_start_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_init_rdgenerators_start_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_init_rdgenerators_start_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_init_rdgenerators_start_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "InitRDGeneratorsStartTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_init_rdgenerators_start_timestamp_monotonic_annotation_info_pointers
  },
  "init-rdgenerators-start-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_init_rdgenerators_finish_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_init_rdgenerators_finish_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_init_rdgenerators_finish_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_init_rdgenerators_finish_timestamp =
{
  {
    -1,
    (gchar *) "InitRDGeneratorsFinishTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_init_rdgenerators_finish_timestamp_annotation_info_pointers
  },
  "init-rdgenerators-finish-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_init_rdgenerators_finish_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_init_rdgenerators_finish_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_init_rdgenerators_finish_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_init_rdgenerators_finish_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "InitRDGeneratorsFinishTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_init_rdgenerators_finish_timestamp_monotonic_annotation_info_pointers
  },
  "init-rdgenerators-finish-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_init_rdunits_load_start_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_init_rdunits_load_start_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_init_rdunits_load_start_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_init_rdunits_load_start_timestamp =
{
  {
    -1,
    (gchar *) "InitRDUnitsLoadStartTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_init_rdunits_load_start_timestamp_annotation_info_pointers
  },
  "init-rdunits-load-start-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_init_rdunits_load_start_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_init_rdunits_load_start_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_init_rdunits_load_start_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_init_rdunits_load_start_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "InitRDUnitsLoadStartTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_init_rdunits_load_start_timestamp_monotonic_annotation_info_pointers
  },
  "init-rdunits-load-start-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_init_rdunits_load_finish_timestamp_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_init_rdunits_load_finish_timestamp_annotation_info_pointers[] =
{
  &_systemd1_manager_property_init_rdunits_load_finish_timestamp_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_init_rdunits_load_finish_timestamp =
{
  {
    -1,
    (gchar *) "InitRDUnitsLoadFinishTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_init_rdunits_load_finish_timestamp_annotation_info_pointers
  },
  "init-rdunits-load-finish-timestamp",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_init_rdunits_load_finish_timestamp_monotonic_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_init_rdunits_load_finish_timestamp_monotonic_annotation_info_pointers[] =
{
  &_systemd1_manager_property_init_rdunits_load_finish_timestamp_monotonic_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_init_rdunits_load_finish_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "InitRDUnitsLoadFinishTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_init_rdunits_load_finish_timestamp_monotonic_annotation_info_pointers
  },
  "init-rdunits-load-finish-timestamp-monotonic",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_log_level_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo _systemd1_manager_property_log_level_annotation_info_1 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_log_level_annotation_info_pointers[] =
{
  &_systemd1_manager_property_log_level_annotation_info_0,
  &_systemd1_manager_property_log_level_annotation_info_1,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_log_level =
{
  {
    -1,
    (gchar *) "LogLevel",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_log_level_annotation_info_pointers
  },
  "log-level",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_log_target_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo _systemd1_manager_property_log_target_annotation_info_1 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_log_target_annotation_info_pointers[] =
{
  &_systemd1_manager_property_log_target_annotation_info_0,
  &_systemd1_manager_property_log_target_annotation_info_1,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_log_target =
{
  {
    -1,
    (gchar *) "LogTarget",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_log_target_annotation_info_pointers
  },
  "log-target",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_nnames_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_nnames_annotation_info_pointers[] =
{
  &_systemd1_manager_property_nnames_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_nnames =
{
  {
    -1,
    (gchar *) "NNames",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_nnames_annotation_info_pointers
  },
  "nnames",
  FALSE,
  FALSE
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_nfailed_units =
{
  {
    -1,
    (gchar *) "NFailedUnits",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "nfailed-units",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _systemd1_manager_property_njobs_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_njobs_annotation_info_pointers[] =
{
  &_systemd1_manager_property_njobs_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_njobs =
{
  {
    -1,
    (gchar *) "NJobs",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_njobs_annotation_info_pointers
  },
  "njobs",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_ninstalled_jobs_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_ninstalled_jobs_annotation_info_pointers[] =
{
  &_systemd1_manager_property_ninstalled_jobs_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_ninstalled_jobs =
{
  {
    -1,
    (gchar *) "NInstalledJobs",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_ninstalled_jobs_annotation_info_pointers
  },
  "ninstalled-jobs",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_nfailed_jobs_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_nfailed_jobs_annotation_info_pointers[] =
{
  &_systemd1_manager_property_nfailed_jobs_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_nfailed_jobs =
{
  {
    -1,
    (gchar *) "NFailedJobs",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_nfailed_jobs_annotation_info_pointers
  },
  "nfailed-jobs",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_progress_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_progress_annotation_info_pointers[] =
{
  &_systemd1_manager_property_progress_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_progress =
{
  {
    -1,
    (gchar *) "Progress",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_progress_annotation_info_pointers
  },
  "progress",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_environment_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_environment_annotation_info_pointers[] =
{
  &_systemd1_manager_property_environment_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_environment =
{
  {
    -1,
    (gchar *) "Environment",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_environment_annotation_info_pointers
  },
  "environment",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_confirm_spawn_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_confirm_spawn_annotation_info_pointers[] =
{
  &_systemd1_manager_property_confirm_spawn_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_confirm_spawn =
{
  {
    -1,
    (gchar *) "ConfirmSpawn",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_confirm_spawn_annotation_info_pointers
  },
  "confirm-spawn",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_show_status_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_show_status_annotation_info_pointers[] =
{
  &_systemd1_manager_property_show_status_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_show_status =
{
  {
    -1,
    (gchar *) "ShowStatus",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_show_status_annotation_info_pointers
  },
  "show-status",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_unit_path_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_unit_path_annotation_info_pointers[] =
{
  &_systemd1_manager_property_unit_path_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_unit_path =
{
  {
    -1,
    (gchar *) "UnitPath",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_unit_path_annotation_info_pointers
  },
  "unit-path",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_standard_output_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_standard_output_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_standard_output_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_standard_output =
{
  {
    -1,
    (gchar *) "DefaultStandardOutput",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_standard_output_annotation_info_pointers
  },
  "default-standard-output",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_standard_error_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_standard_error_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_standard_error_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_standard_error =
{
  {
    -1,
    (gchar *) "DefaultStandardError",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_standard_error_annotation_info_pointers
  },
  "default-standard-error",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_runtime_watchdog_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo _systemd1_manager_property_runtime_watchdog_usec_annotation_info_1 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_runtime_watchdog_usec_annotation_info_pointers[] =
{
  &_systemd1_manager_property_runtime_watchdog_usec_annotation_info_0,
  &_systemd1_manager_property_runtime_watchdog_usec_annotation_info_1,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_runtime_watchdog_usec =
{
  {
    -1,
    (gchar *) "RuntimeWatchdogUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_runtime_watchdog_usec_annotation_info_pointers
  },
  "runtime-watchdog-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_reboot_watchdog_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo _systemd1_manager_property_reboot_watchdog_usec_annotation_info_1 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_reboot_watchdog_usec_annotation_info_pointers[] =
{
  &_systemd1_manager_property_reboot_watchdog_usec_annotation_info_0,
  &_systemd1_manager_property_reboot_watchdog_usec_annotation_info_1,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_reboot_watchdog_usec =
{
  {
    -1,
    (gchar *) "RebootWatchdogUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_reboot_watchdog_usec_annotation_info_pointers
  },
  "reboot-watchdog-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_kexec_watchdog_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo _systemd1_manager_property_kexec_watchdog_usec_annotation_info_1 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_kexec_watchdog_usec_annotation_info_pointers[] =
{
  &_systemd1_manager_property_kexec_watchdog_usec_annotation_info_0,
  &_systemd1_manager_property_kexec_watchdog_usec_annotation_info_1,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_kexec_watchdog_usec =
{
  {
    -1,
    (gchar *) "KExecWatchdogUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_kexec_watchdog_usec_annotation_info_pointers
  },
  "kexec-watchdog-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_service_watchdogs_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo _systemd1_manager_property_service_watchdogs_annotation_info_1 =
{
  -1,
  (gchar *) "org.freedesktop.systemd1.Privileged",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_service_watchdogs_annotation_info_pointers[] =
{
  &_systemd1_manager_property_service_watchdogs_annotation_info_0,
  &_systemd1_manager_property_service_watchdogs_annotation_info_1,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_service_watchdogs =
{
  {
    -1,
    (gchar *) "ServiceWatchdogs",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_service_watchdogs_annotation_info_pointers
  },
  "service-watchdogs",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_control_group_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_control_group_annotation_info_pointers[] =
{
  &_systemd1_manager_property_control_group_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_control_group =
{
  {
    -1,
    (gchar *) "ControlGroup",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_control_group_annotation_info_pointers
  },
  "control-group",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_system_state_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_system_state_annotation_info_pointers[] =
{
  &_systemd1_manager_property_system_state_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_system_state =
{
  {
    -1,
    (gchar *) "SystemState",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_system_state_annotation_info_pointers
  },
  "system-state",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_exit_code_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_exit_code_annotation_info_pointers[] =
{
  &_systemd1_manager_property_exit_code_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_exit_code =
{
  {
    -1,
    (gchar *) "ExitCode",
    (gchar *) "y",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_exit_code_annotation_info_pointers
  },
  "exit-code",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_timer_accuracy_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_timer_accuracy_usec_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_timer_accuracy_usec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_timer_accuracy_usec =
{
  {
    -1,
    (gchar *) "DefaultTimerAccuracyUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_timer_accuracy_usec_annotation_info_pointers
  },
  "default-timer-accuracy-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_timeout_start_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_timeout_start_usec_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_timeout_start_usec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_timeout_start_usec =
{
  {
    -1,
    (gchar *) "DefaultTimeoutStartUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_timeout_start_usec_annotation_info_pointers
  },
  "default-timeout-start-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_timeout_stop_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_timeout_stop_usec_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_timeout_stop_usec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_timeout_stop_usec =
{
  {
    -1,
    (gchar *) "DefaultTimeoutStopUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_timeout_stop_usec_annotation_info_pointers
  },
  "default-timeout-stop-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_timeout_abort_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_timeout_abort_usec_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_timeout_abort_usec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_timeout_abort_usec =
{
  {
    -1,
    (gchar *) "DefaultTimeoutAbortUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_timeout_abort_usec_annotation_info_pointers
  },
  "default-timeout-abort-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_restart_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_restart_usec_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_restart_usec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_restart_usec =
{
  {
    -1,
    (gchar *) "DefaultRestartUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_restart_usec_annotation_info_pointers
  },
  "default-restart-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_start_limit_interval_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_start_limit_interval_usec_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_start_limit_interval_usec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_start_limit_interval_usec =
{
  {
    -1,
    (gchar *) "DefaultStartLimitIntervalUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_start_limit_interval_usec_annotation_info_pointers
  },
  "default-start-limit-interval-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_start_limit_burst_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_start_limit_burst_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_start_limit_burst_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_start_limit_burst =
{
  {
    -1,
    (gchar *) "DefaultStartLimitBurst",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_start_limit_burst_annotation_info_pointers
  },
  "default-start-limit-burst",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_cpuaccounting_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_cpuaccounting_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_cpuaccounting_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_cpuaccounting =
{
  {
    -1,
    (gchar *) "DefaultCPUAccounting",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_cpuaccounting_annotation_info_pointers
  },
  "default-cpuaccounting",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_block_ioaccounting_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_block_ioaccounting_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_block_ioaccounting_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_block_ioaccounting =
{
  {
    -1,
    (gchar *) "DefaultBlockIOAccounting",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_block_ioaccounting_annotation_info_pointers
  },
  "default-block-ioaccounting",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_memory_accounting_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_memory_accounting_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_memory_accounting_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_memory_accounting =
{
  {
    -1,
    (gchar *) "DefaultMemoryAccounting",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_memory_accounting_annotation_info_pointers
  },
  "default-memory-accounting",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_tasks_accounting_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_tasks_accounting_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_tasks_accounting_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_tasks_accounting =
{
  {
    -1,
    (gchar *) "DefaultTasksAccounting",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_tasks_accounting_annotation_info_pointers
  },
  "default-tasks-accounting",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_cpu_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_cpu_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_cpu_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_cpu =
{
  {
    -1,
    (gchar *) "DefaultLimitCPU",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_cpu_annotation_info_pointers
  },
  "default-limit-cpu",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_cpusoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_cpusoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_cpusoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_cpusoft =
{
  {
    -1,
    (gchar *) "DefaultLimitCPUSoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_cpusoft_annotation_info_pointers
  },
  "default-limit-cpusoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_fsize_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_fsize_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_fsize_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_fsize =
{
  {
    -1,
    (gchar *) "DefaultLimitFSIZE",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_fsize_annotation_info_pointers
  },
  "default-limit-fsize",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_fsizesoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_fsizesoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_fsizesoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_fsizesoft =
{
  {
    -1,
    (gchar *) "DefaultLimitFSIZESoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_fsizesoft_annotation_info_pointers
  },
  "default-limit-fsizesoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_data_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_data_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_data_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_data =
{
  {
    -1,
    (gchar *) "DefaultLimitDATA",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_data_annotation_info_pointers
  },
  "default-limit-data",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_datasoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_datasoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_datasoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_datasoft =
{
  {
    -1,
    (gchar *) "DefaultLimitDATASoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_datasoft_annotation_info_pointers
  },
  "default-limit-datasoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_stack_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_stack_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_stack_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_stack =
{
  {
    -1,
    (gchar *) "DefaultLimitSTACK",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_stack_annotation_info_pointers
  },
  "default-limit-stack",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_stacksoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_stacksoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_stacksoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_stacksoft =
{
  {
    -1,
    (gchar *) "DefaultLimitSTACKSoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_stacksoft_annotation_info_pointers
  },
  "default-limit-stacksoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_core_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_core_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_core_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_core =
{
  {
    -1,
    (gchar *) "DefaultLimitCORE",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_core_annotation_info_pointers
  },
  "default-limit-core",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_coresoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_coresoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_coresoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_coresoft =
{
  {
    -1,
    (gchar *) "DefaultLimitCORESoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_coresoft_annotation_info_pointers
  },
  "default-limit-coresoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_rss_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_rss_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_rss_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_rss =
{
  {
    -1,
    (gchar *) "DefaultLimitRSS",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_rss_annotation_info_pointers
  },
  "default-limit-rss",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_rsssoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_rsssoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_rsssoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_rsssoft =
{
  {
    -1,
    (gchar *) "DefaultLimitRSSSoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_rsssoft_annotation_info_pointers
  },
  "default-limit-rsssoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_nofile_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_nofile_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_nofile_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_nofile =
{
  {
    -1,
    (gchar *) "DefaultLimitNOFILE",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_nofile_annotation_info_pointers
  },
  "default-limit-nofile",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_nofilesoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_nofilesoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_nofilesoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_nofilesoft =
{
  {
    -1,
    (gchar *) "DefaultLimitNOFILESoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_nofilesoft_annotation_info_pointers
  },
  "default-limit-nofilesoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_as_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_as_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_as_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_as =
{
  {
    -1,
    (gchar *) "DefaultLimitAS",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_as_annotation_info_pointers
  },
  "default-limit-as",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_assoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_assoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_assoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_assoft =
{
  {
    -1,
    (gchar *) "DefaultLimitASSoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_assoft_annotation_info_pointers
  },
  "default-limit-assoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_nproc_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_nproc_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_nproc_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_nproc =
{
  {
    -1,
    (gchar *) "DefaultLimitNPROC",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_nproc_annotation_info_pointers
  },
  "default-limit-nproc",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_nprocsoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_nprocsoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_nprocsoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_nprocsoft =
{
  {
    -1,
    (gchar *) "DefaultLimitNPROCSoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_nprocsoft_annotation_info_pointers
  },
  "default-limit-nprocsoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_memlock_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_memlock_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_memlock_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_memlock =
{
  {
    -1,
    (gchar *) "DefaultLimitMEMLOCK",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_memlock_annotation_info_pointers
  },
  "default-limit-memlock",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_memlocksoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_memlocksoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_memlocksoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_memlocksoft =
{
  {
    -1,
    (gchar *) "DefaultLimitMEMLOCKSoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_memlocksoft_annotation_info_pointers
  },
  "default-limit-memlocksoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_locks_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_locks_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_locks_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_locks =
{
  {
    -1,
    (gchar *) "DefaultLimitLOCKS",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_locks_annotation_info_pointers
  },
  "default-limit-locks",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_lockssoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_lockssoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_lockssoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_lockssoft =
{
  {
    -1,
    (gchar *) "DefaultLimitLOCKSSoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_lockssoft_annotation_info_pointers
  },
  "default-limit-lockssoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_sigpending_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_sigpending_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_sigpending_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_sigpending =
{
  {
    -1,
    (gchar *) "DefaultLimitSIGPENDING",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_sigpending_annotation_info_pointers
  },
  "default-limit-sigpending",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_sigpendingsoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_sigpendingsoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_sigpendingsoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_sigpendingsoft =
{
  {
    -1,
    (gchar *) "DefaultLimitSIGPENDINGSoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_sigpendingsoft_annotation_info_pointers
  },
  "default-limit-sigpendingsoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_msgqueue_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_msgqueue_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_msgqueue_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_msgqueue =
{
  {
    -1,
    (gchar *) "DefaultLimitMSGQUEUE",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_msgqueue_annotation_info_pointers
  },
  "default-limit-msgqueue",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_msgqueuesoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_msgqueuesoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_msgqueuesoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_msgqueuesoft =
{
  {
    -1,
    (gchar *) "DefaultLimitMSGQUEUESoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_msgqueuesoft_annotation_info_pointers
  },
  "default-limit-msgqueuesoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_nice_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_nice_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_nice_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_nice =
{
  {
    -1,
    (gchar *) "DefaultLimitNICE",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_nice_annotation_info_pointers
  },
  "default-limit-nice",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_nicesoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_nicesoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_nicesoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_nicesoft =
{
  {
    -1,
    (gchar *) "DefaultLimitNICESoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_nicesoft_annotation_info_pointers
  },
  "default-limit-nicesoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_rtprio_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_rtprio_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_rtprio_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_rtprio =
{
  {
    -1,
    (gchar *) "DefaultLimitRTPRIO",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_rtprio_annotation_info_pointers
  },
  "default-limit-rtprio",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_rtpriosoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_rtpriosoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_rtpriosoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_rtpriosoft =
{
  {
    -1,
    (gchar *) "DefaultLimitRTPRIOSoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_rtpriosoft_annotation_info_pointers
  },
  "default-limit-rtpriosoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_rttime_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_rttime_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_rttime_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_rttime =
{
  {
    -1,
    (gchar *) "DefaultLimitRTTIME",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_rttime_annotation_info_pointers
  },
  "default-limit-rttime",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_limit_rttimesoft_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_limit_rttimesoft_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_limit_rttimesoft_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_limit_rttimesoft =
{
  {
    -1,
    (gchar *) "DefaultLimitRTTIMESoft",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_limit_rttimesoft_annotation_info_pointers
  },
  "default-limit-rttimesoft",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_tasks_max_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_tasks_max_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_tasks_max_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_tasks_max =
{
  {
    -1,
    (gchar *) "DefaultTasksMax",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_tasks_max_annotation_info_pointers
  },
  "default-tasks-max",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_timer_slack_nsec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_timer_slack_nsec_annotation_info_pointers[] =
{
  &_systemd1_manager_property_timer_slack_nsec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_timer_slack_nsec =
{
  {
    -1,
    (gchar *) "TimerSlackNSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_timer_slack_nsec_annotation_info_pointers
  },
  "timer-slack-nsec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_default_oompolicy_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_default_oompolicy_annotation_info_pointers[] =
{
  &_systemd1_manager_property_default_oompolicy_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_default_oompolicy =
{
  {
    -1,
    (gchar *) "DefaultOOMPolicy",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_default_oompolicy_annotation_info_pointers
  },
  "default-oompolicy",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_manager_property_ctrl_alt_del_burst_action_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_manager_property_ctrl_alt_del_burst_action_annotation_info_pointers[] =
{
  &_systemd1_manager_property_ctrl_alt_del_burst_action_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_manager_property_info_ctrl_alt_del_burst_action =
{
  {
    -1,
    (gchar *) "CtrlAltDelBurstAction",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_manager_property_ctrl_alt_del_burst_action_annotation_info_pointers
  },
  "ctrl-alt-del-burst-action",
  FALSE,
  FALSE
};

static const GDBusPropertyInfo * const _systemd1_manager_property_info_pointers[] =
{
  &_systemd1_manager_property_info_version.parent_struct,
  &_systemd1_manager_property_info_features.parent_struct,
  &_systemd1_manager_property_info_virtualization.parent_struct,
  &_systemd1_manager_property_info_architecture.parent_struct,
  &_systemd1_manager_property_info_tainted.parent_struct,
  &_systemd1_manager_property_info_firmware_timestamp.parent_struct,
  &_systemd1_manager_property_info_firmware_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_loader_timestamp.parent_struct,
  &_systemd1_manager_property_info_loader_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_kernel_timestamp.parent_struct,
  &_systemd1_manager_property_info_kernel_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_init_rdtimestamp.parent_struct,
  &_systemd1_manager_property_info_init_rdtimestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_userspace_timestamp.parent_struct,
  &_systemd1_manager_property_info_userspace_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_finish_timestamp.parent_struct,
  &_systemd1_manager_property_info_finish_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_security_start_timestamp.parent_struct,
  &_systemd1_manager_property_info_security_start_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_security_finish_timestamp.parent_struct,
  &_systemd1_manager_property_info_security_finish_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_generators_start_timestamp.parent_struct,
  &_systemd1_manager_property_info_generators_start_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_generators_finish_timestamp.parent_struct,
  &_systemd1_manager_property_info_generators_finish_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_units_load_start_timestamp.parent_struct,
  &_systemd1_manager_property_info_units_load_start_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_units_load_finish_timestamp.parent_struct,
  &_systemd1_manager_property_info_units_load_finish_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_init_rdsecurity_start_timestamp.parent_struct,
  &_systemd1_manager_property_info_init_rdsecurity_start_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_init_rdsecurity_finish_timestamp.parent_struct,
  &_systemd1_manager_property_info_init_rdsecurity_finish_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_init_rdgenerators_start_timestamp.parent_struct,
  &_systemd1_manager_property_info_init_rdgenerators_start_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_init_rdgenerators_finish_timestamp.parent_struct,
  &_systemd1_manager_property_info_init_rdgenerators_finish_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_init_rdunits_load_start_timestamp.parent_struct,
  &_systemd1_manager_property_info_init_rdunits_load_start_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_init_rdunits_load_finish_timestamp.parent_struct,
  &_systemd1_manager_property_info_init_rdunits_load_finish_timestamp_monotonic.parent_struct,
  &_systemd1_manager_property_info_log_level.parent_struct,
  &_systemd1_manager_property_info_log_target.parent_struct,
  &_systemd1_manager_property_info_nnames.parent_struct,
  &_systemd1_manager_property_info_nfailed_units.parent_struct,
  &_systemd1_manager_property_info_njobs.parent_struct,
  &_systemd1_manager_property_info_ninstalled_jobs.parent_struct,
  &_systemd1_manager_property_info_nfailed_jobs.parent_struct,
  &_systemd1_manager_property_info_progress.parent_struct,
  &_systemd1_manager_property_info_environment.parent_struct,
  &_systemd1_manager_property_info_confirm_spawn.parent_struct,
  &_systemd1_manager_property_info_show_status.parent_struct,
  &_systemd1_manager_property_info_unit_path.parent_struct,
  &_systemd1_manager_property_info_default_standard_output.parent_struct,
  &_systemd1_manager_property_info_default_standard_error.parent_struct,
  &_systemd1_manager_property_info_runtime_watchdog_usec.parent_struct,
  &_systemd1_manager_property_info_reboot_watchdog_usec.parent_struct,
  &_systemd1_manager_property_info_kexec_watchdog_usec.parent_struct,
  &_systemd1_manager_property_info_service_watchdogs.parent_struct,
  &_systemd1_manager_property_info_control_group.parent_struct,
  &_systemd1_manager_property_info_system_state.parent_struct,
  &_systemd1_manager_property_info_exit_code.parent_struct,
  &_systemd1_manager_property_info_default_timer_accuracy_usec.parent_struct,
  &_systemd1_manager_property_info_default_timeout_start_usec.parent_struct,
  &_systemd1_manager_property_info_default_timeout_stop_usec.parent_struct,
  &_systemd1_manager_property_info_default_timeout_abort_usec.parent_struct,
  &_systemd1_manager_property_info_default_restart_usec.parent_struct,
  &_systemd1_manager_property_info_default_start_limit_interval_usec.parent_struct,
  &_systemd1_manager_property_info_default_start_limit_burst.parent_struct,
  &_systemd1_manager_property_info_default_cpuaccounting.parent_struct,
  &_systemd1_manager_property_info_default_block_ioaccounting.parent_struct,
  &_systemd1_manager_property_info_default_memory_accounting.parent_struct,
  &_systemd1_manager_property_info_default_tasks_accounting.parent_struct,
  &_systemd1_manager_property_info_default_limit_cpu.parent_struct,
  &_systemd1_manager_property_info_default_limit_cpusoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_fsize.parent_struct,
  &_systemd1_manager_property_info_default_limit_fsizesoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_data.parent_struct,
  &_systemd1_manager_property_info_default_limit_datasoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_stack.parent_struct,
  &_systemd1_manager_property_info_default_limit_stacksoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_core.parent_struct,
  &_systemd1_manager_property_info_default_limit_coresoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_rss.parent_struct,
  &_systemd1_manager_property_info_default_limit_rsssoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_nofile.parent_struct,
  &_systemd1_manager_property_info_default_limit_nofilesoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_as.parent_struct,
  &_systemd1_manager_property_info_default_limit_assoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_nproc.parent_struct,
  &_systemd1_manager_property_info_default_limit_nprocsoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_memlock.parent_struct,
  &_systemd1_manager_property_info_default_limit_memlocksoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_locks.parent_struct,
  &_systemd1_manager_property_info_default_limit_lockssoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_sigpending.parent_struct,
  &_systemd1_manager_property_info_default_limit_sigpendingsoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_msgqueue.parent_struct,
  &_systemd1_manager_property_info_default_limit_msgqueuesoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_nice.parent_struct,
  &_systemd1_manager_property_info_default_limit_nicesoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_rtprio.parent_struct,
  &_systemd1_manager_property_info_default_limit_rtpriosoft.parent_struct,
  &_systemd1_manager_property_info_default_limit_rttime.parent_struct,
  &_systemd1_manager_property_info_default_limit_rttimesoft.parent_struct,
  &_systemd1_manager_property_info_default_tasks_max.parent_struct,
  &_systemd1_manager_property_info_timer_slack_nsec.parent_struct,
  &_systemd1_manager_property_info_default_oompolicy.parent_struct,
  &_systemd1_manager_property_info_ctrl_alt_del_burst_action.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _systemd1_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.systemd1.Manager",
    (GDBusMethodInfo **) &_systemd1_manager_method_info_pointers,
    (GDBusSignalInfo **) &_systemd1_manager_signal_info_pointers,
    (GDBusPropertyInfo **) &_systemd1_manager_property_info_pointers,
    NULL
  },
  "systemd1-manager",
};


/**
 * systemd1_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-systemd1-Manager.top_of_page">org.freedesktop.systemd1.Manager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
systemd1_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_systemd1_manager_interface_info.parent_struct;
}

/**
 * systemd1_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #Systemd1Manager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
systemd1_manager_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  g_object_class_override_property (klass, property_id_begin++, "features");
  g_object_class_override_property (klass, property_id_begin++, "virtualization");
  g_object_class_override_property (klass, property_id_begin++, "architecture");
  g_object_class_override_property (klass, property_id_begin++, "tainted");
  g_object_class_override_property (klass, property_id_begin++, "firmware-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "firmware-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "loader-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "loader-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "kernel-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "kernel-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "init-rdtimestamp");
  g_object_class_override_property (klass, property_id_begin++, "init-rdtimestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "userspace-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "userspace-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "finish-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "finish-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "security-start-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "security-start-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "security-finish-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "security-finish-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "generators-start-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "generators-start-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "generators-finish-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "generators-finish-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "units-load-start-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "units-load-start-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "units-load-finish-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "units-load-finish-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "init-rdsecurity-start-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "init-rdsecurity-start-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "init-rdsecurity-finish-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "init-rdsecurity-finish-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "init-rdgenerators-start-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "init-rdgenerators-start-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "init-rdgenerators-finish-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "init-rdgenerators-finish-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "init-rdunits-load-start-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "init-rdunits-load-start-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "init-rdunits-load-finish-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "init-rdunits-load-finish-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "log-level");
  g_object_class_override_property (klass, property_id_begin++, "log-target");
  g_object_class_override_property (klass, property_id_begin++, "nnames");
  g_object_class_override_property (klass, property_id_begin++, "nfailed-units");
  g_object_class_override_property (klass, property_id_begin++, "njobs");
  g_object_class_override_property (klass, property_id_begin++, "ninstalled-jobs");
  g_object_class_override_property (klass, property_id_begin++, "nfailed-jobs");
  g_object_class_override_property (klass, property_id_begin++, "progress");
  g_object_class_override_property (klass, property_id_begin++, "environment");
  g_object_class_override_property (klass, property_id_begin++, "confirm-spawn");
  g_object_class_override_property (klass, property_id_begin++, "show-status");
  g_object_class_override_property (klass, property_id_begin++, "unit-path");
  g_object_class_override_property (klass, property_id_begin++, "default-standard-output");
  g_object_class_override_property (klass, property_id_begin++, "default-standard-error");
  g_object_class_override_property (klass, property_id_begin++, "runtime-watchdog-usec");
  g_object_class_override_property (klass, property_id_begin++, "reboot-watchdog-usec");
  g_object_class_override_property (klass, property_id_begin++, "kexec-watchdog-usec");
  g_object_class_override_property (klass, property_id_begin++, "service-watchdogs");
  g_object_class_override_property (klass, property_id_begin++, "control-group");
  g_object_class_override_property (klass, property_id_begin++, "system-state");
  g_object_class_override_property (klass, property_id_begin++, "exit-code");
  g_object_class_override_property (klass, property_id_begin++, "default-timer-accuracy-usec");
  g_object_class_override_property (klass, property_id_begin++, "default-timeout-start-usec");
  g_object_class_override_property (klass, property_id_begin++, "default-timeout-stop-usec");
  g_object_class_override_property (klass, property_id_begin++, "default-timeout-abort-usec");
  g_object_class_override_property (klass, property_id_begin++, "default-restart-usec");
  g_object_class_override_property (klass, property_id_begin++, "default-start-limit-interval-usec");
  g_object_class_override_property (klass, property_id_begin++, "default-start-limit-burst");
  g_object_class_override_property (klass, property_id_begin++, "default-cpuaccounting");
  g_object_class_override_property (klass, property_id_begin++, "default-block-ioaccounting");
  g_object_class_override_property (klass, property_id_begin++, "default-memory-accounting");
  g_object_class_override_property (klass, property_id_begin++, "default-tasks-accounting");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-cpu");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-cpusoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-fsize");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-fsizesoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-data");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-datasoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-stack");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-stacksoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-core");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-coresoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-rss");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-rsssoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-nofile");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-nofilesoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-as");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-assoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-nproc");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-nprocsoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-memlock");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-memlocksoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-locks");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-lockssoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-sigpending");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-sigpendingsoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-msgqueue");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-msgqueuesoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-nice");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-nicesoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-rtprio");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-rtpriosoft");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-rttime");
  g_object_class_override_property (klass, property_id_begin++, "default-limit-rttimesoft");
  g_object_class_override_property (klass, property_id_begin++, "default-tasks-max");
  g_object_class_override_property (klass, property_id_begin++, "timer-slack-nsec");
  g_object_class_override_property (klass, property_id_begin++, "default-oompolicy");
  g_object_class_override_property (klass, property_id_begin++, "ctrl-alt-del-burst-action");
  return property_id_begin - 1;
}



/**
 * Systemd1Manager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-systemd1-Manager.top_of_page">org.freedesktop.systemd1.Manager</link>.
 */

/**
 * Systemd1ManagerIface:
 * @parent_iface: The parent interface.
 * @handle_abandon_scope: Handler for the #Systemd1Manager::handle-abandon-scope signal.
 * @handle_add_dependency_unit_files: Handler for the #Systemd1Manager::handle-add-dependency-unit-files signal.
 * @handle_attach_processes_to_unit: Handler for the #Systemd1Manager::handle-attach-processes-to-unit signal.
 * @handle_bind_mount_unit: Handler for the #Systemd1Manager::handle-bind-mount-unit signal.
 * @handle_cancel_job: Handler for the #Systemd1Manager::handle-cancel-job signal.
 * @handle_clean_unit: Handler for the #Systemd1Manager::handle-clean-unit signal.
 * @handle_clear_jobs: Handler for the #Systemd1Manager::handle-clear-jobs signal.
 * @handle_disable_unit_files: Handler for the #Systemd1Manager::handle-disable-unit-files signal.
 * @handle_disable_unit_files_with_flags: Handler for the #Systemd1Manager::handle-disable-unit-files-with-flags signal.
 * @handle_dump: Handler for the #Systemd1Manager::handle-dump signal.
 * @handle_dump_by_file_descriptor: Handler for the #Systemd1Manager::handle-dump-by-file-descriptor signal.
 * @handle_enable_unit_files: Handler for the #Systemd1Manager::handle-enable-unit-files signal.
 * @handle_enable_unit_files_with_flags: Handler for the #Systemd1Manager::handle-enable-unit-files-with-flags signal.
 * @handle_enqueue_marked_jobs: Handler for the #Systemd1Manager::handle-enqueue-marked-jobs signal.
 * @handle_enqueue_unit_job: Handler for the #Systemd1Manager::handle-enqueue-unit-job signal.
 * @handle_exit: Handler for the #Systemd1Manager::handle-exit signal.
 * @handle_freeze_unit: Handler for the #Systemd1Manager::handle-freeze-unit signal.
 * @handle_get_default_target: Handler for the #Systemd1Manager::handle-get-default-target signal.
 * @handle_get_dynamic_users: Handler for the #Systemd1Manager::handle-get-dynamic-users signal.
 * @handle_get_job: Handler for the #Systemd1Manager::handle-get-job signal.
 * @handle_get_job_after: Handler for the #Systemd1Manager::handle-get-job-after signal.
 * @handle_get_job_before: Handler for the #Systemd1Manager::handle-get-job-before signal.
 * @handle_get_unit: Handler for the #Systemd1Manager::handle-get-unit signal.
 * @handle_get_unit_by_control_group: Handler for the #Systemd1Manager::handle-get-unit-by-control-group signal.
 * @handle_get_unit_by_invocation_id: Handler for the #Systemd1Manager::handle-get-unit-by-invocation-id signal.
 * @handle_get_unit_by_pid: Handler for the #Systemd1Manager::handle-get-unit-by-pid signal.
 * @handle_get_unit_file_links: Handler for the #Systemd1Manager::handle-get-unit-file-links signal.
 * @handle_get_unit_file_state: Handler for the #Systemd1Manager::handle-get-unit-file-state signal.
 * @handle_get_unit_processes: Handler for the #Systemd1Manager::handle-get-unit-processes signal.
 * @handle_halt: Handler for the #Systemd1Manager::handle-halt signal.
 * @handle_kexec: Handler for the #Systemd1Manager::handle-kexec signal.
 * @handle_kill_unit: Handler for the #Systemd1Manager::handle-kill-unit signal.
 * @handle_link_unit_files: Handler for the #Systemd1Manager::handle-link-unit-files signal.
 * @handle_list_jobs: Handler for the #Systemd1Manager::handle-list-jobs signal.
 * @handle_list_unit_files: Handler for the #Systemd1Manager::handle-list-unit-files signal.
 * @handle_list_unit_files_by_patterns: Handler for the #Systemd1Manager::handle-list-unit-files-by-patterns signal.
 * @handle_list_units: Handler for the #Systemd1Manager::handle-list-units signal.
 * @handle_list_units_by_names: Handler for the #Systemd1Manager::handle-list-units-by-names signal.
 * @handle_list_units_by_patterns: Handler for the #Systemd1Manager::handle-list-units-by-patterns signal.
 * @handle_list_units_filtered: Handler for the #Systemd1Manager::handle-list-units-filtered signal.
 * @handle_load_unit: Handler for the #Systemd1Manager::handle-load-unit signal.
 * @handle_lookup_dynamic_user_by_name: Handler for the #Systemd1Manager::handle-lookup-dynamic-user-by-name signal.
 * @handle_lookup_dynamic_user_by_uid: Handler for the #Systemd1Manager::handle-lookup-dynamic-user-by-uid signal.
 * @handle_mask_unit_files: Handler for the #Systemd1Manager::handle-mask-unit-files signal.
 * @handle_mount_image_unit: Handler for the #Systemd1Manager::handle-mount-image-unit signal.
 * @handle_power_off: Handler for the #Systemd1Manager::handle-power-off signal.
 * @handle_preset_all_unit_files: Handler for the #Systemd1Manager::handle-preset-all-unit-files signal.
 * @handle_preset_unit_files: Handler for the #Systemd1Manager::handle-preset-unit-files signal.
 * @handle_preset_unit_files_with_mode: Handler for the #Systemd1Manager::handle-preset-unit-files-with-mode signal.
 * @handle_reboot: Handler for the #Systemd1Manager::handle-reboot signal.
 * @handle_reenable_unit_files: Handler for the #Systemd1Manager::handle-reenable-unit-files signal.
 * @handle_reexecute: Handler for the #Systemd1Manager::handle-reexecute signal.
 * @handle_ref_unit: Handler for the #Systemd1Manager::handle-ref-unit signal.
 * @handle_reload: Handler for the #Systemd1Manager::handle-reload signal.
 * @handle_reload_or_restart_unit: Handler for the #Systemd1Manager::handle-reload-or-restart-unit signal.
 * @handle_reload_or_try_restart_unit: Handler for the #Systemd1Manager::handle-reload-or-try-restart-unit signal.
 * @handle_reload_unit: Handler for the #Systemd1Manager::handle-reload-unit signal.
 * @handle_reset_failed: Handler for the #Systemd1Manager::handle-reset-failed signal.
 * @handle_reset_failed_unit: Handler for the #Systemd1Manager::handle-reset-failed-unit signal.
 * @handle_restart_unit: Handler for the #Systemd1Manager::handle-restart-unit signal.
 * @handle_revert_unit_files: Handler for the #Systemd1Manager::handle-revert-unit-files signal.
 * @handle_set_default_target: Handler for the #Systemd1Manager::handle-set-default-target signal.
 * @handle_set_environment: Handler for the #Systemd1Manager::handle-set-environment signal.
 * @handle_set_exit_code: Handler for the #Systemd1Manager::handle-set-exit-code signal.
 * @handle_set_show_status: Handler for the #Systemd1Manager::handle-set-show-status signal.
 * @handle_set_unit_properties: Handler for the #Systemd1Manager::handle-set-unit-properties signal.
 * @handle_start_transient_unit: Handler for the #Systemd1Manager::handle-start-transient-unit signal.
 * @handle_start_unit: Handler for the #Systemd1Manager::handle-start-unit signal.
 * @handle_start_unit_replace: Handler for the #Systemd1Manager::handle-start-unit-replace signal.
 * @handle_stop_unit: Handler for the #Systemd1Manager::handle-stop-unit signal.
 * @handle_subscribe: Handler for the #Systemd1Manager::handle-subscribe signal.
 * @handle_switch_root: Handler for the #Systemd1Manager::handle-switch-root signal.
 * @handle_thaw_unit: Handler for the #Systemd1Manager::handle-thaw-unit signal.
 * @handle_try_restart_unit: Handler for the #Systemd1Manager::handle-try-restart-unit signal.
 * @handle_unmask_unit_files: Handler for the #Systemd1Manager::handle-unmask-unit-files signal.
 * @handle_unref_unit: Handler for the #Systemd1Manager::handle-unref-unit signal.
 * @handle_unset_and_set_environment: Handler for the #Systemd1Manager::handle-unset-and-set-environment signal.
 * @handle_unset_environment: Handler for the #Systemd1Manager::handle-unset-environment signal.
 * @handle_unsubscribe: Handler for the #Systemd1Manager::handle-unsubscribe signal.
 * @get_architecture: Getter for the #Systemd1Manager:architecture property.
 * @get_confirm_spawn: Getter for the #Systemd1Manager:confirm-spawn property.
 * @get_control_group: Getter for the #Systemd1Manager:control-group property.
 * @get_ctrl_alt_del_burst_action: Getter for the #Systemd1Manager:ctrl-alt-del-burst-action property.
 * @get_default_block_ioaccounting: Getter for the #Systemd1Manager:default-block-ioaccounting property.
 * @get_default_cpuaccounting: Getter for the #Systemd1Manager:default-cpuaccounting property.
 * @get_default_limit_as: Getter for the #Systemd1Manager:default-limit-as property.
 * @get_default_limit_assoft: Getter for the #Systemd1Manager:default-limit-assoft property.
 * @get_default_limit_core: Getter for the #Systemd1Manager:default-limit-core property.
 * @get_default_limit_coresoft: Getter for the #Systemd1Manager:default-limit-coresoft property.
 * @get_default_limit_cpu: Getter for the #Systemd1Manager:default-limit-cpu property.
 * @get_default_limit_cpusoft: Getter for the #Systemd1Manager:default-limit-cpusoft property.
 * @get_default_limit_data: Getter for the #Systemd1Manager:default-limit-data property.
 * @get_default_limit_datasoft: Getter for the #Systemd1Manager:default-limit-datasoft property.
 * @get_default_limit_fsize: Getter for the #Systemd1Manager:default-limit-fsize property.
 * @get_default_limit_fsizesoft: Getter for the #Systemd1Manager:default-limit-fsizesoft property.
 * @get_default_limit_locks: Getter for the #Systemd1Manager:default-limit-locks property.
 * @get_default_limit_lockssoft: Getter for the #Systemd1Manager:default-limit-lockssoft property.
 * @get_default_limit_memlock: Getter for the #Systemd1Manager:default-limit-memlock property.
 * @get_default_limit_memlocksoft: Getter for the #Systemd1Manager:default-limit-memlocksoft property.
 * @get_default_limit_msgqueue: Getter for the #Systemd1Manager:default-limit-msgqueue property.
 * @get_default_limit_msgqueuesoft: Getter for the #Systemd1Manager:default-limit-msgqueuesoft property.
 * @get_default_limit_nice: Getter for the #Systemd1Manager:default-limit-nice property.
 * @get_default_limit_nicesoft: Getter for the #Systemd1Manager:default-limit-nicesoft property.
 * @get_default_limit_nofile: Getter for the #Systemd1Manager:default-limit-nofile property.
 * @get_default_limit_nofilesoft: Getter for the #Systemd1Manager:default-limit-nofilesoft property.
 * @get_default_limit_nproc: Getter for the #Systemd1Manager:default-limit-nproc property.
 * @get_default_limit_nprocsoft: Getter for the #Systemd1Manager:default-limit-nprocsoft property.
 * @get_default_limit_rss: Getter for the #Systemd1Manager:default-limit-rss property.
 * @get_default_limit_rsssoft: Getter for the #Systemd1Manager:default-limit-rsssoft property.
 * @get_default_limit_rtprio: Getter for the #Systemd1Manager:default-limit-rtprio property.
 * @get_default_limit_rtpriosoft: Getter for the #Systemd1Manager:default-limit-rtpriosoft property.
 * @get_default_limit_rttime: Getter for the #Systemd1Manager:default-limit-rttime property.
 * @get_default_limit_rttimesoft: Getter for the #Systemd1Manager:default-limit-rttimesoft property.
 * @get_default_limit_sigpending: Getter for the #Systemd1Manager:default-limit-sigpending property.
 * @get_default_limit_sigpendingsoft: Getter for the #Systemd1Manager:default-limit-sigpendingsoft property.
 * @get_default_limit_stack: Getter for the #Systemd1Manager:default-limit-stack property.
 * @get_default_limit_stacksoft: Getter for the #Systemd1Manager:default-limit-stacksoft property.
 * @get_default_memory_accounting: Getter for the #Systemd1Manager:default-memory-accounting property.
 * @get_default_oompolicy: Getter for the #Systemd1Manager:default-oompolicy property.
 * @get_default_restart_usec: Getter for the #Systemd1Manager:default-restart-usec property.
 * @get_default_standard_error: Getter for the #Systemd1Manager:default-standard-error property.
 * @get_default_standard_output: Getter for the #Systemd1Manager:default-standard-output property.
 * @get_default_start_limit_burst: Getter for the #Systemd1Manager:default-start-limit-burst property.
 * @get_default_start_limit_interval_usec: Getter for the #Systemd1Manager:default-start-limit-interval-usec property.
 * @get_default_tasks_accounting: Getter for the #Systemd1Manager:default-tasks-accounting property.
 * @get_default_tasks_max: Getter for the #Systemd1Manager:default-tasks-max property.
 * @get_default_timeout_abort_usec: Getter for the #Systemd1Manager:default-timeout-abort-usec property.
 * @get_default_timeout_start_usec: Getter for the #Systemd1Manager:default-timeout-start-usec property.
 * @get_default_timeout_stop_usec: Getter for the #Systemd1Manager:default-timeout-stop-usec property.
 * @get_default_timer_accuracy_usec: Getter for the #Systemd1Manager:default-timer-accuracy-usec property.
 * @get_environment: Getter for the #Systemd1Manager:environment property.
 * @get_exit_code: Getter for the #Systemd1Manager:exit-code property.
 * @get_features: Getter for the #Systemd1Manager:features property.
 * @get_finish_timestamp: Getter for the #Systemd1Manager:finish-timestamp property.
 * @get_finish_timestamp_monotonic: Getter for the #Systemd1Manager:finish-timestamp-monotonic property.
 * @get_firmware_timestamp: Getter for the #Systemd1Manager:firmware-timestamp property.
 * @get_firmware_timestamp_monotonic: Getter for the #Systemd1Manager:firmware-timestamp-monotonic property.
 * @get_generators_finish_timestamp: Getter for the #Systemd1Manager:generators-finish-timestamp property.
 * @get_generators_finish_timestamp_monotonic: Getter for the #Systemd1Manager:generators-finish-timestamp-monotonic property.
 * @get_generators_start_timestamp: Getter for the #Systemd1Manager:generators-start-timestamp property.
 * @get_generators_start_timestamp_monotonic: Getter for the #Systemd1Manager:generators-start-timestamp-monotonic property.
 * @get_init_rdgenerators_finish_timestamp: Getter for the #Systemd1Manager:init-rdgenerators-finish-timestamp property.
 * @get_init_rdgenerators_finish_timestamp_monotonic: Getter for the #Systemd1Manager:init-rdgenerators-finish-timestamp-monotonic property.
 * @get_init_rdgenerators_start_timestamp: Getter for the #Systemd1Manager:init-rdgenerators-start-timestamp property.
 * @get_init_rdgenerators_start_timestamp_monotonic: Getter for the #Systemd1Manager:init-rdgenerators-start-timestamp-monotonic property.
 * @get_init_rdsecurity_finish_timestamp: Getter for the #Systemd1Manager:init-rdsecurity-finish-timestamp property.
 * @get_init_rdsecurity_finish_timestamp_monotonic: Getter for the #Systemd1Manager:init-rdsecurity-finish-timestamp-monotonic property.
 * @get_init_rdsecurity_start_timestamp: Getter for the #Systemd1Manager:init-rdsecurity-start-timestamp property.
 * @get_init_rdsecurity_start_timestamp_monotonic: Getter for the #Systemd1Manager:init-rdsecurity-start-timestamp-monotonic property.
 * @get_init_rdtimestamp: Getter for the #Systemd1Manager:init-rdtimestamp property.
 * @get_init_rdtimestamp_monotonic: Getter for the #Systemd1Manager:init-rdtimestamp-monotonic property.
 * @get_init_rdunits_load_finish_timestamp: Getter for the #Systemd1Manager:init-rdunits-load-finish-timestamp property.
 * @get_init_rdunits_load_finish_timestamp_monotonic: Getter for the #Systemd1Manager:init-rdunits-load-finish-timestamp-monotonic property.
 * @get_init_rdunits_load_start_timestamp: Getter for the #Systemd1Manager:init-rdunits-load-start-timestamp property.
 * @get_init_rdunits_load_start_timestamp_monotonic: Getter for the #Systemd1Manager:init-rdunits-load-start-timestamp-monotonic property.
 * @get_kernel_timestamp: Getter for the #Systemd1Manager:kernel-timestamp property.
 * @get_kernel_timestamp_monotonic: Getter for the #Systemd1Manager:kernel-timestamp-monotonic property.
 * @get_kexec_watchdog_usec: Getter for the #Systemd1Manager:kexec-watchdog-usec property.
 * @get_loader_timestamp: Getter for the #Systemd1Manager:loader-timestamp property.
 * @get_loader_timestamp_monotonic: Getter for the #Systemd1Manager:loader-timestamp-monotonic property.
 * @get_log_level: Getter for the #Systemd1Manager:log-level property.
 * @get_log_target: Getter for the #Systemd1Manager:log-target property.
 * @get_nfailed_jobs: Getter for the #Systemd1Manager:nfailed-jobs property.
 * @get_nfailed_units: Getter for the #Systemd1Manager:nfailed-units property.
 * @get_ninstalled_jobs: Getter for the #Systemd1Manager:ninstalled-jobs property.
 * @get_njobs: Getter for the #Systemd1Manager:njobs property.
 * @get_nnames: Getter for the #Systemd1Manager:nnames property.
 * @get_progress: Getter for the #Systemd1Manager:progress property.
 * @get_reboot_watchdog_usec: Getter for the #Systemd1Manager:reboot-watchdog-usec property.
 * @get_runtime_watchdog_usec: Getter for the #Systemd1Manager:runtime-watchdog-usec property.
 * @get_security_finish_timestamp: Getter for the #Systemd1Manager:security-finish-timestamp property.
 * @get_security_finish_timestamp_monotonic: Getter for the #Systemd1Manager:security-finish-timestamp-monotonic property.
 * @get_security_start_timestamp: Getter for the #Systemd1Manager:security-start-timestamp property.
 * @get_security_start_timestamp_monotonic: Getter for the #Systemd1Manager:security-start-timestamp-monotonic property.
 * @get_service_watchdogs: Getter for the #Systemd1Manager:service-watchdogs property.
 * @get_show_status: Getter for the #Systemd1Manager:show-status property.
 * @get_system_state: Getter for the #Systemd1Manager:system-state property.
 * @get_tainted: Getter for the #Systemd1Manager:tainted property.
 * @get_timer_slack_nsec: Getter for the #Systemd1Manager:timer-slack-nsec property.
 * @get_unit_path: Getter for the #Systemd1Manager:unit-path property.
 * @get_units_load_finish_timestamp: Getter for the #Systemd1Manager:units-load-finish-timestamp property.
 * @get_units_load_finish_timestamp_monotonic: Getter for the #Systemd1Manager:units-load-finish-timestamp-monotonic property.
 * @get_units_load_start_timestamp: Getter for the #Systemd1Manager:units-load-start-timestamp property.
 * @get_units_load_start_timestamp_monotonic: Getter for the #Systemd1Manager:units-load-start-timestamp-monotonic property.
 * @get_userspace_timestamp: Getter for the #Systemd1Manager:userspace-timestamp property.
 * @get_userspace_timestamp_monotonic: Getter for the #Systemd1Manager:userspace-timestamp-monotonic property.
 * @get_version: Getter for the #Systemd1Manager:version property.
 * @get_virtualization: Getter for the #Systemd1Manager:virtualization property.
 * @job_new: Handler for the #Systemd1Manager::job-new signal.
 * @job_removed: Handler for the #Systemd1Manager::job-removed signal.
 * @reloading: Handler for the #Systemd1Manager::reloading signal.
 * @startup_finished: Handler for the #Systemd1Manager::startup-finished signal.
 * @unit_files_changed: Handler for the #Systemd1Manager::unit-files-changed signal.
 * @unit_new: Handler for the #Systemd1Manager::unit-new signal.
 * @unit_removed: Handler for the #Systemd1Manager::unit-removed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-systemd1-Manager.top_of_page">org.freedesktop.systemd1.Manager</link>.
 */

typedef Systemd1ManagerIface Systemd1ManagerInterface;
G_DEFINE_INTERFACE (Systemd1Manager, systemd1_manager, G_TYPE_OBJECT)

static void
systemd1_manager_default_init (Systemd1ManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * Systemd1Manager::handle-get-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnit">GetUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_get_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_get_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-get-unit-by-pid:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitByPID">GetUnitByPID()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_get_unit_by_pid() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-unit-by-pid",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_get_unit_by_pid),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * Systemd1Manager::handle-get-unit-by-invocation-id:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_invocation_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitByInvocationID">GetUnitByInvocationID()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_get_unit_by_invocation_id() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-unit-by-invocation-id",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_get_unit_by_invocation_id),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-get-unit-by-control-group:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_cgroup: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitByControlGroup">GetUnitByControlGroup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_get_unit_by_control_group() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-unit-by-control-group",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_get_unit_by_control_group),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-load-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LoadUnit">LoadUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_load_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-load-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_load_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-start-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StartUnit">StartUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_start_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_start_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-start-unit-replace:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_old_unit: Argument passed by remote caller.
   * @arg_new_unit: Argument passed by remote caller.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StartUnitReplace">StartUnitReplace()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_start_unit_replace() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start-unit-replace",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_start_unit_replace),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-stop-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StopUnit">StopUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_stop_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_stop_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-reload-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReloadUnit">ReloadUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_reload_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reload-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_reload_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-restart-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.RestartUnit">RestartUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_restart_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-restart-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_restart_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-try-restart-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.TryRestartUnit">TryRestartUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_try_restart_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-try-restart-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_try_restart_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-reload-or-restart-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReloadOrRestartUnit">ReloadOrRestartUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_reload_or_restart_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reload-or-restart-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_reload_or_restart_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-reload-or-try-restart-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReloadOrTryRestartUnit">ReloadOrTryRestartUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_reload_or_try_restart_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reload-or-try-restart-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_reload_or_try_restart_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-enqueue-unit-job:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_job_type: Argument passed by remote caller.
   * @arg_job_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnqueueUnitJob">EnqueueUnitJob()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_enqueue_unit_job() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enqueue-unit-job",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_enqueue_unit_job),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-kill-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_whom: Argument passed by remote caller.
   * @arg_signal: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.KillUnit">KillUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_kill_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-kill-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_kill_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT);

  /**
   * Systemd1Manager::handle-clean-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_mask: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.CleanUnit">CleanUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_clean_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-clean-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_clean_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRV);

  /**
   * Systemd1Manager::handle-freeze-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.FreezeUnit">FreezeUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_freeze_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-freeze-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_freeze_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-thaw-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ThawUnit">ThawUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_thaw_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-thaw-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_thaw_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-reset-failed-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ResetFailedUnit">ResetFailedUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_reset_failed_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reset-failed-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_reset_failed_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-set-unit-properties:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_runtime: Argument passed by remote caller.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetUnitProperties">SetUnitProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_set_unit_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-unit-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_set_unit_properties),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_VARIANT);

  /**
   * Systemd1Manager::handle-bind-mount-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_source: Argument passed by remote caller.
   * @arg_destination: Argument passed by remote caller.
   * @arg_read_only: Argument passed by remote caller.
   * @arg_mkdir: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.BindMountUnit">BindMountUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_bind_mount_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-bind-mount-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_bind_mount_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

  /**
   * Systemd1Manager::handle-mount-image-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_source: Argument passed by remote caller.
   * @arg_destination: Argument passed by remote caller.
   * @arg_read_only: Argument passed by remote caller.
   * @arg_mkdir: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.MountImageUnit">MountImageUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_mount_image_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-mount-image-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_mount_image_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_VARIANT);

  /**
   * Systemd1Manager::handle-ref-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.RefUnit">RefUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_ref_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-ref-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_ref_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-unref-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnrefUnit">UnrefUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_unref_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unref-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_unref_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-start-transient-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_mode: Argument passed by remote caller.
   * @arg_properties: Argument passed by remote caller.
   * @arg_aux: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StartTransientUnit">StartTransientUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_start_transient_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start-transient-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_start_transient_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * Systemd1Manager::handle-get-unit-processes:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitProcesses">GetUnitProcesses()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_get_unit_processes() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-unit-processes",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_get_unit_processes),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-attach-processes-to-unit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_unit_name: Argument passed by remote caller.
   * @arg_subcgroup: Argument passed by remote caller.
   * @arg_pids: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.AttachProcessesToUnit">AttachProcessesToUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_attach_processes_to_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-attach-processes-to-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_attach_processes_to_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * Systemd1Manager::handle-abandon-scope:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.AbandonScope">AbandonScope()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_abandon_scope() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-abandon-scope",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_abandon_scope),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-get-job:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetJob">GetJob()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_get_job() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-job",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_get_job),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * Systemd1Manager::handle-get-job-after:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetJobAfter">GetJobAfter()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_get_job_after() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-job-after",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_get_job_after),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * Systemd1Manager::handle-get-job-before:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetJobBefore">GetJobBefore()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_get_job_before() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-job-before",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_get_job_before),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * Systemd1Manager::handle-cancel-job:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.CancelJob">CancelJob()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_cancel_job() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-cancel-job",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_cancel_job),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * Systemd1Manager::handle-clear-jobs:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ClearJobs">ClearJobs()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_clear_jobs() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-clear-jobs",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_clear_jobs),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-reset-failed:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ResetFailed">ResetFailed()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_reset_failed() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reset-failed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_reset_failed),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-set-show-status:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetShowStatus">SetShowStatus()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_set_show_status() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-show-status",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_set_show_status),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-list-units:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnits">ListUnits()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_list_units() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-units",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_list_units),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-list-units-filtered:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_states: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitsFiltered">ListUnitsFiltered()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_list_units_filtered() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-units-filtered",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_list_units_filtered),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * Systemd1Manager::handle-list-units-by-patterns:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_states: Argument passed by remote caller.
   * @arg_patterns: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitsByPatterns">ListUnitsByPatterns()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_list_units_by_patterns() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-units-by-patterns",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_list_units_by_patterns),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_STRV);

  /**
   * Systemd1Manager::handle-list-units-by-names:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_names: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitsByNames">ListUnitsByNames()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_list_units_by_names() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-units-by-names",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_list_units_by_names),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * Systemd1Manager::handle-list-jobs:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListJobs">ListJobs()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_list_jobs() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-jobs",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_list_jobs),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-subscribe:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Subscribe">Subscribe()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_subscribe() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-subscribe",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_subscribe),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-unsubscribe:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Unsubscribe">Unsubscribe()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_unsubscribe() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unsubscribe",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_unsubscribe),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-dump:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Dump">Dump()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_dump() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-dump",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_dump),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-dump-by-file-descriptor:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.DumpByFileDescriptor">DumpByFileDescriptor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_dump_by_file_descriptor() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-dump-by-file-descriptor",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_dump_by_file_descriptor),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-reload:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Reload">Reload()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_reload() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reload",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_reload),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-reexecute:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Reexecute">Reexecute()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_reexecute() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reexecute",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_reexecute),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-exit:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Exit">Exit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_exit() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-exit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_exit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-reboot:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Reboot">Reboot()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_reboot() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reboot",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_reboot),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-power-off:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PowerOff">PowerOff()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_power_off() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-power-off",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_power_off),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-halt:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Halt">Halt()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_halt() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-halt",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_halt),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-kexec:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.KExec">KExec()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_kexec() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-kexec",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_kexec),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-switch-root:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_new_root: Argument passed by remote caller.
   * @arg_init: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SwitchRoot">SwitchRoot()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_switch_root() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-switch-root",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_switch_root),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-set-environment:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_assignments: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetEnvironment">SetEnvironment()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_set_environment() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-environment",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_set_environment),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * Systemd1Manager::handle-unset-environment:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_names: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnsetEnvironment">UnsetEnvironment()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_unset_environment() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unset-environment",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_unset_environment),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * Systemd1Manager::handle-unset-and-set-environment:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_names: Argument passed by remote caller.
   * @arg_assignments: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnsetAndSetEnvironment">UnsetAndSetEnvironment()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_unset_and_set_environment() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unset-and-set-environment",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_unset_and_set_environment),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_STRV);

  /**
   * Systemd1Manager::handle-enqueue-marked-jobs:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnqueueMarkedJobs">EnqueueMarkedJobs()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_enqueue_marked_jobs() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enqueue-marked-jobs",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_enqueue_marked_jobs),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-list-unit-files:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitFiles">ListUnitFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_list_unit_files() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-unit-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_list_unit_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-list-unit-files-by-patterns:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_states: Argument passed by remote caller.
   * @arg_patterns: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitFilesByPatterns">ListUnitFilesByPatterns()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_list_unit_files_by_patterns() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-unit-files-by-patterns",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_list_unit_files_by_patterns),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_STRV);

  /**
   * Systemd1Manager::handle-get-unit-file-state:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_file: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitFileState">GetUnitFileState()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_get_unit_file_state() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-unit-file-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_get_unit_file_state),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-enable-unit-files:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_files: Argument passed by remote caller.
   * @arg_runtime: Argument passed by remote caller.
   * @arg_force: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnableUnitFiles">EnableUnitFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_enable_unit_files() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable-unit-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_enable_unit_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

  /**
   * Systemd1Manager::handle-disable-unit-files:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_files: Argument passed by remote caller.
   * @arg_runtime: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.DisableUnitFiles">DisableUnitFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_disable_unit_files() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disable-unit-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_disable_unit_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_BOOLEAN);

  /**
   * Systemd1Manager::handle-enable-unit-files-with-flags:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_files: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnableUnitFilesWithFlags">EnableUnitFilesWithFlags()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_enable_unit_files_with_flags() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable-unit-files-with-flags",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_enable_unit_files_with_flags),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_UINT64);

  /**
   * Systemd1Manager::handle-disable-unit-files-with-flags:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_files: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.DisableUnitFilesWithFlags">DisableUnitFilesWithFlags()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_disable_unit_files_with_flags() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disable-unit-files-with-flags",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_disable_unit_files_with_flags),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_UINT64);

  /**
   * Systemd1Manager::handle-reenable-unit-files:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_files: Argument passed by remote caller.
   * @arg_runtime: Argument passed by remote caller.
   * @arg_force: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReenableUnitFiles">ReenableUnitFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_reenable_unit_files() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reenable-unit-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_reenable_unit_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

  /**
   * Systemd1Manager::handle-link-unit-files:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_files: Argument passed by remote caller.
   * @arg_runtime: Argument passed by remote caller.
   * @arg_force: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LinkUnitFiles">LinkUnitFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_link_unit_files() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-link-unit-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_link_unit_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

  /**
   * Systemd1Manager::handle-preset-unit-files:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_files: Argument passed by remote caller.
   * @arg_runtime: Argument passed by remote caller.
   * @arg_force: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PresetUnitFiles">PresetUnitFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_preset_unit_files() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-preset-unit-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_preset_unit_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

  /**
   * Systemd1Manager::handle-preset-unit-files-with-mode:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_files: Argument passed by remote caller.
   * @arg_mode: Argument passed by remote caller.
   * @arg_runtime: Argument passed by remote caller.
   * @arg_force: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PresetUnitFilesWithMode">PresetUnitFilesWithMode()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_preset_unit_files_with_mode() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-preset-unit-files-with-mode",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_preset_unit_files_with_mode),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

  /**
   * Systemd1Manager::handle-mask-unit-files:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_files: Argument passed by remote caller.
   * @arg_runtime: Argument passed by remote caller.
   * @arg_force: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.MaskUnitFiles">MaskUnitFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_mask_unit_files() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-mask-unit-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_mask_unit_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

  /**
   * Systemd1Manager::handle-unmask-unit-files:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_files: Argument passed by remote caller.
   * @arg_runtime: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnmaskUnitFiles">UnmaskUnitFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_unmask_unit_files() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unmask-unit-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_unmask_unit_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_BOOLEAN);

  /**
   * Systemd1Manager::handle-revert-unit-files:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_files: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.RevertUnitFiles">RevertUnitFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_revert_unit_files() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-revert-unit-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_revert_unit_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * Systemd1Manager::handle-set-default-target:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_force: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetDefaultTarget">SetDefaultTarget()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_set_default_target() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-default-target",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_set_default_target),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * Systemd1Manager::handle-get-default-target:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetDefaultTarget">GetDefaultTarget()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_get_default_target() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-default-target",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_get_default_target),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Manager::handle-preset-all-unit-files:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mode: Argument passed by remote caller.
   * @arg_runtime: Argument passed by remote caller.
   * @arg_force: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PresetAllUnitFiles">PresetAllUnitFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_preset_all_unit_files() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-preset-all-unit-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_preset_all_unit_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

  /**
   * Systemd1Manager::handle-add-dependency-unit-files:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_files: Argument passed by remote caller.
   * @arg_target: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   * @arg_runtime: Argument passed by remote caller.
   * @arg_force: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.AddDependencyUnitFiles">AddDependencyUnitFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_add_dependency_unit_files() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-dependency-unit-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_add_dependency_unit_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

  /**
   * Systemd1Manager::handle-get-unit-file-links:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_runtime: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitFileLinks">GetUnitFileLinks()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_get_unit_file_links() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-unit-file-links",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_get_unit_file_links),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * Systemd1Manager::handle-set-exit-code:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_number: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetExitCode">SetExitCode()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_set_exit_code() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-exit-code",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_set_exit_code),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UCHAR);

  /**
   * Systemd1Manager::handle-lookup-dynamic-user-by-name:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LookupDynamicUserByName">LookupDynamicUserByName()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_lookup_dynamic_user_by_name() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lookup-dynamic-user-by-name",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_lookup_dynamic_user_by_name),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Manager::handle-lookup-dynamic-user-by-uid:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LookupDynamicUserByUID">LookupDynamicUserByUID()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_lookup_dynamic_user_by_uid() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lookup-dynamic-user-by-uid",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_lookup_dynamic_user_by_uid),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * Systemd1Manager::handle-get-dynamic-users:
   * @object: A #Systemd1Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetDynamicUsers">GetDynamicUsers()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_manager_complete_get_dynamic_users() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-dynamic-users",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, handle_get_dynamic_users),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * Systemd1Manager::unit-new:
   * @object: A #Systemd1Manager.
   * @arg_id: Argument.
   * @arg_unit: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-systemd1-Manager.UnitNew">"UnitNew"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("unit-new",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, unit_new),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Manager::unit-removed:
   * @object: A #Systemd1Manager.
   * @arg_id: Argument.
   * @arg_unit: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-systemd1-Manager.UnitRemoved">"UnitRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("unit-removed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, unit_removed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Manager::job-new:
   * @object: A #Systemd1Manager.
   * @arg_id: Argument.
   * @arg_job: Argument.
   * @arg_unit: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-systemd1-Manager.JobNew">"JobNew"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("job-new",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, job_new),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    3, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Manager::job-removed:
   * @object: A #Systemd1Manager.
   * @arg_id: Argument.
   * @arg_job: Argument.
   * @arg_unit: Argument.
   * @arg_result: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-systemd1-Manager.JobRemoved">"JobRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("job-removed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, job_removed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    4, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Manager::startup-finished:
   * @object: A #Systemd1Manager.
   * @arg_firmware: Argument.
   * @arg_loader: Argument.
   * @arg_kernel: Argument.
   * @arg_initrd: Argument.
   * @arg_userspace: Argument.
   * @arg_total: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-systemd1-Manager.StartupFinished">"StartupFinished"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("startup-finished",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, startup_finished),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    6, G_TYPE_UINT64, G_TYPE_UINT64, G_TYPE_UINT64, G_TYPE_UINT64, G_TYPE_UINT64, G_TYPE_UINT64);

  /**
   * Systemd1Manager::unit-files-changed:
   * @object: A #Systemd1Manager.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-systemd1-Manager.UnitFilesChanged">"UnitFilesChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("unit-files-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, unit_files_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * Systemd1Manager::reloading:
   * @object: A #Systemd1Manager.
   * @arg_active: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-systemd1-Manager.Reloading">"Reloading"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("reloading",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1ManagerIface, reloading),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_BOOLEAN);

  /* GObject properties for D-Bus properties: */
  /**
   * Systemd1Manager:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Version">"Version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("version", "Version", "Version", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:features:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Features">"Features"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("features", "Features", "Features", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:virtualization:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Virtualization">"Virtualization"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("virtualization", "Virtualization", "Virtualization", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:architecture:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Architecture">"Architecture"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("architecture", "Architecture", "Architecture", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:tainted:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Tainted">"Tainted"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("tainted", "Tainted", "Tainted", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:firmware-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.FirmwareTimestamp">"FirmwareTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("firmware-timestamp", "FirmwareTimestamp", "FirmwareTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:firmware-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.FirmwareTimestampMonotonic">"FirmwareTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("firmware-timestamp-monotonic", "FirmwareTimestampMonotonic", "FirmwareTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:loader-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.LoaderTimestamp">"LoaderTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("loader-timestamp", "LoaderTimestamp", "LoaderTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:loader-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.LoaderTimestampMonotonic">"LoaderTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("loader-timestamp-monotonic", "LoaderTimestampMonotonic", "LoaderTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:kernel-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.KernelTimestamp">"KernelTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("kernel-timestamp", "KernelTimestamp", "KernelTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:kernel-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.KernelTimestampMonotonic">"KernelTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("kernel-timestamp-monotonic", "KernelTimestampMonotonic", "KernelTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:init-rdtimestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDTimestamp">"InitRDTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("init-rdtimestamp", "InitRDTimestamp", "InitRDTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:init-rdtimestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDTimestampMonotonic">"InitRDTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("init-rdtimestamp-monotonic", "InitRDTimestampMonotonic", "InitRDTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:userspace-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UserspaceTimestamp">"UserspaceTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("userspace-timestamp", "UserspaceTimestamp", "UserspaceTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:userspace-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UserspaceTimestampMonotonic">"UserspaceTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("userspace-timestamp-monotonic", "UserspaceTimestampMonotonic", "UserspaceTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:finish-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.FinishTimestamp">"FinishTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("finish-timestamp", "FinishTimestamp", "FinishTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:finish-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.FinishTimestampMonotonic">"FinishTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("finish-timestamp-monotonic", "FinishTimestampMonotonic", "FinishTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:security-start-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SecurityStartTimestamp">"SecurityStartTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("security-start-timestamp", "SecurityStartTimestamp", "SecurityStartTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:security-start-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SecurityStartTimestampMonotonic">"SecurityStartTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("security-start-timestamp-monotonic", "SecurityStartTimestampMonotonic", "SecurityStartTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:security-finish-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SecurityFinishTimestamp">"SecurityFinishTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("security-finish-timestamp", "SecurityFinishTimestamp", "SecurityFinishTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:security-finish-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SecurityFinishTimestampMonotonic">"SecurityFinishTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("security-finish-timestamp-monotonic", "SecurityFinishTimestampMonotonic", "SecurityFinishTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:generators-start-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.GeneratorsStartTimestamp">"GeneratorsStartTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("generators-start-timestamp", "GeneratorsStartTimestamp", "GeneratorsStartTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:generators-start-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.GeneratorsStartTimestampMonotonic">"GeneratorsStartTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("generators-start-timestamp-monotonic", "GeneratorsStartTimestampMonotonic", "GeneratorsStartTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:generators-finish-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.GeneratorsFinishTimestamp">"GeneratorsFinishTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("generators-finish-timestamp", "GeneratorsFinishTimestamp", "GeneratorsFinishTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:generators-finish-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.GeneratorsFinishTimestampMonotonic">"GeneratorsFinishTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("generators-finish-timestamp-monotonic", "GeneratorsFinishTimestampMonotonic", "GeneratorsFinishTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:units-load-start-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitsLoadStartTimestamp">"UnitsLoadStartTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("units-load-start-timestamp", "UnitsLoadStartTimestamp", "UnitsLoadStartTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:units-load-start-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitsLoadStartTimestampMonotonic">"UnitsLoadStartTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("units-load-start-timestamp-monotonic", "UnitsLoadStartTimestampMonotonic", "UnitsLoadStartTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:units-load-finish-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitsLoadFinishTimestamp">"UnitsLoadFinishTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("units-load-finish-timestamp", "UnitsLoadFinishTimestamp", "UnitsLoadFinishTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:units-load-finish-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitsLoadFinishTimestampMonotonic">"UnitsLoadFinishTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("units-load-finish-timestamp-monotonic", "UnitsLoadFinishTimestampMonotonic", "UnitsLoadFinishTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:init-rdsecurity-start-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDSecurityStartTimestamp">"InitRDSecurityStartTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("init-rdsecurity-start-timestamp", "InitRDSecurityStartTimestamp", "InitRDSecurityStartTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:init-rdsecurity-start-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDSecurityStartTimestampMonotonic">"InitRDSecurityStartTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("init-rdsecurity-start-timestamp-monotonic", "InitRDSecurityStartTimestampMonotonic", "InitRDSecurityStartTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:init-rdsecurity-finish-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDSecurityFinishTimestamp">"InitRDSecurityFinishTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("init-rdsecurity-finish-timestamp", "InitRDSecurityFinishTimestamp", "InitRDSecurityFinishTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:init-rdsecurity-finish-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDSecurityFinishTimestampMonotonic">"InitRDSecurityFinishTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("init-rdsecurity-finish-timestamp-monotonic", "InitRDSecurityFinishTimestampMonotonic", "InitRDSecurityFinishTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:init-rdgenerators-start-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDGeneratorsStartTimestamp">"InitRDGeneratorsStartTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("init-rdgenerators-start-timestamp", "InitRDGeneratorsStartTimestamp", "InitRDGeneratorsStartTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:init-rdgenerators-start-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDGeneratorsStartTimestampMonotonic">"InitRDGeneratorsStartTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("init-rdgenerators-start-timestamp-monotonic", "InitRDGeneratorsStartTimestampMonotonic", "InitRDGeneratorsStartTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:init-rdgenerators-finish-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDGeneratorsFinishTimestamp">"InitRDGeneratorsFinishTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("init-rdgenerators-finish-timestamp", "InitRDGeneratorsFinishTimestamp", "InitRDGeneratorsFinishTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:init-rdgenerators-finish-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDGeneratorsFinishTimestampMonotonic">"InitRDGeneratorsFinishTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("init-rdgenerators-finish-timestamp-monotonic", "InitRDGeneratorsFinishTimestampMonotonic", "InitRDGeneratorsFinishTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:init-rdunits-load-start-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDUnitsLoadStartTimestamp">"InitRDUnitsLoadStartTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("init-rdunits-load-start-timestamp", "InitRDUnitsLoadStartTimestamp", "InitRDUnitsLoadStartTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:init-rdunits-load-start-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDUnitsLoadStartTimestampMonotonic">"InitRDUnitsLoadStartTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("init-rdunits-load-start-timestamp-monotonic", "InitRDUnitsLoadStartTimestampMonotonic", "InitRDUnitsLoadStartTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:init-rdunits-load-finish-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDUnitsLoadFinishTimestamp">"InitRDUnitsLoadFinishTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("init-rdunits-load-finish-timestamp", "InitRDUnitsLoadFinishTimestamp", "InitRDUnitsLoadFinishTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:init-rdunits-load-finish-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDUnitsLoadFinishTimestampMonotonic">"InitRDUnitsLoadFinishTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("init-rdunits-load-finish-timestamp-monotonic", "InitRDUnitsLoadFinishTimestampMonotonic", "InitRDUnitsLoadFinishTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:log-level:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.LogLevel">"LogLevel"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("log-level", "LogLevel", "LogLevel", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:log-target:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.LogTarget">"LogTarget"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("log-target", "LogTarget", "LogTarget", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:nnames:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NNames">"NNames"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("nnames", "NNames", "NNames", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:nfailed-units:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NFailedUnits">"NFailedUnits"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("nfailed-units", "NFailedUnits", "NFailedUnits", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:njobs:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NJobs">"NJobs"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("njobs", "NJobs", "NJobs", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:ninstalled-jobs:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NInstalledJobs">"NInstalledJobs"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("ninstalled-jobs", "NInstalledJobs", "NInstalledJobs", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:nfailed-jobs:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NFailedJobs">"NFailedJobs"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("nfailed-jobs", "NFailedJobs", "NFailedJobs", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:progress:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Progress">"Progress"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("progress", "Progress", "Progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:environment:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Environment">"Environment"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("environment", "Environment", "Environment", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:confirm-spawn:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ConfirmSpawn">"ConfirmSpawn"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("confirm-spawn", "ConfirmSpawn", "ConfirmSpawn", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:show-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ShowStatus">"ShowStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("show-status", "ShowStatus", "ShowStatus", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:unit-path:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitPath">"UnitPath"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("unit-path", "UnitPath", "UnitPath", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-standard-output:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultStandardOutput">"DefaultStandardOutput"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("default-standard-output", "DefaultStandardOutput", "DefaultStandardOutput", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-standard-error:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultStandardError">"DefaultStandardError"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("default-standard-error", "DefaultStandardError", "DefaultStandardError", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:runtime-watchdog-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.RuntimeWatchdogUSec">"RuntimeWatchdogUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("runtime-watchdog-usec", "RuntimeWatchdogUSec", "RuntimeWatchdogUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:reboot-watchdog-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.RebootWatchdogUSec">"RebootWatchdogUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("reboot-watchdog-usec", "RebootWatchdogUSec", "RebootWatchdogUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:kexec-watchdog-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.KExecWatchdogUSec">"KExecWatchdogUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("kexec-watchdog-usec", "KExecWatchdogUSec", "KExecWatchdogUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:service-watchdogs:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ServiceWatchdogs">"ServiceWatchdogs"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("service-watchdogs", "ServiceWatchdogs", "ServiceWatchdogs", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:control-group:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ControlGroup">"ControlGroup"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("control-group", "ControlGroup", "ControlGroup", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:system-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SystemState">"SystemState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("system-state", "SystemState", "SystemState", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:exit-code:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ExitCode">"ExitCode"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uchar ("exit-code", "ExitCode", "ExitCode", 0, 255, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-timer-accuracy-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTimerAccuracyUSec">"DefaultTimerAccuracyUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-timer-accuracy-usec", "DefaultTimerAccuracyUSec", "DefaultTimerAccuracyUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-timeout-start-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTimeoutStartUSec">"DefaultTimeoutStartUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-timeout-start-usec", "DefaultTimeoutStartUSec", "DefaultTimeoutStartUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-timeout-stop-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTimeoutStopUSec">"DefaultTimeoutStopUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-timeout-stop-usec", "DefaultTimeoutStopUSec", "DefaultTimeoutStopUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-timeout-abort-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTimeoutAbortUSec">"DefaultTimeoutAbortUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-timeout-abort-usec", "DefaultTimeoutAbortUSec", "DefaultTimeoutAbortUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-restart-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultRestartUSec">"DefaultRestartUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-restart-usec", "DefaultRestartUSec", "DefaultRestartUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-start-limit-interval-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultStartLimitIntervalUSec">"DefaultStartLimitIntervalUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-start-limit-interval-usec", "DefaultStartLimitIntervalUSec", "DefaultStartLimitIntervalUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-start-limit-burst:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultStartLimitBurst">"DefaultStartLimitBurst"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("default-start-limit-burst", "DefaultStartLimitBurst", "DefaultStartLimitBurst", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-cpuaccounting:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultCPUAccounting">"DefaultCPUAccounting"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("default-cpuaccounting", "DefaultCPUAccounting", "DefaultCPUAccounting", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-block-ioaccounting:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultBlockIOAccounting">"DefaultBlockIOAccounting"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("default-block-ioaccounting", "DefaultBlockIOAccounting", "DefaultBlockIOAccounting", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-memory-accounting:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultMemoryAccounting">"DefaultMemoryAccounting"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("default-memory-accounting", "DefaultMemoryAccounting", "DefaultMemoryAccounting", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-tasks-accounting:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTasksAccounting">"DefaultTasksAccounting"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("default-tasks-accounting", "DefaultTasksAccounting", "DefaultTasksAccounting", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-cpu:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitCPU">"DefaultLimitCPU"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-cpu", "DefaultLimitCPU", "DefaultLimitCPU", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-cpusoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitCPUSoft">"DefaultLimitCPUSoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-cpusoft", "DefaultLimitCPUSoft", "DefaultLimitCPUSoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-fsize:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitFSIZE">"DefaultLimitFSIZE"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-fsize", "DefaultLimitFSIZE", "DefaultLimitFSIZE", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-fsizesoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitFSIZESoft">"DefaultLimitFSIZESoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-fsizesoft", "DefaultLimitFSIZESoft", "DefaultLimitFSIZESoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-data:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitDATA">"DefaultLimitDATA"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-data", "DefaultLimitDATA", "DefaultLimitDATA", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-datasoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitDATASoft">"DefaultLimitDATASoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-datasoft", "DefaultLimitDATASoft", "DefaultLimitDATASoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-stack:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitSTACK">"DefaultLimitSTACK"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-stack", "DefaultLimitSTACK", "DefaultLimitSTACK", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-stacksoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitSTACKSoft">"DefaultLimitSTACKSoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-stacksoft", "DefaultLimitSTACKSoft", "DefaultLimitSTACKSoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-core:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitCORE">"DefaultLimitCORE"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-core", "DefaultLimitCORE", "DefaultLimitCORE", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-coresoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitCORESoft">"DefaultLimitCORESoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-coresoft", "DefaultLimitCORESoft", "DefaultLimitCORESoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-rss:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRSS">"DefaultLimitRSS"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-rss", "DefaultLimitRSS", "DefaultLimitRSS", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-rsssoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRSSSoft">"DefaultLimitRSSSoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-rsssoft", "DefaultLimitRSSSoft", "DefaultLimitRSSSoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-nofile:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNOFILE">"DefaultLimitNOFILE"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-nofile", "DefaultLimitNOFILE", "DefaultLimitNOFILE", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-nofilesoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNOFILESoft">"DefaultLimitNOFILESoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-nofilesoft", "DefaultLimitNOFILESoft", "DefaultLimitNOFILESoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-as:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitAS">"DefaultLimitAS"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-as", "DefaultLimitAS", "DefaultLimitAS", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-assoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitASSoft">"DefaultLimitASSoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-assoft", "DefaultLimitASSoft", "DefaultLimitASSoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-nproc:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNPROC">"DefaultLimitNPROC"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-nproc", "DefaultLimitNPROC", "DefaultLimitNPROC", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-nprocsoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNPROCSoft">"DefaultLimitNPROCSoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-nprocsoft", "DefaultLimitNPROCSoft", "DefaultLimitNPROCSoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-memlock:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitMEMLOCK">"DefaultLimitMEMLOCK"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-memlock", "DefaultLimitMEMLOCK", "DefaultLimitMEMLOCK", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-memlocksoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitMEMLOCKSoft">"DefaultLimitMEMLOCKSoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-memlocksoft", "DefaultLimitMEMLOCKSoft", "DefaultLimitMEMLOCKSoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-locks:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitLOCKS">"DefaultLimitLOCKS"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-locks", "DefaultLimitLOCKS", "DefaultLimitLOCKS", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-lockssoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitLOCKSSoft">"DefaultLimitLOCKSSoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-lockssoft", "DefaultLimitLOCKSSoft", "DefaultLimitLOCKSSoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-sigpending:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitSIGPENDING">"DefaultLimitSIGPENDING"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-sigpending", "DefaultLimitSIGPENDING", "DefaultLimitSIGPENDING", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-sigpendingsoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitSIGPENDINGSoft">"DefaultLimitSIGPENDINGSoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-sigpendingsoft", "DefaultLimitSIGPENDINGSoft", "DefaultLimitSIGPENDINGSoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-msgqueue:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitMSGQUEUE">"DefaultLimitMSGQUEUE"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-msgqueue", "DefaultLimitMSGQUEUE", "DefaultLimitMSGQUEUE", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-msgqueuesoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitMSGQUEUESoft">"DefaultLimitMSGQUEUESoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-msgqueuesoft", "DefaultLimitMSGQUEUESoft", "DefaultLimitMSGQUEUESoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-nice:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNICE">"DefaultLimitNICE"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-nice", "DefaultLimitNICE", "DefaultLimitNICE", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-nicesoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNICESoft">"DefaultLimitNICESoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-nicesoft", "DefaultLimitNICESoft", "DefaultLimitNICESoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-rtprio:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRTPRIO">"DefaultLimitRTPRIO"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-rtprio", "DefaultLimitRTPRIO", "DefaultLimitRTPRIO", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-rtpriosoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRTPRIOSoft">"DefaultLimitRTPRIOSoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-rtpriosoft", "DefaultLimitRTPRIOSoft", "DefaultLimitRTPRIOSoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-rttime:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRTTIME">"DefaultLimitRTTIME"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-rttime", "DefaultLimitRTTIME", "DefaultLimitRTTIME", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-limit-rttimesoft:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRTTIMESoft">"DefaultLimitRTTIMESoft"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-limit-rttimesoft", "DefaultLimitRTTIMESoft", "DefaultLimitRTTIMESoft", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-tasks-max:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTasksMax">"DefaultTasksMax"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("default-tasks-max", "DefaultTasksMax", "DefaultTasksMax", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:timer-slack-nsec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.TimerSlackNSec">"TimerSlackNSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("timer-slack-nsec", "TimerSlackNSec", "TimerSlackNSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:default-oompolicy:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultOOMPolicy">"DefaultOOMPolicy"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("default-oompolicy", "DefaultOOMPolicy", "DefaultOOMPolicy", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Manager:ctrl-alt-del-burst-action:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.CtrlAltDelBurstAction">"CtrlAltDelBurstAction"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("ctrl-alt-del-burst-action", "CtrlAltDelBurstAction", "CtrlAltDelBurstAction", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * systemd1_manager_get_version: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_version() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_manager_get_version (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_version (object);
}

/**
 * systemd1_manager_dup_version: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_manager_dup_version (Systemd1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "version", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_version: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Version">"Version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_version (Systemd1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * systemd1_manager_get_features: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Features">"Features"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_features() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_manager_get_features (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_features (object);
}

/**
 * systemd1_manager_dup_features: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Features">"Features"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_manager_dup_features (Systemd1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "features", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_features: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Features">"Features"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_features (Systemd1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "features", value, NULL);
}

/**
 * systemd1_manager_get_virtualization: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Virtualization">"Virtualization"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_virtualization() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_manager_get_virtualization (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_virtualization (object);
}

/**
 * systemd1_manager_dup_virtualization: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Virtualization">"Virtualization"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_manager_dup_virtualization (Systemd1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "virtualization", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_virtualization: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Virtualization">"Virtualization"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_virtualization (Systemd1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "virtualization", value, NULL);
}

/**
 * systemd1_manager_get_architecture: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Architecture">"Architecture"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_architecture() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_manager_get_architecture (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_architecture (object);
}

/**
 * systemd1_manager_dup_architecture: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Architecture">"Architecture"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_manager_dup_architecture (Systemd1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "architecture", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_architecture: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Architecture">"Architecture"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_architecture (Systemd1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "architecture", value, NULL);
}

/**
 * systemd1_manager_get_tainted: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Tainted">"Tainted"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_tainted() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_manager_get_tainted (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_tainted (object);
}

/**
 * systemd1_manager_dup_tainted: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Tainted">"Tainted"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_manager_dup_tainted (Systemd1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "tainted", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_tainted: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Tainted">"Tainted"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_tainted (Systemd1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "tainted", value, NULL);
}

/**
 * systemd1_manager_get_firmware_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.FirmwareTimestamp">"FirmwareTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_firmware_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_firmware_timestamp (object);
}

/**
 * systemd1_manager_set_firmware_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.FirmwareTimestamp">"FirmwareTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_firmware_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "firmware-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_firmware_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.FirmwareTimestampMonotonic">"FirmwareTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_firmware_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_firmware_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_firmware_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.FirmwareTimestampMonotonic">"FirmwareTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_firmware_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "firmware-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_loader_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.LoaderTimestamp">"LoaderTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_loader_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_loader_timestamp (object);
}

/**
 * systemd1_manager_set_loader_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.LoaderTimestamp">"LoaderTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_loader_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "loader-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_loader_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.LoaderTimestampMonotonic">"LoaderTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_loader_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_loader_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_loader_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.LoaderTimestampMonotonic">"LoaderTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_loader_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "loader-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_kernel_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.KernelTimestamp">"KernelTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_kernel_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_kernel_timestamp (object);
}

/**
 * systemd1_manager_set_kernel_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.KernelTimestamp">"KernelTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_kernel_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "kernel-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_kernel_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.KernelTimestampMonotonic">"KernelTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_kernel_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_kernel_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_kernel_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.KernelTimestampMonotonic">"KernelTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_kernel_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "kernel-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_init_rdtimestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDTimestamp">"InitRDTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_init_rdtimestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_init_rdtimestamp (object);
}

/**
 * systemd1_manager_set_init_rdtimestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDTimestamp">"InitRDTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_init_rdtimestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "init-rdtimestamp", value, NULL);
}

/**
 * systemd1_manager_get_init_rdtimestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDTimestampMonotonic">"InitRDTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_init_rdtimestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_init_rdtimestamp_monotonic (object);
}

/**
 * systemd1_manager_set_init_rdtimestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDTimestampMonotonic">"InitRDTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_init_rdtimestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "init-rdtimestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_userspace_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UserspaceTimestamp">"UserspaceTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_userspace_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_userspace_timestamp (object);
}

/**
 * systemd1_manager_set_userspace_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UserspaceTimestamp">"UserspaceTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_userspace_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "userspace-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_userspace_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UserspaceTimestampMonotonic">"UserspaceTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_userspace_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_userspace_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_userspace_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UserspaceTimestampMonotonic">"UserspaceTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_userspace_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "userspace-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_finish_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.FinishTimestamp">"FinishTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_finish_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_finish_timestamp (object);
}

/**
 * systemd1_manager_set_finish_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.FinishTimestamp">"FinishTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_finish_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "finish-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_finish_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.FinishTimestampMonotonic">"FinishTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_finish_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_finish_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_finish_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.FinishTimestampMonotonic">"FinishTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_finish_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "finish-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_security_start_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SecurityStartTimestamp">"SecurityStartTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_security_start_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_security_start_timestamp (object);
}

/**
 * systemd1_manager_set_security_start_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SecurityStartTimestamp">"SecurityStartTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_security_start_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "security-start-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_security_start_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SecurityStartTimestampMonotonic">"SecurityStartTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_security_start_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_security_start_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_security_start_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SecurityStartTimestampMonotonic">"SecurityStartTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_security_start_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "security-start-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_security_finish_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SecurityFinishTimestamp">"SecurityFinishTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_security_finish_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_security_finish_timestamp (object);
}

/**
 * systemd1_manager_set_security_finish_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SecurityFinishTimestamp">"SecurityFinishTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_security_finish_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "security-finish-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_security_finish_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SecurityFinishTimestampMonotonic">"SecurityFinishTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_security_finish_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_security_finish_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_security_finish_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SecurityFinishTimestampMonotonic">"SecurityFinishTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_security_finish_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "security-finish-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_generators_start_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.GeneratorsStartTimestamp">"GeneratorsStartTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_generators_start_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_generators_start_timestamp (object);
}

/**
 * systemd1_manager_set_generators_start_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.GeneratorsStartTimestamp">"GeneratorsStartTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_generators_start_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "generators-start-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_generators_start_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.GeneratorsStartTimestampMonotonic">"GeneratorsStartTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_generators_start_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_generators_start_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_generators_start_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.GeneratorsStartTimestampMonotonic">"GeneratorsStartTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_generators_start_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "generators-start-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_generators_finish_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.GeneratorsFinishTimestamp">"GeneratorsFinishTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_generators_finish_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_generators_finish_timestamp (object);
}

/**
 * systemd1_manager_set_generators_finish_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.GeneratorsFinishTimestamp">"GeneratorsFinishTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_generators_finish_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "generators-finish-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_generators_finish_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.GeneratorsFinishTimestampMonotonic">"GeneratorsFinishTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_generators_finish_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_generators_finish_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_generators_finish_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.GeneratorsFinishTimestampMonotonic">"GeneratorsFinishTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_generators_finish_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "generators-finish-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_units_load_start_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitsLoadStartTimestamp">"UnitsLoadStartTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_units_load_start_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_units_load_start_timestamp (object);
}

/**
 * systemd1_manager_set_units_load_start_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitsLoadStartTimestamp">"UnitsLoadStartTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_units_load_start_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "units-load-start-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_units_load_start_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitsLoadStartTimestampMonotonic">"UnitsLoadStartTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_units_load_start_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_units_load_start_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_units_load_start_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitsLoadStartTimestampMonotonic">"UnitsLoadStartTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_units_load_start_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "units-load-start-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_units_load_finish_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitsLoadFinishTimestamp">"UnitsLoadFinishTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_units_load_finish_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_units_load_finish_timestamp (object);
}

/**
 * systemd1_manager_set_units_load_finish_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitsLoadFinishTimestamp">"UnitsLoadFinishTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_units_load_finish_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "units-load-finish-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_units_load_finish_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitsLoadFinishTimestampMonotonic">"UnitsLoadFinishTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_units_load_finish_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_units_load_finish_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_units_load_finish_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitsLoadFinishTimestampMonotonic">"UnitsLoadFinishTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_units_load_finish_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "units-load-finish-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_init_rdsecurity_start_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDSecurityStartTimestamp">"InitRDSecurityStartTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_init_rdsecurity_start_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_init_rdsecurity_start_timestamp (object);
}

/**
 * systemd1_manager_set_init_rdsecurity_start_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDSecurityStartTimestamp">"InitRDSecurityStartTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_init_rdsecurity_start_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "init-rdsecurity-start-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_init_rdsecurity_start_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDSecurityStartTimestampMonotonic">"InitRDSecurityStartTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_init_rdsecurity_start_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_init_rdsecurity_start_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_init_rdsecurity_start_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDSecurityStartTimestampMonotonic">"InitRDSecurityStartTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_init_rdsecurity_start_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "init-rdsecurity-start-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_init_rdsecurity_finish_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDSecurityFinishTimestamp">"InitRDSecurityFinishTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_init_rdsecurity_finish_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_init_rdsecurity_finish_timestamp (object);
}

/**
 * systemd1_manager_set_init_rdsecurity_finish_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDSecurityFinishTimestamp">"InitRDSecurityFinishTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_init_rdsecurity_finish_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "init-rdsecurity-finish-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_init_rdsecurity_finish_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDSecurityFinishTimestampMonotonic">"InitRDSecurityFinishTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_init_rdsecurity_finish_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_init_rdsecurity_finish_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_init_rdsecurity_finish_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDSecurityFinishTimestampMonotonic">"InitRDSecurityFinishTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_init_rdsecurity_finish_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "init-rdsecurity-finish-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_init_rdgenerators_start_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDGeneratorsStartTimestamp">"InitRDGeneratorsStartTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_init_rdgenerators_start_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_init_rdgenerators_start_timestamp (object);
}

/**
 * systemd1_manager_set_init_rdgenerators_start_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDGeneratorsStartTimestamp">"InitRDGeneratorsStartTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_init_rdgenerators_start_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "init-rdgenerators-start-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_init_rdgenerators_start_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDGeneratorsStartTimestampMonotonic">"InitRDGeneratorsStartTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_init_rdgenerators_start_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_init_rdgenerators_start_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_init_rdgenerators_start_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDGeneratorsStartTimestampMonotonic">"InitRDGeneratorsStartTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_init_rdgenerators_start_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "init-rdgenerators-start-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_init_rdgenerators_finish_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDGeneratorsFinishTimestamp">"InitRDGeneratorsFinishTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_init_rdgenerators_finish_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_init_rdgenerators_finish_timestamp (object);
}

/**
 * systemd1_manager_set_init_rdgenerators_finish_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDGeneratorsFinishTimestamp">"InitRDGeneratorsFinishTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_init_rdgenerators_finish_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "init-rdgenerators-finish-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_init_rdgenerators_finish_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDGeneratorsFinishTimestampMonotonic">"InitRDGeneratorsFinishTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_init_rdgenerators_finish_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_init_rdgenerators_finish_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_init_rdgenerators_finish_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDGeneratorsFinishTimestampMonotonic">"InitRDGeneratorsFinishTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_init_rdgenerators_finish_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "init-rdgenerators-finish-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_init_rdunits_load_start_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDUnitsLoadStartTimestamp">"InitRDUnitsLoadStartTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_init_rdunits_load_start_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_init_rdunits_load_start_timestamp (object);
}

/**
 * systemd1_manager_set_init_rdunits_load_start_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDUnitsLoadStartTimestamp">"InitRDUnitsLoadStartTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_init_rdunits_load_start_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "init-rdunits-load-start-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_init_rdunits_load_start_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDUnitsLoadStartTimestampMonotonic">"InitRDUnitsLoadStartTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_init_rdunits_load_start_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_init_rdunits_load_start_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_init_rdunits_load_start_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDUnitsLoadStartTimestampMonotonic">"InitRDUnitsLoadStartTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_init_rdunits_load_start_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "init-rdunits-load-start-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_init_rdunits_load_finish_timestamp: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDUnitsLoadFinishTimestamp">"InitRDUnitsLoadFinishTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_init_rdunits_load_finish_timestamp (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_init_rdunits_load_finish_timestamp (object);
}

/**
 * systemd1_manager_set_init_rdunits_load_finish_timestamp: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDUnitsLoadFinishTimestamp">"InitRDUnitsLoadFinishTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_init_rdunits_load_finish_timestamp (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "init-rdunits-load-finish-timestamp", value, NULL);
}

/**
 * systemd1_manager_get_init_rdunits_load_finish_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDUnitsLoadFinishTimestampMonotonic">"InitRDUnitsLoadFinishTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_init_rdunits_load_finish_timestamp_monotonic (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_init_rdunits_load_finish_timestamp_monotonic (object);
}

/**
 * systemd1_manager_set_init_rdunits_load_finish_timestamp_monotonic: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.InitRDUnitsLoadFinishTimestampMonotonic">"InitRDUnitsLoadFinishTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_init_rdunits_load_finish_timestamp_monotonic (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "init-rdunits-load-finish-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_manager_get_log_level: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.LogLevel">"LogLevel"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_log_level() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_manager_get_log_level (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_log_level (object);
}

/**
 * systemd1_manager_dup_log_level: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.LogLevel">"LogLevel"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_manager_dup_log_level (Systemd1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "log-level", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_log_level: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.LogLevel">"LogLevel"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
systemd1_manager_set_log_level (Systemd1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "log-level", value, NULL);
}

/**
 * systemd1_manager_get_log_target: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.LogTarget">"LogTarget"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_log_target() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_manager_get_log_target (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_log_target (object);
}

/**
 * systemd1_manager_dup_log_target: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.LogTarget">"LogTarget"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_manager_dup_log_target (Systemd1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "log-target", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_log_target: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.LogTarget">"LogTarget"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
systemd1_manager_set_log_target (Systemd1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "log-target", value, NULL);
}

/**
 * systemd1_manager_get_nnames: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NNames">"NNames"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
systemd1_manager_get_nnames (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_nnames (object);
}

/**
 * systemd1_manager_set_nnames: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NNames">"NNames"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_nnames (Systemd1Manager *object, guint value)
{
  g_object_set (G_OBJECT (object), "nnames", value, NULL);
}

/**
 * systemd1_manager_get_nfailed_units: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NFailedUnits">"NFailedUnits"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
systemd1_manager_get_nfailed_units (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_nfailed_units (object);
}

/**
 * systemd1_manager_set_nfailed_units: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NFailedUnits">"NFailedUnits"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_nfailed_units (Systemd1Manager *object, guint value)
{
  g_object_set (G_OBJECT (object), "nfailed-units", value, NULL);
}

/**
 * systemd1_manager_get_njobs: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NJobs">"NJobs"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
systemd1_manager_get_njobs (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_njobs (object);
}

/**
 * systemd1_manager_set_njobs: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NJobs">"NJobs"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_njobs (Systemd1Manager *object, guint value)
{
  g_object_set (G_OBJECT (object), "njobs", value, NULL);
}

/**
 * systemd1_manager_get_ninstalled_jobs: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NInstalledJobs">"NInstalledJobs"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
systemd1_manager_get_ninstalled_jobs (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_ninstalled_jobs (object);
}

/**
 * systemd1_manager_set_ninstalled_jobs: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NInstalledJobs">"NInstalledJobs"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_ninstalled_jobs (Systemd1Manager *object, guint value)
{
  g_object_set (G_OBJECT (object), "ninstalled-jobs", value, NULL);
}

/**
 * systemd1_manager_get_nfailed_jobs: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NFailedJobs">"NFailedJobs"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
systemd1_manager_get_nfailed_jobs (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_nfailed_jobs (object);
}

/**
 * systemd1_manager_set_nfailed_jobs: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.NFailedJobs">"NFailedJobs"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_nfailed_jobs (Systemd1Manager *object, guint value)
{
  g_object_set (G_OBJECT (object), "nfailed-jobs", value, NULL);
}

/**
 * systemd1_manager_get_progress: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Progress">"Progress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
systemd1_manager_get_progress (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_progress (object);
}

/**
 * systemd1_manager_set_progress: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Progress">"Progress"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_progress (Systemd1Manager *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "progress", value, NULL);
}

/**
 * systemd1_manager_get_environment: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Environment">"Environment"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_environment() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_manager_get_environment (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_environment (object);
}

/**
 * systemd1_manager_dup_environment: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Environment">"Environment"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_manager_dup_environment (Systemd1Manager *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "environment", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_environment: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.Environment">"Environment"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_environment (Systemd1Manager *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "environment", value, NULL);
}

/**
 * systemd1_manager_get_confirm_spawn: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ConfirmSpawn">"ConfirmSpawn"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_manager_get_confirm_spawn (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_confirm_spawn (object);
}

/**
 * systemd1_manager_set_confirm_spawn: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ConfirmSpawn">"ConfirmSpawn"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_confirm_spawn (Systemd1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "confirm-spawn", value, NULL);
}

/**
 * systemd1_manager_get_show_status: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ShowStatus">"ShowStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_manager_get_show_status (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_show_status (object);
}

/**
 * systemd1_manager_set_show_status: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ShowStatus">"ShowStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_show_status (Systemd1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "show-status", value, NULL);
}

/**
 * systemd1_manager_get_unit_path: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitPath">"UnitPath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_unit_path() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_manager_get_unit_path (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_unit_path (object);
}

/**
 * systemd1_manager_dup_unit_path: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitPath">"UnitPath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_manager_dup_unit_path (Systemd1Manager *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "unit-path", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_unit_path: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.UnitPath">"UnitPath"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_unit_path (Systemd1Manager *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "unit-path", value, NULL);
}

/**
 * systemd1_manager_get_default_standard_output: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultStandardOutput">"DefaultStandardOutput"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_default_standard_output() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_manager_get_default_standard_output (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_standard_output (object);
}

/**
 * systemd1_manager_dup_default_standard_output: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultStandardOutput">"DefaultStandardOutput"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_manager_dup_default_standard_output (Systemd1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "default-standard-output", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_default_standard_output: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultStandardOutput">"DefaultStandardOutput"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_standard_output (Systemd1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "default-standard-output", value, NULL);
}

/**
 * systemd1_manager_get_default_standard_error: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultStandardError">"DefaultStandardError"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_default_standard_error() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_manager_get_default_standard_error (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_standard_error (object);
}

/**
 * systemd1_manager_dup_default_standard_error: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultStandardError">"DefaultStandardError"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_manager_dup_default_standard_error (Systemd1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "default-standard-error", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_default_standard_error: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultStandardError">"DefaultStandardError"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_standard_error (Systemd1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "default-standard-error", value, NULL);
}

/**
 * systemd1_manager_get_runtime_watchdog_usec: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.RuntimeWatchdogUSec">"RuntimeWatchdogUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_runtime_watchdog_usec (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_runtime_watchdog_usec (object);
}

/**
 * systemd1_manager_set_runtime_watchdog_usec: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.RuntimeWatchdogUSec">"RuntimeWatchdogUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
systemd1_manager_set_runtime_watchdog_usec (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "runtime-watchdog-usec", value, NULL);
}

/**
 * systemd1_manager_get_reboot_watchdog_usec: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.RebootWatchdogUSec">"RebootWatchdogUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_reboot_watchdog_usec (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_reboot_watchdog_usec (object);
}

/**
 * systemd1_manager_set_reboot_watchdog_usec: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.RebootWatchdogUSec">"RebootWatchdogUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
systemd1_manager_set_reboot_watchdog_usec (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "reboot-watchdog-usec", value, NULL);
}

/**
 * systemd1_manager_get_kexec_watchdog_usec: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.KExecWatchdogUSec">"KExecWatchdogUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_kexec_watchdog_usec (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_kexec_watchdog_usec (object);
}

/**
 * systemd1_manager_set_kexec_watchdog_usec: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.KExecWatchdogUSec">"KExecWatchdogUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
systemd1_manager_set_kexec_watchdog_usec (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "kexec-watchdog-usec", value, NULL);
}

/**
 * systemd1_manager_get_service_watchdogs: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ServiceWatchdogs">"ServiceWatchdogs"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_manager_get_service_watchdogs (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_service_watchdogs (object);
}

/**
 * systemd1_manager_set_service_watchdogs: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ServiceWatchdogs">"ServiceWatchdogs"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
systemd1_manager_set_service_watchdogs (Systemd1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "service-watchdogs", value, NULL);
}

/**
 * systemd1_manager_get_control_group: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ControlGroup">"ControlGroup"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_control_group() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_manager_get_control_group (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_control_group (object);
}

/**
 * systemd1_manager_dup_control_group: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ControlGroup">"ControlGroup"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_manager_dup_control_group (Systemd1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "control-group", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_control_group: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ControlGroup">"ControlGroup"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_control_group (Systemd1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "control-group", value, NULL);
}

/**
 * systemd1_manager_get_system_state: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SystemState">"SystemState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_system_state() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_manager_get_system_state (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_system_state (object);
}

/**
 * systemd1_manager_dup_system_state: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SystemState">"SystemState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_manager_dup_system_state (Systemd1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "system-state", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_system_state: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.SystemState">"SystemState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_system_state (Systemd1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "system-state", value, NULL);
}

/**
 * systemd1_manager_get_exit_code: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ExitCode">"ExitCode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guchar 
systemd1_manager_get_exit_code (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_exit_code (object);
}

/**
 * systemd1_manager_set_exit_code: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.ExitCode">"ExitCode"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_exit_code (Systemd1Manager *object, guchar value)
{
  g_object_set (G_OBJECT (object), "exit-code", value, NULL);
}

/**
 * systemd1_manager_get_default_timer_accuracy_usec: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTimerAccuracyUSec">"DefaultTimerAccuracyUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_timer_accuracy_usec (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_timer_accuracy_usec (object);
}

/**
 * systemd1_manager_set_default_timer_accuracy_usec: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTimerAccuracyUSec">"DefaultTimerAccuracyUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_timer_accuracy_usec (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-timer-accuracy-usec", value, NULL);
}

/**
 * systemd1_manager_get_default_timeout_start_usec: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTimeoutStartUSec">"DefaultTimeoutStartUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_timeout_start_usec (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_timeout_start_usec (object);
}

/**
 * systemd1_manager_set_default_timeout_start_usec: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTimeoutStartUSec">"DefaultTimeoutStartUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_timeout_start_usec (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-timeout-start-usec", value, NULL);
}

/**
 * systemd1_manager_get_default_timeout_stop_usec: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTimeoutStopUSec">"DefaultTimeoutStopUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_timeout_stop_usec (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_timeout_stop_usec (object);
}

/**
 * systemd1_manager_set_default_timeout_stop_usec: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTimeoutStopUSec">"DefaultTimeoutStopUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_timeout_stop_usec (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-timeout-stop-usec", value, NULL);
}

/**
 * systemd1_manager_get_default_timeout_abort_usec: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTimeoutAbortUSec">"DefaultTimeoutAbortUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_timeout_abort_usec (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_timeout_abort_usec (object);
}

/**
 * systemd1_manager_set_default_timeout_abort_usec: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTimeoutAbortUSec">"DefaultTimeoutAbortUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_timeout_abort_usec (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-timeout-abort-usec", value, NULL);
}

/**
 * systemd1_manager_get_default_restart_usec: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultRestartUSec">"DefaultRestartUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_restart_usec (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_restart_usec (object);
}

/**
 * systemd1_manager_set_default_restart_usec: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultRestartUSec">"DefaultRestartUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_restart_usec (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-restart-usec", value, NULL);
}

/**
 * systemd1_manager_get_default_start_limit_interval_usec: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultStartLimitIntervalUSec">"DefaultStartLimitIntervalUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_start_limit_interval_usec (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_start_limit_interval_usec (object);
}

/**
 * systemd1_manager_set_default_start_limit_interval_usec: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultStartLimitIntervalUSec">"DefaultStartLimitIntervalUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_start_limit_interval_usec (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-start-limit-interval-usec", value, NULL);
}

/**
 * systemd1_manager_get_default_start_limit_burst: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultStartLimitBurst">"DefaultStartLimitBurst"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
systemd1_manager_get_default_start_limit_burst (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_start_limit_burst (object);
}

/**
 * systemd1_manager_set_default_start_limit_burst: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultStartLimitBurst">"DefaultStartLimitBurst"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_start_limit_burst (Systemd1Manager *object, guint value)
{
  g_object_set (G_OBJECT (object), "default-start-limit-burst", value, NULL);
}

/**
 * systemd1_manager_get_default_cpuaccounting: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultCPUAccounting">"DefaultCPUAccounting"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_manager_get_default_cpuaccounting (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_cpuaccounting (object);
}

/**
 * systemd1_manager_set_default_cpuaccounting: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultCPUAccounting">"DefaultCPUAccounting"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_cpuaccounting (Systemd1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "default-cpuaccounting", value, NULL);
}

/**
 * systemd1_manager_get_default_block_ioaccounting: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultBlockIOAccounting">"DefaultBlockIOAccounting"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_manager_get_default_block_ioaccounting (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_block_ioaccounting (object);
}

/**
 * systemd1_manager_set_default_block_ioaccounting: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultBlockIOAccounting">"DefaultBlockIOAccounting"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_block_ioaccounting (Systemd1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "default-block-ioaccounting", value, NULL);
}

/**
 * systemd1_manager_get_default_memory_accounting: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultMemoryAccounting">"DefaultMemoryAccounting"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_manager_get_default_memory_accounting (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_memory_accounting (object);
}

/**
 * systemd1_manager_set_default_memory_accounting: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultMemoryAccounting">"DefaultMemoryAccounting"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_memory_accounting (Systemd1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "default-memory-accounting", value, NULL);
}

/**
 * systemd1_manager_get_default_tasks_accounting: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTasksAccounting">"DefaultTasksAccounting"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_manager_get_default_tasks_accounting (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_tasks_accounting (object);
}

/**
 * systemd1_manager_set_default_tasks_accounting: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTasksAccounting">"DefaultTasksAccounting"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_tasks_accounting (Systemd1Manager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "default-tasks-accounting", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_cpu: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitCPU">"DefaultLimitCPU"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_cpu (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_cpu (object);
}

/**
 * systemd1_manager_set_default_limit_cpu: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitCPU">"DefaultLimitCPU"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_cpu (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-cpu", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_cpusoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitCPUSoft">"DefaultLimitCPUSoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_cpusoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_cpusoft (object);
}

/**
 * systemd1_manager_set_default_limit_cpusoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitCPUSoft">"DefaultLimitCPUSoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_cpusoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-cpusoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_fsize: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitFSIZE">"DefaultLimitFSIZE"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_fsize (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_fsize (object);
}

/**
 * systemd1_manager_set_default_limit_fsize: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitFSIZE">"DefaultLimitFSIZE"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_fsize (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-fsize", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_fsizesoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitFSIZESoft">"DefaultLimitFSIZESoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_fsizesoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_fsizesoft (object);
}

/**
 * systemd1_manager_set_default_limit_fsizesoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitFSIZESoft">"DefaultLimitFSIZESoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_fsizesoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-fsizesoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_data: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitDATA">"DefaultLimitDATA"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_data (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_data (object);
}

/**
 * systemd1_manager_set_default_limit_data: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitDATA">"DefaultLimitDATA"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_data (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-data", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_datasoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitDATASoft">"DefaultLimitDATASoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_datasoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_datasoft (object);
}

/**
 * systemd1_manager_set_default_limit_datasoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitDATASoft">"DefaultLimitDATASoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_datasoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-datasoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_stack: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitSTACK">"DefaultLimitSTACK"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_stack (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_stack (object);
}

/**
 * systemd1_manager_set_default_limit_stack: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitSTACK">"DefaultLimitSTACK"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_stack (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-stack", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_stacksoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitSTACKSoft">"DefaultLimitSTACKSoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_stacksoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_stacksoft (object);
}

/**
 * systemd1_manager_set_default_limit_stacksoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitSTACKSoft">"DefaultLimitSTACKSoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_stacksoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-stacksoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_core: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitCORE">"DefaultLimitCORE"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_core (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_core (object);
}

/**
 * systemd1_manager_set_default_limit_core: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitCORE">"DefaultLimitCORE"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_core (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-core", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_coresoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitCORESoft">"DefaultLimitCORESoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_coresoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_coresoft (object);
}

/**
 * systemd1_manager_set_default_limit_coresoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitCORESoft">"DefaultLimitCORESoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_coresoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-coresoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_rss: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRSS">"DefaultLimitRSS"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_rss (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_rss (object);
}

/**
 * systemd1_manager_set_default_limit_rss: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRSS">"DefaultLimitRSS"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_rss (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-rss", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_rsssoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRSSSoft">"DefaultLimitRSSSoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_rsssoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_rsssoft (object);
}

/**
 * systemd1_manager_set_default_limit_rsssoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRSSSoft">"DefaultLimitRSSSoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_rsssoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-rsssoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_nofile: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNOFILE">"DefaultLimitNOFILE"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_nofile (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_nofile (object);
}

/**
 * systemd1_manager_set_default_limit_nofile: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNOFILE">"DefaultLimitNOFILE"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_nofile (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-nofile", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_nofilesoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNOFILESoft">"DefaultLimitNOFILESoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_nofilesoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_nofilesoft (object);
}

/**
 * systemd1_manager_set_default_limit_nofilesoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNOFILESoft">"DefaultLimitNOFILESoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_nofilesoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-nofilesoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_as: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitAS">"DefaultLimitAS"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_as (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_as (object);
}

/**
 * systemd1_manager_set_default_limit_as: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitAS">"DefaultLimitAS"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_as (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-as", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_assoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitASSoft">"DefaultLimitASSoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_assoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_assoft (object);
}

/**
 * systemd1_manager_set_default_limit_assoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitASSoft">"DefaultLimitASSoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_assoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-assoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_nproc: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNPROC">"DefaultLimitNPROC"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_nproc (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_nproc (object);
}

/**
 * systemd1_manager_set_default_limit_nproc: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNPROC">"DefaultLimitNPROC"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_nproc (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-nproc", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_nprocsoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNPROCSoft">"DefaultLimitNPROCSoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_nprocsoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_nprocsoft (object);
}

/**
 * systemd1_manager_set_default_limit_nprocsoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNPROCSoft">"DefaultLimitNPROCSoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_nprocsoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-nprocsoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_memlock: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitMEMLOCK">"DefaultLimitMEMLOCK"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_memlock (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_memlock (object);
}

/**
 * systemd1_manager_set_default_limit_memlock: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitMEMLOCK">"DefaultLimitMEMLOCK"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_memlock (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-memlock", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_memlocksoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitMEMLOCKSoft">"DefaultLimitMEMLOCKSoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_memlocksoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_memlocksoft (object);
}

/**
 * systemd1_manager_set_default_limit_memlocksoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitMEMLOCKSoft">"DefaultLimitMEMLOCKSoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_memlocksoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-memlocksoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_locks: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitLOCKS">"DefaultLimitLOCKS"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_locks (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_locks (object);
}

/**
 * systemd1_manager_set_default_limit_locks: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitLOCKS">"DefaultLimitLOCKS"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_locks (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-locks", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_lockssoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitLOCKSSoft">"DefaultLimitLOCKSSoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_lockssoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_lockssoft (object);
}

/**
 * systemd1_manager_set_default_limit_lockssoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitLOCKSSoft">"DefaultLimitLOCKSSoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_lockssoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-lockssoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_sigpending: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitSIGPENDING">"DefaultLimitSIGPENDING"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_sigpending (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_sigpending (object);
}

/**
 * systemd1_manager_set_default_limit_sigpending: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitSIGPENDING">"DefaultLimitSIGPENDING"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_sigpending (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-sigpending", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_sigpendingsoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitSIGPENDINGSoft">"DefaultLimitSIGPENDINGSoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_sigpendingsoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_sigpendingsoft (object);
}

/**
 * systemd1_manager_set_default_limit_sigpendingsoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitSIGPENDINGSoft">"DefaultLimitSIGPENDINGSoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_sigpendingsoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-sigpendingsoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_msgqueue: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitMSGQUEUE">"DefaultLimitMSGQUEUE"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_msgqueue (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_msgqueue (object);
}

/**
 * systemd1_manager_set_default_limit_msgqueue: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitMSGQUEUE">"DefaultLimitMSGQUEUE"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_msgqueue (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-msgqueue", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_msgqueuesoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitMSGQUEUESoft">"DefaultLimitMSGQUEUESoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_msgqueuesoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_msgqueuesoft (object);
}

/**
 * systemd1_manager_set_default_limit_msgqueuesoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitMSGQUEUESoft">"DefaultLimitMSGQUEUESoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_msgqueuesoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-msgqueuesoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_nice: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNICE">"DefaultLimitNICE"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_nice (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_nice (object);
}

/**
 * systemd1_manager_set_default_limit_nice: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNICE">"DefaultLimitNICE"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_nice (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-nice", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_nicesoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNICESoft">"DefaultLimitNICESoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_nicesoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_nicesoft (object);
}

/**
 * systemd1_manager_set_default_limit_nicesoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitNICESoft">"DefaultLimitNICESoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_nicesoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-nicesoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_rtprio: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRTPRIO">"DefaultLimitRTPRIO"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_rtprio (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_rtprio (object);
}

/**
 * systemd1_manager_set_default_limit_rtprio: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRTPRIO">"DefaultLimitRTPRIO"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_rtprio (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-rtprio", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_rtpriosoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRTPRIOSoft">"DefaultLimitRTPRIOSoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_rtpriosoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_rtpriosoft (object);
}

/**
 * systemd1_manager_set_default_limit_rtpriosoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRTPRIOSoft">"DefaultLimitRTPRIOSoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_rtpriosoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-rtpriosoft", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_rttime: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRTTIME">"DefaultLimitRTTIME"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_rttime (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_rttime (object);
}

/**
 * systemd1_manager_set_default_limit_rttime: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRTTIME">"DefaultLimitRTTIME"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_rttime (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-rttime", value, NULL);
}

/**
 * systemd1_manager_get_default_limit_rttimesoft: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRTTIMESoft">"DefaultLimitRTTIMESoft"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_limit_rttimesoft (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_limit_rttimesoft (object);
}

/**
 * systemd1_manager_set_default_limit_rttimesoft: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultLimitRTTIMESoft">"DefaultLimitRTTIMESoft"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_limit_rttimesoft (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-limit-rttimesoft", value, NULL);
}

/**
 * systemd1_manager_get_default_tasks_max: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTasksMax">"DefaultTasksMax"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_default_tasks_max (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_tasks_max (object);
}

/**
 * systemd1_manager_set_default_tasks_max: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultTasksMax">"DefaultTasksMax"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_tasks_max (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "default-tasks-max", value, NULL);
}

/**
 * systemd1_manager_get_timer_slack_nsec: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.TimerSlackNSec">"TimerSlackNSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_manager_get_timer_slack_nsec (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_timer_slack_nsec (object);
}

/**
 * systemd1_manager_set_timer_slack_nsec: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.TimerSlackNSec">"TimerSlackNSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_timer_slack_nsec (Systemd1Manager *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "timer-slack-nsec", value, NULL);
}

/**
 * systemd1_manager_get_default_oompolicy: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultOOMPolicy">"DefaultOOMPolicy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_default_oompolicy() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_manager_get_default_oompolicy (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_default_oompolicy (object);
}

/**
 * systemd1_manager_dup_default_oompolicy: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultOOMPolicy">"DefaultOOMPolicy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_manager_dup_default_oompolicy (Systemd1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "default-oompolicy", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_default_oompolicy: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.DefaultOOMPolicy">"DefaultOOMPolicy"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_default_oompolicy (Systemd1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "default-oompolicy", value, NULL);
}

/**
 * systemd1_manager_get_ctrl_alt_del_burst_action: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.CtrlAltDelBurstAction">"CtrlAltDelBurstAction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_manager_dup_ctrl_alt_del_burst_action() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_manager_get_ctrl_alt_del_burst_action (Systemd1Manager *object)
{
  return SYSTEMD1_MANAGER_GET_IFACE (object)->get_ctrl_alt_del_burst_action (object);
}

/**
 * systemd1_manager_dup_ctrl_alt_del_burst_action: (skip)
 * @object: A #Systemd1Manager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.CtrlAltDelBurstAction">"CtrlAltDelBurstAction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_manager_dup_ctrl_alt_del_burst_action (Systemd1Manager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "ctrl-alt-del-burst-action", &value, NULL);
  return value;
}

/**
 * systemd1_manager_set_ctrl_alt_del_burst_action: (skip)
 * @object: A #Systemd1Manager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Manager.CtrlAltDelBurstAction">"CtrlAltDelBurstAction"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_manager_set_ctrl_alt_del_burst_action (Systemd1Manager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "ctrl-alt-del-burst-action", value, NULL);
}

/**
 * systemd1_manager_emit_unit_new:
 * @object: A #Systemd1Manager.
 * @arg_id: Argument to pass with the signal.
 * @arg_unit: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-systemd1-Manager.UnitNew">"UnitNew"</link> D-Bus signal.
 */
void
systemd1_manager_emit_unit_new (
    Systemd1Manager *object,
    const gchar *arg_id,
    const gchar *arg_unit)
{
  g_signal_emit_by_name (object, "unit-new", arg_id, arg_unit);
}

/**
 * systemd1_manager_emit_unit_removed:
 * @object: A #Systemd1Manager.
 * @arg_id: Argument to pass with the signal.
 * @arg_unit: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-systemd1-Manager.UnitRemoved">"UnitRemoved"</link> D-Bus signal.
 */
void
systemd1_manager_emit_unit_removed (
    Systemd1Manager *object,
    const gchar *arg_id,
    const gchar *arg_unit)
{
  g_signal_emit_by_name (object, "unit-removed", arg_id, arg_unit);
}

/**
 * systemd1_manager_emit_job_new:
 * @object: A #Systemd1Manager.
 * @arg_id: Argument to pass with the signal.
 * @arg_job: Argument to pass with the signal.
 * @arg_unit: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-systemd1-Manager.JobNew">"JobNew"</link> D-Bus signal.
 */
void
systemd1_manager_emit_job_new (
    Systemd1Manager *object,
    guint arg_id,
    const gchar *arg_job,
    const gchar *arg_unit)
{
  g_signal_emit_by_name (object, "job-new", arg_id, arg_job, arg_unit);
}

/**
 * systemd1_manager_emit_job_removed:
 * @object: A #Systemd1Manager.
 * @arg_id: Argument to pass with the signal.
 * @arg_job: Argument to pass with the signal.
 * @arg_unit: Argument to pass with the signal.
 * @arg_result: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-systemd1-Manager.JobRemoved">"JobRemoved"</link> D-Bus signal.
 */
void
systemd1_manager_emit_job_removed (
    Systemd1Manager *object,
    guint arg_id,
    const gchar *arg_job,
    const gchar *arg_unit,
    const gchar *arg_result)
{
  g_signal_emit_by_name (object, "job-removed", arg_id, arg_job, arg_unit, arg_result);
}

/**
 * systemd1_manager_emit_startup_finished:
 * @object: A #Systemd1Manager.
 * @arg_firmware: Argument to pass with the signal.
 * @arg_loader: Argument to pass with the signal.
 * @arg_kernel: Argument to pass with the signal.
 * @arg_initrd: Argument to pass with the signal.
 * @arg_userspace: Argument to pass with the signal.
 * @arg_total: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-systemd1-Manager.StartupFinished">"StartupFinished"</link> D-Bus signal.
 */
void
systemd1_manager_emit_startup_finished (
    Systemd1Manager *object,
    guint64 arg_firmware,
    guint64 arg_loader,
    guint64 arg_kernel,
    guint64 arg_initrd,
    guint64 arg_userspace,
    guint64 arg_total)
{
  g_signal_emit_by_name (object, "startup-finished", arg_firmware, arg_loader, arg_kernel, arg_initrd, arg_userspace, arg_total);
}

/**
 * systemd1_manager_emit_unit_files_changed:
 * @object: A #Systemd1Manager.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-systemd1-Manager.UnitFilesChanged">"UnitFilesChanged"</link> D-Bus signal.
 */
void
systemd1_manager_emit_unit_files_changed (
    Systemd1Manager *object)
{
  g_signal_emit_by_name (object, "unit-files-changed");
}

/**
 * systemd1_manager_emit_reloading:
 * @object: A #Systemd1Manager.
 * @arg_active: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-systemd1-Manager.Reloading">"Reloading"</link> D-Bus signal.
 */
void
systemd1_manager_emit_reloading (
    Systemd1Manager *object,
    gboolean arg_active)
{
  g_signal_emit_by_name (object, "reloading", arg_active);
}

/**
 * systemd1_manager_call_get_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnit">GetUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_get_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_get_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_get_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetUnit",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_get_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_unit: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_get_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_get_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_unit_finish (
    Systemd1Manager *proxy,
    gchar **out_unit,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_unit);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @out_unit: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnit">GetUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_get_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    gchar **out_unit,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetUnit",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_unit);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_unit_by_pid:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitByPID">GetUnitByPID()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_get_unit_by_pid_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_get_unit_by_pid_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_get_unit_by_pid (
    Systemd1Manager *proxy,
    guint arg_pid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetUnitByPID",
    g_variant_new ("(u)",
                   arg_pid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_get_unit_by_pid_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_unit: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_get_unit_by_pid().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_get_unit_by_pid().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_unit_by_pid_finish (
    Systemd1Manager *proxy,
    gchar **out_unit,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_unit);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_unit_by_pid_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @out_unit: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitByPID">GetUnitByPID()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_get_unit_by_pid() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_unit_by_pid_sync (
    Systemd1Manager *proxy,
    guint arg_pid,
    gchar **out_unit,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetUnitByPID",
    g_variant_new ("(u)",
                   arg_pid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_unit);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_unit_by_invocation_id:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_invocation_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitByInvocationID">GetUnitByInvocationID()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_get_unit_by_invocation_id_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_get_unit_by_invocation_id_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_get_unit_by_invocation_id (
    Systemd1Manager *proxy,
    const gchar *arg_invocation_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetUnitByInvocationID",
    g_variant_new ("(^ay)",
                   arg_invocation_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_get_unit_by_invocation_id_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_unit: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_get_unit_by_invocation_id().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_get_unit_by_invocation_id().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_unit_by_invocation_id_finish (
    Systemd1Manager *proxy,
    gchar **out_unit,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_unit);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_unit_by_invocation_id_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_invocation_id: Argument to pass with the method invocation.
 * @out_unit: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitByInvocationID">GetUnitByInvocationID()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_get_unit_by_invocation_id() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_unit_by_invocation_id_sync (
    Systemd1Manager *proxy,
    const gchar *arg_invocation_id,
    gchar **out_unit,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetUnitByInvocationID",
    g_variant_new ("(^ay)",
                   arg_invocation_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_unit);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_unit_by_control_group:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_cgroup: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitByControlGroup">GetUnitByControlGroup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_get_unit_by_control_group_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_get_unit_by_control_group_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_get_unit_by_control_group (
    Systemd1Manager *proxy,
    const gchar *arg_cgroup,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetUnitByControlGroup",
    g_variant_new ("(s)",
                   arg_cgroup),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_get_unit_by_control_group_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_unit: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_get_unit_by_control_group().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_get_unit_by_control_group().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_unit_by_control_group_finish (
    Systemd1Manager *proxy,
    gchar **out_unit,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_unit);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_unit_by_control_group_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_cgroup: Argument to pass with the method invocation.
 * @out_unit: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitByControlGroup">GetUnitByControlGroup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_get_unit_by_control_group() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_unit_by_control_group_sync (
    Systemd1Manager *proxy,
    const gchar *arg_cgroup,
    gchar **out_unit,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetUnitByControlGroup",
    g_variant_new ("(s)",
                   arg_cgroup),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_unit);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_load_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LoadUnit">LoadUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_load_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_load_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_load_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "LoadUnit",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_load_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_unit: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_load_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_load_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_load_unit_finish (
    Systemd1Manager *proxy,
    gchar **out_unit,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_unit);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_load_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @out_unit: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LoadUnit">LoadUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_load_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_load_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    gchar **out_unit,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "LoadUnit",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_unit);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_start_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StartUnit">StartUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_start_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_start_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_start_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StartUnit",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_start_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_start_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_start_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_start_unit_finish (
    Systemd1Manager *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_start_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StartUnit">StartUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_start_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_start_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StartUnit",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_start_unit_replace:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_old_unit: Argument to pass with the method invocation.
 * @arg_new_unit: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StartUnitReplace">StartUnitReplace()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_start_unit_replace_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_start_unit_replace_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_start_unit_replace (
    Systemd1Manager *proxy,
    const gchar *arg_old_unit,
    const gchar *arg_new_unit,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StartUnitReplace",
    g_variant_new ("(sss)",
                   arg_old_unit,
                   arg_new_unit,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_start_unit_replace_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_start_unit_replace().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_start_unit_replace().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_start_unit_replace_finish (
    Systemd1Manager *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_start_unit_replace_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_old_unit: Argument to pass with the method invocation.
 * @arg_new_unit: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StartUnitReplace">StartUnitReplace()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_start_unit_replace() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_start_unit_replace_sync (
    Systemd1Manager *proxy,
    const gchar *arg_old_unit,
    const gchar *arg_new_unit,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StartUnitReplace",
    g_variant_new ("(sss)",
                   arg_old_unit,
                   arg_new_unit,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_stop_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StopUnit">StopUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_stop_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_stop_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_stop_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StopUnit",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_stop_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_stop_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_stop_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_stop_unit_finish (
    Systemd1Manager *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_stop_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StopUnit">StopUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_stop_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_stop_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StopUnit",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reload_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReloadUnit">ReloadUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_reload_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_reload_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_reload_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReloadUnit",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_reload_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_reload_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_reload_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reload_unit_finish (
    Systemd1Manager *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reload_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReloadUnit">ReloadUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_reload_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reload_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReloadUnit",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_restart_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.RestartUnit">RestartUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_restart_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_restart_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_restart_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RestartUnit",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_restart_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_restart_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_restart_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_restart_unit_finish (
    Systemd1Manager *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_restart_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.RestartUnit">RestartUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_restart_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_restart_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RestartUnit",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_try_restart_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.TryRestartUnit">TryRestartUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_try_restart_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_try_restart_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_try_restart_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "TryRestartUnit",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_try_restart_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_try_restart_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_try_restart_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_try_restart_unit_finish (
    Systemd1Manager *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_try_restart_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.TryRestartUnit">TryRestartUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_try_restart_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_try_restart_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "TryRestartUnit",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reload_or_restart_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReloadOrRestartUnit">ReloadOrRestartUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_reload_or_restart_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_reload_or_restart_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_reload_or_restart_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReloadOrRestartUnit",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_reload_or_restart_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_reload_or_restart_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_reload_or_restart_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reload_or_restart_unit_finish (
    Systemd1Manager *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reload_or_restart_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReloadOrRestartUnit">ReloadOrRestartUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_reload_or_restart_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reload_or_restart_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReloadOrRestartUnit",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reload_or_try_restart_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReloadOrTryRestartUnit">ReloadOrTryRestartUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_reload_or_try_restart_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_reload_or_try_restart_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_reload_or_try_restart_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReloadOrTryRestartUnit",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_reload_or_try_restart_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_reload_or_try_restart_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_reload_or_try_restart_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reload_or_try_restart_unit_finish (
    Systemd1Manager *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reload_or_try_restart_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReloadOrTryRestartUnit">ReloadOrTryRestartUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_reload_or_try_restart_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reload_or_try_restart_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReloadOrTryRestartUnit",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_enqueue_unit_job:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_job_type: Argument to pass with the method invocation.
 * @arg_job_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnqueueUnitJob">EnqueueUnitJob()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_enqueue_unit_job_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_enqueue_unit_job_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_enqueue_unit_job (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_job_type,
    const gchar *arg_job_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnqueueUnitJob",
    g_variant_new ("(sss)",
                   arg_name,
                   arg_job_type,
                   arg_job_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_enqueue_unit_job_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_job_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_job_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_unit_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_unit_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_job_type: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_affected_jobs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_enqueue_unit_job().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_enqueue_unit_job().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_enqueue_unit_job_finish (
    Systemd1Manager *proxy,
    guint *out_job_id,
    gchar **out_job_path,
    gchar **out_unit_id,
    gchar **out_unit_path,
    gchar **out_job_type,
    GVariant **out_affected_jobs,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(uosos@a(uosos))",
                 out_job_id,
                 out_job_path,
                 out_unit_id,
                 out_unit_path,
                 out_job_type,
                 out_affected_jobs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_enqueue_unit_job_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_job_type: Argument to pass with the method invocation.
 * @arg_job_mode: Argument to pass with the method invocation.
 * @out_job_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_job_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_unit_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_unit_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_job_type: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_affected_jobs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnqueueUnitJob">EnqueueUnitJob()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_enqueue_unit_job() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_enqueue_unit_job_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_job_type,
    const gchar *arg_job_mode,
    guint *out_job_id,
    gchar **out_job_path,
    gchar **out_unit_id,
    gchar **out_unit_path,
    gchar **out_job_type,
    GVariant **out_affected_jobs,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnqueueUnitJob",
    g_variant_new ("(sss)",
                   arg_name,
                   arg_job_type,
                   arg_job_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(uosos@a(uosos))",
                 out_job_id,
                 out_job_path,
                 out_unit_id,
                 out_unit_path,
                 out_job_type,
                 out_affected_jobs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_kill_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_whom: Argument to pass with the method invocation.
 * @arg_signal: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.KillUnit">KillUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_kill_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_kill_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_kill_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_whom,
    gint arg_signal,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "KillUnit",
    g_variant_new ("(ssi)",
                   arg_name,
                   arg_whom,
                   arg_signal),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_kill_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_kill_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_kill_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_kill_unit_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_kill_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_whom: Argument to pass with the method invocation.
 * @arg_signal: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.KillUnit">KillUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_kill_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_kill_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_whom,
    gint arg_signal,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "KillUnit",
    g_variant_new ("(ssi)",
                   arg_name,
                   arg_whom,
                   arg_signal),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_clean_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mask: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.CleanUnit">CleanUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_clean_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_clean_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_clean_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *const *arg_mask,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CleanUnit",
    g_variant_new ("(s^as)",
                   arg_name,
                   arg_mask),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_clean_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_clean_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_clean_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_clean_unit_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_clean_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mask: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.CleanUnit">CleanUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_clean_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_clean_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *const *arg_mask,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CleanUnit",
    g_variant_new ("(s^as)",
                   arg_name,
                   arg_mask),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_freeze_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.FreezeUnit">FreezeUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_freeze_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_freeze_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_freeze_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FreezeUnit",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_freeze_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_freeze_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_freeze_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_freeze_unit_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_freeze_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.FreezeUnit">FreezeUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_freeze_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_freeze_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FreezeUnit",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_thaw_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ThawUnit">ThawUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_thaw_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_thaw_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_thaw_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ThawUnit",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_thaw_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_thaw_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_thaw_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_thaw_unit_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_thaw_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ThawUnit">ThawUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_thaw_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_thaw_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ThawUnit",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reset_failed_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ResetFailedUnit">ResetFailedUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_reset_failed_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_reset_failed_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_reset_failed_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ResetFailedUnit",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_reset_failed_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_reset_failed_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_reset_failed_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reset_failed_unit_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reset_failed_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ResetFailedUnit">ResetFailedUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_reset_failed_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reset_failed_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ResetFailedUnit",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_set_unit_properties:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetUnitProperties">SetUnitProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_set_unit_properties_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_set_unit_properties_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_set_unit_properties (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    gboolean arg_runtime,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetUnitProperties",
    g_variant_new ("(sb@a(sv))",
                   arg_name,
                   arg_runtime,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_set_unit_properties_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_set_unit_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_set_unit_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_set_unit_properties_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_set_unit_properties_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetUnitProperties">SetUnitProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_set_unit_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_set_unit_properties_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    gboolean arg_runtime,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetUnitProperties",
    g_variant_new ("(sb@a(sv))",
                   arg_name,
                   arg_runtime,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_bind_mount_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_source: Argument to pass with the method invocation.
 * @arg_destination: Argument to pass with the method invocation.
 * @arg_read_only: Argument to pass with the method invocation.
 * @arg_mkdir: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.BindMountUnit">BindMountUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_bind_mount_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_bind_mount_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_bind_mount_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_source,
    const gchar *arg_destination,
    gboolean arg_read_only,
    gboolean arg_mkdir,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "BindMountUnit",
    g_variant_new ("(sssbb)",
                   arg_name,
                   arg_source,
                   arg_destination,
                   arg_read_only,
                   arg_mkdir),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_bind_mount_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_bind_mount_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_bind_mount_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_bind_mount_unit_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_bind_mount_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_source: Argument to pass with the method invocation.
 * @arg_destination: Argument to pass with the method invocation.
 * @arg_read_only: Argument to pass with the method invocation.
 * @arg_mkdir: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.BindMountUnit">BindMountUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_bind_mount_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_bind_mount_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_source,
    const gchar *arg_destination,
    gboolean arg_read_only,
    gboolean arg_mkdir,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "BindMountUnit",
    g_variant_new ("(sssbb)",
                   arg_name,
                   arg_source,
                   arg_destination,
                   arg_read_only,
                   arg_mkdir),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_mount_image_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_source: Argument to pass with the method invocation.
 * @arg_destination: Argument to pass with the method invocation.
 * @arg_read_only: Argument to pass with the method invocation.
 * @arg_mkdir: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.MountImageUnit">MountImageUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_mount_image_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_mount_image_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_mount_image_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_source,
    const gchar *arg_destination,
    gboolean arg_read_only,
    gboolean arg_mkdir,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "MountImageUnit",
    g_variant_new ("(sssbb@a(ss))",
                   arg_name,
                   arg_source,
                   arg_destination,
                   arg_read_only,
                   arg_mkdir,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_mount_image_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_mount_image_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_mount_image_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_mount_image_unit_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_mount_image_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_source: Argument to pass with the method invocation.
 * @arg_destination: Argument to pass with the method invocation.
 * @arg_read_only: Argument to pass with the method invocation.
 * @arg_mkdir: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.MountImageUnit">MountImageUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_mount_image_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_mount_image_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_source,
    const gchar *arg_destination,
    gboolean arg_read_only,
    gboolean arg_mkdir,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "MountImageUnit",
    g_variant_new ("(sssbb@a(ss))",
                   arg_name,
                   arg_source,
                   arg_destination,
                   arg_read_only,
                   arg_mkdir,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_ref_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.RefUnit">RefUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_ref_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_ref_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_ref_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RefUnit",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_ref_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_ref_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_ref_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_ref_unit_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_ref_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.RefUnit">RefUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_ref_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_ref_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RefUnit",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_unref_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnrefUnit">UnrefUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_unref_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_unref_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_unref_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnrefUnit",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_unref_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_unref_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_unref_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_unref_unit_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_unref_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnrefUnit">UnrefUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_unref_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_unref_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnrefUnit",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_start_transient_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @arg_aux: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StartTransientUnit">StartTransientUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_start_transient_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_start_transient_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_start_transient_unit (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    GVariant *arg_properties,
    GVariant *arg_aux,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StartTransientUnit",
    g_variant_new ("(ss@a(sv)@a(sa(sv)))",
                   arg_name,
                   arg_mode,
                   arg_properties,
                   arg_aux),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_start_transient_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_start_transient_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_start_transient_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_start_transient_unit_finish (
    Systemd1Manager *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_start_transient_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @arg_aux: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StartTransientUnit">StartTransientUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_start_transient_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_start_transient_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    const gchar *arg_mode,
    GVariant *arg_properties,
    GVariant *arg_aux,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StartTransientUnit",
    g_variant_new ("(ss@a(sv)@a(sa(sv)))",
                   arg_name,
                   arg_mode,
                   arg_properties,
                   arg_aux),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_unit_processes:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitProcesses">GetUnitProcesses()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_get_unit_processes_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_get_unit_processes_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_get_unit_processes (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetUnitProcesses",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_get_unit_processes_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_processes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_get_unit_processes().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_get_unit_processes().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_unit_processes_finish (
    Systemd1Manager *proxy,
    GVariant **out_processes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sus))",
                 out_processes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_unit_processes_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @out_processes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitProcesses">GetUnitProcesses()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_get_unit_processes() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_unit_processes_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GVariant **out_processes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetUnitProcesses",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sus))",
                 out_processes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_attach_processes_to_unit:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_unit_name: Argument to pass with the method invocation.
 * @arg_subcgroup: Argument to pass with the method invocation.
 * @arg_pids: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.AttachProcessesToUnit">AttachProcessesToUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_attach_processes_to_unit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_attach_processes_to_unit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_attach_processes_to_unit (
    Systemd1Manager *proxy,
    const gchar *arg_unit_name,
    const gchar *arg_subcgroup,
    GVariant *arg_pids,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AttachProcessesToUnit",
    g_variant_new ("(ss@au)",
                   arg_unit_name,
                   arg_subcgroup,
                   arg_pids),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_attach_processes_to_unit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_attach_processes_to_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_attach_processes_to_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_attach_processes_to_unit_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_attach_processes_to_unit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_unit_name: Argument to pass with the method invocation.
 * @arg_subcgroup: Argument to pass with the method invocation.
 * @arg_pids: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.AttachProcessesToUnit">AttachProcessesToUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_attach_processes_to_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_attach_processes_to_unit_sync (
    Systemd1Manager *proxy,
    const gchar *arg_unit_name,
    const gchar *arg_subcgroup,
    GVariant *arg_pids,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AttachProcessesToUnit",
    g_variant_new ("(ss@au)",
                   arg_unit_name,
                   arg_subcgroup,
                   arg_pids),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_abandon_scope:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.AbandonScope">AbandonScope()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_abandon_scope_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_abandon_scope_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_abandon_scope (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AbandonScope",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_abandon_scope_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_abandon_scope().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_abandon_scope().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_abandon_scope_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_abandon_scope_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.AbandonScope">AbandonScope()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_abandon_scope() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_abandon_scope_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AbandonScope",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_job:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetJob">GetJob()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_get_job_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_get_job_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_get_job (
    Systemd1Manager *proxy,
    guint arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetJob",
    g_variant_new ("(u)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_get_job_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_get_job().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_get_job().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_job_finish (
    Systemd1Manager *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_job_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetJob">GetJob()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_get_job() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_job_sync (
    Systemd1Manager *proxy,
    guint arg_id,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetJob",
    g_variant_new ("(u)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_job_after:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetJobAfter">GetJobAfter()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_get_job_after_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_get_job_after_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_get_job_after (
    Systemd1Manager *proxy,
    guint arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetJobAfter",
    g_variant_new ("(u)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_get_job_after_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_jobs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_get_job_after().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_get_job_after().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_job_after_finish (
    Systemd1Manager *proxy,
    GVariant **out_jobs,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(usssoo))",
                 out_jobs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_job_after_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @out_jobs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetJobAfter">GetJobAfter()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_get_job_after() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_job_after_sync (
    Systemd1Manager *proxy,
    guint arg_id,
    GVariant **out_jobs,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetJobAfter",
    g_variant_new ("(u)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(usssoo))",
                 out_jobs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_job_before:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetJobBefore">GetJobBefore()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_get_job_before_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_get_job_before_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_get_job_before (
    Systemd1Manager *proxy,
    guint arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetJobBefore",
    g_variant_new ("(u)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_get_job_before_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_jobs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_get_job_before().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_get_job_before().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_job_before_finish (
    Systemd1Manager *proxy,
    GVariant **out_jobs,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(usssoo))",
                 out_jobs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_job_before_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @out_jobs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetJobBefore">GetJobBefore()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_get_job_before() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_job_before_sync (
    Systemd1Manager *proxy,
    guint arg_id,
    GVariant **out_jobs,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetJobBefore",
    g_variant_new ("(u)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(usssoo))",
                 out_jobs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_cancel_job:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.CancelJob">CancelJob()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_cancel_job_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_cancel_job_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_cancel_job (
    Systemd1Manager *proxy,
    guint arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CancelJob",
    g_variant_new ("(u)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_cancel_job_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_cancel_job().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_cancel_job().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_cancel_job_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_cancel_job_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.CancelJob">CancelJob()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_cancel_job() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_cancel_job_sync (
    Systemd1Manager *proxy,
    guint arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CancelJob",
    g_variant_new ("(u)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_clear_jobs:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ClearJobs">ClearJobs()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_clear_jobs_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_clear_jobs_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_clear_jobs (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ClearJobs",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_clear_jobs_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_clear_jobs().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_clear_jobs().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_clear_jobs_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_clear_jobs_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ClearJobs">ClearJobs()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_clear_jobs() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_clear_jobs_sync (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ClearJobs",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reset_failed:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ResetFailed">ResetFailed()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_reset_failed_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_reset_failed_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_reset_failed (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ResetFailed",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_reset_failed_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_reset_failed().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_reset_failed().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reset_failed_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reset_failed_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ResetFailed">ResetFailed()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_reset_failed() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reset_failed_sync (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ResetFailed",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_set_show_status:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetShowStatus">SetShowStatus()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_set_show_status_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_set_show_status_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_set_show_status (
    Systemd1Manager *proxy,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetShowStatus",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_set_show_status_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_set_show_status().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_set_show_status().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_set_show_status_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_set_show_status_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetShowStatus">SetShowStatus()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_set_show_status() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_set_show_status_sync (
    Systemd1Manager *proxy,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetShowStatus",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_list_units:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnits">ListUnits()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_list_units_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_list_units_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_list_units (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListUnits",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_list_units_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_units: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_list_units().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_list_units().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_list_units_finish (
    Systemd1Manager *proxy,
    GVariant **out_units,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ssssssouso))",
                 out_units);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_list_units_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_units: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnits">ListUnits()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_list_units() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_list_units_sync (
    Systemd1Manager *proxy,
    GVariant **out_units,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListUnits",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ssssssouso))",
                 out_units);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_list_units_filtered:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_states: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitsFiltered">ListUnitsFiltered()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_list_units_filtered_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_list_units_filtered_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_list_units_filtered (
    Systemd1Manager *proxy,
    const gchar *const *arg_states,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListUnitsFiltered",
    g_variant_new ("(^as)",
                   arg_states),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_list_units_filtered_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_units: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_list_units_filtered().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_list_units_filtered().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_list_units_filtered_finish (
    Systemd1Manager *proxy,
    GVariant **out_units,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ssssssouso))",
                 out_units);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_list_units_filtered_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_states: Argument to pass with the method invocation.
 * @out_units: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitsFiltered">ListUnitsFiltered()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_list_units_filtered() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_list_units_filtered_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_states,
    GVariant **out_units,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListUnitsFiltered",
    g_variant_new ("(^as)",
                   arg_states),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ssssssouso))",
                 out_units);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_list_units_by_patterns:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_states: Argument to pass with the method invocation.
 * @arg_patterns: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitsByPatterns">ListUnitsByPatterns()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_list_units_by_patterns_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_list_units_by_patterns_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_list_units_by_patterns (
    Systemd1Manager *proxy,
    const gchar *const *arg_states,
    const gchar *const *arg_patterns,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListUnitsByPatterns",
    g_variant_new ("(^as^as)",
                   arg_states,
                   arg_patterns),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_list_units_by_patterns_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_units: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_list_units_by_patterns().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_list_units_by_patterns().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_list_units_by_patterns_finish (
    Systemd1Manager *proxy,
    GVariant **out_units,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ssssssouso))",
                 out_units);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_list_units_by_patterns_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_states: Argument to pass with the method invocation.
 * @arg_patterns: Argument to pass with the method invocation.
 * @out_units: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitsByPatterns">ListUnitsByPatterns()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_list_units_by_patterns() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_list_units_by_patterns_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_states,
    const gchar *const *arg_patterns,
    GVariant **out_units,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListUnitsByPatterns",
    g_variant_new ("(^as^as)",
                   arg_states,
                   arg_patterns),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ssssssouso))",
                 out_units);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_list_units_by_names:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_names: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitsByNames">ListUnitsByNames()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_list_units_by_names_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_list_units_by_names_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_list_units_by_names (
    Systemd1Manager *proxy,
    const gchar *const *arg_names,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListUnitsByNames",
    g_variant_new ("(^as)",
                   arg_names),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_list_units_by_names_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_units: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_list_units_by_names().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_list_units_by_names().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_list_units_by_names_finish (
    Systemd1Manager *proxy,
    GVariant **out_units,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ssssssouso))",
                 out_units);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_list_units_by_names_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_names: Argument to pass with the method invocation.
 * @out_units: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitsByNames">ListUnitsByNames()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_list_units_by_names() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_list_units_by_names_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_names,
    GVariant **out_units,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListUnitsByNames",
    g_variant_new ("(^as)",
                   arg_names),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ssssssouso))",
                 out_units);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_list_jobs:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListJobs">ListJobs()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_list_jobs_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_list_jobs_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_list_jobs (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListJobs",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_list_jobs_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_jobs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_list_jobs().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_list_jobs().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_list_jobs_finish (
    Systemd1Manager *proxy,
    GVariant **out_jobs,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(usssoo))",
                 out_jobs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_list_jobs_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_jobs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListJobs">ListJobs()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_list_jobs() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_list_jobs_sync (
    Systemd1Manager *proxy,
    GVariant **out_jobs,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListJobs",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(usssoo))",
                 out_jobs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_subscribe:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Subscribe">Subscribe()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_subscribe_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_subscribe_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_subscribe (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Subscribe",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_subscribe_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_subscribe().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_subscribe().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_subscribe_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_subscribe_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Subscribe">Subscribe()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_subscribe() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_subscribe_sync (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Subscribe",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_unsubscribe:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Unsubscribe">Unsubscribe()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_unsubscribe_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_unsubscribe_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_unsubscribe (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Unsubscribe",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_unsubscribe_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_unsubscribe().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_unsubscribe().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_unsubscribe_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_unsubscribe_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Unsubscribe">Unsubscribe()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_unsubscribe() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_unsubscribe_sync (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Unsubscribe",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_dump:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Dump">Dump()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_dump_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_dump_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_dump (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Dump",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_dump_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_output: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_dump().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_dump().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_dump_finish (
    Systemd1Manager *proxy,
    gchar **out_output,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_output);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_dump_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_output: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Dump">Dump()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_dump() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_dump_sync (
    Systemd1Manager *proxy,
    gchar **out_output,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Dump",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_output);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_dump_by_file_descriptor:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.DumpByFileDescriptor">DumpByFileDescriptor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_dump_by_file_descriptor_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_dump_by_file_descriptor_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_dump_by_file_descriptor (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DumpByFileDescriptor",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_dump_by_file_descriptor_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_dump_by_file_descriptor().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_dump_by_file_descriptor().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_dump_by_file_descriptor_finish (
    Systemd1Manager *proxy,
    GVariant **out_fd,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_dump_by_file_descriptor_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.DumpByFileDescriptor">DumpByFileDescriptor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_dump_by_file_descriptor() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_dump_by_file_descriptor_sync (
    Systemd1Manager *proxy,
    GVariant **out_fd,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DumpByFileDescriptor",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reload:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Reload">Reload()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_reload_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_reload_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_reload (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reload",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_reload_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_reload().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_reload().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reload_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reload_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Reload">Reload()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_reload() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reload_sync (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reload",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reexecute:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Reexecute">Reexecute()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_reexecute_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_reexecute_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_reexecute (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reexecute",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_reexecute_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_reexecute().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_reexecute().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reexecute_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reexecute_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Reexecute">Reexecute()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_reexecute() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reexecute_sync (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reexecute",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_exit:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Exit">Exit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_exit_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_exit_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_exit (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Exit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_exit_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_exit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_exit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_exit_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_exit_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Exit">Exit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_exit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_exit_sync (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Exit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reboot:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Reboot">Reboot()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_reboot_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_reboot_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_reboot (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reboot",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_reboot_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_reboot().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_reboot().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reboot_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reboot_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Reboot">Reboot()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_reboot() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reboot_sync (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reboot",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_power_off:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PowerOff">PowerOff()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_power_off_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_power_off_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_power_off (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PowerOff",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_power_off_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_power_off().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_power_off().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_power_off_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_power_off_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PowerOff">PowerOff()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_power_off() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_power_off_sync (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PowerOff",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_halt:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Halt">Halt()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_halt_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_halt_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_halt (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Halt",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_halt_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_halt().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_halt().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_halt_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_halt_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Halt">Halt()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_halt() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_halt_sync (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Halt",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_kexec:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.KExec">KExec()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_kexec_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_kexec_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_kexec (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "KExec",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_kexec_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_kexec().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_kexec().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_kexec_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_kexec_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.KExec">KExec()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_kexec() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_kexec_sync (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "KExec",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_switch_root:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_new_root: Argument to pass with the method invocation.
 * @arg_init: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SwitchRoot">SwitchRoot()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_switch_root_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_switch_root_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_switch_root (
    Systemd1Manager *proxy,
    const gchar *arg_new_root,
    const gchar *arg_init,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SwitchRoot",
    g_variant_new ("(ss)",
                   arg_new_root,
                   arg_init),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_switch_root_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_switch_root().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_switch_root().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_switch_root_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_switch_root_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_new_root: Argument to pass with the method invocation.
 * @arg_init: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SwitchRoot">SwitchRoot()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_switch_root() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_switch_root_sync (
    Systemd1Manager *proxy,
    const gchar *arg_new_root,
    const gchar *arg_init,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SwitchRoot",
    g_variant_new ("(ss)",
                   arg_new_root,
                   arg_init),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_set_environment:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_assignments: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetEnvironment">SetEnvironment()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_set_environment_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_set_environment_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_set_environment (
    Systemd1Manager *proxy,
    const gchar *const *arg_assignments,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetEnvironment",
    g_variant_new ("(^as)",
                   arg_assignments),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_set_environment_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_set_environment().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_set_environment().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_set_environment_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_set_environment_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_assignments: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetEnvironment">SetEnvironment()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_set_environment() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_set_environment_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_assignments,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetEnvironment",
    g_variant_new ("(^as)",
                   arg_assignments),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_unset_environment:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_names: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnsetEnvironment">UnsetEnvironment()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_unset_environment_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_unset_environment_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_unset_environment (
    Systemd1Manager *proxy,
    const gchar *const *arg_names,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnsetEnvironment",
    g_variant_new ("(^as)",
                   arg_names),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_unset_environment_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_unset_environment().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_unset_environment().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_unset_environment_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_unset_environment_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_names: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnsetEnvironment">UnsetEnvironment()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_unset_environment() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_unset_environment_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_names,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnsetEnvironment",
    g_variant_new ("(^as)",
                   arg_names),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_unset_and_set_environment:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_names: Argument to pass with the method invocation.
 * @arg_assignments: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnsetAndSetEnvironment">UnsetAndSetEnvironment()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_unset_and_set_environment_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_unset_and_set_environment_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_unset_and_set_environment (
    Systemd1Manager *proxy,
    const gchar *const *arg_names,
    const gchar *const *arg_assignments,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnsetAndSetEnvironment",
    g_variant_new ("(^as^as)",
                   arg_names,
                   arg_assignments),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_unset_and_set_environment_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_unset_and_set_environment().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_unset_and_set_environment().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_unset_and_set_environment_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_unset_and_set_environment_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_names: Argument to pass with the method invocation.
 * @arg_assignments: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnsetAndSetEnvironment">UnsetAndSetEnvironment()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_unset_and_set_environment() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_unset_and_set_environment_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_names,
    const gchar *const *arg_assignments,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnsetAndSetEnvironment",
    g_variant_new ("(^as^as)",
                   arg_names,
                   arg_assignments),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_enqueue_marked_jobs:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnqueueMarkedJobs">EnqueueMarkedJobs()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_enqueue_marked_jobs_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_enqueue_marked_jobs_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_enqueue_marked_jobs (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnqueueMarkedJobs",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_enqueue_marked_jobs_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_jobs: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_enqueue_marked_jobs().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_enqueue_marked_jobs().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_enqueue_marked_jobs_finish (
    Systemd1Manager *proxy,
    gchar ***out_jobs,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_jobs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_enqueue_marked_jobs_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_jobs: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnqueueMarkedJobs">EnqueueMarkedJobs()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_enqueue_marked_jobs() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_enqueue_marked_jobs_sync (
    Systemd1Manager *proxy,
    gchar ***out_jobs,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnqueueMarkedJobs",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_jobs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_list_unit_files:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitFiles">ListUnitFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_list_unit_files_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_list_unit_files_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_list_unit_files (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListUnitFiles",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_list_unit_files_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_unit_files: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_list_unit_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_list_unit_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_list_unit_files_finish (
    Systemd1Manager *proxy,
    GVariant **out_unit_files,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ss))",
                 out_unit_files);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_list_unit_files_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_unit_files: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitFiles">ListUnitFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_list_unit_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_list_unit_files_sync (
    Systemd1Manager *proxy,
    GVariant **out_unit_files,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListUnitFiles",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ss))",
                 out_unit_files);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_list_unit_files_by_patterns:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_states: Argument to pass with the method invocation.
 * @arg_patterns: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitFilesByPatterns">ListUnitFilesByPatterns()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_list_unit_files_by_patterns_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_list_unit_files_by_patterns_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_list_unit_files_by_patterns (
    Systemd1Manager *proxy,
    const gchar *const *arg_states,
    const gchar *const *arg_patterns,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListUnitFilesByPatterns",
    g_variant_new ("(^as^as)",
                   arg_states,
                   arg_patterns),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_list_unit_files_by_patterns_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_unit_files: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_list_unit_files_by_patterns().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_list_unit_files_by_patterns().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_list_unit_files_by_patterns_finish (
    Systemd1Manager *proxy,
    GVariant **out_unit_files,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ss))",
                 out_unit_files);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_list_unit_files_by_patterns_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_states: Argument to pass with the method invocation.
 * @arg_patterns: Argument to pass with the method invocation.
 * @out_unit_files: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitFilesByPatterns">ListUnitFilesByPatterns()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_list_unit_files_by_patterns() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_list_unit_files_by_patterns_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_states,
    const gchar *const *arg_patterns,
    GVariant **out_unit_files,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListUnitFilesByPatterns",
    g_variant_new ("(^as^as)",
                   arg_states,
                   arg_patterns),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ss))",
                 out_unit_files);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_unit_file_state:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_file: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitFileState">GetUnitFileState()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_get_unit_file_state_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_get_unit_file_state_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_get_unit_file_state (
    Systemd1Manager *proxy,
    const gchar *arg_file,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetUnitFileState",
    g_variant_new ("(s)",
                   arg_file),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_get_unit_file_state_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_state: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_get_unit_file_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_get_unit_file_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_unit_file_state_finish (
    Systemd1Manager *proxy,
    gchar **out_state,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_state);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_unit_file_state_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_file: Argument to pass with the method invocation.
 * @out_state: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitFileState">GetUnitFileState()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_get_unit_file_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_unit_file_state_sync (
    Systemd1Manager *proxy,
    const gchar *arg_file,
    gchar **out_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetUnitFileState",
    g_variant_new ("(s)",
                   arg_file),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_state);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_enable_unit_files:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnableUnitFiles">EnableUnitFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_enable_unit_files_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_enable_unit_files_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_enable_unit_files (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    gboolean arg_runtime,
    gboolean arg_force,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnableUnitFiles",
    g_variant_new ("(^asbb)",
                   arg_files,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_enable_unit_files_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_carries_install_info: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_enable_unit_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_enable_unit_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_enable_unit_files_finish (
    Systemd1Manager *proxy,
    gboolean *out_carries_install_info,
    GVariant **out_changes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b@a(sss))",
                 out_carries_install_info,
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_enable_unit_files_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @out_carries_install_info: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnableUnitFiles">EnableUnitFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_enable_unit_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_enable_unit_files_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    gboolean arg_runtime,
    gboolean arg_force,
    gboolean *out_carries_install_info,
    GVariant **out_changes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnableUnitFiles",
    g_variant_new ("(^asbb)",
                   arg_files,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b@a(sss))",
                 out_carries_install_info,
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_disable_unit_files:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.DisableUnitFiles">DisableUnitFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_disable_unit_files_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_disable_unit_files_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_disable_unit_files (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    gboolean arg_runtime,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DisableUnitFiles",
    g_variant_new ("(^asb)",
                   arg_files,
                   arg_runtime),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_disable_unit_files_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_disable_unit_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_disable_unit_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_disable_unit_files_finish (
    Systemd1Manager *proxy,
    GVariant **out_changes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_disable_unit_files_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.DisableUnitFiles">DisableUnitFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_disable_unit_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_disable_unit_files_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    gboolean arg_runtime,
    GVariant **out_changes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DisableUnitFiles",
    g_variant_new ("(^asb)",
                   arg_files,
                   arg_runtime),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_enable_unit_files_with_flags:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnableUnitFilesWithFlags">EnableUnitFilesWithFlags()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_enable_unit_files_with_flags_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_enable_unit_files_with_flags_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_enable_unit_files_with_flags (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    guint64 arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnableUnitFilesWithFlags",
    g_variant_new ("(^ast)",
                   arg_files,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_enable_unit_files_with_flags_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_carries_install_info: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_enable_unit_files_with_flags().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_enable_unit_files_with_flags().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_enable_unit_files_with_flags_finish (
    Systemd1Manager *proxy,
    gboolean *out_carries_install_info,
    GVariant **out_changes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b@a(sss))",
                 out_carries_install_info,
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_enable_unit_files_with_flags_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @out_carries_install_info: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnableUnitFilesWithFlags">EnableUnitFilesWithFlags()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_enable_unit_files_with_flags() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_enable_unit_files_with_flags_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    guint64 arg_flags,
    gboolean *out_carries_install_info,
    GVariant **out_changes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnableUnitFilesWithFlags",
    g_variant_new ("(^ast)",
                   arg_files,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b@a(sss))",
                 out_carries_install_info,
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_disable_unit_files_with_flags:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.DisableUnitFilesWithFlags">DisableUnitFilesWithFlags()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_disable_unit_files_with_flags_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_disable_unit_files_with_flags_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_disable_unit_files_with_flags (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    guint64 arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DisableUnitFilesWithFlags",
    g_variant_new ("(^ast)",
                   arg_files,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_disable_unit_files_with_flags_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_disable_unit_files_with_flags().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_disable_unit_files_with_flags().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_disable_unit_files_with_flags_finish (
    Systemd1Manager *proxy,
    GVariant **out_changes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_disable_unit_files_with_flags_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.DisableUnitFilesWithFlags">DisableUnitFilesWithFlags()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_disable_unit_files_with_flags() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_disable_unit_files_with_flags_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    guint64 arg_flags,
    GVariant **out_changes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DisableUnitFilesWithFlags",
    g_variant_new ("(^ast)",
                   arg_files,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reenable_unit_files:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReenableUnitFiles">ReenableUnitFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_reenable_unit_files_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_reenable_unit_files_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_reenable_unit_files (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    gboolean arg_runtime,
    gboolean arg_force,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReenableUnitFiles",
    g_variant_new ("(^asbb)",
                   arg_files,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_reenable_unit_files_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_carries_install_info: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_reenable_unit_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_reenable_unit_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reenable_unit_files_finish (
    Systemd1Manager *proxy,
    gboolean *out_carries_install_info,
    GVariant **out_changes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b@a(sss))",
                 out_carries_install_info,
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_reenable_unit_files_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @out_carries_install_info: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReenableUnitFiles">ReenableUnitFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_reenable_unit_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_reenable_unit_files_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    gboolean arg_runtime,
    gboolean arg_force,
    gboolean *out_carries_install_info,
    GVariant **out_changes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReenableUnitFiles",
    g_variant_new ("(^asbb)",
                   arg_files,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b@a(sss))",
                 out_carries_install_info,
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_link_unit_files:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LinkUnitFiles">LinkUnitFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_link_unit_files_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_link_unit_files_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_link_unit_files (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    gboolean arg_runtime,
    gboolean arg_force,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "LinkUnitFiles",
    g_variant_new ("(^asbb)",
                   arg_files,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_link_unit_files_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_link_unit_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_link_unit_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_link_unit_files_finish (
    Systemd1Manager *proxy,
    GVariant **out_changes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_link_unit_files_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LinkUnitFiles">LinkUnitFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_link_unit_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_link_unit_files_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    gboolean arg_runtime,
    gboolean arg_force,
    GVariant **out_changes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "LinkUnitFiles",
    g_variant_new ("(^asbb)",
                   arg_files,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_preset_unit_files:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PresetUnitFiles">PresetUnitFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_preset_unit_files_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_preset_unit_files_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_preset_unit_files (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    gboolean arg_runtime,
    gboolean arg_force,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PresetUnitFiles",
    g_variant_new ("(^asbb)",
                   arg_files,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_preset_unit_files_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_carries_install_info: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_preset_unit_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_preset_unit_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_preset_unit_files_finish (
    Systemd1Manager *proxy,
    gboolean *out_carries_install_info,
    GVariant **out_changes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b@a(sss))",
                 out_carries_install_info,
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_preset_unit_files_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @out_carries_install_info: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PresetUnitFiles">PresetUnitFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_preset_unit_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_preset_unit_files_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    gboolean arg_runtime,
    gboolean arg_force,
    gboolean *out_carries_install_info,
    GVariant **out_changes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PresetUnitFiles",
    g_variant_new ("(^asbb)",
                   arg_files,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b@a(sss))",
                 out_carries_install_info,
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_preset_unit_files_with_mode:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PresetUnitFilesWithMode">PresetUnitFilesWithMode()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_preset_unit_files_with_mode_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_preset_unit_files_with_mode_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_preset_unit_files_with_mode (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    const gchar *arg_mode,
    gboolean arg_runtime,
    gboolean arg_force,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PresetUnitFilesWithMode",
    g_variant_new ("(^assbb)",
                   arg_files,
                   arg_mode,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_preset_unit_files_with_mode_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_carries_install_info: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_preset_unit_files_with_mode().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_preset_unit_files_with_mode().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_preset_unit_files_with_mode_finish (
    Systemd1Manager *proxy,
    gboolean *out_carries_install_info,
    GVariant **out_changes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b@a(sss))",
                 out_carries_install_info,
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_preset_unit_files_with_mode_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_mode: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @out_carries_install_info: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PresetUnitFilesWithMode">PresetUnitFilesWithMode()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_preset_unit_files_with_mode() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_preset_unit_files_with_mode_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    const gchar *arg_mode,
    gboolean arg_runtime,
    gboolean arg_force,
    gboolean *out_carries_install_info,
    GVariant **out_changes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PresetUnitFilesWithMode",
    g_variant_new ("(^assbb)",
                   arg_files,
                   arg_mode,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b@a(sss))",
                 out_carries_install_info,
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_mask_unit_files:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.MaskUnitFiles">MaskUnitFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_mask_unit_files_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_mask_unit_files_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_mask_unit_files (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    gboolean arg_runtime,
    gboolean arg_force,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "MaskUnitFiles",
    g_variant_new ("(^asbb)",
                   arg_files,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_mask_unit_files_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_mask_unit_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_mask_unit_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_mask_unit_files_finish (
    Systemd1Manager *proxy,
    GVariant **out_changes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_mask_unit_files_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.MaskUnitFiles">MaskUnitFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_mask_unit_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_mask_unit_files_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    gboolean arg_runtime,
    gboolean arg_force,
    GVariant **out_changes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "MaskUnitFiles",
    g_variant_new ("(^asbb)",
                   arg_files,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_unmask_unit_files:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnmaskUnitFiles">UnmaskUnitFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_unmask_unit_files_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_unmask_unit_files_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_unmask_unit_files (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    gboolean arg_runtime,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnmaskUnitFiles",
    g_variant_new ("(^asb)",
                   arg_files,
                   arg_runtime),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_unmask_unit_files_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_unmask_unit_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_unmask_unit_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_unmask_unit_files_finish (
    Systemd1Manager *proxy,
    GVariant **out_changes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_unmask_unit_files_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnmaskUnitFiles">UnmaskUnitFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_unmask_unit_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_unmask_unit_files_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    gboolean arg_runtime,
    GVariant **out_changes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnmaskUnitFiles",
    g_variant_new ("(^asb)",
                   arg_files,
                   arg_runtime),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_revert_unit_files:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.RevertUnitFiles">RevertUnitFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_revert_unit_files_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_revert_unit_files_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_revert_unit_files (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RevertUnitFiles",
    g_variant_new ("(^as)",
                   arg_files),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_revert_unit_files_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_revert_unit_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_revert_unit_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_revert_unit_files_finish (
    Systemd1Manager *proxy,
    GVariant **out_changes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_revert_unit_files_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.RevertUnitFiles">RevertUnitFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_revert_unit_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_revert_unit_files_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    GVariant **out_changes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RevertUnitFiles",
    g_variant_new ("(^as)",
                   arg_files),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_set_default_target:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetDefaultTarget">SetDefaultTarget()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_set_default_target_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_set_default_target_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_set_default_target (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    gboolean arg_force,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetDefaultTarget",
    g_variant_new ("(sb)",
                   arg_name,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_set_default_target_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_set_default_target().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_set_default_target().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_set_default_target_finish (
    Systemd1Manager *proxy,
    GVariant **out_changes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_set_default_target_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetDefaultTarget">SetDefaultTarget()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_set_default_target() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_set_default_target_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    gboolean arg_force,
    GVariant **out_changes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetDefaultTarget",
    g_variant_new ("(sb)",
                   arg_name,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_default_target:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetDefaultTarget">GetDefaultTarget()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_get_default_target_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_get_default_target_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_get_default_target (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetDefaultTarget",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_get_default_target_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_get_default_target().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_get_default_target().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_default_target_finish (
    Systemd1Manager *proxy,
    gchar **out_name,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_name);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_default_target_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetDefaultTarget">GetDefaultTarget()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_get_default_target() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_default_target_sync (
    Systemd1Manager *proxy,
    gchar **out_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetDefaultTarget",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_name);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_preset_all_unit_files:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PresetAllUnitFiles">PresetAllUnitFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_preset_all_unit_files_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_preset_all_unit_files_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_preset_all_unit_files (
    Systemd1Manager *proxy,
    const gchar *arg_mode,
    gboolean arg_runtime,
    gboolean arg_force,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PresetAllUnitFiles",
    g_variant_new ("(sbb)",
                   arg_mode,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_preset_all_unit_files_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_preset_all_unit_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_preset_all_unit_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_preset_all_unit_files_finish (
    Systemd1Manager *proxy,
    GVariant **out_changes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_preset_all_unit_files_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PresetAllUnitFiles">PresetAllUnitFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_preset_all_unit_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_preset_all_unit_files_sync (
    Systemd1Manager *proxy,
    const gchar *arg_mode,
    gboolean arg_runtime,
    gboolean arg_force,
    GVariant **out_changes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PresetAllUnitFiles",
    g_variant_new ("(sbb)",
                   arg_mode,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_add_dependency_unit_files:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.AddDependencyUnitFiles">AddDependencyUnitFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_add_dependency_unit_files_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_add_dependency_unit_files_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_add_dependency_unit_files (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    const gchar *arg_target,
    const gchar *arg_type,
    gboolean arg_runtime,
    gboolean arg_force,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddDependencyUnitFiles",
    g_variant_new ("(^asssbb)",
                   arg_files,
                   arg_target,
                   arg_type,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_add_dependency_unit_files_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_add_dependency_unit_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_add_dependency_unit_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_add_dependency_unit_files_finish (
    Systemd1Manager *proxy,
    GVariant **out_changes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_add_dependency_unit_files_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_force: Argument to pass with the method invocation.
 * @out_changes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.AddDependencyUnitFiles">AddDependencyUnitFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_add_dependency_unit_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_add_dependency_unit_files_sync (
    Systemd1Manager *proxy,
    const gchar *const *arg_files,
    const gchar *arg_target,
    const gchar *arg_type,
    gboolean arg_runtime,
    gboolean arg_force,
    GVariant **out_changes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddDependencyUnitFiles",
    g_variant_new ("(^asssbb)",
                   arg_files,
                   arg_target,
                   arg_type,
                   arg_runtime,
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sss))",
                 out_changes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_unit_file_links:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitFileLinks">GetUnitFileLinks()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_get_unit_file_links_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_get_unit_file_links_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_get_unit_file_links (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    gboolean arg_runtime,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetUnitFileLinks",
    g_variant_new ("(sb)",
                   arg_name,
                   arg_runtime),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_get_unit_file_links_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_links: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_get_unit_file_links().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_get_unit_file_links().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_unit_file_links_finish (
    Systemd1Manager *proxy,
    gchar ***out_links,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_links);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_unit_file_links_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_runtime: Argument to pass with the method invocation.
 * @out_links: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitFileLinks">GetUnitFileLinks()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_get_unit_file_links() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_unit_file_links_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    gboolean arg_runtime,
    gchar ***out_links,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetUnitFileLinks",
    g_variant_new ("(sb)",
                   arg_name,
                   arg_runtime),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_links);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_set_exit_code:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_number: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetExitCode">SetExitCode()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_set_exit_code_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_set_exit_code_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_set_exit_code (
    Systemd1Manager *proxy,
    guchar arg_number,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetExitCode",
    g_variant_new ("(y)",
                   arg_number),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_set_exit_code_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_set_exit_code().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_set_exit_code().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_set_exit_code_finish (
    Systemd1Manager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_set_exit_code_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_number: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetExitCode">SetExitCode()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_set_exit_code() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_set_exit_code_sync (
    Systemd1Manager *proxy,
    guchar arg_number,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetExitCode",
    g_variant_new ("(y)",
                   arg_number),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_lookup_dynamic_user_by_name:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LookupDynamicUserByName">LookupDynamicUserByName()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_lookup_dynamic_user_by_name_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_lookup_dynamic_user_by_name_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_lookup_dynamic_user_by_name (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "LookupDynamicUserByName",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_lookup_dynamic_user_by_name_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_uid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_lookup_dynamic_user_by_name().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_lookup_dynamic_user_by_name().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_lookup_dynamic_user_by_name_finish (
    Systemd1Manager *proxy,
    guint *out_uid,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_uid);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_lookup_dynamic_user_by_name_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @out_uid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LookupDynamicUserByName">LookupDynamicUserByName()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_lookup_dynamic_user_by_name() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_lookup_dynamic_user_by_name_sync (
    Systemd1Manager *proxy,
    const gchar *arg_name,
    guint *out_uid,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "LookupDynamicUserByName",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_uid);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_lookup_dynamic_user_by_uid:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LookupDynamicUserByUID">LookupDynamicUserByUID()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_lookup_dynamic_user_by_uid_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_lookup_dynamic_user_by_uid_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_lookup_dynamic_user_by_uid (
    Systemd1Manager *proxy,
    guint arg_uid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "LookupDynamicUserByUID",
    g_variant_new ("(u)",
                   arg_uid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_lookup_dynamic_user_by_uid_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_lookup_dynamic_user_by_uid().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_lookup_dynamic_user_by_uid().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_lookup_dynamic_user_by_uid_finish (
    Systemd1Manager *proxy,
    gchar **out_name,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_name);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_lookup_dynamic_user_by_uid_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @out_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LookupDynamicUserByUID">LookupDynamicUserByUID()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_lookup_dynamic_user_by_uid() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_lookup_dynamic_user_by_uid_sync (
    Systemd1Manager *proxy,
    guint arg_uid,
    gchar **out_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "LookupDynamicUserByUID",
    g_variant_new ("(u)",
                   arg_uid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_name);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_dynamic_users:
 * @proxy: A #Systemd1ManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetDynamicUsers">GetDynamicUsers()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_call_get_dynamic_users_finish() to get the result of the operation.
 *
 * See systemd1_manager_call_get_dynamic_users_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_manager_call_get_dynamic_users (
    Systemd1Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetDynamicUsers",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_manager_call_get_dynamic_users_finish:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_users: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_call_get_dynamic_users().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_manager_call_get_dynamic_users().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_dynamic_users_finish (
    Systemd1Manager *proxy,
    GVariant **out_users,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(us))",
                 out_users);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_call_get_dynamic_users_sync:
 * @proxy: A #Systemd1ManagerProxy.
 * @out_users: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetDynamicUsers">GetDynamicUsers()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_call_get_dynamic_users() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_manager_call_get_dynamic_users_sync (
    Systemd1Manager *proxy,
    GVariant **out_users,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetDynamicUsers",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(us))",
                 out_users);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_manager_complete_get_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unit: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnit">GetUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_get_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *unit)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   unit));
}

/**
 * systemd1_manager_complete_get_unit_by_pid:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unit: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitByPID">GetUnitByPID()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_get_unit_by_pid (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *unit)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   unit));
}

/**
 * systemd1_manager_complete_get_unit_by_invocation_id:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unit: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitByInvocationID">GetUnitByInvocationID()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_get_unit_by_invocation_id (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *unit)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   unit));
}

/**
 * systemd1_manager_complete_get_unit_by_control_group:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unit: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitByControlGroup">GetUnitByControlGroup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_get_unit_by_control_group (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *unit)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   unit));
}

/**
 * systemd1_manager_complete_load_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unit: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LoadUnit">LoadUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_load_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *unit)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   unit));
}

/**
 * systemd1_manager_complete_start_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StartUnit">StartUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_start_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_manager_complete_start_unit_replace:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StartUnitReplace">StartUnitReplace()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_start_unit_replace (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_manager_complete_stop_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StopUnit">StopUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_stop_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_manager_complete_reload_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReloadUnit">ReloadUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_reload_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_manager_complete_restart_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.RestartUnit">RestartUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_restart_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_manager_complete_try_restart_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.TryRestartUnit">TryRestartUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_try_restart_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_manager_complete_reload_or_restart_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReloadOrRestartUnit">ReloadOrRestartUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_reload_or_restart_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_manager_complete_reload_or_try_restart_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReloadOrTryRestartUnit">ReloadOrTryRestartUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_reload_or_try_restart_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_manager_complete_enqueue_unit_job:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job_id: Parameter to return.
 * @job_path: Parameter to return.
 * @unit_id: Parameter to return.
 * @unit_path: Parameter to return.
 * @job_type: Parameter to return.
 * @affected_jobs: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnqueueUnitJob">EnqueueUnitJob()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_enqueue_unit_job (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint job_id,
    const gchar *job_path,
    const gchar *unit_id,
    const gchar *unit_path,
    const gchar *job_type,
    GVariant *affected_jobs)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(uosos@a(uosos))",
                   job_id,
                   job_path,
                   unit_id,
                   unit_path,
                   job_type,
                   affected_jobs));
}

/**
 * systemd1_manager_complete_kill_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.KillUnit">KillUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_kill_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_clean_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.CleanUnit">CleanUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_clean_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_freeze_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.FreezeUnit">FreezeUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_freeze_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_thaw_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ThawUnit">ThawUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_thaw_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_reset_failed_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ResetFailedUnit">ResetFailedUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_reset_failed_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_set_unit_properties:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetUnitProperties">SetUnitProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_set_unit_properties (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_bind_mount_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.BindMountUnit">BindMountUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_bind_mount_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_mount_image_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.MountImageUnit">MountImageUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_mount_image_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_ref_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.RefUnit">RefUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_ref_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_unref_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnrefUnit">UnrefUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_unref_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_start_transient_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.StartTransientUnit">StartTransientUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_start_transient_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_manager_complete_get_unit_processes:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @processes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitProcesses">GetUnitProcesses()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_get_unit_processes (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *processes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sus))",
                   processes));
}

/**
 * systemd1_manager_complete_attach_processes_to_unit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.AttachProcessesToUnit">AttachProcessesToUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_attach_processes_to_unit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_abandon_scope:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.AbandonScope">AbandonScope()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_abandon_scope (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_get_job:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetJob">GetJob()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_get_job (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_manager_complete_get_job_after:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @jobs: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetJobAfter">GetJobAfter()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_get_job_after (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *jobs)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(usssoo))",
                   jobs));
}

/**
 * systemd1_manager_complete_get_job_before:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @jobs: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetJobBefore">GetJobBefore()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_get_job_before (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *jobs)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(usssoo))",
                   jobs));
}

/**
 * systemd1_manager_complete_cancel_job:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.CancelJob">CancelJob()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_cancel_job (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_clear_jobs:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ClearJobs">ClearJobs()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_clear_jobs (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_reset_failed:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ResetFailed">ResetFailed()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_reset_failed (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_set_show_status:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetShowStatus">SetShowStatus()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_set_show_status (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_list_units:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @units: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnits">ListUnits()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_list_units (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *units)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(ssssssouso))",
                   units));
}

/**
 * systemd1_manager_complete_list_units_filtered:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @units: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitsFiltered">ListUnitsFiltered()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_list_units_filtered (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *units)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(ssssssouso))",
                   units));
}

/**
 * systemd1_manager_complete_list_units_by_patterns:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @units: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitsByPatterns">ListUnitsByPatterns()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_list_units_by_patterns (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *units)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(ssssssouso))",
                   units));
}

/**
 * systemd1_manager_complete_list_units_by_names:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @units: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitsByNames">ListUnitsByNames()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_list_units_by_names (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *units)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(ssssssouso))",
                   units));
}

/**
 * systemd1_manager_complete_list_jobs:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @jobs: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListJobs">ListJobs()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_list_jobs (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *jobs)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(usssoo))",
                   jobs));
}

/**
 * systemd1_manager_complete_subscribe:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Subscribe">Subscribe()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_subscribe (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_unsubscribe:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Unsubscribe">Unsubscribe()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_unsubscribe (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_dump:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @output: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Dump">Dump()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_dump (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *output)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   output));
}

/**
 * systemd1_manager_complete_dump_by_file_descriptor:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.DumpByFileDescriptor">DumpByFileDescriptor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_dump_by_file_descriptor (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@h)",
                   fd));
}

/**
 * systemd1_manager_complete_reload:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Reload">Reload()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_reload (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_reexecute:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Reexecute">Reexecute()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_reexecute (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_exit:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Exit">Exit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_exit (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_reboot:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Reboot">Reboot()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_reboot (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_power_off:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PowerOff">PowerOff()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_power_off (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_halt:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.Halt">Halt()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_halt (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_kexec:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.KExec">KExec()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_kexec (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_switch_root:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SwitchRoot">SwitchRoot()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_switch_root (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_set_environment:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetEnvironment">SetEnvironment()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_set_environment (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_unset_environment:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnsetEnvironment">UnsetEnvironment()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_unset_environment (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_unset_and_set_environment:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnsetAndSetEnvironment">UnsetAndSetEnvironment()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_unset_and_set_environment (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_enqueue_marked_jobs:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @jobs: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnqueueMarkedJobs">EnqueueMarkedJobs()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_enqueue_marked_jobs (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *jobs)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   jobs));
}

/**
 * systemd1_manager_complete_list_unit_files:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unit_files: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitFiles">ListUnitFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_list_unit_files (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *unit_files)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(ss))",
                   unit_files));
}

/**
 * systemd1_manager_complete_list_unit_files_by_patterns:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unit_files: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ListUnitFilesByPatterns">ListUnitFilesByPatterns()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_list_unit_files_by_patterns (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *unit_files)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(ss))",
                   unit_files));
}

/**
 * systemd1_manager_complete_get_unit_file_state:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @state: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitFileState">GetUnitFileState()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_get_unit_file_state (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *state)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   state));
}

/**
 * systemd1_manager_complete_enable_unit_files:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @carries_install_info: Parameter to return.
 * @changes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnableUnitFiles">EnableUnitFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_enable_unit_files (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean carries_install_info,
    GVariant *changes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b@a(sss))",
                   carries_install_info,
                   changes));
}

/**
 * systemd1_manager_complete_disable_unit_files:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @changes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.DisableUnitFiles">DisableUnitFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_disable_unit_files (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *changes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sss))",
                   changes));
}

/**
 * systemd1_manager_complete_enable_unit_files_with_flags:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @carries_install_info: Parameter to return.
 * @changes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.EnableUnitFilesWithFlags">EnableUnitFilesWithFlags()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_enable_unit_files_with_flags (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean carries_install_info,
    GVariant *changes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b@a(sss))",
                   carries_install_info,
                   changes));
}

/**
 * systemd1_manager_complete_disable_unit_files_with_flags:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @changes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.DisableUnitFilesWithFlags">DisableUnitFilesWithFlags()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_disable_unit_files_with_flags (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *changes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sss))",
                   changes));
}

/**
 * systemd1_manager_complete_reenable_unit_files:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @carries_install_info: Parameter to return.
 * @changes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.ReenableUnitFiles">ReenableUnitFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_reenable_unit_files (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean carries_install_info,
    GVariant *changes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b@a(sss))",
                   carries_install_info,
                   changes));
}

/**
 * systemd1_manager_complete_link_unit_files:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @changes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LinkUnitFiles">LinkUnitFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_link_unit_files (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *changes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sss))",
                   changes));
}

/**
 * systemd1_manager_complete_preset_unit_files:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @carries_install_info: Parameter to return.
 * @changes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PresetUnitFiles">PresetUnitFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_preset_unit_files (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean carries_install_info,
    GVariant *changes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b@a(sss))",
                   carries_install_info,
                   changes));
}

/**
 * systemd1_manager_complete_preset_unit_files_with_mode:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @carries_install_info: Parameter to return.
 * @changes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PresetUnitFilesWithMode">PresetUnitFilesWithMode()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_preset_unit_files_with_mode (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean carries_install_info,
    GVariant *changes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b@a(sss))",
                   carries_install_info,
                   changes));
}

/**
 * systemd1_manager_complete_mask_unit_files:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @changes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.MaskUnitFiles">MaskUnitFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_mask_unit_files (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *changes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sss))",
                   changes));
}

/**
 * systemd1_manager_complete_unmask_unit_files:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @changes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.UnmaskUnitFiles">UnmaskUnitFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_unmask_unit_files (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *changes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sss))",
                   changes));
}

/**
 * systemd1_manager_complete_revert_unit_files:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @changes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.RevertUnitFiles">RevertUnitFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_revert_unit_files (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *changes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sss))",
                   changes));
}

/**
 * systemd1_manager_complete_set_default_target:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @changes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetDefaultTarget">SetDefaultTarget()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_set_default_target (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *changes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sss))",
                   changes));
}

/**
 * systemd1_manager_complete_get_default_target:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @name: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetDefaultTarget">GetDefaultTarget()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_get_default_target (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *name)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   name));
}

/**
 * systemd1_manager_complete_preset_all_unit_files:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @changes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.PresetAllUnitFiles">PresetAllUnitFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_preset_all_unit_files (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *changes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sss))",
                   changes));
}

/**
 * systemd1_manager_complete_add_dependency_unit_files:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @changes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.AddDependencyUnitFiles">AddDependencyUnitFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_add_dependency_unit_files (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *changes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sss))",
                   changes));
}

/**
 * systemd1_manager_complete_get_unit_file_links:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @links: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetUnitFileLinks">GetUnitFileLinks()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_get_unit_file_links (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *links)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   links));
}

/**
 * systemd1_manager_complete_set_exit_code:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.SetExitCode">SetExitCode()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_set_exit_code (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_manager_complete_lookup_dynamic_user_by_name:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @uid: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LookupDynamicUserByName">LookupDynamicUserByName()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_lookup_dynamic_user_by_name (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint uid)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   uid));
}

/**
 * systemd1_manager_complete_lookup_dynamic_user_by_uid:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @name: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.LookupDynamicUserByUID">LookupDynamicUserByUID()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_lookup_dynamic_user_by_uid (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *name)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   name));
}

/**
 * systemd1_manager_complete_get_dynamic_users:
 * @object: A #Systemd1Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @users: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Manager.GetDynamicUsers">GetDynamicUsers()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_manager_complete_get_dynamic_users (
    Systemd1Manager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *users)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(us))",
                   users));
}

/* ------------------------------------------------------------------------ */

/**
 * Systemd1ManagerProxy:
 *
 * The #Systemd1ManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Systemd1ManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Systemd1ManagerProxy.
 */

struct _Systemd1ManagerProxyPrivate
{
  GData *qdata;
};

static void systemd1_manager_proxy_iface_init (Systemd1ManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Systemd1ManagerProxy, systemd1_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (Systemd1ManagerProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_SYSTEMD1_MANAGER, systemd1_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Systemd1ManagerProxy, systemd1_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_SYSTEMD1_MANAGER, systemd1_manager_proxy_iface_init))

#endif
static void
systemd1_manager_proxy_finalize (GObject *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (systemd1_manager_proxy_parent_class)->finalize (object);
}

static void
systemd1_manager_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 109);
  info = (const _ExtendedGDBusPropertyInfo *) _systemd1_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
systemd1_manager_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.systemd1.Manager: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
systemd1_manager_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 109);
  info = (const _ExtendedGDBusPropertyInfo *) _systemd1_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.systemd1.Manager", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) systemd1_manager_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
systemd1_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_systemd1_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_SYSTEMD1_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_SYSTEMD1_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
systemd1_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_systemd1_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_systemd1_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
systemd1_manager_proxy_get_version (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Version");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_manager_proxy_get_features (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Features");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_manager_proxy_get_virtualization (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Virtualization");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_manager_proxy_get_architecture (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Architecture");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_manager_proxy_get_tainted (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Tainted");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_firmware_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FirmwareTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_firmware_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FirmwareTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_loader_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoaderTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_loader_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoaderTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_kernel_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "KernelTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_kernel_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "KernelTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_init_rdtimestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitRDTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_init_rdtimestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitRDTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_userspace_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UserspaceTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_userspace_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UserspaceTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_finish_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FinishTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_finish_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FinishTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_security_start_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SecurityStartTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_security_start_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SecurityStartTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_security_finish_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SecurityFinishTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_security_finish_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SecurityFinishTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_generators_start_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "GeneratorsStartTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_generators_start_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "GeneratorsStartTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_generators_finish_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "GeneratorsFinishTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_generators_finish_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "GeneratorsFinishTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_units_load_start_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UnitsLoadStartTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_units_load_start_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UnitsLoadStartTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_units_load_finish_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UnitsLoadFinishTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_units_load_finish_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UnitsLoadFinishTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_init_rdsecurity_start_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitRDSecurityStartTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_init_rdsecurity_start_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitRDSecurityStartTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_init_rdsecurity_finish_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitRDSecurityFinishTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_init_rdsecurity_finish_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitRDSecurityFinishTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_init_rdgenerators_start_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitRDGeneratorsStartTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_init_rdgenerators_start_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitRDGeneratorsStartTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_init_rdgenerators_finish_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitRDGeneratorsFinishTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_init_rdgenerators_finish_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitRDGeneratorsFinishTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_init_rdunits_load_start_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitRDUnitsLoadStartTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_init_rdunits_load_start_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitRDUnitsLoadStartTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_init_rdunits_load_finish_timestamp (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitRDUnitsLoadFinishTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_init_rdunits_load_finish_timestamp_monotonic (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitRDUnitsLoadFinishTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_manager_proxy_get_log_level (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LogLevel");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_manager_proxy_get_log_target (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LogTarget");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
systemd1_manager_proxy_get_nnames (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NNames");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
systemd1_manager_proxy_get_nfailed_units (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NFailedUnits");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
systemd1_manager_proxy_get_njobs (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NJobs");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
systemd1_manager_proxy_get_ninstalled_jobs (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NInstalledJobs");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
systemd1_manager_proxy_get_nfailed_jobs (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NFailedJobs");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
systemd1_manager_proxy_get_progress (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  gdouble value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Progress");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_manager_proxy_get_environment (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Environment");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Environment");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Environment", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_manager_proxy_get_confirm_spawn (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ConfirmSpawn");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_manager_proxy_get_show_status (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ShowStatus");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_manager_proxy_get_unit_path (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "UnitPath");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UnitPath");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "UnitPath", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_manager_proxy_get_default_standard_output (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultStandardOutput");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_manager_proxy_get_default_standard_error (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultStandardError");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_runtime_watchdog_usec (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RuntimeWatchdogUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_reboot_watchdog_usec (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RebootWatchdogUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_kexec_watchdog_usec (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "KExecWatchdogUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_manager_proxy_get_service_watchdogs (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ServiceWatchdogs");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_manager_proxy_get_control_group (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ControlGroup");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_manager_proxy_get_system_state (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SystemState");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guchar 
systemd1_manager_proxy_get_exit_code (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guchar value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ExitCode");
  if (variant != NULL)
    {
      value = g_variant_get_byte (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_timer_accuracy_usec (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultTimerAccuracyUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_timeout_start_usec (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultTimeoutStartUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_timeout_stop_usec (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultTimeoutStopUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_timeout_abort_usec (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultTimeoutAbortUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_restart_usec (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultRestartUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_start_limit_interval_usec (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultStartLimitIntervalUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
systemd1_manager_proxy_get_default_start_limit_burst (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultStartLimitBurst");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_manager_proxy_get_default_cpuaccounting (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultCPUAccounting");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_manager_proxy_get_default_block_ioaccounting (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultBlockIOAccounting");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_manager_proxy_get_default_memory_accounting (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultMemoryAccounting");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_manager_proxy_get_default_tasks_accounting (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultTasksAccounting");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_cpu (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitCPU");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_cpusoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitCPUSoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_fsize (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitFSIZE");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_fsizesoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitFSIZESoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_data (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitDATA");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_datasoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitDATASoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_stack (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitSTACK");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_stacksoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitSTACKSoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_core (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitCORE");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_coresoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitCORESoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_rss (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitRSS");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_rsssoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitRSSSoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_nofile (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitNOFILE");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_nofilesoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitNOFILESoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_as (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitAS");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_assoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitASSoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_nproc (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitNPROC");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_nprocsoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitNPROCSoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_memlock (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitMEMLOCK");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_memlocksoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitMEMLOCKSoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_locks (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitLOCKS");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_lockssoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitLOCKSSoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_sigpending (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitSIGPENDING");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_sigpendingsoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitSIGPENDINGSoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_msgqueue (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitMSGQUEUE");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_msgqueuesoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitMSGQUEUESoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_nice (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitNICE");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_nicesoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitNICESoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_rtprio (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitRTPRIO");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_rtpriosoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitRTPRIOSoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_rttime (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitRTTIME");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_limit_rttimesoft (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultLimitRTTIMESoft");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_default_tasks_max (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultTasksMax");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_manager_proxy_get_timer_slack_nsec (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TimerSlackNSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_manager_proxy_get_default_oompolicy (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultOOMPolicy");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_manager_proxy_get_ctrl_alt_del_burst_action (Systemd1Manager *object)
{
  Systemd1ManagerProxy *proxy = SYSTEMD1_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CtrlAltDelBurstAction");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
systemd1_manager_proxy_init (Systemd1ManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = systemd1_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_SYSTEMD1_MANAGER_PROXY, Systemd1ManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), systemd1_manager_interface_info ());
}

static void
systemd1_manager_proxy_class_init (Systemd1ManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = systemd1_manager_proxy_finalize;
  gobject_class->get_property = systemd1_manager_proxy_get_property;
  gobject_class->set_property = systemd1_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = systemd1_manager_proxy_g_signal;
  proxy_class->g_properties_changed = systemd1_manager_proxy_g_properties_changed;

  systemd1_manager_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Systemd1ManagerProxyPrivate));
#endif
}

static void
systemd1_manager_proxy_iface_init (Systemd1ManagerIface *iface)
{
  iface->get_version = systemd1_manager_proxy_get_version;
  iface->get_features = systemd1_manager_proxy_get_features;
  iface->get_virtualization = systemd1_manager_proxy_get_virtualization;
  iface->get_architecture = systemd1_manager_proxy_get_architecture;
  iface->get_tainted = systemd1_manager_proxy_get_tainted;
  iface->get_firmware_timestamp = systemd1_manager_proxy_get_firmware_timestamp;
  iface->get_firmware_timestamp_monotonic = systemd1_manager_proxy_get_firmware_timestamp_monotonic;
  iface->get_loader_timestamp = systemd1_manager_proxy_get_loader_timestamp;
  iface->get_loader_timestamp_monotonic = systemd1_manager_proxy_get_loader_timestamp_monotonic;
  iface->get_kernel_timestamp = systemd1_manager_proxy_get_kernel_timestamp;
  iface->get_kernel_timestamp_monotonic = systemd1_manager_proxy_get_kernel_timestamp_monotonic;
  iface->get_init_rdtimestamp = systemd1_manager_proxy_get_init_rdtimestamp;
  iface->get_init_rdtimestamp_monotonic = systemd1_manager_proxy_get_init_rdtimestamp_monotonic;
  iface->get_userspace_timestamp = systemd1_manager_proxy_get_userspace_timestamp;
  iface->get_userspace_timestamp_monotonic = systemd1_manager_proxy_get_userspace_timestamp_monotonic;
  iface->get_finish_timestamp = systemd1_manager_proxy_get_finish_timestamp;
  iface->get_finish_timestamp_monotonic = systemd1_manager_proxy_get_finish_timestamp_monotonic;
  iface->get_security_start_timestamp = systemd1_manager_proxy_get_security_start_timestamp;
  iface->get_security_start_timestamp_monotonic = systemd1_manager_proxy_get_security_start_timestamp_monotonic;
  iface->get_security_finish_timestamp = systemd1_manager_proxy_get_security_finish_timestamp;
  iface->get_security_finish_timestamp_monotonic = systemd1_manager_proxy_get_security_finish_timestamp_monotonic;
  iface->get_generators_start_timestamp = systemd1_manager_proxy_get_generators_start_timestamp;
  iface->get_generators_start_timestamp_monotonic = systemd1_manager_proxy_get_generators_start_timestamp_monotonic;
  iface->get_generators_finish_timestamp = systemd1_manager_proxy_get_generators_finish_timestamp;
  iface->get_generators_finish_timestamp_monotonic = systemd1_manager_proxy_get_generators_finish_timestamp_monotonic;
  iface->get_units_load_start_timestamp = systemd1_manager_proxy_get_units_load_start_timestamp;
  iface->get_units_load_start_timestamp_monotonic = systemd1_manager_proxy_get_units_load_start_timestamp_monotonic;
  iface->get_units_load_finish_timestamp = systemd1_manager_proxy_get_units_load_finish_timestamp;
  iface->get_units_load_finish_timestamp_monotonic = systemd1_manager_proxy_get_units_load_finish_timestamp_monotonic;
  iface->get_init_rdsecurity_start_timestamp = systemd1_manager_proxy_get_init_rdsecurity_start_timestamp;
  iface->get_init_rdsecurity_start_timestamp_monotonic = systemd1_manager_proxy_get_init_rdsecurity_start_timestamp_monotonic;
  iface->get_init_rdsecurity_finish_timestamp = systemd1_manager_proxy_get_init_rdsecurity_finish_timestamp;
  iface->get_init_rdsecurity_finish_timestamp_monotonic = systemd1_manager_proxy_get_init_rdsecurity_finish_timestamp_monotonic;
  iface->get_init_rdgenerators_start_timestamp = systemd1_manager_proxy_get_init_rdgenerators_start_timestamp;
  iface->get_init_rdgenerators_start_timestamp_monotonic = systemd1_manager_proxy_get_init_rdgenerators_start_timestamp_monotonic;
  iface->get_init_rdgenerators_finish_timestamp = systemd1_manager_proxy_get_init_rdgenerators_finish_timestamp;
  iface->get_init_rdgenerators_finish_timestamp_monotonic = systemd1_manager_proxy_get_init_rdgenerators_finish_timestamp_monotonic;
  iface->get_init_rdunits_load_start_timestamp = systemd1_manager_proxy_get_init_rdunits_load_start_timestamp;
  iface->get_init_rdunits_load_start_timestamp_monotonic = systemd1_manager_proxy_get_init_rdunits_load_start_timestamp_monotonic;
  iface->get_init_rdunits_load_finish_timestamp = systemd1_manager_proxy_get_init_rdunits_load_finish_timestamp;
  iface->get_init_rdunits_load_finish_timestamp_monotonic = systemd1_manager_proxy_get_init_rdunits_load_finish_timestamp_monotonic;
  iface->get_log_level = systemd1_manager_proxy_get_log_level;
  iface->get_log_target = systemd1_manager_proxy_get_log_target;
  iface->get_nnames = systemd1_manager_proxy_get_nnames;
  iface->get_nfailed_units = systemd1_manager_proxy_get_nfailed_units;
  iface->get_njobs = systemd1_manager_proxy_get_njobs;
  iface->get_ninstalled_jobs = systemd1_manager_proxy_get_ninstalled_jobs;
  iface->get_nfailed_jobs = systemd1_manager_proxy_get_nfailed_jobs;
  iface->get_progress = systemd1_manager_proxy_get_progress;
  iface->get_environment = systemd1_manager_proxy_get_environment;
  iface->get_confirm_spawn = systemd1_manager_proxy_get_confirm_spawn;
  iface->get_show_status = systemd1_manager_proxy_get_show_status;
  iface->get_unit_path = systemd1_manager_proxy_get_unit_path;
  iface->get_default_standard_output = systemd1_manager_proxy_get_default_standard_output;
  iface->get_default_standard_error = systemd1_manager_proxy_get_default_standard_error;
  iface->get_runtime_watchdog_usec = systemd1_manager_proxy_get_runtime_watchdog_usec;
  iface->get_reboot_watchdog_usec = systemd1_manager_proxy_get_reboot_watchdog_usec;
  iface->get_kexec_watchdog_usec = systemd1_manager_proxy_get_kexec_watchdog_usec;
  iface->get_service_watchdogs = systemd1_manager_proxy_get_service_watchdogs;
  iface->get_control_group = systemd1_manager_proxy_get_control_group;
  iface->get_system_state = systemd1_manager_proxy_get_system_state;
  iface->get_exit_code = systemd1_manager_proxy_get_exit_code;
  iface->get_default_timer_accuracy_usec = systemd1_manager_proxy_get_default_timer_accuracy_usec;
  iface->get_default_timeout_start_usec = systemd1_manager_proxy_get_default_timeout_start_usec;
  iface->get_default_timeout_stop_usec = systemd1_manager_proxy_get_default_timeout_stop_usec;
  iface->get_default_timeout_abort_usec = systemd1_manager_proxy_get_default_timeout_abort_usec;
  iface->get_default_restart_usec = systemd1_manager_proxy_get_default_restart_usec;
  iface->get_default_start_limit_interval_usec = systemd1_manager_proxy_get_default_start_limit_interval_usec;
  iface->get_default_start_limit_burst = systemd1_manager_proxy_get_default_start_limit_burst;
  iface->get_default_cpuaccounting = systemd1_manager_proxy_get_default_cpuaccounting;
  iface->get_default_block_ioaccounting = systemd1_manager_proxy_get_default_block_ioaccounting;
  iface->get_default_memory_accounting = systemd1_manager_proxy_get_default_memory_accounting;
  iface->get_default_tasks_accounting = systemd1_manager_proxy_get_default_tasks_accounting;
  iface->get_default_limit_cpu = systemd1_manager_proxy_get_default_limit_cpu;
  iface->get_default_limit_cpusoft = systemd1_manager_proxy_get_default_limit_cpusoft;
  iface->get_default_limit_fsize = systemd1_manager_proxy_get_default_limit_fsize;
  iface->get_default_limit_fsizesoft = systemd1_manager_proxy_get_default_limit_fsizesoft;
  iface->get_default_limit_data = systemd1_manager_proxy_get_default_limit_data;
  iface->get_default_limit_datasoft = systemd1_manager_proxy_get_default_limit_datasoft;
  iface->get_default_limit_stack = systemd1_manager_proxy_get_default_limit_stack;
  iface->get_default_limit_stacksoft = systemd1_manager_proxy_get_default_limit_stacksoft;
  iface->get_default_limit_core = systemd1_manager_proxy_get_default_limit_core;
  iface->get_default_limit_coresoft = systemd1_manager_proxy_get_default_limit_coresoft;
  iface->get_default_limit_rss = systemd1_manager_proxy_get_default_limit_rss;
  iface->get_default_limit_rsssoft = systemd1_manager_proxy_get_default_limit_rsssoft;
  iface->get_default_limit_nofile = systemd1_manager_proxy_get_default_limit_nofile;
  iface->get_default_limit_nofilesoft = systemd1_manager_proxy_get_default_limit_nofilesoft;
  iface->get_default_limit_as = systemd1_manager_proxy_get_default_limit_as;
  iface->get_default_limit_assoft = systemd1_manager_proxy_get_default_limit_assoft;
  iface->get_default_limit_nproc = systemd1_manager_proxy_get_default_limit_nproc;
  iface->get_default_limit_nprocsoft = systemd1_manager_proxy_get_default_limit_nprocsoft;
  iface->get_default_limit_memlock = systemd1_manager_proxy_get_default_limit_memlock;
  iface->get_default_limit_memlocksoft = systemd1_manager_proxy_get_default_limit_memlocksoft;
  iface->get_default_limit_locks = systemd1_manager_proxy_get_default_limit_locks;
  iface->get_default_limit_lockssoft = systemd1_manager_proxy_get_default_limit_lockssoft;
  iface->get_default_limit_sigpending = systemd1_manager_proxy_get_default_limit_sigpending;
  iface->get_default_limit_sigpendingsoft = systemd1_manager_proxy_get_default_limit_sigpendingsoft;
  iface->get_default_limit_msgqueue = systemd1_manager_proxy_get_default_limit_msgqueue;
  iface->get_default_limit_msgqueuesoft = systemd1_manager_proxy_get_default_limit_msgqueuesoft;
  iface->get_default_limit_nice = systemd1_manager_proxy_get_default_limit_nice;
  iface->get_default_limit_nicesoft = systemd1_manager_proxy_get_default_limit_nicesoft;
  iface->get_default_limit_rtprio = systemd1_manager_proxy_get_default_limit_rtprio;
  iface->get_default_limit_rtpriosoft = systemd1_manager_proxy_get_default_limit_rtpriosoft;
  iface->get_default_limit_rttime = systemd1_manager_proxy_get_default_limit_rttime;
  iface->get_default_limit_rttimesoft = systemd1_manager_proxy_get_default_limit_rttimesoft;
  iface->get_default_tasks_max = systemd1_manager_proxy_get_default_tasks_max;
  iface->get_timer_slack_nsec = systemd1_manager_proxy_get_timer_slack_nsec;
  iface->get_default_oompolicy = systemd1_manager_proxy_get_default_oompolicy;
  iface->get_ctrl_alt_del_burst_action = systemd1_manager_proxy_get_ctrl_alt_del_burst_action;
}

/**
 * systemd1_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-systemd1-Manager.top_of_page">org.freedesktop.systemd1.Manager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_proxy_new_finish() to get the result of the operation.
 *
 * See systemd1_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
systemd1_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_SYSTEMD1_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.systemd1.Manager", NULL);
}

/**
 * systemd1_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with systemd1_manager_proxy_new().
 *
 * Returns: (transfer full) (type Systemd1ManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
Systemd1Manager *
systemd1_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SYSTEMD1_MANAGER (ret);
  else
    return NULL;
}

/**
 * systemd1_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-systemd1-Manager.top_of_page">org.freedesktop.systemd1.Manager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Systemd1ManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
Systemd1Manager *
systemd1_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_SYSTEMD1_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.systemd1.Manager", NULL);
  if (ret != NULL)
    return SYSTEMD1_MANAGER (ret);
  else
    return NULL;
}


/**
 * systemd1_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like systemd1_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See systemd1_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
systemd1_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_SYSTEMD1_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.systemd1.Manager", NULL);
}

/**
 * systemd1_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with systemd1_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type Systemd1ManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
Systemd1Manager *
systemd1_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SYSTEMD1_MANAGER (ret);
  else
    return NULL;
}

/**
 * systemd1_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like systemd1_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See systemd1_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Systemd1ManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
Systemd1Manager *
systemd1_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_SYSTEMD1_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.systemd1.Manager", NULL);
  if (ret != NULL)
    return SYSTEMD1_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * Systemd1ManagerSkeleton:
 *
 * The #Systemd1ManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Systemd1ManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Systemd1ManagerSkeleton.
 */

struct _Systemd1ManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_systemd1_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_SYSTEMD1_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_SYSTEMD1_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_systemd1_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_systemd1_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_systemd1_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_systemd1_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _systemd1_manager_skeleton_vtable =
{
  _systemd1_manager_skeleton_handle_method_call,
  _systemd1_manager_skeleton_handle_get_property,
  _systemd1_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
systemd1_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return systemd1_manager_interface_info ();
}

static GDBusInterfaceVTable *
systemd1_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_systemd1_manager_skeleton_vtable;
}

static GVariant *
systemd1_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_systemd1_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _systemd1_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _systemd1_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _systemd1_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.systemd1.Manager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _systemd1_manager_emit_changed (gpointer user_data);

static void
systemd1_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _systemd1_manager_emit_changed (skeleton);
}

static void
_systemd1_manager_on_signal_unit_new (
    Systemd1Manager *object,
    const gchar *arg_id,
    const gchar *arg_unit)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(so)",
                   arg_id,
                   arg_unit));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.systemd1.Manager", "UnitNew",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_systemd1_manager_on_signal_unit_removed (
    Systemd1Manager *object,
    const gchar *arg_id,
    const gchar *arg_unit)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(so)",
                   arg_id,
                   arg_unit));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.systemd1.Manager", "UnitRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_systemd1_manager_on_signal_job_new (
    Systemd1Manager *object,
    guint arg_id,
    const gchar *arg_job,
    const gchar *arg_unit)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uos)",
                   arg_id,
                   arg_job,
                   arg_unit));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.systemd1.Manager", "JobNew",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_systemd1_manager_on_signal_job_removed (
    Systemd1Manager *object,
    guint arg_id,
    const gchar *arg_job,
    const gchar *arg_unit,
    const gchar *arg_result)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uoss)",
                   arg_id,
                   arg_job,
                   arg_unit,
                   arg_result));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.systemd1.Manager", "JobRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_systemd1_manager_on_signal_startup_finished (
    Systemd1Manager *object,
    guint64 arg_firmware,
    guint64 arg_loader,
    guint64 arg_kernel,
    guint64 arg_initrd,
    guint64 arg_userspace,
    guint64 arg_total)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(tttttt)",
                   arg_firmware,
                   arg_loader,
                   arg_kernel,
                   arg_initrd,
                   arg_userspace,
                   arg_total));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.systemd1.Manager", "StartupFinished",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_systemd1_manager_on_signal_unit_files_changed (
    Systemd1Manager *object)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.systemd1.Manager", "UnitFilesChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_systemd1_manager_on_signal_reloading (
    Systemd1Manager *object,
    gboolean arg_active)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b)",
                   arg_active));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.systemd1.Manager", "Reloading",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void systemd1_manager_skeleton_iface_init (Systemd1ManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Systemd1ManagerSkeleton, systemd1_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (Systemd1ManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_SYSTEMD1_MANAGER, systemd1_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Systemd1ManagerSkeleton, systemd1_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_SYSTEMD1_MANAGER, systemd1_manager_skeleton_iface_init))

#endif
static void
systemd1_manager_skeleton_finalize (GObject *object)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (object);
  guint n;
  for (n = 0; n < 109; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (systemd1_manager_skeleton_parent_class)->finalize (object);
}

static void
systemd1_manager_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 109);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_systemd1_manager_emit_changed (gpointer user_data)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.systemd1.Manager",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_systemd1_manager_schedule_emit_changed (Systemd1ManagerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
systemd1_manager_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _systemd1_manager_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _systemd1_manager_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
systemd1_manager_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  Systemd1ManagerSkeleton *skeleton = SYSTEMD1_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 109);
  info = (const _ExtendedGDBusPropertyInfo *) _systemd1_manager_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _systemd1_manager_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
systemd1_manager_skeleton_init (Systemd1ManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = systemd1_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_SYSTEMD1_MANAGER_SKELETON, Systemd1ManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 109);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[15], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[16], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[17], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[18], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[19], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[20], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[21], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[22], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[23], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[24], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[25], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[26], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[27], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[28], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[29], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[30], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[31], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[32], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[33], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[34], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[35], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[36], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[37], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[38], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[39], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[40], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[41], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[42], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[43], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[44], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[45], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[46], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[47], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[48], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[49], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[50], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[51], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[52], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[53], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[54], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[55], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[56], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[57], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[58], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[59], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[60], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[61], G_TYPE_UCHAR);
  g_value_init (&skeleton->priv->properties[62], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[63], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[64], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[65], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[66], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[67], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[68], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[69], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[70], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[71], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[72], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[73], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[74], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[75], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[76], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[77], G_TYPE_UINT64);
  g_value_init (&skeleton->priv-