# Source elements

A source element is an element that provides data to the pipeline. It
does typically not have any sink (input) pads.

Typical source elements include:

  - file readers

  - network elements (live or not)

  - capture elements (video/audio/…)

  - generators (signals/video/audio/…)

## Live sources

A source is said to be a live source when it has the following property:

  - temporarily stopping reading from the source causes data to be lost.

In general when this property holds, the source also produces data at a
fixed rate. Most sources have a limit on the rate at which they can
deliver data, which might be faster or slower than the consumption rate.
This property however does not make them a live source.

Let’s look at some example sources.

  - file readers: you can PAUSE without losing data. There is however a
    limit to how fast you can read from this source. This limit is
    usually much higher than the consumption rate. In some cases it
    might be slower (an NFS share, for example) in which case you might
    need to use some buffering (see [buffering](additional/design/buffering.md)).

  - HTTP network element: you can PAUSE without data loss. Depending on
    the available network bandwidth, consumption rate might be higher
    than production rate in which case buffering should be used (see
    [buffering](additional/design/buffering.md)).

  - audio source: pausing the audio capture will lead to lost data. this
    source is therefore definitely live. In addition, an audio source
    will produce data at a fixed rate (the samplerate). Also depending
    on the buffersize, this source will introduce a latency (see
    [latency](additional/design/latency.md)).

  - udp network source: Pausing the receiving part will lead to lost
    data. This source is therefore a live source. Also in a typical case
    the udp packets will be received at a certain rate, which might be
    difficult to guess because of network jitter. This source does not
    necessarily introduce latency on its own.

  - dvb source: PAUSING this element will lead to data loss, it’s a live
    source similar to a UDP source.

## Source types

A source element can operate in three ways:

  - it is fully seekable, this means that random access can be performed
    on it in an efficient way. (a file reader,…). This also typically
    means that the source is not live.

  - data can be obtained from it with a variable size. This means that
    the source can give N bytes of data. An example is an audio source.
    A video source always provides the same amount of data (one video
    frame). Note that this is not a fully seekable source.

  - it is a live source, see above.

When writing a source, one has to look at how the source can operate to
decide on the scheduling methods to implement on the source.

  - fully seekable sources implement a getrange function on the source
    pad.

  - sources that can give N bytes but cannot do seeking also implement a
    getrange function but state that they cannot do random access.

  - sources that are purely live sources implement a task to push out
    data.

Any source that has a getrange function must also implement a push based
scheduling mode. In this mode the source starts a task that gets N bytes
and pushes them out. Whenever possible, the peer element will select the
getrange based scheduling method of the source, though.

A source with a getrange function must activate itself in the pad
activate function. This is needed because the downstream peer element
will decide and activate the source element in its state change function
before the source’s state change function is called.

## Source base classes

`GstBaseSrc`:

This base class provides an implementation of a random access source and
is very well suited for file reader like sources.

`GstPushSrc`:

Base class for block-based sources. This class is mostly useful for
elements that cannot do random access, or at least very slowly. The
source usually prefers to push out a fixed size buffer.

Classes extending this base class will usually be scheduled in a push
based mode. If the peer accepts to operate without offsets and within
the limits of the allowed block size, this class can operate in getrange
based mode automatically.

The subclass should extend the methods from the baseclass in addition to
the create method. If the source is seekable, it needs to override
`GstBaseSrc::event()` in addition to `GstBaseSrc::is_seekable()` in order
to retrieve the seek offset, which is the offset of the next buffer to
be requested.

Flushing, scheduling and sync is all handled by this base class.

## Timestamps

A non-live source should timestamp the buffers it produces starting from
0. If it is not possible to timestamp every buffer (filesrc), the source
is allowed to only timestamp the first buffer (as 0).

Live sources only produce data in the `PLAYING` state, when the clock is
running. They should timestamp each buffer they produce with the current
`running_time` of the pipeline, which is expressed as:

```
absolute_time - base_time
```

With `absolute_time` being the time obtained from the global pipeline with
`gst_clock_get_time()` and `base_time` being the time of that clock when
the pipeline was last set to `PLAYING`.
