---
c: Copyright (C) Daniel Stenberg, <daniel.se>, et al.
SPDX-License-Identifier: curl
Title: CURLOPT_DNS_SHUFFLE_ADDRESSES
Section: 3
Source: libcurl
See-also:
  - CURLOPT_DNS_CACHE_TIMEOUT (3)
  - CURLOPT_IPRESOLVE (3)
---

# NAME

CURLOPT_DNS_SHUFFLE_ADDRESSES - shuffle IP addresses for hostname

# SYNOPSIS

~~~c
#include <curl/curl.h>

CURLcode curl_easy_setopt(CURL *handle, CURLOPT_DNS_SHUFFLE_ADDRESSES, long onoff);
~~~

# DESCRIPTION

Pass a long set to 1 to enable this option.

When a name is resolved and more than one IP address is returned, this
function shuffles the order of all returned addresses so that they are used in
a random order. This is similar to the ordering behavior of the legacy
gethostbyname function which is no longer used on most platforms.

Addresses are not reshuffled if name resolution is completed using the DNS
cache. CURLOPT_DNS_CACHE_TIMEOUT(3) can be used together with this
option to reduce DNS cache timeout or disable caching entirely if frequent
reshuffling is needed.

Since the addresses returned are randomly reordered, the order is not in
accordance with RFC 3484 or any other deterministic order that may be
generated by the system's name resolution implementation. This may have
performance impacts and may cause IPv4 to be used before IPv6 or vice versa.

# DEFAULT

0 (disabled)

# PROTOCOLS

All

# EXAMPLE

~~~c
int main(void)
{
  CURL *curl = curl_easy_init();
  if(curl) {
    curl_easy_setopt(curl, CURLOPT_URL, "https://example.com");
    curl_easy_setopt(curl, CURLOPT_DNS_SHUFFLE_ADDRESSES, 1L);

    curl_easy_perform(curl);

    /* always cleanup */
    curl_easy_cleanup(curl);
  }
}
~~~

# AVAILABILITY

Added in 7.60.0

# RETURN VALUE

CURLE_OK or an error such as CURLE_UNKNOWN_OPTION.
