SUMMARY = "Easily themable notification daemon with transparency effects"
HOMEPAGE = "https://docs.xfce.org/apps/notifyd/start"
LICENSE = "GPL-2.0-only"
LIC_FILES_CHKSUM = "file://COPYING;md5=94d55d512a9ba36caa9b7df079bae19f"
DEPENDS = " \
    dbus \
    dbus-glib \
    libnotify \
    libxfce4util \
    libxfce4ui \
    xfconf \
    xfce4-panel \
"

inherit xfce-app

SRC_URI[sha256sum] = "56a9f895aed460042f2abe09bb1a899e29b7c7d5a76ecac63dead3ced990859f"

# Avoid trouble with other desktops e.g KDE which also ships dbus service named
# org.freedesktop.Notifications
EXTRA_OECONF = "--disable-dbus-start-daemon"

do_compile:prepend() {
    mkdir -p xfce4-notifyd xfce4-notifyd-config
}

FILES:${PN} += " \
    ${systemd_user_unitdir} \
    ${datadir}/xfce4 \
    ${datadir}/themes \
    ${datadir}/dbus-1 \
    ${libdir}/xfce4 \
"
