SUMMARY = "Abseil is a cpp library like STL"
DESCRIPTION = "Abseil provides pieces missing from the C++ standard. Contains \
additional useful libraries like algorithm, container, debugging, hash, memory, \
meta, numeric, strings, synchronization, time, types and utility"
HOMEPAGE = "https://abseil.io/"
SECTION = "libs"
LICENSE = "Apache-2.0"
LIC_FILES_CHKSUM = "file://LICENSE;md5=df52c6edb7adc22e533b2bacc3bd3915"

PV = "20211102.0+git${SRCPV}"
SRCREV = "7c6608d0dbe43cf9bdf7f77787bc6bc89cc42f8b"
BRANCH = "master"
SRC_URI = "git://github.com/abseil/abseil-cpp;branch=${BRANCH};protocol=https \
           file://0001-absl-always-use-asm-sgidefs.h.patch             \
           file://0002-Remove-maes-option-from-cross-compilation.patch \
           file://abseil-ppc-fixes.patch \
           file://0001-absl-strings-internal-str_format-extension.h-add-mis.patch \
           file://CVE-2025-0838.patch \
          "

S = "${WORKDIR}/git"

ASNEEDED:class-native = ""
ASNEEDED:class-nativesdk = ""

inherit cmake

EXTRA_OECMAKE = "-DBUILD_SHARED_LIBS=ON \
                 -DBUILD_TESTING=OFF    \
                 -DCMAKE_CXX_STANDARD=14 \
                "

BBCLASSEXTEND = "native nativesdk"

FILES:${PN}-dev += "${includedir} ${libdir}/cmake ${libdir}/pkgconfig"
