; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible-sve < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming-compatible-sve < %s | FileCheck %s


target triple = "aarch64-unknown-linux-gnu"

define void @zip1_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: zip1_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1, #16]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    mov z2.b, z0.b[15]
; CHECK-NEXT:    mov z3.b, z0.b[14]
; CHECK-NEXT:    mov z4.b, z0.b[13]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    fmov w9, s3
; CHECK-NEXT:    mov z3.b, z0.b[11]
; CHECK-NEXT:    mov z2.b, z0.b[12]
; CHECK-NEXT:    strb w8, [sp, #14]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z0.b[10]
; CHECK-NEXT:    strb w9, [sp, #12]
; CHECK-NEXT:    fmov w9, s2
; CHECK-NEXT:    mov z2.b, z0.b[9]
; CHECK-NEXT:    strb w8, [sp, #10]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z3.b, z0.b[8]
; CHECK-NEXT:    strb w9, [sp, #8]
; CHECK-NEXT:    zip1 z0.b, z0.b, z1.b
; CHECK-NEXT:    strb w8, [sp, #6]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z1.b[15]
; CHECK-NEXT:    strb w8, [sp, #4]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.b, z1.b[14]
; CHECK-NEXT:    strb w8, [sp, #2]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z3.b, z1.b[13]
; CHECK-NEXT:    strb w8, [sp]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z1.b[12]
; CHECK-NEXT:    strb w8, [sp, #15]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.b, z1.b[11]
; CHECK-NEXT:    strb w8, [sp, #13]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z3.b, z1.b[10]
; CHECK-NEXT:    strb w8, [sp, #11]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z1.b[9]
; CHECK-NEXT:    fmov w9, s3
; CHECK-NEXT:    strb w8, [sp, #9]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.b, z1.b[8]
; CHECK-NEXT:    strb w9, [sp, #5]
; CHECK-NEXT:    strb w8, [sp, #7]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    strb w8, [sp, #3]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    strb w8, [sp, #1]
; CHECK-NEXT:    ldr q1, [sp]
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
  %tmp1 = load volatile <32 x i8>, ptr %a
  %tmp2 = load volatile <32 x i8>, ptr %b
  %tmp3 = shufflevector <32 x i8> %tmp1, <32 x i8> %tmp2, <32 x i32> <i32 0, i32 32, i32 1, i32 33, i32 2, i32 34, i32 3, i32 35, i32 4, i32 36, i32 5, i32 37, i32 6, i32 38, i32 7, i32 39, i32 8, i32 40, i32 9, i32 41, i32 10, i32 42, i32 11, i32 43, i32 12, i32 44, i32 13, i32 45, i32 14, i32 46, i32 15, i32 47>
  store volatile <32 x i8> %tmp3, ptr %a
  ret void
}

define void @zip_v32i16(ptr %a, ptr %b) {
; CHECK-LABEL: zip_v32i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    ldp q0, q4, [x0]
; CHECK-NEXT:    ldp q2, q6, [x0, #32]
; CHECK-NEXT:    mov z16.h, z3.h[7]
; CHECK-NEXT:    mov z18.h, z3.h[6]
; CHECK-NEXT:    mov z17.h, z4.h[7]
; CHECK-NEXT:    ldp q5, q7, [x1, #32]
; CHECK-NEXT:    mov z19.h, z4.h[6]
; CHECK-NEXT:    fmov w8, s16
; CHECK-NEXT:    mov z16.h, z3.h[5]
; CHECK-NEXT:    fmov w9, s17
; CHECK-NEXT:    mov z17.h, z4.h[5]
; CHECK-NEXT:    mov z20.h, z7.h[6]
; CHECK-NEXT:    strh w8, [sp, #30]
; CHECK-NEXT:    fmov w8, s18
; CHECK-NEXT:    mov z18.h, z3.h[4]
; CHECK-NEXT:    strh w9, [sp, #28]
; CHECK-NEXT:    fmov w9, s19
; CHECK-NEXT:    mov z19.h, z6.h[7]
; CHECK-NEXT:    zip1 z3.h, z4.h, z3.h
; CHECK-NEXT:    strh w8, [sp, #26]
; CHECK-NEXT:    fmov w8, s16
; CHECK-NEXT:    mov z16.h, z4.h[4]
; CHECK-NEXT:    strh w9, [sp, #24]
; CHECK-NEXT:    zip1 z4.h, z6.h, z7.h
; CHECK-NEXT:    strh w8, [sp, #22]
; CHECK-NEXT:    fmov w8, s17
; CHECK-NEXT:    mov z17.h, z1.h[7]
; CHECK-NEXT:    add z3.h, z3.h, z4.h
; CHECK-NEXT:    strh w8, [sp, #20]
; CHECK-NEXT:    fmov w8, s18
; CHECK-NEXT:    mov z18.h, z0.h[7]
; CHECK-NEXT:    strh w8, [sp, #18]
; CHECK-NEXT:    fmov w8, s16
; CHECK-NEXT:    mov z16.h, z1.h[6]
; CHECK-NEXT:    strh w8, [sp, #16]
; CHECK-NEXT:    fmov w8, s17
; CHECK-NEXT:    mov z17.h, z0.h[6]
; CHECK-NEXT:    strh w8, [sp, #62]
; CHECK-NEXT:    fmov w8, s18
; CHECK-NEXT:    mov z18.h, z1.h[5]
; CHECK-NEXT:    strh w8, [sp, #60]
; CHECK-NEXT:    fmov w8, s16
; CHECK-NEXT:    mov z16.h, z0.h[5]
; CHECK-NEXT:    strh w8, [sp, #58]
; CHECK-NEXT:    fmov w8, s17
; CHECK-NEXT:    mov z17.h, z1.h[4]
; CHECK-NEXT:    strh w8, [sp, #56]
; CHECK-NEXT:    fmov w8, s18
; CHECK-NEXT:    mov z18.h, z0.h[4]
; CHECK-NEXT:    zip1 z0.h, z0.h, z1.h
; CHECK-NEXT:    zip1 z1.h, z2.h, z5.h
; CHECK-NEXT:    strh w8, [sp, #54]
; CHECK-NEXT:    fmov w8, s16
; CHECK-NEXT:    ldr q16, [sp, #16]
; CHECK-NEXT:    add z0.h, z0.h, z1.h
; CHECK-NEXT:    strh w8, [sp, #52]
; CHECK-NEXT:    fmov w8, s17
; CHECK-NEXT:    strh w8, [sp, #50]
; CHECK-NEXT:    fmov w8, s18
; CHECK-NEXT:    mov z18.h, z7.h[7]
; CHECK-NEXT:    strh w8, [sp, #48]
; CHECK-NEXT:    fmov w8, s18
; CHECK-NEXT:    mov z18.h, z6.h[6]
; CHECK-NEXT:    ldr q17, [sp, #48]
; CHECK-NEXT:    strh w8, [sp, #46]
; CHECK-NEXT:    fmov w8, s19
; CHECK-NEXT:    mov z19.h, z7.h[5]
; CHECK-NEXT:    strh w8, [sp, #44]
; CHECK-NEXT:    fmov w8, s20
; CHECK-NEXT:    mov z20.h, z6.h[5]
; CHECK-NEXT:    strh w8, [sp, #42]
; CHECK-NEXT:    fmov w8, s18
; CHECK-NEXT:    mov z18.h, z7.h[4]
; CHECK-NEXT:    strh w8, [sp, #40]
; CHECK-NEXT:    fmov w8, s19
; CHECK-NEXT:    mov z19.h, z6.h[4]
; CHECK-NEXT:    strh w8, [sp, #38]
; CHECK-NEXT:    fmov w8, s20
; CHECK-NEXT:    mov z20.h, z5.h[7]
; CHECK-NEXT:    strh w8, [sp, #36]
; CHECK-NEXT:    fmov w8, s18
; CHECK-NEXT:    mov z18.h, z2.h[7]
; CHECK-NEXT:    strh w8, [sp, #34]
; CHECK-NEXT:    fmov w8, s19
; CHECK-NEXT:    mov z19.h, z5.h[6]
; CHECK-NEXT:    strh w8, [sp, #32]
; CHECK-NEXT:    fmov w8, s20
; CHECK-NEXT:    mov z20.h, z2.h[6]
; CHECK-NEXT:    strh w8, [sp, #14]
; CHECK-NEXT:    fmov w8, s18
; CHECK-NEXT:    mov z18.h, z5.h[5]
; CHECK-NEXT:    strh w8, [sp, #12]
; CHECK-NEXT:    fmov w8, s19
; CHECK-NEXT:    mov z19.h, z2.h[5]
; CHECK-NEXT:    strh w8, [sp, #10]
; CHECK-NEXT:    fmov w8, s20
; CHECK-NEXT:    mov z20.h, z5.h[4]
; CHECK-NEXT:    fmov w9, s19
; CHECK-NEXT:    strh w8, [sp, #8]
; CHECK-NEXT:    fmov w8, s18
; CHECK-NEXT:    mov z18.h, z2.h[4]
; CHECK-NEXT:    strh w9, [sp, #4]
; CHECK-NEXT:    ldr q2, [sp, #32]
; CHECK-NEXT:    strh w8, [sp, #6]
; CHECK-NEXT:    fmov w8, s20
; CHECK-NEXT:    add z2.h, z16.h, z2.h
; CHECK-NEXT:    strh w8, [sp, #2]
; CHECK-NEXT:    fmov w8, s18
; CHECK-NEXT:    strh w8, [sp]
; CHECK-NEXT:    ldr q4, [sp]
; CHECK-NEXT:    stp q3, q2, [x0, #32]
; CHECK-NEXT:    add z1.h, z17.h, z4.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    ret
  %tmp1 = load <32 x i16>, ptr %a
  %tmp2 = load <32 x i16>, ptr %b
  %tmp3 = shufflevector <32 x i16> %tmp1, <32 x i16> %tmp2, <32 x i32> <i32 0, i32 32, i32 1, i32 33, i32 2, i32 34, i32 3, i32 35, i32 4, i32 36, i32 5, i32 37, i32 6, i32 38, i32 7, i32 39, i32 8, i32 40, i32 9, i32 41, i32 10, i32 42, i32 11, i32 43, i32 12, i32 44, i32 13, i32 45, i32 14, i32 46, i32 15, i32 47>
  %tmp4 = shufflevector <32 x i16> %tmp1, <32 x i16> %tmp2, <32 x i32> <i32 16, i32 48, i32 17, i32 49, i32 18, i32 50, i32 19, i32 51, i32 20, i32 52, i32 21, i32 53, i32 22, i32 54, i32 23, i32 55, i32 24, i32 56, i32 25, i32 57, i32 26, i32 58, i32 27, i32 59, i32 28, i32 60, i32 29, i32 61, i32 30, i32 62, i32 31, i32 63>
  %tmp5 = add <32 x i16> %tmp3, %tmp4
  store <32 x i16> %tmp5, ptr %a
  ret void
}

define void @zip1_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: zip1_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1, #16]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    mov z2.h, z0.h[7]
; CHECK-NEXT:    mov z3.h, z0.h[6]
; CHECK-NEXT:    mov z4.h, z0.h[5]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.h, z0.h[4]
; CHECK-NEXT:    fmov w9, s3
; CHECK-NEXT:    mov z3.h, z1.h[7]
; CHECK-NEXT:    zip1 z0.h, z0.h, z1.h
; CHECK-NEXT:    strh w8, [sp, #12]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.h, z1.h[6]
; CHECK-NEXT:    strh w9, [sp, #8]
; CHECK-NEXT:    fmov w9, s2
; CHECK-NEXT:    mov z2.h, z1.h[5]
; CHECK-NEXT:    strh w8, [sp, #4]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z3.h, z1.h[4]
; CHECK-NEXT:    strh w9, [sp]
; CHECK-NEXT:    fmov w9, s4
; CHECK-NEXT:    strh w8, [sp, #14]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    strh w9, [sp, #10]
; CHECK-NEXT:    strh w8, [sp, #6]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    strh w8, [sp, #2]
; CHECK-NEXT:    ldr q1, [sp]
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
  %tmp1 = load volatile <16 x i16>, ptr %a
  %tmp2 = load volatile <16 x i16>, ptr %b
  %tmp3 = shufflevector <16 x i16> %tmp1, <16 x i16> %tmp2, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
  store volatile <16 x i16> %tmp3, ptr %a
  ret void
}

define void @zip1_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: zip1_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1, #16]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    mov z2.s, z0.s[3]
; CHECK-NEXT:    mov z4.s, z0.s[2]
; CHECK-NEXT:    mov z3.s, z1.s[3]
; CHECK-NEXT:    zip1 z0.s, z0.s, z1.s
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.s, z1.s[2]
; CHECK-NEXT:    fmov w9, s3
; CHECK-NEXT:    stp w8, w9, [sp, #8]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    fmov w9, s2
; CHECK-NEXT:    stp w8, w9, [sp]
; CHECK-NEXT:    ldr q1, [sp]
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
  %tmp1 = load volatile <8 x i32>, ptr %a
  %tmp2 = load volatile <8 x i32>, ptr %b
  %tmp3 = shufflevector <8 x i32> %tmp1, <8 x i32> %tmp2, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
  store volatile <8 x i32> %tmp3, ptr %a
  ret void
}

define void @zip_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: zip_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q3, q2, [x1]
; CHECK-NEXT:    zip1 z4.d, z1.d, z3.d
; CHECK-NEXT:    zip1 z5.d, z0.d, z2.d
; CHECK-NEXT:    trn2 z1.d, z1.d, z3.d
; CHECK-NEXT:    trn2 z0.d, z0.d, z2.d
; CHECK-NEXT:    movprfx z2, z4
; CHECK-NEXT:    fadd z2.d, p0/m, z2.d, z5.d
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    stp q2, q0, [x0]
; CHECK-NEXT:    ret
  %tmp1 = load <4 x double>, ptr %a
  %tmp2 = load <4 x double>, ptr %b
  %tmp3 = shufflevector <4 x double> %tmp1, <4 x double> %tmp2, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %tmp4 = shufflevector <4 x double> %tmp1, <4 x double> %tmp2, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %tmp5 = fadd <4 x double> %tmp3, %tmp4
  store <4 x double> %tmp5, ptr %a
  ret void
}

define void @zip_v4i32(ptr %a, ptr %b) {
; CHECK-LABEL: zip_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldr q0, [x1]
; CHECK-NEXT:    ldr q1, [x0]
; CHECK-NEXT:    mov z2.s, z0.s[3]
; CHECK-NEXT:    mov z3.s, z1.s[3]
; CHECK-NEXT:    mov z4.s, z0.s[2]
; CHECK-NEXT:    zip1 z0.s, z1.s, z0.s
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.s, z1.s[2]
; CHECK-NEXT:    fmov w9, s3
; CHECK-NEXT:    stp w9, w8, [sp, #8]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    fmov w9, s2
; CHECK-NEXT:    stp w9, w8, [sp]
; CHECK-NEXT:    ldr q1, [sp]
; CHECK-NEXT:    add z0.s, z0.s, z1.s
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
  %tmp1 = load <4 x i32>, ptr %a
  %tmp2 = load <4 x i32>, ptr %b
  %tmp3 = shufflevector <4 x i32> %tmp1, <4 x i32> %tmp2, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %tmp4 = shufflevector <4 x i32> %tmp1, <4 x i32> %tmp2, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %tmp5 = add <4 x i32> %tmp3, %tmp4
  store <4 x i32> %tmp5, ptr %a
  ret void
}

define void @zip1_v8i32_undef(ptr %a) {
; CHECK-LABEL: zip1_v8i32_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI6_0
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI6_0]
; CHECK-NEXT:    tbl z1.s, { z0.s }, z1.s
; CHECK-NEXT:    zip1 z0.s, z0.s, z0.s
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %tmp1 = load  volatile <8 x i32>, ptr %a
  %tmp2 = shufflevector <8 x i32> %tmp1, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 1, i32 1, i32 2, i32 2, i32 3, i32 3>
  store volatile <8 x i32> %tmp2, ptr %a
  ret void
}

define void @trn_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: trn_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    trn1 z4.b, z0.b, z1.b
; CHECK-NEXT:    trn2 z0.b, z0.b, z1.b
; CHECK-NEXT:    trn1 z1.b, z2.b, z3.b
; CHECK-NEXT:    trn2 z2.b, z2.b, z3.b
; CHECK-NEXT:    add z0.b, z4.b, z0.b
; CHECK-NEXT:    add z1.b, z1.b, z2.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %tmp1 = load <32 x i8>, ptr %a
  %tmp2 = load <32 x i8>, ptr %b
  %tmp3 = shufflevector <32 x i8> %tmp1, <32 x i8> %tmp2, <32 x i32> <i32 0, i32 32, i32 2, i32 34, i32 4, i32 36, i32 6, i32 38, i32 8, i32 40, i32 10, i32 42, i32 12, i32 44, i32 14, i32 46, i32 16, i32 48, i32 18, i32 50, i32 20, i32 52, i32 22, i32 54, i32 24, i32 56, i32 26, i32 58, i32 28, i32 60, i32 30, i32 62>
  %tmp4 = shufflevector <32 x i8> %tmp1, <32 x i8> %tmp2, <32 x i32> <i32 1, i32 33, i32 3, i32 35, i32 undef, i32 37, i32 7, i32 undef, i32 undef, i32 41, i32 11, i32 43, i32 13, i32 45, i32 15, i32 47, i32 17, i32 49, i32 19, i32 51, i32 21, i32 53, i32 23, i32 55, i32 25, i32 57, i32 27, i32 59, i32 29, i32 61, i32 31, i32 63>
  %tmp5 = add <32 x i8> %tmp3, %tmp4
  store <32 x i8> %tmp5, ptr %a
  ret void
}

define void @trn_v8i16(ptr %a, ptr %b) {
; CHECK-LABEL: trn_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI8_0
; CHECK-NEXT:    adrp x9, .LCPI8_1
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI8_0]
; CHECK-NEXT:    ldr q2, [x9, :lo12:.LCPI8_1]
; CHECK-NEXT:    tbl z1.h, { z0.h }, z1.h
; CHECK-NEXT:    tbl z0.h, { z0.h }, z2.h
; CHECK-NEXT:    add z0.h, z1.h, z0.h
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %tmp1 = load <8 x i16>, ptr %a
  %tmp2 = load <8 x i16>, ptr %b
  %tmp3 = shufflevector <8 x i16> %tmp1, <8 x i16> %tmp2, <8 x i32> <i32 0, i32 7, i32 2, i32 6, i32 4, i32 5, i32 1, i32 3>
  %tmp4 = shufflevector <8 x i16> %tmp1, <8 x i16> %tmp2, <8 x i32> <i32 1, i32 6, i32 3, i32 5, i32 undef, i32 4, i32 7, i32 undef>
  %tmp5 = add <8 x i16> %tmp3, %tmp4
  store <8 x i16> %tmp5, ptr %a
  ret void
}

define void @trn_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: trn_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    trn1 z4.h, z0.h, z1.h
; CHECK-NEXT:    trn2 z0.h, z0.h, z1.h
; CHECK-NEXT:    trn1 z1.h, z2.h, z3.h
; CHECK-NEXT:    trn2 z2.h, z2.h, z3.h
; CHECK-NEXT:    add z0.h, z4.h, z0.h
; CHECK-NEXT:    add z1.h, z1.h, z2.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %tmp1 = load <16 x i16>, ptr %a
  %tmp2 = load <16 x i16>, ptr %b
  %tmp3 = shufflevector <16 x i16> %tmp1, <16 x i16> %tmp2, <16 x i32> <i32 0, i32 16, i32 2, i32 18, i32 4, i32 20, i32 6, i32 22, i32 8, i32 24, i32 10, i32 26, i32 12, i32 28, i32 14, i32 30>
  %tmp4 = shufflevector <16 x i16> %tmp1, <16 x i16> %tmp2, <16 x i32> <i32 1, i32 17, i32 3, i32 19, i32 5, i32 21, i32 7, i32 23, i32 9, i32 25, i32 11, i32 27, i32 13, i32 29, i32 15, i32 31>
  %tmp5 = add <16 x i16> %tmp3, %tmp4
  store <16 x i16> %tmp5, ptr %a
  ret void
}

define void @trn_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: trn_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    zip1 z4.s, z0.s, z1.s
; CHECK-NEXT:    trn2 z0.s, z0.s, z1.s
; CHECK-NEXT:    trn1 z1.s, z2.s, z3.s
; CHECK-NEXT:    trn2 z2.s, z2.s, z3.s
; CHECK-NEXT:    add z0.s, z4.s, z0.s
; CHECK-NEXT:    add z1.s, z1.s, z2.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %tmp1 = load <8 x i32>, ptr %a
  %tmp2 = load <8 x i32>, ptr %b
  %tmp3 = shufflevector <8 x i32> %tmp1, <8 x i32> %tmp2, <8 x i32> <i32 0, i32 8, i32 undef, i32 undef, i32 4, i32 12, i32 6, i32 14>
  %tmp4 = shufflevector <8 x i32> %tmp1, <8 x i32> %tmp2, <8 x i32> <i32 1, i32 undef, i32 3, i32 11, i32 5, i32 13, i32 undef, i32 undef>
  %tmp5 = add <8 x i32> %tmp3, %tmp4
  store <8 x i32> %tmp5, ptr %a
  ret void
}

define void @trn_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: trn_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    zip1 z4.d, z0.d, z1.d
; CHECK-NEXT:    trn2 z0.d, z0.d, z1.d
; CHECK-NEXT:    zip1 z1.d, z2.d, z3.d
; CHECK-NEXT:    trn2 z2.d, z2.d, z3.d
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z4.d
; CHECK-NEXT:    fadd z1.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %tmp1 = load <4 x double>, ptr %a
  %tmp2 = load <4 x double>, ptr %b
  %tmp3 = shufflevector <4 x double> %tmp1, <4 x double> %tmp2, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  %tmp4 = shufflevector <4 x double> %tmp1, <4 x double> %tmp2, <4 x i32> <i32 1, i32 5, i32 3, i32 7>
  %tmp5 = fadd <4 x double> %tmp3, %tmp4
  store <4 x double> %tmp5, ptr %a
  ret void
}

define void @trn_v4f32(ptr %a, ptr %b) {
; CHECK-LABEL: trn_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    trn1 z2.s, z0.s, z1.s
; CHECK-NEXT:    trn2 z0.s, z0.s, z1.s
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z2.s
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %tmp1 = load <4 x float>, ptr %a
  %tmp2 = load <4 x float>, ptr %b
  %tmp3 = shufflevector <4 x float> %tmp1, <4 x float> %tmp2, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  %tmp4 = shufflevector <4 x float> %tmp1, <4 x float> %tmp2, <4 x i32> <i32 1, i32 5, i32 3, i32 7>
  %tmp5 = fadd <4 x float> %tmp3, %tmp4
  store <4 x float> %tmp5, ptr %a
  ret void
}

define void @trn_v8i32_undef(ptr %a) {
; CHECK-LABEL: trn_v8i32_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    trn1 z2.s, z0.s, z0.s
; CHECK-NEXT:    trn2 z0.s, z0.s, z0.s
; CHECK-NEXT:    trn1 z3.s, z1.s, z1.s
; CHECK-NEXT:    trn2 z1.s, z1.s, z1.s
; CHECK-NEXT:    add z0.s, z2.s, z0.s
; CHECK-NEXT:    add z1.s, z3.s, z1.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %tmp1 = load <8 x i32>, ptr %a
  %tmp3 = shufflevector <8 x i32> %tmp1, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  %tmp4 = shufflevector <8 x i32> %tmp1, <8 x i32> undef, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7>
  %tmp5 = add <8 x i32> %tmp3, %tmp4
  store <8 x i32> %tmp5, ptr %a
  ret void
}

define void @zip2_v32i8(ptr %a, ptr %b) #0{
; CHECK-LABEL: zip2_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    ldr q1, [x1, #16]
; CHECK-NEXT:    mov z2.b, z0.b[15]
; CHECK-NEXT:    mov z3.b, z0.b[14]
; CHECK-NEXT:    mov z4.b, z0.b[13]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    fmov w9, s3
; CHECK-NEXT:    mov z3.b, z0.b[11]
; CHECK-NEXT:    mov z2.b, z0.b[12]
; CHECK-NEXT:    strb w8, [sp, #14]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z0.b[10]
; CHECK-NEXT:    strb w9, [sp, #12]
; CHECK-NEXT:    fmov w9, s2
; CHECK-NEXT:    mov z2.b, z0.b[9]
; CHECK-NEXT:    strb w8, [sp, #10]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z3.b, z0.b[8]
; CHECK-NEXT:    strb w9, [sp, #8]
; CHECK-NEXT:    zip1 z0.b, z0.b, z1.b
; CHECK-NEXT:    strb w8, [sp, #6]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z1.b[15]
; CHECK-NEXT:    strb w8, [sp, #4]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.b, z1.b[14]
; CHECK-NEXT:    strb w8, [sp, #2]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z3.b, z1.b[13]
; CHECK-NEXT:    strb w8, [sp]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z1.b[12]
; CHECK-NEXT:    strb w8, [sp, #15]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.b, z1.b[11]
; CHECK-NEXT:    strb w8, [sp, #13]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z3.b, z1.b[10]
; CHECK-NEXT:    strb w8, [sp, #11]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z1.b[9]
; CHECK-NEXT:    fmov w9, s3
; CHECK-NEXT:    strb w8, [sp, #9]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.b, z1.b[8]
; CHECK-NEXT:    strb w9, [sp, #5]
; CHECK-NEXT:    strb w8, [sp, #7]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    strb w8, [sp, #3]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    strb w8, [sp, #1]
; CHECK-NEXT:    ldr q1, [sp]
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
  %tmp1 = load volatile <32 x i8>, ptr %a
  %tmp2 = load volatile <32 x i8>, ptr %b
  %tmp3 = shufflevector <32 x i8> %tmp1, <32 x i8> %tmp2, <32 x i32> <i32 16, i32 48, i32 17, i32 49, i32 18, i32 50, i32 19, i32 51, i32 20, i32 52, i32 21, i32 53, i32 22, i32 54, i32 23, i32 55, i32 24, i32 56, i32 25, i32 57, i32 26, i32 58, i32 27, i32 59, i32 28, i32 60, i32 29, i32 61, i32 30, i32 62, i32 31, i32 63>
  store volatile <32 x i8> %tmp3, ptr %a
  ret void
}

define void @zip2_v16i16(ptr %a, ptr %b) #0{
; CHECK-LABEL: zip2_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    ldr q1, [x1, #16]
; CHECK-NEXT:    mov z2.h, z0.h[7]
; CHECK-NEXT:    mov z3.h, z0.h[6]
; CHECK-NEXT:    mov z4.h, z0.h[5]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.h, z0.h[4]
; CHECK-NEXT:    fmov w9, s3
; CHECK-NEXT:    mov z3.h, z1.h[7]
; CHECK-NEXT:    zip1 z0.h, z0.h, z1.h
; CHECK-NEXT:    strh w8, [sp, #12]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.h, z1.h[6]
; CHECK-NEXT:    strh w9, [sp, #8]
; CHECK-NEXT:    fmov w9, s2
; CHECK-NEXT:    mov z2.h, z1.h[5]
; CHECK-NEXT:    strh w8, [sp, #4]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z3.h, z1.h[4]
; CHECK-NEXT:    strh w9, [sp]
; CHECK-NEXT:    fmov w9, s4
; CHECK-NEXT:    strh w8, [sp, #14]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    strh w9, [sp, #10]
; CHECK-NEXT:    strh w8, [sp, #6]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    strh w8, [sp, #2]
; CHECK-NEXT:    ldr q1, [sp]
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
  %tmp1 = load volatile <16 x i16>, ptr %a
  %tmp2 = load volatile <16 x i16>, ptr %b
  %tmp3 = shufflevector <16 x i16> %tmp1, <16 x i16> %tmp2, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
  store volatile <16 x i16> %tmp3, ptr %a
  ret void
}

define void @zip2_v8i32(ptr %a, ptr %b) #0{
; CHECK-LABEL: zip2_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    ldr q1, [x1, #16]
; CHECK-NEXT:    mov z2.s, z0.s[3]
; CHECK-NEXT:    mov z4.s, z0.s[2]
; CHECK-NEXT:    mov z3.s, z1.s[3]
; CHECK-NEXT:    zip1 z0.s, z0.s, z1.s
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.s, z1.s[2]
; CHECK-NEXT:    fmov w9, s3
; CHECK-NEXT:    stp w8, w9, [sp, #8]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    fmov w9, s2
; CHECK-NEXT:    stp w8, w9, [sp]
; CHECK-NEXT:    ldr q1, [sp]
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
  %tmp1 = load volatile <8 x i32>, ptr %a
  %tmp2 = load volatile <8 x i32>, ptr %b
  %tmp3 = shufflevector <8 x i32> %tmp1, <8 x i32> %tmp2, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  store volatile <8 x i32> %tmp3, ptr %a
  ret void
}

define void @zip2_v8i32_undef(ptr %a) #0{
; CHECK-LABEL: zip2_v8i32_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI17_0
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI17_0]
; CHECK-NEXT:    tbl z1.s, { z0.s }, z1.s
; CHECK-NEXT:    zip1 z0.s, z0.s, z0.s
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %tmp1 = load volatile <8 x i32>, ptr %a
  %tmp2 = shufflevector <8 x i32> %tmp1, <8 x i32> undef, <8 x i32> <i32 4, i32 4, i32 5, i32 5, i32 6, i32 6, i32 7, i32 7>
  store volatile <8 x i32> %tmp2, ptr %a
  ret void
}

define void @uzp_v32i8(ptr %a, ptr %b) #0{
; CHECK-LABEL: uzp_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    ldp q2, q3, [x0]
; CHECK-NEXT:    ldp q0, q1, [x1]
; CHECK-NEXT:    mov z4.b, z3.b[14]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z6.b, z3.b[10]
; CHECK-NEXT:    mov z5.b, z3.b[12]
; CHECK-NEXT:    fmov w9, s2
; CHECK-NEXT:    mov z7.b, z3.b[8]
; CHECK-NEXT:    mov z17.b, z3.b[9]
; CHECK-NEXT:    mov z18.b, z3.b[7]
; CHECK-NEXT:    mov z16.b, z3.b[11]
; CHECK-NEXT:    strb w8, [sp, #40]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z3.b[6]
; CHECK-NEXT:    strb w9, [sp, #32]
; CHECK-NEXT:    fmov w9, s5
; CHECK-NEXT:    mov z5.b, z3.b[4]
; CHECK-NEXT:    strb w8, [sp, #47]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.b, z3.b[2]
; CHECK-NEXT:    strb w9, [sp, #46]
; CHECK-NEXT:    fmov w9, s7
; CHECK-NEXT:    mov z7.b, z2.b[14]
; CHECK-NEXT:    strb w8, [sp, #45]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z2.b[12]
; CHECK-NEXT:    strb w9, [sp, #44]
; CHECK-NEXT:    fmov w9, s16
; CHECK-NEXT:    mov z16.b, z2.b[11]
; CHECK-NEXT:    strb w8, [sp, #43]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    mov z5.b, z2.b[10]
; CHECK-NEXT:    strb w9, [sp, #61]
; CHECK-NEXT:    fmov w9, s16
; CHECK-NEXT:    strb w8, [sp, #42]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.b, z2.b[8]
; CHECK-NEXT:    strb w9, [sp, #53]
; CHECK-NEXT:    strb w8, [sp, #41]
; CHECK-NEXT:    fmov w8, s7
; CHECK-NEXT:    mov z7.b, z2.b[6]
; CHECK-NEXT:    strb w8, [sp, #39]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z2.b[4]
; CHECK-NEXT:    strb w8, [sp, #38]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    mov z5.b, z2.b[2]
; CHECK-NEXT:    strb w8, [sp, #37]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.b, z1.b[10]
; CHECK-NEXT:    strb w8, [sp, #36]
; CHECK-NEXT:    fmov w8, s7
; CHECK-NEXT:    mov z7.b, z1.b[8]
; CHECK-NEXT:    strb w8, [sp, #35]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z1.b[14]
; CHECK-NEXT:    strb w8, [sp, #34]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    mov z5.b, z1.b[12]
; CHECK-NEXT:    strb w8, [sp, #33]
; CHECK-NEXT:    fmov w8, s1
; CHECK-NEXT:    strb w8, [sp, #8]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    strb w8, [sp]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z1.b[6]
; CHECK-NEXT:    strb w8, [sp, #15]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    mov z5.b, z1.b[4]
; CHECK-NEXT:    strb w8, [sp, #14]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.b, z1.b[2]
; CHECK-NEXT:    strb w8, [sp, #13]
; CHECK-NEXT:    fmov w8, s7
; CHECK-NEXT:    mov z7.b, z0.b[14]
; CHECK-NEXT:    strb w8, [sp, #12]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z0.b[12]
; CHECK-NEXT:    strb w8, [sp, #11]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    mov z5.b, z0.b[10]
; CHECK-NEXT:    strb w8, [sp, #10]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.b, z0.b[8]
; CHECK-NEXT:    strb w8, [sp, #9]
; CHECK-NEXT:    fmov w8, s7
; CHECK-NEXT:    mov z7.b, z0.b[6]
; CHECK-NEXT:    strb w8, [sp, #7]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.b, z0.b[4]
; CHECK-NEXT:    strb w8, [sp, #6]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    mov z5.b, z0.b[2]
; CHECK-NEXT:    strb w8, [sp, #5]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.b, z3.b[15]
; CHECK-NEXT:    strb w8, [sp, #4]
; CHECK-NEXT:    fmov w8, s7
; CHECK-NEXT:    mov z7.b, z3.b[13]
; CHECK-NEXT:    strb w8, [sp, #3]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    ldr q4, [sp, #32]
; CHECK-NEXT:    strb w8, [sp, #2]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    strb w8, [sp, #1]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.b, z3.b[5]
; CHECK-NEXT:    mov z3.b, z3.b[3]
; CHECK-NEXT:    ldr q5, [sp]
; CHECK-NEXT:    strb w8, [sp, #63]
; CHECK-NEXT:    fmov w8, s7
; CHECK-NEXT:    mov z7.b, z2.b[13]
; CHECK-NEXT:    strb w8, [sp, #62]
; CHECK-NEXT:    fmov w8, s17
; CHECK-NEXT:    strb w8, [sp, #60]
; CHECK-NEXT:    fmov w8, s18
; CHECK-NEXT:    strb w8, [sp, #59]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.b, z2.b[9]
; CHECK-NEXT:    strb w8, [sp, #58]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z3.b, z2.b[5]
; CHECK-NEXT:    strb w8, [sp, #57]
; CHECK-NEXT:    fmov w8, s7
; CHECK-NEXT:    mov z7.b, z2.b[3]
; CHECK-NEXT:    mov z2.b, z2.b[1]
; CHECK-NEXT:    strb w8, [sp, #54]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.b, z1.b[15]
; CHECK-NEXT:    strb w8, [sp, #52]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z3.b, z1.b[13]
; CHECK-NEXT:    strb w8, [sp, #50]
; CHECK-NEXT:    fmov w8, s7
; CHECK-NEXT:    mov z7.b, z1.b[11]
; CHECK-NEXT:    strb w8, [sp, #49]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.b, z1.b[9]
; CHECK-NEXT:    strb w8, [sp, #48]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.b, z1.b[7]
; CHECK-NEXT:    fmov w9, s2
; CHECK-NEXT:    mov z2.b, z0.b[15]
; CHECK-NEXT:    strb w8, [sp, #31]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z3.b, z1.b[5]
; CHECK-NEXT:    strb w9, [sp, #28]
; CHECK-NEXT:    strb w8, [sp, #30]
; CHECK-NEXT:    fmov w8, s7
; CHECK-NEXT:    mov z7.b, z1.b[3]
; CHECK-NEXT:    mov z1.b, z1.b[1]
; CHECK-NEXT:    strb w8, [sp, #29]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.b, z0.b[11]
; CHECK-NEXT:    strb w8, [sp, #27]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z3.b, z0.b[13]
; CHECK-NEXT:    strb w8, [sp, #26]
; CHECK-NEXT:    fmov w8, s7
; CHECK-NEXT:    strb w8, [sp, #25]
; CHECK-NEXT:    fmov w8, s1
; CHECK-NEXT:    mov z1.b, z0.b[9]
; CHECK-NEXT:    strb w8, [sp, #24]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.b, z0.b[7]
; CHECK-NEXT:    strb w8, [sp, #23]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z3.b, z0.b[5]
; CHECK-NEXT:    strb w8, [sp, #22]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.b, z0.b[3]
; CHECK-NEXT:    mov z0.b, z0.b[1]
; CHECK-NEXT:    strb w8, [sp, #21]
; CHECK-NEXT:    fmov w8, s1
; CHECK-NEXT:    strb w8, [sp, #20]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    strb w8, [sp, #19]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    strb w8, [sp, #18]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    strb w8, [sp, #17]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    ldr q0, [sp, #48]
; CHECK-NEXT:    add z0.b, z4.b, z0.b
; CHECK-NEXT:    strb w8, [sp, #16]
; CHECK-NEXT:    ldr q1, [sp, #16]
; CHECK-NEXT:    add z1.b, z5.b, z1.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    ret
  %tmp1 = load <32 x i8>, ptr %a
  %tmp2 = load <32 x i8>, ptr %b
  %tmp3 = shufflevector <32 x i8> %tmp1, <32 x i8> %tmp2, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 32, i32 34, i32 36, i32 38, i32 40, i32 42, i32 44, i32 46, i32 48, i32 50, i32 52, i32 54, i32 56, i32 58, i32 60, i32 62>
  %tmp4 = shufflevector <32 x i8> %tmp1, <32 x i8> %tmp2, <32 x i32> <i32 1, i32 3, i32 5, i32 undef, i32 9, i32 11, i32 13, i32 undef, i32 undef, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31, i32 33, i32 35, i32 37, i32 39, i32 41, i32 43, i32 45, i32 47, i32 49, i32 51, i32 53, i32 55, i32 57, i32 59, i32 61, i32 63>
  %tmp5 = add <32 x i8> %tmp3, %tmp4
  store <32 x i8> %tmp5, ptr %a
  ret void
}

define void @uzp_v4i16(ptr %a, ptr %b) #0{
; CHECK-LABEL: uzp_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI19_0
; CHECK-NEXT:    adrp x9, .LCPI19_1
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI19_0]
; CHECK-NEXT:    ldr q2, [x9, :lo12:.LCPI19_1]
; CHECK-NEXT:    tbl z1.h, { z0.h }, z1.h
; CHECK-NEXT:    tbl z0.h, { z0.h }, z2.h
; CHECK-NEXT:    add z0.h, z1.h, z0.h
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
  %tmp1 = load <4 x i16>, ptr %a
  %tmp2 = load <4 x i16>, ptr %b
  %tmp3 = shufflevector <4 x i16> %tmp1, <4 x i16> %tmp2, <4 x i32> <i32 0, i32 3, i32 2, i32 1>
  %tmp4 = shufflevector <4 x i16> %tmp1, <4 x i16> %tmp2, <4 x i32> <i32 1, i32 0, i32 2, i32 undef>
  %tmp5 = add <4 x i16> %tmp3, %tmp4
  store <4 x i16> %tmp5, ptr %a
  ret void
}

define void @uzp_v16i16(ptr %a, ptr %b) #0{
; CHECK-LABEL: uzp_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    ldp q2, q3, [x0]
; CHECK-NEXT:    ldp q0, q1, [x1]
; CHECK-NEXT:    mov z4.h, z3.h[6]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    mov z6.h, z3.h[2]
; CHECK-NEXT:    mov z5.h, z3.h[4]
; CHECK-NEXT:    fmov w9, s2
; CHECK-NEXT:    mov z7.h, z2.h[6]
; CHECK-NEXT:    mov z17.h, z2.h[7]
; CHECK-NEXT:    mov z16.h, z3.h[1]
; CHECK-NEXT:    strh w8, [sp, #40]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.h, z2.h[4]
; CHECK-NEXT:    strh w9, [sp, #32]
; CHECK-NEXT:    fmov w9, s5
; CHECK-NEXT:    mov z5.h, z2.h[2]
; CHECK-NEXT:    strh w8, [sp, #46]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.h, z1.h[2]
; CHECK-NEXT:    strh w9, [sp, #44]
; CHECK-NEXT:    fmov w9, s7
; CHECK-NEXT:    mov z7.h, z0.h[6]
; CHECK-NEXT:    strh w8, [sp, #42]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.h, z1.h[6]
; CHECK-NEXT:    strh w9, [sp, #38]
; CHECK-NEXT:    fmov w9, s16
; CHECK-NEXT:    strh w8, [sp, #36]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    mov z5.h, z1.h[4]
; CHECK-NEXT:    strh w9, [sp, #56]
; CHECK-NEXT:    strh w8, [sp, #34]
; CHECK-NEXT:    fmov w8, s1
; CHECK-NEXT:    strh w8, [sp, #8]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    strh w8, [sp]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.h, z0.h[4]
; CHECK-NEXT:    strh w8, [sp, #14]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    mov z5.h, z0.h[2]
; CHECK-NEXT:    strh w8, [sp, #12]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.h, z3.h[7]
; CHECK-NEXT:    strh w8, [sp, #10]
; CHECK-NEXT:    fmov w8, s7
; CHECK-NEXT:    mov z7.h, z3.h[5]
; CHECK-NEXT:    strh w8, [sp, #6]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    strh w8, [sp, #4]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    mov z5.h, z3.h[3]
; CHECK-NEXT:    ldr q3, [sp, #32]
; CHECK-NEXT:    strh w8, [sp, #2]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.h, z2.h[5]
; CHECK-NEXT:    ldr q4, [sp]
; CHECK-NEXT:    strh w8, [sp, #62]
; CHECK-NEXT:    fmov w8, s7
; CHECK-NEXT:    mov z7.h, z1.h[7]
; CHECK-NEXT:    strh w8, [sp, #60]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    mov z5.h, z2.h[3]
; CHECK-NEXT:    mov z2.h, z2.h[1]
; CHECK-NEXT:    strh w8, [sp, #58]
; CHECK-NEXT:    fmov w8, s17
; CHECK-NEXT:    fmov w9, s2
; CHECK-NEXT:    mov z2.h, z0.h[7]
; CHECK-NEXT:    strh w8, [sp, #54]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.h, z1.h[5]
; CHECK-NEXT:    strh w9, [sp, #48]
; CHECK-NEXT:    strh w8, [sp, #52]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    mov z5.h, z1.h[3]
; CHECK-NEXT:    mov z1.h, z1.h[1]
; CHECK-NEXT:    strh w8, [sp, #50]
; CHECK-NEXT:    fmov w8, s7
; CHECK-NEXT:    strh w8, [sp, #30]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    mov z6.h, z0.h[5]
; CHECK-NEXT:    strh w8, [sp, #28]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    mov z5.h, z0.h[3]
; CHECK-NEXT:    mov z0.h, z0.h[1]
; CHECK-NEXT:    strh w8, [sp, #26]
; CHECK-NEXT:    fmov w8, s1
; CHECK-NEXT:    strh w8, [sp, #24]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    strh w8, [sp, #22]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    strh w8, [sp, #20]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    strh w8, [sp, #18]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    ldr q0, [sp, #48]
; CHECK-NEXT:    add z0.h, z3.h, z0.h
; CHECK-NEXT:    strh w8, [sp, #16]
; CHECK-NEXT:    ldr q1, [sp, #16]
; CHECK-NEXT:    add z1.h, z4.h, z1.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    ret
  %tmp1 = load <16 x i16>, ptr %a
  %tmp2 = load <16 x i16>, ptr %b
  %tmp3 = shufflevector <16 x i16> %tmp1, <16 x i16> %tmp2, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %tmp4 = shufflevector <16 x i16> %tmp1, <16 x i16> %tmp2, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %tmp5 = add <16 x i16> %tmp3, %tmp4
  store <16 x i16> %tmp5, ptr %a
  ret void
}

define void @uzp_v8f32(ptr %a, ptr %b) #0{
; CHECK-LABEL: uzp_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    ldp q2, q0, [x0]
; CHECK-NEXT:    adrp x8, .LCPI21_0
; CHECK-NEXT:    ldp q4, q1, [x1]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    mov z3.s, z0.s[2]
; CHECK-NEXT:    mov z5.s, z1.s[2]
; CHECK-NEXT:    stp s0, s3, [sp, #24]
; CHECK-NEXT:    mov z3.s, z4.s[2]
; CHECK-NEXT:    stp s5, s2, [sp, #12]
; CHECK-NEXT:    mov z5.s, z0.s[3]
; CHECK-NEXT:    mov z0.s, z0.s[1]
; CHECK-NEXT:    stp s3, s1, [sp, #4]
; CHECK-NEXT:    mov z1.s, z2.s[1]
; CHECK-NEXT:    str s5, [sp, #44]
; CHECK-NEXT:    ldr q5, [x8, :lo12:.LCPI21_0]
; CHECK-NEXT:    str s0, [sp, #40]
; CHECK-NEXT:    ldp q3, q2, [sp]
; CHECK-NEXT:    tbl z0.s, { z4.s }, z5.s
; CHECK-NEXT:    str s1, [sp, #32]
; CHECK-NEXT:    ldr q1, [sp, #32]
; CHECK-NEXT:    fadd z1.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z3.s
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
  %tmp1 = load <8 x float>, ptr %a
  %tmp2 = load <8 x float>, ptr %b
  %tmp3 = shufflevector <8 x float> %tmp1, <8 x float> %tmp2, <8 x i32> <i32 0, i32 undef, i32 4, i32 6, i32 undef, i32 10, i32 12, i32 14>
  %tmp4 = shufflevector <8 x float> %tmp1, <8 x float> %tmp2, <8 x i32> <i32 1, i32 undef, i32 5, i32 7, i32 9, i32 11, i32 undef, i32 undef>
  %tmp5 = fadd <8 x float> %tmp3, %tmp4
  store <8 x float> %tmp5, ptr %a
  ret void
}

define void @uzp_v4i64(ptr %a, ptr %b) #0{
; CHECK-LABEL: uzp_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ldp q3, q2, [x1]
; CHECK-NEXT:    zip1 z4.d, z1.d, z0.d
; CHECK-NEXT:    trn2 z0.d, z1.d, z0.d
; CHECK-NEXT:    zip1 z1.d, z3.d, z2.d
; CHECK-NEXT:    trn2 z2.d, z3.d, z2.d
; CHECK-NEXT:    add z0.d, z4.d, z0.d
; CHECK-NEXT:    add z1.d, z1.d, z2.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %tmp1 = load <4 x i64>, ptr %a
  %tmp2 = load <4 x i64>, ptr %b
  %tmp3 = shufflevector <4 x i64> %tmp1, <4 x i64> %tmp2, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %tmp4 = shufflevector <4 x i64> %tmp1, <4 x i64> %tmp2, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %tmp5 = add <4 x i64> %tmp3, %tmp4
  store <4 x i64> %tmp5, ptr %a
  ret void
}

define void @uzp_v8i16(ptr %a, ptr %b) #0{
; CHECK-LABEL: uzp_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    mov z2.h, z1.h[6]
; CHECK-NEXT:    fmov w8, s1
; CHECK-NEXT:    mov z4.h, z1.h[2]
; CHECK-NEXT:    mov z6.h, z0.h[4]
; CHECK-NEXT:    mov z3.h, z1.h[4]
; CHECK-NEXT:    fmov w9, s0
; CHECK-NEXT:    mov z5.h, z0.h[6]
; CHECK-NEXT:    strh w8, [sp, #8]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.h, z0.h[2]
; CHECK-NEXT:    strh w9, [sp]
; CHECK-NEXT:    fmov w9, s3
; CHECK-NEXT:    mov z3.h, z1.h[7]
; CHECK-NEXT:    strh w8, [sp, #14]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.h, z1.h[5]
; CHECK-NEXT:    strh w9, [sp, #12]
; CHECK-NEXT:    fmov w9, s5
; CHECK-NEXT:    mov z5.h, z1.h[3]
; CHECK-NEXT:    mov z1.h, z1.h[1]
; CHECK-NEXT:    strh w8, [sp, #10]
; CHECK-NEXT:    fmov w8, s6
; CHECK-NEXT:    strh w9, [sp, #6]
; CHECK-NEXT:    fmov w9, s1
; CHECK-NEXT:    strh w8, [sp, #4]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    mov z2.h, z0.h[7]
; CHECK-NEXT:    strh w9, [sp, #24]
; CHECK-NEXT:    strh w8, [sp, #2]
; CHECK-NEXT:    fmov w8, s3
; CHECK-NEXT:    strh w8, [sp, #30]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    mov z4.h, z0.h[5]
; CHECK-NEXT:    strh w8, [sp, #28]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    mov z5.h, z0.h[3]
; CHECK-NEXT:    mov z0.h, z0.h[1]
; CHECK-NEXT:    strh w8, [sp, #26]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    strh w8, [sp, #22]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    strh w8, [sp, #20]
; CHECK-NEXT:    fmov w8, s5
; CHECK-NEXT:    strh w8, [sp, #18]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    strh w8, [sp, #16]
; CHECK-NEXT:    ldp q3, q0, [sp]
; CHECK-NEXT:    add z0.h, z3.h, z0.h
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    add sp, sp, #32
; CHECK-NEXT:    ret
  %tmp1 = load <8 x i16>, ptr %a
  %tmp2 = load <8 x i16>, ptr %b
  %tmp3 = shufflevector <8 x i16> %tmp1, <8 x i16> %tmp2, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %tmp4 = shufflevector <8 x i16> %tmp1, <8 x i16> %tmp2, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %tmp5 = add <8 x i16> %tmp3, %tmp4
  store <8 x i16> %tmp5, ptr %a
  ret void
}

define void @uzp_v8i32_undef(ptr %a) #0{
; CHECK-LABEL: uzp_v8i32_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    mov z2.s, z0.s[2]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    mov z3.s, z1.s[2]
; CHECK-NEXT:    mov z4.s, z0.s[3]
; CHECK-NEXT:    mov z0.s, z0.s[1]
; CHECK-NEXT:    fmov w9, s2
; CHECK-NEXT:    mov z2.s, z1.s[3]
; CHECK-NEXT:    stp w8, w9, [sp, #8]
; CHECK-NEXT:    fmov w8, s1
; CHECK-NEXT:    fmov w9, s3
; CHECK-NEXT:    mov z1.s, z1.s[1]
; CHECK-NEXT:    stp w8, w9, [sp]
; CHECK-NEXT:    fmov w8, s4
; CHECK-NEXT:    fmov w9, s0
; CHECK-NEXT:    stp w9, w8, [sp, #24]
; CHECK-NEXT:    fmov w8, s2
; CHECK-NEXT:    fmov w9, s1
; CHECK-NEXT:    stp w9, w8, [sp, #16]
; CHECK-NEXT:    ldp q0, q1, [sp]
; CHECK-NEXT:    add z0.s, z0.s, z1.s
; CHECK-NEXT:    stp q0, q0, [x0]
; CHECK-NEXT:    add sp, sp, #32
; CHECK-NEXT:    ret
  %tmp1 = load <8 x i32>, ptr %a
  %tmp3 = shufflevector <8 x i32> %tmp1, <8 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 0, i32 2, i32 4, i32 6>
  %tmp4 = shufflevector <8 x i32> %tmp1, <8 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 1, i32 3, i32 5, i32 7>
  %tmp5 = add <8 x i32> %tmp3, %tmp4
  store <8 x i32> %tmp5, ptr %a
  ret void
}

define void @zip_vscale2_4(ptr %a, ptr %b) {
; CHECK-LABEL: zip_vscale2_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q3, q2, [x1]
; CHECK-NEXT:    zip1 z4.d, z1.d, z3.d
; CHECK-NEXT:    zip1 z5.d, z0.d, z2.d
; CHECK-NEXT:    trn2 z1.d, z1.d, z3.d
; CHECK-NEXT:    trn2 z0.d, z0.d, z2.d
; CHECK-NEXT:    movprfx z2, z4
; CHECK-NEXT:    fadd z2.d, p0/m, z2.d, z5.d
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    stp q2, q0, [x0]
; CHECK-NEXT:    ret
  %tmp1 = load <4 x double>, ptr %a
  %tmp2 = load <4 x double>, ptr %b
  %tmp3 = shufflevector <4 x double> %tmp1, <4 x double> %tmp2, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %tmp4 = shufflevector <4 x double> %tmp1, <4 x double> %tmp2, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %tmp5 = fadd <4 x double> %tmp3, %tmp4
  store <4 x double> %tmp5, ptr %a
  ret void
}
