; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=riscv32 -mattr=+experimental-zfbfmin -verify-machineinstrs \
; RUN:   -target-abi ilp32f < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+experimental-zfbfmin -verify-machineinstrs \
; RUN:   -target-abi lp64f < %s | FileCheck %s

define i32 @fcmp_false(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_false:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    ret
  %1 = fcmp false bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_oeq(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_oeq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa1
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa0
; CHECK-NEXT:    feq.s a0, fa4, fa5
; CHECK-NEXT:    ret
  %1 = fcmp oeq bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ogt(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_ogt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa1
; CHECK-NEXT:    flt.s a0, fa4, fa5
; CHECK-NEXT:    ret
  %1 = fcmp ogt bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_oge(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_oge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa1
; CHECK-NEXT:    fle.s a0, fa4, fa5
; CHECK-NEXT:    ret
  %1 = fcmp oge bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_olt(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_olt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa1
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa0
; CHECK-NEXT:    flt.s a0, fa4, fa5
; CHECK-NEXT:    ret
  %1 = fcmp olt bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ole(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_ole:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa1
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa0
; CHECK-NEXT:    fle.s a0, fa4, fa5
; CHECK-NEXT:    ret
  %1 = fcmp ole bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_one(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_one:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa1
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa0
; CHECK-NEXT:    flt.s a0, fa4, fa5
; CHECK-NEXT:    flt.s a1, fa5, fa4
; CHECK-NEXT:    or a0, a1, a0
; CHECK-NEXT:    ret
  %1 = fcmp one bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ord(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_ord:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa1
; CHECK-NEXT:    feq.s a0, fa5, fa5
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    feq.s a1, fa5, fa5
; CHECK-NEXT:    and a0, a1, a0
; CHECK-NEXT:    ret
  %1 = fcmp ord bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ueq(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_ueq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa1
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa0
; CHECK-NEXT:    flt.s a0, fa4, fa5
; CHECK-NEXT:    flt.s a1, fa5, fa4
; CHECK-NEXT:    or a0, a1, a0
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
  %1 = fcmp ueq bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ugt(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_ugt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa1
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa0
; CHECK-NEXT:    fle.s a0, fa4, fa5
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
  %1 = fcmp ugt bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_uge(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_uge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa1
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa0
; CHECK-NEXT:    flt.s a0, fa4, fa5
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
  %1 = fcmp uge bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ult(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_ult:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa1
; CHECK-NEXT:    fle.s a0, fa4, fa5
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
  %1 = fcmp ult bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ule(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_ule:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa1
; CHECK-NEXT:    flt.s a0, fa4, fa5
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
  %1 = fcmp ule bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_une(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_une:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa1
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa0
; CHECK-NEXT:    feq.s a0, fa4, fa5
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
  %1 = fcmp une bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_uno(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_uno:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa1
; CHECK-NEXT:    feq.s a0, fa5, fa5
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    feq.s a1, fa5, fa5
; CHECK-NEXT:    and a0, a1, a0
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
  %1 = fcmp uno bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_true(bfloat %a, bfloat %b) nounwind {
; CHECK-LABEL: fcmp_true:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 1
; CHECK-NEXT:    ret
  %1 = fcmp true bfloat %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}
