/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.common;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import io.flutter.Log;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.StandardMethodCodec;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class BasicMessageChannel<T> {
    private static final String TAG = "BasicMessageChannel#";
    public static final String CHANNEL_BUFFERS_CHANNEL = "dev.flutter/channel-buffers";
    @NonNull
    private final BinaryMessenger messenger;
    @NonNull
    private final String name;
    @NonNull
    private final MessageCodec<T> codec;
    @Nullable
    private final BinaryMessenger.TaskQueue taskQueue;

    public BasicMessageChannel(@NonNull BinaryMessenger messenger, @NonNull String name, @NonNull MessageCodec<T> codec) {
        this(messenger, name, codec, null);
    }

    public BasicMessageChannel(@NonNull BinaryMessenger messenger, @NonNull String name, @NonNull MessageCodec<T> codec, BinaryMessenger.TaskQueue taskQueue) {
        if (messenger == null) {
            Log.e(TAG, "Parameter messenger must not be null.");
        }
        if (name == null) {
            Log.e(TAG, "Parameter name must not be null.");
        }
        if (codec == null) {
            Log.e(TAG, "Parameter codec must not be null.");
        }
        this.messenger = messenger;
        this.name = name;
        this.codec = codec;
        this.taskQueue = taskQueue;
    }

    public void send(@Nullable T message) {
        this.send(message, null);
    }

    @UiThread
    public void send(@Nullable T message, @Nullable Reply<T> callback) {
        this.messenger.send(this.name, this.codec.encodeMessage(message), callback == null ? null : new IncomingReplyHandler(callback));
    }

    @UiThread
    public void setMessageHandler(@Nullable MessageHandler<T> handler) {
        if (this.taskQueue != null) {
            this.messenger.setMessageHandler(this.name, handler == null ? null : new IncomingMessageHandler(handler), this.taskQueue);
        } else {
            this.messenger.setMessageHandler(this.name, handler == null ? null : new IncomingMessageHandler(handler));
        }
    }

    public void resizeChannelBuffer(int newSize) {
        BasicMessageChannel.resizeChannelBuffer(this.messenger, this.name, newSize);
    }

    public void setWarnsOnChannelOverflow(boolean warns) {
        BasicMessageChannel.setWarnsOnChannelOverflow(this.messenger, this.name, warns);
    }

    private static ByteBuffer packetFromEncodedMessage(ByteBuffer message) {
        message.flip();
        byte[] bytes = new byte[message.remaining()];
        message.get(bytes);
        ByteBuffer packet = ByteBuffer.allocateDirect(bytes.length);
        packet.put(bytes);
        return packet;
    }

    public static void resizeChannelBuffer(@NonNull BinaryMessenger messenger, @NonNull String channel, int newSize) {
        StandardMethodCodec codec = StandardMethodCodec.INSTANCE;
        Object[] arguments = new Object[]{channel, newSize};
        MethodCall methodCall = new MethodCall("resize", Arrays.asList(arguments));
        ByteBuffer message = codec.encodeMethodCall(methodCall);
        ByteBuffer packet = BasicMessageChannel.packetFromEncodedMessage(message);
        messenger.send(CHANNEL_BUFFERS_CHANNEL, packet);
    }

    public static void setWarnsOnChannelOverflow(@NonNull BinaryMessenger messenger, @NonNull String channel, boolean warns) {
        StandardMethodCodec codec = StandardMethodCodec.INSTANCE;
        Object[] arguments = new Object[]{channel, !warns};
        MethodCall methodCall = new MethodCall("overflow", Arrays.asList(arguments));
        ByteBuffer message = codec.encodeMethodCall(methodCall);
        ByteBuffer packet = BasicMessageChannel.packetFromEncodedMessage(message);
        messenger.send(CHANNEL_BUFFERS_CHANNEL, packet);
    }

    public static interface Reply<T> {
        public void reply(@Nullable T var1);
    }

    private final class IncomingReplyHandler
    implements BinaryMessenger.BinaryReply {
        private final Reply<T> callback;

        private IncomingReplyHandler(Reply<T> callback) {
            this.callback = callback;
        }

        @Override
        public void reply(@Nullable ByteBuffer reply) {
            try {
                this.callback.reply(BasicMessageChannel.this.codec.decodeMessage(reply));
            }
            catch (RuntimeException e) {
                Log.e(BasicMessageChannel.TAG + BasicMessageChannel.this.name, "Failed to handle message reply", e);
            }
        }
    }

    private final class IncomingMessageHandler
    implements BinaryMessenger.BinaryMessageHandler {
        private final MessageHandler<T> handler;

        private IncomingMessageHandler(MessageHandler<T> handler) {
            this.handler = handler;
        }

        @Override
        public void onMessage(@Nullable ByteBuffer message, final @NonNull BinaryMessenger.BinaryReply callback) {
            try {
                this.handler.onMessage(BasicMessageChannel.this.codec.decodeMessage(message), new Reply<T>(){

                    @Override
                    public void reply(T reply) {
                        callback.reply(BasicMessageChannel.this.codec.encodeMessage(reply));
                    }
                });
            }
            catch (RuntimeException e) {
                Log.e(BasicMessageChannel.TAG + BasicMessageChannel.this.name, "Failed to handle message", e);
                callback.reply(null);
            }
        }
    }

    public static interface MessageHandler<T> {
        public void onMessage(@Nullable T var1, @NonNull Reply<T> var2);
    }
}

