// Copyright (c) 2020, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

@Tags(['daily'])
@TestOn('vm')
@Timeout(Duration(minutes: 2))

import 'package:test/test.dart';
import 'package:test_common/test_sdk_configuration.dart';

import '../fixtures/context.dart';
import '../fixtures/project.dart';
import 'common/instance_inspection_common.dart';

void main() {
  // Enable verbose logging for debugging.
  final debug = false;
  final canaryFeatures = false;

  group('canary: $canaryFeatures |', () {
    final provider = TestSdkConfigurationProvider(
      verbose: debug,
      canaryFeatures: canaryFeatures,
    );
    tearDownAll(provider.dispose);

    for (var compilationMode in CompilationMode.values) {
      for (var nullSafetyMode in NullSafety.values) {
        runTests(
          provider: provider,
          compilationMode: compilationMode,
          nullSafetyMode: nullSafetyMode,
          canaryFeatures: canaryFeatures,
          debug: debug,
        );
      }
    }
  });
}
