; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s --mattr=+sve2 -o - | FileCheck %s

target triple = "aarch64-arm-none-eabi"

; Expected to transform
define <vscale x 2 x i64> @complex_mul_v2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: complex_mul_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.d, #0 // =0x0
; CHECK-NEXT:    cmla z2.d, z1.d, z0.d, #0
; CHECK-NEXT:    cmla z2.d, z1.d, z0.d, #90
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 1 x i64>, <vscale x 1 x i64> } @llvm.experimental.vector.deinterleave2.nxv2i64(<vscale x 2 x i64> %a)
  %a.real = extractvalue { <vscale x 1 x i64>, <vscale x 1 x i64> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 1 x i64>, <vscale x 1 x i64> } %a.deinterleaved, 1
  %b.deinterleaved = tail call { <vscale x 1 x i64>, <vscale x 1 x i64> } @llvm.experimental.vector.deinterleave2.nxv2i64(<vscale x 2 x i64> %b)
  %b.real = extractvalue { <vscale x 1 x i64>, <vscale x 1 x i64> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 1 x i64>, <vscale x 1 x i64> } %b.deinterleaved, 1
  %0 = mul <vscale x 1 x i64> %b.imag, %a.real
  %1 = mul <vscale x 1 x i64> %b.real, %a.imag
  %2 = add <vscale x 1 x i64> %1, %0
  %3 = mul <vscale x 1 x i64> %b.real, %a.real
  %4 = mul <vscale x 1 x i64> %a.imag, %b.imag
  %5 = sub <vscale x 1 x i64> %3, %4
  %interleaved.vec = tail call <vscale x 2 x i64> @llvm.experimental.vector.interleave2.nxv2i64(<vscale x 1 x i64> %5, <vscale x 1 x i64> %2)
  ret <vscale x 2 x i64> %interleaved.vec
}

; Expected to transform
define <vscale x 4 x i64> @complex_mul_v4i64(<vscale x 4 x i64> %a, <vscale x 4 x i64> %b) {
; CHECK-LABEL: complex_mul_v4i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z4.d, #0 // =0x0
; CHECK-NEXT:    mov z5.d, z4.d
; CHECK-NEXT:    cmla z4.d, z3.d, z1.d, #0
; CHECK-NEXT:    cmla z5.d, z2.d, z0.d, #0
; CHECK-NEXT:    cmla z4.d, z3.d, z1.d, #90
; CHECK-NEXT:    cmla z5.d, z2.d, z0.d, #90
; CHECK-NEXT:    mov z1.d, z4.d
; CHECK-NEXT:    mov z0.d, z5.d
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 2 x i64>, <vscale x 2 x i64> } @llvm.experimental.vector.deinterleave2.nxv4i64(<vscale x 4 x i64> %a)
  %a.real = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64> } %a.deinterleaved, 1
  %b.deinterleaved = tail call { <vscale x 2 x i64>, <vscale x 2 x i64> } @llvm.experimental.vector.deinterleave2.nxv4i64(<vscale x 4 x i64> %b)
  %b.real = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64> } %b.deinterleaved, 1
  %0 = mul <vscale x 2 x i64> %b.imag, %a.real
  %1 = mul <vscale x 2 x i64> %b.real, %a.imag
  %2 = add <vscale x 2 x i64> %1, %0
  %3 = mul <vscale x 2 x i64> %b.real, %a.real
  %4 = mul <vscale x 2 x i64> %a.imag, %b.imag
  %5 = sub <vscale x 2 x i64> %3, %4
  %interleaved.vec = tail call <vscale x 4 x i64> @llvm.experimental.vector.interleave2.nxv4i64(<vscale x 2 x i64> %5, <vscale x 2 x i64> %2)
  ret <vscale x 4 x i64> %interleaved.vec
}

; Expected to transform
define <vscale x 8 x i64> @complex_mul_v8i64(<vscale x 8 x i64> %a, <vscale x 8 x i64> %b) {
; CHECK-LABEL: complex_mul_v8i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z24.d, #0 // =0x0
; CHECK-NEXT:    mov z25.d, z24.d
; CHECK-NEXT:    mov z26.d, z24.d
; CHECK-NEXT:    mov z27.d, z24.d
; CHECK-NEXT:    cmla z24.d, z7.d, z3.d, #0
; CHECK-NEXT:    cmla z25.d, z4.d, z0.d, #0
; CHECK-NEXT:    cmla z26.d, z5.d, z1.d, #0
; CHECK-NEXT:    cmla z27.d, z6.d, z2.d, #0
; CHECK-NEXT:    cmla z24.d, z7.d, z3.d, #90
; CHECK-NEXT:    cmla z25.d, z4.d, z0.d, #90
; CHECK-NEXT:    cmla z26.d, z5.d, z1.d, #90
; CHECK-NEXT:    cmla z27.d, z6.d, z2.d, #90
; CHECK-NEXT:    mov z3.d, z24.d
; CHECK-NEXT:    mov z0.d, z25.d
; CHECK-NEXT:    mov z1.d, z26.d
; CHECK-NEXT:    mov z2.d, z27.d
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 4 x i64>, <vscale x 4 x i64> } @llvm.experimental.vector.deinterleave2.nxv8i64(<vscale x 8 x i64> %a)
  %a.real = extractvalue { <vscale x 4 x i64>, <vscale x 4 x i64> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 4 x i64>, <vscale x 4 x i64> } %a.deinterleaved, 1
  %b.deinterleaved = tail call { <vscale x 4 x i64>, <vscale x 4 x i64> } @llvm.experimental.vector.deinterleave2.nxv8i64(<vscale x 8 x i64> %b)
  %b.real = extractvalue { <vscale x 4 x i64>, <vscale x 4 x i64> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 4 x i64>, <vscale x 4 x i64> } %b.deinterleaved, 1
  %0 = mul <vscale x 4 x i64> %b.imag, %a.real
  %1 = mul <vscale x 4 x i64> %b.real, %a.imag
  %2 = add <vscale x 4 x i64> %1, %0
  %3 = mul <vscale x 4 x i64> %b.real, %a.real
  %4 = mul <vscale x 4 x i64> %a.imag, %b.imag
  %5 = sub <vscale x 4 x i64> %3, %4
  %interleaved.vec = tail call <vscale x 8 x i64> @llvm.experimental.vector.interleave2.nxv8i64(<vscale x 4 x i64> %5, <vscale x 4 x i64> %2)
  ret <vscale x 8 x i64> %interleaved.vec
}

; Expected to transform
define <vscale x 8 x i64> @complex_minus_mul_v8i64(<vscale x 8 x i64> %a, <vscale x 8 x i64> %b) {
; CHECK-LABEL: complex_minus_mul_v8i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z24.d, #0 // =0x0
; CHECK-NEXT:    mov z25.d, z24.d
; CHECK-NEXT:    mov z26.d, z24.d
; CHECK-NEXT:    mov z27.d, z24.d
; CHECK-NEXT:    cmla z24.d, z7.d, z3.d, #270
; CHECK-NEXT:    cmla z25.d, z4.d, z0.d, #270
; CHECK-NEXT:    cmla z26.d, z5.d, z1.d, #270
; CHECK-NEXT:    cmla z27.d, z6.d, z2.d, #270
; CHECK-NEXT:    cmla z24.d, z7.d, z3.d, #180
; CHECK-NEXT:    cmla z25.d, z4.d, z0.d, #180
; CHECK-NEXT:    cmla z26.d, z5.d, z1.d, #180
; CHECK-NEXT:    cmla z27.d, z6.d, z2.d, #180
; CHECK-NEXT:    mov z3.d, z24.d
; CHECK-NEXT:    mov z0.d, z25.d
; CHECK-NEXT:    mov z1.d, z26.d
; CHECK-NEXT:    mov z2.d, z27.d
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 4 x i64>, <vscale x 4 x i64> } @llvm.experimental.vector.deinterleave2.nxv8i64(<vscale x 8 x i64> %a)
  %a.real = extractvalue { <vscale x 4 x i64>, <vscale x 4 x i64> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 4 x i64>, <vscale x 4 x i64> } %a.deinterleaved, 1
  %0 = sub <vscale x 4 x i64> zeroinitializer, %a.real
  %b.deinterleaved = tail call { <vscale x 4 x i64>, <vscale x 4 x i64> } @llvm.experimental.vector.deinterleave2.nxv8i64(<vscale x 8 x i64> %b)
  %b.real = extractvalue { <vscale x 4 x i64>, <vscale x 4 x i64> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 4 x i64>, <vscale x 4 x i64> } %b.deinterleaved, 1
  %1 = mul <vscale x 4 x i64> %b.real, %0
  %2 = mul <vscale x 4 x i64> %b.imag, %a.imag
  %3 = add <vscale x 4 x i64> %2, %1
  %4 = mul <vscale x 4 x i64> %b.real, %a.imag
  %5 = mul <vscale x 4 x i64> %b.imag, %0
  %6 = sub <vscale x 4 x i64> %5, %4
  %interleaved.vec = tail call <vscale x 8 x i64> @llvm.experimental.vector.interleave2.nxv8i64(<vscale x 4 x i64> %3, <vscale x 4 x i64> %6)
  ret <vscale x 8 x i64> %interleaved.vec
}

declare { <vscale x 1 x i64>, <vscale x 1 x i64> } @llvm.experimental.vector.deinterleave2.nxv2i64(<vscale x 2 x i64>)
declare <vscale x 2 x i64> @llvm.experimental.vector.interleave2.nxv2i64(<vscale x 1 x i64>, <vscale x 1 x i64>)

declare { <vscale x 2 x i64>, <vscale x 2 x i64> } @llvm.experimental.vector.deinterleave2.nxv4i64(<vscale x 4 x i64>)
declare <vscale x 4 x i64> @llvm.experimental.vector.interleave2.nxv4i64(<vscale x 2 x i64>, <vscale x 2 x i64>)

declare { <vscale x 4 x i64>, <vscale x 4 x i64> } @llvm.experimental.vector.deinterleave2.nxv8i64(<vscale x 8 x i64>)
declare <vscale x 8 x i64> @llvm.experimental.vector.interleave2.nxv8i64(<vscale x 4 x i64>, <vscale x 4 x i64>)
