;; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
;; Test that Octeon BBIT family of branch can be replaced by
;; the long branch expansion pass.

; RUN: llc -O3 -mtriple=mips64-octeon-linux -mcpu=octeon -force-mips-long-branch < %s -o - | FileCheck %s

define i64 @bbit1(i64 %a) nounwind {
; CHECK-LABEL: bbit1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bbit0 $4, 3, .LBB0_2
; CHECK-NEXT:    nop
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    j .LBB0_3
; CHECK-NEXT:    nop
; CHECK-NEXT:  .LBB0_2: # %endif
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    daddiu $2, $zero, 12
; CHECK-NEXT:  .LBB0_3: # %if
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    daddiu $2, $zero, 48
entry:
  %bit = and i64 %a, 8
  %res = icmp eq i64 %bit, 0
  br i1 %res, label %endif, label %if
if:
  ret i64 48

endif:
  ret i64 12
}

define i64 @bbit132(i64 %a) nounwind {
; CHECK-LABEL: bbit132:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bbit032 $4, 3, .LBB1_2
; CHECK-NEXT:    nop
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    j .LBB1_3
; CHECK-NEXT:    nop
; CHECK-NEXT:  .LBB1_2: # %endif
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    daddiu $2, $zero, 12
; CHECK-NEXT:  .LBB1_3: # %if
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    daddiu $2, $zero, 48
entry:
  %bit = and i64 %a, 34359738368
  %res = icmp eq i64 %bit, 0
  br i1 %res, label %endif, label %if
if:
  ret i64 48

endif:
  ret i64 12
}

define i64 @bbit0(i64 %a) nounwind {
; CHECK-LABEL: bbit0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bbit1 $4, 3, .LBB2_2
; CHECK-NEXT:    nop
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    j .LBB2_3
; CHECK-NEXT:    nop
; CHECK-NEXT:  .LBB2_2: # %endif
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    daddiu $2, $zero, 12
; CHECK-NEXT:  .LBB2_3: # %if
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    daddiu $2, $zero, 48
entry:
  %bit = and i64 %a, 8
  %res = icmp ne i64 %bit, 0
  br i1 %res, label %endif, label %if
if:
  ret i64 48

endif:
  ret i64 12
}

define i64 @bbit032(i64 %a) nounwind {
; CHECK-LABEL: bbit032:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bbit132 $4, 3, .LBB3_2
; CHECK-NEXT:    nop
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    j .LBB3_3
; CHECK-NEXT:    nop
; CHECK-NEXT:  .LBB3_2: # %endif
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    daddiu $2, $zero, 12
; CHECK-NEXT:  .LBB3_3: # %if
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    daddiu $2, $zero, 48
entry:
  %bit = and i64 %a, 34359738368
  %res = icmp ne i64 %bit, 0
  br i1 %res, label %endif, label %if
if:
  ret i64 48

endif:
  ret i64 12
}
