/* valasignal.c generated by valac, the Vala compiler
 * generated from valasignal.vala, do not modify */

/* valasignal.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaSignalPrivate {
	gboolean _is_virtual;
	ValaList* parameters;
	ValaMethod* _default_handler;
	ValaMethod* _emitter;
	ValaDataType* _return_type;
	ValaBlock* _body;
};

static gint ValaSignal_private_offset;
static gpointer vala_signal_parent_class = NULL;
static ValaCallableIface * vala_signal_vala_callable_parent_iface = NULL;

static void vala_signal_set_default_handler (ValaSignal* self,
                                      ValaMethod* value);
static void vala_signal_set_emitter (ValaSignal* self,
                              ValaMethod* value);
static void vala_signal_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_signal_real_get_parameters (ValaCallable* base);
static void vala_signal_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_signal_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_signal_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static gboolean vala_signal_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static void vala_signal_finalize (ValaCodeNode * obj);
static GType vala_signal_get_type_once (void);

static inline gpointer
vala_signal_get_instance_private (ValaSignal* self)
{
	return G_STRUCT_MEMBER_P (self, ValaSignal_private_offset);
}

static ValaDataType*
vala_signal_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaSignal* self;
	ValaDataType* _tmp0_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_signal_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaSignal* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaSignal*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaBlock*
vala_signal_get_body (ValaSignal* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

void
vala_signal_set_body (ValaSignal* self,
                      ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	if (_tmp1_ != NULL) {
		ValaBlock* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_body;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_signal_get_is_virtual (ValaSignal* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_signal_set_is_virtual (ValaSignal* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

ValaMethod*
vala_signal_get_default_handler (ValaSignal* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_handler;
	result = _tmp0_;
	return result;
}

static void
vala_signal_set_default_handler (ValaSignal* self,
                                 ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_handler);
	self->priv->_default_handler = _tmp0_;
}

ValaMethod*
vala_signal_get_emitter (ValaSignal* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_emitter;
	result = _tmp0_;
	return result;
}

static void
vala_signal_set_emitter (ValaSignal* self,
                         ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_emitter);
	self->priv->_emitter = _tmp0_;
}

/**
 * Creates a new signal.
 *
 * @param name              signal name
 * @param return_type       signal return type
 * @param source_reference  reference to source code
 * @return                  newly created signal
 */
ValaSignal*
vala_signal_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaSignal* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaSignal*) vala_symbol_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaSignal*
vala_signal_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_signal_construct (VALA_TYPE_SIGNAL, name, return_type, source_reference, comment);
}

/**
 * Appends parameter to signal handler.
 *
 * @param param a formal parameter
 */
static void
vala_signal_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaSignal * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaSignal*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static ValaList*
vala_signal_real_get_parameters (ValaCallable* base)
{
	ValaSignal * self;
	ValaList* _tmp0_;
	ValaList* result;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->parameters;
	result = _tmp0_;
	return result;
}

/**
 * Returns generated delegate to be used for signal handlers.
 *
 * @return delegate
 */
ValaDelegate*
vala_signal_get_delegate (ValaSignal* self,
                          ValaDataType* sender_type,
                          ValaCodeNode* node_reference)
{
	ValaDataType* actual_return_type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDelegate* generated_delegate = NULL;
	ValaDataType* _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaDelegate* _tmp6_;
	ValaDelegate* _tmp7_;
	ValaDelegate* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	ValaDataType* sender_param_type = NULL;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDelegate* _tmp14_;
	ValaDataType* _tmp15_;
	gboolean is_generic = FALSE;
	ValaDataType* _tmp16_;
	ValaScope* _tmp107_;
	ValaScope* _tmp108_;
	ValaDelegate* _tmp109_;
	ValaDelegate* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sender_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_data_type_get_actual_type (_tmp1_, sender_type, NULL, node_reference);
	actual_return_type = _tmp2_;
	_tmp3_ = actual_return_type;
	_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_delegate_new (NULL, _tmp3_, _tmp5_, NULL);
	generated_delegate = _tmp6_;
	_tmp7_ = generated_delegate;
	vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp8_ = generated_delegate;
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp8_, _tmp10_);
	_tmp11_ = vala_data_type_copy (sender_type);
	sender_param_type = _tmp11_;
	_tmp12_ = sender_param_type;
	vala_data_type_set_value_owned (_tmp12_, FALSE);
	_tmp13_ = sender_param_type;
	vala_data_type_set_nullable (_tmp13_, FALSE);
	_tmp14_ = generated_delegate;
	_tmp15_ = sender_param_type;
	vala_delegate_set_sender_type (_tmp14_, _tmp15_);
	_tmp16_ = actual_return_type;
	is_generic = vala_data_type_is_generic (_tmp16_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp17_;
		gint _param_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _param_index = 0;
		_tmp17_ = self->priv->parameters;
		_param_list = _tmp17_;
		_tmp18_ = _param_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_param_size = _tmp20_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaParameter* param = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaParameter* actual_param = NULL;
			ValaParameter* _tmp25_;
			ValaParameter* _tmp26_;
			ValaParameter* _tmp27_;
			ValaParameter* _tmp28_;
			ValaDataType* _tmp29_;
			ValaDataType* _tmp30_;
			ValaDataType* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDelegate* _tmp33_;
			ValaParameter* _tmp34_;
			ValaParameter* _tmp35_;
			ValaDataType* _tmp36_;
			ValaDataType* _tmp37_;
			_param_index = _param_index + 1;
			_tmp21_ = _param_index;
			_tmp22_ = _param_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _param_list;
			_tmp24_ = vala_list_get (_tmp23_, _param_index);
			param = (ValaParameter*) _tmp24_;
			_tmp25_ = param;
			_tmp26_ = vala_parameter_copy (_tmp25_);
			actual_param = _tmp26_;
			_tmp27_ = actual_param;
			_tmp28_ = actual_param;
			_tmp29_ = vala_variable_get_variable_type ((ValaVariable*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_data_type_get_actual_type (_tmp30_, sender_type, NULL, node_reference);
			_tmp32_ = _tmp31_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp27_, _tmp32_);
			_vala_code_node_unref0 (_tmp32_);
			_tmp33_ = generated_delegate;
			_tmp34_ = actual_param;
			vala_callable_add_parameter ((ValaCallable*) _tmp33_, _tmp34_);
			_tmp35_ = actual_param;
			_tmp36_ = vala_variable_get_variable_type ((ValaVariable*) _tmp35_);
			_tmp37_ = _tmp36_;
			if (vala_data_type_is_generic (_tmp37_)) {
				is_generic = TRUE;
			}
			_vala_code_node_unref0 (actual_param);
			_vala_code_node_unref0 (param);
		}
	}
	if (is_generic) {
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp38_;
		ValaSymbol* _tmp39_;
		_tmp38_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp39_ = _tmp38_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
		{
			ValaList* _type_param_list = NULL;
			ValaObjectTypeSymbol* _tmp40_;
			ValaList* _tmp41_;
			gint _type_param_size = 0;
			ValaList* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			gint _type_param_index = 0;
			_tmp40_ = cl;
			_tmp41_ = vala_object_type_symbol_get_type_parameters (_tmp40_);
			_type_param_list = _tmp41_;
			_tmp42_ = _type_param_list;
			_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
			_tmp44_ = _tmp43_;
			_type_param_size = _tmp44_;
			_type_param_index = -1;
			while (TRUE) {
				gint _tmp45_;
				gint _tmp46_;
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp47_;
				gpointer _tmp48_;
				ValaDelegate* _tmp49_;
				ValaTypeParameter* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				ValaTypeParameter* _tmp53_;
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				ValaTypeParameter* _tmp56_;
				ValaTypeParameter* _tmp57_;
				_type_param_index = _type_param_index + 1;
				_tmp45_ = _type_param_index;
				_tmp46_ = _type_param_size;
				if (!(_tmp45_ < _tmp46_)) {
					break;
				}
				_tmp47_ = _type_param_list;
				_tmp48_ = vala_list_get (_tmp47_, _type_param_index);
				type_param = (ValaTypeParameter*) _tmp48_;
				_tmp49_ = generated_delegate;
				_tmp50_ = type_param;
				_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = type_param;
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = vala_typeparameter_new (_tmp52_, _tmp55_);
				_tmp57_ = _tmp56_;
				vala_delegate_add_type_parameter (_tmp49_, _tmp57_);
				_vala_code_node_unref0 (_tmp57_);
				_vala_code_node_unref0 (type_param);
			}
		}
		{
			ValaList* _type_param_list = NULL;
			ValaDelegate* _tmp58_;
			ValaList* _tmp59_;
			gint _type_param_size = 0;
			ValaList* _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			gint _type_param_index = 0;
			_tmp58_ = generated_delegate;
			_tmp59_ = vala_delegate_get_type_parameters (_tmp58_);
			_type_param_list = _tmp59_;
			_tmp60_ = _type_param_list;
			_tmp61_ = vala_collection_get_size ((ValaCollection*) _tmp60_);
			_tmp62_ = _tmp61_;
			_type_param_size = _tmp62_;
			_type_param_index = -1;
			while (TRUE) {
				gint _tmp63_;
				gint _tmp64_;
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp65_;
				gpointer _tmp66_;
				ValaDataType* _tmp67_;
				ValaObjectTypeSymbol* _tmp68_;
				ValaList* _tmp69_;
				ValaObjectTypeSymbol* _tmp70_;
				ValaTypeParameter* _tmp71_;
				const gchar* _tmp72_;
				const gchar* _tmp73_;
				gpointer _tmp74_;
				ValaTypeParameter* _tmp75_;
				ValaTypeParameter* _tmp76_;
				_type_param_index = _type_param_index + 1;
				_tmp63_ = _type_param_index;
				_tmp64_ = _type_param_size;
				if (!(_tmp63_ < _tmp64_)) {
					break;
				}
				_tmp65_ = _type_param_list;
				_tmp66_ = vala_list_get (_tmp65_, _type_param_index);
				type_param = (ValaTypeParameter*) _tmp66_;
				_tmp67_ = actual_return_type;
				_tmp68_ = cl;
				_tmp69_ = vala_object_type_symbol_get_type_parameters (_tmp68_);
				_tmp70_ = cl;
				_tmp71_ = type_param;
				_tmp72_ = vala_symbol_get_name ((ValaSymbol*) _tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_list_get (_tmp69_, vala_typesymbol_get_type_parameter_index ((ValaTypeSymbol*) _tmp70_, _tmp73_));
				_tmp75_ = (ValaTypeParameter*) _tmp74_;
				_tmp76_ = type_param;
				vala_data_type_replace_type_parameter (_tmp67_, _tmp75_, _tmp76_);
				_vala_code_node_unref0 (_tmp75_);
				_vala_code_node_unref0 (type_param);
			}
		}
		{
			ValaList* _param_list = NULL;
			ValaDelegate* _tmp77_;
			ValaList* _tmp78_;
			gint _param_size = 0;
			ValaList* _tmp79_;
			gint _tmp80_;
			gint _tmp81_;
			gint _param_index = 0;
			_tmp77_ = generated_delegate;
			_tmp78_ = vala_callable_get_parameters ((ValaCallable*) _tmp77_);
			_param_list = _tmp78_;
			_tmp79_ = _param_list;
			_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
			_tmp81_ = _tmp80_;
			_param_size = _tmp81_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp82_;
				gint _tmp83_;
				ValaParameter* param = NULL;
				ValaList* _tmp84_;
				gpointer _tmp85_;
				_param_index = _param_index + 1;
				_tmp82_ = _param_index;
				_tmp83_ = _param_size;
				if (!(_tmp82_ < _tmp83_)) {
					break;
				}
				_tmp84_ = _param_list;
				_tmp85_ = vala_list_get (_tmp84_, _param_index);
				param = (ValaParameter*) _tmp85_;
				{
					ValaList* _type_param_list = NULL;
					ValaDelegate* _tmp86_;
					ValaList* _tmp87_;
					gint _type_param_size = 0;
					ValaList* _tmp88_;
					gint _tmp89_;
					gint _tmp90_;
					gint _type_param_index = 0;
					_tmp86_ = generated_delegate;
					_tmp87_ = vala_delegate_get_type_parameters (_tmp86_);
					_type_param_list = _tmp87_;
					_tmp88_ = _type_param_list;
					_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
					_tmp90_ = _tmp89_;
					_type_param_size = _tmp90_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp91_;
						gint _tmp92_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp93_;
						gpointer _tmp94_;
						ValaParameter* _tmp95_;
						ValaDataType* _tmp96_;
						ValaDataType* _tmp97_;
						ValaObjectTypeSymbol* _tmp98_;
						ValaList* _tmp99_;
						ValaObjectTypeSymbol* _tmp100_;
						ValaTypeParameter* _tmp101_;
						const gchar* _tmp102_;
						const gchar* _tmp103_;
						gpointer _tmp104_;
						ValaTypeParameter* _tmp105_;
						ValaTypeParameter* _tmp106_;
						_type_param_index = _type_param_index + 1;
						_tmp91_ = _type_param_index;
						_tmp92_ = _type_param_size;
						if (!(_tmp91_ < _tmp92_)) {
							break;
						}
						_tmp93_ = _type_param_list;
						_tmp94_ = vala_list_get (_tmp93_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp94_;
						_tmp95_ = param;
						_tmp96_ = vala_variable_get_variable_type ((ValaVariable*) _tmp95_);
						_tmp97_ = _tmp96_;
						_tmp98_ = cl;
						_tmp99_ = vala_object_type_symbol_get_type_parameters (_tmp98_);
						_tmp100_ = cl;
						_tmp101_ = type_param;
						_tmp102_ = vala_symbol_get_name ((ValaSymbol*) _tmp101_);
						_tmp103_ = _tmp102_;
						_tmp104_ = vala_list_get (_tmp99_, vala_typesymbol_get_type_parameter_index ((ValaTypeSymbol*) _tmp100_, _tmp103_));
						_tmp105_ = (ValaTypeParameter*) _tmp104_;
						_tmp106_ = type_param;
						vala_data_type_replace_type_parameter (_tmp97_, _tmp105_, _tmp106_);
						_vala_code_node_unref0 (_tmp105_);
						_vala_code_node_unref0 (type_param);
					}
				}
				_vala_code_node_unref0 (param);
			}
		}
	}
	_tmp107_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp108_ = _tmp107_;
	_tmp109_ = generated_delegate;
	vala_scope_add (_tmp108_, NULL, (ValaSymbol*) _tmp109_);
	result = generated_delegate;
	_vala_code_node_unref0 (sender_param_type);
	_vala_code_node_unref0 (actual_return_type);
	return result;
}

static void
vala_signal_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaSignal * self;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_signal (visitor, self);
}

static void
vala_signal_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean _tmp11_ = FALSE;
	ValaMethod* _tmp12_;
	ValaMethod* _tmp19_;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp2_;
		gint _param_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _param_index = 0;
		_tmp2_ = self->priv->parameters;
		_param_list = _tmp2_;
		_tmp3_ = _param_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_param_size = _tmp5_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			_param_index = _param_index + 1;
			_tmp6_ = _param_index;
			_tmp7_ = _param_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = vala_list_get (_tmp8_, _param_index);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (param);
		}
	}
	_tmp12_ = self->priv->_default_handler;
	if (_tmp12_ == NULL) {
		ValaBlock* _tmp13_;
		ValaBlock* _tmp14_;
		_tmp13_ = vala_signal_get_body (self);
		_tmp14_ = _tmp13_;
		_tmp11_ = _tmp14_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaBlock* _tmp15_;
		ValaBlock* _tmp16_;
		_tmp15_ = vala_signal_get_body (self);
		_tmp16_ = _tmp15_;
		vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
	} else {
		ValaMethod* _tmp17_;
		_tmp17_ = self->priv->_default_handler;
		if (_tmp17_ != NULL) {
			ValaMethod* _tmp18_;
			_tmp18_ = self->priv->_default_handler;
			vala_code_node_accept ((ValaCodeNode*) _tmp18_, visitor);
		}
	}
	_tmp19_ = self->priv->_emitter;
	if (_tmp19_ != NULL) {
		ValaMethod* _tmp20_;
		_tmp20_ = self->priv->_emitter;
		vala_code_node_accept ((ValaCodeNode*) _tmp20_, visitor);
	}
}

static void
vala_signal_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaSignal*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
	}
}

static gboolean
vala_signal_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaSignal * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaClass* parent_cl = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaClass* _tmp7_;
	ValaClass* _tmp13_;
	ValaDataType* _tmp35_;
	ValaDataType* _tmp36_;
	ValaDataType* _tmp37_;
	ValaDataType* _tmp38_;
	ValaTypeSymbol* _tmp39_;
	ValaTypeSymbol* _tmp40_;
	ValaSemanticAnalyzer* _tmp41_;
	ValaSemanticAnalyzer* _tmp42_;
	ValaDataType* _tmp43_;
	ValaTypeSymbol* _tmp44_;
	ValaTypeSymbol* _tmp45_;
	gboolean _tmp69_ = FALSE;
	ValaBlock* _tmp70_;
	ValaBlock* _tmp71_;
	gboolean _tmp187_ = FALSE;
	gboolean _tmp188_ = FALSE;
	gboolean _tmp189_;
	gboolean _tmp190_;
	gboolean _tmp203_;
	gboolean _tmp204_;
	gboolean result;
	self = (ValaSignal*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	parent_cl = VALA_IS_CLASS (_tmp5_) ? ((ValaClass*) _tmp5_) : NULL;
	_tmp7_ = parent_cl;
	if (_tmp7_ != NULL) {
		ValaClass* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = parent_cl;
		_tmp9_ = vala_class_get_is_compact (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		vala_report_error (_tmp12_, "Signals are not supported in compact classes");
		result = FALSE;
		return result;
	}
	_tmp13_ = parent_cl;
	if (_tmp13_ != NULL) {
		{
			ValaList* _base_type_list = NULL;
			ValaClass* _tmp14_;
			ValaList* _tmp15_;
			gint _base_type_size = 0;
			ValaList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _base_type_index = 0;
			_tmp14_ = parent_cl;
			_tmp15_ = vala_class_get_base_types (_tmp14_);
			_base_type_list = _tmp15_;
			_tmp16_ = _base_type_list;
			_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_base_type_size = _tmp18_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp19_;
				gint _tmp20_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp21_;
				gpointer _tmp22_;
				ValaDataType* _tmp23_;
				ValaTypeSymbol* _tmp24_;
				ValaTypeSymbol* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				ValaSymbol* _tmp28_;
				ValaSymbol* _tmp29_;
				gboolean _tmp30_;
				_base_type_index = _base_type_index + 1;
				_tmp19_ = _base_type_index;
				_tmp20_ = _base_type_size;
				if (!(_tmp19_ < _tmp20_)) {
					break;
				}
				_tmp21_ = _base_type_list;
				_tmp22_ = vala_list_get (_tmp21_, _base_type_index);
				base_type = (ValaDataType*) _tmp22_;
				_tmp23_ = base_type;
				_tmp24_ = vala_data_type_get_type_symbol (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp25_, _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = VALA_IS_SIGNAL (_tmp29_);
				_vala_code_node_unref0 (_tmp29_);
				if (_tmp30_) {
					ValaSourceReference* _tmp31_;
					ValaSourceReference* _tmp32_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp32_ = _tmp31_;
					vala_report_error (_tmp32_, "Signals with the same name as a signal in a base type are not supporte" \
"d");
					result = FALSE;
					_vala_code_node_unref0 (base_type);
					return result;
				}
				_vala_code_node_unref0 (base_type);
			}
		}
	}
	if (VALA_IS_DYNAMIC_SIGNAL (self)) {
		gboolean _tmp33_;
		gboolean _tmp34_;
		_tmp33_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp34_ = _tmp33_;
		result = !_tmp34_;
		return result;
	}
	_tmp35_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp36_ = _tmp35_;
	vala_code_node_check ((ValaCodeNode*) _tmp36_, context);
	_tmp37_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_data_type_get_type_symbol (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_code_context_get_analyzer (context);
	_tmp42_ = _tmp41_;
	_tmp43_ = _tmp42_->va_list_type;
	_tmp44_ = vala_data_type_get_type_symbol (_tmp43_);
	_tmp45_ = _tmp44_;
	if (_tmp40_ == _tmp45_) {
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		ValaTypeSymbol* _tmp50_;
		ValaTypeSymbol* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_data_type_get_type_symbol (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp51_);
		_tmp53_ = _tmp52_;
		vala_report_error (_tmp47_, "`%s' not supported as return type", _tmp53_);
		_g_free0 (_tmp53_);
		result = FALSE;
		return result;
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp54_;
		gint _param_size = 0;
		ValaList* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		gint _param_index = 0;
		_tmp54_ = self->priv->parameters;
		_param_list = _tmp54_;
		_tmp55_ = _param_list;
		_tmp56_ = vala_collection_get_size ((ValaCollection*) _tmp55_);
		_tmp57_ = _tmp56_;
		_param_size = _tmp57_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp58_;
			gint _tmp59_;
			ValaParameter* param = NULL;
			ValaList* _tmp60_;
			gpointer _tmp61_;
			ValaParameter* _tmp62_;
			gboolean _tmp63_;
			gboolean _tmp64_;
			ValaParameter* _tmp68_;
			_param_index = _param_index + 1;
			_tmp58_ = _param_index;
			_tmp59_ = _param_size;
			if (!(_tmp58_ < _tmp59_)) {
				break;
			}
			_tmp60_ = _param_list;
			_tmp61_ = vala_list_get (_tmp60_, _param_index);
			param = (ValaParameter*) _tmp61_;
			_tmp62_ = param;
			_tmp63_ = vala_parameter_get_ellipsis (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_) {
				ValaParameter* _tmp65_;
				ValaSourceReference* _tmp66_;
				ValaSourceReference* _tmp67_;
				_tmp65_ = param;
				_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp65_);
				_tmp67_ = _tmp66_;
				vala_report_error (_tmp67_, "Signals with variable argument lists are not supported");
				result = FALSE;
				_vala_code_node_unref0 (param);
				return result;
			}
			_tmp68_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp68_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp70_ = vala_signal_get_body (self);
	_tmp71_ = _tmp70_;
	if (_tmp71_ != NULL) {
		_tmp69_ = TRUE;
	} else {
		gboolean _tmp72_ = FALSE;
		gboolean _tmp73_;
		_tmp73_ = self->priv->_is_virtual;
		if (_tmp73_) {
			gboolean _tmp74_;
			gboolean _tmp75_;
			_tmp74_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp75_ = _tmp74_;
			_tmp72_ = _tmp75_;
		} else {
			_tmp72_ = FALSE;
		}
		_tmp69_ = _tmp72_;
	}
	if (_tmp69_) {
		const gchar* _tmp76_;
		const gchar* _tmp77_;
		ValaDataType* _tmp78_;
		ValaDataType* _tmp79_;
		ValaSourceReference* _tmp80_;
		ValaSourceReference* _tmp81_;
		ValaMethod* _tmp82_;
		ValaMethod* _tmp83_;
		ValaMethod* _tmp84_;
		ValaScope* _tmp85_;
		ValaScope* _tmp86_;
		ValaSymbolAccessibility _tmp87_ = 0;
		gboolean _tmp88_;
		ValaMethod* _tmp91_;
		ValaMethod* _tmp92_;
		gboolean _tmp93_;
		gboolean _tmp94_;
		ValaMethod* _tmp95_;
		gboolean _tmp96_;
		gboolean _tmp97_;
		ValaMethod* _tmp98_;
		gboolean _tmp99_;
		ValaMethod* _tmp100_;
		ValaMethod* _tmp101_;
		ValaBlock* _tmp102_;
		ValaBlock* _tmp103_;
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp114_;
		ValaSymbol* _tmp115_;
		ValaObjectTypeSymbol* _tmp116_;
		ValaMethod* _tmp117_;
		ValaMethod* _tmp118_;
		_tmp76_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp81_ = _tmp80_;
		_tmp82_ = vala_method_new (_tmp77_, _tmp79_, _tmp81_, NULL);
		_tmp83_ = _tmp82_;
		vala_signal_set_default_handler (self, _tmp83_);
		_vala_code_node_unref0 (_tmp83_);
		_tmp84_ = self->priv->_default_handler;
		_tmp85_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp86_ = _tmp85_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp84_, _tmp86_);
		_tmp88_ = self->priv->_is_virtual;
		if (_tmp88_) {
			ValaSymbolAccessibility _tmp89_;
			ValaSymbolAccessibility _tmp90_;
			_tmp89_ = vala_symbol_get_access ((ValaSymbol*) self);
			_tmp90_ = _tmp89_;
			_tmp87_ = _tmp90_;
		} else {
			_tmp87_ = VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
		}
		_tmp91_ = self->priv->_default_handler;
		vala_symbol_set_access ((ValaSymbol*) _tmp91_, _tmp87_);
		_tmp92_ = self->priv->_default_handler;
		_tmp93_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp94_ = _tmp93_;
		vala_symbol_set_external ((ValaSymbol*) _tmp92_, _tmp94_);
		_tmp95_ = self->priv->_default_handler;
		_tmp96_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp97_ = _tmp96_;
		vala_symbol_set_hides ((ValaSymbol*) _tmp95_, _tmp97_);
		_tmp98_ = self->priv->_default_handler;
		_tmp99_ = self->priv->_is_virtual;
		vala_method_set_is_virtual (_tmp98_, _tmp99_);
		_tmp100_ = self->priv->_default_handler;
		vala_method_set_signal_reference (_tmp100_, self);
		_tmp101_ = self->priv->_default_handler;
		_tmp102_ = vala_signal_get_body (self);
		_tmp103_ = _tmp102_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp101_, _tmp103_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp104_;
			gint _param_size = 0;
			ValaList* _tmp105_;
			gint _tmp106_;
			gint _tmp107_;
			gint _param_index = 0;
			_tmp104_ = self->priv->parameters;
			_param_list = _tmp104_;
			_tmp105_ = _param_list;
			_tmp106_ = vala_collection_get_size ((ValaCollection*) _tmp105_);
			_tmp107_ = _tmp106_;
			_param_size = _tmp107_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp108_;
				gint _tmp109_;
				ValaParameter* param = NULL;
				ValaList* _tmp110_;
				gpointer _tmp111_;
				ValaMethod* _tmp112_;
				ValaParameter* _tmp113_;
				_param_index = _param_index + 1;
				_tmp108_ = _param_index;
				_tmp109_ = _param_size;
				if (!(_tmp108_ < _tmp109_)) {
					break;
				}
				_tmp110_ = _param_list;
				_tmp111_ = vala_list_get (_tmp110_, _param_index);
				param = (ValaParameter*) _tmp111_;
				_tmp112_ = self->priv->_default_handler;
				_tmp113_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp112_, _tmp113_);
				_vala_code_node_unref0 (param);
			}
		}
		_tmp114_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp115_ = _tmp114_;
		cl = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp115_) ? ((ValaObjectTypeSymbol*) _tmp115_) : NULL;
		_tmp116_ = cl;
		_tmp117_ = self->priv->_default_handler;
		vala_object_type_symbol_add_hidden_method (_tmp116_, _tmp117_);
		_tmp118_ = self->priv->_default_handler;
		vala_code_node_check ((ValaCodeNode*) _tmp118_, context);
	}
	if (vala_code_node_has_attribute ((ValaCodeNode*) self, "HasEmitter")) {
		const gchar* _tmp119_;
		const gchar* _tmp120_;
		ValaDataType* _tmp121_;
		ValaDataType* _tmp122_;
		ValaSourceReference* _tmp123_;
		ValaSourceReference* _tmp124_;
		ValaMethod* _tmp125_;
		ValaMethod* _tmp126_;
		ValaMethod* _tmp127_;
		ValaScope* _tmp128_;
		ValaScope* _tmp129_;
		ValaMethod* _tmp130_;
		ValaSymbolAccessibility _tmp131_;
		ValaSymbolAccessibility _tmp132_;
		ValaBlock* body = NULL;
		ValaSourceReference* _tmp133_;
		ValaSourceReference* _tmp134_;
		ValaBlock* _tmp135_;
		ValaMethodCall* call = NULL;
		const gchar* _tmp136_;
		const gchar* _tmp137_;
		ValaSourceReference* _tmp138_;
		ValaSourceReference* _tmp139_;
		ValaMemberAccess* _tmp140_;
		ValaMemberAccess* _tmp141_;
		ValaSourceReference* _tmp142_;
		ValaSourceReference* _tmp143_;
		ValaMethodCall* _tmp144_;
		ValaMethodCall* _tmp145_;
		ValaDataType* _tmp164_;
		ValaDataType* _tmp165_;
		ValaMethod* _tmp178_;
		ValaBlock* _tmp179_;
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp180_;
		ValaSymbol* _tmp181_;
		ValaObjectTypeSymbol* _tmp182_;
		ValaMethod* _tmp183_;
		gboolean _tmp184_;
		gboolean _tmp185_;
		_tmp119_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp124_ = _tmp123_;
		_tmp125_ = vala_method_new (_tmp120_, _tmp122_, _tmp124_, NULL);
		_tmp126_ = _tmp125_;
		vala_signal_set_emitter (self, _tmp126_);
		_vala_code_node_unref0 (_tmp126_);
		_tmp127_ = self->priv->_emitter;
		_tmp128_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp129_ = _tmp128_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp127_, _tmp129_);
		_tmp130_ = self->priv->_emitter;
		_tmp131_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp132_ = _tmp131_;
		vala_symbol_set_access ((ValaSymbol*) _tmp130_, _tmp132_);
		_tmp133_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp134_ = _tmp133_;
		_tmp135_ = vala_block_new (_tmp134_);
		body = _tmp135_;
		_tmp136_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp137_ = _tmp136_;
		_tmp138_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_member_access_new_simple (_tmp137_, _tmp139_);
		_tmp141_ = _tmp140_;
		_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_method_call_new ((ValaExpression*) _tmp141_, _tmp143_);
		_tmp145_ = _tmp144_;
		_vala_code_node_unref0 (_tmp141_);
		call = _tmp145_;
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp146_;
			gint _param_size = 0;
			ValaList* _tmp147_;
			gint _tmp148_;
			gint _tmp149_;
			gint _param_index = 0;
			_tmp146_ = self->priv->parameters;
			_param_list = _tmp146_;
			_tmp147_ = _param_list;
			_tmp148_ = vala_collection_get_size ((ValaCollection*) _tmp147_);
			_tmp149_ = _tmp148_;
			_param_size = _tmp149_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp150_;
				gint _tmp151_;
				ValaParameter* param = NULL;
				ValaList* _tmp152_;
				gpointer _tmp153_;
				ValaMethod* _tmp154_;
				ValaParameter* _tmp155_;
				ValaMethodCall* _tmp156_;
				ValaParameter* _tmp157_;
				const gchar* _tmp158_;
				const gchar* _tmp159_;
				ValaSourceReference* _tmp160_;
				ValaSourceReference* _tmp161_;
				ValaMemberAccess* _tmp162_;
				ValaMemberAccess* _tmp163_;
				_param_index = _param_index + 1;
				_tmp150_ = _param_index;
				_tmp151_ = _param_size;
				if (!(_tmp150_ < _tmp151_)) {
					break;
				}
				_tmp152_ = _param_list;
				_tmp153_ = vala_list_get (_tmp152_, _param_index);
				param = (ValaParameter*) _tmp153_;
				_tmp154_ = self->priv->_emitter;
				_tmp155_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp154_, _tmp155_);
				_tmp156_ = call;
				_tmp157_ = param;
				_tmp158_ = vala_symbol_get_name ((ValaSymbol*) _tmp157_);
				_tmp159_ = _tmp158_;
				_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_member_access_new_simple (_tmp159_, _tmp161_);
				_tmp163_ = _tmp162_;
				vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp156_, (ValaExpression*) _tmp163_);
				_vala_code_node_unref0 (_tmp163_);
				_vala_code_node_unref0 (param);
			}
		}
		_tmp164_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp165_ = _tmp164_;
		if (VALA_IS_VOID_TYPE (_tmp165_)) {
			ValaBlock* _tmp166_;
			ValaMethodCall* _tmp167_;
			ValaSourceReference* _tmp168_;
			ValaSourceReference* _tmp169_;
			ValaExpressionStatement* _tmp170_;
			ValaExpressionStatement* _tmp171_;
			_tmp166_ = body;
			_tmp167_ = call;
			_tmp168_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp169_ = _tmp168_;
			_tmp170_ = vala_expression_statement_new ((ValaExpression*) _tmp167_, _tmp169_);
			_tmp171_ = _tmp170_;
			vala_block_add_statement (_tmp166_, (ValaStatement*) _tmp171_);
			_vala_code_node_unref0 (_tmp171_);
		} else {
			ValaBlock* _tmp172_;
			ValaMethodCall* _tmp173_;
			ValaSourceReference* _tmp174_;
			ValaSourceReference* _tmp175_;
			ValaReturnStatement* _tmp176_;
			ValaReturnStatement* _tmp177_;
			_tmp172_ = body;
			_tmp173_ = call;
			_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp175_ = _tmp174_;
			_tmp176_ = vala_return_statement_new ((ValaExpression*) _tmp173_, _tmp175_);
			_tmp177_ = _tmp176_;
			vala_block_add_statement (_tmp172_, (ValaStatement*) _tmp177_);
			_vala_code_node_unref0 (_tmp177_);
		}
		_tmp178_ = self->priv->_emitter;
		_tmp179_ = body;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp178_, _tmp179_);
		_tmp180_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp181_ = _tmp180_;
		cl = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp181_) ? ((ValaObjectTypeSymbol*) _tmp181_) : NULL;
		_tmp182_ = cl;
		_tmp183_ = self->priv->_emitter;
		vala_object_type_symbol_add_hidden_method (_tmp182_, _tmp183_);
		_tmp184_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp185_ = _tmp184_;
		if (!_tmp185_) {
			ValaMethod* _tmp186_;
			_tmp186_ = self->priv->_emitter;
			vala_code_node_check ((ValaCodeNode*) _tmp186_, context);
		}
		_vala_code_node_unref0 (call);
		_vala_code_node_unref0 (body);
	}
	_tmp189_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp190_ = _tmp189_;
	if (!_tmp190_) {
		gboolean _tmp191_;
		gboolean _tmp192_;
		_tmp191_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp192_ = _tmp191_;
		_tmp188_ = !_tmp192_;
	} else {
		_tmp188_ = FALSE;
	}
	if (_tmp188_) {
		ValaSymbol* _tmp193_;
		ValaSymbol* _tmp194_;
		_tmp193_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp194_ = _tmp193_;
		_tmp187_ = _tmp194_ != NULL;
		_vala_code_node_unref0 (_tmp194_);
	} else {
		_tmp187_ = FALSE;
	}
	if (_tmp187_) {
		ValaSourceReference* _tmp195_;
		ValaSourceReference* _tmp196_;
		gchar* _tmp197_;
		gchar* _tmp198_;
		ValaSymbol* _tmp199_;
		ValaSymbol* _tmp200_;
		gchar* _tmp201_;
		gchar* _tmp202_;
		_tmp195_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp196_ = _tmp195_;
		_tmp197_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp198_ = _tmp197_;
		_tmp199_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp200_ = _tmp199_;
		_tmp201_ = vala_symbol_get_full_name (_tmp200_);
		_tmp202_ = _tmp201_;
		vala_report_warning (_tmp196_, "%s hides inherited signal `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp198_, _tmp202_);
		_g_free0 (_tmp202_);
		_vala_code_node_unref0 (_tmp200_);
		_g_free0 (_tmp198_);
	}
	_tmp203_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp204_ = _tmp203_;
	result = !_tmp204_;
	return result;
}

static void
vala_signal_class_init (ValaSignalClass * klass,
                        gpointer klass_data)
{
	vala_signal_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_signal_finalize;
	g_type_class_adjust_private_offset (klass, &ValaSignal_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_signal_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_signal_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_signal_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_signal_real_check;
}

static void
vala_signal_vala_callable_interface_init (ValaCallableIface * iface,
                                          gpointer iface_data)
{
	vala_signal_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_signal_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_signal_real_get_parameters;
	iface->get_return_type = vala_signal_real_get_return_type;
	iface->set_return_type = vala_signal_real_set_return_type;
}

static void
vala_signal_instance_init (ValaSignal * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_signal_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_signal_finalize (ValaCodeNode * obj)
{
	ValaSignal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SIGNAL, ValaSignal);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_code_node_unref0 (self->priv->_default_handler);
	_vala_code_node_unref0 (self->priv->_emitter);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_signal_parent_class)->finalize (obj);
}

/**
 * Represents an object signal. Signals enable objects to provide notifications.
 */
static GType
vala_signal_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaSignalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_signal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSignal), 0, (GInstanceInitFunc) vala_signal_instance_init, NULL };
	static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_signal_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_signal_type_id;
	vala_signal_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaSignal", &g_define_type_info, 0);
	g_type_add_interface_static (vala_signal_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
	ValaSignal_private_offset = g_type_add_instance_private (vala_signal_type_id, sizeof (ValaSignalPrivate));
	return vala_signal_type_id;
}

GType
vala_signal_get_type (void)
{
	static volatile gsize vala_signal_type_id__once = 0;
	if (g_once_init_enter (&vala_signal_type_id__once)) {
		GType vala_signal_type_id;
		vala_signal_type_id = vala_signal_get_type_once ();
		g_once_init_leave (&vala_signal_type_id__once, vala_signal_type_id);
	}
	return vala_signal_type_id__once;
}

