
include ("${RunCMake_SOURCE_DIR}/check_errors.cmake")
unset (errors)

cmake_path(CONVERT "/x/y/z/../../a/d" TO_CMAKE_PATH_LIST output)
if (NOT output STREQUAL "/x/y/z/../../a/d")
  list (APPEND errors "TO_CMAKE_PATH_LIST: '${output}' instead of '/x/y/z/../../a/d'")
endif()
cmake_path(CONVERT "/x/y/z/../../a/d" TO_CMAKE_PATH_LIST output NORMALIZE)
if (NOT output STREQUAL "/x/a/d")
  list (APPEND errors "TO_CMAKE_PATH_LIST: '${output}' instead of '/x/a/d'")
endif()

if (WIN32)
  cmake_path(CONVERT "/x\\y/z\\..\\../a/d" TO_CMAKE_PATH_LIST output)
  if (NOT output STREQUAL "/x/y/z/../../a/d")
    list (APPEND errors "TO_CMAKE_PATH_LIST: '${output}' instead of '/x/y/z/../../a/d'")
  endif()
  cmake_path(CONVERT "/x\\y/z\\..\\../a/d" TO_CMAKE_PATH_LIST output NORMALIZE)
  if (NOT output STREQUAL "/x/a/d")
    list (APPEND errors "TO_CMAKE_PATH_LIST: '${output}' instead of '/x/a/d'")
  endif()

  cmake_path(CONVERT "//?/c:/x\\y/z\\..\\../a/d" TO_CMAKE_PATH_LIST output)
  if (NOT output STREQUAL "c:/x/y/z/../../a/d")
    list (APPEND errors "TO_CMAKE_PATH_LIST: '${output}' instead of 'c:/x/y/z/../../a/d'")
  endif()
  cmake_path(CONVERT "//?/c:/x\\y/z\\..\\../a/d" TO_CMAKE_PATH_LIST output NORMALIZE)
  if (NOT output STREQUAL "c:/x/a/d")
    list (APPEND errors "TO_CMAKE_PATH_LIST: '${output}' instead of 'c:/x/a/d'")
  endif()

  cmake_path(CONVERT "//?/UNC/host/x\\y/z\\..\\../a/d" TO_CMAKE_PATH_LIST output)
  if (NOT output STREQUAL "//host/x/y/z/../../a/d")
    list (APPEND errors "TO_CMAKE_PATH_LIST: '${output}' instead of '//host/x/y/z/../../a/d'")
  endif()
  cmake_path(CONVERT "//?/UNC/host/x\\y/z\\..\\../a/d" TO_CMAKE_PATH_LIST output NORMALIZE)
  if (NOT output STREQUAL "//host/x/a/d")
    list (APPEND errors "TO_CMAKE_PATH_LIST: '${output}' instead of '//host/x/a/d'")
  endif()
endif()

if (WIN32)
  cmake_path(CONVERT "/x\\y/z/..\\../a\\d;c:\\a/b\\c/..\\d" TO_CMAKE_PATH_LIST output)
  if (NOT output STREQUAL "/x/y/z/../../a/d;c:/a/b/c/../d")
    list (APPEND errors "TO_CMAKE_PATH_LIST: '${output}' instead of '/x/y/z/../../a/d;c:/a/b/c/../d'")
  endif()
  cmake_path(CONVERT "/x\\y/z/..\\../a\\d;c:\\a/b\\c/..\\d" TO_CMAKE_PATH_LIST output NORMALIZE)
  if (NOT output STREQUAL "/x/a/d;c:/a/b/d")
    list (APPEND errors "TO_CMAKE_PATH_LIST: '${output}' instead of '/x/a/d;c:/a/b/d'")
  endif()
else()
  cmake_path(CONVERT "/x/y/z/../../a/d:/a/b/c/../d" TO_CMAKE_PATH_LIST output)
  if (NOT output STREQUAL "/x/y/z/../../a/d;/a/b/c/../d")
    list (APPEND errors "TO_CMAKE_PATH_LIST: '${outputh}' instead of '/x/y/z/../../a/d;/a/b/c/../d'")
  endif()
  cmake_path(CONVERT "/x/y/z/../../a/d:/a/b/c/../d" TO_CMAKE_PATH_LIST output NORMALIZE)
  if (NOT output STREQUAL "/x/a/d;/a/b/d")
    list (APPEND errors "TO_CMAKE_PATH_LIST: '${output}' instead of '/x/a/d;/a/b/d'")
  endif()
endif()


if (WIN32)
  cmake_path(CONVERT "c:/a//b\\c/..\\d" TO_NATIVE_PATH_LIST output)
  if (NOT output STREQUAL "c:\\a\\\\b\\c\\..\\d")
    list (APPEND errors "TO_NATIVE_PATH_LIST: '${output}' instead of 'c:\\a\\\\b\\c\\..\\d'")
  endif()
  cmake_path(CONVERT "c:/a//b\\c/..\\d" TO_NATIVE_PATH_LIST output NORMALIZE)
  if (NOT output STREQUAL "c:\\a\\b\\d")
    list (APPEND errors "TO_NATIVE_PATH_LIST: '${output}' instead of 'c:\\a\\b\\d'")
  endif()

  cmake_path(CONVERT "//host/a//b\\c/..\\d" TO_NATIVE_PATH_LIST output)
  if (NOT output STREQUAL "\\\\host\\a\\\\b\\c\\..\\d")
    list (APPEND errors "TO_NATIVE_PATH_LIST: '${output}' instead of '\\\\host\\a\\\\b\\c\\..\\d'")
  endif()
  cmake_path(CONVERT "//host/a//b\\c/..\\d" TO_NATIVE_PATH_LIST output NORMALIZE)
  if (NOT output STREQUAL "\\\\host\\a\\b\\d")
    list (APPEND errors "TO_NATIVE_PATH_LIST: '${output}' instead of '\\\\host\\a\\b\\d'")
  endif()
  cmake_path(CONVERT "//host/a//b\\c/..\\d;c:/a//b\\c/..\\d" TO_NATIVE_PATH_LIST output)
  if (NOT output STREQUAL "\\\\host\\a\\\\b\\c\\..\\d;c:\\a\\\\b\\c\\..\\d")
    list (APPEND errors "TO_NATIVE_PATH_LIST: '${output}' instead of '\\\\host\\a\\\\b\\c\\..\\d;c:\\a\\\\b\\c\\..\\d'")
  endif()
  cmake_path(CONVERT "//host/a//b\\c/..\\d;c:/a//b\\c/..\\d" TO_NATIVE_PATH_LIST output NORMALIZE)
  if (NOT output STREQUAL "\\\\host\\a\\b\\d;c:\\a\\b\\d")
    list (APPEND errors "TO_NATIVE_PATH_LIST: '${output}' instead of '\\\\host\\a\\b\\d;c:\\a\\b\\d'")
  endif()
else()
  cmake_path(CONVERT "/a//b/c/../d" TO_NATIVE_PATH_LIST output)
  if (NOT output STREQUAL "/a//b/c/../d")
    list (APPEND errors "TO_NATIVE_PATH_LIST: '${output}' instead of '/a//b/c/../d'")
  endif()
  cmake_path(CONVERT "/a//b/c/../d" TO_NATIVE_PATH_LIST output NORMALIZE)
  if (NOT output STREQUAL "/a/b/d")
    list (APPEND errors "TO_NATIVE_PATH_LIST: '${output}' instead of '/a/b/d'")
  endif()
  cmake_path(CONVERT "/x/y/z/../../a/d;/a/b/c/../d" TO_NATIVE_PATH_LIST output)
  if (NOT output STREQUAL "/x/y/z/../../a/d:/a/b/c/../d")
    list (APPEND errors "TO_NATIVE_PATH_LIST: '${output}' instead of '/x/y/z/../../a/d:/a/b/c/../d'")
  endif()
  cmake_path(CONVERT "/x/y/z/../../a/d;/a/b/c/../d" TO_NATIVE_PATH_LIST output NORMALIZE)
  if (NOT output STREQUAL "/x/a/d:/a/b/d")
    list (APPEND errors "TO_NATIVE_PATH_LIST: '${output}' instead of '/x/a/d:/a/b/d'")
  endif()
endif()


check_errors (CONVERT ${errors})
