// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v10.1.6), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#undef _HAS_EXCEPTIONS

#include "messages.h"

#include <flutter/basic_message_channel.h>
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/method_call.h>
#include <flutter/method_channel.h>
#include <flutter/standard_method_codec.h>

#include <filesystem>
#include <optional>
#include <string>

#include "plugins/common/common.h"

namespace plugin_file_selector {

static constexpr char kMethodOpenFile[] = "openFile";
static constexpr char kGetSavePath[] = "getSavePath";
static constexpr char kGetDirectoryPath[] = "getDirectoryPath";

static constexpr char kArgInitialDirectory[] = "initialDirectory";
static constexpr char kArgConfirmButtonText[] = "confirmButtonText";
static constexpr char kArgAcceptedTypeGroups[] = "acceptedTypeGroups";

static constexpr char kArgTypeGroupLabel[] = "label";
static constexpr char kArgTypeGroupExtensions[] = "extensions";
// TODO static constexpr char kArgTypeGroupMime[] = "mimeTypes";
static constexpr char kArgMultiple[] = "multiple";
static constexpr char kArgSuggestedName[] = "suggestedName";

using flutter::BasicMessageChannel;
using flutter::CustomEncodableValue;
using flutter::EncodableList;
using flutter::EncodableMap;
using flutter::EncodableValue;

// Sets up an instance of `UrlLauncherApi` to handle messages through the
// `binary_messenger`.
void FileSelectorApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                            FileSelectorApi* api) {
  {
    const auto channel = std::make_unique<flutter::MethodChannel<>>(
        binary_messenger, "plugins.flutter.dev/file_selector_linux",
        &flutter::StandardMethodCodec::GetInstance());
    if (api != nullptr) {
      channel->SetMethodCallHandler(
          [](const flutter::MethodCall<EncodableValue>& call,
             const std::unique_ptr<flutter::MethodResult<EncodableValue>>&
                 result) {
            SPDLOG_DEBUG("[file_selector] {}", call.method_name());
            if (call.method_name() == kGetDirectoryPath) {
              SPDLOG_DEBUG("[file_selector] getDirectoryPath:");
              if (call.arguments()->IsNull()) {
                result->Error("invalid_arguments", "");
                return;
              }

              std::string initialDirectory;
              std::string confirmButtonText;
              bool multiple{};
              std::ostringstream oss;

              auto args = std::get_if<flutter::EncodableMap>(call.arguments());
              for (auto& it : *args) {
                auto key = std::get<std::string>(it.first);
                if (key == kArgInitialDirectory && !it.second.IsNull() &&
                    std::holds_alternative<std::string>(it.second)) {
                  initialDirectory = std::get<std::string>(it.second);
                } else if (key == kArgConfirmButtonText &&
                           !it.second.IsNull()) {
                  confirmButtonText.assign(std::get<std::string>(it.second));
                } else if (key == kArgMultiple && !it.second.IsNull() &&
                           std::holds_alternative<bool>(it.second)) {
                  multiple = std::get<bool>(it.second);
                }
              }

              SPDLOG_DEBUG("initialDirectory: [{}]", initialDirectory);
              if (!initialDirectory.empty()) {
                if (std::filesystem::exists(initialDirectory)) {
                  oss << "cd " << initialDirectory << " && ";
                }
              }

              oss << "zenity --file-selection --directory";

              SPDLOG_DEBUG("multiple: [{}]", multiple);
              if (multiple) {
                oss << " --multiple";
              }

              SPDLOG_DEBUG("confirmButtonText: [{}]", confirmButtonText);
              if (!confirmButtonText.empty()) {
                oss << " --title=" << confirmButtonText;
              }

              SPDLOG_DEBUG("cmd: [{}]", oss.str());

              std::string path;
              if (!plugin_common::Command::Execute(oss.str().c_str(), path)) {
                result->Error("failed", "failed to execute command");
                return;
              }
              flutter::EncodableList results;
              auto paths = plugin_common::StringTools::split(path, "|");
              for (auto p : paths) {
                results.emplace_back(
                    std::move(plugin_common::StringTools::trim(p, "\n")));
              }
              result->Success(flutter::EncodableValue(results));
              return;
            } else if (call.method_name() == kGetSavePath) {
              SPDLOG_DEBUG("[file_selector] getSavePath:");
              if (call.arguments()->IsNull()) {
                result->Error("invalid_arguments", "");
                return;
              }

              std::filesystem::path filepath;
              std::string initialDirectory;
              std::string suggestedName;
              std::string confirmButtonText;
              std::ostringstream oss;

              auto args = std::get_if<flutter::EncodableMap>(call.arguments());
              for (auto& it : *args) {
                auto key = std::get<std::string>(it.first);
                if (key == kArgInitialDirectory && !it.second.IsNull() &&
                    std::holds_alternative<std::string>(it.second)) {
                  initialDirectory = std::get<std::string>(it.second);
                } else if (key == kArgSuggestedName && !it.second.IsNull() &&
                           std::holds_alternative<std::string>(it.second)) {
                  suggestedName.assign(std::get<std::string>(it.second));
                } else if (key == kArgConfirmButtonText &&
                           !it.second.IsNull()) {
                  confirmButtonText.assign(std::get<std::string>(it.second));
                }
              }

              SPDLOG_DEBUG("initialDirectory: [{}]", initialDirectory);
              filepath.assign(initialDirectory);
              if (!exists(filepath)) {
                if (!std::filesystem::create_directories(filepath)) {
                  result->Error("error", "Failed to create directories");
                  return;
                }
              }
              SPDLOG_DEBUG("suggestedName: [{}]", suggestedName);
              filepath.append(suggestedName);
              SPDLOG_DEBUG("confirmButtonText: [{}]", confirmButtonText);
              SPDLOG_DEBUG("save filepath: [{}]", filepath.c_str());
              flutter::EncodableValue val(filepath.c_str());
              result->Success(flutter::EncodableValue(filepath.c_str()));
              return;
            } else if (call.method_name() == kMethodOpenFile) {
              SPDLOG_DEBUG("[file_selector] openFile");

              if (call.arguments()->IsNull()) {
                result->Error("invalid_arguments", "");
                return;
              }

              std::string initialDirectory;
              std::string confirmButtonText;
              std::string label;
              std::ostringstream oss;
              std::stringstream extensions;
              bool multiple{};

              auto args = std::get_if<flutter::EncodableMap>(call.arguments());
              for (auto& it : *args) {
                auto key = std::get<std::string>(it.first);
                if (key == kArgAcceptedTypeGroups && !it.second.IsNull() &&
                    std::holds_alternative<flutter::EncodableList>(it.second)) {
                  auto acceptedTypeGroups =
                      std::get<flutter::EncodableList>(it.second);
                  for (auto const& group : acceptedTypeGroups) {
                    if (!group.IsNull() &&
                        std::holds_alternative<flutter::EncodableMap>(group)) {
                      auto map = std::get<flutter::EncodableMap>(group);
                      for (const auto& ele : map) {
                        if (std::holds_alternative<std::string>(ele.first) &&
                            std::holds_alternative<std::string>(ele.second)) {
                          const auto k = std::get<std::string>(ele.first);
                          if (k == kArgTypeGroupLabel) {
                            label = std::get<std::string>(ele.second);
                            SPDLOG_DEBUG("{}: {}", k, label);
                          }
                        }
                        if (std::holds_alternative<std::string>(ele.first) &&
                            std::holds_alternative<flutter::EncodableList>(
                                ele.second)) {
                          auto k = std::get<std::string>(ele.first);
                          auto list =
                              std::get<flutter::EncodableList>(ele.second);
                          for (const auto& item : list) {
                            if (std::holds_alternative<std::string>(item)) {
                              auto value = std::get<std::string>(item);
                              if (k == kArgTypeGroupExtensions) {
                                extensions << " " << value;
                                SPDLOG_DEBUG("{}: {}", k, value);
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                } else if (key == kArgInitialDirectory && !it.second.IsNull() &&
                           std::holds_alternative<std::string>(it.second)) {
                  initialDirectory.assign(std::get<std::string>(it.second));
                } else if (key == kArgConfirmButtonText &&
                           !it.second.IsNull()) {
                  confirmButtonText.assign(std::get<std::string>(it.second));
                } else if (key == kArgMultiple && !it.second.IsNull() &&
                           std::holds_alternative<bool>(it.second)) {
                  multiple = std::get<bool>(it.second);
                }
              }

              SPDLOG_DEBUG("initialDirectory: [{}]", initialDirectory);
              if (!initialDirectory.empty()) {
                if (std::filesystem::exists(initialDirectory)) {
                  oss << "cd " << initialDirectory << " && ";
                }
              }

              oss << "zenity --file-selection --file-filter=\"" << label
                  << " | " << extensions.str() << "\"";

              SPDLOG_DEBUG("multiple: {}", multiple);
              if (multiple) {
                oss << " --multiple";
              }

              SPDLOG_DEBUG("confirmButtonText: [{}]", confirmButtonText);
              if (!confirmButtonText.empty()) {
                oss << " --title=" << confirmButtonText;
              }

              SPDLOG_DEBUG("cmd: [{}]", oss.str());

              std::string path;
              if (!plugin_common::Command::Execute(oss.str().c_str(), path)) {
                result->Error("failed", "failed to execute command");
                return;
              }

              flutter::EncodableList results;
              auto paths = plugin_common::StringTools::split(path, "|");
              for (auto p : paths) {
                results.emplace_back(
                    std::move(plugin_common::StringTools::trim(p, "\n")));
              }
              result->Success(flutter::EncodableValue(results));
            } else {
              result->NotImplemented();
            }
          });
    } else {
      channel->SetMethodCallHandler(nullptr);
    }
  }
}

EncodableValue FileSelectorApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue FileSelectorApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

}  // namespace plugin_file_selector
