// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v10.1.6), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#undef _HAS_EXCEPTIONS

#include "messages.h"

#include <flutter/basic_message_channel.h>
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/method_call.h>
#include <flutter/method_channel.h>
#include <flutter/standard_method_codec.h>

#include <optional>
#include <string>

#include "plugins/common/common.h"

namespace plugin_secure_storage {

using flutter::BasicMessageChannel;
using flutter::CustomEncodableValue;
using flutter::EncodableList;
using flutter::EncodableMap;
using flutter::EncodableValue;

/// The codec used by SecureStorageApi.
const flutter::StandardMethodCodec& SecureStorageApi::GetCodec() {
  return flutter::StandardMethodCodec::GetInstance();
}

// Sets up an instance of `SecureStorageApi` to handle messages through the
// `binary_messenger`.
void SecureStorageApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                             SecureStorageApi* api) {
  {
    const auto channel =
        std::make_unique<flutter::MethodChannel<EncodableValue>>(
            binary_messenger, "plugins.it_nomads.com/flutter_secure_storage",
            &GetCodec());
    if (api != nullptr) {
      channel->SetMethodCallHandler(
          [api](const flutter::MethodCall<EncodableValue>& call,
                const std::unique_ptr<flutter::MethodResult<EncodableValue>>&
                    result) {
            SPDLOG_DEBUG("[secure_storage] {}", call.method_name());
            auto args = std::get_if<flutter::EncodableMap>(call.arguments());

            std::string key;
            std::string value;

            for (const auto& it : *args) {
              if (std::holds_alternative<std::string>(it.first) &&
                  std::holds_alternative<std::string>(it.second)) {
                auto k = std::get<std::string>(it.first);
                if (k == "key") {
                  key = std::get<std::string>(it.second);
                } else if (k == "value") {
                  value = std::get<std::string>(it.second);
                }
              }
            }

            if (call.method_name() == "write") {
              SPDLOG_DEBUG("secure_storage: [Write] key: {}, value: {}", key,
                           value);
              api->write(key.c_str(), value.c_str());
              result->Success(flutter::EncodableValue(true));
            } else if (call.method_name() == "read") {
              SPDLOG_DEBUG("secure_storage: [Read] key: {}", key);
              result->Success(api->read(key.c_str()));
            } else if (call.method_name() == "readAll") {
              SPDLOG_DEBUG("secure_storage: [ReadAll]");
              result->Success(api->readAll());
            } else if (call.method_name() == "delete") {
              SPDLOG_DEBUG("secure_storage: [Delete]");
              api->deleteIt(key.c_str());
              result->Success(flutter::EncodableValue(true));
            } else if (call.method_name() == "deleteAll") {
              SPDLOG_DEBUG("secure_storage: [DeleteAll]");
              api->deleteAll();
              result->Success(flutter::EncodableValue(true));
            } else if (call.method_name() == "containsKey") {
              SPDLOG_DEBUG("secure_storage: [ContainsKey]");
              auto val = api->containsKey(key.c_str());
              result->Success(flutter::EncodableValue(val));
            } else {
              result->NotImplemented();
            }
          });
    } else {
      channel->SetMethodCallHandler(nullptr);
    }
  }
}

EncodableValue SecureStorageApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue SecureStorageApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

}  // namespace plugin_secure_storage
