// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v10.1.6), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#undef _HAS_EXCEPTIONS

#include "messages.h"

#include <flutter/basic_message_channel.h>
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/method_call.h>
#include <flutter/method_channel.h>
#include <flutter/standard_method_codec.h>

#include <optional>
#include <string>

#include "plugins/common/common.h"

namespace url_launcher_linux {
using flutter::BasicMessageChannel;
using flutter::CustomEncodableValue;
using flutter::EncodableList;
using flutter::EncodableMap;
using flutter::EncodableValue;

// Sets up an instance of `UrlLauncherApi` to handle messages through the
// `binary_messenger`.
void UrlLauncherApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                           UrlLauncherApi* api) {
  {
    const auto channel = std::make_unique<flutter::MethodChannel<>>(
        binary_messenger, "plugins.flutter.io/url_launcher_linux",
        &flutter::StandardMethodCodec::GetInstance());
    if (api != nullptr) {
      channel->SetMethodCallHandler(
          [api](const flutter::MethodCall<EncodableValue>& call,
                const std::unique_ptr<flutter::MethodResult<EncodableValue>>&
                    result) {
            SPDLOG_DEBUG("[url_launcher] {}", call.method_name());
            if ("closeWebView" == call.method_name()) {
              result->Success(flutter::EncodableValue(true));
            } else if ("canLaunch" == call.method_name()) {
              if (std::holds_alternative<std::string>(*call.arguments())) {
                const auto& value = std::get<std::string>(*call.arguments());
                spdlog::debug("[url_launcher] canLaunch: {}", value);
                const ErrorOr<bool> output = api->CanLaunchUrl(value);
                if (output.has_error()) {
                  result->Error(output.error().code(),
                                output.error().message());
                  return;
                }
                result->Success(flutter::EncodableValue(true));
              } else if (std::holds_alternative<flutter::EncodableMap>(
                             *call.arguments())) {
                const auto& args =
                    std::get_if<flutter::EncodableMap>(call.arguments());
                for (const auto& it : *args) {
                  if (std::holds_alternative<std::string>(it.first) &&
                      std::holds_alternative<std::string>(it.second)) {
                    auto key = std::get<std::string>(it.first);
                    auto value = std::get<std::string>(it.second);
                    if (key == "url") {
                      const ErrorOr<bool> output = api->CanLaunchUrl(value);
                      if (output.has_error()) {
                        result->Error(output.error().code(),
                                      output.error().message());
                        return;
                      }
                      result->Success(flutter::EncodableValue(true));
                    } else {
                      result->NotImplemented();
                    }
                  }
                  break;
                }
              }
            } else if ("launch" == call.method_name()) {
              const auto& arg = *call.arguments();
              plugin_common::Encodable::PrintFlutterEncodableValue("launch",
                                                                   arg);
              if (std::holds_alternative<std::string>(arg)) {
                const auto& value = std::get<std::string>(arg);
                spdlog::debug("[url_launcher] launch: {}", value);
                const std::optional<FlutterError> output =
                    api->LaunchUrl(value);
                if (output.has_value()) {
                  result->Error(output->code(), output->message(),
                                output->details());
                  return;
                }
              } else if (std::holds_alternative<EncodableMap>(arg)) {
                const auto& args = std::get<EncodableMap>(arg);
                std::string url;
                bool enableJavaScript{};
                bool enableDomStorage{};
                bool universalLinksOnly{};
                EncodableMap headers{};
                for (const auto& it : args) {
                  if (std::holds_alternative<std::string>(it.first) &&
                      std::holds_alternative<std::string>(it.second)) {
                    auto key = std::get<std::string>(it.first);
                    auto value = std::get<std::string>(it.second);
                    if (key == "url") {
                      url = value;
                    }
                  } else if (std::holds_alternative<std::string>(it.first) &&
                             std::holds_alternative<bool>(it.second)) {
                    std::string key = std::get<std::string>(it.first);
                    if (key == "enableJavaScript") {
                      enableJavaScript = std::get<bool>(it.second);
                    } else if (key == "enableDomStorage") {
                      enableDomStorage = std::get<bool>(it.second);
                    } else if (key == "universalLinksOnly") {
                      universalLinksOnly = std::get<bool>(it.second);
                    } else if (std::holds_alternative<std::string>(it.first) &&
                               std::holds_alternative<EncodableMap>(
                                   it.second)) {
                      key = std::get<std::string>(it.first);
                      auto map = std::get<EncodableMap>(it.second);
                      if (key == "headers") {
                        for (const auto& header : map) {
                          auto header_key = std::get<std::string>(header.first);
                          auto header_value =
                              std::get<std::string>(header.second);
                          SPDLOG_DEBUG("[url_launcher] {}={}", header_key,
                                       header_value);
                        }
                      } else {
                        plugin_common::Encodable::PrintFlutterEncodableMap(
                            key.c_str(), map);
                      }
                    }
                  }
                }
                spdlog::debug(
                    "[url_launcher] url: {}, enableJavaScript: {}, "
                    "enableDomStorage: {}, universalLinksOnly: {}",
                    url, enableJavaScript, enableDomStorage,
                    universalLinksOnly);
                const std::optional<FlutterError> output = api->LaunchUrl(url);
                if (output.has_value()) {
                  result->Error(output->code(), output->message(),
                                output->details());
                  return;
                }
              }
              result->Success(flutter::EncodableValue(true));
            } else {
              result->NotImplemented();
            }
          });
    }
  }
}

EncodableValue UrlLauncherApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue UrlLauncherApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

}  // namespace url_launcher_linux
