// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#ifndef GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_8_15_7_H
#define GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_8_15_7_H
#include <grpc/support/port_platform.h>

#include <cstddef>
#include <cstdint>
namespace grpc_core {
namespace geometry_8_15_7 {
class HuffDecoderCommon {
 protected:
  static inline uint64_t GetOp2(size_t i) { return table2_0_ops_[i]; }
  static inline uint64_t GetEmit2(size_t, size_t emit) {
    return table2_0_emit_[emit];
  }
  static inline uint64_t GetOp3(size_t i) { return table3_0_ops_[i]; }
  static inline uint64_t GetEmit3(size_t, size_t emit) {
    return table3_0_emit_[emit];
  }
  static inline uint64_t GetOp4(size_t i) {
    return table4_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit4(size_t i, size_t emit) {
    return table4_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp1(size_t i) {
    return table1_0_inner_[table1_0_outer_[i]];
  }
  static inline uint64_t GetEmit1(size_t, size_t emit) {
    return table1_0_emit_[emit];
  }
  static inline uint64_t GetOp5(size_t i) {
    return (i < 2 ? (i ? 6 : 2) : ((i - 2) ? 14 : 10));
  }
  static inline uint64_t GetEmit5(size_t, size_t emit) {
    return (emit < 2 ? (emit + 33) : ((emit - 2) + 40));
  }
  static inline uint64_t GetOp7(size_t i) {
    return (i < 2 ? (i) : ((i - 2) + 1));
  }
  static inline uint64_t GetEmit7(size_t, size_t emit) {
    return ((void)emit, 63);
  }
  static inline uint64_t GetOp8(size_t i) {
    return table8_0_inner_[table8_0_outer_[i]];
  }
  static inline uint64_t GetEmit8(size_t, size_t emit) {
    return (emit < 2 ? (emit ? 39 : 63) : ((emit - 2) ? 124 : 43));
  }
  static inline uint64_t GetOp9(size_t i) {
    return table9_0_inner_[table9_0_outer_[i]];
  }
  static inline uint64_t GetEmit9(size_t, size_t emit) {
    return table9_0_emit_[emit];
  }
  static inline uint64_t GetOp10(size_t i) { return table10_0_ops_[i]; }
  static inline uint64_t GetEmit10(size_t, size_t emit) {
    return table10_0_emit_[emit];
  }
  static inline uint64_t GetOp11(size_t i) { return table11_0_ops_[i]; }
  static inline uint64_t GetEmit11(size_t, size_t emit) {
    return table11_0_emit_[emit];
  }
  static inline uint64_t GetOp12(size_t i) { return table12_0_ops_[i]; }
  static inline uint64_t GetEmit12(size_t, size_t emit) {
    return table12_0_emit_[emit];
  }
  static inline uint64_t GetOp13(size_t i) {
    return table13_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit13(size_t i, size_t emit) {
    return table13_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp14(size_t i) {
    return table14_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit14(size_t i, size_t emit) {
    return table14_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp15(size_t i) {
    return table15_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit15(size_t i, size_t emit) {
    return table15_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp16(size_t i) {
    return table16_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit16(size_t i, size_t emit) {
    return table16_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp17(size_t i) {
    return table17_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit17(size_t i, size_t emit) {
    return table17_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp18(size_t i) {
    return table18_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit18(size_t i, size_t emit) {
    return table18_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp19(size_t i) {
    return table19_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit19(size_t i, size_t emit) {
    return table19_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp6(size_t i) {
    return table6_ops_[i >> 8][i & 0xff];
  }
  static inline uint64_t GetEmit6(size_t i, size_t emit) {
    return table6_emit_[i >> 8][emit];
  }
  static inline uint64_t GetOp20(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit20(size_t, size_t emit) {
    return emit ? 142 : 9;
  }
  static inline uint64_t GetOp21(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit21(size_t, size_t emit) { return emit + 144; }
  static inline uint64_t GetOp22(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit22(size_t, size_t emit) {
    return emit ? 159 : 148;
  }
  static inline uint64_t GetOp23(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit23(size_t, size_t emit) {
    return emit ? 206 : 171;
  }
  static inline uint64_t GetOp24(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit24(size_t, size_t emit) {
    return emit ? 225 : 215;
  }
  static inline uint64_t GetOp25(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit25(size_t, size_t emit) { return emit + 236; }
  static inline uint64_t GetOp26(size_t i) {
    return (i < 2 ? (i ? 6 : 2) : ((i - 2) ? 14 : 10));
  }
  static inline uint64_t GetEmit26(size_t, size_t emit) {
    return (emit < 2 ? (emit ? 207 : 199) : ((emit - 2) + 234));
  }
  static inline uint64_t GetOp27(size_t i) { return table27_0_inner_[i]; }
  static inline uint64_t GetEmit27(size_t, size_t emit) {
    return table27_0_emit_[emit];
  }
  static inline uint64_t GetOp28(size_t i) { return table28_0_inner_[i]; }
  static inline uint64_t GetEmit28(size_t, size_t emit) {
    return table28_0_emit_[emit];
  }
  static inline uint64_t GetOp30(size_t i) {
    return (i < 1 ? (((void)i, 0)) : ((i - 1) / 14 + 1));
  }
  static inline uint64_t GetEmit30(size_t, size_t emit) {
    return ((void)emit, 254);
  }
  static inline uint64_t GetOp31(size_t i) { return table31_0_ops_[i]; }
  static inline uint64_t GetEmit31(size_t, size_t emit) {
    return table31_0_emit_[emit];
  }
  static inline uint64_t GetOp32(size_t i) { return table32_0_ops_[i]; }
  static inline uint64_t GetEmit32(size_t, size_t emit) {
    return table31_0_emit_[emit];
  }
  static inline uint64_t GetOp29(size_t i) {
    return table29_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit29(size_t i, size_t emit) {
    return table29_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp34(size_t i) { return table34_0_inner_[i]; }
  static inline uint64_t GetEmit34(size_t, size_t emit) {
    return table34_0_emit_[emit];
  }
  static inline uint64_t GetOp33(size_t i) {
    return table33_0_inner_[(i < 13 ? (i / 2 + 0) : ((i - 13) + 6))];
  }
  static inline uint64_t GetEmit33(size_t, size_t emit) {
    return table33_0_emit_[emit];
  }

 private:
  static const uint8_t table2_0_emit_[10];
  static const uint8_t table2_0_ops_[32];
  static const uint8_t table3_0_emit_[36];
  static const uint8_t table3_0_ops_[64];
  static const uint8_t table4_0_emit_[22];
  static const uint8_t table4_0_ops_[64];
  static const uint8_t table4_1_emit_[46];
  static const uint8_t table4_1_ops_[64];
  static const uint8_t* const table4_emit_[2];
  static const uint8_t* const table4_ops_[2];
  static const uint8_t table1_0_emit_[74];
  static const uint16_t table1_0_inner_[76];
  static const uint8_t table1_0_outer_[256];
  static const uint8_t table8_0_inner_[6];
  static const uint8_t table8_0_outer_[8];
  static const uint8_t table9_0_emit_[6];
  static const uint8_t table9_0_inner_[8];
  static const uint8_t table9_0_outer_[16];
  static const uint8_t table10_0_emit_[12];
  static const uint8_t table10_0_ops_[32];
  static const uint8_t table11_0_emit_[14];
  static const uint8_t table11_0_ops_[64];
  static const uint8_t table12_0_emit_[36];
  static const uint8_t table12_0_ops_[128];
  static const uint8_t table13_0_emit_[44];
  static const uint8_t table13_0_ops_[32];
  static const uint8_t table13_1_emit_[28];
  static const uint8_t table13_1_ops_[32];
  static const uint8_t table13_2_emit_[20];
  static const uint8_t table13_2_ops_[32];
  static const uint8_t table13_3_emit_[20];
  static const uint8_t table13_4_emit_[20];
  static const uint8_t table13_5_emit_[2];
  static const uint8_t table13_5_ops_[32];
  static const uint8_t table13_6_emit_[4];
  static const uint8_t table13_6_ops_[32];
  static const uint8_t table13_7_emit_[7];
  static const uint8_t table13_7_ops_[32];
  static const uint8_t* const table13_emit_[8];
  static const uint8_t* const table13_ops_[8];
  static const uint8_t table14_0_emit_[16];
  static const uint8_t table14_0_ops_[32];
  static const uint8_t table14_1_emit_[28];
  static const uint8_t table14_1_ops_[32];
  static const uint8_t table14_2_emit_[36];
  static const uint8_t table14_2_ops_[32];
  static const uint8_t table14_3_emit_[56];
  static const uint8_t table14_3_ops_[32];
  static const uint8_t table14_4_emit_[44];
  static const uint8_t table14_5_emit_[28];
  static const uint8_t table14_6_emit_[44];
  static const uint8_t table14_7_emit_[28];
  static const uint8_t table14_8_emit_[44];
  static const uint8_t table14_9_emit_[28];
  static const uint8_t table14_10_emit_[20];
  static const uint8_t table14_11_emit_[20];
  static const uint8_t table14_12_emit_[2];
  static const uint8_t table14_13_emit_[2];
  static const uint8_t table14_14_emit_[2];
  static const uint8_t table14_15_emit_[5];
  static const uint8_t table14_15_ops_[32];
  static const uint8_t* const table14_emit_[16];
  static const uint8_t* const table14_ops_[16];
  static const uint16_t table15_0_ops_[64];
  static const uint16_t table15_1_ops_[64];
  static const uint16_t table15_2_ops_[64];
  static const uint8_t table15_3_emit_[68];
  static const uint16_t table15_3_ops_[64];
  static const uint16_t table15_4_ops_[64];
  static const uint8_t table15_5_emit_[92];
  static const uint16_t table15_5_ops_[64];
  static const uint8_t table15_7_emit_[92];
  static const uint8_t table15_9_emit_[92];
  static const uint8_t table15_10_emit_[72];
  static const uint16_t table15_10_ops_[64];
  static const uint8_t table15_11_emit_[72];
  static const uint8_t table15_12_emit_[40];
  static const uint16_t table15_12_ops_[64];
  static const uint8_t table15_13_emit_[40];
  static const uint8_t table15_14_emit_[40];
  static const uint16_t table15_15_ops_[64];
  static const uint8_t* const table15_emit_[16];
  static const uint16_t* const table15_ops_[16];
  static const uint8_t table16_0_emit_[8];
  static const uint16_t table16_0_ops_[64];
  static const uint8_t table16_1_emit_[8];
  static const uint8_t table16_2_emit_[12];
  static const uint16_t table16_2_ops_[64];
  static const uint8_t table16_3_emit_[16];
  static const uint8_t table16_4_emit_[16];
  static const uint8_t table16_5_emit_[20];
  static const uint16_t table16_5_ops_[64];
  static const uint8_t table16_6_emit_[32];
  static const uint16_t table16_6_ops_[64];
  static const uint8_t table16_7_emit_[36];
  static const uint16_t table16_7_ops_[64];
  static const uint8_t table16_8_emit_[16];
  static const uint8_t table16_9_emit_[28];
  static const uint8_t table16_10_emit_[36];
  static const uint8_t table16_11_emit_[68];
  static const uint8_t table16_12_emit_[16];
  static const uint8_t table16_13_emit_[28];
  static const uint8_t table16_14_emit_[36];
  static const uint8_t table16_15_emit_[68];
  static const uint8_t table16_16_emit_[16];
  static const uint8_t table16_17_emit_[28];
  static const uint8_t table16_18_emit_[36];
  static const uint8_t table16_19_emit_[68];
  static const uint8_t table16_20_emit_[44];
  static const uint8_t table16_21_emit_[92];
  static const uint8_t table16_22_emit_[44];
  static const uint8_t table16_23_emit_[92];
  static const uint8_t table16_24_emit_[72];
  static const uint8_t table16_25_emit_[72];
  static const uint8_t table16_26_emit_[72];
  static const uint8_t table16_27_emit_[72];
  static const uint8_t table16_28_emit_[72];
  static const uint8_t table16_29_emit_[72];
  static const uint8_t table16_30_emit_[40];
  static const uint8_t table16_31_emit_[6];
  static const uint16_t table16_31_ops_[64];
  static const uint8_t* const table16_emit_[32];
  static const uint16_t* const table16_ops_[32];
  static const uint8_t table17_0_emit_[60];
  static const uint16_t table17_0_ops_[64];
  static const uint8_t table17_1_emit_[60];
  static const uint8_t table17_2_emit_[60];
  static const uint8_t table17_3_emit_[60];
  static const uint8_t table17_4_emit_[60];
  static const uint8_t table17_5_emit_[8];
  static const uint16_t table17_5_ops_[64];
  static const uint8_t table17_6_emit_[8];
  static const uint8_t table17_7_emit_[8];
  static const uint8_t table17_8_emit_[8];
  static const uint8_t table17_9_emit_[8];
  static const uint8_t table17_10_emit_[8];
  static const uint8_t table17_11_emit_[12];
  static const uint16_t table17_11_ops_[64];
  static const uint8_t table17_12_emit_[16];
  static const uint16_t table17_12_ops_[64];
  static const uint8_t table17_13_emit_[16];
  static const uint8_t table17_14_emit_[16];
  static const uint8_t table17_15_emit_[30];
  static const uint16_t table17_15_ops_[64];
  static const uint8_t table17_16_emit_[8];
  static const uint8_t table17_17_emit_[8];
  static const uint8_t table17_18_emit_[12];
  static const uint8_t table17_19_emit_[16];
  static const uint8_t table17_20_emit_[16];
  static const uint8_t table17_21_emit_[20];
  static const uint16_t table17_21_ops_[64];
  static const uint8_t table17_22_emit_[32];
  static const uint16_t table17_22_ops_[64];
  static const uint8_t table17_23_emit_[36];
  static const uint16_t table17_23_ops_[64];
  static const uint8_t table17_24_emit_[8];
  static const uint8_t table17_25_emit_[8];
  static const uint8_t table17_26_emit_[12];
  static const uint8_t table17_27_emit_[16];
  static const uint8_t table17_28_emit_[16];
  static const uint8_t table17_29_emit_[20];
  static const uint8_t table17_30_emit_[32];
  static const uint8_t table17_31_emit_[36];
  static const uint8_t table17_32_emit_[8];
  static const uint8_t table17_33_emit_[8];
  static const uint8_t table17_34_emit_[12];
  static const uint8_t table17_35_emit_[16];
  static const uint8_t table17_36_emit_[16];
  static const uint8_t table17_37_emit_[20];
  static const uint8_t table17_38_emit_[32];
  static const uint8_t table17_39_emit_[36];
  static const uint8_t table17_40_emit_[16];
  static const uint8_t table17_41_emit_[28];
  static const uint16_t table17_41_ops_[64];
  static const uint8_t table17_42_emit_[36];
  static const uint16_t table17_42_ops_[64];
  static const uint8_t table17_43_emit_[68];
  static const uint16_t table17_43_ops_[64];
  static const uint8_t table17_44_emit_[16];
  static const uint8_t table17_45_emit_[28];
  static const uint8_t table17_46_emit_[36];
  static const uint8_t table17_47_emit_[68];
  static const uint8_t table17_48_emit_[44];
  static const uint16_t table17_48_ops_[64];
  static const uint8_t table17_49_emit_[92];
  static const uint16_t table17_49_ops_[64];
  static const uint8_t table17_50_emit_[44];
  static const uint8_t table17_51_emit_[92];
  static const uint8_t table17_52_emit_[44];
  static const uint8_t table17_53_emit_[92];
  static const uint8_t table17_54_emit_[44];
  static const uint8_t table17_55_emit_[92];
  static const uint8_t table17_56_emit_[44];
  static const uint8_t table17_57_emit_[92];
  static const uint8_t table17_58_emit_[44];
  static const uint8_t table17_59_emit_[92];
  static const uint8_t table17_60_emit_[72];
  static const uint16_t table17_60_ops_[64];
  static const uint8_t table17_61_emit_[72];
  static const uint8_t table17_62_emit_[40];
  static const uint16_t table17_62_ops_[64];
  static const uint8_t table17_63_emit_[31];
  static const uint16_t table17_63_ops_[64];
  static const uint8_t* const table17_emit_[64];
  static const uint16_t* const table17_ops_[64];
  static const uint8_t table18_0_emit_[108];
  static const uint16_t table18_0_ops_[64];
  static const uint8_t table18_1_emit_[108];
  static const uint8_t table18_2_emit_[108];
  static const uint8_t table18_3_emit_[108];
  static const uint8_t table18_4_emit_[108];
  static const uint8_t table18_5_emit_[108];
  static const uint8_t table18_6_emit_[108];
  static const uint8_t table18_7_emit_[108];
  static const uint8_t table18_8_emit_[108];
  static const uint8_t table18_9_emit_[108];
  static const uint8_t table18_10_emit_[60];
  static const uint16_t table18_10_ops_[64];
  static const uint8_t table18_11_emit_[60];
  static const uint8_t table18_12_emit_[60];
  static const uint8_t table18_13_emit_[60];
  static const uint8_t table18_14_emit_[60];
  static const uint8_t table18_15_emit_[60];
  static const uint8_t table18_16_emit_[60];
  static const uint8_t table18_17_emit_[60];
  static const uint8_t table18_18_emit_[60];
  static const uint8_t table18_19_emit_[60];
  static const uint8_t table18_20_emit_[60];
  static const uint8_t table18_21_emit_[60];
  static const uint8_t table18_22_emit_[60];
  static const uint8_t table18_23_emit_[8];
  static const uint16_t table18_23_ops_[64];
  static const uint8_t table18_24_emit_[8];
  static const uint8_t table18_25_emit_[8];
  static const uint8_t table18_26_emit_[8];
  static const uint8_t table18_27_emit_[8];
  static const uint8_t table18_28_emit_[8];
  static const uint8_t table18_29_emit_[8];
  static const uint8_t table18_30_emit_[8];
  static const uint8_t table18_31_emit_[27];
  static const uint16_t table18_31_ops_[64];
  static const uint8_t table18_32_emit_[60];
  static const uint8_t table18_33_emit_[60];
  static const uint8_t table18_34_emit_[60];
  static const uint8_t table18_35_emit_[60];
  static const uint8_t table18_36_emit_[60];
  static const uint8_t table18_37_emit_[8];
  static const uint8_t table18_38_emit_[8];
  static const uint8_t table18_39_emit_[8];
  static const uint8_t table18_40_emit_[8];
  static const uint8_t table18_41_emit_[8];
  static const uint8_t table18_42_emit_[8];
  static const uint8_t table18_43_emit_[12];
  static const uint16_t table18_43_ops_[64];
  static const uint8_t table18_44_emit_[16];
  static const uint16_t table18_44_ops_[64];
  static const uint8_t table18_45_emit_[16];
  static const uint8_t table18_46_emit_[16];
  static const uint8_t table18_47_emit_[30];
  static const uint16_t table18_47_ops_[64];
  static const uint8_t table18_48_emit_[60];
  static const uint8_t table18_49_emit_[60];
  static const uint8_t table18_50_emit_[60];
  static const uint8_t table18_51_emit_[60];
  static const uint8_t table18_52_emit_[60];
  static const uint8_t table18_53_emit_[8];
  static const uint8_t table18_54_emit_[8];
  static const uint8_t table18_55_emit_[8];
  static const uint8_t table18_56_emit_[8];
  static const uint8_t table18_57_emit_[8];
  static const uint8_t table18_58_emit_[8];
  static const uint8_t table18_59_emit_[12];
  static const uint8_t table18_60_emit_[16];
  static const uint8_t table18_61_emit_[16];
  static const uint8_t table18_62_emit_[16];
  static const uint8_t table18_63_emit_[30];
  static const uint8_t table18_64_emit_[60];
  static const uint8_t table18_65_emit_[60];
  static const uint8_t table18_66_emit_[60];
  static const uint8_t table18_67_emit_[60];
  static const uint8_t table18_68_emit_[60];
  static const uint8_t table18_69_emit_[8];
  static const uint8_t table18_70_emit_[8];
  static const uint8_t table18_71_emit_[8];
  static const uint8_t table18_72_emit_[8];
  static const uint8_t table18_73_emit_[8];
  static const uint8_t table18_74_emit_[8];
  static const uint8_t table18_75_emit_[12];
  static const uint8_t table18_76_emit_[16];
  static const uint8_t table18_77_emit_[16];
  static const uint8_t table18_78_emit_[16];
  static const uint8_t table18_79_emit_[30];
  static const uint8_t table18_80_emit_[8];
  static const uint8_t table18_81_emit_[8];
  static const uint8_t table18_82_emit_[12];
  static const uint8_t table18_83_emit_[16];
  static const uint8_t table18_84_emit_[16];
  static const uint8_t table18_85_emit_[20];
  static const uint16_t table18_85_ops_[64];
  static const uint8_t table18_86_emit_[32];
  static const uint16_t table18_86_ops_[64];
  static const uint8_t table18_87_emit_[36];
  static const uint16_t table18_87_ops_[64];
  static const uint8_t table18_88_emit_[8];
  static const uint8_t table18_89_emit_[8];
  static const uint8_t table18_90_emit_[12];
  static const uint8_t table18_91_emit_[16];
  static const uint8_t table18_92_emit_[16];
  static const uint8_t table18_93_emit_[20];
  static const uint8_t table18_94_emit_[32];
  static const uint8_t table18_95_emit_[36];
  static const uint8_t table18_96_emit_[16];
  static const uint8_t table18_97_emit_[28];
  static const uint16_t table18_97_ops_[64];
  static const uint8_t table18_98_emit_[36];
  static const uint16_t table18_98_ops_[64];
  static const uint8_t table18_99_emit_[68];
  static const uint16_t table18_99_ops_[64];
  static const uint8_t table18_100_emit_[16];
  static const uint8_t table18_101_emit_[28];
  static const uint8_t table18_102_emit_[36];
  static const uint8_t table18_103_emit_[68];
  static const uint8_t table18_104_emit_[16];
  static const uint8_t table18_105_emit_[28];
  static const uint8_t table18_106_emit_[36];
  static const uint8_t table18_107_emit_[68];
  static const uint8_t table18_108_emit_[16];
  static const uint8_t table18_109_emit_[28];
  static const uint8_t table18_110_emit_[36];
  static const uint8_t table18_111_emit_[68];
  static const uint8_t table18_112_emit_[16];
  static const uint8_t table18_113_emit_[28];
  static const uint8_t table18_114_emit_[36];
  static const uint8_t table18_115_emit_[68];
  static const uint8_t table18_116_emit_[16];
  static const uint8_t table18_117_emit_[28];
  static const uint8_t table18_118_emit_[36];
  static const uint8_t table18_119_emit_[68];
  static const uint8_t table18_120_emit_[44];
  static const uint16_t table18_120_ops_[64];
  static const uint8_t table18_121_emit_[92];
  static const uint16_t table18_121_ops_[64];
  static const uint8_t table18_122_emit_[44];
  static const uint8_t table18_123_emit_[92];
  static const uint8_t table18_124_emit_[72];
  static const uint16_t table18_124_ops_[64];
  static const uint8_t table18_125_emit_[72];
  static const uint8_t table18_126_emit_[72];
  static const uint8_t table18_127_emit_[24];
  static const uint16_t table18_127_ops_[64];
  static const uint8_t* const table18_emit_[128];
  static const uint16_t* const table18_ops_[128];
  static const uint8_t table19_0_emit_[204];
  static const uint16_t table19_0_ops_[128];
  static const uint8_t table19_1_emit_[204];
  static const uint8_t table19_2_emit_[204];
  static const uint8_t table19_3_emit_[204];
  static const uint8_t table19_4_emit_[204];
  static const uint8_t table19_5_emit_[204];
  static const uint8_t table19_6_emit_[204];
  static const uint8_t table19_7_emit_[204];
  static const uint8_t table19_8_emit_[204];
  static const uint8_t table19_9_emit_[204];
  static const uint8_t table19_10_emit_[216];
  static const uint16_t table19_10_ops_[128];
  static const uint8_t table19_11_emit_[216];
  static const uint8_t table19_12_emit_[216];
  static const uint8_t table19_13_emit_[216];
  static const uint8_t table19_14_emit_[216];
  static const uint8_t table19_15_emit_[216];
  static const uint8_t table19_16_emit_[216];
  static const uint8_t table19_17_emit_[216];
  static const uint8_t table19_18_emit_[216];
  static const uint8_t table19_19_emit_[216];
  static const uint8_t table19_20_emit_[216];
  static const uint8_t table19_21_emit_[216];
  static const uint8_t table19_22_emit_[216];
  static const uint8_t table19_23_emit_[120];
  static const uint16_t table19_23_ops_[128];
  static const uint8_t table19_24_emit_[120];
  static const uint8_t table19_25_emit_[120];
  static const uint8_t table19_26_emit_[120];
  static const uint8_t table19_27_emit_[120];
  static const uint8_t table19_28_emit_[120];
  static const uint8_t table19_29_emit_[120];
  static const uint8_t table19_30_emit_[120];
  static const uint8_t table19_31_emit_[31];
  static const uint16_t table19_31_ops_[128];
  static const uint8_t table19_32_emit_[216];
  static const uint8_t table19_33_emit_[216];
  static const uint8_t table19_34_emit_[216];
  static const uint8_t table19_35_emit_[216];
  static const uint8_t table19_36_emit_[216];
  static const uint8_t table19_37_emit_[120];
  static const uint8_t table19_38_emit_[120];
  static const uint8_t table19_39_emit_[120];
  static const uint8_t table19_40_emit_[120];
  static const uint8_t table19_41_emit_[120];
  static const uint8_t table19_42_emit_[120];
  static const uint8_t table19_43_emit_[68];
  static const uint16_t table19_43_ops_[128];
  static const uint16_t table19_44_ops_[128];
  static const uint8_t table19_47_emit_[35];
  static const uint16_t table19_47_ops_[128];
  static const uint8_t table19_48_emit_[216];
  static const uint8_t table19_49_emit_[216];
  static const uint8_t table19_50_emit_[216];
  static const uint8_t table19_51_emit_[216];
  static const uint8_t table19_52_emit_[216];
  static const uint8_t table19_53_emit_[120];
  static const uint8_t table19_54_emit_[120];
  static const uint8_t table19_55_emit_[120];
  static const uint8_t table19_56_emit_[120];
  static const uint8_t table19_57_emit_[120];
  static const uint8_t table19_58_emit_[120];
  static const uint8_t table19_59_emit_[68];
  static const uint8_t table19_63_emit_[35];
  static const uint16_t table19_63_ops_[128];
  static const uint8_t table19_64_emit_[216];
  static const uint8_t table19_65_emit_[216];
  static const uint8_t table19_66_emit_[216];
  static const uint8_t table19_67_emit_[216];
  static const uint8_t table19_68_emit_[216];
  static const uint8_t table19_69_emit_[120];
  static const uint8_t table19_70_emit_[120];
  static const uint8_t table19_71_emit_[120];
  static const uint8_t table19_72_emit_[120];
  static const uint8_t table19_73_emit_[120];
  static const uint8_t table19_74_emit_[120];
  static const uint8_t table19_75_emit_[68];
  static const uint8_t table19_79_emit_[36];
  static const uint16_t table19_79_ops_[128];
  static const uint8_t table19_80_emit_[120];
  static const uint8_t table19_81_emit_[120];
  static const uint8_t table19_82_emit_[68];
  static const uint16_t table19_85_ops_[128];
  static const uint16_t table19_86_ops_[128];
  static const uint8_t table19_87_emit_[46];
  static const uint16_t table19_87_ops_[128];
  static const uint8_t table19_88_emit_[120];
  static const uint8_t table19_89_emit_[120];
  static const uint8_t table19_90_emit_[68];
  static const uint8_t table19_95_emit_[46];
  static const uint16_t table19_97_ops_[128];
  static const uint16_t table19_98_ops_[128];
  static const uint16_t table19_99_ops_[128];
  static const uint16_t table19_120_ops_[128];
  static const uint8_t table19_121_emit_[104];
  static const uint16_t table19_121_ops_[128];
  static const uint8_t table19_123_emit_[104];
  static const uint8_t table19_124_emit_[136];
  static const uint16_t table19_124_ops_[128];
  static const uint8_t table19_125_emit_[136];
  static const uint8_t table19_126_emit_[136];
  static const uint8_t table19_127_emit_[50];
  static const uint16_t table19_127_ops_[128];
  static const uint8_t* const table19_emit_[128];
  static const uint16_t* const table19_ops_[128];
  static const uint8_t table6_0_emit_[1];
  static const uint16_t table6_0_ops_[256];
  static const uint8_t table6_32_emit_[1];
  static const uint16_t table6_32_ops_[256];
  static const uint8_t table6_48_emit_[1];
  static const uint8_t table6_64_emit_[1];
  static const uint8_t table6_80_emit_[1];
  static const uint16_t table6_80_ops_[256];
  static const uint8_t table6_88_emit_[1];
  static const uint8_t table6_96_emit_[1];
  static const uint16_t table6_96_ops_[256];
  static const uint8_t table6_100_emit_[1];
  static const uint8_t table6_104_emit_[1];
  static const uint8_t table6_108_emit_[1];
  static const uint8_t table6_112_emit_[1];
  static const uint8_t table6_116_emit_[1];
  static const uint8_t table6_120_emit_[1];
  static const uint16_t table6_120_ops_[256];
  static const uint8_t table6_122_emit_[1];
  static const uint8_t table6_124_emit_[1];
  static const uint16_t table6_124_ops_[256];
  static const uint8_t table6_125_emit_[1];
  static const uint8_t table6_126_emit_[1];
  static const uint8_t table6_127_emit_[79];
  static const uint16_t table6_127_ops_[256];
  static const uint8_t* const table6_emit_[128];
  static const uint16_t* const table6_ops_[128];
  static const uint8_t table27_0_emit_[8];
  static const uint8_t table27_0_inner_[8];
  static const uint8_t table28_0_emit_[16];
  static const uint8_t table28_0_inner_[16];
  static const uint8_t table31_0_emit_[30];
  static const uint8_t table31_0_ops_[32];
  static const uint8_t table32_0_ops_[64];
  static const uint8_t table29_0_emit_[7];
  static const uint8_t table29_0_ops_[32];
  static const uint8_t table29_1_emit_[8];
  static const uint8_t table29_1_ops_[32];
  static const uint8_t table29_2_emit_[8];
  static const uint8_t table29_3_emit_[10];
  static const uint8_t table29_3_ops_[32];
  static const uint8_t* const table29_emit_[4];
  static const uint8_t* const table29_ops_[4];
  static const uint8_t table34_0_emit_[7];
  static const uint8_t table34_0_inner_[8];
  static const uint8_t table33_0_emit_[9];
  static const uint8_t table33_0_inner_[9];
};
template <typename F>
class HuffDecoder : public HuffDecoderCommon {
 public:
  HuffDecoder(F sink, const uint8_t* begin, const uint8_t* end)
      : sink_(sink), begin_(begin), end_(end) {}
  bool Run() {
    while (!done_) {
      if (!RefillTo8()) {
        Done0();
        break;
      }
      const auto index = (buffer_ >> (buffer_len_ - 8)) & 0xff;
      const auto op = GetOp1(index);
      const int consumed = op & 15;
      buffer_len_ -= consumed;
      const auto emit_ofs = op >> 6;
      switch ((op >> 4) & 3) {
        case 0: {
          sink_(GetEmit1(index, emit_ofs + 0));
          break;
        }
        case 1: {
          DecodeStep0();
          break;
        }
        case 2: {
          DecodeStep1();
          break;
        }
      }
    }
    return ok_;
  }

 private:
  bool RefillTo8() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  bool Read1to8Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  void Fill1() {
    buffer_ = (buffer_ << 8) | (static_cast<uint64_t>(begin_[0]) << 0);
    begin_ += 1;
    buffer_len_ += 8;
  }
  void Fill2() {
    buffer_ = (buffer_ << 16) | (static_cast<uint64_t>(begin_[0]) << 8) |
              (static_cast<uint64_t>(begin_[1]) << 0);
    begin_ += 2;
    buffer_len_ += 16;
  }
  void Fill3() {
    buffer_ = (buffer_ << 24) | (static_cast<uint64_t>(begin_[0]) << 16) |
              (static_cast<uint64_t>(begin_[1]) << 8) |
              (static_cast<uint64_t>(begin_[2]) << 0);
    begin_ += 3;
    buffer_len_ += 24;
  }
  void Fill4() {
    buffer_ = (buffer_ << 32) | (static_cast<uint64_t>(begin_[0]) << 24) |
              (static_cast<uint64_t>(begin_[1]) << 16) |
              (static_cast<uint64_t>(begin_[2]) << 8) |
              (static_cast<uint64_t>(begin_[3]) << 0);
    begin_ += 4;
    buffer_len_ += 32;
  }
  void Fill5() {
    buffer_ = (buffer_ << 40) | (static_cast<uint64_t>(begin_[0]) << 32) |
              (static_cast<uint64_t>(begin_[1]) << 24) |
              (static_cast<uint64_t>(begin_[2]) << 16) |
              (static_cast<uint64_t>(begin_[3]) << 8) |
              (static_cast<uint64_t>(begin_[4]) << 0);
    begin_ += 5;
    buffer_len_ += 40;
  }
  void Fill6() {
    buffer_ = (buffer_ << 48) | (static_cast<uint64_t>(begin_[0]) << 40) |
              (static_cast<uint64_t>(begin_[1]) << 32) |
              (static_cast<uint64_t>(begin_[2]) << 24) |
              (static_cast<uint64_t>(begin_[3]) << 16) |
              (static_cast<uint64_t>(begin_[4]) << 8) |
              (static_cast<uint64_t>(begin_[5]) << 0);
    begin_ += 6;
    buffer_len_ += 48;
  }
  void Fill7() {
    buffer_ = (buffer_ << 56) | (static_cast<uint64_t>(begin_[0]) << 48) |
              (static_cast<uint64_t>(begin_[1]) << 40) |
              (static_cast<uint64_t>(begin_[2]) << 32) |
              (static_cast<uint64_t>(begin_[3]) << 24) |
              (static_cast<uint64_t>(begin_[4]) << 16) |
              (static_cast<uint64_t>(begin_[5]) << 8) |
              (static_cast<uint64_t>(begin_[6]) << 0);
    begin_ += 7;
    buffer_len_ += 56;
  }
  void Fill8() {
    buffer_ = 0 | (static_cast<uint64_t>(begin_[0]) << 56) |
              (static_cast<uint64_t>(begin_[1]) << 48) |
              (static_cast<uint64_t>(begin_[2]) << 40) |
              (static_cast<uint64_t>(begin_[3]) << 32) |
              (static_cast<uint64_t>(begin_[4]) << 24) |
              (static_cast<uint64_t>(begin_[5]) << 16) |
              (static_cast<uint64_t>(begin_[6]) << 8) |
              (static_cast<uint64_t>(begin_[7]) << 0);
    begin_ += 8;
    buffer_len_ += 64;
  }
  bool Read1to7Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  void Done0() {
    done_ = true;
    switch (end_ - begin_) {}
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3:
      case 4: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp2(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit2(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp3(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit3(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp4(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit4(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep0() {
    if (!RefillTo2()) {
      Done1();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp5(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit5(index, emit_ofs + 0));
  }
  bool RefillTo2() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done1() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep1() {
    if (!RefillTo15()) {
      Done2();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 15)) & 0x7fff;
    const auto op = GetOp6(index);
    const int consumed = op & 15;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 8;
    switch ((op >> 4) & 15) {
      case 0: {
        sink_(GetEmit6(index, emit_ofs + 0));
        break;
      }
      case 1: {
        DecodeStep2();
        break;
      }
      case 2: {
        DecodeStep3();
        break;
      }
      case 3: {
        DecodeStep4();
        break;
      }
      case 4: {
        DecodeStep5();
        break;
      }
      case 5: {
        DecodeStep6();
        break;
      }
      case 6: {
        DecodeStep7();
        break;
      }
      case 7: {
        DecodeStep8();
        break;
      }
      case 8: {
        DecodeStep9();
        break;
      }
      case 9: {
        DecodeStep12();
        break;
      }
      case 10: {
        DecodeStep10();
        break;
      }
      case 11: {
        DecodeStep11();
        break;
      }
    }
  }
  bool RefillTo15() {
    switch (buffer_len_) {
      case 0: {
        return Read2to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6: {
        return Read2to7Bytes();
      }
      case 7:
      case 8: {
        return Read1to7Bytes();
      }
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14: {
        return Read1to6Bytes();
      }
    }
    return true;
  }
  bool Read2to8Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  bool Read2to7Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  bool Read1to6Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      default: {
        Fill6();
        return true;
      }
    }
  }
  void Done2() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 2: {
        const auto index = buffer_ & 3;
        const auto op = GetOp7(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit7(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 3: {
        const auto index = buffer_ & 7;
        const auto op = GetOp8(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit8(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 4: {
        const auto index = buffer_ & 15;
        const auto op = GetOp9(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit9(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp10(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit10(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp11(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit11(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp12(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit12(index, (op >> 2) + 0));
            sink_(GetEmit12(index, (op >> 2) + 1));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit12(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp13(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit13(index, (op >> 2) + 0));
            sink_(GetEmit13(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit13(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 9: {
        const auto index = buffer_ & 511;
        const auto op = GetOp14(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit14(index, (op >> 2) + 0));
            sink_(GetEmit14(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit14(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 10: {
        const auto index = buffer_ & 1023;
        const auto op = GetOp15(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit15(index, (op >> 2) + 0));
            sink_(GetEmit15(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit15(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 11: {
        const auto index = buffer_ & 2047;
        const auto op = GetOp16(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit16(index, (op >> 2) + 0));
            sink_(GetEmit16(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit16(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 12: {
        const auto index = buffer_ & 4095;
        const auto op = GetOp17(index);
        switch (op & 7) {
          case 0: {
            sink_(GetEmit17(index, (op >> 3) + 0));
            sink_(GetEmit17(index, (op >> 3) + 1));
            sink_(GetEmit17(index, (op >> 3) + 2));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit17(index, (op >> 3) + 0));
            sink_(GetEmit17(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit17(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 13: {
        const auto index = buffer_ & 8191;
        const auto op = GetOp18(index);
        switch (op & 7) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit18(index, (op >> 3) + 0));
            sink_(GetEmit18(index, (op >> 3) + 1));
            sink_(GetEmit18(index, (op >> 3) + 2));
            break;
          }
          case 2: {
            sink_(GetEmit18(index, (op >> 3) + 0));
            sink_(GetEmit18(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit18(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 14: {
        const auto index = buffer_ & 16383;
        const auto op = GetOp19(index);
        switch (op & 7) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit19(index, (op >> 3) + 0));
            sink_(GetEmit19(index, (op >> 3) + 1));
            sink_(GetEmit19(index, (op >> 3) + 2));
            break;
          }
          case 2: {
            sink_(GetEmit19(index, (op >> 3) + 0));
            sink_(GetEmit19(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit19(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep2() {
    if (!RefillTo1()) {
      Done3();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp20(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit20(index, emit_ofs + 0));
  }
  bool RefillTo1() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
    }
    return true;
  }
  void Done3() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep3() {
    if (!RefillTo1()) {
      Done4();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp21(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit21(index, emit_ofs + 0));
  }
  void Done4() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep4() {
    if (!RefillTo1()) {
      Done5();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp22(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit22(index, emit_ofs + 0));
  }
  void Done5() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep5() {
    if (!RefillTo1()) {
      Done6();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp23(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit23(index, emit_ofs + 0));
  }
  void Done6() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep6() {
    if (!RefillTo1()) {
      Done7();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp24(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit24(index, emit_ofs + 0));
  }
  void Done7() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep7() {
    if (!RefillTo1()) {
      Done8();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp25(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit25(index, emit_ofs + 0));
  }
  void Done8() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep8() {
    if (!RefillTo2()) {
      Done9();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp26(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit26(index, emit_ofs + 0));
  }
  void Done9() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep9() {
    if (!RefillTo3()) {
      Done10();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 3)) & 0x7;
    const auto op = GetOp27(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit27(index, emit_ofs + 0));
  }
  bool RefillTo3() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done10() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 2:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep10() {
    if (!RefillTo4()) {
      Done11();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 4)) & 0xf;
    const auto op = GetOp28(index);
    const int consumed = op & 7;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 3;
    sink_(GetEmit28(index, emit_ofs + 0));
  }
  bool RefillTo4() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2:
      case 3: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done11() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep11() {
    if (!RefillTo7()) {
      Done12();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 7)) & 0x7f;
    const auto op = GetOp29(index);
    const int consumed = op & 7;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 4;
    switch ((op >> 3) & 1) {
      case 0: {
        sink_(GetEmit29(index, emit_ofs + 0));
        break;
      }
      case 1: {
        begin_ = end_;
        buffer_len_ = 0;
        break;
      }
    }
  }
  bool RefillTo7() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done12() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 4: {
        const auto index = buffer_ & 15;
        const auto op = GetOp30(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit30(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp31(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit31(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp32(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit32(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep12() {
    if (!RefillTo4()) {
      Done13();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 4)) & 0xf;
    const auto op = GetOp33(index);
    const int consumed = op & 7;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 3;
    sink_(GetEmit33(index, emit_ofs + 0));
  }
  void Done13() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 2:
      case 0: {
        ok_ = false;
        return;
      }
      case 3: {
        const auto index = buffer_ & 7;
        const auto op = GetOp34(index);
        switch (op & 1) {
          case 0: {
            sink_(GetEmit34(index, (op >> 1) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
    }
  }
  F sink_;
  const uint8_t* begin_;
  const uint8_t* const end_;
  uint64_t buffer_ = 0;
  int buffer_len_ = 0;
  bool ok_ = true;
  bool done_ = false;
};
}  // namespace geometry_8_15_7
}  // namespace grpc_core
#endif  // GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_8_15_7_H
