Turn on kernel logging of matching packets.  When this option is set
for a rule, the Linux kernel will print some information on all
matching packets (like most IP/IPv6 header fields) via the kernel log
(where it can be read with \fIdmesg(1)\fP or read in the syslog).
.PP
This is a "non-terminating target", i.e. rule traversal continues at
the next rule.  So if you want to LOG the packets you refuse, use two
separate rules with the same matching criteria, first using target LOG
then DROP (or REJECT).
.TP
\fB\-\-log\-level\fP \fIlevel\fP
Level of logging, which can be (system-specific) numeric or a mnemonic.
Possible values are (in decreasing order of priority): \fBemerg\fP,
\fBalert\fP, \fBcrit\fP, \fBerror\fP, \fBwarning\fP, \fBnotice\fP, \fBinfo\fP
or \fBdebug\fP.
.TP
\fB\-\-log\-prefix\fP \fIprefix\fP
Prefix log messages with the specified prefix; up to 29 letters long,
and useful for distinguishing messages in the logs.
.TP
\fB\-\-log\-tcp\-sequence\fP
Log TCP sequence numbers. This is a security risk if the log is
readable by users.
.TP
\fB\-\-log\-tcp\-options\fP
Log options from the TCP packet header.
.TP
\fB\-\-log\-ip\-options\fP
Log options from the IP/IPv6 packet header.
.TP
\fB\-\-log\-uid\fP
Log the userid of the process which generated the packet.
.TP
\fB\-\-log\-macdecode\fP
Log MAC addresses and protocol.
