/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.StandardMethodCodec;
import java.util.HashMap;
import java.util.Map;

public class KeyboardChannel {
    public final MethodChannel channel;
    private KeyboardMethodHandler keyboardMethodHandler;
    @NonNull
    public final MethodChannel.MethodCallHandler parsingMethodHandler = new MethodChannel.MethodCallHandler(){
        Map<Long, Long> pressedState = new HashMap<Long, Long>();

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            if (KeyboardChannel.this.keyboardMethodHandler == null) {
                result.success(this.pressedState);
            } else {
                switch (call.method) {
                    case "getKeyboardState": {
                        try {
                            this.pressedState = KeyboardChannel.this.keyboardMethodHandler.getKeyboardState();
                        }
                        catch (IllegalStateException exception) {
                            result.error("error", exception.getMessage(), null);
                        }
                        result.success(this.pressedState);
                        break;
                    }
                    default: {
                        result.notImplemented();
                    }
                }
            }
        }
    };

    public KeyboardChannel(@NonNull BinaryMessenger messenger) {
        this.channel = new MethodChannel(messenger, "flutter/keyboard", StandardMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.parsingMethodHandler);
    }

    public void setKeyboardMethodHandler(@Nullable KeyboardMethodHandler keyboardMethodHandler) {
        this.keyboardMethodHandler = keyboardMethodHandler;
    }

    public static interface KeyboardMethodHandler {
        public Map<Long, Long> getKeyboardState();
    }
}

