/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.renderer;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.SyncFence;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;
import io.flutter.embedding.engine.renderer.SurfaceTextureWrapper;
import io.flutter.view.TextureRegistry;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class FlutterRenderer
implements TextureRegistry {
    private static final String TAG = "FlutterRenderer";
    @NonNull
    private final FlutterJNI flutterJNI;
    @NonNull
    private final AtomicLong nextTextureId = new AtomicLong(0L);
    @Nullable
    private Surface surface;
    private boolean isDisplayingFlutterUi = false;
    private int isRenderingToImageViewCount = 0;
    private Handler handler = new Handler();
    @NonNull
    private final Set<WeakReference<TextureRegistry.OnTrimMemoryListener>> onTrimMemoryListeners = new HashSet<WeakReference<TextureRegistry.OnTrimMemoryListener>>();
    @NonNull
    private final FlutterUiDisplayListener flutterUiDisplayListener = new FlutterUiDisplayListener(){

        @Override
        public void onFlutterUiDisplayed() {
            FlutterRenderer.this.isDisplayingFlutterUi = true;
        }

        @Override
        public void onFlutterUiNoLongerDisplayed() {
            FlutterRenderer.this.isDisplayingFlutterUi = false;
        }
    };

    public FlutterRenderer(@NonNull FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
        this.flutterJNI.addIsDisplayingFlutterUiListener(this.flutterUiDisplayListener);
    }

    public boolean isDisplayingFlutterUi() {
        return this.isDisplayingFlutterUi;
    }

    public void SetRenderingToImageView(boolean value) {
        this.isRenderingToImageViewCount = value ? ++this.isRenderingToImageViewCount : --this.isRenderingToImageViewCount;
        this.flutterJNI.SetIsRenderingToImageView(this.isRenderingToImageViewCount > 0);
    }

    public void addIsDisplayingFlutterUiListener(@NonNull FlutterUiDisplayListener listener) {
        this.flutterJNI.addIsDisplayingFlutterUiListener(listener);
        if (this.isDisplayingFlutterUi) {
            listener.onFlutterUiDisplayed();
        }
    }

    public void removeIsDisplayingFlutterUiListener(@NonNull FlutterUiDisplayListener listener) {
        this.flutterJNI.removeIsDisplayingFlutterUiListener(listener);
    }

    private void clearDeadListeners() {
        Iterator<WeakReference<TextureRegistry.OnTrimMemoryListener>> iterator = this.onTrimMemoryListeners.iterator();
        while (iterator.hasNext()) {
            WeakReference<TextureRegistry.OnTrimMemoryListener> listenerRef = iterator.next();
            TextureRegistry.OnTrimMemoryListener listener = (TextureRegistry.OnTrimMemoryListener)listenerRef.get();
            if (listener != null) continue;
            iterator.remove();
        }
    }

    @VisibleForTesting
    void addOnTrimMemoryListener(@NonNull TextureRegistry.OnTrimMemoryListener listener) {
        this.clearDeadListeners();
        this.onTrimMemoryListeners.add(new WeakReference<TextureRegistry.OnTrimMemoryListener>(listener));
    }

    @VisibleForTesting
    void removeOnTrimMemoryListener(@NonNull TextureRegistry.OnTrimMemoryListener listener) {
        for (WeakReference<TextureRegistry.OnTrimMemoryListener> listenerRef : this.onTrimMemoryListeners) {
            if (listenerRef.get() != listener) continue;
            this.onTrimMemoryListeners.remove(listenerRef);
            break;
        }
    }

    @Override
    public TextureRegistry.SurfaceProducer createSurfaceProducer() {
        ImageReaderSurfaceProducer entry = new ImageReaderSurfaceProducer(this.nextTextureId.getAndIncrement());
        Log.v(TAG, "New SurfaceProducer ID: " + entry.id());
        this.registerImageTexture(entry.id(), entry);
        return entry;
    }

    @Override
    public TextureRegistry.SurfaceTextureEntry createSurfaceTexture() {
        Log.v(TAG, "Creating a SurfaceTexture.");
        SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        return this.registerSurfaceTexture(surfaceTexture);
    }

    @Override
    public TextureRegistry.SurfaceTextureEntry registerSurfaceTexture(@NonNull SurfaceTexture surfaceTexture) {
        surfaceTexture.detachFromGLContext();
        SurfaceTextureRegistryEntry entry = new SurfaceTextureRegistryEntry(this.nextTextureId.getAndIncrement(), surfaceTexture);
        Log.v(TAG, "New SurfaceTexture ID: " + entry.id());
        this.registerTexture(entry.id(), entry.textureWrapper());
        this.addOnTrimMemoryListener(entry);
        return entry;
    }

    @Override
    public TextureRegistry.ImageTextureEntry createImageTexture() {
        ImageTextureRegistryEntry entry = new ImageTextureRegistryEntry(this.nextTextureId.getAndIncrement());
        Log.v(TAG, "New ImageTextureEntry ID: " + entry.id());
        this.registerImageTexture(entry.id(), entry);
        return entry;
    }

    @Override
    public void onTrimMemory(int level) {
        Iterator<WeakReference<TextureRegistry.OnTrimMemoryListener>> iterator = this.onTrimMemoryListeners.iterator();
        while (iterator.hasNext()) {
            WeakReference<TextureRegistry.OnTrimMemoryListener> listenerRef = iterator.next();
            TextureRegistry.OnTrimMemoryListener listener = (TextureRegistry.OnTrimMemoryListener)listenerRef.get();
            if (listener != null) {
                listener.onTrimMemory(level);
                continue;
            }
            iterator.remove();
        }
    }

    public void startRenderingToSurface(@NonNull Surface surface, boolean onlySwap) {
        if (!onlySwap) {
            this.stopRenderingToSurface();
        }
        this.surface = surface;
        if (onlySwap) {
            this.flutterJNI.onSurfaceWindowChanged(surface);
        } else {
            this.flutterJNI.onSurfaceCreated(surface);
        }
    }

    public void swapSurface(@NonNull Surface surface) {
        this.surface = surface;
        this.flutterJNI.onSurfaceWindowChanged(surface);
    }

    public void surfaceChanged(int width, int height) {
        this.flutterJNI.onSurfaceChanged(width, height);
    }

    public void stopRenderingToSurface() {
        if (this.surface != null) {
            this.flutterJNI.onSurfaceDestroyed();
            if (this.isDisplayingFlutterUi) {
                this.flutterUiDisplayListener.onFlutterUiNoLongerDisplayed();
            }
            this.isDisplayingFlutterUi = false;
            this.surface = null;
        }
    }

    public void setViewportMetrics(@NonNull ViewportMetrics viewportMetrics) {
        if (!viewportMetrics.validate()) {
            return;
        }
        Log.v(TAG, "Setting viewport metrics\nSize: " + viewportMetrics.width + " x " + viewportMetrics.height + "\nPadding - L: " + viewportMetrics.viewPaddingLeft + ", T: " + viewportMetrics.viewPaddingTop + ", R: " + viewportMetrics.viewPaddingRight + ", B: " + viewportMetrics.viewPaddingBottom + "\nInsets - L: " + viewportMetrics.viewInsetLeft + ", T: " + viewportMetrics.viewInsetTop + ", R: " + viewportMetrics.viewInsetRight + ", B: " + viewportMetrics.viewInsetBottom + "\nSystem Gesture Insets - L: " + viewportMetrics.systemGestureInsetLeft + ", T: " + viewportMetrics.systemGestureInsetTop + ", R: " + viewportMetrics.systemGestureInsetRight + ", B: " + viewportMetrics.systemGestureInsetRight + "\nDisplay Features: " + viewportMetrics.displayFeatures.size());
        int[] displayFeaturesBounds = new int[viewportMetrics.displayFeatures.size() * 4];
        int[] displayFeaturesType = new int[viewportMetrics.displayFeatures.size()];
        int[] displayFeaturesState = new int[viewportMetrics.displayFeatures.size()];
        for (int i = 0; i < viewportMetrics.displayFeatures.size(); ++i) {
            DisplayFeature displayFeature = viewportMetrics.displayFeatures.get(i);
            displayFeaturesBounds[4 * i] = displayFeature.bounds.left;
            displayFeaturesBounds[4 * i + 1] = displayFeature.bounds.top;
            displayFeaturesBounds[4 * i + 2] = displayFeature.bounds.right;
            displayFeaturesBounds[4 * i + 3] = displayFeature.bounds.bottom;
            displayFeaturesType[i] = displayFeature.type.encodedValue;
            displayFeaturesState[i] = displayFeature.state.encodedValue;
        }
        this.flutterJNI.setViewportMetrics(viewportMetrics.devicePixelRatio, viewportMetrics.width, viewportMetrics.height, viewportMetrics.viewPaddingTop, viewportMetrics.viewPaddingRight, viewportMetrics.viewPaddingBottom, viewportMetrics.viewPaddingLeft, viewportMetrics.viewInsetTop, viewportMetrics.viewInsetRight, viewportMetrics.viewInsetBottom, viewportMetrics.viewInsetLeft, viewportMetrics.systemGestureInsetTop, viewportMetrics.systemGestureInsetRight, viewportMetrics.systemGestureInsetBottom, viewportMetrics.systemGestureInsetLeft, viewportMetrics.physicalTouchSlop, displayFeaturesBounds, displayFeaturesType, displayFeaturesState);
    }

    public Bitmap getBitmap() {
        return this.flutterJNI.getBitmap();
    }

    public void dispatchPointerDataPacket(@NonNull ByteBuffer buffer, int position) {
        this.flutterJNI.dispatchPointerDataPacket(buffer, position);
    }

    private void registerTexture(long textureId, @NonNull SurfaceTextureWrapper textureWrapper) {
        this.flutterJNI.registerTexture(textureId, textureWrapper);
    }

    private void registerImageTexture(long textureId, @NonNull TextureRegistry.ImageConsumer imageTexture) {
        this.flutterJNI.registerImageTexture(textureId, imageTexture);
    }

    private void markTextureFrameAvailable(long textureId) {
        this.flutterJNI.markTextureFrameAvailable(textureId);
    }

    private void unregisterTexture(long textureId) {
        this.flutterJNI.unregisterTexture(textureId);
    }

    public boolean isSoftwareRenderingEnabled() {
        return this.flutterJNI.getIsSoftwareRenderingEnabled();
    }

    public void setAccessibilityFeatures(int flags) {
        this.flutterJNI.setAccessibilityFeatures(flags);
    }

    public void setSemanticsEnabled(boolean enabled) {
        this.flutterJNI.setSemanticsEnabled(enabled);
    }

    public void dispatchSemanticsAction(int nodeId, int action, @Nullable ByteBuffer args, int argsPosition) {
        this.flutterJNI.dispatchSemanticsAction(nodeId, action, args, argsPosition);
    }

    @Keep
    @TargetApi(value=29)
    final class ImageReaderSurfaceProducer
    implements TextureRegistry.SurfaceProducer,
    TextureRegistry.ImageConsumer {
        private static final String TAG = "ImageReaderSurfaceProducer";
        private static final int MAX_IMAGES = 4;
        private final long id;
        private boolean released;
        private boolean ignoringFence = false;
        private int requestedWidth = 0;
        private int requestedHeight = 0;
        private ImageReader activeReader;
        private final Set<ImageReader> readersToClose = new HashSet<ImageReader>();
        private PerImage lastProducedImage;
        private PerImage lastConsumedImage;
        private final Handler onImageAvailableHandler = new Handler();
        private final ImageReader.OnImageAvailableListener onImageAvailableListener = new ImageReader.OnImageAvailableListener(){

            public void onImageAvailable(ImageReader reader) {
                Image image = null;
                try {
                    image = reader.acquireLatestImage();
                }
                catch (IllegalStateException e) {
                    Log.e(ImageReaderSurfaceProducer.TAG, "onImageAvailable acquireLatestImage failed: " + e.toString());
                }
                if (image == null) {
                    return;
                }
                ImageReaderSurfaceProducer.this.onImage(new PerImage(reader, image));
            }
        };

        ImageReaderSurfaceProducer(long id) {
            this.id = id;
        }

        @Override
        public long id() {
            return this.id;
        }

        private void releaseInternal() {
            this.released = true;
            if (this.lastProducedImage != null) {
                this.lastProducedImage.close();
                this.lastProducedImage = null;
            }
            if (this.lastConsumedImage != null) {
                this.lastConsumedImage.close();
                this.lastConsumedImage = null;
            }
            for (ImageReader reader : this.readersToClose) {
                reader.close();
            }
            this.readersToClose.clear();
            if (this.activeReader != null) {
                this.activeReader.close();
                this.activeReader = null;
            }
        }

        @Override
        public void release() {
            if (this.released) {
                return;
            }
            this.releaseInternal();
            FlutterRenderer.this.unregisterTexture(this.id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSize(int width, int height) {
            if (this.requestedWidth == width && this.requestedHeight == height) {
                return;
            }
            this.requestedHeight = height;
            this.requestedWidth = width;
            ImageReaderSurfaceProducer imageReaderSurfaceProducer = this;
            synchronized (imageReaderSurfaceProducer) {
                if (this.activeReader != null) {
                    this.readersToClose.add(this.activeReader);
                    this.activeReader = null;
                }
            }
        }

        @Override
        public int getWidth() {
            return this.requestedWidth;
        }

        @Override
        public int getHeight() {
            return this.requestedHeight;
        }

        @Override
        public Surface getSurface() {
            this.maybeCreateReader();
            return this.activeReader.getSurface();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TargetApi(value=29)
        public Image acquireLatestImage() {
            PerImage toClose;
            PerImage r;
            ImageReaderSurfaceProducer imageReaderSurfaceProducer = this;
            synchronized (imageReaderSurfaceProducer) {
                r = this.lastProducedImage;
                this.lastProducedImage = null;
                toClose = this.lastConsumedImage;
                this.lastConsumedImage = r;
            }
            if (toClose != null) {
                toClose.close();
            }
            if (r == null) {
                return null;
            }
            this.maybeWaitOnFence(r.image);
            return r.image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeCloseReader(ImageReader reader) {
            ImageReaderSurfaceProducer imageReaderSurfaceProducer = this;
            synchronized (imageReaderSurfaceProducer) {
                if (!this.readersToClose.contains(reader)) {
                    return;
                }
                if (this.lastConsumedImage != null && this.lastConsumedImage.reader == reader) {
                    return;
                }
                if (this.lastProducedImage != null && this.lastProducedImage.reader == reader) {
                    return;
                }
                this.readersToClose.remove(reader);
            }
            reader.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeCreateReader() {
            ImageReaderSurfaceProducer imageReaderSurfaceProducer = this;
            synchronized (imageReaderSurfaceProducer) {
                if (this.activeReader != null) {
                    return;
                }
                this.activeReader = this.createImageReader();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onImage(PerImage image) {
            PerImage toClose;
            if (this.released) {
                return;
            }
            ImageReaderSurfaceProducer imageReaderSurfaceProducer = this;
            synchronized (imageReaderSurfaceProducer) {
                if (this.readersToClose.contains(image.reader)) {
                    Log.i(TAG, "Skipped frame because resize is in flight.");
                    image.close();
                    return;
                }
                toClose = this.lastProducedImage;
                this.lastProducedImage = image;
            }
            if (toClose != null) {
                Log.i(TAG, "Dropping rendered frame that was not acquired in time.");
                toClose.close();
            }
            if (image != null) {
                FlutterRenderer.this.markTextureFrameAvailable(this.id);
            }
        }

        @TargetApi(value=33)
        private void waitOnFence(Image image) {
            try {
                SyncFence fence = image.getFence();
                boolean signaled = fence.awaitForever();
                if (!signaled) {
                    Log.e(TAG, "acquireLatestImage image's fence was never signalled.");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void maybeWaitOnFence(Image image) {
            if (image == null) {
                return;
            }
            if (this.ignoringFence) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 33) {
                this.waitOnFence(image);
                return;
            }
            if (!this.ignoringFence) {
                this.ignoringFence = true;
                Log.w(TAG, "ImageTextureEntry can't wait on the fence on Android < 33");
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (this.released) {
                    return;
                }
                this.releaseInternal();
                FlutterRenderer.this.handler.post((Runnable)new TextureFinalizerRunnable(this.id, FlutterRenderer.this.flutterJNI));
            }
            finally {
                super.finalize();
            }
        }

        @TargetApi(value=33)
        private ImageReader createImageReader33() {
            ImageReader.Builder builder = new ImageReader.Builder(this.requestedWidth, this.requestedHeight);
            builder.setMaxImages(4);
            builder.setImageFormat(34);
            builder.setUsage(256L);
            ImageReader reader = builder.build();
            reader.setOnImageAvailableListener(this.onImageAvailableListener, this.onImageAvailableHandler);
            return reader;
        }

        @TargetApi(value=29)
        private ImageReader createImageReader29() {
            ImageReader reader = ImageReader.newInstance((int)this.requestedWidth, (int)this.requestedHeight, (int)34, (int)4, (long)256L);
            reader.setOnImageAvailableListener(this.onImageAvailableListener, this.onImageAvailableHandler);
            return reader;
        }

        private ImageReader createImageReader() {
            if (Build.VERSION.SDK_INT >= 33) {
                return this.createImageReader33();
            }
            if (Build.VERSION.SDK_INT >= 29) {
                return this.createImageReader29();
            }
            throw new UnsupportedOperationException("ImageReaderPlatformViewRenderTarget requires API version 29+");
        }

        @VisibleForTesting
        public void disableFenceForTest() {
            this.ignoringFence = true;
        }

        @VisibleForTesting
        public int readersToCloseSize() {
            return this.readersToClose.size();
        }

        private class PerImage {
            public final ImageReader reader;
            public final Image image;

            public PerImage(ImageReader reader, Image image) {
                this.reader = reader;
                this.image = image;
            }

            public void close() {
                this.image.close();
                ImageReaderSurfaceProducer.this.maybeCloseReader(this.reader);
            }
        }
    }

    final class SurfaceTextureRegistryEntry
    implements TextureRegistry.SurfaceTextureEntry,
    TextureRegistry.OnTrimMemoryListener {
        private final long id;
        @NonNull
        private final SurfaceTextureWrapper textureWrapper;
        private boolean released;
        @Nullable
        private TextureRegistry.OnTrimMemoryListener trimMemoryListener;
        @Nullable
        private TextureRegistry.OnFrameConsumedListener frameConsumedListener;
        private final Runnable onFrameConsumed = new Runnable(){

            @Override
            public void run() {
                if (SurfaceTextureRegistryEntry.this.frameConsumedListener != null) {
                    SurfaceTextureRegistryEntry.this.frameConsumedListener.onFrameConsumed();
                }
            }
        };
        private SurfaceTexture.OnFrameAvailableListener onFrameListener = new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(@NonNull SurfaceTexture texture) {
                if (SurfaceTextureRegistryEntry.this.released || !FlutterRenderer.this.flutterJNI.isAttached()) {
                    return;
                }
                FlutterRenderer.this.markTextureFrameAvailable(SurfaceTextureRegistryEntry.this.id);
            }
        };

        SurfaceTextureRegistryEntry(@NonNull long id, SurfaceTexture surfaceTexture) {
            this.id = id;
            this.textureWrapper = new SurfaceTextureWrapper(surfaceTexture, this.onFrameConsumed);
            if (Build.VERSION.SDK_INT >= 21) {
                this.surfaceTexture().setOnFrameAvailableListener(this.onFrameListener, new Handler());
            } else {
                this.surfaceTexture().setOnFrameAvailableListener(this.onFrameListener);
            }
        }

        @Override
        public void onTrimMemory(int level) {
            if (this.trimMemoryListener != null) {
                this.trimMemoryListener.onTrimMemory(level);
            }
        }

        private void removeListener() {
            FlutterRenderer.this.removeOnTrimMemoryListener(this);
        }

        @NonNull
        public SurfaceTextureWrapper textureWrapper() {
            return this.textureWrapper;
        }

        @Override
        @NonNull
        public SurfaceTexture surfaceTexture() {
            return this.textureWrapper.surfaceTexture();
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public void release() {
            if (this.released) {
                return;
            }
            Log.v(FlutterRenderer.TAG, "Releasing a SurfaceTexture (" + this.id + ").");
            this.textureWrapper.release();
            FlutterRenderer.this.unregisterTexture(this.id);
            this.removeListener();
            this.released = true;
        }

        protected void finalize() throws Throwable {
            try {
                if (this.released) {
                    return;
                }
                FlutterRenderer.this.handler.post((Runnable)new TextureFinalizerRunnable(this.id, FlutterRenderer.this.flutterJNI));
            }
            finally {
                super.finalize();
            }
        }

        @Override
        public void setOnFrameConsumedListener(@Nullable TextureRegistry.OnFrameConsumedListener listener) {
            this.frameConsumedListener = listener;
        }

        @Override
        public void setOnTrimMemoryListener(@Nullable TextureRegistry.OnTrimMemoryListener listener) {
            this.trimMemoryListener = listener;
        }
    }

    @Keep
    final class ImageTextureRegistryEntry
    implements TextureRegistry.ImageTextureEntry,
    TextureRegistry.ImageConsumer {
        private static final String TAG = "ImageTextureRegistryEntry";
        private final long id;
        private boolean released;
        private boolean ignoringFence = false;
        private Image image;

        ImageTextureRegistryEntry(long id) {
            this.id = id;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        @TargetApi(value=19)
        public void release() {
            if (this.released) {
                return;
            }
            this.released = true;
            if (this.image != null) {
                this.image.close();
                this.image = null;
            }
            FlutterRenderer.this.unregisterTexture(this.id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TargetApi(value=19)
        public void pushImage(Image image) {
            Image toClose;
            if (this.released) {
                return;
            }
            ImageTextureRegistryEntry imageTextureRegistryEntry = this;
            synchronized (imageTextureRegistryEntry) {
                toClose = this.image;
                this.image = image;
            }
            if (toClose != null) {
                Log.e(TAG, "Dropping PlatformView Frame");
                toClose.close();
            }
            if (image != null) {
                FlutterRenderer.this.markTextureFrameAvailable(this.id);
            }
        }

        @TargetApi(value=33)
        private void waitOnFence(Image image) {
            try {
                SyncFence fence = image.getFence();
                boolean signaled = fence.awaitForever();
                if (!signaled) {
                    Log.e(TAG, "acquireLatestImage image's fence was never signalled.");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @TargetApi(value=29)
        private void maybeWaitOnFence(Image image) {
            if (image == null) {
                return;
            }
            if (this.ignoringFence) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 33) {
                this.waitOnFence(image);
                return;
            }
            if (!this.ignoringFence) {
                this.ignoringFence = true;
                Log.w(TAG, "ImageTextureEntry can't wait on the fence on Android < 33");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TargetApi(value=29)
        public Image acquireLatestImage() {
            Image r;
            ImageTextureRegistryEntry imageTextureRegistryEntry = this;
            synchronized (imageTextureRegistryEntry) {
                r = this.image;
                this.image = null;
            }
            this.maybeWaitOnFence(r);
            return r;
        }

        @TargetApi(value=19)
        protected void finalize() throws Throwable {
            try {
                if (this.released) {
                    return;
                }
                if (this.image != null) {
                    this.image.close();
                    this.image = null;
                }
                this.released = true;
                FlutterRenderer.this.handler.post((Runnable)new TextureFinalizerRunnable(this.id, FlutterRenderer.this.flutterJNI));
            }
            finally {
                super.finalize();
            }
        }
    }

    public static final class ViewportMetrics {
        public static final int unsetValue = -1;
        public float devicePixelRatio = 1.0f;
        public int width = 0;
        public int height = 0;
        public int viewPaddingTop = 0;
        public int viewPaddingRight = 0;
        public int viewPaddingBottom = 0;
        public int viewPaddingLeft = 0;
        public int viewInsetTop = 0;
        public int viewInsetRight = 0;
        public int viewInsetBottom = 0;
        public int viewInsetLeft = 0;
        public int systemGestureInsetTop = 0;
        public int systemGestureInsetRight = 0;
        public int systemGestureInsetBottom = 0;
        public int systemGestureInsetLeft = 0;
        public int physicalTouchSlop = -1;
        public List<DisplayFeature> displayFeatures = new ArrayList<DisplayFeature>();

        boolean validate() {
            return this.width > 0 && this.height > 0 && this.devicePixelRatio > 0.0f;
        }
    }

    public static final class DisplayFeature {
        public final Rect bounds;
        public final DisplayFeatureType type;
        public final DisplayFeatureState state;

        public DisplayFeature(Rect bounds, DisplayFeatureType type, DisplayFeatureState state) {
            this.bounds = bounds;
            this.type = type;
            this.state = state;
        }

        public DisplayFeature(Rect bounds, DisplayFeatureType type) {
            this.bounds = bounds;
            this.type = type;
            this.state = DisplayFeatureState.UNKNOWN;
        }
    }

    public static enum DisplayFeatureType {
        UNKNOWN(0),
        FOLD(1),
        HINGE(2),
        CUTOUT(3);

        public final int encodedValue;

        private DisplayFeatureType(int encodedValue) {
            this.encodedValue = encodedValue;
        }
    }

    public static enum DisplayFeatureState {
        UNKNOWN(0),
        POSTURE_FLAT(1),
        POSTURE_HALF_OPENED(2);

        public final int encodedValue;

        private DisplayFeatureState(int encodedValue) {
            this.encodedValue = encodedValue;
        }
    }

    static final class TextureFinalizerRunnable
    implements Runnable {
        private final long id;
        private final FlutterJNI flutterJNI;

        TextureFinalizerRunnable(long id, @NonNull FlutterJNI flutterJNI) {
            this.id = id;
            this.flutterJNI = flutterJNI;
        }

        @Override
        public void run() {
            if (!this.flutterJNI.isAttached()) {
                return;
            }
            Log.v(FlutterRenderer.TAG, "Releasing a Texture (" + this.id + ").");
            this.flutterJNI.unregisterTexture(this.id);
        }
    }
}

