/* Generated by re2c */
// re2c $INPUT -o $OUTPUT -igcd --flex-syntax
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2014 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef PHP_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "tsrm_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16

#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable, CG(doc_comment_len) can be reused */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) CG(doc_comment_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    CG(doc_comment_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x7F)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	assert(internal_encoding && zend_multibyte_check_lexer_compatibility(internal_encoding));
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding) TSRMLS_CC);
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding) TSRMLS_CC);
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8 TSRMLS_CC);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	assert(internal_encoding && zend_multibyte_check_lexer_compatibility(internal_encoding));
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8 TSRMLS_CC);
}


static void _yy_push_state(int new_state TSRMLS_DC)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION(), sizeof(int));
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(TSRMLS_D)
{
	int *stack_state;
	zend_stack_top(&SCNG(state_stack), (void **) &stack_state);
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len TSRMLS_DC)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(TSRMLS_D)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(doc_comment_len) = 0;
	zend_stack_init(&SCNG(state_stack));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(TSRMLS_D)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename(TSRMLS_C);
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename TSRMLS_CC);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle TSRMLS_DC)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size TSRMLS_DC)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	while ((p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	while ((p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(TSRMLS_D)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while (pos1 - pos2 >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size) TSRMLS_CC);
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(TSRMLS_D)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode(TSRMLS_C);
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size) TSRMLS_CC);
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding(TSRMLS_C);

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle TSRMLS_DC)
{
	const char *file_path = NULL;
	char *buf;
	size_t size, offset = 0;

	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == -1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != -1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL TSRMLS_CC);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf - offset;
		yy_scan_buffer(buf, size TSRMLS_CC);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		file_path = file_handle->opened_path;
	} else {
		file_path = file_handle->filename;
	}

	zend_set_compiled_filename(file_path TSRMLS_CC);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	RESET_DOC_COMMENT();
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()


ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval=NULL;
	int compiler_result;
	zend_bool compilation_successful=0;
	znode retval_znode;
	zend_bool original_in_compilation = CG(in_compilation);

	retval_znode.op_type = IS_CONST;
	retval_znode.u.constant.type = IS_LONG;
	retval_znode.u.constant.value.lval = 1;
	Z_UNSET_ISREF(retval_znode.u.constant);
	Z_SET_REFCOUNT(retval_znode.u.constant, 1);

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);

	retval = op_array; /* success oriented */

	if (open_file_for_scanning(file_handle TSRMLS_CC)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename TSRMLS_CC);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename TSRMLS_CC);
		}
		compilation_successful=0;
	} else {
		init_op_array(op_array, ZEND_USER_FUNCTION, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(in_compilation) = 1;
		CG(active_op_array) = op_array;
		zend_stack_push(&CG(context_stack), (void *) &CG(context), sizeof(CG(context)));
		zend_init_compiler_context(TSRMLS_C);
		compiler_result = zendparse(TSRMLS_C);
		zend_do_return(&retval_znode, 0 TSRMLS_CC);
		CG(in_compilation) = original_in_compilation;
		if (compiler_result != 0) { /* parser error */
			zend_bailout();
		}
		compilation_successful=1;
	}

	if (retval) {
		CG(active_op_array) = original_active_op_array;
		if (compilation_successful) {
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(0 TSRMLS_CC);
		} else {
			efree(op_array);
			retval = NULL;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return retval;
}


zend_op_array *compile_filename(int type, zval *filename TSRMLS_DC)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	char *opened_path = NULL;

	if (filename->type != IS_STRING) {
		tmp = *filename;
		zval_copy_ctor(&tmp);
		convert_to_string(&tmp);
		filename = &tmp;
	}
	file_handle.filename = filename->value.str.val;
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type TSRMLS_CC);
	if (retval && file_handle.handle.stream.handle) {
		int dummy = 1;

		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = estrndup(filename->value.str.val, filename->value.str.len);
		}

		zend_hash_add(&EG(included_files), file_handle.opened_path, strlen(file_handle.opened_path)+1, (void *)&dummy, sizeof(int), NULL);

		if (opened_path) {
			efree(opened_path);
		}
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);

	if (filename==&tmp) {
		zval_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename TSRMLS_DC)
{
	char *buf;
	size_t size;

	/* enforce two trailing NULLs for flex... */
	if (IS_INTERNED(str->value.str.val)) {
		char *tmp = safe_emalloc(1, str->value.str.len, ZEND_MMAP_AHEAD);
		memcpy(tmp, str->value.str.val, str->value.str.len + ZEND_MMAP_AHEAD);
		str->value.str.val = tmp;
	} else {
		str->value.str.val = safe_erealloc(str->value.str.val, 1, str->value.str.len, ZEND_MMAP_AHEAD);
	}

	memset(str->value.str.val + str->value.str.len, 0, ZEND_MMAP_AHEAD);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = str->value.str.val;
	size = str->value.str.len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding(TSRMLS_C) TSRMLS_CC);

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, size TSRMLS_CC);

	zend_set_compiled_filename(filename TSRMLS_CC);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(TSRMLS_D)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset TSRMLS_CC)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}


zend_op_array *compile_string(zval *source_string, char *filename TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval;
	zval tmp;
	int compiler_result;
	zend_bool original_in_compilation = CG(in_compilation);

	if (source_string->value.str.len==0) {
		efree(op_array);
		return NULL;
	}

	CG(in_compilation) = 1;

	tmp = *source_string;
	zval_copy_ctor(&tmp);
	convert_to_string(&tmp);
	source_string = &tmp;

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(source_string, filename TSRMLS_CC)==FAILURE) {
		efree(op_array);
		retval = NULL;
	} else {
		zend_bool orig_interactive = CG(interactive);

		CG(interactive) = 0;
		init_op_array(op_array, ZEND_EVAL_CODE, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(interactive) = orig_interactive;
		CG(active_op_array) = op_array;
		zend_stack_push(&CG(context_stack), (void *) &CG(context), sizeof(CG(context)));
		zend_init_compiler_context(TSRMLS_C);
		BEGIN(ST_IN_SCRIPTING);
		compiler_result = zendparse(TSRMLS_C);

		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}

		if (compiler_result != 0) {
			CG(active_op_array) = original_active_op_array;
			CG(unclean_shutdown)=1;
			destroy_op_array(op_array TSRMLS_CC);
			efree(op_array);
			retval = NULL;
		} else {
			zend_do_return(NULL, 0 TSRMLS_CC);
			CG(active_op_array) = original_active_op_array;
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(0 TSRMLS_CC);
			retval = op_array;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(&tmp);
	CG(in_compilation) = original_in_compilation;
	return retval;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (open_file_for_scanning(&file_handle TSRMLS_CC)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename TSRMLS_CC);
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zval tmp = *str;

	str = &tmp;
	zval_copy_ctor(str);
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(str, str_name TSRMLS_CC)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(str);
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding TSRMLS_DC)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + (SCNG(yy_limit) - SCNG(yy_start));

	SCNG(yy_start) = new_yy_start;
}


# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC); \
		zendlval->value.str.len = sz; \
	} else { \
		zendlval->value.str.val = (char *) estrndup(yytext, yyleng); \
		zendlval->value.str.len = yyleng; \
	}

static void zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type TSRMLS_DC)
{
	register char *s, *t;
	char *end;

	ZVAL_STRINGL(zendlval, str, len, 1);

	/* convert escape sequences */
	s = t = zendlval->value.str.val;
	end = s+zendlval->value.str.len;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					zendlval->value.str.len--;
					break;
				case 'r':
					*t++ = '\r';
					zendlval->value.str.len--;
					break;
				case 't':
					*t++ = '\t';
					zendlval->value.str.len--;
					break;
				case 'f':
					*t++ = '\f';
					zendlval->value.str.len--;
					break;
				case 'v':
					*t++ = '\v';
					zendlval->value.str.len--;
					break;
				case 'e':
#ifdef PHP_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					zendlval->value.str.len--;
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					zendlval->value.str.len--;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						zendlval->value.str.len--; /* for the 'x' */

						hex_buf[0] = *(++s);
						zendlval->value.str.len--;
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
							zendlval->value.str.len--;
						}
						*t++ = (char) strtol(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						zendlval->value.str.len--;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							zendlval->value.str.len--;
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
								zendlval->value.str.len--;
							}
						}
						*t++ = (char) strtol(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = zendlval->value.str.val;
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)s, (size_t)zendlval->value.str.len TSRMLS_CC);
		zendlval->value.str.len = sz;
		efree(s);
	}
}


int lex_scan(zval *zendlval TSRMLS_DC)
{
restart:
	SCNG(yy_text) = YYCURSOR;

yymore_restart:


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static void *yyctable[10] = {
		&&yyc_ST_IN_SCRIPTING,
		&&yyc_ST_LOOKING_FOR_PROPERTY,
		&&yyc_ST_BACKQUOTE,
		&&yyc_ST_DOUBLE_QUOTES,
		&&yyc_ST_HEREDOC,
		&&yyc_ST_LOOKING_FOR_VARNAME,
		&&yyc_ST_VAR_OFFSET,
		&&yyc_INITIAL,
		&&yyc_ST_END_HEREDOC,
		&&yyc_ST_NOWDOC,
	};
	static const unsigned char yybm_ST_IN_SCRIPTING[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  36,   4,   0,   0,   4,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		 36,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		216, 216, 152, 152, 152, 152, 152, 152, 
		152, 152,   0,   0,   0,   0,   0,   0, 
		  0, 144, 144, 144, 144, 144, 144,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,   0,   0,   0,   0,  16, 
		  0, 144, 144, 144, 144, 144, 144,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,   0,   0,   0,   0,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
	};
	static const unsigned char yybm_ST_LOOKING_FOR_PROPERTY[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  64,  64,   0,   0,  64,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		 64,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128,   0,   0,   0,   0,   0,   0, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0, 128, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
	};
	static const unsigned char yybm_ST_BACKQUOTE[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128,   0,   0,   0,   0,   0,   0, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0, 128, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
	};
	static const unsigned char yybm_ST_DOUBLE_QUOTES[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128,   0,   0,   0,   0,   0,   0, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0, 128, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
	};
	static const unsigned char yybm_ST_HEREDOC[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128,   0,   0,   0,   0,   0,   0, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0, 128, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
	};
	static const unsigned char yybm_ST_LOOKING_FOR_VARNAME[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128,   0,   0,   0,   0,   0,   0, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0, 128, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
	};
	static const unsigned char yybm_ST_VAR_OFFSET[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		240, 240, 176, 176, 176, 176, 176, 176, 
		176, 176,   0,   0,   0,   0,   0,   0, 
		  0, 160, 160, 160, 160, 160, 160,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,   0,   0,   0,   0,  32, 
		  0, 160, 160, 160, 160, 160, 160,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,   0,   0,   0,   0,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  32,  32,  32,  32, 
	};
	static const unsigned char yybm_INITIAL[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 128, 128,   0,   0, 128,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		128,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	goto *yyctable[YYGETCONDITION()];
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	YYDEBUG(0, *YYCURSOR);
	YYFILL(16);
	yych = *YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy1,  &&yy1,  &&yy1,  &&yy1,  &&yy1,  &&yy1,  &&yy1,  &&yy1,
			&&yy1,  &&yy2,  &&yy2,  &&yy1,  &&yy1,  &&yy2,  &&yy1,  &&yy1,
			&&yy1,  &&yy1,  &&yy1,  &&yy1,  &&yy1,  &&yy1,  &&yy1,  &&yy1,
			&&yy1,  &&yy1,  &&yy1,  &&yy1,  &&yy1,  &&yy1,  &&yy1,  &&yy1,
			&&yy2,  &&yy3,  &&yy5,  &&yy6,  &&yy7,  &&yy8,  &&yy9,  &&yy10,
			&&yy11, &&yy12, &&yy13, &&yy14, &&yy12, &&yy15, &&yy16, &&yy17,
			&&yy18, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20,
			&&yy20, &&yy20, &&yy22, &&yy12, &&yy23, &&yy24, &&yy25, &&yy26,
			&&yy12, &&yy27, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy31,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy32, &&yy29, &&yy29, &&yy12, &&yy33, &&yy12, &&yy34, &&yy35,
			&&yy36, &&yy37, &&yy38, &&yy39, &&yy40, &&yy41, &&yy42, &&yy43,
			&&yy29, &&yy44, &&yy29, &&yy29, &&yy45, &&yy29, &&yy46, &&yy29,
			&&yy47, &&yy29, &&yy48, &&yy49, &&yy50, &&yy51, &&yy52, &&yy53,
			&&yy29, &&yy54, &&yy29, &&yy55, &&yy56, &&yy57, &&yy12, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29,
			&&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29, &&yy29
		};
		goto *yytarget[yych];
	}
yy1:
	YYDEBUG(1, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 4) {
		goto yy2;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
yy3:
	YYDEBUG(3, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '=') goto yy58;
yy4:
	YYDEBUG(4, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return yytext[0];
}
yy5:
	YYDEBUG(5, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"' TSRMLS_CC);
				return T_CONSTANT_ENCAPSED_STRING;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	return '"';
}
yy6:
	YYDEBUG(6, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '%':
				if (!CG(asp_tags)) {
					continue;
				}
				/* fall through */
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	return T_COMMENT;
}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '_') {
		if (yych <= '@') goto yy4;
		if (yych <= 'Z') goto yy60;
		if (yych <= '^') goto yy4;
		goto yy60;
	} else {
		if (yych <= '`') goto yy4;
		if (yych <= 'z') goto yy60;
		if (yych <= '~') goto yy4;
		goto yy60;
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '<') goto yy4;
	if (yych <= '=') goto yy62;
	if (yych <= '>') goto yy63;
	goto yy4;
yy9:
	YYDEBUG(9, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '&') goto yy65;
	if (yych == '=') goto yy66;
	goto yy4;
yy10:
	YYDEBUG(10, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			return T_ENCAPSED_AND_WHITESPACE;
		}
	}

	zendlval->value.str.val = estrndup(yytext+bprefix+1, yyleng-bprefix-2);
	zendlval->value.str.len = yyleng-bprefix-2;
	zendlval->type = IS_STRING;

	/* convert escape sequences */
	s = t = zendlval->value.str.val;
	end = s+zendlval->value.str.len;
	while (s<end) {
		if (*s=='\\') {
			s++;

			switch(*s) {
				case '\\':
				case '\'':
					*t++ = *s;
					zendlval->value.str.len--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;

	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = zendlval->value.str.val;
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)s, (size_t)zendlval->value.str.len TSRMLS_CC);
		zendlval->value.str.len = sz;
		efree(s);
	}
	return T_CONSTANT_ENCAPSED_STRING;
}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	{
		static void *yytarget[256] = {
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy68, &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy68, &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy68, &&yy68, &&yy4,  &&yy68, &&yy4,  &&yy68, &&yy4,
			&&yy4,  &&yy68, &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy68,
			&&yy4,  &&yy4,  &&yy68, &&yy68, &&yy4,  &&yy68, &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
			&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4
		};
		goto *yytarget[yych];
	}
yy12:
	YYDEBUG(12, *YYCURSOR);
	++YYCURSOR;
	goto yy4;
yy13:
	YYDEBUG(13, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '=') goto yy79;
	goto yy4;
yy14:
	YYDEBUG(14, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy80;
	if (yych == '=') goto yy81;
	goto yy4;
yy15:
	YYDEBUG(15, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '<') {
		if (yych == '-') goto yy82;
		goto yy4;
	} else {
		if (yych <= '=') goto yy83;
		if (yych <= '>') goto yy84;
		goto yy4;
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy4;
	if (yych <= '9') goto yy85;
	if (yych == '=') goto yy87;
	goto yy4;
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych == '*') goto yy88;
		goto yy4;
	} else {
		if (yych <= '/') goto yy6;
		if (yych == '=') goto yy90;
		goto yy4;
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'b') goto yy92;
	if (yych == 'x') goto yy93;
	goto yy21;
yy19:
	YYDEBUG(19, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		zendlval->value.lval = strtol(yytext, NULL, 0);
	} else {
		errno = 0;
		zendlval->value.lval = strtol(yytext, NULL, 0);
		if (errno == ERANGE) { /* Overflow */
			if (yytext[0] == '0') { /* octal overflow */
				zendlval->value.dval = zend_oct_strtod(yytext, NULL);
			} else {
				zendlval->value.dval = zend_strtod(yytext, NULL);
			}
			zendlval->type = IS_DOUBLE;
			return T_DNUMBER;
		}
	}

	zendlval->type = IS_LONG;
	return T_LNUMBER;
}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yyaccept = 1;
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
yy21:
	YYDEBUG(21, *YYCURSOR);
	if (yybm_ST_IN_SCRIPTING[0+yych] & 8) {
		goto yy20;
	}
	if (yych <= 'D') {
		if (yych == '.') goto yy85;
		goto yy19;
	} else {
		if (yych <= 'E') goto yy91;
		if (yych == 'e') goto yy91;
		goto yy19;
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy94;
	goto yy4;
yy23:
	YYDEBUG(23, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ';') {
		if (yych == '/') goto yy95;
		goto yy4;
	} else {
		if (yych <= '<') goto yy96;
		if (yych <= '=') goto yy98;
		if (yych <= '>') goto yy99;
		goto yy4;
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '<') goto yy4;
	if (yych <= '=') goto yy100;
	if (yych <= '>') goto yy101;
	goto yy4;
yy25:
	YYDEBUG(25, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '<') goto yy4;
	if (yych <= '=') goto yy102;
	if (yych <= '>') goto yy103;
	goto yy4;
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '>') goto yy104;
	goto yy4;
yy27:
	YYDEBUG(27, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy106;
	goto yy30;
yy28:
	YYDEBUG(28, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
yy29:
	YYDEBUG(29, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
yy30:
	YYDEBUG(30, *YYCURSOR);
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	goto yy28;
yy31:
	YYDEBUG(31, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy107;
	goto yy30;
yy32:
	YYDEBUG(32, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy108;
	goto yy30;
yy33:
	YYDEBUG(33, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_NS_SEPARATOR;
}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '=') goto yy109;
	goto yy4;
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy110;
	goto yy30;
yy36:
	YYDEBUG(36, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_BACKQUOTE);
	return '`';
}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'q') {
		if (yych == 'b') goto yy111;
		goto yy30;
	} else {
		if (yych <= 'r') goto yy112;
		if (yych <= 's') goto yy113;
		goto yy30;
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	{
		static void *yytarget[256] = {
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy5,   &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy10,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy114, &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy115, &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30
		};
		goto *yytarget[yych];
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'k') {
		if (yych == 'a') goto yy116;
		goto yy30;
	} else {
		if (yych <= 'l') goto yy117;
		if (yych == 'o') goto yy118;
		goto yy30;
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'h') {
		if (yych == 'e') goto yy119;
		goto yy30;
	} else {
		if (yych <= 'i') goto yy120;
		if (yych == 'o') goto yy121;
		goto yy30;
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy122, &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy123, &&yy124, &&yy125, &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy126, &&yy30,
			&&yy127, &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30
		};
		goto *yytarget[yych];
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'n') {
		if (yych == 'i') goto yy128;
		goto yy30;
	} else {
		if (yych <= 'o') goto yy129;
		if (yych == 'u') goto yy130;
		goto yy30;
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy131;
	if (yych == 'o') goto yy132;
	goto yy30;
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'm') {
		if (yych == 'f') goto yy133;
		if (yych <= 'l') goto yy30;
		goto yy134;
	} else {
		if (yych <= 'n') goto yy135;
		if (yych == 's') goto yy136;
		goto yy30;
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy137;
	goto yy30;
yy46:
	YYDEBUG(46, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy138;
	if (yych == 'e') goto yy139;
	goto yy30;
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy140;
	if (yych == 'u') goto yy141;
	goto yy30;
yy48:
	YYDEBUG(48, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy142;
	goto yy30;
yy49:
	YYDEBUG(49, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy143;
	if (yych == 'w') goto yy144;
	goto yy30;
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy145;
	if (yych == 'r') goto yy146;
	goto yy30;
yy51:
	YYDEBUG(51, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy147;
	if (yych == 's') goto yy148;
	goto yy30;
yy52:
	YYDEBUG(52, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy149;
	goto yy30;
yy53:
	YYDEBUG(53, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy150;
	goto yy30;
yy54:
	YYDEBUG(54, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy151;
	goto yy30;
yy55:
	YYDEBUG(55, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return '{';
}
yy56:
	YYDEBUG(56, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '=') goto yy152;
	if (yych == '|') goto yy153;
	goto yy4;
yy57:
	YYDEBUG(57, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state(TSRMLS_C);
	}
	return '}';
}
yy58:
	YYDEBUG(58, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '=') goto yy154;
yy59:
	YYDEBUG(59, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_IS_NOT_EQUAL;
}
yy60:
	YYDEBUG(60, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
			&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
			&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
			&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
			&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
			&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
			&&yy61, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy61, &&yy61, &&yy61, &&yy61, &&yy60,
			&&yy61, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy61, &&yy61, &&yy61, &&yy61, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
			&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60
		};
		goto *yytarget[yych];
	}
yy61:
	YYDEBUG(61, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy62:
	YYDEBUG(62, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_MOD_EQUAL;
}
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy155;
	if (yych == '\r') goto yy156;
yy64:
	YYDEBUG(64, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(asp_tags)) {
		BEGIN(INITIAL);
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		zendlval->value.str.val = yytext; /* no copying - intentional */
		return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
	} else {
		yyless(1);
		return yytext[0];
	}
}
yy65:
	YYDEBUG(65, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_BOOLEAN_AND;
}
yy66:
	YYDEBUG(66, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_AND_EQUAL;
}
yy67:
	YYDEBUG(67, *YYCURSOR);
	++YYCURSOR;
	YYFILL(7);
	yych = *YYCURSOR;
yy68:
	YYDEBUG(68, *YYCURSOR);
	{
		static void *yytarget[256] = {
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy67, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy67, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy70, &&yy71, &&yy69, &&yy72, &&yy69, &&yy73, &&yy69,
			&&yy69, &&yy74, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy75,
			&&yy69, &&yy69, &&yy76, &&yy77, &&yy69, &&yy78, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
			&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69
		};
		goto *yytarget[yych];
	}
yy69:
	YYDEBUG(69, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 2) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy4;
			} else {
				goto yy19;
			}
		} else {
			goto yy28;
		}
	} else {
		if (yyaccept <= 4) {
			if (yyaccept == 3) {
				goto yy86;
			} else {
				goto yy89;
			}
		} else {
			goto yy97;
		}
	}
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy157;
	goto yy69;
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy158;
	if (yych == 'o') goto yy159;
	goto yy69;
yy72:
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy160;
	goto yy69;
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy161;
	goto yy69;
yy74:
	YYDEBUG(74, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy162;
	goto yy69;
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'b') goto yy163;
	goto yy69;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy164;
	goto yy69;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy165;
	goto yy69;
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy166;
	goto yy69;
yy79:
	YYDEBUG(79, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_MUL_EQUAL;
}
yy80:
	YYDEBUG(80, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_INC;
}
yy81:
	YYDEBUG(81, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_PLUS_EQUAL;
}
yy82:
	YYDEBUG(82, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_DEC;
}
yy83:
	YYDEBUG(83, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_MINUS_EQUAL;
}
yy84:
	YYDEBUG(84, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	return T_OBJECT_OPERATOR;
}
yy85:
	YYDEBUG(85, *YYCURSOR);
	yyaccept = 3;
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yych <= 'D') {
		if (yych <= '/') goto yy86;
		if (yych <= '9') goto yy85;
	} else {
		if (yych <= 'E') goto yy91;
		if (yych == 'e') goto yy91;
	}
yy86:
	YYDEBUG(86, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zendlval->value.dval = zend_strtod(yytext, NULL);
	zendlval->type = IS_DOUBLE;
	return T_DNUMBER;
}
yy87:
	YYDEBUG(87, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_CONCAT_EQUAL;
}
yy88:
	YYDEBUG(88, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '*') goto yy167;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = estrndup(yytext, yyleng);
		CG(doc_comment_len) = yyleng;
		return T_DOC_COMMENT;
	}

	return T_COMMENT;
}
yy90:
	YYDEBUG(90, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_DIV_EQUAL;
}
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '+') goto yy168;
		goto yy69;
	} else {
		if (yych <= '-') goto yy168;
		if (yych <= '/') goto yy69;
		if (yych <= '9') goto yy169;
		goto yy69;
	}
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 64) {
		goto yy170;
	}
	goto yy69;
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 128) {
		goto yy171;
	}
	goto yy69;
yy94:
	YYDEBUG(94, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_PAAMAYIM_NEKUDOTAYIM;
}
yy95:
	YYDEBUG(95, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 's') goto yy172;
	goto yy69;
yy96:
	YYDEBUG(96, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ';') goto yy97;
	if (yych <= '<') goto yy173;
	if (yych <= '=') goto yy174;
yy97:
	YYDEBUG(97, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_SL;
}
yy98:
	YYDEBUG(98, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_IS_SMALLER_OR_EQUAL;
}
yy99:
	YYDEBUG(99, *YYCURSOR);
	++YYCURSOR;
	goto yy59;
yy100:
	YYDEBUG(100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '=') goto yy175;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_IS_EQUAL;
}
yy101:
	YYDEBUG(101, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_DOUBLE_ARROW;
}
yy102:
	YYDEBUG(102, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_IS_GREATER_OR_EQUAL;
}
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '=') goto yy176;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_SR;
}
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy177;
	if (yych == '\r') goto yy178;
yy105:
	YYDEBUG(105, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(INITIAL);
	return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
}
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy179;
	goto yy30;
yy107:
	YYDEBUG(107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_LOGICAL_OR;
}
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy180;
	goto yy30;
yy109:
	YYDEBUG(109, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_XOR_EQUAL;
}
yy110:
	YYDEBUG(110, *YYCURSOR);
	yych = *++YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy181, &&yy182, &&yy30,  &&yy183, &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy184, &&yy185, &&yy186, &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy187, &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy188, &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30
		};
		goto *yytarget[yych];
	}
yy111:
	YYDEBUG(111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 's') goto yy189;
	goto yy30;
yy112:
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy190;
	goto yy30;
yy113:
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_AS;
}
yy114:
	YYDEBUG(114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '<') goto yy191;
	goto yy69;
yy115:
	YYDEBUG(115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy192;
	goto yy30;
yy116:
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'r') {
		if (yych == 'l') goto yy193;
		goto yy30;
	} else {
		if (yych <= 's') goto yy194;
		if (yych <= 't') goto yy195;
		goto yy30;
	}
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy196;
	if (yych == 'o') goto yy197;
	goto yy30;
yy118:
	YYDEBUG(118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy198;
	goto yy30;
yy119:
	YYDEBUG(119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy199;
	if (yych == 'f') goto yy200;
	goto yy30;
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy201;
	goto yy30;
yy121:
	YYDEBUG(121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_DO;
}
yy122:
	YYDEBUG(122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy202;
	goto yy30;
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 's') goto yy203;
	goto yy30;
yy124:
	YYDEBUG(124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy204;
	goto yy30;
yy125:
	YYDEBUG(125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy205;
	goto yy30;
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy206;
	goto yy30;
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy207;
	if (yych == 't') goto yy208;
	goto yy30;
yy128:
	YYDEBUG(128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy209;
	goto yy30;
yy129:
	YYDEBUG(129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy210;
	goto yy30;
yy130:
	YYDEBUG(130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy212;
	goto yy30;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy213;
	goto yy30;
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy214;
	goto yy30;
yy133:
	YYDEBUG(133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_IF;
}
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy215;
	goto yy30;
yy135:
	YYDEBUG(135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'r') {
		if (yych == 'c') goto yy216;
		goto yy30;
	} else {
		if (yych <= 's') goto yy217;
		if (yych <= 't') goto yy218;
		goto yy30;
	}
yy136:
	YYDEBUG(136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 's') goto yy219;
	goto yy30;
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 's') goto yy220;
	goto yy30;
yy138:
	YYDEBUG(138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'm') goto yy221;
	goto yy30;
yy139:
	YYDEBUG(139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'w') goto yy222;
	goto yy30;
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy223;
	if (yych == 'o') goto yy224;
	goto yy30;
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'b') goto yy225;
	goto yy30;
yy142:
	YYDEBUG(142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'q') goto yy226;
	if (yych == 't') goto yy227;
	goto yy30;
yy143:
	YYDEBUG(143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy228;
	goto yy30;
yy144:
	YYDEBUG(144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy229;
	goto yy30;
yy145:
	YYDEBUG(145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy230;
	goto yy30;
yy146:
	YYDEBUG(146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy231;
	if (yych == 'y') goto yy232;
	goto yy30;
yy147:
	YYDEBUG(147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 's') goto yy233;
	goto yy30;
yy148:
	YYDEBUG(148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy234;
	goto yy30;
yy149:
	YYDEBUG(149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy235;
	goto yy30;
yy150:
	YYDEBUG(150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy236;
	goto yy30;
yy151:
	YYDEBUG(151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy237;
	goto yy30;
yy152:
	YYDEBUG(152, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_OR_EQUAL;
}
yy153:
	YYDEBUG(153, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_BOOLEAN_OR;
}
yy154:
	YYDEBUG(154, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_IS_NOT_IDENTICAL;
}
yy155:
	YYDEBUG(155, *YYCURSOR);
	++YYCURSOR;
	goto yy64;
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy155;
	goto yy64;
yy157:
	YYDEBUG(157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy238;
	goto yy69;
yy158:
	YYDEBUG(158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy239;
	goto yy69;
yy159:
	YYDEBUG(159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy240;
	goto yy69;
yy160:
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'u') goto yy241;
	goto yy69;
yy161:
	YYDEBUG(161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy242;
	goto yy69;
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy243;
	goto yy69;
yy163:
	YYDEBUG(163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'j') goto yy244;
	goto yy69;
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy245;
	goto yy69;
yy165:
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy246;
	goto yy69;
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 's') goto yy247;
	goto yy69;
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy69;
		if (yych <= '\n') goto yy248;
		goto yy69;
	} else {
		if (yych <= '\r') goto yy248;
		if (yych == ' ') goto yy248;
		goto yy69;
	}
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy69;
	if (yych >= ':') goto yy69;
yy169:
	YYDEBUG(169, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy86;
	if (yych <= '9') goto yy169;
	goto yy86;
yy170:
	YYDEBUG(170, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 64) {
		goto yy170;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	char *bin = yytext + 2; /* Skip "0b" */
	int len = yyleng - 2;

	/* Skip any leading 0s */
	while (*bin == '0') {
		++bin;
		--len;
	}

	if (len < SIZEOF_LONG * 8) {
		if (len == 0) {
			zendlval->value.lval = 0;
		} else {
			zendlval->value.lval = strtol(bin, NULL, 2);
		}
		zendlval->type = IS_LONG;
		return T_LNUMBER;
	} else {
		zendlval->value.dval = zend_bin_strtod(bin, NULL);
		zendlval->type = IS_DOUBLE;
		return T_DNUMBER;
	}
}
yy171:
	YYDEBUG(171, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 128) {
		goto yy171;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_LONG * 2 || (len == SIZEOF_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			zendlval->value.lval = 0;
		} else {
			zendlval->value.lval = strtol(hex, NULL, 16);
		}
		zendlval->type = IS_LONG;
		return T_LNUMBER;
	} else {
		zendlval->value.dval = zend_hex_strtod(hex, NULL);
		zendlval->type = IS_DOUBLE;
		return T_DNUMBER;
	}
}
yy172:
	YYDEBUG(172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy249;
	goto yy69;
yy173:
	YYDEBUG(173, *YYCURSOR);
	++YYCURSOR;
	YYFILL(2);
	yych = *YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy173, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy173, &&yy69,  &&yy250, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy251,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy252,
			&&yy69,  &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252
		};
		goto *yytarget[yych];
	}
yy174:
	YYDEBUG(174, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_SL_EQUAL;
}
yy175:
	YYDEBUG(175, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_IS_IDENTICAL;
}
yy176:
	YYDEBUG(176, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_SR_EQUAL;
}
yy177:
	YYDEBUG(177, *YYCURSOR);
	++YYCURSOR;
	goto yy105;
yy178:
	YYDEBUG(178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy177;
	goto yy105;
yy179:
	YYDEBUG(179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_LOGICAL_AND;
}
yy180:
	YYDEBUG(180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_LOGICAL_XOR;
}
yy181:
	YYDEBUG(181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy253;
	goto yy30;
yy182:
	YYDEBUG(182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy254;
	goto yy30;
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy255;
	if (yych == 'U') goto yy256;
	goto yy30;
yy184:
	YYDEBUG(184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy257;
	goto yy30;
yy185:
	YYDEBUG(185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy258;
	goto yy30;
yy186:
	YYDEBUG(186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy259;
	goto yy30;
yy187:
	YYDEBUG(187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy260;
	goto yy30;
yy188:
	YYDEBUG(188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy261;
	goto yy30;
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy262;
	goto yy30;
yy190:
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy263;
	goto yy30;
yy191:
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '<') goto yy173;
	goto yy69;
yy192:
	YYDEBUG(192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy264;
	goto yy30;
yy193:
	YYDEBUG(193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy265;
	goto yy30;
yy194:
	YYDEBUG(194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy266;
	goto yy30;
yy195:
	YYDEBUG(195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy267;
	goto yy30;
yy196:
	YYDEBUG(196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 's') goto yy268;
	goto yy30;
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy269;
	goto yy30;
yy198:
	YYDEBUG(198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'r') goto yy30;
	if (yych <= 's') goto yy270;
	if (yych <= 't') goto yy271;
	goto yy30;
yy199:
	YYDEBUG(199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy272;
	goto yy30;
yy200:
	YYDEBUG(200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy273;
	goto yy30;
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_EXIT;
}
yy202:
	YYDEBUG(202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy274;
	goto yy30;
yy203:
	YYDEBUG(203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy275;
	goto yy30;
yy204:
	YYDEBUG(204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy277;
	goto yy30;
yy205:
	YYDEBUG(205, *YYCURSOR);
	yych = *++YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy278, &&yy30,  &&yy279, &&yy30,
			&&yy30,  &&yy280, &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy281, &&yy30,  &&yy30,  &&yy30,  &&yy282,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,
			&&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30,  &&yy30
		};
		goto *yytarget[yych];
	}
yy206:
	YYDEBUG(206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy283;
	goto yy30;
yy207:
	YYDEBUG(207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy284;
	goto yy30;
yy208:
	YYDEBUG(208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy285;
	goto yy30;
yy209:
	YYDEBUG(209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy286;
	goto yy30;
yy210:
	YYDEBUG(210, *YYCURSOR);
	yych = *++YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211,
			&&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211,
			&&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211,
			&&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211,
			&&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211,
			&&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy211, &&yy211, &&yy211, &&yy211, &&yy211, &&yy211,
			&&yy211, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy211, &&yy211, &&yy211, &&yy211, &&yy29,
			&&yy211, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy287, &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy211, &&yy211, &&yy211, &&yy211, &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29
		};
		goto *yytarget[yych];
	}
yy211:
	YYDEBUG(211, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_FOR;
}
yy212:
	YYDEBUG(212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy288;
	goto yy30;
yy213:
	YYDEBUG(213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'b') goto yy289;
	goto yy30;
yy214:
	YYDEBUG(214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy290;
	goto yy30;
yy215:
	YYDEBUG(215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy291;
	goto yy30;
yy216:
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy292;
	goto yy30;
yy217:
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy293;
	goto yy30;
yy218:
	YYDEBUG(218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy294;
	goto yy30;
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy295;
	goto yy30;
yy220:
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy296;
	goto yy30;
yy221:
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy297;
	goto yy30;
yy222:
	YYDEBUG(222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_NEW;
}
yy223:
	YYDEBUG(223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy298;
	if (yych == 'v') goto yy299;
	goto yy30;
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy300;
	goto yy30;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy301;
	goto yy30;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'u') goto yy302;
	goto yy30;
yy227:
	YYDEBUG(227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'u') goto yy303;
	goto yy30;
yy228:
	YYDEBUG(228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy304;
	goto yy30;
yy229:
	YYDEBUG(229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy305;
	goto yy30;
yy230:
	YYDEBUG(230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy306;
	goto yy30;
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy307;
	goto yy30;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_TRY;
}
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy308;
	goto yy30;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_USE;
}
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_VAR;
}
yy236:
	YYDEBUG(236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy309;
	goto yy30;
yy237:
	YYDEBUG(237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy310;
	goto yy30;
yy238:
	YYDEBUG(238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy311;
	goto yy69;
yy239:
	YYDEBUG(239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy312;
	goto yy69;
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy313;
	goto yy69;
yy241:
	YYDEBUG(241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'b') goto yy314;
	goto yy69;
yy242:
	YYDEBUG(242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy315;
	goto yy69;
yy243:
	YYDEBUG(243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy318;
	goto yy317;
yy244:
	YYDEBUG(244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy319;
	goto yy69;
yy245:
	YYDEBUG(245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy320;
	goto yy69;
yy246:
	YYDEBUG(246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy321;
	goto yy69;
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy322;
	goto yy69;
yy248:
	YYDEBUG(248, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy89;
		if (yych <= '\n') goto yy248;
		goto yy89;
	} else {
		if (yych <= '\r') goto yy248;
		if (yych == ' ') goto yy248;
		goto yy89;
	}
yy249:
	YYDEBUG(249, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy323;
	goto yy69;
yy250:
	YYDEBUG(250, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '"') goto yy69;
	if (yych <= '/') goto yy325;
	if (yych <= '9') goto yy69;
	goto yy325;
yy251:
	YYDEBUG(251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\'') goto yy69;
	if (yych <= '/') goto yy327;
	if (yych <= '9') goto yy69;
	goto yy327;
yy252:
	YYDEBUG(252, *YYCURSOR);
	++YYCURSOR;
	YYFILL(2);
	yych = *YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy328, &&yy69,  &&yy69,  &&yy330, &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy252,
			&&yy69,  &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252,
			&&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252, &&yy252
		};
		goto *yytarget[yych];
	}
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy331;
	goto yy30;
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy332;
	goto yy30;
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy333;
	goto yy30;
yy256:
	YYDEBUG(256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy334;
	goto yy30;
yy257:
	YYDEBUG(257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy335;
	goto yy30;
yy258:
	YYDEBUG(258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy336;
	goto yy30;
yy259:
	YYDEBUG(259, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy337;
	goto yy30;
yy260:
	YYDEBUG(260, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy338;
	goto yy30;
yy261:
	YYDEBUG(261, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy339;
	goto yy30;
yy262:
	YYDEBUG(262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy340;
	goto yy30;
yy263:
	YYDEBUG(263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'y') goto yy341;
	goto yy30;
yy264:
	YYDEBUG(264, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'k') goto yy342;
	goto yy30;
yy265:
	YYDEBUG(265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy343;
	goto yy30;
yy266:
	YYDEBUG(266, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_CASE;
}
yy267:
	YYDEBUG(267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy344;
	goto yy30;
yy268:
	YYDEBUG(268, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 's') goto yy345;
	goto yy30;
yy269:
	YYDEBUG(269, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy346;
	goto yy30;
yy270:
	YYDEBUG(270, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy347;
	goto yy30;
yy271:
	YYDEBUG(271, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy348;
	goto yy30;
yy272:
	YYDEBUG(272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy349;
	goto yy30;
yy273:
	YYDEBUG(273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'u') goto yy350;
	goto yy30;
yy274:
	YYDEBUG(274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_ECHO;
}
yy275:
	YYDEBUG(275, *YYCURSOR);
	yych = *++YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276,
			&&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276,
			&&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276,
			&&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276,
			&&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276,
			&&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy276, &&yy276, &&yy276, &&yy276, &&yy276, &&yy276,
			&&yy276, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy276, &&yy276, &&yy276, &&yy276, &&yy29,
			&&yy276, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy351, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy276, &&yy276, &&yy276, &&yy276, &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29
		};
		goto *yytarget[yych];
	}
yy276:
	YYDEBUG(276, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_ELSE;
}
yy277:
	YYDEBUG(277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'y') goto yy352;
	goto yy30;
yy278:
	YYDEBUG(278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy353;
	goto yy30;
yy279:
	YYDEBUG(279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy354;
	goto yy30;
yy280:
	YYDEBUG(280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'f') goto yy355;
	goto yy30;
yy281:
	YYDEBUG(281, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'w') goto yy356;
	goto yy30;
yy282:
	YYDEBUG(282, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy357;
	goto yy30;
yy283:
	YYDEBUG(283, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_EVAL;
}
yy284:
	YYDEBUG(284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_EXIT;
}
yy285:
	YYDEBUG(285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy358;
	goto yy30;
yy286:
	YYDEBUG(286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy359;
	goto yy30;
yy287:
	YYDEBUG(287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy361;
	goto yy30;
yy288:
	YYDEBUG(288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy362;
	goto yy30;
yy289:
	YYDEBUG(289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy363;
	goto yy30;
yy290:
	YYDEBUG(290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_GOTO;
}
yy291:
	YYDEBUG(291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy364;
	goto yy30;
yy292:
	YYDEBUG(292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'u') goto yy365;
	goto yy30;
yy293:
	YYDEBUG(293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy366;
	if (yych == 'e') goto yy367;
	goto yy30;
yy294:
	YYDEBUG(294, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy368;
	goto yy30;
yy295:
	YYDEBUG(295, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy369;
	goto yy30;
yy296:
	YYDEBUG(296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_LIST;
}
yy297:
	YYDEBUG(297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 's') goto yy370;
	goto yy30;
yy298:
	YYDEBUG(298, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy371;
	goto yy30;
yy299:
	YYDEBUG(299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy372;
	goto yy30;
yy300:
	YYDEBUG(300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy373;
	goto yy30;
yy301:
	YYDEBUG(301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy374;
	goto yy30;
yy302:
	YYDEBUG(302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy375;
	goto yy30;
yy303:
	YYDEBUG(303, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy376;
	goto yy30;
yy304:
	YYDEBUG(304, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy377;
	goto yy30;
yy305:
	YYDEBUG(305, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy378;
	goto yy30;
yy306:
	YYDEBUG(306, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'w') goto yy379;
	goto yy30;
yy307:
	YYDEBUG(307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy380;
	goto yy30;
yy308:
	YYDEBUG(308, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy381;
	goto yy30;
yy309:
	YYDEBUG(309, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy382;
	goto yy30;
yy310:
	YYDEBUG(310, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy383;
	goto yy30;
yy311:
	YYDEBUG(311, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'y') goto yy384;
	goto yy69;
yy312:
	YYDEBUG(312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy385;
	goto yy69;
yy313:
	YYDEBUG(313, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy388;
	goto yy387;
yy314:
	YYDEBUG(314, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy389;
	goto yy69;
yy315:
	YYDEBUG(315, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy320;
	goto yy69;
yy316:
	YYDEBUG(316, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
yy317:
	YYDEBUG(317, *YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy316;
		goto yy69;
	} else {
		if (yych <= ' ') goto yy316;
		if (yych != ')') goto yy69;
	}
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_INT_CAST;
}
yy318:
	YYDEBUG(318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'g') goto yy390;
	goto yy69;
yy319:
	YYDEBUG(319, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy391;
	goto yy69;
yy320:
	YYDEBUG(320, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy320;
		goto yy69;
	} else {
		if (yych <= ' ') goto yy320;
		if (yych == ')') goto yy392;
		goto yy69;
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy393;
	goto yy69;
yy322:
	YYDEBUG(322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy394;
	goto yy69;
yy323:
	YYDEBUG(323, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy395;
	goto yy69;
yy324:
	YYDEBUG(324, *YYCURSOR);
	++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
yy325:
	YYDEBUG(325, *YYCURSOR);
	{
		static void *yytarget[256] = {
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy396, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy324,
			&&yy69,  &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324,
			&&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324, &&yy324
		};
		goto *yytarget[yych];
	}
yy326:
	YYDEBUG(326, *YYCURSOR);
	++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
yy327:
	YYDEBUG(327, *YYCURSOR);
	{
		static void *yytarget[256] = {
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy396,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy326,
			&&yy69,  &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
			&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326
		};
		goto *yytarget[yych];
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	++YYCURSOR;
yy329:
	YYDEBUG(329, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	char *s;
	int bprefix = (yytext[0] != '<') ? 1 : 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		YYCTYPE *end = YYCURSOR + heredoc_label->length;

		if (*end == ';') {
			end++;
		}

		if (*end == '\n' || *end == '\r') {
			BEGIN(ST_END_HEREDOC);
		}
	}

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	return T_START_HEREDOC;
}
yy330:
	YYDEBUG(330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy328;
	goto yy329;
yy331:
	YYDEBUG(331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy397;
	goto yy30;
yy332:
	YYDEBUG(332, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy398;
	goto yy30;
yy333:
	YYDEBUG(333, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy399;
	goto yy30;
yy334:
	YYDEBUG(334, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy400;
	goto yy30;
yy335:
	YYDEBUG(335, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy401;
	goto yy30;
yy336:
	YYDEBUG(336, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy402;
	goto yy30;
yy337:
	YYDEBUG(337, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy403;
	goto yy30;
yy338:
	YYDEBUG(338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy404;
	goto yy30;
yy339:
	YYDEBUG(339, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy405;
	goto yy30;
yy340:
	YYDEBUG(340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy406;
	goto yy30;
yy341:
	YYDEBUG(341, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_ARRAY;
}
yy342:
	YYDEBUG(342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_BREAK;
}
yy343:
	YYDEBUG(343, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'b') goto yy407;
	goto yy30;
yy344:
	YYDEBUG(344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_CATCH;
}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_CLASS;
}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_CLONE;
}
yy347:
	YYDEBUG(347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_CONST;
}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy408;
	goto yy30;
yy349:
	YYDEBUG(349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy409;
	goto yy30;
yy350:
	YYDEBUG(350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy410;
	goto yy30;
yy351:
	YYDEBUG(351, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'f') goto yy411;
	goto yy30;
yy352:
	YYDEBUG(352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_EMPTY;
}
yy353:
	YYDEBUG(353, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy412;
	goto yy30;
yy354:
	YYDEBUG(354, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy413;
	goto yy30;
yy355:
	YYDEBUG(355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_ENDIF;
}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy415;
	goto yy30;
yy357:
	YYDEBUG(357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy416;
	goto yy30;
yy358:
	YYDEBUG(358, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy417;
	goto yy30;
yy359:
	YYDEBUG(359, *YYCURSOR);
	yych = *++YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360,
			&&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360,
			&&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360,
			&&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360,
			&&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360,
			&&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy360, &&yy360, &&yy360, &&yy360, &&yy360, &&yy360,
			&&yy360, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy360, &&yy360, &&yy360, &&yy360, &&yy29,
			&&yy360, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy418, &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy360, &&yy360, &&yy360, &&yy360, &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29
		};
		goto *yytarget[yych];
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_FINAL;
}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy419;
	goto yy30;
yy362:
	YYDEBUG(362, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy420;
	goto yy30;
yy363:
	YYDEBUG(363, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy421;
	goto yy30;
yy364:
	YYDEBUG(364, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'm') goto yy422;
	goto yy30;
yy365:
	YYDEBUG(365, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy423;
	goto yy30;
yy366:
	YYDEBUG(366, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy424;
	goto yy30;
yy367:
	YYDEBUG(367, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy425;
	goto yy30;
yy368:
	YYDEBUG(368, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'f') goto yy426;
	goto yy30;
yy369:
	YYDEBUG(369, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_ISSET;
}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy427;
	goto yy30;
yy371:
	YYDEBUG(371, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_PRINT;
}
yy372:
	YYDEBUG(372, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy428;
	goto yy30;
yy373:
	YYDEBUG(373, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy429;
	goto yy30;
yy374:
	YYDEBUG(374, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy430;
	goto yy30;
yy375:
	YYDEBUG(375, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy431;
	goto yy30;
yy376:
	YYDEBUG(376, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy432;
	goto yy30;
yy377:
	YYDEBUG(377, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy433;
	goto yy30;
yy378:
	YYDEBUG(378, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy434;
	goto yy30;
yy379:
	YYDEBUG(379, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_THROW;
}
yy380:
	YYDEBUG(380, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_TRAIT;
}
yy381:
	YYDEBUG(381, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_UNSET;
}
yy382:
	YYDEBUG(382, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_WHILE;
}
yy383:
	YYDEBUG(383, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_YIELD;
}
yy384:
	YYDEBUG(384, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy384;
		goto yy69;
	} else {
		if (yych <= ' ') goto yy384;
		if (yych == ')') goto yy435;
		goto yy69;
	}
yy385:
	YYDEBUG(385, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'y') goto yy436;
	goto yy69;
yy386:
	YYDEBUG(386, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
yy387:
	YYDEBUG(387, *YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy386;
		goto yy69;
	} else {
		if (yych <= ' ') goto yy386;
		if (yych != ')') goto yy69;
	}
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_BOOL_CAST;
}
yy388:
	YYDEBUG(388, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy437;
	goto yy69;
yy389:
	YYDEBUG(389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy320;
	goto yy69;
yy390:
	YYDEBUG(390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy438;
	goto yy69;
yy391:
	YYDEBUG(391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy439;
	goto yy69;
yy392:
	YYDEBUG(392, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_DOUBLE_CAST;
}
yy393:
	YYDEBUG(393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'g') goto yy436;
	goto yy69;
yy394:
	YYDEBUG(394, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy394;
		goto yy69;
	} else {
		if (yych <= ' ') goto yy394;
		if (yych == ')') goto yy440;
		goto yy69;
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy441;
	goto yy69;
yy396:
	YYDEBUG(396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy328;
	if (yych == '\r') goto yy330;
	goto yy69;
yy397:
	YYDEBUG(397, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy442;
	goto yy30;
yy398:
	YYDEBUG(398, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy443;
	goto yy30;
yy399:
	YYDEBUG(399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy444;
	goto yy30;
yy400:
	YYDEBUG(400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy445;
	goto yy30;
yy401:
	YYDEBUG(401, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy446;
	goto yy30;
yy402:
	YYDEBUG(402, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy447;
	goto yy30;
yy403:
	YYDEBUG(403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy448;
	goto yy30;
yy404:
	YYDEBUG(404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy449;
	goto yy30;
yy405:
	YYDEBUG(405, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy450;
	goto yy30;
yy406:
	YYDEBUG(406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy451;
	goto yy30;
yy407:
	YYDEBUG(407, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy452;
	goto yy30;
yy408:
	YYDEBUG(408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'u') goto yy453;
	goto yy30;
yy409:
	YYDEBUG(409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy454;
	goto yy30;
yy410:
	YYDEBUG(410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy455;
	goto yy30;
yy411:
	YYDEBUG(411, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_ELSEIF;
}
yy412:
	YYDEBUG(412, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy456;
	goto yy30;
yy413:
	YYDEBUG(413, *YYCURSOR);
	yych = *++YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414,
			&&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414,
			&&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414,
			&&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414,
			&&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414,
			&&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy414, &&yy414, &&yy414, &&yy414, &&yy414, &&yy414,
			&&yy414, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy414, &&yy414, &&yy414, &&yy414, &&yy29,
			&&yy414, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy457, &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy414, &&yy414, &&yy414, &&yy414, &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29
		};
		goto *yytarget[yych];
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_ENDFOR;
}
yy415:
	YYDEBUG(415, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy458;
	goto yy30;
yy416:
	YYDEBUG(416, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy459;
	goto yy30;
yy417:
	YYDEBUG(417, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 's') goto yy460;
	goto yy30;
yy418:
	YYDEBUG(418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'y') goto yy461;
	goto yy30;
yy419:
	YYDEBUG(419, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy462;
	goto yy30;
yy420:
	YYDEBUG(420, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy463;
	goto yy30;
yy421:
	YYDEBUG(421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_GLOBAL;
}
yy422:
	YYDEBUG(422, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy464;
	goto yy30;
yy423:
	YYDEBUG(423, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy465;
	goto yy30;
yy424:
	YYDEBUG(424, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy467;
	goto yy30;
yy425:
	YYDEBUG(425, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy468;
	goto yy30;
yy426:
	YYDEBUG(426, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy469;
	goto yy30;
yy427:
	YYDEBUG(427, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy470;
	goto yy30;
yy428:
	YYDEBUG(428, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy471;
	goto yy30;
yy429:
	YYDEBUG(429, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy472;
	goto yy30;
yy430:
	YYDEBUG(430, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_PUBLIC;
}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy473;
	goto yy30;
yy432:
	YYDEBUG(432, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_RETURN;
}
yy433:
	YYDEBUG(433, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_STATIC;
}
yy434:
	YYDEBUG(434, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_SWITCH;
}
yy435:
	YYDEBUG(435, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_ARRAY_CAST;
}
yy436:
	YYDEBUG(436, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy436;
		goto yy69;
	} else {
		if (yych <= ' ') goto yy436;
		if (yych == ')') goto yy475;
		goto yy69;
	}
yy437:
	YYDEBUG(437, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy386;
	goto yy69;
yy438:
	YYDEBUG(438, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy316;
	goto yy69;
yy439:
	YYDEBUG(439, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy439;
		goto yy69;
	} else {
		if (yych <= ' ') goto yy439;
		if (yych == ')') goto yy476;
		goto yy69;
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_UNSET_CAST;
}
yy441:
	YYDEBUG(441, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy477;
	goto yy69;
yy442:
	YYDEBUG(442, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy478;
	goto yy30;
yy443:
	YYDEBUG(443, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	char *filename = zend_get_compiled_filename(TSRMLS_C);
	const size_t filename_len = strlen(filename);
	char *dirname;

	if (!filename) {
		filename = "";
	}

	dirname = estrndup(filename, filename_len);
	zend_dirname(dirname, filename_len);

	if (strcmp(dirname, ".") == 0) {
		dirname = erealloc(dirname, MAXPATHLEN);
#if HAVE_GETCWD
		VCWD_GETCWD(dirname, MAXPATHLEN);
#elif HAVE_GETWD
		VCWD_GETWD(dirname);
#endif
	}

	zendlval->value.str.len = strlen(dirname);
	zendlval->value.str.val = dirname;
	zendlval->type = IS_STRING;
	return T_DIR;
}
yy444:
	YYDEBUG(444, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy479;
	goto yy30;
yy445:
	YYDEBUG(445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy480;
	goto yy30;
yy446:
	YYDEBUG(446, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy481;
	goto yy30;
yy447:
	YYDEBUG(447, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy482;
	goto yy30;
yy448:
	YYDEBUG(448, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy483;
	goto yy30;
yy449:
	YYDEBUG(449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy484;
	goto yy30;
yy450:
	YYDEBUG(450, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy485;
	goto yy30;
yy451:
	YYDEBUG(451, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy486;
	goto yy30;
yy452:
	YYDEBUG(452, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy487;
	goto yy30;
yy453:
	YYDEBUG(453, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy488;
	goto yy30;
yy454:
	YYDEBUG(454, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_DECLARE;
}
yy455:
	YYDEBUG(455, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_DEFAULT;
}
yy456:
	YYDEBUG(456, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy489;
	goto yy30;
yy457:
	YYDEBUG(457, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy490;
	goto yy30;
yy458:
	YYDEBUG(458, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy491;
	goto yy30;
yy459:
	YYDEBUG(459, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy492;
	goto yy30;
yy460:
	YYDEBUG(460, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_EXTENDS;
}
yy461:
	YYDEBUG(461, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_FINALLY;
}
yy462:
	YYDEBUG(462, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_FOREACH;
}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy493;
	goto yy30;
yy464:
	YYDEBUG(464, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy494;
	goto yy30;
yy465:
	YYDEBUG(465, *YYCURSOR);
	yych = *++YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466,
			&&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466,
			&&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466,
			&&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466,
			&&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466,
			&&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy466, &&yy466, &&yy466, &&yy466, &&yy466, &&yy466,
			&&yy466, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy466, &&yy466, &&yy466, &&yy466, &&yy495,
			&&yy466, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy466, &&yy466, &&yy466, &&yy466, &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29
		};
		goto *yytarget[yych];
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_INCLUDE;
}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy496;
	goto yy30;
yy468:
	YYDEBUG(468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy497;
	goto yy30;
yy469:
	YYDEBUG(469, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy498;
	goto yy30;
yy470:
	YYDEBUG(470, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy499;
	goto yy30;
yy471:
	YYDEBUG(471, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_PRIVATE;
}
yy472:
	YYDEBUG(472, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy500;
	goto yy30;
yy473:
	YYDEBUG(473, *YYCURSOR);
	yych = *++YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474,
			&&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474,
			&&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474,
			&&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474,
			&&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474,
			&&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy474, &&yy474, &&yy474, &&yy474, &&yy474, &&yy474,
			&&yy474, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy474, &&yy474, &&yy474, &&yy474, &&yy501,
			&&yy474, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy474, &&yy474, &&yy474, &&yy474, &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
			&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29
		};
		goto *yytarget[yych];
	}
yy474:
	YYDEBUG(474, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_REQUIRE;
}
yy475:
	YYDEBUG(475, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_STRING_CAST;
}
yy476:
	YYDEBUG(476, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_OBJECT_CAST;
}
yy477:
	YYDEBUG(477, *YYCURSOR);
	++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy477, &&yy477, &&yy69,  &&yy69,  &&yy477, &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy477, &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy104, &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,
			&&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69,  &&yy69
		};
		goto *yytarget[yych];
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy502;
	goto yy30;
yy479:
	YYDEBUG(479, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	char *filename = zend_get_compiled_filename(TSRMLS_C);

	if (!filename) {
		filename = "";
	}
	zendlval->value.str.len = strlen(filename);
	zendlval->value.str.val = estrndup(filename, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_FILE;
}
yy480:
	YYDEBUG(480, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy503;
	goto yy30;
yy481:
	YYDEBUG(481, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zendlval->value.lval = CG(zend_lineno);
	zendlval->type = IS_LONG;
	return T_LINE;
}
yy482:
	YYDEBUG(482, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy504;
	goto yy30;
yy483:
	YYDEBUG(483, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy505;
	goto yy30;
yy484:
	YYDEBUG(484, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy506;
	goto yy30;
yy485:
	YYDEBUG(485, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy507;
	goto yy30;
yy486:
	YYDEBUG(486, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_ABSTRACT;
}
yy487:
	YYDEBUG(487, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
 return T_CALLABLE;
}
yy488:
	YYDEBUG(488, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_CONTINUE;
}
yy489:
	YYDEBUG(489, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy508;
	goto yy30;
yy490:
	YYDEBUG(490, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy509;
	goto yy30;
yy491:
	YYDEBUG(491, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy510;
	goto yy30;
yy492:
	YYDEBUG(492, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_ENDWHILE;
}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_FUNCTION;
}
yy494:
	YYDEBUG(494, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy511;
	goto yy30;
yy495:
	YYDEBUG(495, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy512;
	goto yy30;
yy496:
	YYDEBUG(496, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy513;
	goto yy30;
yy497:
	YYDEBUG(497, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'f') goto yy514;
	goto yy30;
yy498:
	YYDEBUG(498, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy515;
	goto yy30;
yy499:
	YYDEBUG(499, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy516;
	goto yy30;
yy500:
	YYDEBUG(500, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy517;
	goto yy30;
yy501:
	YYDEBUG(501, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy518;
	goto yy30;
yy502:
	YYDEBUG(502, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	const char *class_name = NULL;
	
	if (CG(active_class_entry)
		&& (ZEND_ACC_TRAIT ==
			(CG(active_class_entry)->ce_flags & ZEND_ACC_TRAIT))) {
		/* We create a special __CLASS__ constant that is going to be resolved
		   at run-time */
		zendlval->value.str.len = sizeof("__CLASS__")-1;
		zendlval->value.str.val = estrndup("__CLASS__", zendlval->value.str.len);
		zendlval->type = IS_CONSTANT;
	} else {
		if (CG(active_class_entry)) {
			class_name = CG(active_class_entry)->name;
		}
		
		if (!class_name) {
			class_name = "";
		}
		
		zendlval->value.str.len = strlen(class_name);
		zendlval->value.str.val = estrndup(class_name, zendlval->value.str.len);
		zendlval->type = IS_STRING;
	}
	return T_CLASS_C;
}
yy503:
	YYDEBUG(503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy519;
	goto yy30;
yy504:
	YYDEBUG(504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy520;
	goto yy30;
yy505:
	YYDEBUG(505, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy521;
	goto yy30;
yy506:
	YYDEBUG(506, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	const char *trait_name = NULL;
	
	if (CG(active_class_entry)
		&& (ZEND_ACC_TRAIT == 
			(CG(active_class_entry)->ce_flags & ZEND_ACC_TRAIT))) {
		trait_name = CG(active_class_entry)->name;
	}
	
	if (!trait_name) {
		trait_name = "";
	}
	
	zendlval->value.str.len = strlen(trait_name);
	zendlval->value.str.val = estrndup(trait_name, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	
	return T_TRAIT_C;
}
yy507:
	YYDEBUG(507, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'm') goto yy522;
	goto yy30;
yy508:
	YYDEBUG(508, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy523;
	goto yy30;
yy509:
	YYDEBUG(509, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy524;
	goto yy30;
yy510:
	YYDEBUG(510, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_ENDSWITCH;
}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 's') goto yy525;
	goto yy30;
yy512:
	YYDEBUG(512, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy526;
	goto yy30;
yy513:
	YYDEBUG(513, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'f') goto yy527;
	goto yy30;
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
        return T_INSTEADOF;
}
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_INTERFACE;
}
yy516:
	YYDEBUG(516, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_NAMESPACE;
}
yy517:
	YYDEBUG(517, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_PROTECTED;
}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'n') goto yy528;
	goto yy30;
yy519:
	YYDEBUG(519, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy529;
	goto yy30;
yy520:
	YYDEBUG(520, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	const char *class_name = CG(active_class_entry) ? CG(active_class_entry)->name : NULL;
	const char *func_name = CG(active_op_array)? CG(active_op_array)->function_name : NULL;
	size_t len = 0;

	if (class_name) {
		len += strlen(class_name) + 2;
	}
	if (func_name) {
		len += strlen(func_name);
	}

	zendlval->value.str.len = zend_spprintf(&zendlval->value.str.val, 0, "%s%s%s",
		class_name ? class_name : "",
		class_name && func_name ? "::" : "",
		func_name ? func_name : ""
		);
	zendlval->type = IS_STRING;
	return T_METHOD_C;
}
yy521:
	YYDEBUG(521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy530;
	goto yy30;
yy522:
	YYDEBUG(522, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy531;
	goto yy30;
yy523:
	YYDEBUG(523, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_ENDDECLARE;
}
yy524:
	YYDEBUG(524, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_ENDFOREACH;
}
yy525:
	YYDEBUG(525, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_IMPLEMENTS;
}
yy526:
	YYDEBUG(526, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy532;
	goto yy30;
yy527:
	YYDEBUG(527, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_INSTANCEOF;
}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy533;
	goto yy30;
yy529:
	YYDEBUG(529, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy534;
	goto yy30;
yy530:
	YYDEBUG(530, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy535;
	goto yy30;
yy531:
	YYDEBUG(531, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy536;
	goto yy30;
yy532:
	YYDEBUG(532, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy537;
	goto yy30;
yy533:
	YYDEBUG(533, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy538;
	goto yy30;
yy534:
	YYDEBUG(534, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	const char *func_name = NULL;

	if (CG(active_op_array)) {
		func_name = CG(active_op_array)->function_name;
	}

	if (!func_name) {
		func_name = "";
	}
	zendlval->value.str.len = strlen(func_name);
	zendlval->value.str.val = estrndup(func_name, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_FUNC_C;
}
yy535:
	YYDEBUG(535, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '_') goto yy539;
	goto yy30;
yy536:
	YYDEBUG(536, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy540;
	goto yy30;
yy537:
	YYDEBUG(537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_INCLUDE_ONCE;
}
yy538:
	YYDEBUG(538, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_REQUIRE_ONCE;
}
yy539:
	YYDEBUG(539, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(current_namespace)) {
		*zendlval = *CG(current_namespace);
		zval_copy_ctor(zendlval);
	} else {
		ZVAL_EMPTY_STRING(zendlval);
	}
	return T_NS_C;
}
yy540:
	YYDEBUG(540, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'e') goto yy30;
	yych = *++YYCURSOR;
	if (yych != 'r') goto yy30;
	yych = *++YYCURSOR;
	if (yybm_ST_IN_SCRIPTING[0+yych] & 16) {
		goto yy29;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_HALT_COMPILER;
}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	YYDEBUG(541, *YYCURSOR);
	YYFILL(2);
	yych = *YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542,
			&&yy542, &&yy544, &&yy544, &&yy542, &&yy542, &&yy544, &&yy542, &&yy542,
			&&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542,
			&&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542,
			&&yy544, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542,
			&&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy545, &&yy542, &&yy542,
			&&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542,
			&&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542, &&yy542,
			&&yy542, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy542, &&yy542, &&yy542, &&yy542, &&yy546,
			&&yy542, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy542, &&yy542, &&yy542, &&yy542, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546,
			&&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546, &&yy546
		};
		goto *yytarget[yych];
	}
yy542:
	YYDEBUG(542, *YYCURSOR);
	++YYCURSOR;
yy543:
	YYDEBUG(543, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	goto restart;
}
yy544:
	YYDEBUG(544, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_ST_LOOKING_FOR_PROPERTY[0+yych] & 64) {
		goto yy544;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
yy545:
	YYDEBUG(545, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '>') goto yy547;
	goto yy543;
yy546:
	YYDEBUG(546, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_ST_LOOKING_FOR_PROPERTY[0+yych] & 128) {
		goto yy546;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yy_pop_state(TSRMLS_C);
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
yy547:
	YYDEBUG(547, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return T_OBJECT_OPERATOR;
}
/* *********************************** */
yyc_ST_BACKQUOTE:
	YYDEBUG(548, *YYCURSOR);
	YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= '_') {
		if (yych == '$') goto yy550;
	} else {
		if (yych <= '`') goto yy551;
		if (yych == '{') goto yy552;
	}
	++YYCURSOR;
yy549:
	YYDEBUG(549, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '`' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy550:
	YYDEBUG(550, *YYCURSOR);
	yych = *++YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549,
			&&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549,
			&&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549,
			&&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549,
			&&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549,
			&&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549,
			&&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549,
			&&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549, &&yy549,
			&&yy549, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy549, &&yy549, &&yy549, &&yy549, &&yy553,
			&&yy549, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy555, &&yy549, &&yy549, &&yy549, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553,
			&&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553, &&yy553
		};
		goto *yytarget[yych];
	}
yy551:
	YYDEBUG(551, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_IN_SCRIPTING);
	return '`';
}
yy552:
	YYDEBUG(552, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '$') goto yy556;
	goto yy549;
yy553:
	YYDEBUG(553, *YYCURSOR);
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yybm_ST_BACKQUOTE[0+yych] & 128) {
		goto yy553;
	}
	if (yych == '-') goto yy557;
	if (yych <= '@') goto yy554;
	if (yych <= '[') goto yy559;
yy554:
	YYDEBUG(554, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy555:
	YYDEBUG(555, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy556:
	YYDEBUG(556, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
yy557:
	YYDEBUG(557, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '>') goto yy560;
yy558:
	YYDEBUG(558, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy554;
yy559:
	YYDEBUG(559, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '_') {
		if (yych <= '@') goto yy558;
		if (yych <= 'Z') goto yy561;
		if (yych <= '^') goto yy558;
	} else {
		if (yych <= '`') goto yy558;
		if (yych <= 'z') goto yy561;
		if (yych <= '~') goto yy558;
	}
yy561:
	YYDEBUG(561, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	YYDEBUG(562, *YYCURSOR);
	YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= '#') {
		if (yych == '"') goto yy564;
	} else {
		if (yych <= '$') goto yy565;
		if (yych == '{') goto yy566;
	}
	++YYCURSOR;
yy563:
	YYDEBUG(563, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '"' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy564:
	YYDEBUG(564, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_IN_SCRIPTING);
	return '"';
}
yy565:
	YYDEBUG(565, *YYCURSOR);
	yych = *++YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563,
			&&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563,
			&&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563,
			&&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563,
			&&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563,
			&&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563,
			&&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563,
			&&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563, &&yy563,
			&&yy563, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy563, &&yy563, &&yy563, &&yy563, &&yy567,
			&&yy563, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy569, &&yy563, &&yy563, &&yy563, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
			&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567
		};
		goto *yytarget[yych];
	}
yy566:
	YYDEBUG(566, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '$') goto yy570;
	goto yy563;
yy567:
	YYDEBUG(567, *YYCURSOR);
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yybm_ST_DOUBLE_QUOTES[0+yych] & 128) {
		goto yy567;
	}
	if (yych == '-') goto yy571;
	if (yych <= '@') goto yy568;
	if (yych <= '[') goto yy573;
yy568:
	YYDEBUG(568, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy569:
	YYDEBUG(569, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy570:
	YYDEBUG(570, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
yy571:
	YYDEBUG(571, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '>') goto yy574;
yy572:
	YYDEBUG(572, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy568;
yy573:
	YYDEBUG(573, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '_') {
		if (yych <= '@') goto yy572;
		if (yych <= 'Z') goto yy575;
		if (yych <= '^') goto yy572;
	} else {
		if (yych <= '`') goto yy572;
		if (yych <= 'z') goto yy575;
		if (yych <= '~') goto yy572;
	}
yy575:
	YYDEBUG(575, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
/* *********************************** */
yyc_ST_HEREDOC:
	YYDEBUG(576, *YYCURSOR);
	YYFILL(2);
	yych = *YYCURSOR;
	if (yych == '$') goto yy578;
	if (yych == '{') goto yy579;
	++YYCURSOR;
yy577:
	YYDEBUG(577, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto heredoc_scan_done;
					}
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng - newline, 0 TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy578:
	YYDEBUG(578, *YYCURSOR);
	yych = *++YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
			&&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
			&&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
			&&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
			&&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
			&&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
			&&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
			&&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
			&&yy577, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy577, &&yy577, &&yy577, &&yy577, &&yy580,
			&&yy577, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy582, &&yy577, &&yy577, &&yy577, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580,
			&&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580, &&yy580
		};
		goto *yytarget[yych];
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '$') goto yy583;
	goto yy577;
yy580:
	YYDEBUG(580, *YYCURSOR);
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yybm_ST_HEREDOC[0+yych] & 128) {
		goto yy580;
	}
	if (yych == '-') goto yy584;
	if (yych <= '@') goto yy581;
	if (yych <= '[') goto yy586;
yy581:
	YYDEBUG(581, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy582:
	YYDEBUG(582, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy583:
	YYDEBUG(583, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
yy584:
	YYDEBUG(584, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '>') goto yy587;
yy585:
	YYDEBUG(585, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy581;
yy586:
	YYDEBUG(586, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '_') {
		if (yych <= '@') goto yy585;
		if (yych <= 'Z') goto yy588;
		if (yych <= '^') goto yy585;
	} else {
		if (yych <= '`') goto yy585;
		if (yych <= 'z') goto yy588;
		if (yych <= '~') goto yy585;
	}
yy588:
	YYDEBUG(588, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	YYDEBUG(589, *YYCURSOR);
	YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= '_') {
		if (yych <= '@') goto yy590;
		if (yych <= 'Z') goto yy592;
		if (yych >= '_') goto yy592;
	} else {
		if (yych <= '`') goto yy590;
		if (yych <= 'z') goto yy592;
		if (yych >= 0x7F) goto yy592;
	}
yy590:
	YYDEBUG(590, *YYCURSOR);
	++YYCURSOR;
yy591:
	YYDEBUG(591, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	goto restart;
}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	{
		static void *yytarget[256] = {
			&&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591,
			&&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591,
			&&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591,
			&&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591,
			&&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591,
			&&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591, &&yy591,
			&&yy591, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy591, &&yy591, &&yy591, &&yy594,
			&&yy591, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy591, &&yy591, &&yy594, &&yy591, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594,
			&&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594, &&yy594
		};
		goto *yytarget[yych];
	}
yy593:
	YYDEBUG(593, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
yy594:
	YYDEBUG(594, *YYCURSOR);
	if (yybm_ST_LOOKING_FOR_VARNAME[0+yych] & 128) {
		goto yy593;
	}
	if (yych <= '@') goto yy595;
	if (yych <= '[') goto yy596;
	if (yych == '}') goto yy596;
yy595:
	YYDEBUG(595, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy591;
yy596:
	YYDEBUG(596, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yyless(yyleng - 1);
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return T_STRING_VARNAME;
}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	YYDEBUG(597, *YYCURSOR);
	YYFILL(3);
	yych = *YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy598, &&yy598, &&yy598, &&yy598, &&yy598, &&yy598, &&yy598, &&yy598,
			&&yy598, &&yy599, &&yy599, &&yy598, &&yy598, &&yy599, &&yy598, &&yy598,
			&&yy598, &&yy598, &&yy598, &&yy598, &&yy598, &&yy598, &&yy598, &&yy598,
			&&yy598, &&yy598, &&yy598, &&yy598, &&yy598, &&yy598, &&yy598, &&yy598,
			&&yy599, &&yy600, &&yy600, &&yy599, &&yy602, &&yy600, &&yy600, &&yy599,
			&&yy600, &&yy600, &&yy600, &&yy600, &&yy600, &&yy600, &&yy600, &&yy600,
			&&yy603, &&yy605, &&yy605, &&yy605, &&yy605, &&yy605, &&yy605, &&yy605,
			&&yy605, &&yy605, &&yy600, &&yy600, &&yy600, &&yy600, &&yy600, &&yy600,
			&&yy600, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy600, &&yy599, &&yy607, &&yy600, &&yy606,
			&&yy600, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy600, &&yy600, &&yy600, &&yy600, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606,
			&&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606, &&yy606
		};
		goto *yytarget[yych];
	}
yy598:
	YYDEBUG(598, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy599:
	YYDEBUG(599, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state(TSRMLS_C);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy600:
	YYDEBUG(600, *YYCURSOR);
	++YYCURSOR;
yy601:
	YYDEBUG(601, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	/* Only '[' can be valid, but returning other tokens will allow a more explicit parse error */
	return yytext[0];
}
yy602:
	YYDEBUG(602, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '_') {
		if (yych <= '@') goto yy601;
		if (yych <= 'Z') goto yy608;
		if (yych <= '^') goto yy601;
		goto yy608;
	} else {
		if (yych <= '`') goto yy601;
		if (yych <= 'z') goto yy608;
		if (yych <= '~') goto yy601;
		goto yy608;
	}
yy603:
	YYDEBUG(603, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= '/') goto yy604;
		if (yych <= '9') goto yy610;
	} else {
		if (yych <= 'b') goto yy612;
		if (yych == 'x') goto yy614;
	}
yy604:
	YYDEBUG(604, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		zendlval->value.lval = strtol(yytext, NULL, 10);
		zendlval->type = IS_LONG;
	} else {
		zendlval->value.str.val = (char *)estrndup(yytext, yyleng);
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
	}
	return T_NUM_STRING;
}
yy605:
	YYDEBUG(605, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_ST_VAR_OFFSET[0+yych] & 16) {
		goto yy605;
	}
	goto yy604;
yy606:
	YYDEBUG(606, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_ST_VAR_OFFSET[0+yych] & 32) {
		goto yy606;
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
yy607:
	YYDEBUG(607, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	yy_pop_state(TSRMLS_C);
	return ']';
}
yy608:
	YYDEBUG(608, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609,
			&&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609,
			&&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609,
			&&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609,
			&&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609,
			&&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609, &&yy609,
			&&yy609, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy609, &&yy609, &&yy609, &&yy609, &&yy608,
			&&yy609, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy609, &&yy609, &&yy609, &&yy609, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
			&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608
		};
		goto *yytarget[yych];
	}
yy609:
	YYDEBUG(609, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy610:
	YYDEBUG(610, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy611;
	if (yych <= '9') goto yy610;
yy611:
	YYDEBUG(611, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{ /* Offset must be treated as a string */
	zendlval->value.str.val = (char *)estrndup(yytext, yyleng);
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	return T_NUM_STRING;
}
yy612:
	YYDEBUG(612, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_VAR_OFFSET[0+yych] & 64) {
		goto yy615;
	}
yy613:
	YYDEBUG(613, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy604;
yy614:
	YYDEBUG(614, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_ST_VAR_OFFSET[0+yych] & 128) {
		goto yy616;
	}
	goto yy613;
yy615:
	YYDEBUG(615, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_ST_VAR_OFFSET[0+yych] & 64) {
		goto yy615;
	}
	goto yy611;
yy616:
	YYDEBUG(616, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_ST_VAR_OFFSET[0+yych] & 128) {
		goto yy616;
	}
	goto yy611;
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(617, *YYCURSOR);
	YYFILL(8);
	yych = *YYCURSOR;
	if (yych == '<') goto yy619;
	++YYCURSOR;
yy618:
	YYDEBUG(618, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR < YYLIMIT) {
			switch (*YYCURSOR) {
				case '?':
					if (CG(short_tags) || !strncasecmp((char*)YYCURSOR + 1, "php", 3) || (*(YYCURSOR + 1) == '=')) { /* Assume [ \t\n\r] follows "php" */
						break;
					}
					continue;
				case '%':
					if (CG(asp_tags)) {
						break;
					}
					continue;
				case 's':
				case 'S':
					/* Probably NOT an opening PHP <script> tag, so don't end the HTML chunk yet
					 * If it is, the PHP <script> tag rule checks for any HTML scanned before it */
					YYCURSOR--;
					yymore();
				default:
					continue;
			}

			YYCURSOR--;
		}

		break;
	}

inline_html:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		int readsize;
		size_t sz = 0;
		readsize = SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC);
		zendlval->value.str.len = sz;
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else {
	  zendlval->value.str.val = (char *) estrndup(yytext, yyleng);
	  zendlval->value.str.len = yyleng;
	}
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_INLINE_HTML;
}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '>') {
		if (yych != '%') goto yy618;
	} else {
		if (yych <= '?') goto yy620;
		if (yych == 's') goto yy622;
		goto yy618;
	}
	yych = *++YYCURSOR;
	if (yych == '=') goto yy624;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(asp_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
yy620:
	YYDEBUG(620, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '=') goto yy625;
	if (yych == 'p') goto yy626;
yy621:
	YYDEBUG(621, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(short_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
yy622:
	YYDEBUG(622, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy627;
yy623:
	YYDEBUG(623, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept == 0) {
		goto yy618;
	} else {
		goto yy621;
	}
yy624:
	YYDEBUG(624, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(asp_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG_WITH_ECHO;
	} else {
		goto inline_char_handler;
	}
}
yy625:
	YYDEBUG(625, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG_WITH_ECHO;
}
yy626:
	YYDEBUG(626, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy628;
	goto yy623;
yy627:
	YYDEBUG(627, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy629;
	goto yy623;
yy628:
	YYDEBUG(628, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy630;
	goto yy623;
yy629:
	YYDEBUG(629, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy631;
	goto yy623;
yy630:
	YYDEBUG(630, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy623;
		if (yych <= '\n') goto yy632;
		goto yy623;
	} else {
		if (yych <= '\r') goto yy634;
		if (yych == ' ') goto yy632;
		goto yy623;
	}
yy631:
	YYDEBUG(631, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy635;
	goto yy623;
yy632:
	YYDEBUG(632, *YYCURSOR);
	++YYCURSOR;
yy633:
	YYDEBUG(633, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
yy634:
	YYDEBUG(634, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy632;
	goto yy633;
yy635:
	YYDEBUG(635, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 't') goto yy623;
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy623;
	goto yy637;
yy636:
	YYDEBUG(636, *YYCURSOR);
	++YYCURSOR;
	YYFILL(8);
	yych = *YYCURSOR;
yy637:
	YYDEBUG(637, *YYCURSOR);
	if (yybm_INITIAL[0+yych] & 128) {
		goto yy636;
	}
	if (yych != 'l') goto yy623;
	yych = *++YYCURSOR;
	if (yych != 'a') goto yy623;
	yych = *++YYCURSOR;
	if (yych != 'n') goto yy623;
	yych = *++YYCURSOR;
	if (yych != 'g') goto yy623;
	yych = *++YYCURSOR;
	if (yych != 'u') goto yy623;
	yych = *++YYCURSOR;
	if (yych != 'a') goto yy623;
	yych = *++YYCURSOR;
	if (yych != 'g') goto yy623;
	yych = *++YYCURSOR;
	if (yych != 'e') goto yy623;
yy638:
	YYDEBUG(638, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy638, &&yy638, &&yy623, &&yy623, &&yy638, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy638, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy639, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623
		};
		goto *yytarget[yych];
	}
yy639:
	YYDEBUG(639, *YYCURSOR);
	++YYCURSOR;
	YYFILL(5);
	yych = *YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy639, &&yy639, &&yy623, &&yy623, &&yy639, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy639, &&yy623, &&yy640, &&yy623, &&yy623, &&yy623, &&yy623, &&yy641,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy642, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623
		};
		goto *yytarget[yych];
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy643;
	goto yy623;
yy641:
	YYDEBUG(641, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy644;
	goto yy623;
yy642:
	YYDEBUG(642, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy645;
	goto yy623;
yy643:
	YYDEBUG(643, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy646;
	goto yy623;
yy644:
	YYDEBUG(644, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy647;
	goto yy623;
yy645:
	YYDEBUG(645, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy648;
	goto yy623;
yy646:
	YYDEBUG(646, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy649;
	goto yy623;
yy647:
	YYDEBUG(647, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy650;
	goto yy623;
yy648:
	YYDEBUG(648, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy648, &&yy648, &&yy623, &&yy623, &&yy648, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy648, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy651, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623,
			&&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623, &&yy623
		};
		goto *yytarget[yych];
	}
yy649:
	YYDEBUG(649, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '"') goto yy648;
	goto yy623;
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\'') goto yy648;
	goto yy623;
yy651:
	YYDEBUG(651, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	YYCTYPE *bracket = (YYCTYPE*)zend_memrchr(yytext, '<', yyleng - (sizeof("script language=php>") - 1));

	if (bracket != SCNG(yy_text)) {
		/* Handle previously scanned HTML, as possible <script> tags found are assumed to not be PHP's */
		YYCURSOR = bracket;
		goto inline_html;
	}

	HANDLE_NEWLINES(yytext, yyleng);
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(652, *YYCURSOR);
	YYFILL(1);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	YYCURSOR += heredoc_label->length - 1;
	yyleng = heredoc_label->length;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	return T_END_HEREDOC;
}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(653, *YYCURSOR);
	YYFILL(1);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto nowdoc_scan_done;
					}
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_copy_value(zendlval, yytext, yyleng - newline);
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng - newline);
	return T_ENCAPSED_AND_WHITESPACE;
}
}

}
real_world/php20140822_zend_language_scanner.re:1017:12: warning: escape has no effect: '\[' [-Wuseless-escape]
real_world/php20140822_zend_language_scanner.re:1007:0: warning: condition numbers may change, use '/*!conditions:re2c*/' directive to generate reliable condition identifiers [-Wcondition-order]
